

        .extern __runtime_division_by_zero
        .extern __aeabi_ldivmod
        .extern __aeabi_uldivmod
        .section .text.libc

    .if @BIGENDIAN()
        .define hi1     'r0'
        .define lo1     'r1'
        .define hi2     'r2'
        .define lo2     'r3'
    .else
        .define hi1     'r1'
        .define lo1     'r0'
        .define hi2     'r3'
        .define lo2     'r2'
    .endif
        
    .if @thumb()
        .thumb
    .else
        .arm
    .endif
        
        .global __TASKING_ldivmod0
__TASKING_ldivmod0:     .type func
        cmp     lo2,#0
        bne     nonzero
        cmp     hi2,#0
        ; this will do an abort()
        beq     __runtime_division_by_zero
nonzero:
        str     lr, [sp,#-4]!
        bl      __aeabi_ldivmod
        ldr     lr, [sp], #4

        bx      lr
        .size   __TASKING_ldivmod0,$-__TASKING_ldivmod0
        
        .global __TASKING_uldivmod0
__TASKING_uldivmod0:    .type func
        cmp     lo2,#0
        bne     unonzero
        cmp     hi2,#0
        ; this will do an abort()
        beq     __runtime_division_by_zero
unonzero:
        str     lr, [sp,#-4]!
        bl      __aeabi_uldivmod
        ldr     lr, [sp], #4

        bx      lr
        .size   __TASKING_uldivmod0,$-__TASKING_uldivmod0
        
        .endsec

        .calls  '__TASKING_ldivmod0','__runtime_division_by_zero'
        .calls  '__TASKING_ldivmod0','__aeabi_ldivmod'
        .calls  '__TASKING_ldivmod0','',4
        .calls  '__TASKING_uldivmod0','__runtime_division_by_zero'
        .calls  '__TASKING_uldivmod0','__aeabi_uldivmod'
        .calls  '__TASKING_uldivmod0','',4

        .end
