
/**************************************************************************
**                                                                        *
**  FILE        :  div64.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for __aeabi_ldivmod() and                  *
**                 __aeabi_uldivmod().                                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

struct sdivmod_t {
        signed long long quotient;
        signed long long remainder;
};

struct udivmod_t {
        unsigned long long quotient;
        unsigned long long remainder;
};

struct udivmod_t        __return_in_regs __aeabi_uldivmod( unsigned long long dividend, unsigned long long divisor )
{
        unsigned int            count;
        unsigned long long      factor    = 0x1;
        unsigned long long      remainder = dividend;
        unsigned long long      quotient  = 0;
        struct udivmod_t        ret;
        
        /* strip leading zeros, while divisor is still smaller than dividend */
        /* count starts at 1 because we count back one step further than we count up */
        for     ( count = 1; divisor < dividend && count < 65 && (signed long)(divisor >> 32) >= 0; count++ )
        {
                divisor <<= 1;
                factor  <<= 1;
        }

        /* substract ever smaller multiples of divisor, until factor is 0 */
        do
        {
                if( remainder >= divisor )
                {
                        remainder -= divisor;
                        quotient  |= factor;
                }
                
                divisor >>= 1;
                factor  >>= 1;
        } while (--count);

        ret.quotient = quotient;
        ret.remainder = remainder;

        return ret;
}

struct sdivmod_t        __return_in_regs __aeabi_ldivmod( long long dividend, long long divisor )
{
        unsigned int            divsign = (unsigned int)(dividend>>32) ^ (unsigned int)(divisor>>32);
        unsigned int            modsign = (signed long)((unsigned long long)dividend>>32) < 0;
        struct udivmod_t        uret;
        struct sdivmod_t        ret;
        
        if( (signed long)((unsigned long long)dividend>>32) < 0 ) dividend = -dividend;
        if( (signed long)((unsigned long long)divisor>>32) < 0  ) divisor  = -divisor;

        uret = __aeabi_uldivmod( (unsigned long long)dividend, (unsigned long long)divisor );

        if( modsign ) 
        {
                ret.remainder = -(signed long long)uret.remainder;
        }
        else
        {
                ret.remainder = uret.remainder;
        }
        if( divsign & 0x80000000 ) 
        {
                ret.quotient = -(signed long long)uret.quotient;
        }
        else
        {
                ret.quotient = uret.quotient;
        }

        return ret;
}

