

        .extern __aeabi_ldiv0
        .section .text.libc

    .if @BIGENDIAN()
        .define hi1     'r0'
        .define lo1     'r1'
        .define hi2     'r2'
        .define lo2     'r3'
    .else
        .define hi1     'r1'
        .define lo1     'r0'
        .define hi2     'r3'
        .define lo2     'r2'
    .endif
        
        .code32
        
        .global __aeabi_ldivmod
__aeabi_ldivmod:        .type func
        ; check for division by zero
        cmp     lo2,#0
        bne     unonzero
        cmp     hi2,#0
        beq     divide_by_zero
        
unonzero:
        stmfd   sp!,{r4,r5,r6,r7,lr}
        
        ands    r4,hi2,#0x80000000
        bpl     pos1
        rsbs    lo2,lo2,#0
        rsc     hi2,hi2,#0
pos1:   
        eors    ip,r4,hi1,asr #32
        bcc     pos2
        rsbs    lo1,lo1,#0
        rsc     hi1,hi1,#0
pos2:   
                
        bl      common_ldivmod  ; for size considerations

        movs    ip,ip,lsl #1
        bcc     pos3
        rsbs    lo1,lo1,#0
        rsc     hi1,hi1,#0
pos3:
        cmp     ip,#0
        bge     pos4
        rsbs    lo2,lo2,#0
        rsc     hi2,hi2,#0
pos4:   
                
        ldmfd   sp!,{r4,r5,r6,r7,lr}
        bx      lr
        
divide_by_zero:
        cmp     hi1,#0
        bgt     posdivzero
        blt     negdivzero
        
        cmp     lo1,#0
        beq     numerator_set
        bgt     posdivzero

negdivzero:
        ldr     hi1,=0x80000000
        ldr     lo1,=0x00000000
        b       numerator_set

posdivzero:
        ldr     hi1,=0x7fffffff
        ldr     lo1,=0xffffffff
        
numerator_set:
        stmfd   sp!,{lr}
        bl      __aeabi_ldiv0
        ldmfd   sp!,{lr}
        bx      lr
        .size   __aeabi_ldivmod,$-__aeabi_ldivmod

        .global __aeabi_uldivmod
__aeabi_uldivmod:       .type func
        ; check for division by zero
        cmp     lo2,#0
        bne     common_ldivmod
        cmp     hi2,#0
        bne     common_ldivmod
        
udivide_by_zero:
        cmp     hi1,#0
        bhi     u_posdivzero
        cmp     lo1,#0
        beq     u_numerator_set
u_posdivzero:
        ldr     hi1,=0xffffffff
        mov     lo1,#0

u_numerator_set:
        stmfd   sp!,{lr}
        bl      __aeabi_ldiv0
        ldmfd   sp!,{lr}
        bx      lr
        .size   __aeabi_uldivmod,$-__aeabi_uldivmod

; common code (unsigned division)
common_ldivmod: .type func
        stmfd   sp!,{r4,r5,r6,r7}

        mov     r6,lo2
        mov     r7,hi2

        mov     r4,lo1,lsr #1
        orr     r4,r4,hi1,lsl #31
        mov     r5,hi1,lsr #1
u_just_l:
        cmp     r7,r5
        cmpeq   r6,r4
        movls   r7,r7,lsl #1
        orrls   r7,r7,r6,lsr #31
        movls   r6,r6,lsl #1
        blo     u_just_l

        mov     r4,#0
        mov     r5,#0
u_div_l:        
        cmp     hi1,r7
        cmpeq   lo1,r6
        bcs     carry_set
        adds    r4,r4,r4
        adc     r5,r5,r5
        b       l_1
carry_set:
        adcs    r4,r4,r4
        adc     r5,r5,r5
        subs    lo1,lo1,r6
        sbc     hi1,hi1,r7
l_1:
        teq     r7,hi2
        teqeq   r6,lo2
        movne   r6,r6,lsr #1
        orrne   r6,r6,r7,lsl #31
        movne   r7,r7,lsr #1

        bne     u_div_l
                
        mov     lo2,lo1
        mov     hi2,hi1
        mov     lo1,r4
        mov     hi1,r5
        
        ldmfd   sp!,{r4,r5,r6,r7}
        bx      lr
        .size   common_ldivmod,$-common_ldivmod

        .endsec

        .calls  '__aeabi_ldivmod','__aeabi_ldiv0'
        .calls  '__aeabi_ldivmod','',20
        .calls  '__aeabi_uldivmod','__aeabi_ldiv0'
        .calls  '__aeabi_uldivmod','',16

        .end
