

        .extern __aeabi_idiv0
        .section .text.libc

        .thumb
        
        .global __aeabi_idivmod
        .global __aeabi_idiv
__aeabi_idivmod:        .type func
__aeabi_idiv:
        ; Signed divide of R0 by R1: returns quotient in R0, 
        ; remainder in R1
        
        ; Get abs value of R1 into R3 
        asrs    r2,r1,#31       ; Get 0 or -1 in R2 depending on sign of R1
        eors    r1,r1,r2        ; EOR with -1 (0xFFFFFFFF) if negative 
        subs    r3,r1,r2        ; and ADD 1 (SUB -1) to get abs value 
        
        ; SUB always sets flag so go & report division by 0 if necessary 
        beq     divide_by_zero 
        
        ; Get abs value of R0 by xoring with 0xFFFFFFFF and adding 1 
        ; if negative
        movs    r1,r0
        asrs    r0,r1,#31       ; Get 0 or -1 in R3 depending on sign of R1 
        eors    r1,r1,r0        ; EOR with -1 (0xFFFFFFFF) if negative 
        subs    r1,r1,r0        ; and ADD 1 (SUB -1) to get abs value 
        
        ; Save signs (0 or -1 in R0 & R2) for later use in determining 
        ; sign of quotient & remainder. 
        
        push    {r0,r2} 
        
        ; Justification, shift 1 bit at a time until divisor (R0 value) 
        ; is just <= than dividend (R1 value). To do this shift dividend 
        ; right by 1 and stop as soon as shifted value becomes >. 
        lsrs    r0,r1,#1 
        movs    r2,r3 
        b       lab1
        
just_l: lsls    r2,r2,#1 
lab1:   cmp     r2,r0 
        bls     just_l 
        
        movs    r0,#0           ; Set accumulator to 0 
        b       lab2            ; Branch into division loop 
        
div_l:  lsrs    r2,r2,#1 
lab2:   cmp     r1,r2           ; Test subtract
        bcc     lab3
        
        subs    r1,r1,r2        ; If successful do a real 
                                ; subtract

lab3:   adcs    r0,r0,r0        ; Shift result and add 1 if 
                                ; subtract succeeded 
        
        cmp     r2,r3           ; Terminate when R2 == R3 (ie we have just 
        bne     div_l           ; tested subtracting the 'ones' value). 
        
        ; Now fixup the signs of the quotient (R0) and remainder (R1) 
        pop     {r2,r3}         ; Get dividend/divisor signs back 
        eors    r3,r3,r2        ; Result sign 
        eors    r0,r0,r3        ; Negate if result sign = -1 
        subs    r0,r0,r3
        
        eors    r1,r1,r2        ; Negate remainder if dividend sign = -1 
        subs    r1,r1,r2
        
        bx      lr
        
divide_by_zero:
        cmp     r0,#0
        beq     numerator_set
        bpl     posdivzero
        
        ldr     r0,=0x7fffffff
        b       numerator_set
        
posdivzero:
        ldr     r0,=0x80000000

numerator_set:
        push    {lr}
        bl      __aeabi_idiv0
        movs    r1,#0
        pop     {pc}
        .size   __aeabi_idivmod,$-__aeabi_idivmod
        
        .global __aeabi_uidivmod
        .global __aeabi_uidiv
__aeabi_uidivmod:       .type func
__aeabi_uidiv:
        ; Unigned divide of R0 by R1: returns quotient in R0, 
        ; remainder in R1

        movs    r3,r1
        ; check for division by zero
        beq     udivide_by_zero
        
        movs    r1,r0   
        ; Justification, shift 1 bit at a time until divisor (R1 value) 
        ; is just <= than dividend (R0 value). To do this shift dividend 
        ; right by 1 and stop as soon as shifted value becomes >. 
        lsrs    r0,r1,#1 
        movs    r2,r3 
        b       u_lab1
        
u_just_l:       
        lsls    r2,r2,#1 
u_lab1: cmp     r2,r0 
        bls     u_just_l 
        
        movs    r0,#0           ; Set accumulator to 0 
        b       u_lab2          ; Branch into division loop 
        
u_div_l:        
        lsrs    r2,r2,#1 
u_lab2: cmp     r1,r2           ; Test subtract
        bcc     u_lab3
        
        subs    r1,r1,r2        ; If successful do a real 
                                ; subtract

u_lab3: adcs    r0,r0,r0        ; Shift result and add 1 if 
                                ; subtract succeeded 
        
        cmp     r2,r3           ; Terminate when R2 == R3 (ie we have just 
        bne     u_div_l         ; tested subtracting the 'ones' value). 
        
        bx      lr
        
udivide_by_zero:
        cmp     r0,#0
        beq     u_numerator_set
        ldr     r0,=0xffffffff

u_numerator_set:
        push    {lr}
        bl      __aeabi_idiv0
        movs    r1,#0
        pop     {pc}
        .size   __aeabi_uidivmod,$-__aeabi_uidivmod

        .endsec

        .calls  '__aeabi_idivmod','__aeabi_idiv0'
        .calls  '__aeabi_idivmod','',8
        .calls  '__aeabi_uidivmod','__aeabi_idiv0'
        .calls  '__aeabi_uidivmod','',4

        .end
