

        .extern __aeabi_idiv0
        .section .text.librt

        .code32
        
        .global __aeabi_idivmod
        .global __aeabi_idiv
__aeabi_idivmod:        .type func
__aeabi_idiv:
        
        ; effectively zero r3 as top bit will be shifted out later 
        ands    r3,r1,#0x80000000 
        rsbmi   r1,r1,#0 
        
        ; central part is identical code to udiv 
        ; (without mov r3, #0 which comes for free as part of signed 
        ; entry sequence) 
        movs    r2,r1 
        beq     divide_by_zero
        
        eors    ip,r3,r0, asr #32 
        
        ; ip bit 31 = sign of result 
        ; ip bit 30 = sign of r1 
        rsbcs   r0,r0,#0 
        
just_l: 
        ; justification stage shifts 1 bit at a time 
        cmp     r2,r0,lsr #1 
        movls   r2,r2,lsl #1 
        ; NB: LSL #1 is always OK if LS succeeds 
        blo     just_l
        
div_l:  
        cmp     r0,r2 
        adc     r3,r3,r3 
        subcs   r0,r0,r2
        
        teq     r2,r1 
        movne   r2,r2,lsr #1

        bne     div_l
        mov     r1,r0
        mov     r0,r3
        
        movs    ip,ip,lsl #1 
        rsbcs   r0,r0,#0 
        rsbmi   r1,r1,#0
        
        bx      lr

divide_by_zero:
        cmp     r0,#0
        ldrgt   r0,=0x7fffffff
        ldrlt   r0,=0x80000000

        stmfd   sp!,{lr}
        bl      __aeabi_idiv0
        ldmfd   sp!,{lr}
        mov     r1,#0
        bx      lr
        .size   __aeabi_idivmod,$-__aeabi_idivmod

        .global __aeabi_uidivmod
        .global __aeabi_uidiv
__aeabi_uidivmod:       .type func
__aeabi_uidiv:

        mov     r3,#0   
        movs    r2,r1 
        beq     udivide_by_zero
        
u_just_l:       
        ; justification stage shifts 1 bit at a time 
        cmp     r2,r0,lsr #1 
        movls   r2,r2,lsl #1 
        ; NB: LSL #1 is always OK if LS succeeds 
        blo     u_just_l
        
u_div_l:        
        cmp     r0,r2 
        adc     r3,r3,r3 
        subcs   r0,r0,r2
        
        teq     r2,r1 
        movne   r2,r2,lsr #1

        bne     u_div_l
        mov     r1,r0
        mov     r0,r3
        
        bx      lr

udivide_by_zero:
        cmp     r0,#0
        ldrne   r0,#0xffffffff

        stmfd   sp!,{lr}
        bl      __aeabi_idiv0
        ldmfd   sp!,{lr}
        mov     r1,#0
        bx      lr
        .size   __aeabi_uidivmod,$-__aeabi_uidivmod

        .endsec

        .calls  '__aeabi_idivmod','__aeabi_idiv0'
        .calls  '__aeabi_idivmod','',4
        .calls  '__aeabi_uidivmod','__aeabi_idiv0'
        .calls  '__aeabi_uidivmod','',4

        .end
