
/**************************************************************************
**                                                                        *
**  FILE        :  csqrtg.c                                               *
**                                                                        *
**  DESCRIPTION :  The csqrt() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * csqrt(z)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
extern  long double complex             csqrtl(long double complex z)
{
        long double complex c;
        long double x,y,w,r;
        if ((__cld_r(z) == 0.0l) && (__cld_i(z) == 0.0l))
        {
                c = z;
        }
        else
        {
                x = fabsl(__cld_r(z));
                y = fabsl(__cld_i(z));
                if (x >= y)
                {
                        r = y/x;
                        w = sqrtl(x)*sqrtl(0.5l*(1.0l+sqrtl(1.0+r*r)));
                }
                else
                {
                        r = x/y;
                        w = sqrtl(y)*sqrtl(0.5l*(r+sqrtl(1.0l+r*r)));
                }
                if (__cld_r(z) >= 0.0l)
                {
                        __cld_r(c) = w;
                        __cld_i(c) = __cld_i(z)/(2.0l*w);
                }
                else
                {
                        __cld_i(c) = (__cld_i(z) >= 0.0l) ? w : -w;
                        __cld_r(c) = __cld_i(z)/(2.0l*__cld_i(c));
                }
        }
        return c;
}
