
/**************************************************************************
**                                                                        *
**  FILE        :  csing.c                                                *
**                                                                        *
**  DESCRIPTION :  The csin() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * csin(z)
 *
 *      = (exp(i*z)-exp(-i*z))/2i       calc
 *      = -i*csinh(i*z)                 ISO p.471
 */
extern  long double complex             csinl(long double complex z)
{
        return -__CLDI*csinhl(__CLDI*z);
}
