
/**************************************************************************
**                                                                        *
**  FILE        :  csinhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The csinh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * csinh(z)
 *
 *      = (exp(z)-exp(-z)/2     Edwards
 */
extern  double complex          csinh(double complex z)
{
        return (cexp(z)-cexp(-z))/2.0;
}
