
/**************************************************************************
**                                                                        *
**  FILE        :  cprojg.c                                               *
**                                                                        *
**  DESCRIPTION :  The cproj() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <float.h>
#include <math.h>
#include "fpbits.h"

/*
 * cproj(z)
 *
 * See ISO p.179.
 */
extern  float complex           cprojf(float complex z)
{
        if (isinf(__cf_r(z)) || isinf(__cf_i(z)))
        {
                float complex c;
                __cf_r(c) = __float_infinity;
                __cf_i(c) = copysignf(0.0f,__cf_i(z));
                return c;
        }
        else
        {
                return z;
        }
}
