
/**************************************************************************
**                                                                        *
**  FILE        :  cpowg.c                                                *
**                                                                        *
**  DESCRIPTION :  The cpow() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * cpow(x,y)
 *
 * Standard math.
 * See ISO p.177.
 * Should check branch cut.
 */
extern  float complex           cpowf(float complex x, float complex y)
{
        return cexpf(clogf(x)*y);
}
