
/**************************************************************************
**                                                                        *
**  FILE        :  cos.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for cos() routine                          *
**                 Computes the 'cosinus' for the given angle (in radians)*
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifndef __SINGLE_FP__
#pragma alias   cosl    = _cos_dpf
#pragma alias   cos             = _cos_dpf


extern double _sinus( double, int );

static
double
_cos_dpf( double arg )
{
        if( arg < 0.0 )
                arg = -arg;

        return( _sinus( arg, 1 ) );
}

#endif

