
/**************************************************************************
**                                                                        *
**  FILE        :  clogg.c                                                *
**                                                                        *
**  DESCRIPTION :  The clog() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * clog(z)
 *
 * clog(a+ib)   = log(a*a+b*b)/2+i*atan2(b,a)   calc
 *              = log(sqrt(a*a+b*b))+i*atan2(b,a)
 *              = log(abs(a+ib))+i*atan2(b,a)
 *
 * Use last rewrite as abs has a good algorithm from NR.
 */
extern  long double complex             clogl(long double complex z)
{
        long double complex c;
        __cld_r(c) = logl(cabsl(z));
        __cld_i(c) = atan2l(__cld_i(z),__cld_r(z));
        return c;
}
