
/**************************************************************************
**                                                                        *
**  FILE        :  clogg.c                                                *
**                                                                        *
**  DESCRIPTION :  The clog() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * clog(z)
 *
 * clog(a+ib)   = log(a*a+b*b)/2+i*atan2(b,a)   calc
 *              = log(sqrt(a*a+b*b))+i*atan2(b,a)
 *              = log(abs(a+ib))+i*atan2(b,a)
 *
 * Use last rewrite as abs has a good algorithm from NR.
 */
extern  double complex          clog(double complex z)
{
        double complex c;
        __cd_r(c) = log(cabs(z));
        __cd_i(c) = atan2(__cd_i(z),__cd_r(z));
        return c;
}
