
/**************************************************************************
**                                                                        *
**  FILE        :  cexpg.c                                                *
**                                                                        *
**  DESCRIPTION :  The cexp() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * cexp(z)
 *
 * cexp(a+ib)   = exp(a)*(cos(b)+i*sin(b))      calc
 */
extern  float complex           cexpf(float complex z)
{
        float complex c;
        float tmp;
        tmp = expf(__cf_r(z));
        __cf_r(c) = tmp*cosf(__cf_i(z));
        __cf_i(c) = tmp*sinf(__cf_i(z));
        return c;
}
