
/**************************************************************************
**                                                                        *
**  FILE        :  catang.c                                               *
**                                                                        *
**  DESCRIPTION :  The catan() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * catan(z)
 *
 * = i*clog((i+z)/(i-z))/2      mathwizards
 * = -i*catanh(i*z)             ISO p.471
 */
extern  double complex          catan(double complex z)
{
        return -__CDI*catanh(__CDI*z);
}
