
/********************************************************************
**
**  VERSION CONTROL:    @(#)cases8.c    1.1     07/09/04
**
**  IN PACKAGE:         
**
**  AUTHORS:            Frits Kuijlman          (frits)
**
**  COPYRIGHT:          Copyright 2007-2009 Altium BV
**
*********************************************************************/


/*
 * Binary search for sparse switch implementation.
 *
 * Derived from 68k assembly version.
 *
 * v : case value
 * high: number of cases
 * val : array of case values
 * label: array of label addresses, label[0] is default
 */

typedef         char    case_t;

void* __s8case( case_t v, int high, case_t *val, void **label )
{
        int low;
        int middle;

        if ( high <= 0 )
                return label[0];
        low = 0;
        while (1)
        {
                middle = (low+high)/2;
                if ( val[middle] == v )
                        return label[middle+1];
                if ( v < val[middle] )
                        low = middle+1;
                else
                        high=middle;
                if ( low > high )
                        return label[0];
        }
}

