
/**************************************************************************
**                                                                        *
**  FILE        :  bounds-malloc.c                                        *
**                                                                        *
**  DESCRIPTION :  Malloc wrappers for run-time bounds checking.          *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdlib.h>
#include "bounds.h"
#include "runtime-error.h"

#pragma runtime -malloc,-bounds

extern  void*   __bounds_malloc ( size_t size )
{
        void*   ptr;

        SAVE_CALLER;
        ptr = malloc( size );
        if      ( ptr )
        {
                __bounds_new( ptr, size );
        }
        CLEAR_CALLER;
        return ptr;
}

extern  void    __bounds_free   ( void* ptr )
{
        SAVE_CALLER;
        if      ( ptr )
        {
                __bounds_del( ptr );
        }
        free( ptr );
        CLEAR_CALLER;
}

extern  void*   __bounds_realloc( void* ptr, size_t size )
{
        SAVE_CALLER;
        if      ( ptr )
        {
                __bounds_del( ptr );
        }
        ptr = realloc( ptr, size );
        if      ( ptr )
        {
                __bounds_new( ptr, size );
        }
        CLEAR_CALLER;
        return ptr;
}

extern  void*   __bounds_calloc ( size_t nmemb, size_t size )
{
        void*   ptr;

        SAVE_CALLER;
        ptr = calloc( nmemb, size );
        if      ( ptr )
        {
                __bounds_new( ptr, nmemb * size );
        }
        CLEAR_CALLER;
        return ptr;
}
