
/**************************************************************************
**                                                                        *
**  FILE        :  bounds-error.c                                         *
**                                                                        *
**  DESCRIPTION :  Default error function for run-time bounds checking.   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "runtime-error.h"

#pragma runtime -bounds

extern  volatile char  __bounds_uninit;
#ifndef BOUNDS_STRICT
extern  volatile char  __bounds_illegal;
#endif

/*
 * This function is called from bounds.c to report an invalid or
 * out-of-bounds pointer in the user program.
 */
extern  void    __bounds_error ( int type, __bounds_t low, __bounds_t high,
                                 __bounds_t p1, __bounds_t p2 )
{
        static  char*   action[2] = { "comparing", "subtracting" };
        static  char    buf[100];
        char*           msg;

        msg = buf;
        switch  ( type )
        {
        case 1: /* invalid pointer update */
                if      ( low == (__bounds_t) 0 )
                {
                        msg = "arithmetic on null pointer";
                }
                else if ( low == (__bounds_t) & __bounds_uninit )
                {
                        msg = "arithmetic on uninitialized pointer";
                }
#ifndef BOUNDS_STRICT
                else if ( low == (__bounds_t) & __bounds_illegal )
                {
                        msg = "arithmetic on out-of-bounds pointer";
                }
#endif
                else
                {
                        snprintf( buf, sizeof(buf),
                                "pointer %08lx outside object [%08lx,%08lx]",
                                (long) p1, (long) low, (long) high );
                }
                break;
        case 2: /* access beyond end of object */
                if      ( low == (__bounds_t) 0 )
                {
                        msg = "dereferencing null pointer";
                }
                else if ( low == (__bounds_t) & __bounds_uninit )
                {
                        msg = "dereferencing uninitialized pointer";
                }
#ifndef BOUNDS_STRICT
                else if ( low == (__bounds_t) & __bounds_illegal )
                {
                        msg = "dereferencing out-of-bounds pointer";
                }
#endif
                else
                {
                        snprintf( buf, sizeof(buf),
                                "access beyond end of object [%08lx,%08lx]",
                                (long) low, (long) high );
                }
                break;
        case 3: /* comparing pointers to different objects */
        case 4: /* subtracting pointers to different objects */
                snprintf( buf, sizeof(buf),
                        "%s pointers to different objects (%08lx/%08lx)",
                        action[type-3], (long) p1, (long) p2 );
                break;
        }
        __runtime_error( msg );
}
