
/**************************************************************************
**                                                                        *
**  FILE        :  atan2.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for atan2() routine                        *
**                 Computes the 'arctangent' for the given value          *
**                 (return value in radians)                              *
**                 argument in the range [-pi,pi].                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#if 0


#define PIO2    1.570796326794896619231e0l
extern long double _atanl( long double );

static
long double
_atan2_qpf( long double arg1, long double arg2 )
{
        if( ( arg1 + arg2 ) == arg1 )
        {
                if( arg1 == 0.0l )
                        return( 0.0l );
                else if( arg1 > 0.0l )
                        return( PIO2 );
                else
                        return( -PIO2 );
        }
        else if( arg2 < 0.0l )
        {
                if( arg1 == 0.0l )
                        return( copysignl( PIO2 + PIO2, arg1 ) );
                else if( arg1 > 0.0l )
                        return( PIO2 + PIO2 - _atanl( -arg1 / arg2 ) );
                else
                        return( -PIO2 - PIO2 + _atanl( arg1 / arg2 ) );
        }
        else if( arg1 > 0.0l )
        {
                return( _atanl( arg1 / arg2 ) );
        }
        else
        {
                return( -_atanl( -arg1 / arg2 ) );
        }
}

#endif

