
/**************************************************************************
**                                                                        *
**  FILE        :  atan2.c                                                *
**                                                                        *
**  DESCRIPTION :  Source file for atan2() routine                        *
**                 Computes the 'arctangent' for the given value          *
**                 (return value in radians)                              *
**                 argument in the range [-pi,pi].                        *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   atan2l  = _atan2_spf
#pragma alias   atan2           = _atan2_spf
#endif
#pragma alias   atan2f  = _atan2_spf


#define PIO2    1.570796326794896619231e0f
extern float _atanf( float );

static
float
_atan2_spf( float arg1, float arg2 )
{
        if( ( arg1 + arg2 ) == arg1 )
        {
                if( arg1 == 0.0f )
                        return( 0.0f );
                else if( arg1 > 0.0f )
                        return( PIO2 );
                else
                        return( -PIO2 );
        }
        else if( arg2 < 0.0f )
        {
                if( arg1 == 0.0f )
                        return( copysignf( PIO2 + PIO2, arg1 ) );
                else if( arg1 > 0.0f )
                        return( PIO2 + PIO2 - _atanf( -arg1 / arg2 ) );
                else
                        return( -PIO2 - PIO2 + _atanf( arg1 / arg2 ) );
        }
        else if( arg1 > 0.0f )
        {
                return( _atanf( arg1 / arg2 ) );
        }
        else
        {
                return( -_atanf( -arg1 / arg2 ) );
        }
}


