
/**************************************************************************
**                                                                        *
**  FILE        :  asinhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The asinh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * asinh(x)
 *
 * Edwards
 * See calc for extra sign stuff.
 */
extern  float           asinhf(float x)
{
        int     is_neg;
        float   result;
        if (x == 0.0f || isinf(x))
        {
                return x;
        }
        is_neg = (x < 0.0f);
        if (is_neg)
        {
                x = -x;
        }
        result = logf(x+sqrtf(x*x+1.0f));
        if (is_neg)
        {
                result = -result;
        }
        return result;
}
