
/**************************************************************************
**                                                                        *
**  FILE        :  acoshg.c                                               *
**                                                                        *
**  DESCRIPTION :  The acosh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

/*
 * acosh(x)
 *
 * Edwards
 *
 * ISO F.9.2.1 defines exceptions. These should be handled here,
 * but for now we rely on sqrt to do the right thing.
 */
extern  long double             acoshl(long double x)
{
        if (x == 1.0l)
        {
                return 0.0l;
        }
#if 0
        if (x < 1.0l)
        {
                // return NaN and raise invalid FP exception.
        }
        if (isinf(x))
        {
                return x;
        }
#endif
        return logl(x+sqrtl(x*x-1.0l));
}
