
/**************************************************************************
**                                                                        *
**  FILE        :  acos.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for acos() routine                         *
**                 Computes the 'arccosinus' of the given value.          *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>
#include        <errno.h>

#ifndef __SINGLE_FP__
#pragma alias   acosl   = _acos_dpf
#pragma alias   acos            = _acos_dpf


#define PIO2    1.570796326794896619231e0

static
double
_acos_dpf( double arg )
{
        if( ( arg > 1.0 ) || ( arg < -1.0 ) )
        {
                errno = EDOM;
                return( 0.0 );
        }

        return( PIO2 - asin( arg ) );
}

#endif

