
/**************************************************************************
**                                                                        *
**  FILE        :  _wcsnccmp.c                                            *
**                                                                        *
**  DESCRIPTION :  Source file for _wcsncasecmp() routine                 *
**                 Compares two wide-character strings case insensitive.  *
**                 Returns : < 0  -- ws1<ws2                              *
**                           = 0  -- ws1=ws2                              *
**                           > 0  -- ws1>ws2                              *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

int
_wcsncasecmp( const wchar_t * ws1, const wchar_t * ws2, size_t n )
{
        wint_t wc1, wc2;

        while ( n-- )
        {
                wc2 = towupper(*ws2++);
                wc1 = towupper(*ws1++);

                if ( wc1 == L'\0' || wc1 != wc2 )
                {
                        return( (int)wc1 - (int)wc2 );
                }
        }

        return( 0 );
}

#endif
