
/**************************************************************************
**                                                                        *
**  FILE        :  _printflags.h                                          *
**                                                                        *
**  DESCRIPTION :  Predefined format flags used by the various printf()   *
**                 and scanf() support functions.                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#define FLG_LEFT_ALIGNMENT      ((unsigned short) 1 << 0)
#define FLG_ZERO_FILL           ((unsigned short) 1 << 1)
#define FLG_ALTERNATIVE_FORMAT  ((unsigned short) 1 << 2)
#define FLG_ALWAYS_SIGN         ((unsigned short) 1 << 3)
#define FLG_SIGN_OR_SPACE       ((unsigned short) 1 << 4)
#define FLG_MAX_LENGTH          ((unsigned short) 1 << 5)
#define FLG_SHORT               ((unsigned short) 1 << 6)
#define FLG_LONG                ((unsigned short) 1 << 7)
#define FLG_DOUBLE              ((unsigned short) 1 << 8)
#define FLG_INTMAX_T            ((unsigned short) 1 << 9)
#define FLG_SIZE_T              ((unsigned short) 1 << 10)
#define FLG_PTRDIFF_T           ((unsigned short) 1 << 11)
#define FLG_DOUBLE_LENGTH       ((unsigned short) 1 << 12)
#define FLG_LEFT_BRACKET        ((unsigned short) 1 << 13)
                                
                                
#define FLG_LONG_LONG           (FLG_LONG | FLG_DOUBLE_LENGTH)
#define FLG_SHORT_SHORT         (FLG_SHORT | FLG_DOUBLE_LENGTH)
                                
#define FLG_ALL_MODIFIERS       (FLG_SHORT | FLG_LONG | FLG_DOUBLE | \
                                 FLG_INTMAX_T | FLG_SIZE_T | FLG_PTRDIFF_T | \
                                 FLG_DOUBLE_LENGTH)

typedef unsigned short          format_value_type;
