
/**************************************************************************
**                                                                        *
**  FILE        :  _malloc.h                                              *
**                                                                        *
**  DESCRIPTION :  Internal definitions for malloc() and friends.         *
**                                                                        *
**                 Each block is preceded by an object of type msize_t    *
**                 which holds the size of the block (including the size  *
**                 of the header itself). This size is always a multiple  *
**                 of ALIGN, which is at least 2. As a result, the least  *
**                 significant bit can be used to mark allocated blocks.  *
**                 The heap is terminated by a zero size field.           *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef __MALLOC_H
#define __MALLOC_H

#include <stddef.h>

typedef unsigned long   msize_t;        /* malloc block size */
typedef char*           mptr_t;         /* malloc pointer type */

struct  align
{
        char    c;
        union
        {
                void*           p;
                long long       ll;
                double          d;
        }       u;
};

#define MINALIGN        ((int)offsetof(struct align, u))
#define ALIGN           (MINALIGN > 2 ? MINALIGN : 2)
#define ALIGNED(x)      (((x) + ALIGN - 1) & ~ (ALIGN - 1))
#define HEADER          ALIGNED(sizeof(msize_t))

#endif  /* __MALLOC_H */
