
/**************************************************************************
**                                                                        *
**  FILE        :  _io_putwc.c                                            *
**                                                                        *
**  DESCRIPTION :  _io_getc(), _io_putc(), _io_puts(), _io_ungetc() and   *
**                 their wide character variants are wrapper functions    *
**                 which operate either on a string or call a standard    *
**                 I/O function. They are used solely by the printf/scanf *
**                 family of functions.                                   *
**                 Unless _iob.c:_iob[] is referenced, the standard I/O   *
**                 function references will turn out to be NULL pointers  *
**                 because the references are weak. This is ok because in *
**                 that case io->fp will always be NULL. Linking in       *
**                 _iob.c will automatically pull in the standard I/O     *
**                 functions.                                             *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED
#include <wchar.h>
#include <errno.h>

#pragma weak fputwc
void    _io_putwc(wchar_t wc, struct _io *io)
{
        if (io->fp)
        {
                fputwc(wc, io->fp);
        }
        else if (io->ptr < io->end)
        {
                if (wc > (wchar_t) UCHAR_MAX)
                {
                        errno = EILSEQ;
                        /* should return WEOF but it's ignored by the string formatters */
                }
                else
                {
                        *(wchar_t *)io->ptr = wc;
                        io->ptr = io->ptr + sizeof (wchar_t);
                }
        }
}
#endif
