
/**************************************************************************
**                                                                        *
**  FILE        :  _io_getwc.c                                            *
**                                                                        *
**  DESCRIPTION :  _io_getc(), _io_putc(), _io_puts(), _io_ungetc() and   *
**                 their wide character variants are wrapper functions    *
**                 which operate either on a string or call a standard    *
**                 I/O function. They are used solely by the printf/scanf *
**                 family of functions.                                   *
**                 Unless _iob.c:_iob[] is referenced, the standard I/O   *
**                 function references will turn out to be NULL pointers  *
**                 because the references are weak. This is ok because in *
**                 that case io->fp will always be NULL. Linking in       *
**                 _iob.c will automatically pull in the standard I/O     *
**                 functions.                                             *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdio.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED
#include <wchar.h>
#include <errno.h>

#pragma weak fgetwc
wint_t  _io_getwc(struct _io *io)
{
        wint_t  wc;

        if (io->fp)
        {
                wc = fgetwc(io->fp);
        }
        else if (io->ptr < io->end)
        {
                wc = *(wchar_t *)io->ptr;
                io->ptr = io->ptr + sizeof (wchar_t);
                if (wc > (wint_t) UCHAR_MAX)
                {
                        errno = EILSEQ;
                        wc = WEOF;
                }
        }
        else
        {
                wc = WEOF;
        }
        return wc;
}
#endif
