
/**************************************************************************
**                                                                        *
**  FILE        :  _fpclassifyg.c                                         *
**                                                                        *
**  DESCRIPTION :  Floating point classification.                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

extern  int     _issubnormal(double x);
extern  int     _fpclassify(double x)
{
        if (isinf(x))
                return FP_INFINITE;
        if (isnan(x))
                return FP_NAN;
        if (_issubnormal(x))
                return FP_SUBNORMAL;
        if (x == 0.0)
            return FP_ZERO;
        return FP_NORMAL;
}
