
/**************************************************************************
**                                                                        *
**  FILE        :  _dowscan_llong.c                                       *
**                                                                        *
**  DESCRIPTION :  "long long" version of the _dowscan() function         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

#pragma alias                   __wscanf_llong2 = _dowscan

#pragma weak                    _getwflt

#define WIDE                    1
#define DOSCAN                  _dowscan
#define GETFLOAT                _getwflt
#define ISSPACE                 iswspace
#define ISDIGIT                 iswdigit
#define ISXDIGIT                iswxdigit
#define TOUPPER                 towupper
#define FGETC                   _io_getwc
#define UNGETC                  _io_ungetwc
#define LITERAL(s)              L ## s
#define E_O_F                   WEOF

typedef wchar_t                 char_t;
typedef wchar_t                 uchar_t;
typedef wint_t                  int_t;

typedef unsigned long long      uint_value_t;
typedef signed long long        sint_value_t;
#define VALUE_MAX               LLONG_MAX
#define VALUE_MIN               LLONG_MIN
#define UVALUE_MAX              ULLONG_MAX

#include "_doscan.h"

#endif
