
/**************************************************************************
**                                                                        *
**  FILE        :  _dowflt.c                                              *
**                                                                        *
**  DESCRIPTION :  Source file for '_dowflt()' routine                    *
**                 Which is the formatter for floating point printing     *
**                 This file is only linked when floating point is used   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>
#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#pragma alias                   __wprintf_float = _dowflt

#define WIDE                    1
#define DOFLT                   _dowflt
#define FPUTC                   _io_putwc
#define FPUTS(s,fp)             _io_putws(s, fp)
#define ISUPPER                 iswupper
#define LITERAL(s)              L ## s

typedef wchar_t                 char_t;
typedef wchar_t                 uchar_t;
typedef wint_t                  int_t;

#include "_doflt.h"

#endif
