
/**************************************************************************
**                                                                        *
**  FILE        :  _caddg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex addition.                                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * _cadd(x,y)
 *
 * Element-wise addition.
 */
extern  double complex          _d_cadd(double complex x, double complex y)
{
        double complex z;
        __cd_r(z) = __cd_r(x) + __cd_r(y);
        __cd_i(z) = __cd_i(x) + __cd_i(y);
        return z;
}
