/**************************************************************************
**
**  FILE        :  set_new.c
**
**  DESCRIPTION :  set_new_handler routine to allow the user to affect
**                 the behavior of the default operator new() when memory
**                 cannot be allocated.
**
**  COPYRIGHT   :  Copyright 1998-2009 Altium BV
**
**************************************************************************/

#include "basics.h"
#include "runtime.h"
#pragma hdrstop
#include <tasking_config.h>

#ifndef NULL
#define NULL 0
#endif /* ifndef NULL */

__TASKING_START_NAMESPACE

new_handler set_new_handler(new_handler handler) THROW_NOTHING()
/*
Set _new_handler to the new function pointer provided and return the
previous value of _new_handler.
*/
{
  new_handler rr = _new_handler;
  _new_handler = handler;
  return rr;
}  /* set_new_handler */

__TASKING_END_NAMESPACE
