
/**************************************************************************
**                                                                        *
**  FILE        :  setjmp.h                                               *
**                                                                        *
**  DESCRIPTION :  Include file with prototypes for non-local jump        *
**                 functions                                              *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _SETJMP_H
#define _SETJMP_H       1

/* Byte offsets in jmp_buf array. */
#define __JB_R4         0                       /* R4 - 4 MAUs */
#define __JB_R5         4                       /* R5 - 4 MAUs */
#define __JB_R6         8                       /* R6 - 4 MAUs */
#define __JB_R7         12                      /* R7 - 4 MAUs */
#define __JB_R8         16                      /* R8 - 4 MAUs */
#define __JB_R9         20                      /* R9 - 4 MAUs */
#define __JB_R10        24                      /* R10 - 4 MAUs */
#define __JB_R11        28                      /* R11 - 4 MAUs */
#define __JB_R12        32                      /* R12 - 4 MAUs */
#define __JB_R13        36                      /* R13 - 4 MAUs */
#define __JB_R14        40                      /* R14 - 4 MAUs */

#define __JMPBUF_SIZ (44/4)

typedef int jmp_buf[__JMPBUF_SIZ];

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
int setjmp      ( jmp_buf );
void longjmp    ( jmp_buf, int );
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* _SETJMP_H */
