/**************************************************************************
**                                                                        *
**  FILE        :  sc32442.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung SC32442        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _SC32442_H
#define _SC32442_H


#ifdef __BIG_ENDIAN__
#define BIG_END_CHAR_OFF        3
#define BIG_END_HW_OFF          2
#else
#define BIG_END_CHAR_OFF        0
#define BIG_END_HW_OFF          0
#endif


/*
** Memory Controller
*/

#define BWSCON                  (*((volatile unsigned int  *) 0x48000000)) // Bus width & wait status
#define BANKCON0                (*((volatile unsigned int  *) 0x48000004)) // Boot ROM control
#define BANKCON1                (*((volatile unsigned int  *) 0x48000008)) // BANK1 control
#define BANKCON2                (*((volatile unsigned int  *) 0x4800000c)) // BANK2 control
#define BANKCON3                (*((volatile unsigned int  *) 0x48000010)) // BANK3 control
#define BANKCON4                (*((volatile unsigned int  *) 0x48000014)) // BANK4 control
#define BANKCON5                (*((volatile unsigned int  *) 0x48000018)) // BANK5 control
#define BANKCON6                (*((volatile unsigned int  *) 0x4800001c)) // BANK6 control
#define BANKCON7                (*((volatile unsigned int  *) 0x48000020)) // BANK7 control
#define REFRESH                 (*((volatile unsigned int  *) 0x48000024)) // DRAM/SDRAM refresh
#define BANKSIZE                (*((volatile unsigned int  *) 0x48000028)) // Flexible Bank Size
#define MRSRB6                  (*((volatile unsigned int  *) 0x4800002c)) // Mode register set for SDRAM
#define MRSRB7                  (*((volatile unsigned int  *) 0x48000030)) // Mode register set for SDRAM


/*
** USB Host Controller
*/

#define HcRevision              (*((volatile unsigned int  *) 0x49000000)) // Control and Status Group
#define HcControl               (*((volatile unsigned int  *) 0x49000004))
#define HcCommonStatus          (*((volatile unsigned int  *) 0x49000008))
#define HcInterruptStatus       (*((volatile unsigned int  *) 0x4900000c))
#define HcInterruptEnable       (*((volatile unsigned int  *) 0x49000010))
#define HcInterruptDisable      (*((volatile unsigned int  *) 0x49000014))

#define HcHCCA                  (*((volatile unsigned int  *) 0x49000018)) // Memory Pointer Group
#define HcPeriodCuttentED       (*((volatile unsigned int  *) 0x4900001c))
#define HcControlHeadED         (*((volatile unsigned int  *) 0x49000020))
#define HcControlCurrentED      (*((volatile unsigned int  *) 0x49000024))
#define HcBulkHeadED            (*((volatile unsigned int  *) 0x49000028))
#define HcBulkCurrentED         (*((volatile unsigned int  *) 0x4900002c))
#define HcDoneHead              (*((volatile unsigned int  *) 0x49000030))

#define HcRmInterval            (*((volatile unsigned int  *) 0x49000034)) // Frame Counter Group
#define HcFmRemaining           (*((volatile unsigned int  *) 0x49000038))
#define HcFmNumber              (*((volatile unsigned int  *) 0x4900003c))
#define HcPeriodicStart         (*((volatile unsigned int  *) 0x49000040))
#define HcLSThreshold           (*((volatile unsigned int  *) 0x49000044))

#define HcRhDescriptorA         (*((volatile unsigned int  *) 0x49000048)) // Root Hub Group
#define HcRhDescriptorB         (*((volatile unsigned int  *) 0x4900004c))
#define HcRhStatus              (*((volatile unsigned int  *) 0x49000050))
#define HcRhPortStatus1         (*((volatile unsigned int  *) 0x49000054))
#define HcRhPortStatus2         (*((volatile unsigned int  *) 0x49000058))


/*
** Interrupt Controller
*/

#define SRCPND                  (*((volatile unsigned int  *) 0x4a000000)) // Interrupt request status
#define INTMOD                  (*((volatile unsigned int  *) 0x4a000004)) // Interrupt mode control
#define INTMSK                  (*((volatile unsigned int  *) 0x4a000008)) // Interrupt mask control
#define PRIORITY                (*((volatile unsigned int  *) 0x4a00000c)) // IRQ priority control
#define INTPND                  (*((volatile unsigned int  *) 0x4a000010)) // Interrupt request status
#define INTOFFSET               (*((volatile unsigned int  *) 0x4a000014)) // Interruot request source offset
#define SUBSRCPND               (*((volatile unsigned int  *) 0x4a000018)) // Sub source pending
#define INTSUBMSK               (*((volatile unsigned int  *) 0x4a00001c)) // Interrupt sub mask


/*
** DMA
*/

#define DISRC0                  (*((volatile unsigned int  *) 0x4b000000)) // DMA 0 Initial source
#define DISRCC0                 (*((volatile unsigned int  *) 0x4b000004)) // DMA 0 Initial source control
#define DIDST0                  (*((volatile unsigned int  *) 0x4b000008)) // DMA 0 Initial Destination
#define DIDSTC0                 (*((volatile unsigned int  *) 0x4b00000c)) // DMA 0 Initial Destination control
#define DCON0                   (*((volatile unsigned int  *) 0x4b000010)) // DMA 0 Control
#define DSTAT0                  (*((volatile unsigned int  *) 0x4b000014)) // DMA 0 Status
#define DCSRC0                  (*((volatile unsigned int  *) 0x4b000018)) // DMA 0 Current source
#define DCDST0                  (*((volatile unsigned int  *) 0x4b00001c)) // DMA 0 Current destination
#define DMASKTRIG0              (*((volatile unsigned int  *) 0x4b000020)) // DMA 0 Mask trigger

#define DISRC1                  (*((volatile unsigned int  *) 0x4b000040)) // DMA 1 Initial source
#define DISRCC1                 (*((volatile unsigned int  *) 0x4b000044)) // DMA 1 Initial source control
#define DIDST1                  (*((volatile unsigned int  *) 0x4b000048)) // DMA 1 Initial Destination
#define DIDSTC1                 (*((volatile unsigned int  *) 0x4b00004c)) // DMA 1 Initial Destination control
#define DCON1                   (*((volatile unsigned int  *) 0x4b000050)) // DMA 1 Control
#define DSTAT1                  (*((volatile unsigned int  *) 0x4b000054)) // DMA 1 Status
#define DCSRC1                  (*((volatile unsigned int  *) 0x4b000058)) // DMA 1 Current source
#define DCDST1                  (*((volatile unsigned int  *) 0x4b00005c)) // DMA 1 Current destination
#define DMASKTRIG1              (*((volatile unsigned int  *) 0x4b000060)) // DMA 1 Mask trigger

#define DISRC2                  (*((volatile unsigned int  *) 0x4b000080)) // DMA 2 Initial source
#define DISRCC2                 (*((volatile unsigned int  *) 0x4b000084)) // DMA 2 Initial source control
#define DIDST2                  (*((volatile unsigned int  *) 0x4b000088)) // DMA 2 Initial Destination
#define DIDSTC2                 (*((volatile unsigned int  *) 0x4b00008c)) // DMA 2 Initial Destination control
#define DCON2                   (*((volatile unsigned int  *) 0x4b000090)) // DMA 2 Control
#define DSTAT2                  (*((volatile unsigned int  *) 0x4b000094)) // DMA 2 Status
#define DCSRC2                  (*((volatile unsigned int  *) 0x4b000098)) // DMA 2 Current source
#define DCDST2                  (*((volatile unsigned int  *) 0x4b00009c)) // DMA 2 Current destination
#define DMASKTRIG2              (*((volatile unsigned int  *) 0x4b0000a0)) // DMA 2 Mask trigger

#define DISRC3                  (*((volatile unsigned int  *) 0x4b0000c0)) // DMA 3 Initial source
#define DISRCC3                 (*((volatile unsigned int  *) 0x4b0000c4)) // DMA 3 Initial source control
#define DIDST3                  (*((volatile unsigned int  *) 0x4b0000c8)) // DMA 3 Initial Destination
#define DIDSTC3                 (*((volatile unsigned int  *) 0x4b0000cc)) // DMA 3 Initial Destination control
#define DCON3                   (*((volatile unsigned int  *) 0x4b0000d0)) // DMA 3 Control
#define DSTAT3                  (*((volatile unsigned int  *) 0x4b0000d4)) // DMA 3 Status
#define DCSRC3                  (*((volatile unsigned int  *) 0x4b0000d8)) // DMA 3 Current source
#define DCDST3                  (*((volatile unsigned int  *) 0x4b0000dc)) // DMA 3 Current destination
#define DMASKTRIG3              (*((volatile unsigned int  *) 0x4b0000e0)) // DMA 3 Mask trigger


/*
** Clock & Power Management
*/

#define LOCKTIME                (*((volatile unsigned int  *) 0x4c000000)) // PLL lock time counter
#define MPLLCON                 (*((volatile unsigned int  *) 0x4c000004)) // MPLL Control
#define UPLLCON                 (*((volatile unsigned int  *) 0x4c000008)) // UPLL Control
#define CLKCON                  (*((volatile unsigned int  *) 0x4c00000c)) // Clock generator control
#define CLKSLOW                 (*((volatile unsigned int  *) 0x4c000010)) // Slow clock control
#define CLKDIVN                 (*((volatile unsigned int  *) 0x4c000014)) // Clock divider control
#define CAMDIVN			(*((volatile unsigned int  *) 0x4c000018)) // USB, CAM Clock divider control


/*
** LCD Controller
*/

#define LCDCON1                 (*((volatile unsigned int  *) 0x4d000000)) // LCD control 1
#define LCDCON2                 (*((volatile unsigned int  *) 0x4d000004)) // LCD control 2
#define LCDCON3                 (*((volatile unsigned int  *) 0x4d000008)) // LCD control 3
#define LCDCON4                 (*((volatile unsigned int  *) 0x4d00000c)) // LCD control 4
#define LCDCON5                 (*((volatile unsigned int  *) 0x4d000010)) // LCD control 5
#define LCDSADDR1               (*((volatile unsigned int  *) 0x4d000014)) // STN/TFT Frame buffer start address 1
#define LCDSADDR2               (*((volatile unsigned int  *) 0x4d000018)) // STN/TFT Frame buffer start address 2
#define LCDSADDR3               (*((volatile unsigned int  *) 0x4d00001c)) // STN/TFT Virtual screen address set
#define REDLUT                  (*((volatile unsigned int  *) 0x4d000020)) // STN Red lookup table
#define GREENLUT                (*((volatile unsigned int  *) 0x4d000024)) // STN Green lookup table 
#define BLUELUT                 (*((volatile unsigned int  *) 0x4d000028)) // STN Blue lookup table
#define DITHMODE                (*((volatile unsigned int  *) 0x4d00004c)) // STN Dithering mode
#define TPAL                    (*((volatile unsigned int  *) 0x4d000050)) // TFT Temporary palette
#define LCDINTPND               (*((volatile unsigned int  *) 0x4d000054)) // LCD Interrupt pending
#define LCDSRCPND               (*((volatile unsigned int  *) 0x4d000058)) // LCD Interrupt source
#define LCDINTMSK               (*((volatile unsigned int  *) 0x4d00005c)) // LCD Interrupt mask
#define LPCSEL                  (*((volatile unsigned int  *) 0x4d000060)) // LPC3600 Control
#define PALETTE_START_ADDRESS   (0x4d000400)                               // Palette start address


/*
** NAND Flash
*/

#define NFCONF			(*((volatile unsigned int  *) 0x4e000000)) // NAND Flash configuration
#define NFCONT			(*((volatile unsigned int  *) 0x4e000004)) // NAND Flash control
#define NFCMD			(*((volatile unsigned int  *) 0x4e000008)) // NAND Flash command
#define NFADDR			(*((volatile unsigned int  *) 0x4e00000c)) // NAND Flash address
#define NFDATA			(*((volatile unsigned int  *) 0x4e000010)) // NAND Flash data
#define NFMECCD0		(*((volatile unsigned int  *) 0x4e000014)) // NAND Flash main area ECC0/1
#define NFMECCD1		(*((volatile unsigned int  *) 0x4e000018)) // NAND Flash main area ECC2/3
#define NFSECCD			(*((volatile unsigned int  *) 0x4e00001c)) // NAND Flash spare area ECC
#define NFSTAT			(*((volatile unsigned int  *) 0x4e000020)) // NAND Flash operation status
#define NFESTAT0		(*((volatile unsigned int  *) 0x4e000024)) // NAND Flash ECC status for I/O[7:0]
#define NFESTAT1		(*((volatile unsigned int  *) 0x4e000028)) // NAND Flash ECC status for I/O[15:8]
#define NFMECC0			(*((volatile unsigned int  *) 0x4e00002c)) // NAND Flash main area ECC0 status
#define NFMECC1			(*((volatile unsigned int  *) 0x4e000030)) // NAND Flash main area ECC1 status
#define NFSECC			(*((volatile unsigned int  *) 0x4e000034)) // NAND Flash spare area ECC status
#define NFSBLK			(*((volatile unsigned int  *) 0x4e000038)) // NAND Flash Start block address
#define NFEBLK			(*((volatile unsigned int  *) 0x4e00003c)) // NAND Flash End block address


/*
** Camera Interface
*/

#define CISRCFMT                (*((volatile unsigned int  *) 0x4f000000)) // Input Source Format Register
#define CIWDOFST                (*((volatile unsigned int  *) 0x4f000004)) // Window Offset Register
#define CIGCTRL                 (*((volatile unsigned int  *) 0x4f000008)) // Global Control Register
#define CICOYSA1                (*((volatile unsigned int  *) 0x4f000018)) // Y 1st frame start address for codec DMA
#define CICOYSA2                (*((volatile unsigned int  *) 0x4f00001c)) // Y 2nd frame start address for codec DMA
#define CICOYSA3                (*((volatile unsigned int  *) 0x4f000020)) // Y 3rd frame start address for codec DMA
#define CICOYSA4                (*((volatile unsigned int  *) 0x4f000024)) // Y 4th frame start address for codec DMA
#define CICOCBSA1               (*((volatile unsigned int  *) 0x4f000028)) // Cb 1st frame start address for codec DMA
#define CICOCBSA2               (*((volatile unsigned int  *) 0x4f00002c)) // Cb 2nd frame start address for codec DMA
#define CICOCBSA3               (*((volatile unsigned int  *) 0x4f000030)) // Cb 3rd frame start address for codec DMA
#define CICOCBSA4               (*((volatile unsigned int  *) 0x4f000034)) // Cb 4th frame start address for codec DMA
#define CICOCRSA1               (*((volatile unsigned int  *) 0x4f000038)) // Cr 1st frame start address for codec DMA
#define CICOCRSA2               (*((volatile unsigned int  *) 0x4f00003c)) // Cr 2nd frame start address for codec DMA
#define CICOCRSA3               (*((volatile unsigned int  *) 0x4f000040)) // Cr 3rd frame start address for codec DMA
#define CICOCRSA4               (*((volatile unsigned int  *) 0x4f000044)) // Cr 4th frame start address for codec DMA
#define CICOTRGFMT              (*((volatile unsigned int  *) 0x4f000048)) // Target image format of codec DMA
#define CICOCTRL                (*((volatile unsigned int  *) 0x4f00004c)) // Codec DMA control related
#define CICOSCPRERATIO          (*((volatile unsigned int  *) 0x4f000050)) // Codec pre-scaler ratio control
#define CICOSCPREDST            (*((volatile unsigned int  *) 0x4f000054)) // Codec pre-scaler destination format
#define CICOSCCTRL              (*((volatile unsigned int  *) 0x4f000058)) // Codec main-scaler control
#define CICOTAREA               (*((volatile unsigned int  *) 0x4f00005c)) // Codec scaler target area
#define CICOSTATUS              (*((volatile unsigned int  *) 0x4f000064)) // Codec path status
#define CIPRCLRSA1              (*((volatile unsigned int  *) 0x4f00006c)) // RGB 1st frame start address for preview DMA
#define CIPRCLRSA2              (*((volatile unsigned int  *) 0x4f000070)) // RGB 2nd frame start address for preview DMA
#define CIPRCLRSA3              (*((volatile unsigned int  *) 0x4f000074)) // RGB 3rd frame start address for preview DMA
#define CIPRCLRSA4              (*((volatile unsigned int  *) 0x4f000078)) // RGB 4th frame start address for preview DMA
#define CIPRTRGFMT              (*((volatile unsigned int  *) 0x4f00007c)) // Target image format of preview DMA
#define CIPRCTRL                (*((volatile unsigned int  *) 0x4f000080)) // Preview DMA control related
#define CIPRSCPRERATIO          (*((volatile unsigned int  *) 0x4f000084)) // Preview pre-scaler ratio control
#define CIPRSCPREDST            (*((volatile unsigned int  *) 0x4f000088)) // Preview pre-scaler destination format
#define CIPRSCCTRL              (*((volatile unsigned int  *) 0x4f00008c)) // Preview main-scaler control
#define CIPRTAREA               (*((volatile unsigned int  *) 0x4f000090)) // Preview scaler target area
#define CIPRSTATUS              (*((volatile unsigned int  *) 0x4f000098)) // Preview path status
#define CIIMGCPT                (*((volatile unsigned int  *) 0x4f0000a0)) // Image capture enable command


/*
** UART
*/

#define ULCON0                  (*((volatile unsigned int  *) 0x50000000)) // UART 0 Line control
#define UCON0                   (*((volatile unsigned int  *) 0x50000004)) // UART 0 Control
#define UFCON0                  (*((volatile unsigned int  *) 0x50000008)) // UART 0 FIFO control
#define UMCON0                  (*((volatile unsigned int  *) 0x5000000c)) // UART 0 Modem control
#define UTRSTAT0                (*((volatile unsigned int  *) 0x50000010)) // UART 0 Tx/Rx status
#define UERSTAT0                (*((volatile unsigned int  *) 0x50000014)) // UART 0 Rx error status
#define UFSTAT0                 (*((volatile unsigned int  *) 0x50000018)) // UART 0 FIFO status
#define UMSTAT0                 (*((volatile unsigned int  *) 0x5000001c)) // UART 0 Modem status
#define UTXH0                   (*((volatile unsigned char *)(0x50000020 + BIG_END_CHAR_OFF))) // UART 0 Transmission Hold
#define URXH0                   (*((volatile unsigned char *)(0x50000024 + BIG_END_CHAR_OFF))) // UART 0 Receive buffer
#define UBRDIV0                 (*((volatile unsigned int  *) 0x50000028)) // UART 0 Baud rate divisor

#define ULCON1                  (*((volatile unsigned int  *) 0x50004000)) // UART 1 Line control
#define UCON1                   (*((volatile unsigned int  *) 0x50004004)) // UART 1 Control
#define UFCON1                  (*((volatile unsigned int  *) 0x50004008)) // UART 1 FIFO control
#define UMCON1                  (*((volatile unsigned int  *) 0x5000400c)) // UART 1 Modem control
#define UTRSTAT1                (*((volatile unsigned int  *) 0x50004010)) // UART 1 Tx/Rx status
#define UERSTAT1                (*((volatile unsigned int  *) 0x50004014)) // UART 1 Rx error status
#define UFSTAT1                 (*((volatile unsigned int  *) 0x50004018)) // UART 1 FIFO status
#define UMSTAT1                 (*((volatile unsigned int  *) 0x5000401c)) // UART 1 Modem status
#define UTXH1                   (*((volatile unsigned char *)(0x50004020 + BIG_END_CHAR_OFF))) // UART 1 Transmission Hold
#define URXH1                   (*((volatile unsigned char *)(0x50004024 + BIG_END_CHAR_OFF))) // UART 1 Receive buffer
#define UBRDIV1                 (*((volatile unsigned int  *) 0x50004028)) // UART 1 Baud rate divisor

#define ULCON2                  (*((volatile unsigned int  *) 0x50008000)) // UART 2 Line control
#define UCON2                   (*((volatile unsigned int  *) 0x50008004)) // UART 2 Control
#define UFCON2                  (*((volatile unsigned int  *) 0x50008008)) // UART 2 FIFO control
#define UMCON2                  (*((volatile unsigned int  *) 0x5000800c)) // UART 2 Modem control
#define UTRSTAT2                (*((volatile unsigned int  *) 0x50008010)) // UART 2 Tx/Rx status
#define UERSTAT2                (*((volatile unsigned int  *) 0x50008014)) // UART 2 Rx error status
#define UFSTAT2                 (*((volatile unsigned int  *) 0x50008018)) // UART 2 FIFO status
#define UMSTAT2                 (*((volatile unsigned int  *) 0x5000801c)) // UART 2 Modem status
#define UTXH2                   (*((volatile unsigned char *)(0x50008020 + BIG_END_CHAR_OFF))) // UART 2 Transmission Hold
#define URXH2                   (*((volatile unsigned char *)(0x50008024 + BIG_END_CHAR_OFF))) // UART 2 Receive buffer
#define UBRDIV2                 (*((volatile unsigned int  *) 0x50008028)) // UART 2 Baud rate divisor


/*
** PWM Timer
*/

#define TCFG0                   (*((volatile unsigned int  *) 0x51000000)) // Timer 0 configuration
#define TCFG1                   (*((volatile unsigned int  *) 0x51000004)) // Timer 1 configuration
#define TCON                    (*((volatile unsigned int  *) 0x51000008)) // Timer control
#define TCNTB0                  (*((volatile unsigned int  *) 0x5100000c)) // Timer count buffer 0
#define TCMPB0                  (*((volatile unsigned int  *) 0x51000010)) // Timer compare buffer 0
#define TCNTO0                  (*((volatile unsigned int  *) 0x51000014)) // Timer count observation 0
#define TCNTB1                  (*((volatile unsigned int  *) 0x51000018)) // Timer count buffer 1
#define TCMPB1                  (*((volatile unsigned int  *) 0x5100001c)) // Timer compare buffer 1
#define TCNTO1                  (*((volatile unsigned int  *) 0x51000020)) // Timer count observation 1
#define TCNTB2                  (*((volatile unsigned int  *) 0x51000024)) // Timer count buffer 2
#define TCMPB2                  (*((volatile unsigned int  *) 0x51000028)) // Timer compare buffer 2
#define TCNTO2                  (*((volatile unsigned int  *) 0x5100002c)) // Timer count observation 2
#define TCNTB3                  (*((volatile unsigned int  *) 0x51000030)) // Timer count buffer 3
#define TCMPB3                  (*((volatile unsigned int  *) 0x51000034)) // Timer compare buffer 3
#define TCNTO3                  (*((volatile unsigned int  *) 0x51000038)) // Timer count observation 3
#define TCNTB4                  (*((volatile unsigned int  *) 0x5100003c)) // Timer count buffer 4
#define TCNTO4                  (*((volatile unsigned int  *) 0x51000040)) // Timer count observation 4


/*
** USB Device
*/

#define FUNC_ADDR_REG           (*((volatile unsigned char *) (0x52000140 + BIG_END_CHAR_OFF))) // Function address
#define PWR_REG                 (*((volatile unsigned char *) (0x52000144 + BIG_END_CHAR_OFF))) // Power management
#define EP_INT_REG              (*((volatile unsigned char *) (0x52000148 + BIG_END_CHAR_OFF))) // EP Interrupt pending and clear
#define USB_INT_REG             (*((volatile unsigned char *) (0x52000158 + BIG_END_CHAR_OFF))) // USB Interrupt pending and clear
#define EP_INT_EN_REG           (*((volatile unsigned char *) (0x5200015c + BIG_END_CHAR_OFF))) // Interrupt enable
#define USB_INT_EN_REG          (*((volatile unsigned char *) (0x5200016c + BIG_END_CHAR_OFF))) // Interrupt enable
#define FRAME_NUM1_REG          (*((volatile unsigned char *) (0x52000170 + BIG_END_CHAR_OFF))) // Frame number lower byte
#define FRAME_NUM2_REG          (*((volatile unsigned char *) (0x52000174 + BIG_END_CHAR_OFF))) // Frame number higher byte
#define INDEX_REG               (*((volatile unsigned char *) (0x52000178 + BIG_END_CHAR_OFF))) // Register index
#define MAXP_REG                (*((volatile unsigned char *) (0x52000180 + BIG_END_CHAR_OFF))) // Endpoint max packet
#define EP0_CSR                 (*((volatile unsigned char *) (0x52000184 + BIG_END_CHAR_OFF))) // Endpoint 0 status
#define IN_CSR1_REG             (*((volatile unsigned char *) (0x52000184 + BIG_END_CHAR_OFF))) // In endpoint control status
#define IN_CSR2_REG             (*((volatile unsigned char *) (0x52000188 + BIG_END_CHAR_OFF))) // In endpoint control status
#define OUT_CSR1_REG            (*((volatile unsigned char *) (0x52000190 + BIG_END_CHAR_OFF))) // Out endpoint control status
#define OUT_CSR2_REG            (*((volatile unsigned char *) (0x52000194 + BIG_END_CHAR_OFF))) // Out endpoint control status
#define OUT_FIFO_CNT1_REG       (*((volatile unsigned char *) (0x52000198 + BIG_END_CHAR_OFF))) // Endpoint out write count
#define OUT_FIFO_CNT2_REG       (*((volatile unsigned char *) (0x5200019c + BIG_END_CHAR_OFF))) // Endpoint out write count
#define EP0_FIFO                (*((volatile unsigned char *) (0x520001c0 + BIG_END_CHAR_OFF))) // Endpoint 0 FIFO
#define EP1_FIFO                (*((volatile unsigned char *) (0x520001c4 + BIG_END_CHAR_OFF))) // Endpoint 1 FIFO
#define EP2_FIFO                (*((volatile unsigned char *) (0x520001c8 + BIG_END_CHAR_OFF))) // Endpoint 2 FIFO
#define EP3_FIFO                (*((volatile unsigned char *) (0x520001cc + BIG_END_CHAR_OFF))) // Endpoint 3 FIFO
#define EP4_FIFO                (*((volatile unsigned char *) (0x520001d0 + BIG_END_CHAR_OFF))) // Endpoint 4 FIFO
#define EP1_DMA_CON             (*((volatile unsigned char *) (0x52000200 + BIG_END_CHAR_OFF))) // EP1 DMA interface control
#define EP1_DMA_UNIT            (*((volatile unsigned char *) (0x52000204 + BIG_END_CHAR_OFF))) // EP1 DMA Tx unit counter
#define EP1_DMA_FIFO            (*((volatile unsigned char *) (0x52000208 + BIG_END_CHAR_OFF))) // EP1 DMA Tx FIFO counter
#define EP1_DMA_TTC_L           (*((volatile unsigned char *) (0x5200020c + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_M           (*((volatile unsigned char *) (0x52000210 + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_H           (*((volatile unsigned char *) (0x52000214 + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP2_DMA_CON             (*((volatile unsigned char *) (0x52000218 + BIG_END_CHAR_OFF))) // EP2 DMA interface control
#define EP2_DMA_UNIT            (*((volatile unsigned char *) (0x5200021c + BIG_END_CHAR_OFF))) // EP2 DMA Tx unit counter
#define EP2_DMA_FIFO            (*((volatile unsigned char *) (0x52000220 + BIG_END_CHAR_OFF))) // EP2 DMA Tx FIFO counter
#define EP2_DMA_TTC_L           (*((volatile unsigned char *) (0x52000224 + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_M           (*((volatile unsigned char *) (0x52000228 + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_H           (*((volatile unsigned char *) (0x5200022c + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP3_DMA_CON             (*((volatile unsigned char *) (0x52000240 + BIG_END_CHAR_OFF))) // EP3 DMA interface control
#define EP3_DMA_UNIT            (*((volatile unsigned char *) (0x52000244 + BIG_END_CHAR_OFF))) // EP3 DMA Tx unit counter
#define EP3_DMA_FIFO            (*((volatile unsigned char *) (0x52000248 + BIG_END_CHAR_OFF))) // EP3 DMA Tx FIFO counter
#define EP3_DMA_TTC_L           (*((volatile unsigned char *) (0x5200024c + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_M           (*((volatile unsigned char *) (0x52000250 + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_H           (*((volatile unsigned char *) (0x52000254 + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP4_DMA_CON             (*((volatile unsigned char *) (0x52000258 + BIG_END_CHAR_OFF))) // EP4 DMA interface control
#define EP4_DMA_UNIT            (*((volatile unsigned char *) (0x5200025c + BIG_END_CHAR_OFF))) // EP4 DMA Tx unit counter
#define EP4_DMA_FIFO            (*((volatile unsigned char *) (0x52000260 + BIG_END_CHAR_OFF))) // EP4 DMA Tx FIFO counter
#define EP4_DMA_TTC_L           (*((volatile unsigned char *) (0x52000264 + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_M           (*((volatile unsigned char *) (0x52000268 + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_H           (*((volatile unsigned char *) (0x5200026c + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter


/*
** Watchdog Timer
*/

#define WTCON                   (*((volatile unsigned int  *) 0x53000000)) // Watch-dog timer mode
#define WTDAT                   (*((volatile unsigned int  *) 0x53000004)) // Watch-dog timer data
#define WTCNT                   (*((volatile unsigned int  *) 0x53000008)) // Eatch-dog timer count


/*
** IIC
*/

#define IICCON                  (*((volatile unsigned int  *) 0x54000000)) // IIC control
#define IICSTAT                 (*((volatile unsigned int  *) 0x54000004)) // IIC status
#define IICADD                  (*((volatile unsigned int  *) 0x54000008)) // IIC address
#define IICDS                   (*((volatile unsigned int  *) 0x5400000c)) // IIC data shift
#define IICLC			(*((volatile unsigned int  *) 0x54000010)) // IIC multi-master line control


/*
** IIS
*/

#define IISCON                  (*((volatile unsigned int  *) 0x55000000)) //IIS Control
#define IISMOD                  (*((volatile unsigned int  *) 0x55000004)) //IIS Mode
#define IISPSR                  (*((volatile unsigned int  *) 0x55000008)) //IIS Prescaler
#define IISFCON                 (*((volatile unsigned int  *) 0x5500000c)) //IIS FIFO control
#define IISFIFO                 (*((volatile unsigned short *) (0x55000010 + BIG_END_HW_OFF))) //IIS FIFO entry


/*
** AC97 Controller
*/

#define AC_GLBCTRL              (*((volatile unsigned int  *) 0x5b000000)) // Global Control Register
#define AC_GLBSTAT              (*((volatile unsigned int  *) 0x5b000004)) // Global Status Register
#define AC_CODEC_CMD            (*((volatile unsigned int  *) 0x5b000008)) // Codec Command Register
#define AC_CODEC_STAT           (*((volatile unsigned int  *) 0x5b00000c)) // Codec Status Register
#define AC_PCMADDR              (*((volatile unsigned int  *) 0x5b000010)) // PCM Out/In Channel FIFO Address Register
#define AC_MICADDR              (*((volatile unsigned int  *) 0x5b000014)) // Mic In Channel FIFO Address Register
#define AC_PCMDATA              (*((volatile unsigned int  *) 0x5b000018)) // PCM Out/In Channel FIFO Data Register
#define AC_MICDATA              (*((volatile unsigned int  *) 0x5b00001c)) // MIC In Channel FIFO Data Register


/*
** I/O Port
*/

#define GPACON                  (*((volatile unsigned int  *) 0x56000000)) // Port A control
#define GPADAT                  (*((volatile unsigned int  *) 0x56000004)) // Port A data
                        
#define GPBCON                  (*((volatile unsigned int  *) 0x56000010)) // Port B control
#define GPBDAT                  (*((volatile unsigned int  *) 0x56000014)) // Port B data
#define GPBDN                   (*((volatile unsigned int  *) 0x56000018)) // Pull-down control B
                        
#define GPCCON                  (*((volatile unsigned int  *) 0x56000020)) // Port C control
#define GPCDAT                  (*((volatile unsigned int  *) 0x56000024)) // Port C data
#define GPCDN                   (*((volatile unsigned int  *) 0x56000028)) // Pull-down control C
                        
#define GPDCON                  (*((volatile unsigned int  *) 0x56000030)) // Port D control
#define GPDDAT                  (*((volatile unsigned int  *) 0x56000034)) // Port D data
#define GPDDN                   (*((volatile unsigned int  *) 0x56000038)) // Pull-down control D
                        
#define GPECON                  (*((volatile unsigned int  *) 0x56000040)) // Port E control
#define GPEDAT                  (*((volatile unsigned int  *) 0x56000044)) // Port E data
#define GPEDN                   (*((volatile unsigned int  *) 0x56000048)) // Pull-down control E
                        
#define GPFCON                  (*((volatile unsigned int  *) 0x56000050)) // Port F control
#define GPFDAT                  (*((volatile unsigned int  *) 0x56000054)) // Port F data
#define GPFDN                   (*((volatile unsigned int  *) 0x56000058)) // Pull-down control F
                        
#define GPGCON                  (*((volatile unsigned int  *) 0x56000060)) // Port G control
#define GPGDAT                  (*((volatile unsigned int  *) 0x56000064)) // Port G data
#define GPGDN                   (*((volatile unsigned int  *) 0x56000068)) // Pull-down control G
                        
#define GPHCON                  (*((volatile unsigned int  *) 0x56000070)) // Port H control
#define GPHDAT                  (*((volatile unsigned int  *) 0x56000074)) // Port H data
#define GPHDN                   (*((volatile unsigned int  *) 0x56000078)) // Pull-down control H
                        
#define MISCCR                  (*((volatile unsigned int  *) 0x56000080)) // Miscellaneous control
#define DCLKCON                 (*((volatile unsigned int  *) 0x56000084)) // DCLK0/1 control
#define EXTINT0                 (*((volatile unsigned int  *) 0x56000088)) // External interrupt control register 0
#define EXTINT1                 (*((volatile unsigned int  *) 0x5600008c)) // External interrupt control register 1
#define EXTINT2                 (*((volatile unsigned int  *) 0x56000090)) // External interrupt control register 2
#define EINTFLT0                (*((volatile unsigned int  *) 0x56000094)) // Reserved
#define EINTFLT1                (*((volatile unsigned int  *) 0x56000098)) // Reserved
#define EINTFLT2                (*((volatile unsigned int  *) 0x5600009c)) // External interrupt filter control register 2
#define EINTFLT3                (*((volatile unsigned int  *) 0x560000a0)) // External interrupt filter control register 3
#define EINTMASK                (*((volatile unsigned int  *) 0x560000a4)) // External interrupt mask
#define EINTPEND                (*((volatile unsigned int  *) 0x560000a8)) // External interrupt pending
#define GSTATUS0                (*((volatile unsigned int  *) 0x560000ac)) // External pin status
#define GSTATUS1                (*((volatile unsigned int  *) 0x560000b0)) // Chip ID
#define GSTATUS2                (*((volatile unsigned int  *) 0x560000b4)) // Reset type
#define GSTATUS3                (*((volatile unsigned int  *) 0x560000b8)) // Inform Register
#define GSTATUS4                (*((volatile unsigned int  *) 0x560000bc)) // Inform Register
#define DSC0			(*((volatile unsigned int  *) 0x560000c4)) // Strength control register 0
#define DSC1			(*((volatile unsigned int  *) 0x560000c8)) // Strength control register 1
#define MSLCON			(*((volatile unsigned int  *) 0x560000cc)) // Memory sleep control register

#define GPJCON                  (*((volatile unsigned int  *) 0x560000d0)) // Port J control
#define GPJDAT                  (*((volatile unsigned int  *) 0x560000d4)) // Port J data
#define GPJDN                   (*((volatile unsigned int  *) 0x560000d8)) // Pull-down control J
                        

/*
** RTC
*/

#define RTCCON                  (*((volatile unsigned char *) (0x57000040 + BIG_END_CHAR_OFF))) // RTC control
#define TICNT                   (*((volatile unsigned char *) (0x57000044 + BIG_END_CHAR_OFF))) // Tick time count
#define RTCALM                  (*((volatile unsigned char *) (0x57000050 + BIG_END_CHAR_OFF))) // RTC alarm control
#define ALMSEC                  (*((volatile unsigned char *) (0x57000054 + BIG_END_CHAR_OFF))) // Alarm second
#define ALMMIN                  (*((volatile unsigned char *) (0x57000058 + BIG_END_CHAR_OFF))) // Alarm minute
#define ALMHOUR                 (*((volatile unsigned char *) (0x5700005c + BIG_END_CHAR_OFF))) // Alarm Hour
#define ALMDATE                 (*((volatile unsigned char *) (0x57000060 + BIG_END_CHAR_OFF))) // Alarm day
#define ALMMON                  (*((volatile unsigned char *) (0x57000064 + BIG_END_CHAR_OFF))) // Alarm month
#define ALMYEAR                 (*((volatile unsigned char *) (0x57000068 + BIG_END_CHAR_OFF))) // Alarm year
#define RTCRST                  (*((volatile unsigned char *) (0x5700006c + BIG_END_CHAR_OFF))) // RTC round reset
#define BCDSEC                  (*((volatile unsigned char *) (0x57000070 + BIG_END_CHAR_OFF))) // BCD second
#define BCDMIN                  (*((volatile unsigned char *) (0x57000074 + BIG_END_CHAR_OFF))) // BCD minute
#define BCDHOUR                 (*((volatile unsigned char *) (0x57000078 + BIG_END_CHAR_OFF))) // BCD hour
#define BCDDATE                 (*((volatile unsigned char *) (0x5700007c + BIG_END_CHAR_OFF))) // BCD day
#define BCDDAY                  (*((volatile unsigned char *) (0x57000080 + BIG_END_CHAR_OFF))) // BCD date
#define BCDMON                  (*((volatile unsigned char *) (0x57000084 + BIG_END_CHAR_OFF))) // BCD month
#define BCDYEAR                 (*((volatile unsigned char *) (0x57000088 + BIG_END_CHAR_OFF))) // BCD year


/*
** A/D Converter
*/

#define ADCCON                  (*((volatile unsigned int  *) 0x58000000)) // ADC control
#define ADCTSC                  (*((volatile unsigned int  *) 0x58000004)) // ADC touch screen control
#define ADCDLY                  (*((volatile unsigned int  *) 0x58000008)) // ADC start or Interval Delay
#define ADCDAT0                 (*((volatile unsigned int  *) 0x5800000c)) // ADC conversion data 0
#define ADCDAT1                 (*((volatile unsigned int  *) 0x58000010)) // ADC conversion data 1
#define ADCUPDN			(*((volatile unsigned int  *) 0x58000014)) // Stylus Up/Down interrupt status

/*
** SPI
*/

#define SPCON0                  (*((volatile unsigned int  *) 0x59000000)) // SPI0 control
#define SPSTA0                  (*((volatile unsigned int  *) 0x59000004)) // SPI0 status
#define SPPIN0                  (*((volatile unsigned int  *) 0x59000008)) // SPI0 pin control
#define SPPRE0                  (*((volatile unsigned int  *) 0x5900000c)) // SPI0 baud rate prescaler
#define SPTDAT0                 (*((volatile unsigned int  *) 0x59000010)) // SPI0 Tx data
#define SPRDAT0                 (*((volatile unsigned int  *) 0x59000014)) // SPI0 Rx data

#define SPCON1                  (*((volatile unsigned int  *) 0x59000020)) // SPI1 control
#define SPSTA1                  (*((volatile unsigned int  *) 0x59000024)) // SPI1 status
#define SPPIN1                  (*((volatile unsigned int  *) 0x59000028)) // SPI1 pin control
#define SPPRE1                  (*((volatile unsigned int  *) 0x5900002c)) // SPI1 baud rate prescaler
#define SPTDAT1                 (*((volatile unsigned int  *) 0x59000030)) // SPI1 Tx data
#define SPRDAT1                 (*((volatile unsigned int  *) 0x59000034)) // SPI1 Rx data


/*
** SD Interface
*/

#define SDICON                  (*((volatile unsigned int  *) 0x5a000000)) // SDI control
#define SDIPRE                  (*((volatile unsigned int  *) 0x5a000004)) // SDI baud rate prescaler
#define SDICARG                 (*((volatile unsigned int  *) 0x5a000008)) // SDI command argument
#define SDICCON                 (*((volatile unsigned int  *) 0x5a00000c)) // SDI command control
#define SDICSTA                 (*((volatile unsigned int  *) 0x5a000010)) // SDI command status
#define SDIRSP0                 (*((volatile unsigned int  *) 0x5a000014)) // SDI response 0
#define SDIRSP1                 (*((volatile unsigned int  *) 0x5a000018)) // SDI response 1
#define SDIRSP2                 (*((volatile unsigned int  *) 0x5a00001c)) // SDI response 2
#define SDIRSP3                 (*((volatile unsigned int  *) 0x5a000020)) // SDI response 3
#define SDIDTIMER               (*((volatile unsigned int  *) 0x5a000024)) // SDI data/busy timer
#define SDIBSIZE                (*((volatile unsigned int  *) 0x5a000028)) // SDI block size
#define SDIDCON                 (*((volatile unsigned int  *) 0x5a00002c)) // SDI data control
#define SDIDCNT                 (*((volatile unsigned int  *) 0x5a000030)) // SDI data remain counter
#define SDIDSTA                 (*((volatile unsigned int  *) 0x5a000034)) // SDI data status
#define SDIFSTA                 (*((volatile unsigned int  *) 0x5a000038)) // SDI FIFO status
#define SDIIMSK                 (*((volatile unsigned int  *) 0x5a00003c)) // SDI interrupt mask
#define SDIDAT                  (*((volatile unsigned char *)(0x5a000040 + BIG_END_CHAR_OFF))) // SDI data


#endif   /* _SC32442_H */
