/**************************************************************************
**                                                                        *
**  FILE        :  s3c4530a.h                                             *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C4530A       *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C4530A_H
#define _S3C4530A_H


#define SFR_BASE (0x03ff0000)


/*
** System Manager
*/

#define SYSCFG          (*((volatile unsigned int *) (SFR_BASE + 0x0000))) // System configuration register
#define CLKCON          (*((volatile unsigned int *) (SFR_BASE + 0x3000))) // Clock control register
#define EXTACON0        (*((volatile unsigned int *) (SFR_BASE + 0x3008))) // External I/O timing register 1
#define EXTACON1        (*((volatile unsigned int *) (SFR_BASE + 0x300C))) // External I/O timing register 2
#define EXTDBWTH        (*((volatile unsigned int *) (SFR_BASE + 0x3010))) // Data bus width for each memory bank

#define ROMCON0         (*((volatile unsigned int *) (SFR_BASE + 0x3014))) // ROM/SRAM/Flash bank 0 control register
#define ROMCON1         (*((volatile unsigned int *) (SFR_BASE + 0x3018))) // ROM/SRAM/Flash bank 1 control register
#define ROMCON2         (*((volatile unsigned int *) (SFR_BASE + 0x301C))) // ROM/SRAM/Flash bank 2 control register
#define ROMCON3         (*((volatile unsigned int *) (SFR_BASE + 0x3020))) // ROM/SRAM/Flash bank 3 control register
#define ROMCON4         (*((volatile unsigned int *) (SFR_BASE + 0x3024))) // ROM/SRAM/Flash bank 4 control register
#define ROMCON5         (*((volatile unsigned int *) (SFR_BASE + 0x3028))) // ROM/SRAM/Flash bank 5 control register

#define DRAMCON0        (*((volatile unsigned int *) (SFR_BASE + 0x302C))) // DRAM bank 0 control register
#define DRAMCON1        (*((volatile unsigned int *) (SFR_BASE + 0x3030))) // DRAM bank 1 control register
#define DRAMCON2        (*((volatile unsigned int *) (SFR_BASE + 0x3034))) // DRAM bank 2 control register
#define DRAMCON3        (*((volatile unsigned int *) (SFR_BASE + 0x3038))) // DRAM bank 3 control register

#define REFEXTCON       (*((volatile unsigned int *) (SFR_BASE + 0x303C))) // Refresh and external I/O control register


/*
** Ethernet (BDMA)
*/

#define BDMATXCON       (*((volatile unsigned int *) (SFR_BASE + 0x9000))) // Buffered DMA receive control register
#define BDMARXCON       (*((volatile unsigned int *) (SFR_BASE + 0x9004))) // Buffered DMA transmit control register
#define BDMATXPTR       (*((volatile unsigned int *) (SFR_BASE + 0x9008))) // Transmit frame descriptor start address
#define BDMARXPTR       (*((volatile unsigned int *) (SFR_BASE + 0x900C))) // Receive frame descriptor start address
#define BDMARXLSZ       (*((volatile unsigned int *) (SFR_BASE + 0x9010))) // Receive frame maximum size
#define BDMASTAT        (*((volatile unsigned int *) (SFR_BASE + 0x9014))) // Buffered DMA status
#define CAM             (*((volatile unsigned int *) (SFR_BASE + 0x9100))) // CAM content (32 words)
#define BDMATXBUF       (*((volatile unsigned int *) (SFR_BASE + 0x9200))) // BDMA Tx buffer (64 words) for test mode addressing
#define BDMARXBUF       (*((volatile unsigned int *) (SFR_BASE + 0x9800))) // BDMA Rx buffer (64 words) for test mode addressing


/*
** Ethernet (MAC)
*/

#define MACON           (*((volatile unsigned int *) (SFR_BASE + 0xA000))) // Ethernet MAC control register
#define CAMCON          (*((volatile unsigned int *) (SFR_BASE + 0xA004))) // CAM control register
#define MACTXCON        (*((volatile unsigned int *) (SFR_BASE + 0xA008))) // MAC transmit control register
#define MACTXSTAT       (*((volatile unsigned int *) (SFR_BASE + 0xA00C))) // MAC transmit status register
#define MACRXCON        (*((volatile unsigned int *) (SFR_BASE + 0xA010))) // MAC receive control register
#define MACRXSTAT       (*((volatile unsigned int *) (SFR_BASE + 0xA014))) // MAC receive status register
#define STADATA         (*((volatile unsigned int *) (SFR_BASE + 0xA018))) // Station management data
#define STACON          (*((volatile unsigned int *) (SFR_BASE + 0xA01C))) // Station management control and address
#define CAMEN           (*((volatile unsigned int *) (SFR_BASE + 0xA028))) // CAM enable register
#define EMISSCNT        (*((volatile unsigned int *) (SFR_BASE + 0xA03C))) // Missed error count register
#define EPZCNT          (*((volatile unsigned int *) (SFR_BASE + 0xA040))) // Pause count register
#define ERMPZCNT        (*((volatile unsigned int *) (SFR_BASE + 0xA044))) // Remote pause count register
#define ETXSTAT         (*((volatile unsigned int *) (SFR_BASE + 0x9040))) // Transmit control frame status


/*
** HDLC Channel A
*/

#define HMODE_A         (*((volatile unsigned int *) (SFR_BASE + 0x7000))) // Mode register
#define HCON_A          (*((volatile unsigned int *) (SFR_BASE + 0x7004))) // Control register
#define HSTAT_A         (*((volatile unsigned int *) (SFR_BASE + 0x7008))) // Status register
#define HINTEN_A        (*((volatile unsigned int *) (SFR_BASE + 0x700C))) // Interrupt enable register
#define HTXFIFOC_A      (*((volatile unsigned int *) (SFR_BASE + 0x7010))) // TxFIFO frame continue register
#define HTXFIFOT_A      (*((volatile unsigned int *) (SFR_BASE + 0x7014))) // TxFIFO frame terminate register
#define HRXFIFO_A       (*((volatile unsigned int *) (SFR_BASE + 0x7018))) // RxFIFO entry register
#define HBRGTC_A        (*((volatile unsigned int *) (SFR_BASE + 0x701C))) // Baud rate generate time constant
#define HPRMB_A         (*((volatile unsigned int *) (SFR_BASE + 0x7020))) // Preamble constant
#define HSAR0_A         (*((volatile unsigned int *) (SFR_BASE + 0x7024))) // Station address 0
#define HSAR1_A         (*((volatile unsigned int *) (SFR_BASE + 0x7028))) // Station address 1
#define HSAR2_A         (*((volatile unsigned int *) (SFR_BASE + 0x702C))) // Station address 2
#define HSAR3_A         (*((volatile unsigned int *) (SFR_BASE + 0x7030))) // Station address 3
#define HMASK_A         (*((volatile unsigned int *) (SFR_BASE + 0x7034))) // Mask register
#define DMATxPTR_A      (*((volatile unsigned int *) (SFR_BASE + 0x7038))) // DMA Tx buffer descriptor pointer
#define DMARxPTR_A      (*((volatile unsigned int *) (SFR_BASE + 0x703C))) // DMA Rx buffer descriptor pointer
#define HMFLR_A         (*((volatile unsigned int *) (SFR_BASE + 0x7040))) // Maximum frame length register
#define HRBSR_A         (*((volatile unsigned int *) (SFR_BASE + 0x7040))) // DMA receive buffer size register
#define HSYNC_A         (*((volatile unsigned int *) (SFR_BASE + 0x7048))) // HDLC Sync Register


/*
** HDLC Channel B
*/

#define HMODE_B         (*((volatile unsigned int *) (SFR_BASE + 0x8000))) // Mode register
#define HCON_B          (*((volatile unsigned int *) (SFR_BASE + 0x8004))) // Control register
#define HSTAT_B         (*((volatile unsigned int *) (SFR_BASE + 0x8008))) // Status register
#define HINTEN_B        (*((volatile unsigned int *) (SFR_BASE + 0x800C))) // Interrupt enable register
#define HTXFIFOC_B      (*((volatile unsigned int *) (SFR_BASE + 0x8010))) // TxFIFO frame continue register
#define HTXFIFOT_B      (*((volatile unsigned int *) (SFR_BASE + 0x8014))) // TxFIFO frame terminate register
#define HRXFIFO_B       (*((volatile unsigned int *) (SFR_BASE + 0x8018))) // RxFIFO entry register
#define HBRGTC_B        (*((volatile unsigned int *) (SFR_BASE + 0x801C))) // Baud rate generate time constant
#define HPRMB_B         (*((volatile unsigned int *) (SFR_BASE + 0xA020))) // Preamble constant
#define HSAR0_B         (*((volatile unsigned int *) (SFR_BASE + 0x8024))) // Station address 0
#define HSAR1_B         (*((volatile unsigned int *) (SFR_BASE + 0x8028))) // Station address 1
#define HSAR2_B         (*((volatile unsigned int *) (SFR_BASE + 0x802C))) // Station address 2
#define HSAR3_B         (*((volatile unsigned int *) (SFR_BASE + 0x8030))) // Station address 3
#define HMASK_B         (*((volatile unsigned int *) (SFR_BASE + 0x8034))) // Mask register
#define DMATxPTR_B      (*((volatile unsigned int *) (SFR_BASE + 0x8038))) // DMA Tx buffer descriptor pointer
#define DMARxPTR_B      (*((volatile unsigned int *) (SFR_BASE + 0x803C))) // DMA Rx buffer descriptor pointer
#define HMFLR_B         (*((volatile unsigned int *) (SFR_BASE + 0x8040))) // Maximum frame length register
#define HRBSR_B         (*((volatile unsigned int *) (SFR_BASE + 0x8044))) // DMA receive buffer size register
#define HSYNC_B         (*((volatile unsigned int *) (SFR_BASE + 0x8048))) // HDLC Sync Register
#define TCON_B          (*((volatile unsigned int *) (SFR_BASE + 0x804C))) // Transparent Control Register


/*
** I/O Ports
*/

#define IOPMOD          (*((volatile unsigned int *) (SFR_BASE + 0x5000))) // I/O port mode register
#define IOPCON          (*((volatile unsigned int *) (SFR_BASE + 0x5004))) // I/O port control register
#define IOPDATA         (*((volatile unsigned int *) (SFR_BASE + 0x5008))) // Input port data register


/*
** Interrupt Controller
*/

#define INTMOD          (*((volatile unsigned int *) (SFR_BASE + 0x4000))) // Interrupt mode register
#define INTPND          (*((volatile unsigned int *) (SFR_BASE + 0x4004))) // Interrupt pending register
#define INTMSK          (*((volatile unsigned int *) (SFR_BASE + 0x4008))) // Interrupt mask register
#define INTPRI0         (*((volatile unsigned int *) (SFR_BASE + 0x400C))) // Interrupt priority register 0
#define INTPRI1         (*((volatile unsigned int *) (SFR_BASE + 0x4010))) // Interrupt priority register 1
#define INTPRI2         (*((volatile unsigned int *) (SFR_BASE + 0x4014))) // Interrupt priority register 2
#define INTPRI3         (*((volatile unsigned int *) (SFR_BASE + 0x4018))) // Interrupt priority register 3
#define INTPRI4         (*((volatile unsigned int *) (SFR_BASE + 0x401C))) // Interrupt priority register 4
#define INTPRI5         (*((volatile unsigned int *) (SFR_BASE + 0x4020))) // Interrupt priority register 5
#define INTOFFSET       (*((volatile unsigned int *) (SFR_BASE + 0x4024))) // Interrupt offset address register
#define INTOSET_FIQ     (*((volatile unsigned int *) (SFR_BASE + 0x4030))) // FIQ interrupt offset register
#define INTOSET_IRQ     (*((volatile unsigned int *) (SFR_BASE + 0x4034))) // IRQ interrupt offset register


/*
** I2C Bus
*/

#define IICCON          (*((volatile unsigned int *) (SFR_BASE + 0XF000))) // I2C bus control status register
#define IICBUF          (*((volatile unsigned int *) (SFR_BASE + 0xF004))) // I2C bus shift buffer register
#define IICPS           (*((volatile unsigned int *) (SFR_BASE + 0xF008))) // I2C bus prescaler register
#define IICCOUNT        (*((volatile unsigned int *) (SFR_BASE + 0xF00C))) // I2C bus prescaler counter register


/*
** GDMA
*/

#define GDMACON0        (*((volatile unsigned int *) (SFR_BASE + 0xB000))) // GDMA control register 0
#define GDMASRC0        (*((volatile unsigned int *) (SFR_BASE + 0xB004))) // GDMA source address register 0
#define GDMADST0        (*((volatile unsigned int *) (SFR_BASE + 0xB008))) // GDMA destination address register 0
#define GDMACNT0        (*((volatile unsigned int *) (SFR_BASE + 0xB00C))) // GDMA transfer count register 0

#define GDMACON1        (*((volatile unsigned int *) (SFR_BASE + 0xC000))) // GDMA control register 1
#define GDMASRC1        (*((volatile unsigned int *) (SFR_BASE + 0xC004))) // GDMA source address register 1
#define GDMADST1        (*((volatile unsigned int *) (SFR_BASE + 0xC008))) // GDMA destination address register 1
#define GDMACNT1        (*((volatile unsigned int *) (SFR_BASE + 0xC00C))) // GDMA transfer count register 1


/*
** UART
*/

#define ULCON0          (*((volatile unsigned int *) (SFR_BASE + 0xD000))) // Line control register 0
#define UCON0           (*((volatile unsigned int *) (SFR_BASE + 0xD004))) // Control register 0
#define USTAT0          (*((volatile unsigned int *) (SFR_BASE + 0xD008))) // Status register 0
#define UTXBUF0         (*((volatile unsigned int *) (SFR_BASE + 0xD00C))) // Transmit holding register 0
#define URXBUF0         (*((volatile unsigned int *) (SFR_BASE + 0xD010))) // Receive buffer register 0
#define UBRDIV0         (*((volatile unsigned int *) (SFR_BASE + 0xD014))) // Baud rate divisor register 0
#define UCC1_0          (*((volatile unsigned int *) (SFR_BASE + 0xD018))) // 1st Control Character register 0
#define UCC2_0          (*((volatile unsigned int *) (SFR_BASE + 0xD01C))) // 2nd Control Character register 0

#define ULCON1          (*((volatile unsigned int *) (SFR_BASE + 0xE000))) // Line control register 1
#define UCON1           (*((volatile unsigned int *) (SFR_BASE + 0xE004))) // Control register 1
#define USTAT1          (*((volatile unsigned int *) (SFR_BASE + 0xE008))) // Status register 1
#define UTXBUF1         (*((volatile unsigned int *) (SFR_BASE + 0xE00C))) // Transmit holding register 1
#define URXBUF1         (*((volatile unsigned int *) (SFR_BASE + 0xE010))) // Receive buffer register 1
#define UBRDIV1         (*((volatile unsigned int *) (SFR_BASE + 0xE014))) // Baud rate divisor register 1
#define UCC1_1          (*((volatile unsigned int *) (SFR_BASE + 0xE018))) // 1st Control Character register 1
#define UCC2_1          (*((volatile unsigned int *) (SFR_BASE + 0xE01C))) // 2nd Control Character register 1


/*
** Timers
*/

#define TMOD            (*((volatile unsigned int *) (SFR_BASE + 0x6000))) // Timer mode register
#define TDATA0          (*((volatile unsigned int *) (SFR_BASE + 0x6004))) // Timer 0 data register
#define TDATA1          (*((volatile unsigned int *) (SFR_BASE + 0x6008))) // Timer 1 data register
#define TCNT0           (*((volatile unsigned int *) (SFR_BASE + 0x600C))) // Timer 0 count register
#define TCNT1           (*((volatile unsigned int *) (SFR_BASE + 0x6010))) // Timer 1 count register


#endif   /* _S3C4530A_H */
