/**************************************************************************
**                                                                        *
**  FILE        :  s3c44b0.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C44B0        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C44B0_H
#define _S3C44B0_H


#ifdef __BIG_ENDIAN__
#define BIG_END_CHAR_OFF        3
#define BIG_END_HW_OFF          2
#else
#define BIG_END_CHAR_OFF        0
#define BIG_END_HW_OFF          0
#endif


/*
** CPU WRAPPER
*/

#define SYSCFG          	(*((volatile unsigned int  *) 0x01c00000)) // System Configuration
#define NCACHBE0        	(*((volatile unsigned int  *) 0x01c00004)) // Non Cacheable Area 0
#define NCACHBE1        	(*((volatile unsigned int  *) 0x01c00008)) // Non Cacheable Area 1
#define SBUSCON         	(*((volatile unsigned int  *) 0x01c40000)) // System Bus Control


/*
** MEMORY CONTROLLER
*/

#define BWSCON          	(*((volatile unsigned int  *) 0x01c80000)) // Bus Width & Wait Status Control
#define BANKCON0        	(*((volatile unsigned int  *) 0x01c80004)) // Boot ROM Control
#define BANKCON1        	(*((volatile unsigned int  *) 0x01c80008)) // BANK1 Control
#define BANKCON2        	(*((volatile unsigned int  *) 0x01c8000c)) // BANK2 Control
#define BANKCON3        	(*((volatile unsigned int  *) 0x01c80010)) // BANK3 Control
#define BANKCON4        	(*((volatile unsigned int  *) 0x01c80014)) // BANK4 Control
#define BANKCON5        	(*((volatile unsigned int  *) 0x01c80018)) // BANK5 Control
#define BANKCON6        	(*((volatile unsigned int  *) 0x01c8001c)) // BANK6 Control
#define BANKCON7        	(*((volatile unsigned int  *) 0x01c80020)) // BANK7 Control
#define REFRESH         	(*((volatile unsigned int  *) 0x01c80024)) // DRAM/SDRAM Refresh Control
#define BANKSIZE        	(*((volatile unsigned int  *) 0x01c80028)) // Flexible Bank Size
#define MRSRB6          	(*((volatile unsigned int  *) 0x01c8002c)) // Mode register set for SDRAM
#define MRSRB7          	(*((volatile unsigned int  *) 0x01c80030)) // Mode register set for SDRAM


/*
** UART
*/

#define ULCON0          	(*((volatile unsigned int  *) 0x01d00000)) // UART 0 Line Control
#define UCON0           	(*((volatile unsigned int  *) 0x01d00004)) // UART 0 Control
#define UFCON0          	(*((volatile unsigned int  *) 0x01d00008)) // UART 0 FIFO Control
#define UMCON0          	(*((volatile unsigned int  *) 0x01d0000c)) // UART 0 Modem Control
#define UTRSTAT0        	(*((volatile unsigned int  *) 0x01d00010)) // UART 0 Tx/Rx Status
#define UERSTAT0        	(*((volatile unsigned int  *) 0x01d00014)) // UART 0 Rx Error Status
#define UFSTAT0         	(*((volatile unsigned int  *) 0x01d00018)) // UART 0 FIFO Status
#define UMSTAT0         	(*((volatile unsigned int  *) 0x01d0001c)) // UART 0 Modem Status
#define UTXH0           	(*((volatile unsigned char *)(0x01d00020 + BIG_END_CHAR_OFF))) // UART 0 Transmission Hold
#define URXH0           	(*((volatile unsigned char *)(0x01d00024 + BIG_END_CHAR_OFF))) // UART 0 Receive Buffer
#define UBRDIV0         	(*((volatile unsigned int  *) 0x01d00028)) // UART 0 Baud Rate Divisor

#define ULCON1          	(*((volatile unsigned int  *) 0x01d04000)) // UART 1 Line Control
#define UCON1           	(*((volatile unsigned int  *) 0x01d04004)) // UART 1 Control
#define UFCON1          	(*((volatile unsigned int  *) 0x01d04008)) // UART 1 FIFO Control
#define UMCON1          	(*((volatile unsigned int  *) 0x01d0400c)) // UART 1 Modem Control
#define UTRSTAT1        	(*((volatile unsigned int  *) 0x01d04010)) // UART 1 Tx/Rx Status
#define UERSTAT1        	(*((volatile unsigned int  *) 0x01d04014)) // UART 1 Rx Error Status
#define UFSTAT1         	(*((volatile unsigned int  *) 0x01d04018)) // UART 1 FIFO Status
#define UMSTAT1         	(*((volatile unsigned int  *) 0x01d0401c)) // UART 1 Modem Status
#define UTXH1           	(*((volatile unsigned char *)(0x01d04020 + BIG_END_CHAR_OFF))) // UART 1 Transmission Hold
#define URXH1           	(*((volatile unsigned char *)(0x01d04024 + BIG_END_CHAR_OFF))) // UART 1 Receive Buffer
#define UBRDIV1         	(*((volatile unsigned int  *) 0x01d04028)) // UART 1 Baud Rate Divisor


/*
** SIO
*/

#define SIOCON          	(*((volatile unsigned int  *) 0x01d14000)) // SIO Control
#define SIODAT          	(*((volatile unsigned int  *) 0x01d14004)) // SIO Data
#define SBRDR           	(*((volatile unsigned int  *) 0x01d14008)) // SIO Baud Rate Prescaler
#define ITVCNT          	(*((volatile unsigned int  *) 0x01d1400c)) // SIO Interval Counter
#define DCNTZ           	(*((volatile unsigned int  *) 0x01d14010)) // SIO DMA Count Zero


/*
** IIS
*/

#define IISCON          	(*((volatile unsigned int  *) 0x01d18000)) // IIS Control
#define IISMOD          	(*((volatile unsigned int  *) 0x01d18004)) // IIS Mode
#define IISPSR          	(*((volatile unsigned int  *) 0x01d18008)) // IIS Prescaler
#define IISFIFCON       	(*((volatile unsigned int  *) 0x01d1800c)) // IIS FIFO Control
#define IISFIF          	(*((volatile unsigned short*)(0x01d18010 + BIG_END_HW_OFF))) // IIS FIFO Entry


/*
** I/O PORT
*/

#define PCONA           	(*((volatile unsigned int  *) 0x01d20000)) // Port A Control
#define PDATA           	(*((volatile unsigned int  *) 0x01d20004)) // Port A Data
#define PCONB           	(*((volatile unsigned int  *) 0x01d20008)) // Port B Control
#define PDATB           	(*((volatile unsigned int  *) 0x01d2000c)) // Port B Data
#define PCONC           	(*((volatile unsigned int  *) 0x01d20010)) // Port C Control
#define PDATC           	(*((volatile unsigned int  *) 0x01d20014)) // Port C Data
#define PUPC            	(*((volatile unsigned int  *) 0x01d20018)) // Pull-up Control C
#define PCOND           	(*((volatile unsigned int  *) 0x01d2001c)) // Port D Control
#define PDATD           	(*((volatile unsigned int  *) 0x01d20020)) // Port D Data
#define PUPD            	(*((volatile unsigned int  *) 0x01d20024)) // Pull-up Control D
#define PCONE           	(*((volatile unsigned int  *) 0x01d20028)) // Port E Control
#define PDATE           	(*((volatile unsigned int  *) 0x01d2002c)) // Port E Data
#define PUPE            	(*((volatile unsigned int  *) 0x01d20030)) // Pull-up Control E
#define PCONF           	(*((volatile unsigned int  *) 0x01d20034)) // Port F Control
#define PDATF           	(*((volatile unsigned int  *) 0x01d20038)) // Port F Data
#define PUPF            	(*((volatile unsigned int  *) 0x01d2003c)) // Pull-up Control F
#define PCONG           	(*((volatile unsigned int  *) 0x01d20040)) // Port G Control
#define PDATG           	(*((volatile unsigned int  *) 0x01d20044)) // Port G Data
#define PUPG            	(*((volatile unsigned int  *) 0x01d20048)) // Pull-up Control G
#define SPUCR           	(*((volatile unsigned int  *) 0x01d2004c)) // Special Pull-up
#define EXTINT          	(*((volatile unsigned int  *) 0x01d20050)) // External Interrupt Control
#define EXTINPND        	(*((volatile unsigned int  *) 0x01d20054)) // External Interrupt Pending


/*
** WATCHDOG TIMER
*/

#define WTCON           	(*((volatile unsigned int  *) 0x01d30000)) // Watchdog Timer Mode
#define WTDAT           	(*((volatile unsigned int  *) 0x01d30004)) // Watchdog Timer Data
#define WTCNT           	(*((volatile unsigned int  *) 0x01d30008)) // Watchdog Timer Count


/*
** A/D CONVERTER
*/

#define ADCCON          	(*((volatile unsigned int  *) 0x01d40000)) // ADC Control
#define ADCPSR          	(*((volatile unsigned int  *) 0x01d40004)) // ADC Prescaler
#define ADCDAT          	(*((volatile unsigned int  *) 0x01d40008)) // Digitized 10 bit Data


/*
** PWM TIMER
*/

#define TCFG0           	(*((volatile unsigned int  *) 0x01d50000)) // Timer Configuration 0
#define TCFG1           	(*((volatile unsigned int  *) 0x01d50004)) // Timer Configuration 1
#define TCON            	(*((volatile unsigned int  *) 0x01d50008)) // Timer Control
#define TCNTB0          	(*((volatile unsigned int  *) 0x01d5000c)) // Timer Count Buffer 0
#define TCMPB0          	(*((volatile unsigned int  *) 0x01d50010)) // Timer Compare Buffer 0
#define TCNTO0          	(*((volatile unsigned int  *) 0x01d50014)) // Timer Count Observation 0
#define TCNTB1          	(*((volatile unsigned int  *) 0x01d50018)) // Timer Count Buffer 1
#define TCMPB1          	(*((volatile unsigned int  *) 0x01d5001c)) // Timer Compare Buffer 1
#define TCNTO1          	(*((volatile unsigned int  *) 0x01d50020)) // Timer Count Observation 1
#define TCNTB2          	(*((volatile unsigned int  *) 0x01d50024)) // Timer Count Buffer 2
#define TCMPB2          	(*((volatile unsigned int  *) 0x01d50028)) // Timer Compare Buffer 2
#define TCNTO2          	(*((volatile unsigned int  *) 0x01d5002c)) // Timer Count Observation 2
#define TCNTB3          	(*((volatile unsigned int  *) 0x01d50030)) // Timer Count Buffer 3
#define TCMPB3          	(*((volatile unsigned int  *) 0x01d50034)) // Timer Compare Buffer 3
#define TCNTO3          	(*((volatile unsigned int  *) 0x01d50038)) // Timer Count Observation 3
#define TCNTB4          	(*((volatile unsigned int  *) 0x01d5003c)) // Timer Count Buffer 4
#define TCMPB4          	(*((volatile unsigned int  *) 0x01d50040)) // Timer Compare Buffer 4
#define TCNTO4          	(*((volatile unsigned int  *) 0x01d50044)) // Timer Count Observation 4
#define TCNTB5          	(*((volatile unsigned int  *) 0x01d50048)) // Timer Count Buffer 5
#define TCNTO5          	(*((volatile unsigned int  *) 0x01d5004c)) // Timer Count Observation 5


/*
** IIC
*/

#define IICCON          	(*((volatile unsigned int  *) 0x01d60000)) // IIC Control
#define IICSTAT         	(*((volatile unsigned int  *) 0x01d60004)) // IIC Status
#define IICADD          	(*((volatile unsigned int  *) 0x01d60008)) // IIC Address
#define IICDS           	(*((volatile unsigned int  *) 0x01d6000c)) // IIC Data Shift


/*
** RTC
*/

#define RTCCON          	(*((volatile unsigned char *)(0x01d70040 + BIG_END_CHAR_OFF))) // RTC Control
#define RTCALM          	(*((volatile unsigned char *)(0x01d70050 + BIG_END_CHAR_OFF))) // RTC Alarm
#define ALMSEC          	(*((volatile unsigned char *)(0x01d70054 + BIG_END_CHAR_OFF))) // Alarm Second
#define ALMMIN          	(*((volatile unsigned char *)(0x01d70058 + BIG_END_CHAR_OFF))) // Alarm Minute
#define ALMHOUR         	(*((volatile unsigned char *)(0x01d7005c + BIG_END_CHAR_OFF))) // Alarm Hour
#define ALMDAY          	(*((volatile unsigned char *)(0x01d70060 + BIG_END_CHAR_OFF))) // Alarm Day
#define ALMMON          	(*((volatile unsigned char *)(0x01d70064 + BIG_END_CHAR_OFF))) // Alarm Month
#define ALMYEAR         	(*((volatile unsigned char *)(0x01d70068 + BIG_END_CHAR_OFF))) // Alarm Year
#define RTCRST          	(*((volatile unsigned char *)(0x01d7006c + BIG_END_CHAR_OFF))) // RTC Round Reset
#define BCDSEC          	(*((volatile unsigned char *)(0x01d70070 + BIG_END_CHAR_OFF))) // BCD Second
#define BCDMIN          	(*((volatile unsigned char *)(0x01d70074 + BIG_END_CHAR_OFF))) // BCD Minute
#define BCDHOUR         	(*((volatile unsigned char *)(0x01d70078 + BIG_END_CHAR_OFF))) // BCD Hour
#define BCDDAY          	(*((volatile unsigned char *)(0x01d7007c + BIG_END_CHAR_OFF))) // BCD Day
#define BCDDATE         	(*((volatile unsigned char *)(0x01d70080 + BIG_END_CHAR_OFF))) // BCD Date
#define BCDMON          	(*((volatile unsigned char *)(0x01d70084 + BIG_END_CHAR_OFF))) // BCD Month
#define BCDYEAR         	(*((volatile unsigned char *)(0x01d70088 + BIG_END_CHAR_OFF))) // BCD Year
#define TICINT          	(*((volatile unsigned char *)(0x01D7008C + BIG_END_CHAR_OFF))) // Tick time count


/*
** CLOCK & POWER MANAGEMENT
*/

#define PLLCON          	(*((volatile unsigned int  *) 0x01d80000)) // PLL Control
#define CLKCON          	(*((volatile unsigned int  *) 0x01d80004)) // Clock Control
#define CLKSLOW         	(*((volatile unsigned int  *) 0x01d80008)) // Slow clock Control
#define LOCKTIME        	(*((volatile unsigned int  *) 0x01d8000c)) // PLL lock time Counter


/*
** INTERRUPT CONTROLLER
*/

#define INTCON          	(*((volatile unsigned int  *) 0x01e00000)) // Interrupt Control
#define INTPND          	(*((volatile unsigned int  *) 0x01e00004)) // Interrupt Request Status
#define INTMOD          	(*((volatile unsigned int  *) 0x01e00008)) // Interrupt Mode Control
#define INTMSK          	(*((volatile unsigned int  *) 0x01e0000c)) // Interrupt Mask Control
#define I_PSLV          	(*((volatile unsigned int  *) 0x01e00010)) // IRQ Interrupt Previous Slave
#define I_PMST          	(*((volatile unsigned int  *) 0x01e00014)) // IRQ Interrupt Priority Master
#define I_CSLV          	(*((volatile unsigned int  *) 0x01e00018)) // IRQ Interrupt Current Slave
#define I_CMST          	(*((volatile unsigned int  *) 0x01e0001c)) // IRQ Interrupt Current Master
#define I_ISPR          	(*((volatile unsigned int  *) 0x01e00020)) // IRQ Interrupt Pending Status
#define I_ISPC          	(*((volatile unsigned int  *) 0x01e00024)) // IRQ Interrupt Pending Clear
#define F_ISPR          	(*((volatile unsigned int  *) 0x01e00038)) // FIQ Interrupt Pending
#define F_ISPC          	(*((volatile unsigned int  *) 0x01e0003c)) // FIQ Interrupt Pending Clear


/*
** LCD CONTROLLER
*/

#define LCDCON1         	(*((volatile unsigned int  *) 0x01f00000)) // LCD Control 1
#define LCDCON2         	(*((volatile unsigned int  *) 0x01f00004)) // LCD Control 2
#define LCDCON3         	(*((volatile unsigned int  *) 0x01f00040)) // LCD Control 3
#define LCDSADDR1       	(*((volatile unsigned int  *) 0x01f00008)) // Frame Upper Buffer Start Address 1
#define LCDSADDR2       	(*((volatile unsigned int  *) 0x01f0000c)) // Frame Lower Buffer Start Address 2
#define LCDSADDR3       	(*((volatile unsigned int  *) 0x01f00010)) // Virtual Screen Address
#define REDLUT          	(*((volatile unsigned int  *) 0x01f00014)) // RED Lookup Table
#define GREENLUT        	(*((volatile unsigned int  *) 0x01f00018)) // GREEN Lookup Table
#define BLUELUT         	(*((volatile unsigned int  *) 0x01f0001c)) // BLUE Lookup Table
#define DP1_2           	(*((volatile unsigned int  *) 0x01f00020)) // Dithering Pattern duty 1/2
#define DP4_7           	(*((volatile unsigned int  *) 0x01f00024)) // Dithering Pattern duty 4/7
#define DP3_5           	(*((volatile unsigned int  *) 0x01f00028)) // Dithering Pattern duty 3/5
#define DP2_3           	(*((volatile unsigned int  *) 0x01f0002c)) // Dithering Pattern duty 2/3
#define DP5_7           	(*((volatile unsigned int  *) 0x01f00030)) // Dithering Pattern duty 5/7
#define DP3_4           	(*((volatile unsigned int  *) 0x01f00034)) // Dithering Pattern duty 3/4
#define DP4_5           	(*((volatile unsigned int  *) 0x01f00038)) // Dithering Pattern duty 4/5
#define DP6_7           	(*((volatile unsigned int  *) 0x01f0003c)) // Dithering Pattern duty 6/7
#define DITHMODE        	(*((volatile unsigned int  *) 0x01f00044)) // Dithering Mode


/*
** DMA
*/

#define ZDCON0          	(*((volatile unsigned int  *) 0x01e80000)) // ZDMA 0 Control
#define ZDISRC0         	(*((volatile unsigned int  *) 0x01e80004)) // ZDMA 0 Initial Source Address
#define ZDIDES0         	(*((volatile unsigned int  *) 0x01e80008)) // ZDMA 0 Initial Destination Address
#define ZDICNT0         	(*((volatile unsigned int  *) 0x01e8000c)) // ZDMA 0 Initial Transfer Count
#define ZDCSRC0         	(*((volatile unsigned int  *) 0x01e80010)) // ZDMA 0 Current Source Address
#define ZDCDES0         	(*((volatile unsigned int  *) 0x01e80014)) // ZDMA 0 Current Destination Address
#define ZDCCNT0         	(*((volatile unsigned int  *) 0x01e80018)) // ZDMA 0 Current Transfer Count

#define ZDCON1          	(*((volatile unsigned int  *) 0x01e80020)) // ZDMA 1 Control
#define ZDISRC1         	(*((volatile unsigned int  *) 0x01e80024)) // ZDMA 1 Initial Source Address
#define ZDIDES1         	(*((volatile unsigned int  *) 0x01e80028)) // ZDMA 1 Initial Destination Address
#define ZDICNT1         	(*((volatile unsigned int  *) 0x01e8002c)) // ZDMA 1 Initial Transfer Count
#define ZDCSRC1         	(*((volatile unsigned int  *) 0x01e80030)) // ZDMA 1 Current Source Address
#define ZDCDES1         	(*((volatile unsigned int  *) 0x01e80034)) // ZDMA 1 Current Destination Address
#define ZDCCNT1         	(*((volatile unsigned int  *) 0x01e80038)) // ZDMA 1 Current Transfer Count

#define BDCON0          	(*((volatile unsigned int  *) 0x01f80000)) // BDMA 0 Control
#define BDISRC0         	(*((volatile unsigned int  *) 0x01f80004)) // BDMA 0 Initial Source Address
#define BDIDES0         	(*((volatile unsigned int  *) 0x01f80008)) // BDMA 0 Initial Destination Address
#define BDICNT0         	(*((volatile unsigned int  *) 0x01f8000c)) // BDMA 0 Initial Transfer Count
#define BDCSRC0         	(*((volatile unsigned int  *) 0x01f80010)) // BDMA 0 Current Source Address
#define BDCDES0         	(*((volatile unsigned int  *) 0x01f80014)) // BDMA 0 Current Destination Address
#define BDCCNT0         	(*((volatile unsigned int  *) 0x01f80018)) // BDMA 0 Current Transfer Count

#define BDCON1          	(*((volatile unsigned int  *) 0x01f80020)) // BDMA 1 Control
#define BDISRC1         	(*((volatile unsigned int  *) 0x01f80024)) // BDMA 1 Initial Source Address
#define BDIDES1         	(*((volatile unsigned int  *) 0x01f80028)) // BDMA 1 Initial Destination Address
#define BDICNT1         	(*((volatile unsigned int  *) 0x01f8002c)) // BDMA 1 Initial Transfer Count
#define BDCSRC1         	(*((volatile unsigned int  *) 0x01f80030)) // BDMA 1 Current Source Address
#define BDCDES1         	(*((volatile unsigned int  *) 0x01f80034)) // BDMA 1 Current Destination Address
#define BDCCNT1         	(*((volatile unsigned int  *) 0x01f80038)) // BDMA 1 Current Transfer Count


#endif   /* _S3C44B0_H */
