/**************************************************************************
**                                                                        *
**  FILE        :  s3c3410.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C3410        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C3410_H
#define _S3C3410_H


#define SFR_BASE (0x07ff0000)


/*
** System Manager 
*/

#define SYSCFG          (*((volatile unsigned int  *) (SFR_BASE + 0x1000))) // System Configuration Register
#define BANKCON0        (*((volatile unsigned int  *) (SFR_BASE + 0x2000))) // Memory Bank 0 Control Register
#define BANKCON1        (*((volatile unsigned int  *) (SFR_BASE + 0x2004))) // Memory Bank 1 Control Register
#define BANKCON2        (*((volatile unsigned int  *) (SFR_BASE + 0x2008))) // Memory Bank 2 Control Register
#define BANKCON3        (*((volatile unsigned int  *) (SFR_BASE + 0x200c))) // Memory Bank 3 Control Register
#define BANKCON4        (*((volatile unsigned int  *) (SFR_BASE + 0x2010))) // Memory Bank 4 Control Register
#define BANKCON5        (*((volatile unsigned int  *) (SFR_BASE + 0x2014))) // Memory Bank 5 Control Register
#define BANKCON6        (*((volatile unsigned int  *) (SFR_BASE + 0x2018))) // Memory Bank 6 Control Register
#define BANKCON7        (*((volatile unsigned int  *) (SFR_BASE + 0x201c))) // Memory Bank 7 Control Register
#define REFCON          (*((volatile unsigned int  *) (SFR_BASE + 0x2020))) // DRAM Refresh Control Register
#define EXTCON0         (*((volatile unsigned int  *) (SFR_BASE + 0x2030))) // Extra device control register 0
#define EXTCON1         (*((volatile unsigned int  *) (SFR_BASE + 0x2034))) // Extra device control register 1
#define EXTPORT         (*((volatile unsigned short*) (SFR_BASE + 0x203e))) // External port data register
#define EXTDAT0         (*((volatile unsigned short*) (SFR_BASE + 0x202c))) // Extra chip selection data register 0
#define EXTDAT1         (*((volatile unsigned short*) (SFR_BASE + 0x202e))) // Extra chip selection data register 1


/*
** DMA
*/

#define DMACON0         (*((volatile unsigned int  *) (SFR_BASE + 0x300c))) // DMA 0 control register
#define DMASRC0         (*((volatile unsigned int  *) (SFR_BASE + 0x3000))) // DMA 0 source address register
#define DMADST0         (*((volatile unsigned int  *) (SFR_BASE + 0x3004))) // DMA 0 destination address register
#define DMACNT0         (*((volatile unsigned int  *) (SFR_BASE + 0x3008))) // DMA 0 transfer count register

#define DMACON1         (*((volatile unsigned int  *) (SFR_BASE + 0x400c))) // DMA 1 Control Register
#define DMASRC1         (*((volatile unsigned int  *) (SFR_BASE + 0x4000))) // DMA 1 source address register
#define DMADST1         (*((volatile unsigned int  *) (SFR_BASE + 0x4004))) // DMA 1 destination address register
#define DMACNT1         (*((volatile unsigned int  *) (SFR_BASE + 0x4008))) // DMA 1 transfer count register


/*
** I/O Port
*/

#define PDAT0           (*((volatile unsigned char *) (SFR_BASE + 0xb000))) // Port 0 data register
#define PDAT1           (*((volatile unsigned char *) (SFR_BASE + 0xb001))) // Port 1 data register
#define PDAT2           (*((volatile unsigned char *) (SFR_BASE + 0xb002))) // Port 2 data register
#define PDAT3           (*((volatile unsigned char *) (SFR_BASE + 0xb003))) // Port 3 data register
#define PDAT4           (*((volatile unsigned char *) (SFR_BASE + 0xb004))) // Port 4 data register
#define PDAT5           (*((volatile unsigned char *) (SFR_BASE + 0xb005))) // Port 5 data register
#define PDAT6           (*((volatile unsigned char *) (SFR_BASE + 0xb006))) // Port 6 data register
#define PDAT7           (*((volatile unsigned char *) (SFR_BASE + 0xb007))) // Port 7 data register
#define PDAT8           (*((volatile unsigned char *) (SFR_BASE + 0xb008))) // Port 8 data register
#define PDAT9           (*((volatile unsigned char *) (SFR_BASE + 0xb009))) // Port 9 data register
#define P7BR            (*((volatile unsigned char *) (SFR_BASE + 0xb00b))) // Port 7 buffer register
#define PCON0           (*((volatile unsigned short*) (SFR_BASE + 0xb010))) // Port 0 control register
#define PCON1           (*((volatile unsigned short*) (SFR_BASE + 0xb012))) // Port 1 control register
#define PCON2           (*((volatile unsigned short*) (SFR_BASE + 0xb014))) // Port 2 control register
#define PCON3           (*((volatile unsigned short*) (SFR_BASE + 0xb016))) // Port 3 control register
#define PCON4           (*((volatile unsigned short*) (SFR_BASE + 0xb018))) // Port 4 control register
#define PCON5           (*((volatile unsigned int  *) (SFR_BASE + 0xb01c))) // Port 5 control register
#define PCON6           (*((volatile unsigned int  *) (SFR_BASE + 0xb020))) // Port 6 control register
#define PCON7           (*((volatile unsigned short*) (SFR_BASE + 0xb024))) // Port 7 control register
#define PCON8           (*((volatile unsigned char *) (SFR_BASE + 0xb026))) // Port 8 control register
#define PCON9           (*((volatile unsigned char *) (SFR_BASE + 0xb027))) // Port 9 control register
#define PUR0            (*((volatile unsigned char *) (SFR_BASE + 0xb028))) // Port 0 pull-up control register
#define PDR1            (*((volatile unsigned char *) (SFR_BASE + 0xb029))) // Port 1 pull-down control register
#define PUR2            (*((volatile unsigned char *) (SFR_BASE + 0xb02a))) // Port 2 pull-up control register
#define PUR3            (*((volatile unsigned char *) (SFR_BASE + 0xb02b))) // Port 3 pull-up control register
#define PDR4            (*((volatile unsigned char *) (SFR_BASE + 0xb02c))) // Port 4 pull-down control register
#define PUR5            (*((volatile unsigned char *) (SFR_BASE + 0xb02d))) // Port 5 pull-up control register
#define PUR6            (*((volatile unsigned char *) (SFR_BASE + 0xb02e))) // Port 6 pull-up control register
#define PUR7            (*((volatile unsigned char *) (SFR_BASE + 0xb02f))) // Port 7 pull-up control register
#define PUR8            (*((volatile unsigned char *) (SFR_BASE + 0xb03c))) // Port 8 pull-up control register
#define EINTPND         (*((volatile unsigned char *) (SFR_BASE + 0xb031))) // External interrupt pending register
#define EINTCON         (*((volatile unsigned short*) (SFR_BASE + 0xb032))) // External interrupt control register
#define EINTMOD         (*((volatile unsigned int  *) (SFR_BASE + 0xb034))) // External interrupt mode register


/*
** Timers
*/

#define TDAT0           (*((volatile unsigned short*) (SFR_BASE + 0x9000))) // Timer 0 data register
#define TPRE0           (*((volatile unsigned char *) (SFR_BASE + 0x9002))) // Timer 0 prescaler register
#define TCON0           (*((volatile unsigned char *) (SFR_BASE + 0x9003))) // Timer 0 control register
#define TCNT0           (*((volatile unsigned short*) (SFR_BASE + 0x9006))) // Timer 0 counter register

#define TDAT1           (*((volatile unsigned short*) (SFR_BASE + 0x9010))) // Timer 1 data register
#define TPRE1           (*((volatile unsigned char *) (SFR_BASE + 0x9012))) // Timer 1 prescaler register
#define TCON1           (*((volatile unsigned char *) (SFR_BASE + 0x9013))) // Timer 1 control register
#define TCNT1           (*((volatile unsigned short*) (SFR_BASE + 0x9016))) // Timer 1 counter register

#define TDAT2           (*((volatile unsigned short*) (SFR_BASE + 0x9020))) // Timer 2 data register
#define TPRE2           (*((volatile unsigned char *) (SFR_BASE + 0x9022))) // Timer 2 prescaler register
#define TCON2           (*((volatile unsigned char *) (SFR_BASE + 0x9023))) // Timer 2 control register
#define TCNT2           (*((volatile unsigned short*) (SFR_BASE + 0x9026))) // Timer 2 counter register

#define TDAT3           (*((volatile unsigned char *) (SFR_BASE + 0x9031))) // Timer 3 data register
#define TPRE3           (*((volatile unsigned char *) (SFR_BASE + 0x9032))) // Timer 3 prescaler register
#define TCON3           (*((volatile unsigned char *) (SFR_BASE + 0x9033))) // Timer 3 control register
#define TCNT3           (*((volatile unsigned char *) (SFR_BASE + 0x9037))) // Timer 3 counter register

#define TDAT4           (*((volatile unsigned char *) (SFR_BASE + 0x9041))) // Timer 4 data register
#define TPRE4           (*((volatile unsigned char *) (SFR_BASE + 0x9042))) // Timer 4 prescaler register
#define TCON4           (*((volatile unsigned char *) (SFR_BASE + 0x9043))) // Timer 4 control register
#define TCNT4           (*((volatile unsigned char *) (SFR_BASE + 0x9047))) // Timer 4 counter register
#define TFCON           (*((volatile unsigned char *) (SFR_BASE + 0x904f))) // FIFO control register of Timer 4
#define TFSTAT          (*((volatile unsigned char *) (SFR_BASE + 0x904e))) // FIFO status register of Timer 4
#define TFB4            (*((volatile unsigned char *) (SFR_BASE + 0x904b))) // Timer 4 FIFO register (byte)
#define TFHW4           (*((volatile unsigned short*) (SFR_BASE + 0x904a))) // Timer 4 FIFO register (half-word)
#define TFW4            (*((volatile unsigned int  *) (SFR_BASE + 0x9048))) // Timer 4 FIFO register (word)


/*
** UART
*/

#define ULCON           (*((volatile unsigned char *) (SFR_BASE + 0x5003))) // UART line control register
#define UCON            (*((volatile unsigned char *) (SFR_BASE + 0x5007))) // UART control register
#define USTAT           (*((volatile unsigned char *) (SFR_BASE + 0x500b))) // UART status register
#define UFCON           (*((volatile unsigned char *) (SFR_BASE + 0x500f))) // UART FIFO control register
#define UFSTAT          (*((volatile unsigned char *) (SFR_BASE + 0x5012))) // UART FIFO status register
#define UTXH            (*((volatile unsigned char *) (SFR_BASE + 0x5017))) // UART transmit holding register
#define UTXH_B          (*((volatile unsigned char *) (SFR_BASE + 0x5017))) // UART transmit FIFO register (byte)
#define UTXH_HW         (*((volatile unsigned short*) (SFR_BASE + 0x5016))) // UART transmit FIFO register (half-word)
#define UTXH_W          (*((volatile unsigned int  *) (SFR_BASE + 0x5014))) // UART transmit FIFO register (word)
#define URXH            (*((volatile unsigned char *) (SFR_BASE + 0x501b))) // UART receive buffer register
#define URXH_B          (*((volatile unsigned char *) (SFR_BASE + 0x501b))) // UART receive FIFO register (byte)
#define URXH_HW         (*((volatile unsigned short*) (SFR_BASE + 0x501a))) // UART receive FIFO register (half-word)
#define URXH_W          (*((volatile unsigned int  *) (SFR_BASE + 0x5018))) // UART receive FIFO register (word)
#define UBRDIV          (*((volatile unsigned short*) (SFR_BASE + 0x501e))) // UART baud rate divisor register


/*
** SIO 0
*/

#define ITVCNT0         (*((volatile unsigned char *) (SFR_BASE + 0x6000))) // SIO 0 interval counter register
#define SBRDR0          (*((volatile unsigned char *) (SFR_BASE + 0x6001))) // SIO 0 baud rate prescaler register
#define SIODAT0         (*((volatile unsigned char *) (SFR_BASE + 0x6002))) // SIO 0 data register
#define SIOCON0         (*((volatile unsigned char *) (SFR_BASE + 0x6003))) // SIO 0 control register


/*
** SIO 1
*/

#define ITVCNT1         (*((volatile unsigned char *) (SFR_BASE + 0x7000))) // SIO 1 interval counter register
#define SBRDR1          (*((volatile unsigned char *) (SFR_BASE + 0x7001))) // SIO 1 baud rate prescaler register
#define SIODAT1         (*((volatile unsigned char *) (SFR_BASE + 0x7002))) // SIO 1 data register
#define SIOCON1         (*((volatile unsigned char *) (SFR_BASE + 0x7003))) // SIO 1 control register


/*
** Interrupt
*/

#define INTMOD          (*((volatile unsigned int  *) (SFR_BASE + 0xc000))) // Interrupt mode register
#define INTPND          (*((volatile unsigned int  *) (SFR_BASE + 0xc004))) // Interrupt pending register
#define INTMSK          (*((volatile unsigned int  *) (SFR_BASE + 0xc008))) // Interrupt mask register
#define INTPRI0         (*((volatile unsigned int  *) (SFR_BASE + 0xc00c))) // Interrupt priority register 0
#define INTPRI1         (*((volatile unsigned int  *) (SFR_BASE + 0xc010))) // Interrupt priority register 1
#define INTPRI2         (*((volatile unsigned int  *) (SFR_BASE + 0xc014))) // Interrupt priority register 2
#define INTPRI3         (*((volatile unsigned int  *) (SFR_BASE + 0xc018))) // Interrupt priority register 3
#define INTPRI4         (*((volatile unsigned int  *) (SFR_BASE + 0xc01c))) // Interrupt priority register 4
#define INTPRI5         (*((volatile unsigned int  *) (SFR_BASE + 0xc020))) // Interrupt priority register 5
#define INTPRI6         (*((volatile unsigned int  *) (SFR_BASE + 0xc024))) // Interrupt priority register 6
#define INTPRI7         (*((volatile unsigned int  *) (SFR_BASE + 0xc028))) // Interrupt priority register 7


/*
** ADC
*/

#define ADCCON          (*((volatile unsigned short*) (SFR_BASE + 0x8002))) // A/D Converter control register
#define ADCDAT          (*((volatile unsigned short*) (SFR_BASE + 0x8006))) // A/D Converter data register


/*
** Basic Timer
*/

#define BTCON           (*((volatile unsigned short*) (SFR_BASE + 0xa002))) // Basic Timer control register
#define BTCNT           (*((volatile unsigned char *) (SFR_BASE + 0xa007))) // Basic Timer count register


/*
** IIC
*/

#define IICCON          (*((volatile unsigned char *) (SFR_BASE + 0xe000))) // IIC-bus control register
#define IICSTAT         (*((volatile unsigned char *) (SFR_BASE + 0xe001))) // IIC-bus status register
#define IICDS           (*((volatile unsigned char *) (SFR_BASE + 0xe002))) // IIC-Bus transmit/receive data shift register
#define IICADD          (*((volatile unsigned char *) (SFR_BASE + 0xe003))) // IIC-Bus transmit/receive address register
#define IICPS           (*((volatile unsigned char *) (SFR_BASE + 0xe004))) // IIC-Bus Prescaler register
#define IICPCNT         (*((volatile unsigned char *) (SFR_BASE + 0xe005))) // IIC-Bus Prescaler Counter register


/*
** System Control Register
*/

#define SYSON           (*((volatile unsigned char *) (SFR_BASE + 0xd003))) // System control register


/*
** RTC
*/

#define RTCCON          (*((volatile unsigned char *) (SFR_BASE + 0xa013))) // RTC control register
#define RTCALM          (*((volatile unsigned char *) (SFR_BASE + 0xa012))) // RTC alarm control register
#define ALMSEC          (*((volatile unsigned char *) (SFR_BASE + 0xa033))) // Alarm second data register
#define ALMMIN          (*((volatile unsigned char *) (SFR_BASE + 0xa032))) // Alarm minute data register
#define ALMHOUR         (*((volatile unsigned char *) (SFR_BASE + 0xa031))) // Alarm hour data register
#define ALMDAY          (*((volatile unsigned char *) (SFR_BASE + 0xa037))) // Alarm day data register
#define ALMMON          (*((volatile unsigned char *) (SFR_BASE + 0xa036))) // Alarm month data register
#define ALMYEAR         (*((volatile unsigned char *) (SFR_BASE + 0xa035))) // Alarm year data register
#define BCDSEC          (*((volatile unsigned char *) (SFR_BASE + 0xa023))) // BCD second data register
#define BCDMIN          (*((volatile unsigned char *) (SFR_BASE + 0xa022))) // BCD minute data register
#define BCDHOUR         (*((volatile unsigned char *) (SFR_BASE + 0xa021))) // BCD hour data register
#define BCDDAY          (*((volatile unsigned char *) (SFR_BASE + 0xa027))) // BCD day data register
#define BCDDATE         (*((volatile unsigned char *) (SFR_BASE + 0xa020))) // BCD date data register
#define BCDMON          (*((volatile unsigned char *) (SFR_BASE + 0xa026))) // BCD month data register
#define BCDYEAR         (*((volatile unsigned char *) (SFR_BASE + 0xa025))) // BCD year data register
#define RINTPND         (*((volatile unsigned char *) (SFR_BASE + 0xa010))) // RTC time interrupt pending register
#define RINTCON         (*((volatile unsigned char *) (SFR_BASE + 0xa011))) // RTC time interrupt control register


#endif   /* _S3C3410_H */
