/**************************************************************************
**                                                                        *
**  FILE        :  s3c2510a.h                                             *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C2510A       *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C2510A_H
#define _S3C2510A_H


/*
** System Configuration Registers
*/

#define SYSCFG                  (*((volatile unsigned int *) 0xf0000000)) // System configuration register
#define PDCODE                  (*((volatile unsigned int *) 0xf0000004)) // Product code and revision number register
#define MISCREG                 (*((volatile unsigned int *) 0xf0000008)) // Miscellaneous register
#define PCLKDIS                 (*((volatile unsigned int *) 0xf000000c)) // Peripheral clock disable register
#define CLKST                   (*((volatile unsigned int *) 0xf0000010)) // Clock Status register
#define HPRIF                   (*((volatile unsigned int *) 0xf0000014)) // AHB bus master fixed priority register
#define HPRIR                   (*((volatile unsigned int *) 0xf0000018)) // AHB bus master round-robin priority register
#define CPLLCON                 (*((volatile unsigned int *) 0xf000001c)) // Core PLL Configuration Register
#define SPLLCON                 (*((volatile unsigned int *) 0xf0000020)) // PCI & PC Card PLL Configuration Register
#define UPLLCON                 (*((volatile unsigned int *) 0xf0000024)) // USB PLL Configuration Register
#define PPLLCON                 (*((volatile unsigned int *) 0xf0000028)) // PHY PLL Configuration Register


/*
** Ext. I/O Bank Controller Special Registers
*/

#define B0CON                   (*((volatile unsigned int *) 0xf0010000)) // Bank 0 control register
#define B1CON                   (*((volatile unsigned int *) 0xf0010004)) // Bank 1 control register
#define B2CON                   (*((volatile unsigned int *) 0xf0010008)) // Bank 2 control register
#define B3CON                   (*((volatile unsigned int *) 0xf001000c)) // Bank 3 control register
#define B4CON                   (*((volatile unsigned int *) 0xf0010010)) // Bank 4 control register
#define B5CON                   (*((volatile unsigned int *) 0xf0010014)) // Bank 5 control register
#define B6CON                   (*((volatile unsigned int *) 0xf0010018)) // Bank 6 control register
#define B7CON                   (*((volatile unsigned int *) 0xf001001c)) // Bank 7 control register
#define MUXBCON                 (*((volatile unsigned int *) 0xf0010020)) // Muxed bus control register
#define WAITCON                 (*((volatile unsigned int *) 0xf0010024)) // Wait control register
#define WDSCON                  (*((volatile unsigned int *) 0xf0010028)) // Wait data setup cycle control register


/*
** SDRAM Special Registers
*/

#define CFGREG                  (*((volatile unsigned int *) 0xf0020000)) // Configuration register
#define CMDREG                  (*((volatile unsigned int *) 0xf0020004)) // Command register
#define REFREG                  (*((volatile unsigned int *) 0xf0020008)) // Refresh timer register
#define WBTOREG                 (*((volatile unsigned int *) 0xf002000c)) // Write buffer time-out register


/*
** ETHERNET 0 Special Registers
*/

#define ETH0_BDMATXCONA         (*((volatile unsigned int *) 0xf00a0000)) // Buffered DMA transmit control register
#define ETH0_BDMARXCONA         (*((volatile unsigned int *) 0xf00a0004)) // Buffered DMA receive control register
#define ETH0_BDMATXDPTRA        (*((volatile unsigned int *) 0xf00a0008)) // Transmit buffer descriptor start address
#define ETH0_BDMARXDPTRA        (*((volatile unsigned int *) 0xf00a000c)) // Receive buffer descriptor start address
#define ETH0_BTXBDCNTA          (*((volatile unsigned int *) 0xf00a0010)) // BDMA Tx buffer descriptor counter
#define ETH0_BRXBDCNTA          (*((volatile unsigned int *) 0xf00a0014)) // BDMA Rx buffer descriptor counter
#define ETH0_BMTXINTENA         (*((volatile unsigned int *) 0xf00a0018)) // BDMA/MAC Tx Interrupt enable register
#define ETH0_BMRXINTENA         (*((volatile unsigned int *) 0xf00a001c)) // BDMA/MAC Rx Interrupt enable register
#define ETH0_BMTXSTATA          (*((volatile unsigned int *) 0xf00a0020)) // BDMA/MAC Tx Status register
#define ETH0_BMRXSTATA          (*((volatile unsigned int *) 0xf00a0024)) // BDMA/MAC Rx Status register
#define ETH0_BDMARXLENA         (*((volatile unsigned int *) 0xf00a0028)) // Receive Frame Size
#define ETH0_CFTXSTATA          (*((volatile unsigned int *) 0xf00a0030)) // Transmit control frame status
#define ETH0_MACCONA            (*((volatile unsigned int *) 0xf00b0000)) // MAC control
#define ETH0_CAMCONA            (*((volatile unsigned int *) 0xf00b0004)) // CAM control
#define ETH0_MACTXCONA          (*((volatile unsigned int *) 0xf00b0008)) // Transmit control
#define ETH0_MACTXSTATA         (*((volatile unsigned int *) 0xf00b000c)) // Transmit status
#define ETH0_MACRXCONA          (*((volatile unsigned int *) 0xf00b0010)) // Receive control
#define ETH0_MACRXSTATA         (*((volatile unsigned int *) 0xf00b0014)) // Receive status
#define ETH0_STADATAA           (*((volatile unsigned int *) 0xf00b0018)) // Station management data
#define ETH0_STACONA            (*((volatile unsigned int *) 0xf00b001c)) // Station management control and address
#define ETH0_CAMENA             (*((volatile unsigned int *) 0xf00b0028)) // CAM enable
#define ETH0_MISSCNTA           (*((volatile unsigned int *) 0xf00b003c)) // Missed error count
#define ETH0_PZCNTA             (*((volatile unsigned int *) 0xf00b0040)) // Pause count
#define ETH0_RMPZCNTA           (*((volatile unsigned int *) 0xf00b0044)) // Remote pause count
#define ETH0_CAMA               (*((volatile unsigned int *) 0xf00b0080)) // CAM content


/*
** ETHERNET 1 Special Registers
*/

#define ETH1_BDMATXCONB         (*((volatile unsigned int *) 0xf00c0000)) // Buffered DMA transmit control register
#define ETH1_BDMARXCONB         (*((volatile unsigned int *) 0xf00c0004)) // Buffered DMA receive control register
#define ETH1_BDMATXDPTRB        (*((volatile unsigned int *) 0xf00c0008)) // Transmit buffer descriptor start address
#define ETH1_BDMARXDPTRB        (*((volatile unsigned int *) 0xf00c000c)) // Receive buffer descriptor start address
#define ETH1_BTXBDCNTB          (*((volatile unsigned int *) 0xf00c0010)) // BDMA Tx buffer descriptor counter
#define ETH1_BRXBDCNTB          (*((volatile unsigned int *) 0xf00c0014)) // BDMA Rx buffer descriptor counter
#define ETH1_BMTXINTENB         (*((volatile unsigned int *) 0xf00c0018)) // BDMA/MAC Tx Interrupt enable register
#define ETH1_BMRXINTENB         (*((volatile unsigned int *) 0xf00c001c)) // BDMA/MAC Rx Interrupt enable register
#define ETH1_BMTXSTATB          (*((volatile unsigned int *) 0xf00c0020)) // BDMA/MAC Tx Status register
#define ETH1_BMRXSTATB          (*((volatile unsigned int *) 0xf00c0024)) // BDMA/MAC Rx Status register
#define ETH1_BDMARXLENB         (*((volatile unsigned int *) 0xf00c0028)) // Receive Frame Size
#define ETH1_CFTXSTATB          (*((volatile unsigned int *) 0xf00c0030)) // Transmit control frame status
#define ETH1_MACCONB            (*((volatile unsigned int *) 0xf00d0000)) // MAC control
#define ETH1_CAMCONB            (*((volatile unsigned int *) 0xf00d0004)) // CAM control
#define ETH1_MACTXCONB          (*((volatile unsigned int *) 0xf00d0008)) // Transmit control
#define ETH1_MACTXSTATB         (*((volatile unsigned int *) 0xf00d000c)) // Transmit status
#define ETH1_MACRXCONB          (*((volatile unsigned int *) 0xf00d0010)) // Receive control
#define ETH1_MACRXSTATB         (*((volatile unsigned int *) 0xf00d0014)) // Receive status
#define ETH1_CAMENB             (*((volatile unsigned int *) 0xf00d0028)) // CAM enable
#define ETH1_MISSCNTB           (*((volatile unsigned int *) 0xf00d003c)) // Missed error count
#define ETH1_PZCNTB             (*((volatile unsigned int *) 0xf00d0040)) // Pause count
#define ETH1_RMPZCNTB           (*((volatile unsigned int *) 0xf00d0044)) // Remote pause count
#define ETH1_CAMB               (*((volatile unsigned int *) 0xf00d0080)) // CAM content


/*
** SAR Configuration Register Summary
*/

#define SW_RESET                (*((volatile unsigned int *) 0xf0120000)) // Software reset
#define SAR_DB_ID               (*((volatile unsigned int *) 0xf0120004)) // SAR DB date and revision number register
#define GLOBAL_MODE             (*((volatile unsigned int *) 0xf0120008)) // Global mode register
#define TIMEOUT_BASE            (*((volatile unsigned int *) 0xf012000c)) // Base multiple for receive packet timeout
#define TX_READY1               (*((volatile unsigned int *) 0xf0120010)) // Transmit ready first packet or subpacket address
#define TX_READY2               (*((volatile unsigned int *) 0xf0120014)) // Transmit ready last packet or subpacket address
#define TX_DONE_ADDR            (*((volatile unsigned int *) 0xf0120018)) // Transmit packet done queue base address register
#define TX_DONE_SIZE            (*((volatile unsigned int *) 0xf012001c)) // Transmit packet done queue size register
#define RX_POOL0_ADDR           (*((volatile unsigned int *) 0xf0120020)) // Receive queue 0 base address register
#define RX_POOL0_SIZE           (*((volatile unsigned int *) 0xf0120024)) // Receive queue 0 size register
#define RX_POOL1_ADDR           (*((volatile unsigned int *) 0xf0120028)) // Receive queue 1 base address register
#define RX_POOL1_SIZE           (*((volatile unsigned int *) 0xf012002c)) // Receive queue 1 size register
#define RX_POOL2_ADDR           (*((volatile unsigned int *) 0xf0120030)) // Receive queue 2 base address register
#define RX_POOL2_SIZE           (*((volatile unsigned int *) 0xf0120034)) // Receive queue 2 size register
#define RX_POOL3_ADDR           (*((volatile unsigned int *) 0xf0120038)) // Receive queue 3 base address register
#define RX_POOL3_SIZE           (*((volatile unsigned int *) 0xf012003c)) // Receive queue 3 size register
#define RX_DONE0_ADDR           (*((volatile unsigned int *) 0xf0120040)) // Receive packet done queue 0 base address register
#define RX_DONE0_SIZE           (*((volatile unsigned int *) 0xf0120044)) // Receive packet done queue 0 size register
#define RX_DONE1_ADDR           (*((volatile unsigned int *) 0xf0120048)) // Receive packet done queue 1 base address register
#define RX_DONE1_SIZE           (*((volatile unsigned int *) 0xf012004c)) // Receive packet done queue 1 size register
#define UTOPIA_CONFIG           (*((volatile unsigned int *) 0xf0120050)) // UTOPIA interface configuration register
#define UTOPIA_TIMEOUT          (*((volatile unsigned int *) 0xf0120054)) // UTOPIA interface timeout register
#define CLOCK_RATIO             (*((volatile unsigned int *) 0xf0120064)) // Ratio of SAR clock (SAR_CLK) frequency to UNI interface speed
#define DONE_INT_MASK           (*((volatile unsigned int *) 0xf0120070)) // Interrupt mask register
#define ERR_INT_MASK            (*((volatile unsigned int *) 0xf0120074)) // Interrupt mask register
#define DONE_INT_STATUS         (*((volatile unsigned int *) 0xf0120078)) // Interrupt status register
#define ERR_INT_STATUS          (*((volatile unsigned int *) 0xf012007c)) // Interrupt status register
#define RATE_LOOKUP_TBL         (*((volatile unsigned int *) 0xf0120080)) // Base address of 1/Rate lookup table
#define VP_LOOKUP_TBL           (*((volatile unsigned int *) 0xf0120084)) // Base address of VP lookup table
#define UBR_SCH_TBL             (*((volatile unsigned int *) 0xf0120088)) // Base address and entry number of UBR schedule table
#define CBR_SCH_TBL             (*((volatile unsigned int *) 0xf012008c)) // Base address and entry number of CBR schedule table
#define CELL_BUFF               (*((volatile unsigned int *) 0xf0120090)) // Base address and entry number of cell buffer
#define SCH_CONN_TBL            (*((volatile unsigned int *) 0xf0120094)) // Base address and entry number of scheduler connection table
#define AAL_CONN_TBL            (*((volatile unsigned int *) 0xf0120098)) // Base address and entry number of AAL connection table
#define SAR_CONN_TBL            (*((volatile unsigned int *) 0xf012009c)) // Base address and entry number of SAR connection table
#define CAM_VPIVCIn             (*((volatile unsigned int *) 0xf0120100)) // CAM VPI and VCI register 0
#define CAM_CNn                 (*((volatile unsigned int *) 0xf0120100)) // CAM connection number register 0
#define CONFIGURATION           (*((volatile unsigned int *) 0xf0120200)) // Clock control and connection memory configuration register
#define EXT_CMBASE              (*((volatile unsigned int *) 0xf0120204)) // External connection memory base address register


/*
** USBHOST Controller Registers
*/

#define HcRevision              (*((volatile unsigned int *) 0xf0100000)) // Control and status group
#define HcControl               (*((volatile unsigned int *) 0xf0100004)) //
#define HcCommandStatus         (*((volatile unsigned int *) 0xf0100008)) //
#define HcInterruptStatus       (*((volatile unsigned int *) 0xf010000c)) //
#define HcInterruptEnable       (*((volatile unsigned int *) 0xf0100010)) //
#define HcInterruptDisable      (*((volatile unsigned int *) 0xf0100014)) //
#define HcHCCA                  (*((volatile unsigned int *) 0xf0100018)) // Memory pointer group
#define HcPeriodCurrentED       (*((volatile unsigned int *) 0xf010001c)) //
#define HcControlHeadED         (*((volatile unsigned int *) 0xf0100020)) //
#define HcControlCurrentED      (*((volatile unsigned int *) 0xf0100024)) //
#define HcBulkHeadED            (*((volatile unsigned int *) 0xf0100028)) //
#define HcBulkCurrentED         (*((volatile unsigned int *) 0xf010002c)) //
#define HcDoneHead              (*((volatile unsigned int *) 0xf0100030)) //
#define HcFmInterval            (*((volatile unsigned int *) 0xf0100034)) // Frame counter group
#define HcFmRemaining           (*((volatile unsigned int *) 0xf0100038)) //
#define HcFmNumber              (*((volatile unsigned int *) 0xf010003c)) //
#define HcPeriodicStart         (*((volatile unsigned int *) 0xf0100040)) //
#define HcLSThreshold           (*((volatile unsigned int *) 0xf0100044)) //
#define HcRhDescriptorA         (*((volatile unsigned int *) 0xf0100048)) // Root hub group
#define HcRhDescriptorB         (*((volatile unsigned int *) 0xf010004c)) //
#define HcRhStatus              (*((volatile unsigned int *) 0xf0100050)) //
#define HcRhPortStatus1         (*((volatile unsigned int *) 0xf0100054)) //
#define HcRhPortStatus2         (*((volatile unsigned int *) 0xf0100058)) //


/*
** USB Registers
*/

#define USBFA                   (*((volatile unsigned int *) 0xf00e0000)) // USB function address register
#define USBPM                   (*((volatile unsigned int *) 0xf00e0004)) // USB power management register
#define USBINTR                 (*((volatile unsigned int *) 0xf00e0008)) // USB interrupt register
#define USBINTRE                (*((volatile unsigned int *) 0xf00e000c)) // USB interrupt enable register
#define USBFN                   (*((volatile unsigned int *) 0xf00e0010)) // USB frame number register
#define USBDISCONN              (*((volatile unsigned int *) 0xf00e0014)) // USB disconnect timer register
#define USBEP0CSR               (*((volatile unsigned int *) 0xf00e0018)) // USB endpoint 0 common status register
#define USBEP1CSR               (*((volatile unsigned int *) 0xf00e001c)) // USB endpoint 1 common status register
#define USBEP2CSR               (*((volatile unsigned int *) 0xf00e0020)) // USB endpoint 2 common status register
#define USBEP3CSR               (*((volatile unsigned int *) 0xf00e0024)) // USB endpoint 3 common status register
#define USBEP4CSR               (*((volatile unsigned int *) 0xf00e0028)) // USB endpoint 4 common status register
#define USBWCEP0                (*((volatile unsigned int *) 0xf00e0030)) // USB write count register for endpoint 0
#define USBWCEP1                (*((volatile unsigned int *) 0xf00e0034)) // USB write count register for endpoint 1
#define USBWCEP2                (*((volatile unsigned int *) 0xf00e0038)) // USB write count register for endpoint 2
#define USBWCEP3                (*((volatile unsigned int *) 0xf00e003c)) // USB write count register for endpoint 3
#define USBWCEP4                (*((volatile unsigned int *) 0xf00e0040)) // USB write count register for endpoint 4
#define USBEP0                  (*((volatile unsigned int *) 0xf00e0080)) // USB endpoint 0 FIFO
#define USBEP1                  (*((volatile unsigned int *) 0xf00e0084)) // USB endpoint 1 FIFO
#define USBEP2                  (*((volatile unsigned int *) 0xf00e0088)) // USB endpoint 2 FIFO
#define USBEP3                  (*((volatile unsigned int *) 0xf00e008c)) // USB endpoint 3 FIFO
#define USBEP4                  (*((volatile unsigned int *) 0xf00e0090)) // USB endpoint 4 FIFO


/*
** DES/3DES Special Registers Overview
*/

#define DESCON                  (*((volatile unsigned int *) 0xf0090000)) // DES/3DES control register
#define DESSTA                  (*((volatile unsigned int *) 0xf0090004)) // DES/3DES status register
#define DESINT                  (*((volatile unsigned int *) 0xf0090008)) // DES/3DES interrupt enable register
#define DESRUN                  (*((volatile unsigned int *) 0xf009000c)) // DES/3DES run enable register
#define DESKEY1L                (*((volatile unsigned int *) 0xf0090010)) // Key 1 left half
#define DESKEY1R                (*((volatile unsigned int *) 0xf0090014)) // Key 1 right half
#define DESKEY2L                (*((volatile unsigned int *) 0xf0090018)) // Key 2 left half
#define DESKEY2R                (*((volatile unsigned int *) 0xf009001c)) // Key 2 right half
#define DESKEY3L                (*((volatile unsigned int *) 0xf0090020)) // Key 3 left half
#define DESKEY3R                (*((volatile unsigned int *) 0xf0090024)) // Key 3 right half
#define DESIVL                  (*((volatile unsigned int *) 0xf0090028)) // IV left half
#define DESIVR                  (*((volatile unsigned int *) 0xf009002c)) // IV right half
#define DESINFIFO               (*((volatile unsigned int *) 0xf0090030)) // DES/3DES input FIFO
#define DESOUTFIFO              (*((volatile unsigned int *) 0xf0090034)) // DES/3DES output FIFO


/*
** GDMA Special Registers Overview
*/

#define DCON0                   (*((volatile unsigned int *) 0xf0050000)) // GDMA channel 0 control register
#define DSAR0                   (*((volatile unsigned int *) 0xf0050004)) // GDMA channel 0 source address register
#define DDAR0                   (*((volatile unsigned int *) 0xf0050008)) // GDMA channel 0 destination address register
#define DTCR0                   (*((volatile unsigned int *) 0xf005000c)) // GDMA channel 0 transfer count register
#define DRER0                   (*((volatile unsigned int *) 0xf0050010)) // GDMA channel 0 run enable register
#define DIPR0                   (*((volatile unsigned int *) 0xf0050014)) // GDMA channel 0 interrupt pending register

#define DCON1                   (*((volatile unsigned int *) 0xf0050020)) // GDMA channel 1 control register
#define DSAR1                   (*((volatile unsigned int *) 0xf0050024)) // GDMA channel 1 source address register
#define DDAR1                   (*((volatile unsigned int *) 0xf0050028)) // GDMA channel 1 destination address register
#define DTCR1                   (*((volatile unsigned int *) 0xf005002c)) // GDMA channel 1 transfer count register
#define DRER1                   (*((volatile unsigned int *) 0xf0050030)) // GDMA channel 1 run enable register
#define DIPR1                   (*((volatile unsigned int *) 0xf0050034)) // GDMA channel 1 interrupt pending register

#define DCON2                   (*((volatile unsigned int *) 0xf0050040)) // GDMA channel 2 control register
#define DSAR2                   (*((volatile unsigned int *) 0xf0050044)) // GDMA channel 2 source address register
#define DDAR2                   (*((volatile unsigned int *) 0xf0050048)) // GDMA channel 2 destination address register
#define DTCR2                   (*((volatile unsigned int *) 0xf005004c)) // GDMA channel 2 transfer count register
#define DRER2                   (*((volatile unsigned int *) 0xf0050050)) // GDMA channel 2 run enable register
#define DIPR2                   (*((volatile unsigned int *) 0xf0050054)) // GDMA channel 2 interrupt pending register

#define DCON3                   (*((volatile unsigned int *) 0xf0050060)) // GDMA channel 3 control register
#define DSAR3                   (*((volatile unsigned int *) 0xf0050064)) // GDMA channel 3 source address register
#define DDAR3                   (*((volatile unsigned int *) 0xf0050068)) // GDMA channel 3 destination address register
#define DTCR3                   (*((volatile unsigned int *) 0xf005006c)) // GDMA channel 3 transfer count register
#define DRER3                   (*((volatile unsigned int *) 0xf0050070)) // GDMA channel 3 run enable register
#define DIPR3                   (*((volatile unsigned int *) 0xf0050074)) // GDMA channel 3 interrupt pending register

#define DCON4                   (*((volatile unsigned int *) 0xf0050080)) // GDMA channel 4 control register
#define DSAR4                   (*((volatile unsigned int *) 0xf0050084)) // GDMA channel 4 source address register
#define DDAR4                   (*((volatile unsigned int *) 0xf0050088)) // GDMA channel 4 destination address register
#define DTCR4                   (*((volatile unsigned int *) 0xf005008c)) // GDMA channel 4 transfer count register
#define DRER4                   (*((volatile unsigned int *) 0xf0050090)) // GDMA channel 4 run enable register
#define DIPR4                   (*((volatile unsigned int *) 0xf0050094)) // GDMA channel 4 interrupt pending register

#define DCON5                   (*((volatile unsigned int *) 0xf00500a0)) // GDMA channel 5 control register
#define DSAR5                   (*((volatile unsigned int *) 0xf00500a4)) // GDMA channel 5 source address register
#define DDAR5                   (*((volatile unsigned int *) 0xf00500a8)) // GDMA channel 5 destination address register
#define DTCR5                   (*((volatile unsigned int *) 0xf00500ac)) // GDMA channel 5 transfer count register
#define DRER5                   (*((volatile unsigned int *) 0xf00500b0)) // GDMA channel 5 run enable register
#define DIPR5                   (*((volatile unsigned int *) 0xf00500b4)) // GDMA channel 5 interrupt pending register

#define DPRIC                   (*((volatile unsigned int *) 0xf0051000)) // GDMA priority configuration register
#define DPRIF                   (*((volatile unsigned int *) 0xf0052000)) // GDMA programmable priority register for fixed
#define DPRIR                   (*((volatile unsigned int *) 0xf0053000)) // GDMA programmable priority register for programmable occupancy round-robin


/*
** Console UART Special Registers Overview
*/

#define CUCON                   (*((volatile unsigned int *) 0xf0060000)) // Console UART control register
#define CUSTAT                  (*((volatile unsigned int *) 0xf0060004)) // Console UART status register
#define CUINT                   (*((volatile unsigned int *) 0xf0060008)) // Console UART interrupt enable register
#define CUTXBUF                 (*((volatile unsigned int *) 0xf006000c)) // Console UART transmit data register
#define CURXBUF                 (*((volatile unsigned int *) 0xf0060010)) // Console UART receive data register
#define CUBRD                   (*((volatile unsigned int *) 0xf0060014)) // Console UART baud rate divisor register
#define CUCHAR1                 (*((volatile unsigned int *) 0xf0060018)) // Console UART control character register 1
#define CUCHAR2                 (*((volatile unsigned int *) 0xf006001c)) // Console UART control character register 2


/*
** High-Speed UART 0 Special Registers Overview
*/

#define U0_HUCON                (*((volatile unsigned int *) 0xf0070000)) // High-Speed UART control register
#define U0_HUSTAT               (*((volatile unsigned int *) 0xf0070004)) // High-Speed UART status register
#define U0_HUINT                (*((volatile unsigned int *) 0xf0070008)) // High-Speed UART interrupt enable register
#define U0_HUTXBUF              (*((volatile unsigned int *) 0xf007000c)) // High-Speed UART transmit data register
#define U0_HURXBUF              (*((volatile unsigned int *) 0xf0070010)) // High-Speed UART receive data register
#define U0_HUBRD                (*((volatile unsigned int *) 0xf0070014)) // High-Speed UART baud rate divisor register
#define U0_HUCHAR1              (*((volatile unsigned int *) 0xf0070018)) // High-Speed UART control character register 1
#define U0_HUCHAR2              (*((volatile unsigned int *) 0xf007001c)) // High-Speed UART control character register 2
#define U0_HUABB                (*((volatile unsigned int *) 0xf0070020)) // High-Speed UART autobaud boundary register
#define U0_HUABT                (*((volatile unsigned int *) 0xf0070024)) // High-Speed UART autobaud table register


/*
** High-Speed UART 1 Special Registers Overview
*/

#define U1_HUCON                (*((volatile unsigned int *) 0xf0080000)) // High-Speed UART control register
#define U1_HUSTAT               (*((volatile unsigned int *) 0xf0080004)) // High-Speed UART status register
#define U1_HUINT                (*((volatile unsigned int *) 0xf0080008)) // High-Speed UART interrupt enable register
#define U1_HUTXBUF              (*((volatile unsigned int *) 0xf008000c)) // High-Speed UART transmit data register
#define U1_HURXBUF              (*((volatile unsigned int *) 0xf0080010)) // High-Speed UART receive data register
#define U1_HUBRD                (*((volatile unsigned int *) 0xf0080014)) // High-Speed UART baud rate divisor register
#define U1_HUCHAR1              (*((volatile unsigned int *) 0xf0080018)) // High-Speed UART control character register 1
#define U1_HUCHAR2              (*((volatile unsigned int *) 0xf008001c)) // High-Speed UART control character register 2
#define U1_HUABB                (*((volatile unsigned int *) 0xf0080020)) // High-Speed UART autobaud boundary register
#define U1_HUABT                (*((volatile unsigned int *) 0xf0080024)) // High-Speed UART autobaud table register


/*
** I/O Port Special Registers
*/

#define IOPMODE1                (*((volatile unsigned int *) 0xf0030000)) // I/O port mode select register for port 0 to 31
#define IOPMODE2                (*((volatile unsigned int *) 0xf0030004)) // I/O port mode select register for port 32 to 63
#define IOPCON1                 (*((volatile unsigned int *) 0xf0030008)) // I/O port function select register for port 0 to 31
#define IOPCON2                 (*((volatile unsigned int *) 0xf003000c)) // I/O port function select register for port 32 to 63
#define IOPGDMA                 (*((volatile unsigned int *) 0xf0030010)) // I/O port special function register for GDMA
#define IOPEXTINT               (*((volatile unsigned int *) 0xf0030014)) // I/O port special function register for external interrupt
#define IOPEXTINTPND            (*((volatile unsigned int *) 0xf0030018)) // I/O port external interrupt clear register
#define IOPDATA1                (*((volatile unsigned int *) 0xf003001c)) // I/O port data register for port 0 to 31
#define IOPDATA2                (*((volatile unsigned int *) 0xf0030020)) // I/O port data register for port 32 to 63
#define IOPDRV1                 (*((volatile unsigned int *) 0xf0030024)) // I/O port drive control register for port 0 to 31
#define IOPDRV2                 (*((volatile unsigned int *) 0xf0030028)) // I/O port drive control register for port 32 to 63


/*
** Interrupt Controller
*/

#define INTMOD                  (*((volatile unsigned int *) 0xf0140000)) // Internal interrupt mode register
#define EXTMOD                  (*((volatile unsigned int *) 0xf0140004)) // External interrupt mode register
#define INTMASK                 (*((volatile unsigned int *) 0xf0140008)) // Internal Interrupt mask register
#define EXTMASK                 (*((volatile unsigned int *) 0xf014000c)) // External Interrupt mask register
#define INTPRIOR0               (*((volatile unsigned int *) 0xf0140020)) // Interrupt priority register 0
#define INTPRIOR1               (*((volatile unsigned int *) 0xf0140024)) // Interrupt priority register 1
#define INTPRIOR2               (*((volatile unsigned int *) 0xf0140028)) // Interrupt priority register 2
#define INTPRIOR3               (*((volatile unsigned int *) 0xf014002c)) // Interrupt priority register 3
#define INTPRIOR4               (*((volatile unsigned int *) 0xf0140030)) // Interrupt priority register 4
#define INTPRIOR5               (*((volatile unsigned int *) 0xf0140034)) // Interrupt priority register 5
#define INTPRIOR6               (*((volatile unsigned int *) 0xf0140038)) // Interrupt priority register 6
#define INTPRIOR7               (*((volatile unsigned int *) 0xf014003c)) // Interrupt priority register 7
#define INTPRIOR8               (*((volatile unsigned int *) 0xf0140040)) // Interrupt priority register 8
#define INTOFFSET_FIQ           (*((volatile unsigned int *) 0xf0140018)) // FIQ interrupt offset register
#define INTOFFSET_IRQ           (*((volatile unsigned int *) 0xf014001c)) // IRQ interrupt offset register
#define IPRIORHI                (*((volatile unsigned int *) 0xf0140010)) // High bits, 35-32 bit, Interrupt by priority register
#define IPRIORLO                (*((volatile unsigned int *) 0xf0140014)) // Low bits, 31-0 bit, Interrupt by priority register
#define INTTST                  (*((volatile unsigned int *) 0xf0140048)) // High bits, 35-6bit, Internal interrupt test register
#define EXTTST                  (*((volatile unsigned int *) 0xf014004c)) // Low bits, 5-0 bit, External interrupt test register


/*
** Timers
*/

#define TMOD                    (*((volatile unsigned int *) 0xf0040000)) // Timer mode register
#define TIC                     (*((volatile unsigned int *) 0xf0040004)) // Timer Interrupt Clear
#define WDT                     (*((volatile unsigned int *) 0xf0040008)) // Watchdog Timer Register
#define TDATA0                  (*((volatile unsigned int *) 0xf0040010)) // Timer 0 data register
#define TDATA1                  (*((volatile unsigned int *) 0xf0040018)) // Timer 1 data register
#define TDATA2                  (*((volatile unsigned int *) 0xf0040020)) // Timer 2 data register
#define TDATA3                  (*((volatile unsigned int *) 0xf0040028)) // Timer 3 data register
#define TDATA4                  (*((volatile unsigned int *) 0xf0040030)) // Timer 4 data register
#define TDATA5                  (*((volatile unsigned int *) 0xf0040038)) // Timer 5 data register
#define TCNT0                   (*((volatile unsigned int *) 0xf0040014)) // Timer 0 count register
#define TCNT1                   (*((volatile unsigned int *) 0xf004001c)) // Timer 1 count register
#define TCNT2                   (*((volatile unsigned int *) 0xf0040024)) // Timer 2 count register
#define TCNT3                   (*((volatile unsigned int *) 0xf004002c)) // Timer 3 count register
#define TCNT4                   (*((volatile unsigned int *) 0xf0040034)) // Timer 4 count register
#define TCNT5                   (*((volatile unsigned int *) 0xf004003c)) // Timer 5 count register


/*
** PCI (Mini-PCI)
*/

#define PCIHID                  (*((volatile unsigned int *) 0xf0110000))
#define PCIHSC                  (*((volatile unsigned int *) 0xf0110004))
#define PCIHCODE                (*((volatile unsigned int *) 0xf0110008))
#define PCIHLINE                (*((volatile unsigned int *) 0xf011000c))
#define PCIHBAR0                (*((volatile unsigned int *) 0xf0110010))
#define PCIHBAR1                (*((volatile unsigned int *) 0xf0110014))
#define PCIHBAR2                (*((volatile unsigned int *) 0xf0110018))
#define PCIHCISP                (*((volatile unsigned int *) 0xf0110028))
#define PCIHSSID                (*((volatile unsigned int *) 0xf011002c))
#define PCIHCAP                 (*((volatile unsigned int *) 0xf0110034))
#define PCIHLTIT                (*((volatile unsigned int *) 0xf011003c))
#define PCIHTIMER               (*((volatile unsigned int *) 0xf0110040))
#define PCIHPMR0                (*((volatile unsigned int *) 0xf01100dc))
#define PCIHPMR1                (*((volatile unsigned int *) 0xf01100e0))

#define PCICON                  (*((volatile unsigned int *) 0xf0110100))
#define PCISET                  (*((volatile unsigned int *) 0xf0110104))
#define PCIINTEN                (*((volatile unsigned int *) 0xf0110108))
#define PCIINTST                (*((volatile unsigned int *) 0xf011010c))
#define PCIINTAD                (*((volatile unsigned int *) 0xf0110110))
#define PCIBATAPM               (*((volatile unsigned int *) 0xf0110114))
#define PCIBATAPI               (*((volatile unsigned int *) 0xf0110118))
#define PCIRCC                  (*((volatile unsigned int *) 0xf011011c))
#define PCIDIAG0                (*((volatile unsigned int *) 0xf0110120))
#define PCIDIAG1                (*((volatile unsigned int *) 0xf0110124))
#define PCIBELAP                (*((volatile unsigned int *) 0xf0110128))
#define PCIBELPA                (*((volatile unsigned int *) 0xf011012c))

#define PCIMAIL0                (*((volatile unsigned int *) 0xf0110130))
#define PCIMAIL1                (*((volatile unsigned int *) 0xf0110134))
#define PCIMAIL2                (*((volatile unsigned int *) 0xf0110138))
#define PCIMAIL3                (*((volatile unsigned int *) 0xf011013c))
#define PCIBATPA0               (*((volatile unsigned int *) 0xf0110140))
#define PCIBAM0                 (*((volatile unsigned int *) 0xf0110144))
#define PCIBATPA1               (*((volatile unsigned int *) 0xf0110148))
#define PCIBAM1                 (*((volatile unsigned int *) 0xf011014c))
#define PCIBATPA2               (*((volatile unsigned int *) 0xf0110150))
#define PCIBAM2                 (*((volatile unsigned int *) 0xf0110154))
#define PCISWAP                 (*((volatile unsigned int *) 0xf0110158))
#define PCCARDEVT               (*((volatile unsigned int *) 0xf0110160))
#define PCCARDEVM               (*((volatile unsigned int *) 0xf0110164))
#define PCCARDPRS               (*((volatile unsigned int *) 0xf0110168))
#define PCCARDFEV               (*((volatile unsigned int *) 0xf011016c))
#define PCCARDCON               (*((volatile unsigned int *) 0xf0110170))
#define PCCARD16C               (*((volatile unsigned int *) 0xf0110174))
#define PCCARD16M               (*((volatile unsigned int *) 0xf0110178))
#define PCCARD16I               (*((volatile unsigned int *) 0xf011017c))
#define PDMACON0                (*((volatile unsigned int *) 0xf0110180))
#define PDMASRC0                (*((volatile unsigned int *) 0xf0110184))
#define PDMADST0                (*((volatile unsigned int *) 0xf0110188))
#define PDMACNT0                (*((volatile unsigned int *) 0xf011018c))
#define PDMARUN0                (*((volatile unsigned int *) 0xf0110190))
#define PDMACON1                (*((volatile unsigned int *) 0xf01101a0))
#define PDMASRC1                (*((volatile unsigned int *) 0xf01101a4))
#define PDMADST1                (*((volatile unsigned int *) 0xf01101a8))
#define PDMACNT1                (*((volatile unsigned int *) 0xf01101ac))
#define PDMARUN1                (*((volatile unsigned int *) 0xf01101b0))


#endif   /* _S3C2510A_H */
