/**************************************************************************
**                                                                        *
**  FILE        :  s3c24a0.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C24A0        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C24A0_H
#define _S3C24A0_H


/*
** PLL Clock Control and Power Management
*/

#define LOCKTIME                (*((volatile unsigned int  *) 0x40000000)) // PLL lock time counter
#define OSCWSET                 (*((volatile unsigned int  *) 0x40000004)) // OSC settle-down wait time setting
#define MPLLCON                 (*((volatile unsigned int  *) 0x40000010)) // MPLL configuration
#define UPLLCON                 (*((volatile unsigned int  *) 0x40000014)) // UPLL configuration
#define CLKCON                  (*((volatile unsigned int  *) 0x40000020)) // Clock generator control
#define CLKSRC                  (*((volatile unsigned int  *) 0x40000024)) // Slow clock control
#define CLKDIVN                 (*((volatile unsigned int  *) 0x40000028)) // Clock divider control
#define PWRMAN                  (*((volatile unsigned int  *) 0x40000030)) // Power management
#define SOFTRESET               (*((volatile unsigned int  *) 0x40000038)) // Software reset


/*
** Interrupt Controller
*/

#define SRCPND                  (*((volatile unsigned int  *) 0x40200000)) // Interrupt request status
#define INTMOD                  (*((volatile unsigned int  *) 0x40200004)) // Interrupt mode control
#define INTMSK                  (*((volatile unsigned int  *) 0x40200008)) // Interrupt mask control
#define PRIORITY                (*((volatile unsigned int  *) 0x4020000c)) // IRQ priority control
#define INTPND                  (*((volatile unsigned int  *) 0x40200010)) // Interrupt request status
#define INTOFFSET               (*((volatile unsigned int  *) 0x40200014)) // Interrupt request source offset
#define SUBSRCPND               (*((volatile unsigned int  *) 0x40200018)) // Sub source pending
#define INTSUBMSK               (*((volatile unsigned int  *) 0x4020001c)) // Interrupt sub mask
#define VECINTMOD               (*((volatile unsigned int  *) 0x40200020)) // Vectored interrupt mode
#define VECADDR                 (*((volatile unsigned int  *) 0x40200024)) // Vectored mode address
#define NVECADDR                (*((volatile unsigned int  *) 0x40200028)) // Non-vectored mode address
#define VAR                     (*((volatile unsigned int  *) 0x4020002c)) // Vector address register


/*
** 4-ch DMA controller
*/

#define DISRC0                  (*((volatile unsigned int  *) 0x40400000)) // DMA 0 initial source
#define DISRCC0                 (*((volatile unsigned int  *) 0x40400004)) // DMA 0 initial source control
#define DIDST0                  (*((volatile unsigned int  *) 0x40400008)) // DMA 0 initial destination
#define DIDSTC0                 (*((volatile unsigned int  *) 0x4040000c)) // DMA 0 initial destination control
#define DCON0                   (*((volatile unsigned int  *) 0x40400010)) // DMA 0 control
#define DSTAT0                  (*((volatile unsigned int  *) 0x40400014)) // DMA 0 count
#define DCSRC0                  (*((volatile unsigned int  *) 0x40400018)) // DMA 0 current source
#define DCDST0                  (*((volatile unsigned int  *) 0x4040001c)) // DMA 0 current destination
#define DMASKTRIG0              (*((volatile unsigned int  *) 0x40400020)) // DMA 0 mask trigger
#define DISRC1                  (*((volatile unsigned int  *) 0x40500000)) // DMA 1 initial source
#define DISRCC1                 (*((volatile unsigned int  *) 0x40500004)) // DMA 1 initial source control
#define DIDST1                  (*((volatile unsigned int  *) 0x40500008)) // DMA 1 initial destination
#define DIDSTC1                 (*((volatile unsigned int  *) 0x4050000c)) // DMA 1 initial destination control
#define DCON1                   (*((volatile unsigned int  *) 0x40500010)) // DMA 1 control
#define DSTAT1                  (*((volatile unsigned int  *) 0x40500014)) // DMA 1 count
#define DCSRC1                  (*((volatile unsigned int  *) 0x40500018)) // DMA 1 current source
#define DCDST1                  (*((volatile unsigned int  *) 0x4050001c)) // DMA 1 current destination
#define DMASKTRIG1              (*((volatile unsigned int  *) 0x40500020)) // DMA 1 mask trigger
#define DISRC2                  (*((volatile unsigned int  *) 0x40600000)) // DMA 2 initial source
#define DISRCC2                 (*((volatile unsigned int  *) 0x40600004)) // DMA 2 initial source control
#define DIDST2                  (*((volatile unsigned int  *) 0x40600008)) // DMA 2 initial destination
#define DIDSTC2                 (*((volatile unsigned int  *) 0x4060000c)) // DMA 2 initial destination control
#define DCON2                   (*((volatile unsigned int  *) 0x40600010)) // DMA 2 control
#define DSTAT2                  (*((volatile unsigned int  *) 0x40600014)) // DMA 2 count
#define DCSRC2                  (*((volatile unsigned int  *) 0x40600018)) // DMA 2 current source
#define DCDST2                  (*((volatile unsigned int  *) 0x4060001c)) // DMA 2 current destination
#define DMASKTRIG2              (*((volatile unsigned int  *) 0x40600020)) // DMA 2 mask trigger
#define DISRC3                  (*((volatile unsigned int  *) 0x40700000)) // DMA 3 initial source
#define DISRCC3                 (*((volatile unsigned int  *) 0x40700004)) // DMA 3 initial source control
#define DIDST3                  (*((volatile unsigned int  *) 0x40700008)) // DMA 3 initial destination
#define DIDSTC3                 (*((volatile unsigned int  *) 0x4070000c)) // DMA 3 initial destination control
#define DCON3                   (*((volatile unsigned int  *) 0x40700010)) // DMA 3 control
#define DSTAT3                  (*((volatile unsigned int  *) 0x40700014)) // DMA 3 count
#define DCSRC3                  (*((volatile unsigned int  *) 0x40700018)) // DMA 3 current source
#define DCDST3                  (*((volatile unsigned int  *) 0x4070001c)) // DMA 3 current destination
#define DMASKTRIG3              (*((volatile unsigned int  *) 0x40700020)) // DMA 3 mask trigger


/*
** NAND Flash Controller
*/

#define NFCONF                  (*((volatile unsigned int  *) 0x40c00000)) // NAND flash configuration
#define NFCONT                  (*((volatile unsigned int  *) 0x40c00004)) // NAND flash control
#define NFCMMD                  (*((volatile unsigned int  *) 0x40c00008)) // NAND flash command
#define NFADDR                  (*((volatile unsigned int  *) 0x40c0000c)) // NAND flash address
#define NFDATA                  (*((volatile unsigned int  *) 0x40c00010)) // NAND flash data
#define NFMECCDATA0             (*((volatile unsigned int  *) 0x40c00014)) // NAND flash main area ECC data reg.0
#define NFMECCDATA1             (*((volatile unsigned int  *) 0x40c00018)) // NAND flash main area ECC data reg.1
#define NFMECCDATA2             (*((volatile unsigned int  *) 0x40c0001c)) // NAND flash main area ECC data reg.2
#define NFMECCDATA3             (*((volatile unsigned int  *) 0x40c00020)) // NAND flash main area ECC data reg.3
#define NFSECCDATA0             (*((volatile unsigned int  *) 0x40c00024)) // NAND flash spare area ECC data reg.1
#define NFSECCDATA1             (*((volatile unsigned int  *) 0x40c00028)) // NAND flash spare area ECC data reg.2
#define NFSTAT                  (*((volatile unsigned int  *) 0x40c0002c)) // NAND flash status
#define NFESTAT0                (*((volatile unsigned int  *) 0x40c00030)) // NAND flash ECC status 0 for I/O[7:0]
#define NFESTAT1                (*((volatile unsigned int  *) 0x40c00034)) // NAND flash ECC status 1 for I/O[15:8]
#define NFMECC0                 (*((volatile unsigned int  *) 0x40c00038)) // NAND flash main area ECC reg.0
#define NFMECC1                 (*((volatile unsigned int  *) 0x40c0003c)) // NAND flash main area ECC reg.1
#define NFSECC                  (*((volatile unsigned int  *) 0x40c00040)) // NAND flash spare area ECC reg.
#define NFSBLK                  (*((volatile unsigned int  *) 0x40c00044)) // NAND flash start block address
#define NFEBLK                  (*((volatile unsigned int  *) 0x40c00048)) // NAND flash end block address


/*
** SROM Controller
*/

#define SROM_BW                 (*((volatile unsigned int  *) 0x40c20000)) // SROM bus width & wait control
#define SROM_BC0                (*((volatile unsigned int  *) 0x40c20004)) // SROM bank0 Control register
#define SROM_BC1                (*((volatile unsigned int  *) 0x40c20008)) // SROM bank1 Control register
#define SROM_BC2                (*((volatile unsigned int  *) 0x40c2000c)) // SROM bank2 Control register


/*
** SDRAM Controller
*/

#define SDRAM_BANKCFG           (*((volatile unsigned int  *) 0x40c40000)) // SDRAM configuration
#define SDRAM_BANKCON           (*((volatile unsigned int  *) 0x40c40004)) // SDRAM control
#define SDRAM_REFRESH           (*((volatile unsigned int  *) 0x40c40008)) // SDRAM refresh control


/*
** BUS Matrix
*/

#define PRIORITY0               (*((volatile unsigned int  *) 0x40ce0000)) // Priority control for SROMC/NFLASHC
#define PRIORITY1               (*((volatile unsigned int  *) 0x40ce0004)) // Priority control for SDRAMC


/*
** USB Host
*/

#define HcRevision              (*((volatile unsigned int  *) 0x41000000)) // Control and status group
#define HcControl               (*((volatile unsigned int  *) 0x41000004)) //
#define HcCommonStatus          (*((volatile unsigned int  *) 0x41000008)) //
#define HcInterruptStatus       (*((volatile unsigned int  *) 0x4100000c)) //
#define HcInterruptEnable       (*((volatile unsigned int  *) 0x41000010)) //
#define HcInterruptDisable      (*((volatile unsigned int  *) 0x41000014)) //
#define HcHCCA                  (*((volatile unsigned int  *) 0x41000018)) // Memory pointer group
#define HcPeriodCuttentED       (*((volatile unsigned int  *) 0x4100001c)) //
#define HcControlHeadED         (*((volatile unsigned int  *) 0x41000020)) //
#define HcControlCurrentED      (*((volatile unsigned int  *) 0x41000024)) //
#define HcBulkHeadED            (*((volatile unsigned int  *) 0x41000028)) //
#define HcBulkCurrentED         (*((volatile unsigned int  *) 0x4100002c)) //
#define HcDoneHead              (*((volatile unsigned int  *) 0x41000030)) //
#define HcRmInterval            (*((volatile unsigned int  *) 0x41000034)) // Frame counter group
#define HcFmRemaining           (*((volatile unsigned int  *) 0x41000038)) //
#define HcFmNumber              (*((volatile unsigned int  *) 0x4100003c)) //
#define HcPeriodicStart         (*((volatile unsigned int  *) 0x41000040)) //
#define HcLSThreshold           (*((volatile unsigned int  *) 0x41000044)) //
#define HcRhDescriptorA         (*((volatile unsigned int  *) 0x41000048)) // Root HUB group
#define HcRhDescriptorB         (*((volatile unsigned int  *) 0x4100004c)) //
#define HcRhStatus              (*((volatile unsigned int  *) 0x41000050)) //
#define HcRhPortStatus1         (*((volatile unsigned int  *) 0x41000054)) //
#define HcRhPortStatus2         (*((volatile unsigned int  *) 0x41000058)) //


/*
** Modem Interface
*/

#define INT2AP                  (*((volatile unsigned int  *) 0x41180000)) // Interrupt request to AP register
#define INT2MDM                 (*((volatile unsigned int  *) 0x41180004)) // Interrupt request to modem register


/*
** IrDA
*/

#define IrDA_CNT                (*((volatile unsigned int  *) 0x41800000)) // IrDA control
#define IrDA_MDR                (*((volatile unsigned int  *) 0x41800004)) // IrDA mode definition
#define IrDA_CNF                (*((volatile unsigned int  *) 0x41800008)) // IrDA interrupt / DMA configuration
#define IrDA_IER                (*((volatile unsigned int  *) 0x4180000c)) // IrDA interrupt enable
#define IrDA_IIR                (*((volatile unsigned int  *) 0x41800010)) // IrDA interrupt identification
#define IrDA_LSR                (*((volatile unsigned int  *) 0x41800014)) // IrDA line status
#define IrDA_FCR                (*((volatile unsigned int  *) 0x41800018)) // IrDA FIFO control
#define IrDA_PLR                (*((volatile unsigned int  *) 0x4180001c)) // IrDA preamble length
#define IrDA_RBR                (*((volatile unsigned int  *) 0x41800020)) // IrDA receiver & transmitter buffer
#define IrDA_TXNO               (*((volatile unsigned int  *) 0x41800024)) // IrDA the total number of data bytes remained in Tx FIFO
#define IrDA_RXNO               (*((volatile unsigned int  *) 0x41800028)) // IrDA the total number of data bytes remained in Rx FIFO
#define IrDA_TXFLL              (*((volatile unsigned int  *) 0x4180002c)) // IrDA transmit frame-length register low
#define IrDA_TXFLH              (*((volatile unsigned int  *) 0x41800030)) // IrDA transmit frame-length register high
#define IrDA_RXFLL              (*((volatile unsigned int  *) 0x41800034)) // IrDA receive frame-length register low
#define IrDA_RXFLH              (*((volatile unsigned int  *) 0x41800038)) // IrDA receive frame-length register high


/*
** PWM Timer
*/

#define TCFG0                   (*((volatile unsigned int  *) 0x44000000)) // Timer configuration
#define TCFG1                   (*((volatile unsigned int  *) 0x44000004)) // Timer configuration
#define TCON                    (*((volatile unsigned int  *) 0x44000008)) // Timer control
#define TCNTB0                  (*((volatile unsigned int  *) 0x4400000c)) // Timer count buffer 0
#define TCMPB0                  (*((volatile unsigned int  *) 0x44000010)) // Timer compare buffer 0
#define TCNTO0                  (*((volatile unsigned int  *) 0x44000014)) // Timer count observation 0
#define TCNTB1                  (*((volatile unsigned int  *) 0x44000018)) // Timer count buffer 1
#define TCMPB1                  (*((volatile unsigned int  *) 0x4400001c)) // Timer compare buffer 1
#define TCNTO1                  (*((volatile unsigned int  *) 0x44000020)) // Timer count observation 1
#define TCNTB2                  (*((volatile unsigned int  *) 0x44000024)) // Timer count buffer 2
#define TCMPB2                  (*((volatile unsigned int  *) 0x44000028)) // Timer compare buffer 2
#define TCNTO2                  (*((volatile unsigned int  *) 0x4400002c)) // Timer count observation 2
#define TCNTB3                  (*((volatile unsigned int  *) 0x44000030)) // Timer count buffer 3
#define TCMPB3                  (*((volatile unsigned int  *) 0x44000034)) // Timer compare buffer 3
#define TCNTO3                  (*((volatile unsigned int  *) 0x44000038)) // Timer count observation 3
#define TCNTB4                  (*((volatile unsigned int  *) 0x4400003c)) // Timer count buffer 4
#define TCNTO4                  (*((volatile unsigned int  *) 0x44000040)) // Timer count observation 4


/*
** Watchdog Timer
*/

#define WTCON                   (*((volatile unsigned int  *) 0x44100000)) // Watch-dog timer mode
#define WTDAT                   (*((volatile unsigned int  *) 0x44100004)) // Watch-dog timer data
#define WTCNT                   (*((volatile unsigned int  *) 0x44100008)) // Watch-dog timer count


/*
** RTC (Real Time Clock)
*/

#define RTCCON                  (*((volatile unsigned char *) 0x44200040)) // RTC control
#define TICINT                  (*((volatile unsigned char *) 0x44200044)) // Tick time count
#define RTCALM                  (*((volatile unsigned char *) 0x44200050)) // RTC alarm control
#define ALMSEC                  (*((volatile unsigned char *) 0x44200054)) // Alarm second
#define ALMMIN                  (*((volatile unsigned char *) 0x44200058)) // Alarm minute
#define ALMHOUR                 (*((volatile unsigned char *) 0x4420005c)) // Alarm hour
#define ALMDATE                 (*((volatile unsigned char *) 0x44200060)) // Alarm day
#define ALMMON                  (*((volatile unsigned char *) 0x44200064)) // Alarm month
#define ALMYEAR                 (*((volatile unsigned char *) 0x44200068)) // Alarm year
#define RTCRST                  (*((volatile unsigned char *) 0x4420006c)) // RTC round reset
#define BCDSEC                  (*((volatile unsigned char *) 0x44200070)) // BCD second
#define BCDMIN                  (*((volatile unsigned char *) 0x44200074)) // BCD minute
#define BCDHOUR                 (*((volatile unsigned char *) 0x44200078)) // BCD hour
#define BCDDATE                 (*((volatile unsigned char *) 0x4420007c)) // BCD day
#define BCDDAY                  (*((volatile unsigned char *) 0x44200080)) // BCD date
#define BCDMON                  (*((volatile unsigned char *) 0x44200084)) // BCD month
#define BCDYEAR                 (*((volatile unsigned char *) 0x44200088)) // BCD year


/*
** UART
*/

#define ULCON0                  (*((volatile unsigned int  *) 0x44400000)) // UART 0 line control
#define UCON0                   (*((volatile unsigned int  *) 0x44400004)) // UART 0 control
#define UFCON0                  (*((volatile unsigned int  *) 0x44400008)) // UART 0 FIFO control
#define UMCON0                  (*((volatile unsigned int  *) 0x4440000c)) // UART 0 modem control
#define UTRSTAT0                (*((volatile unsigned int  *) 0x44400010)) // UART 0 Tx/Rx status
#define UERSTAT0                (*((volatile unsigned int  *) 0x44400014)) // UART 0 Rx error status
#define UFSTAT0                 (*((volatile unsigned int  *) 0x44400018)) // UART 0 FIFO status
#define UMSTAT0                 (*((volatile unsigned int  *) 0x4440001c)) // UART 0 modem status
#define UTXH0                   (*((volatile unsigned char *) 0x44400020)) // UART 0 transmission hold
#define URXH0                   (*((volatile unsigned char *) 0x44400024)) // UART 0 receive buffer
#define UBRDIV0                 (*((volatile unsigned int  *) 0x44400028)) // UART 0 baud rate divisor
#define ULCON1                  (*((volatile unsigned int  *) 0x44404000)) // UART 1 line control
#define UCON1                   (*((volatile unsigned int  *) 0x44404004)) // UART 1 control
#define UFCON1                  (*((volatile unsigned int  *) 0x44404008)) // UART 1 FIFO control
#define UMCON1                  (*((volatile unsigned int  *) 0x4440400c)) // UART 1 modem control
#define UTRSTAT1                (*((volatile unsigned int  *) 0x44404010)) // UART 1 Tx/Rx status
#define UERSTAT1                (*((volatile unsigned int  *) 0x44404014)) // UART 1 Rx error status
#define UFSTAT1                 (*((volatile unsigned int  *) 0x44404018)) // UART 1 FIFO status
#define UMSTAT1                 (*((volatile unsigned int  *) 0x4440401c)) // UART 1 modem status
#define UTXH1                   (*((volatile unsigned char *) 0x44404020)) // UART 1 transmission hold
#define URXH1                   (*((volatile unsigned char *) 0x44404024)) // UART 1 receive buffer
#define UBRDIV1                 (*((volatile unsigned int  *) 0x44404028)) // UART 1 baud rate divisor


/*
** SPI
*/

#define SPCON0                  (*((volatile unsigned int  *) 0x44500000)) // SPI channel 0 control
#define SPSTA0                  (*((volatile unsigned int  *) 0x44500004)) // SPI channel 0 status
#define SPPIN0                  (*((volatile unsigned int  *) 0x44500008)) // SPI channel 0 pin control
#define SPPRE0                  (*((volatile unsigned int  *) 0x4450000c)) // SPI channel 0 baud rate prescaler
#define SPTDAT0                 (*((volatile unsigned int  *) 0x44500010)) // SPI channel 0 Tx data
#define SPRDAT0                 (*((volatile unsigned int  *) 0x44500014)) // SPI channel 0 Rx data
#define SPCON1                  (*((volatile unsigned int  *) 0x44500020)) // SPI channel 1 control
#define SPSTA1                  (*((volatile unsigned int  *) 0x44500024)) // SPI channel 1 status
#define SPPIN1                  (*((volatile unsigned int  *) 0x44500028)) // SPI channel 1 pin control
#define SPPRE1                  (*((volatile unsigned int  *) 0x4450002c)) // SPI channel 1 baud rate prescaler
#define SPTDAT1                 (*((volatile unsigned int  *) 0x44500030)) // SPI channel 1 Tx data
#define SPRDAT1                 (*((volatile unsigned int  *) 0x44500034)) // SPI channel 1 Rx data


/*
** IIC
*/

#define IICCON                  (*((volatile unsigned int  *) 0x44600000)) // IIC control
#define IICSTAT                 (*((volatile unsigned int  *) 0x44600004)) // IIC status
#define IICADD                  (*((volatile unsigned int  *) 0x44600008)) // IIC address
#define IICDS                   (*((volatile unsigned int  *) 0x4460000c)) // IIC data shift
#define IICSDADLY               (*((volatile unsigned int  *) 0x44600010)) // IIC 1-bit SDA output delay


/*
** Inter-IC Sound (IIS)
*/

#define IISCON                  (*((volatile unsigned int  *) 0x44700000)) // IIS control
#define IISMOD                  (*((volatile unsigned int  *) 0x44700004)) // IIS mode
#define IISPSR                  (*((volatile unsigned int  *) 0x44700008)) // IIS prescaler
#define IISFCON                 (*((volatile unsigned int  *) 0x4470000c)) // IIS FIFO control
#define IISFIFO                 (*((volatile unsigned short*) 0x44700010)) // IIS FIFO entry


/*
** GPIO
*/

#define GPCON_U                 (*((volatile unsigned int  *) 0x44800000)) // GPIO ports configuration register
#define GPCON_M                 (*((volatile unsigned int  *) 0x44800004)) // GPIO ports configuration register
#define GPCON_L                 (*((volatile unsigned int  *) 0x44800008)) // GPIO ports configuration register
#define GPDAT                   (*((volatile unsigned int  *) 0x4480000c)) // GPIO ports data register
#define GPPU                    (*((volatile unsigned int  *) 0x44800010)) // GPIO ports pull-up control register
#define EXTINTC0                (*((volatile unsigned int  *) 0x44800018)) // External interrupt control register 0
#define EXTINTC1                (*((volatile unsigned int  *) 0x4480001c)) // External interrupt control register 1
#define EXTINTC2                (*((volatile unsigned int  *) 0x44800020)) // External interrupt control register 2
#define EINTFLT0                (*((volatile unsigned int  *) 0x44800024)) // External interrupt filter control register 0
#define EINTFLT1                (*((volatile unsigned int  *) 0x44800028)) // External interrupt filter control register 1
#define EINTMASK                (*((volatile unsigned int  *) 0x44800034)) // External interupt mask register
#define EINTPEND                (*((volatile unsigned int  *) 0x44800038)) // External interupt pending register
#define PERIPU                  (*((volatile unsigned int  *) 0x44800040)) // Peri. ports pull-up control register
#define ALIVECON                (*((volatile unsigned int  *) 0x44800044)) // Alive control register
#define GPDAT_SLEEP             (*((volatile unsigned int  *) 0x44800048)) // GPIO output data for sleep mode
#define GPOEN_SLEEP             (*((volatile unsigned int  *) 0x4480004c)) // GPIO output enable control for sleep mode
#define GPPU_SLEEP              (*((volatile unsigned int  *) 0x44800050)) // GPIO pull-up control register for sleep mode
#define PERIDAT_SLEEP0          (*((volatile unsigned int  *) 0x44800054)) // Peri. ports output data control register 0 for sleep mode
#define PERIDAT_SLEEP1          (*((volatile unsigned int  *) 0x44800058)) // Peri. ports output data control register 1 for sleep mode
#define PERIOEN_SLEEP0          (*((volatile unsigned int  *) 0x4480005c)) // Peri. ports output control register 0 for sleep mode
#define PERIOEN_SLEEP1          (*((volatile unsigned int  *) 0x44800060)) // Peri. ports output control register 1 for sleep mode
#define PERIPU_SLEEP            (*((volatile unsigned int  *) 0x44800064)) // Peri. ports pull-up control register for slee mode
#define RSTCNT                  (*((volatile unsigned int  *) 0x44800068)) // Reset count compare register
#define GPRAM0                  (*((volatile unsigned int  *) 0x44800080)) // General purpose RAM word 0
#define GPRAM1                  (*((volatile unsigned int  *) 0x44800084)) // General purpose RAM word 1
#define GPRAM2                  (*((volatile unsigned int  *) 0x44800088)) // General purpose RAM word 2
#define GPRAM3                  (*((volatile unsigned int  *) 0x4480008c)) // General purpose RAM word 3
#define GPRAM4                  (*((volatile unsigned int  *) 0x44800090)) // General purpose RAM word 4
#define GPRAM5                  (*((volatile unsigned int  *) 0x44800094)) // General purpose RAM word 5
#define GPRAM6                  (*((volatile unsigned int  *) 0x44800098)) // General purpose RAM word 6
#define GPRAM7                  (*((volatile unsigned int  *) 0x4480009c)) // General purpose RAM word 7
#define GPRAM8                  (*((volatile unsigned int  *) 0x448000a0)) // General purpose RAM word 8
#define GPRAM9                  (*((volatile unsigned int  *) 0x448000a4)) // General purpose RAM word 9
#define GPRAM10                 (*((volatile unsigned int  *) 0x448000a8)) // General purpose RAM word 10
#define GPRAM11                 (*((volatile unsigned int  *) 0x448000ac)) // General purpose RAM word 11
#define GPRAM12                 (*((volatile unsigned int  *) 0x448000b0)) // General purpose RAM word 12
#define GPRAM13                 (*((volatile unsigned int  *) 0x448000b4)) // General purpose RAM word 13
#define GPRAM14                 (*((volatile unsigned int  *) 0x448000b8)) // General purpose RAM word 14
#define GPRAM15                 (*((volatile unsigned int  *) 0x448000bc)) // General purpose RAM word 15


/*
** Key Pad Interface
*/

#define KEYDAT                  (*((volatile unsigned int  *) 0x44900000)) // The data register for KEYPAD input
#define KEYINTC                 (*((volatile unsigned int  *) 0x44900004)) // KEYPAD input ports interrupt control
#define KEYFLT0                 (*((volatile unsigned int  *) 0x44900008)) // KEYPAD input filter control
#define KEYFLT1                 (*((volatile unsigned int  *) 0x4490000c)) // KEYPAD input filter control
#define KEYMAN                  (*((volatile unsigned int  *) 0x44900010)) // KEYPAD manual scan control


/*
** USB Device
*/

#define FUNC_ADDR_REG           (*((volatile unsigned char *) 0x44a00140)) // Function address
#define PWR_REG                 (*((volatile unsigned char *) 0x44a00144)) // Power management
#define EP_INT_REG              (*((volatile unsigned char *) 0x44a00148)) // EP interrupt pending and clear
#define USB_INT_REG             (*((volatile unsigned char *) 0x44a00158)) // USB interrupt pending and clear
#define EP_INT_EN_REG           (*((volatile unsigned char *) 0x44a0015c)) // Interrupt enable
#define USB_INT_EN_REG          (*((volatile unsigned char *) 0x44a0016c)) // Interrupt enbale
#define FRAME_NUM1_REG          (*((volatile unsigned char *) 0x44a00170)) // Frame number lower byte
#define FRAME_NUM2_REG          (*((volatile unsigned char *) 0x44a00174)) // Frame number lower byte
#define INDEX_REG               (*((volatile unsigned char *) 0x44a00178)) // Register index
#define EP0_CSR                 (*((volatile unsigned char *) 0x44a00184)) // Endpoint 0 status
#define IN_CSR1_REG             (*((volatile unsigned char *) 0x44a00184)) // In endpoint control status
#define IN_CSR2_REG             (*((volatile unsigned char *) 0x44a00188)) // In endpoint control status
#define MAXP_REG                (*((volatile unsigned char *) 0x44a00180)) // Endpoint max packet
#define OUT_CSR1_REG            (*((volatile unsigned char *) 0x44a00190)) // Out endpoint control status
#define OUT_CSR2_REG            (*((volatile unsigned char *) 0x44a00194)) // Out endpoint control status
#define OUT_FIFO_CNT1_REG       (*((volatile unsigned char *) 0x44a00198)) // Endpoint out write count
#define OUT_FIFO_CNT2_REG       (*((volatile unsigned char *) 0x44a0019c)) // Endpoint out write count
#define EP0_FIFO                (*((volatile unsigned char *) 0x44a001c0)) // Endpoint 0 FIFO
#define EP1_FIFO                (*((volatile unsigned char *) 0x44a001c4)) // Endpoint 1 FIFO
#define EP2_FIFO                (*((volatile unsigned char *) 0x44a001c8)) // Endpoint 2 FIFO
#define EP3_FIFO                (*((volatile unsigned char *) 0x44a001cc)) // Endpoint 3 FIFO
#define EP4_FIFO                (*((volatile unsigned char *) 0x44a001d0)) // Endpoint 4 FIFO
#define EP1_DMA_CON             (*((volatile unsigned char *) 0x44a00200)) // EP1 DMA interface control
#define EP1_DMA_UNIT            (*((volatile unsigned char *) 0x44a00204)) // EP1 DMA Tx unit counter
#define EP1_DMA_FIFO            (*((volatile unsigned char *) 0x44a00208)) // EP1 DMA Tx FIFO counter
#define EP1_DMA_TTC_L           (*((volatile unsigned char *) 0x44a0020c)) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00210)) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_H           (*((volatile unsigned char *) 0x44a00214)) // EP1 DMA total Tx counter
#define EP2_DMA_CON             (*((volatile unsigned char *) 0x44a00218)) // EP2 DMA interface control
#define EP2_DMA_UNIT            (*((volatile unsigned char *) 0x44a0021c)) // EP2 DMA Tx Unit counter
#define EP2_DMA_FIFO            (*((volatile unsigned char *) 0x44a00220)) // EP2 DMA Tx FIFO counter
#define EP2_DMA_TTC_L           (*((volatile unsigned char *) 0x44a00224)) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00228)) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_H           (*((volatile unsigned char *) 0x44a0022c)) // EP2 DMA total Tx counter
#define EP3_DMA_CON             (*((volatile unsigned char *) 0x44a00240)) // EP3 DMA interface control
#define EP3_DMA_UNIT            (*((volatile unsigned char *) 0x44a00244)) // EP3 DMA Tx unit counter
#define EP3_DMA_FIFO            (*((volatile unsigned char *) 0x44a00248)) // EP3 DMA Tx FIFO counter
#define EP3_DMA_TTC_L           (*((volatile unsigned char *) 0x44a0024c)) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00250)) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_H           (*((volatile unsigned char *) 0x44a00254)) // EP3 DMA total Tx counter
#define EP4_DMA_CON             (*((volatile unsigned char *) 0x44a00258)) // EP4 DMA interface control
#define EP4_DMA_UNIT            (*((volatile unsigned char *) 0x44a0025c)) // EP4 DMA Tx Unit counter
#define EP4_DMA_FIFO            (*((volatile unsigned char *) 0x44a00260)) // EP4 DMA Tx FIFO counter
#define EP4_DMA_TTC_L           (*((volatile unsigned char *) 0x44a00264)) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00268)) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_H           (*((volatile unsigned char *) 0x44a0026c)) // EP4 DMA total Tx counter


/*
** AC97 Controller
*/

#define AC_GLBCTRL              (*((volatile unsigned int  *) 0x45000000)) // AC97 global control
#define AC_GLBSTAT              (*((volatile unsigned int  *) 0x45000004)) // AC97 global status
#define AC_CODEC_CMD            (*((volatile unsigned int  *) 0x45000008)) // AC97 codec command
#define AC_CODEC_STAT           (*((volatile unsigned int  *) 0x4500000c)) // AC97 codec status
#define AC_PCM_ADDR             (*((volatile unsigned int  *) 0x45000010)) // AC97 PCM out/in channel FIFO address
#define AC_MICADDR              (*((volatile unsigned int  *) 0x45000014)) // AC97 MIC in channel FIFO address
#define AC_PCMDATA              (*((volatile unsigned int  *) 0x45000018)) // AC97 PCM out/in channel FIFO data
#define AC_MICDATA              (*((volatile unsigned int  *) 0x4500001c)) // AC97 MIC in channel FIFO data


/*
** Analog-to-Digital Converter & Touch Screen
*/

#define ADCCON                  (*((volatile unsigned int  *) 0x45800000)) // ADC control
#define ADCTSC                  (*((volatile unsigned int  *) 0x45800004)) // ADC touch screen control
#define ADCDLY                  (*((volatile unsigned int  *) 0x45800008)) // ADC start or interval delay
#define ADCDAX                  (*((volatile unsigned int  *) 0x4580000c)) // ADC conversion data register X
#define ADCDAY                  (*((volatile unsigned int  *) 0x45800010)) // ADC conversion data register Y


/*
** SD and SDIO / MMC
*/

#define SDICON                  (*((volatile unsigned int  *) 0x46000000)) // SDI control
#define SDIPRE                  (*((volatile unsigned int  *) 0x46000004)) // SDI buad rate prescaler
#define SDICARG                 (*((volatile unsigned int  *) 0x46000008)) // SDI command argument
#define SDICCON                 (*((volatile unsigned int  *) 0x4600000c)) // SDI command control
#define SDICSTA                 (*((volatile unsigned int  *) 0x46000010)) // SDI command status
#define SDIRSP0                 (*((volatile unsigned int  *) 0x46000014)) // SDI response
#define SDIRSP1                 (*((volatile unsigned int  *) 0x46000018)) // SDI response
#define SDIRSP2                 (*((volatile unsigned int  *) 0x4600001c)) // SDI response
#define SDIRSP3                 (*((volatile unsigned int  *) 0x46000020)) // SDI response
#define SDIDTIMER               (*((volatile unsigned int  *) 0x46000024)) // SDI data / busy timer
#define SDIBSIZE                (*((volatile unsigned int  *) 0x46000028)) // SDI block size
#define SDIDCON                 (*((volatile unsigned int  *) 0x4600002c)) // SDI data control
#define SDIDCNT                 (*((volatile unsigned int  *) 0x46000030)) // SDI data remain counter
#define SDIDSTA                 (*((volatile unsigned int  *) 0x46000034)) // SDI data status
#define SDIFSTA                 (*((volatile unsigned int  *) 0x46000038)) // SDI FIFO status
#define SDIIMSK                 (*((volatile unsigned int  *) 0x4600003c)) // SDI interrupt mask
#define SDIDAT0                 (*((volatile unsigned int  *) 0x46000040)) // SDI data0
#define SDIDAT1                 (*((volatile unsigned int  *) 0x46000044)) // SDI data1
#define SDIDAT2                 (*((volatile unsigned int  *) 0x46000048)) // SDI data2
#define SDIDAT3                 (*((volatile unsigned int  *) 0x4600004c)) // SDI data3


/*
** Memory Stick
*/

#define MSPRE                   (*((volatile unsigned int  *) 0x46100000)) // Prescaler control
#define MSFINTCON               (*((volatile unsigned int  *) 0x46100004)) // FIFO interrupt control
#define TP_CMD                  (*((volatile unsigned int  *) 0x46108000)) // Transfer protocol command
#define CTRL_STA                (*((volatile unsigned int  *) 0x46108004)) // Command and status
#define DAT_FIFO                (*((volatile unsigned int  *) 0x46108008)) // Data FIFO
#define INTCTRL_STA             (*((volatile unsigned int  *) 0x4610800c)) // Interrupt control and status
#define INS_CON                 (*((volatile unsigned int  *) 0x46108010)) // INS port control
#define ACMD_CON                (*((volatile unsigned int  *) 0x46108014)) // Auto command and polarity control
#define ATP_CMD                 (*((volatile unsigned int  *) 0x46108018)) // Auto transfer protocol command


/*
** Camera Interface
*/

#define CISRCFMT                (*((volatile unsigned int  *) 0x48000000)) // Input source format
#define CIWDOFST                (*((volatile unsigned int  *) 0x48000004)) // Window offset register
#define CIGCTRL                 (*((volatile unsigned int  *) 0x48000008)) // Global control register
#define CICOYSA1                (*((volatile unsigned int  *) 0x48000018)) // Y 1st frame start address for codec DMA
#define CICOYSA2                (*((volatile unsigned int  *) 0x4800001c)) // Y 2nd frame start address for codec DMA
#define CICOYSA3                (*((volatile unsigned int  *) 0x48000020)) // Y 3nd frame start address for codec DMA
#define CICOYSA4                (*((volatile unsigned int  *) 0x48000024)) // Y 4th frame start address for codec DMA
#define CICOCBSA1               (*((volatile unsigned int  *) 0x48000028)) // Cb 1st frame start address for codec DMA
#define CICOCBSA2               (*((volatile unsigned int  *) 0x4800002c)) // Cb 2nd frame start address for codec DMA
#define CICOCBSA3               (*((volatile unsigned int  *) 0x48000030)) // Cb 3nd frame start address for codec DMA
#define CICOCBSA4               (*((volatile unsigned int  *) 0x48000034)) // Cb 4th frame start address for codec DMA
#define CICOCRSA1               (*((volatile unsigned int  *) 0x48000038)) // Cr 1st frame start address for codec DMA
#define CICOCRSA2               (*((volatile unsigned int  *) 0x4800003c)) // Cr 2nd frame start address for codec DMA
#define CICOCRSA3               (*((volatile unsigned int  *) 0x48000040)) // Cr 3rd frame start address for codec DMA
#define CICOCRSA4               (*((volatile unsigned int  *) 0x48000044)) // Cr 4th frame start address for codec DMA
#define CICOTRGFMT              (*((volatile unsigned int  *) 0x48000048)) // Target image format of codec DMA
#define CICOCTRL                (*((volatile unsigned int  *) 0x4800004c)) // Codec DMA control related
#define CICOSCPRERATIO          (*((volatile unsigned int  *) 0x48000050)) // Codec pre-scaler ratio control
#define CICOSCPREDST            (*((volatile unsigned int  *) 0x48000054)) // Codec pre-scaler destination format
#define CICOSCCTRL              (*((volatile unsigned int  *) 0x48000058)) // Codec main-scaler control
#define CICOTAREA               (*((volatile unsigned int  *) 0x4800005c)) // Codec pre-scaler destination format
#define CICOSTATUS              (*((volatile unsigned int  *) 0x48000064)) // Codec path status
#define CIPRCLRSA1              (*((volatile unsigned int  *) 0x4800006c)) // RGB 1st frame start address for preview DMA
#define CIPRCLRSA2              (*((volatile unsigned int  *) 0x48000070)) // RGB 2nd frame start address for preview DMA
#define CIPRCLRSA3              (*((volatile unsigned int  *) 0x48000074)) // RGB 3rd frame start address for preview DMA
#define CIPRCLRSA4              (*((volatile unsigned int  *) 0x48000078)) // RGB 4th frame start address for preview DMA
#define CIPRTRGFMT              (*((volatile unsigned int  *) 0x4800007c)) // Target image format of preview DMA
#define CIPRCTRL                (*((volatile unsigned int  *) 0x48000080)) // Preview DMA control related
#define CIPRSCPRERATIO          (*((volatile unsigned int  *) 0x48000084)) // Preview pre-scaler ratio control
#define CIPRSCPREDST            (*((volatile unsigned int  *) 0x48000088)) // Preview pre-scaler destination format
#define CIPRSCCTRL              (*((volatile unsigned int  *) 0x4800008c)) // Preview main-scaler control
#define CIPRTAREA               (*((volatile unsigned int  *) 0x48000090)) // Preview pre-scaler destination format
#define CIPRSTATUS              (*((volatile unsigned int  *) 0x48000098)) // Preview path status
#define CIIMGCPT                (*((volatile unsigned int  *) 0x480000a0)) // Image capture enable command


/*
** MPEG-4 Video Codec
*/

/* Motion Estimation */
#define ME_CFSA                 (*((volatile unsigned int  *) 0x48800000)) // Current Frame Start Address Register
#define ME_PFSA                 (*((volatile unsigned int  *) 0x48800004)) // Previous Frame Start Address Register
#define ME_MVSA                 (*((volatile unsigned int  *) 0x48800008)) // Motion Vector Start Address Register
#define ME_CMND                 (*((volatile unsigned int  *) 0x4880000c)) // Command Register
#define ME_STAT_SWR             (*((volatile unsigned int  *) 0x48800010)) // Status & S/W Reset Register
#define ME_CNFG                 (*((volatile unsigned int  *) 0x48800014)) // Configuration Register
#define ME_IMGFMT               (*((volatile unsigned int  *) 0x48800018)) // Image Format Register

/* Motion Compensation */
#define MC_PFYSA_ENC            (*((volatile unsigned int  *) 0x48c00000)) // Previous frame Y start address register for the encoder
#define MC_CFYSA_ENC            (*((volatile unsigned int  *) 0x48c00004)) // MCed frame Y start address register for the encoder
#define MC_PFYSA_DEC            (*((volatile unsigned int  *) 0x48c00008)) // Previous frame Y start address register for the decoder
#define MC_CFYSA_DEC            (*((volatile unsigned int  *) 0x48c0000c)) // MCed frame Y start address register for the decoder
#define MC_PFCbSA_ENC           (*((volatile unsigned int  *) 0x48c00010)) // Previous frame Cb start address register for the encoder
#define MC_PFCrSA_ENC           (*((volatile unsigned int  *) 0x48c00014)) // Previous frame Cr start address register for the encoder
#define MC_CFCbSA_ENC           (*((volatile unsigned int  *) 0x48c00018)) // MCed frame Cb start address register for the encoder
#define MC_CFCrSA_ENC           (*((volatile unsigned int  *) 0x48c0001c)) // MCed frame Cr start address register for the encoder
#define MC_PFCbSA_DEC           (*((volatile unsigned int  *) 0x48c00020)) // Previous frame Cb start address register for the decoder
#define MC_PFCrSA_DEC           (*((volatile unsigned int  *) 0x48c00024)) // Previous frame Cr start address register for the decoder
#define MC_CFCbSA_DEC           (*((volatile unsigned int  *) 0x48c00028)) // MCed frame Cb start address register for the decoder
#define MC_CFCrSA_DEC           (*((volatile unsigned int  *) 0x48c0002c)) // MCed frame Cr start address register for the decoder
#define MC_MVSA_ENC             (*((volatile unsigned int  *) 0x48c00030)) // Motion vector start address register for the encoder
#define MC_MVSA_DEC             (*((volatile unsigned int  *) 0x48c00034)) // Motion vector start address register for the decoder
#define MC_CMND                 (*((volatile unsigned int  *) 0x48c00038)) // Command register
#define MC_STAT_SWR             (*((volatile unsigned int  *) 0x48c0003c)) // Status & S/W reset register
#define MC_CNFG                 (*((volatile unsigned int  *) 0x48c00040)) // Configuration register
#define MC_IMGFMT               (*((volatile unsigned int  *) 0x48c00044)) // Image format register

/* DCTQ */
#define SAYCF                   (*((volatile unsigned int  *) 0x49000000)) // Current frame luminance start address
#define SACBCF                  (*((volatile unsigned int  *) 0x49000004)) // Current frame Cb start address
#define SACRCF                  (*((volatile unsigned int  *) 0x49000008)) // Current frame Cr start address
#define SAYRF                   (*((volatile unsigned int  *) 0x4900000c)) // Reconstruction frame luminance start address
#define SACBRF                  (*((volatile unsigned int  *) 0x49000010)) // Reconstruction frame Cb start address
#define SACRRF                  (*((volatile unsigned int  *) 0x49000014)) // Reconstruction frame Cr start address
#define SAYDQF                  (*((volatile unsigned int  *) 0x49000018)) // DCTQed frame luminance start address
#define SACBDQF                 (*((volatile unsigned int  *) 0x4900001c)) // DCTQed frame Cb start address
#define SACRDQF                 (*((volatile unsigned int  *) 0x49000020)) // DCTQed frame Cr start address
#define SAQP                    (*((volatile unsigned int  *) 0x49000024)) // Qp start address
#define IMGSIZE                 (*((volatile unsigned int  *) 0x49000028)) // Image horizontal and vertical pixel number
#define SHQ                     (*((volatile unsigned int  *) 0x4900002c)) // Short header quantization mode
#define DCTQCTRL                (*((volatile unsigned int  *) 0x49000034)) // Control register

/* VLX */
#define VLX_COMMON1             (*((volatile unsigned int  *) 0x49400000)) // VLX common control register1
#define VLX_FRAMESTARTY         (*((volatile unsigned int  *) 0x49400004)) // Y coeff. start address
#define VLX_FRAMESTARTCB        (*((volatile unsigned int  *) 0x49400008)) // Cb coeff. frame start address
#define VLX_FRAMESTARTCR        (*((volatile unsigned int  *) 0x4940000c)) // Cr coeff. frame start address
#define VLC_CON1                (*((volatile unsigned int  *) 0x49400010)) // Control register in VLC mode
#define VLC_CON2                (*((volatile unsigned int  *) 0x49400014)) // Reserved
#define VLC_CON3                (*((volatile unsigned int  *) 0x49400018)) // VLC result external address
#define VLC_CON4                (*((volatile unsigned int  *) 0x4940001c)) // Reserved
#define VLD_CON1                (*((volatile unsigned int  *) 0x49400020)) // Control register in VLD mode
#define VLD_CON2                (*((volatile unsigned int  *) 0x49400024)) // VLCed bit stream start address
#define VLD_CON3                (*((volatile unsigned int  *) 0x49400028)) // Reserved
#define VLX_OUT1                (*((volatile unsigned int  *) 0x4940002c)) // VLX output information register 1
#define VLX_OUT2                (*((volatile unsigned int  *) 0x49400030)) // VLX output information register 2


/*
** LCD Controller
*/

#define LCDCON1                 (*((volatile unsigned int  *) 0x4a000000)) // LCD control 1
#define LCDCON2                 (*((volatile unsigned int  *) 0x4a000004)) // LCD control 2
#define LCDTCON1                (*((volatile unsigned int  *) 0x4a000008)) // LCD time control 1
#define LCDTCON2                (*((volatile unsigned int  *) 0x4a00000c)) // LCD time control 2
#define LCDTCON3                (*((volatile unsigned int  *) 0x4a000010)) // LCD time control 3
#define LCDOSD1                 (*((volatile unsigned int  *) 0x4a000014)) // LCD OSD control register
#define LCDOSD2                 (*((volatile unsigned int  *) 0x4a000018)) // Foreground image(OSD Image) left top position set
#define LCDOSD3                 (*((volatile unsigned int  *) 0x4a00001c)) // Foreground image(OSD Image) right bottom position set
#define LCDSADDRB1              (*((volatile unsigned int  *) 0x4a000020)) // frame buffer start address 1 (background buffer 1)
#define LCDSADDRB2              (*((volatile unsigned int  *) 0x4a000024)) // Frame buffer start address 2 (background buffer 2)
#define LCDSADDRF1              (*((volatile unsigned int  *) 0x4a000028)) // Frame buffer start address 1 (foreground buffer 1)
#define LCDSADDRF2              (*((volatile unsigned int  *) 0x4a00002c)) // Frame buffer start address 2 (foreground buffer 2)
#define LCDEADDRB1              (*((volatile unsigned int  *) 0x4a000030)) // Frame buffer end address 1 (background buffer 1)
#define LCDEADDRB2              (*((volatile unsigned int  *) 0x4a000034)) // Frame buffer end address 2 (background buffer 2)
#define LCDEADDRF1              (*((volatile unsigned int  *) 0x4a000038)) // Frame buffer end address 1 (foreground buffer 1)
#define LCDEADDRF2              (*((volatile unsigned int  *) 0x4a00003c)) // Frame buffer end address 2 (foreground buffer 2)
#define LCDVSCRB1               (*((volatile unsigned int  *) 0x4a000040)) // Virtual screen offsize and pagewidth (Background buffer 1)
#define LCDVSCRB2               (*((volatile unsigned int  *) 0x4a000044)) // Virtual screen offsize and pagewidth (Background buffer 2)
#define LCDVSCRF1               (*((volatile unsigned int  *) 0x4a000048)) // Virtual screen offsize and pagewidth (Foreground buffer 1)
#define LCDVSCRF2               (*((volatile unsigned int  *) 0x4a00004c)) // Virtual screen offsize and pagewidth (Foreground buffer 2)
#define LCDINTCON               (*((volatile unsigned int  *) 0x4a000050)) // LCD Interrupt Control
#define LCDKEYCON               (*((volatile unsigned int  *) 0x4a000054)) // Color key control 1
#define LCDKEYVAL               (*((volatile unsigned int  *) 0x4a000058)) // Color key control 2
#define LCDBGCON                (*((volatile unsigned int  *) 0x4a00005c)) // Back-ground color Control
#define LCDFGCON                (*((volatile unsigned int  *) 0x4a000060)) // Fore-ground color Control
#define LCDDITHCON              (*((volatile unsigned int  *) 0x4a000064)) // LCD dithering control for active matrix


/*
** Post Processor
*/

#define MODE                    (*((volatile unsigned int  *) 0x4a100000)) // Mode Register [9:0]
#define PreScale_Ratio          (*((volatile unsigned int  *) 0x4a100004)) // Pre-Scale ratio for vertical and horizontal.
#define PreScaleImgSize         (*((volatile unsigned int  *) 0x4a100008)) // Pre-Scaled image size
#define SRCImgSize              (*((volatile unsigned int  *) 0x4a10000c)) // Source image size
#define MainScale_H_Ratio       (*((volatile unsigned int  *) 0x4a100010)) // Main scale ratio along to horizontal direction
#define MainScale_V_Ratio       (*((volatile unsigned int  *) 0x4a100014)) // Main scale ratio along to vertical direction
#define DSTImgSize              (*((volatile unsigned int  *) 0x4a100018)) // Destination image size
#define PreScale_SHFactor       (*((volatile unsigned int  *) 0x4a10001c)) // Pre-scale shift factor
#define ADDRStart_Y             (*((volatile unsigned int  *) 0x4a100020)) // DMA Start address for Y or RGB component
#define ADDRStart_Cb            (*((volatile unsigned int  *) 0x4a100024)) // DMA Start address for Cb component
#define ADDRStart_Cr            (*((volatile unsigned int  *) 0x4a100028)) // DMA Start address for Cr component
#define ADDRStart_RGB           (*((volatile unsigned int  *) 0x4a10002c)) // DMA Start address for RGB component
#define ADDREnd_Y               (*((volatile unsigned int  *) 0x4a100030)) // DMA End address for Y or RGB component
#define ADDREnd_Cb              (*((volatile unsigned int  *) 0x4a100034)) // DMA End address for Cb component
#define ADDREnd_Cr              (*((volatile unsigned int  *) 0x4a100038)) // DMA End address for Cr component
#define ADDREnd_RGB             (*((volatile unsigned int  *) 0x4a10003c)) // DMA End address for RGB component
#define Offset_Y                (*((volatile unsigned int  *) 0x4a100040)) // Offset of Y component for fetching source image
#define Offset_Cb               (*((volatile unsigned int  *) 0x4a100044)) // Offset of Cb component for fetching source image
#define Offset_Cr               (*((volatile unsigned int  *) 0x4a100048)) // Offset of Cr component for fetching source image
#define Offset_RGB              (*((volatile unsigned int  *) 0x4a10004c)) // Offset of RGB component for restoring destination image


#endif   /* _S3C24A0_H */
