/**************************************************************************
**                                                                        *
**  FILE        :  s3c2460.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C2460        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C2460_H
#define _S3C2460_H


/*
** System Clock Control and System Power-management Control
*/

#define LOCKTIME0               (*((volatile unsigned int  *) 0x40000000)) // PLL Lockup Time Count Value Register 0
#define LOCKTIME1               (*((volatile unsigned int  *) 0x40000004)) // PLL Lockup Time Count Value Register 1
#define OSCSET                  (*((volatile unsigned int  *) 0x40000008)) // Crystal Oscillator settle-down wait time Register
#define MPLLCON                 (*((volatile unsigned int  *) 0x40000010)) // MPLL control register
#define UPLLCON                 (*((volatile unsigned int  *) 0x40000014)) // UPLL control register
#define EPLLCON                 (*((volatile unsigned int  *) 0x40000018)) // EPLL control register
#define CLKSRCON                (*((volatile unsigned int  *) 0x40000020)) // Clock Source control register
#define CLKDIVCON               (*((volatile unsigned int  *) 0x40000024)) // Clock division control register
#define CLKOUTCON               (*((volatile unsigned int  *) 0x40000028)) // Clock Out pin Configure register
#define HCLKCON                 (*((volatile unsigned int  *) 0x40000030)) // AHB Clock Control register
#define PCLKCON                 (*((volatile unsigned int  *) 0x40000034)) // APB Clock Control register
#define SCLKCON                 (*((volatile unsigned int  *) 0x40000038)) // Special Clock Control register
#define PWRMODECON              (*((volatile unsigned int  *) 0x40000040)) // Power mode control Register
#define SWRSTCON                (*((volatile unsigned int  *) 0x40000044)) // Software Reset control Register
#define M_D_BUSPRI              (*((volatile unsigned int  *) 0x40000050)) // M and D-Bus Priority configure register
#define F_I_BUSPRI              (*((volatile unsigned int  *) 0x40000054)) // F and I-Bus Priority configure register
#define BUS_MISC                (*((volatile unsigned int  *) 0x40000058)) // Miscellaneous Bus Control register(hidden)
#define CHIP_ID                 (*((volatile unsigned int  *) 0x4000005c)) // System ID Register
#define PWRCFG                  (*((volatile unsigned int  *) 0x40000060)) // Power management configuration Register
#define RSTCNT                  (*((volatile unsigned int  *) 0x40000064)) // Reset Count Value Register
#define RSTSTAT                 (*((volatile unsigned int  *) 0x40000068)) // Reset Status Register
#define WKUPSTAT                (*((volatile unsigned int  *) 0x4000006c)) // Wake-up Status Register
#define INFORM0                 (*((volatile unsigned int  *) 0x40000070)) // Sleep Mode Information Register 0
#define INFORM1                 (*((volatile unsigned int  *) 0x40000074)) // Sleep Mode Information Register 1
#define INFORM2                 (*((volatile unsigned int  *) 0x40000078)) // Sleep Mode Information Register 2
#define INFORM3                 (*((volatile unsigned int  *) 0x4000007c)) // Sleep Mode Information Register 3


/*
** Interrupt controller
*/

#define SRCPND                  (*((volatile unsigned int  *) 0x40200000)) // Indicate the interrupt request status
#define INTMOD                  (*((volatile unsigned int  *) 0x40200004)) // Interrupt mode register
#define INTMSK                  (*((volatile unsigned int  *) 0x40200008)) // Interrupt mask register
#define INTPND                  (*((volatile unsigned int  *) 0x40200010)) // Indicate the interrupt request status
#define INTOFFSET               (*((volatile unsigned int  *) 0x40200014)) // Indicate the IRQ interrupt request source
#define SUBSRCPND1              (*((volatile unsigned int  *) 0x40200018)) // Indicate the interrupt request status
#define INTSUBMSK1              (*((volatile unsigned int  *) 0x4020001c)) // Interrupt mask register
#define SUBSRCPND2              (*((volatile unsigned int  *) 0x40200030)) // Indicate the interrupt request status
#define INTSUBMSK2              (*((volatile unsigned int  *) 0x40200034)) // Interrupt mask register
#define PRIORITY_MODE           (*((volatile unsigned int  *) 0x40200038)) // IRQ priority mode register
#define PRIORITY_UPDATE         (*((volatile unsigned int  *) 0x4020003c)) // IRQ priority update register


/*
** DSP subsystem
*/

#define DSPDMA0_DISRC           (*((volatile unsigned int  *) 0x40300000)) // DSP-DMA0 Initial Source Register
#define DSPDMA0_DISRCC          (*((volatile unsigned int  *) 0x40300004)) // DSP-DMA0 Initial Source Control Register
#define DSPDMA0_DIDST           (*((volatile unsigned int  *) 0x40300008)) // DSP-DMA0 Initial Destination Register
#define DSPDMA0_DIDSTC          (*((volatile unsigned int  *) 0x4030000c)) // DSP-DMA0 Initial Destination Control Register
#define DSPDMA0_DCON            (*((volatile unsigned int  *) 0x40300010)) // DSP-DMA0 Control Register
#define DSPDMA0_DSTAT           (*((volatile unsigned int  *) 0x40300014)) // DSP-DMA0 Count Register
#define DSPDMA0_DCSRC           (*((volatile unsigned int  *) 0x40300018)) // DSP-DMA0 Current Source Register
#define DSPDMA0_DCDST           (*((volatile unsigned int  *) 0x4030001c)) // DSP-DMA0 Current Destination Register
#define DSPDMA0_DMASKTRIG       (*((volatile unsigned int  *) 0x40300020)) // DSP-DMA0 Mask Trigger Register
#define DSPDMA0_DMAREQSEL       (*((volatile unsigned int  *) 0x40300024)) // DSP-DMA0 Request Selection Register

#define DSPDMA1_DISRC           (*((volatile unsigned int  *) 0x40301000)) // DSP-DMA1 Initial Source Register
#define DSPDMA1_DISRCC          (*((volatile unsigned int  *) 0x40301004)) // DSP-DMA1 Initial Source Control Register
#define DSPDMA1_DIDST           (*((volatile unsigned int  *) 0x40301008)) // DSP-DMA1 Initial Destination Register
#define DSPDMA1_DIDSTC          (*((volatile unsigned int  *) 0x4030100c)) // DSP-DMA1 Initial Destination Control Register
#define DSPDMA1_DCON            (*((volatile unsigned int  *) 0x40301010)) // DSP-DMA1 Control Register
#define DSPDMA1_DSTAT           (*((volatile unsigned int  *) 0x40301014)) // DSP-DMA1 Count Register
#define DSPDMA1_DCSRC           (*((volatile unsigned int  *) 0x40301018)) // DSP-DMA1 Current Source Register
#define DSPDMA1_DCDST           (*((volatile unsigned int  *) 0x4030101c)) // DSP-DMA1 Current Destination Register
#define DSPDMA1_DMASKTRIG       (*((volatile unsigned int  *) 0x40301020)) // DSP-DMA1 Mask Trigger Register
#define DSPDMA1_DMAREQSEL       (*((volatile unsigned int  *) 0x40301024)) // DSP-DMA1 Request Selection Register

#define DSPDMA2_DISRC           (*((volatile unsigned int  *) 0x40302000)) // DSP-DMA2 Initial Source Register
#define DSPDMA2_DISRCC          (*((volatile unsigned int  *) 0x40302004)) // DSP-DMA2 Initial Source Control Register
#define DSPDMA2_DIDST           (*((volatile unsigned int  *) 0x40302008)) // DSP-DMA2 Initial Destination Register
#define DSPDMA2_DIDSTC          (*((volatile unsigned int  *) 0x4030200c)) // DSP-DMA2 Initial Destination Control Register
#define DSPDMA2_DCON            (*((volatile unsigned int  *) 0x40302010)) // DSP-DMA2 Control Register
#define DSPDMA2_DSTAT           (*((volatile unsigned int  *) 0x40302014)) // DSP-DMA2 Count Register
#define DSPDMA2_DCSRC           (*((volatile unsigned int  *) 0x40302018)) // DSP-DMA2 Current Source Register
#define DSPDMA2_DCDST           (*((volatile unsigned int  *) 0x4030201c)) // DSP-DMA2 Current Destination Register
#define DSPDMA2_DMASKTRIG       (*((volatile unsigned int  *) 0x40302020)) // DSP-DMA2 Mask Trigger Register
#define DSPDMA2_DMAREQSEL       (*((volatile unsigned int  *) 0x40302024)) // DSP-DMA2 Request Selection Register

#define DSPDMA3_DISRC           (*((volatile unsigned int  *) 0x40303000)) // DSP-DMA3 Initial Source Register
#define DSPDMA3_DISRCC          (*((volatile unsigned int  *) 0x40303004)) // DSP-DMA3 Initial Source Control Register
#define DSPDMA3_DIDST           (*((volatile unsigned int  *) 0x40303008)) // DSP-DMA3 Initial Destination Register
#define DSPDMA3_DIDSTC          (*((volatile unsigned int  *) 0x4030300c)) // DSP-DMA3 Initial Destination Control Register
#define DSPDMA3_DCON            (*((volatile unsigned int  *) 0x40303010)) // DSP-DMA3 Control Register
#define DSPDMA3_DSTAT           (*((volatile unsigned int  *) 0x40303014)) // DSP-DMA3 Count Register
#define DSPDMA3_DCSRC           (*((volatile unsigned int  *) 0x40303018)) // DSP-DMA3 Current Source Register
#define DSPDMA3_DCDST           (*((volatile unsigned int  *) 0x4030301c)) // DSP-DMA3 Current Destination Register
#define DSPDMA3_DMASKTRIG       (*((volatile unsigned int  *) 0x40303020)) // DSP-DMA3 Mask Trigger Register
#define DSPDMA3_DMAREQSEL       (*((volatile unsigned int  *) 0x40303024)) // DSP-DMA3 Request Selection Register


/*
** DMA
*/

#define DISRC0                  (*((volatile unsigned int  *) 0x40400000)) // DMA 0 Initial source
#define DISRCC0                 (*((volatile unsigned int  *) 0x40400004)) // DMA 0 Initial source control
#define DIDST0                  (*((volatile unsigned int  *) 0x40400008)) // DMA 0 Initial Destination
#define DIDSTC0                 (*((volatile unsigned int  *) 0x4040000c)) // DMA 0 Initial Destination control
#define DCON0                   (*((volatile unsigned int  *) 0x40400010)) // DMA 0 Control
#define DSTAT0                  (*((volatile unsigned int  *) 0x40400014)) // DMA 0 Status
#define DCSRC0                  (*((volatile unsigned int  *) 0x40400018)) // DMA 0 Current source
#define DCDST0                  (*((volatile unsigned int  *) 0x4040001c)) // DMA 0 Current destination
#define DMASKTRIG0              (*((volatile unsigned int  *) 0x40400020)) // DMA 0 Mask trigger
#define DMAREQSEL0              (*((volatile unsigned int  *) 0x40400024)) // DMA 0 Request Selection Register

#define DISRC1                  (*((volatile unsigned int  *) 0x40400040)) // DMA 1 Initial source
#define DISRCC1                 (*((volatile unsigned int  *) 0x40400044)) // DMA 1 Initial source control
#define DIDST1                  (*((volatile unsigned int  *) 0x40400048)) // DMA 1 Initial Destination
#define DIDSTC1                 (*((volatile unsigned int  *) 0x4040004c)) // DMA 1 Initial Destination control
#define DCON1                   (*((volatile unsigned int  *) 0x40400050)) // DMA 1 Control
#define DSTAT1                  (*((volatile unsigned int  *) 0x40400054)) // DMA 1 Status
#define DCSRC1                  (*((volatile unsigned int  *) 0x40400058)) // DMA 1 Current source
#define DCDST1                  (*((volatile unsigned int  *) 0x4040005c)) // DMA 1 Current destination
#define DMASKTRIG1              (*((volatile unsigned int  *) 0x40400060)) // DMA 1 Mask trigger
#define DMAREQSEL1              (*((volatile unsigned int  *) 0x40400064)) // DMA 1 Request Selection Register

#define DISRC2                  (*((volatile unsigned int  *) 0x40400080)) // DMA 2 Initial source
#define DISRCC2                 (*((volatile unsigned int  *) 0x40400084)) // DMA 2 Initial source control
#define DIDST2                  (*((volatile unsigned int  *) 0x40400088)) // DMA 2 Initial Destination
#define DIDSTC2                 (*((volatile unsigned int  *) 0x4040008c)) // DMA 2 Initial Destination control
#define DCON2                   (*((volatile unsigned int  *) 0x40400090)) // DMA 2 Control
#define DSTAT2                  (*((volatile unsigned int  *) 0x40400094)) // DMA 2 Status
#define DCSRC2                  (*((volatile unsigned int  *) 0x40400098)) // DMA 2 Current source
#define DCDST2                  (*((volatile unsigned int  *) 0x4040009c)) // DMA 2 Current destination
#define DMASKTRIG2              (*((volatile unsigned int  *) 0x404000a0)) // DMA 2 Mask trigger
#define DMAREQSEL2              (*((volatile unsigned int  *) 0x404000a4)) // DMA 2 Request Selection Register

#define DISRC3                  (*((volatile unsigned int  *) 0x404000c0)) // DMA 3 Initial source
#define DISRCC3                 (*((volatile unsigned int  *) 0x404000c4)) // DMA 3 Initial source control
#define DIDST3                  (*((volatile unsigned int  *) 0x404000c8)) // DMA 3 Initial Destination
#define DIDSTC3                 (*((volatile unsigned int  *) 0x404000cc)) // DMA 3 Initial Destination control
#define DCON3                   (*((volatile unsigned int  *) 0x404000d0)) // DMA 3 Control
#define DSTAT3                  (*((volatile unsigned int  *) 0x404000d4)) // DMA 3 Status
#define DCSRC3                  (*((volatile unsigned int  *) 0x404000d8)) // DMA 3 Current source
#define DCDST3                  (*((volatile unsigned int  *) 0x404000dc)) // DMA 3 Current destination
#define DMASKTRIG3              (*((volatile unsigned int  *) 0x404000e0)) // DMA 3 Mask trigger
#define DMAREQSEL3              (*((volatile unsigned int  *) 0x404000e4)) // DMA 3 Request Selection Register


/*
** NAND Flash
*/

#define REG_CONF                (*((volatile unsigned int  *) 0x40c00000)) // NAND Flash Configuration register
#define REG_CONT                (*((volatile unsigned int  *) 0x40c00004)) // NAND Flash control register
#define REG_CMMD                (*((volatile unsigned int  *) 0x40c00008)) // NAND Flash command set register
#define REG_ADDR                (*((volatile unsigned int  *) 0x40c0000c)) // NAND Flash address set register
#define REG_DATA                (*((volatile unsigned int  *) 0x40c00010)) // NAND Flash data register
#define MECCData0               (*((volatile unsigned int  *) 0x40c00014)) // NAND Flash ECC register for main data read
#define MECCData1               (*((volatile unsigned int  *) 0x40c00018)) // NAND Flash ECC register for main data read
#define MECCData2               (*((volatile unsigned int  *) 0x40c0001c)) // NAND Flash ECC register for main data read
#define MECCData3               (*((volatile unsigned int  *) 0x40c00020)) // NAND Flash ECC register for main data read (Advance Flash memory have 4byte ECC code)
#define SECCData0               (*((volatile unsigned int  *) 0x40c00024)) // NAND Flash ECC register for spare area data read
#define SECCData1               (*((volatile unsigned int  *) 0x40c00028)) // NAND Flash ECC register for spare area data read
#define REG_STAT                (*((volatile unsigned int  *) 0x40c0002c)) // NAND Flash operation status register
#define REG_EStat0              (*((volatile unsigned int  *) 0x40c00030)) // NAND Flash ECC Status register for I/O [7:0]
#define REG_Estat1              (*((volatile unsigned int  *) 0x40c00034)) // NAND Flash ECC Status register for I/O [15:8]
#define REG_MECC0               (*((volatile unsigned int  *) 0x40c00038)) // NAND Flash ECC register for I/O [7:0]
#define REG_MECC1               (*((volatile unsigned int  *) 0x40c0003c)) // NAND Flash ECC register for data[15:8]
#define REG_SECC                (*((volatile unsigned int  *) 0x40c00040)) // NAND Flash ECC register for I/O [15:0]
#define REG_SBLK                (*((volatile unsigned int  *) 0x40c00044)) // NAND Flash programmable start block address
#define REG_EBLK                (*((volatile unsigned int  *) 0x40c00048)) // NAND Flash programmable end block address


/*
** SROM Controller
*/

#define SROM_BW                 (*((volatile unsigned int  *) 0x40c20000)) // SROM Bus width & wait control
#define SROM_BC0                (*((volatile unsigned int  *) 0x40c20004)) // SROM Bank0-1 control register
#define SROM_BC1                (*((volatile unsigned int  *) 0x40c20008)) // SROM Bank2-3 control register
#define SROM_BC2                (*((volatile unsigned int  *) 0x40c2000c)) // SROM Bank4-5 control register


/*
** DRAM Controller
*/

#define P1BANKCFG               (*((volatile unsigned int  *) 0x40c40000)) // Port 1 DRAM configuration register
#define P1BANKCON               (*((volatile unsigned int  *) 0x40c40004)) // Port 1 DRAM control register
#define P1REFRESH               (*((volatile unsigned int  *) 0x40c40008)) // Port 1 DRAM refresh control register
#define P1TIMEOUT               (*((volatile unsigned int  *) 0x40c4000c)) // Port 1 Write Buffer Time out control register

#define P2BANKCFG               (*((volatile unsigned int  *) 0x40c80000)) // Port 2 DRAM configuration register
#define P2BANKCON               (*((volatile unsigned int  *) 0x40c80004)) // Port 2 DRAM control register
#define P2REFRESH               (*((volatile unsigned int  *) 0x40c80008)) // Port 2 DRAM refresh control register
#define P2TIMEOUT               (*((volatile unsigned int  *) 0x40c8000c)) // Port 2 Write Buffer Time out control register


/*
** Bus Matrix
*/

#define	PRIORITY0		(*((volatile unsigned int  *) 0x40ce0000)) // Memory port 0 priority control register
#define	PRIORITY1		(*((volatile unsigned int  *) 0x40ce0004)) // Memory port 0 priority control register
#define	PRIORITY2		(*((volatile unsigned int  *) 0x40ce0008)) // Memory port 0 priority control register


/*
** USB Host Controller
*/

#define HcRevision              (*((volatile unsigned int  *) 0x41000000)) // Control and Status Group
#define HcControl               (*((volatile unsigned int  *) 0x41000004))
#define HcCommonStatus          (*((volatile unsigned int  *) 0x41000008))
#define HcInterruptStatus       (*((volatile unsigned int  *) 0x4100000c))
#define HcInterruptEnable       (*((volatile unsigned int  *) 0x41000010))
#define HcInterruptDisable      (*((volatile unsigned int  *) 0x41000014))

#define HcHCCA                  (*((volatile unsigned int  *) 0x41000018)) // Memory Pointer Group
#define HcPeriodCuttentED       (*((volatile unsigned int  *) 0x4100001c))
#define HcControlHeadED         (*((volatile unsigned int  *) 0x41000020))
#define HcControlCurrentED      (*((volatile unsigned int  *) 0x41000024))
#define HcBulkHeadED            (*((volatile unsigned int  *) 0x41000028))
#define HcBulkCurrentED         (*((volatile unsigned int  *) 0x4100002c))
#define HcDoneHead              (*((volatile unsigned int  *) 0x41000030))

#define HcRmInterval            (*((volatile unsigned int  *) 0x41000034)) // Frame Counter Group
#define HcFmRemaining           (*((volatile unsigned int  *) 0x41000038))
#define HcFmNumber              (*((volatile unsigned int  *) 0x4100003c))
#define HcPeriodicStart         (*((volatile unsigned int  *) 0x41000040))
#define HcLSThreshold           (*((volatile unsigned int  *) 0x41000044))

#define HcRhDescriptorA         (*((volatile unsigned int  *) 0x41000048)) // Root Hub Group
#define HcRhDescriptorB         (*((volatile unsigned int  *) 0x4100004c))
#define HcRhStatus              (*((volatile unsigned int  *) 0x41000050))
#define HcRhPortStatus1         (*((volatile unsigned int  *) 0x41000054))
#define HcRhPortStatus2         (*((volatile unsigned int  *) 0x41000058))


/*
** Modem Interface
*/

#define MSBM                    (*((volatile unsigned int  *) 0x41100000)) // MSM I/F SRAM buffer memory (AP side)

/* MSMIF */
#define INT2AP                  (*((volatile unsigned int  *) 0x41108000)) // Interrupt request to AP Register
#define INT2MSM                 (*((volatile unsigned int  *) 0x41108004)) // Interrupt request to MSM modem Register
#define MIFCON                  (*((volatile unsigned int  *) 0x41108008)) // Modem Interface Control Register
#define MDMASFRBASE             (*((volatile unsigned int  *) 0x4110800c)) // Two Modem Interface DMA Special Function Register (Modem side) Base Address

/* MDMA0 */
#define MDISRC0                 (*((volatile unsigned int  *) 0x41140000)) // MDMA0 Initial Source Register
#define MDISRCC0                (*((volatile unsigned int  *) 0x41140004)) // MDMA0 Initial Source Control Register
#define MDIDST0                 (*((volatile unsigned int  *) 0x41140008)) // MDMA0 Initial Destination Register
#define MDIDSTC0                (*((volatile unsigned int  *) 0x4114000c)) // MDMA0 Initial Destination Control Register
#define MDCON0                  (*((volatile unsigned int  *) 0x41140010)) // MDMA0 Control Register
#define MDSTAT0                 (*((volatile unsigned int  *) 0x41140014)) // MDMA0 Count Register
#define MDCSRC0                 (*((volatile unsigned int  *) 0x41140018)) // MDMA0 Current Source Register
#define MDCDST0                 (*((volatile unsigned int  *) 0x4114001c)) // MDMA0 Current Destination Register
#define MDMASKTRIG0             (*((volatile unsigned int  *) 0x41140020)) // MDMA0 Mask Trigger Register
#define MDREQSEL0               (*((volatile unsigned int  *) 0x41140024)) // MDMA0 Request Selection Register

/* MDMA1 */
#define MDISRC1                 (*((volatile unsigned int  *) 0x41150000)) // MDMA1 Initial Source Register
#define MDISRCC1                (*((volatile unsigned int  *) 0x41150004)) // MDMA1 Initial Source Control Register
#define MDIDST1                 (*((volatile unsigned int  *) 0x41150008)) // MDMA1 Initial Destination Register
#define MDIDSTC1                (*((volatile unsigned int  *) 0x4115000c)) // MDMA1 Initial Destination Control Register
#define MDCON1                  (*((volatile unsigned int  *) 0x41150010)) // MDMA1 Control Register
#define MDSTAT1                 (*((volatile unsigned int  *) 0x41150014)) // MDMA1 Count Register
#define MDCSRC1                 (*((volatile unsigned int  *) 0x41150018)) // MDMA1 Current Source Register
#define MDCDST1                 (*((volatile unsigned int  *) 0x4115001c)) // MDMA1 Current Destination Register
#define MDMASKTRIG1             (*((volatile unsigned int  *) 0x41150020)) // MDMA1 Mask Trigger Register
#define MDREQSEL1               (*((volatile unsigned int  *) 0x41150024)) // MDMA1 Request Selection Register


/*
** USB OTG (On-The-Go)
*/

/* OTG-TLI in USB Device Mode */
#define UDM_InEP0_CON           (*((volatile unsigned int  *) 0x41944000)) // Endpoint 0 Control
#define UDM_InEP0_STA           (*((volatile unsigned int  *) 0x41944004)) // Endpoint 0 Status
#define UDM_InEP0_FIFO_SIZE     (*((volatile unsigned int  *) 0x41944008)) // Endpoint 0 FIFO Size
#define UDM_InEP0_TRANS_SIZE    (*((volatile unsigned int  *) 0x4194400c)) // Endpoint 0 Transfer Size

#define UDM_InEP1_CON           (*((volatile unsigned int  *) 0x41944010)) // Endpoint 1 Control
#define UDM_InEP1_STA           (*((volatile unsigned int  *) 0x41944014)) // Endpoint 1 Status
#define UDM_InEP1_FIFO_SIZE     (*((volatile unsigned int  *) 0x41944018)) // Endpoint 1 FIFO Size
#define UDM_InEP1_TRANS_SIZE    (*((volatile unsigned int  *) 0x4194401c)) // Endpoint 1 Transfer Size

#define UDM_InEP2_CON           (*((volatile unsigned int  *) 0x41944020)) // Endpoint 2 Control
#define UDM_InEP2_STA           (*((volatile unsigned int  *) 0x41944024)) // Endpoint 2 Status
#define UDM_InEP2_FIFO_SIZE     (*((volatile unsigned int  *) 0x41944028)) // Endpoint 2 FIFO Size
#define UDM_InEP2_TRANS_SIZE    (*((volatile unsigned int  *) 0x4194402c)) // Endpoint 2 Transfer Size

#define UDM_InEP3_CON           (*((volatile unsigned int  *) 0x41944030)) // Endpoint 3 Control
#define UDM_InEP3_STA           (*((volatile unsigned int  *) 0x41944034)) // Endpoint 3 Status
#define UDM_InEP3_FIFO_SIZE     (*((volatile unsigned int  *) 0x41944038)) // Endpoint 3 FIFO Size
#define UDM_InEP3_TRANS_SIZE    (*((volatile unsigned int  *) 0x4194403c)) // Endpoint 3 Transfer Size

#define UDM_InEP4_CON           (*((volatile unsigned int  *) 0x41944040)) // Endpoint 4 Control
#define UDM_InEP4_STA           (*((volatile unsigned int  *) 0x41944044)) // Endpoint 4 Status
#define UDM_InEP4_FIFO_SIZE     (*((volatile unsigned int  *) 0x41944048)) // Endpoint 4 FIFO Size
#define UDM_InEP4_TRANS_SIZE    (*((volatile unsigned int  *) 0x4194404c)) // Endpoint 4 Transfer Size

#define UDM_OutEP0_CON          (*((volatile unsigned int  *) 0x41944100)) // Endpoint 0 Control
#define UDM_OutEP1_CON          (*((volatile unsigned int  *) 0x41944110)) // Endpoint 1 Control
#define UDM_OutEP2_CON          (*((volatile unsigned int  *) 0x41944120)) // Endpoint 2 Control
#define UDM_OutEP3_CON          (*((volatile unsigned int  *) 0x41944130)) // Endpoint 3 Control
#define UDM_OutEP4_CON          (*((volatile unsigned int  *) 0x41944140)) // Endpoint 4 Control

#define UDM_DEV_CON             (*((volatile unsigned int  *) 0x41944200)) // Device Control
#define UDM_DEV_STA             (*((volatile unsigned int  *) 0x41944204)) // Device Status
#define UDM_DEV_INT             (*((volatile unsigned int  *) 0x41944208)) // Device Interrupt
#define UDM_DEV_INT_EN          (*((volatile unsigned int  *) 0x4194420c)) // Device Interrupt Enable
#define UDM_OUT_EP_RX_FIFO_SIZE (*((volatile unsigned int  *) 0x41944210)) // OUT Endpoint RX FIFO SIZE
#define UDM_GBL_EP_INT_EN       (*((volatile unsigned int  *) 0x41944214)) // Global Endpoint Interrupt Enable
#define UDM_THRES               (*((volatile unsigned int  *) 0x41944218)) // Threshold
#define UDM_OUT_EP_RX_FIFO_STA  (*((volatile unsigned int  *) 0x4194421c)) // OUT Endpoint RX FIFO Status
#define UDM_SETUP_RX_FIFO_STA   (*((volatile unsigned int  *) 0x41944220)) // SETUP RX FIFO Status
#define UDM_GBL_EP_INT          (*((volatile unsigned int  *) 0x41944224)) // Global Endpoint Interrupt
#define UDM_FRM_NUM             (*((volatile unsigned int  *) 0x41944228)) // Frame Number
#define UDM_SETUP_DATA_1        (*((volatile unsigned int  *) 0x41944300)) // SETUP Data - 1st DWORD
#define UDM_SETUP_DATA_2        (*((volatile unsigned int  *) 0x41944304)) // SETUP Data - 2nd DWORD

/* OTG-TLI in USB Device and Host Mode */
#define SLV_BIU_DLY_CNT         (*((volatile unsigned int  *) 0x41944308)) // Slave BIU Delay Count
#define I2C_REG                 (*((volatile unsigned int  *) 0x4194430c)) // I2C Register

/* OTG-TLI in USB Host Mode */
#define UHM_INT                 (*((volatile unsigned int  *) 0x41944800)) // Interrupt
#define UHM_INT_EN              (*((volatile unsigned int  *) 0x41944804)) // Interrupt Enable
#define UHM_STA                 (*((volatile unsigned int  *) 0x41944808)) // Status
#define UHM_HOST_CON            (*((volatile unsigned int  *) 0x4194480c)) // Host Control
#define UHM_FIFO_SIZE           (*((volatile unsigned int  *) 0x41944810)) // FIFO Size
#define UHM_THRES               (*((volatile unsigned int  *) 0x41944814)) // Threshold
#define UHM_OUT_TRANS_SIZE      (*((volatile unsigned int  *) 0x41944818)) // OUT Transfer size

/* OTG-MAC in USB Host Mode */
#define UHM_TOKEN               (*((volatile unsigned int  *) 0x41944c90)) // Token
#define UHM_CONSTA              (*((volatile unsigned int  *) 0x41944c94)) // OTG Control Status
#define UHM_FRAME_INT           (*((volatile unsigned int  *) 0x41944c34)) // Frame Interval
#define UHM_FRAME_REM           (*((volatile unsigned int  *) 0x41944c38)) // Frame remaining
#define UHM_FRAME_NUM           (*((volatile unsigned int  *) 0x41944c3c)) // Frame number
#define UHM_STA_CH_CON          (*((volatile unsigned int  *) 0x41944c00)) // Port status change control


/*
** PWM Timer
*/

#define TCFG0                   (*((volatile unsigned int  *) 0x44000000)) // Timer 0 configuration
#define TCFG1                   (*((volatile unsigned int  *) 0x44000004)) // Timer 1 configuration
#define TCON                    (*((volatile unsigned int  *) 0x44000008)) // Timer control
#define TCNTB0                  (*((volatile unsigned int  *) 0x4400000c)) // Timer count buffer 0
#define TCMPB0                  (*((volatile unsigned int  *) 0x44000010)) // Timer compare buffer 0
#define TCNTO0                  (*((volatile unsigned int  *) 0x44000014)) // Timer count observation 0
#define TCNTB1                  (*((volatile unsigned int  *) 0x44000018)) // Timer count buffer 1
#define TCMPB1                  (*((volatile unsigned int  *) 0x4400001c)) // Timer compare buffer 1
#define TCNTO1                  (*((volatile unsigned int  *) 0x44000020)) // Timer count observation 1
#define TCNTB2                  (*((volatile unsigned int  *) 0x44000024)) // Timer count buffer 2
#define TCMPB2                  (*((volatile unsigned int  *) 0x44000028)) // Timer compare buffer 2
#define TCNTO2                  (*((volatile unsigned int  *) 0x4400002c)) // Timer count observation 2
#define TCNTB3                  (*((volatile unsigned int  *) 0x44000030)) // Timer count buffer 3
#define TCMPB3                  (*((volatile unsigned int  *) 0x44000034)) // Timer compare buffer 3
#define TCNTO3                  (*((volatile unsigned int  *) 0x44000038)) // Timer count observation 3
#define TCNTB4                  (*((volatile unsigned int  *) 0x4400003c)) // Timer count buffer 4
#define TCNTO4                  (*((volatile unsigned int  *) 0x44000040)) // Timer count observation 4


/*
** Watchdog Timer
*/

#define WTCON                   (*((volatile unsigned int  *) 0x44200000)) // Watch-dog timer mode
#define WTDAT                   (*((volatile unsigned int  *) 0x44200004)) // Watch-dog timer data
#define WTCNT                   (*((volatile unsigned int  *) 0x44200008)) // Eatch-dog timer count


/*
** RTC (Real Time Clock)
*/

#define RTCCON                  (*((volatile unsigned char *) 0x44200040)) // RTC control
#define TICNT                   (*((volatile unsigned char *) 0x44200044)) // Tick time count
#define RTCALM                  (*((volatile unsigned char *) 0x44200050)) // RTC alarm control
#define ALMSEC                  (*((volatile unsigned char *) 0x44200054)) // Alarm second
#define ALMMIN                  (*((volatile unsigned char *) 0x44200058)) // Alarm minute
#define ALMHOUR                 (*((volatile unsigned char *) 0x4420005c)) // Alarm Hour
#define ALMDATE                 (*((volatile unsigned char *) 0x44200060)) // Alarm day
#define ALMMON                  (*((volatile unsigned char *) 0x44200064)) // Alarm month
#define ALMYEAR                 (*((volatile unsigned char *) 0x44200068)) // Alarm year
#define RTCRST                  (*((volatile unsigned char *) 0x4420006c)) // RTC round reset
#define BCDSEC                  (*((volatile unsigned char *) 0x44200070)) // BCD second
#define BCDMIN                  (*((volatile unsigned char *) 0x44200074)) // BCD minute
#define BCDHOUR                 (*((volatile unsigned char *) 0x44200078)) // BCD hour
#define BCDDATE                 (*((volatile unsigned char *) 0x4420007c)) // BCD day
#define BCDDAY                  (*((volatile unsigned char *) 0x44200080)) // BCD date
#define BCDMON                  (*((volatile unsigned char *) 0x44200084)) // BCD month
#define BCDYEAR                 (*((volatile unsigned char *) 0x44200088)) // BCD year


/*
** UART
*/

#define ULCON0                  (*((volatile unsigned int  *) 0x44400000)) // UART channel 0 line control register
#define UCON0                   (*((volatile unsigned int  *) 0x44400004)) // UART channel 0 control register
#define UFCON0                  (*((volatile unsigned int  *) 0x44400008)) // UART channel 0 FIFO control register
#define UMCON0                  (*((volatile unsigned int  *) 0x4440000c)) // UART channel 0 Modem control register
#define UTRSTAT0                (*((volatile unsigned int  *) 0x44400010)) // UART channel 0 Tx/Rx status register
#define UERSTAT0                (*((volatile unsigned int  *) 0x44400014)) // UART channel 0 Rx error status register
#define UFSTAT0                 (*((volatile unsigned int  *) 0x44400018)) // UART channel 0 FIFO status register
#define UMSTAT0                 (*((volatile unsigned int  *) 0x4440001c)) // UART channel 0 Modem status register
#define UTXH0                   (*((volatile unsigned int  *) 0x44400020)) // UART channel 0 transmit buffer register
#define URXH0                   (*((volatile unsigned int  *) 0x44400024)) // UART channel 0 receive buffer register
#define UBRDIV0                 (*((volatile unsigned int  *) 0x44400028)) // UART channel 0 Baud rate divisior register
#define UDIVSLOT0               (*((volatile unsigned int  *) 0x4440002c)) // UART channel 0 Dividing slot register
#define UINTP0                  (*((volatile unsigned int  *) 0x44400030)) // UART channel 0 Interrupt Pending Register
#define UINTSP0                 (*((volatile unsigned int  *) 0x44400034)) // UART channel 0 Interrupt Source Pending Register
#define UINTM0                  (*((volatile unsigned int  *) 0x44400038)) // UART channel 0 Interrupt Mask Register

#define ULCON1                  (*((volatile unsigned int  *) 0x44404000)) // UART channel 1 line control register
#define UCON1                   (*((volatile unsigned int  *) 0x44404004)) // UART channel 1 control register
#define UFCON1                  (*((volatile unsigned int  *) 0x44404008)) // UART channel 1 FIFO control register
#define UMCON1                  (*((volatile unsigned int  *) 0x4440400c)) // UART channel 1 Modem control register
#define UTRSTAT1                (*((volatile unsigned int  *) 0x44404010)) // UART channel 1 Tx/Rx status register
#define UERSTAT1                (*((volatile unsigned int  *) 0x44404014)) // UART channel 1 Rx error status register
#define UFSTAT1                 (*((volatile unsigned int  *) 0x44404018)) // UART channel 1 FIFO status register
#define UMSTAT1                 (*((volatile unsigned int  *) 0x4440401c)) // UART channel 1 Modem status register
#define UTXH1                   (*((volatile unsigned int  *) 0x44404020)) // UART channel 1 transmit buffer register
#define URXH1                   (*((volatile unsigned int  *) 0x44404024)) // UART channel 1 receive buffer register
#define UBRDIV1                 (*((volatile unsigned int  *) 0x44404028)) // UART channel 1 Baud rate divisior register
#define UDIVSLOT1               (*((volatile unsigned int  *) 0x4440402c)) // UART channel 1 Dividing slot register
#define UINTP1                  (*((volatile unsigned int  *) 0x4440402c)) // UART channel 1 Interrupt Pending Register
#define UINTSP1                 (*((volatile unsigned int  *) 0x44404034)) // UART channel 1 Interrupt Source Pending Register
#define UINTM1                  (*((volatile unsigned int  *) 0x44404038)) // UART channel 1 Interrupt Mask Register

#define ULCON2                  (*((volatile unsigned int  *) 0x44408000)) // UART channel 2 line control register
#define UCON2                   (*((volatile unsigned int  *) 0x44408004)) // UART channel 2 control register
#define UFCON2                  (*((volatile unsigned int  *) 0x44408008)) // UART channel 2 FIFO control register
#define UMCON2                  (*((volatile unsigned int  *) 0x4440800c)) // UART channel 2 Modem control register
#define UTRSTAT2                (*((volatile unsigned int  *) 0x44408010)) // UART channel 2 Tx/Rx status register
#define UERSTAT2                (*((volatile unsigned int  *) 0x44408014)) // UART channel 2 Rx error status register
#define UFSTAT2                 (*((volatile unsigned int  *) 0x44408018)) // UART channel 2 FIFO status register
#define UMSTAT2                 (*((volatile unsigned int  *) 0x4440801c)) // UART channel 2 Modem status register
#define UTXH2                   (*((volatile unsigned int  *) 0x44408020)) // UART channel 2 transmit buffer register
#define URXH2                   (*((volatile unsigned int  *) 0x44408024)) // UART channel 2 receive buffer register
#define UBRDIV2                 (*((volatile unsigned int  *) 0x44408028)) // UART channel 2 Baud rate divisior register
#define UDIVSLOT2               (*((volatile unsigned int  *) 0x4440802c)) // UART channel 2 Dividing slot register
#define INTP2                   (*((volatile unsigned int  *) 0x44408030)) // UART channel 2 Interrupt Pending Register
#define UINTSP2                 (*((volatile unsigned int  *) 0x44408034)) // UART channel 2 Interrupt Source Pending Register
#define UINTM2                  (*((volatile unsigned int  *) 0x44408038)) // UART channel 2 Interrupt Mask Register


/*
** SPI
*/

#define SPCON0                  (*((volatile unsigned int  *) 0x44500000)) // SPI0 control
#define SPSTA0                  (*((volatile unsigned int  *) 0x44500004)) // SPI0 status
#define SPPIN0                  (*((volatile unsigned int  *) 0x44500008)) // SPI0 pin control
#define SPPRE0                  (*((volatile unsigned int  *) 0x4450000c)) // SPI0 baud rate prescaler
#define SPTDAT0                 (*((volatile unsigned int  *) 0x44500010)) // SPI0 Tx data
#define SPRDAT0                 (*((volatile unsigned int  *) 0x44500014)) // SPI0 Rx data

#define SPCON1                  (*((volatile unsigned int  *) 0x44500020)) // SPI1 control
#define SPSTA1                  (*((volatile unsigned int  *) 0x44500024)) // SPI1 status
#define SPPIN1                  (*((volatile unsigned int  *) 0x44500028)) // SPI1 pin control
#define SPPRE1                  (*((volatile unsigned int  *) 0x4450002c)) // SPI1 baud rate prescaler
#define SPTDAT1                 (*((volatile unsigned int  *) 0x44500030)) // SPI1 Tx data
#define SPRDAT1                 (*((volatile unsigned int  *) 0x44500034)) // SPI1 Rx data


/*
** IIC
*/

#define IICCON                  (*((volatile unsigned int  *) 0x44600000)) // IIC Control
#define IICSTAT                 (*((volatile unsigned int  *) 0x44600004)) // IIC Status
#define IICADD                  (*((volatile unsigned int  *) 0x44600008)) // IIC Address
#define IICDS                   (*((volatile unsigned int  *) 0x4460000c)) // IIC Data Shift
#define IICLC                   (*((volatile unsigned int  *) 0x44600010)) // IIC multi-master line control


/*
** Inter-IC Sound (IIS)
*/

#define IISCON                  (*((volatile unsigned int  *) 0x44700000)) // IIS control register
#define IISMOD                  (*((volatile unsigned int  *) 0x44700004)) // IIS mode register
#define IISPSR                  (*((volatile unsigned int  *) 0x44700008)) // IIS prescaler register
#define IISFCON                 (*((volatile unsigned int  *) 0x4470000c)) // IIS FIFO interface register
#define IISFIFO                 (*((volatile unsigned short*) 0x44700010)) // IIS FIFO register


/*
** GPIO
*/

#define GPACON                  (*((volatile unsigned int  *) 0x44800000)) // Port A Configuration Register
#define GPADAT                  (*((volatile unsigned int  *) 0x44800004)) // Port A Data Register
#define GPAPU                   (*((volatile unsigned int  *) 0x44800008)) // Port A Pull-up Register
#define GPASLPCON               (*((volatile unsigned int  *) 0x4480000c)) // Port A Sleep mode Configuration Register
#define GPABON                  (*((volatile unsigned int  *) 0x44800010)) // Port B Configuration Register
#define GPBDAT                  (*((volatile unsigned int  *) 0x44800014)) // Port B Data Register
#define GPBPU                   (*((volatile unsigned int  *) 0x44800018)) // Port B Pull-up Register
#define GPBSLPCON               (*((volatile unsigned int  *) 0x4480001c)) // Port B Sleep mode Configuration Register
#define GPCCON                  (*((volatile unsigned int  *) 0x44800020)) // Port C Configuration Register
#define GPCDAT                  (*((volatile unsigned int  *) 0x44800024)) // Port C Data Register
#define GPCPU                   (*((volatile unsigned int  *) 0x44800028)) // Port C Pull-up Register
#define GPCSLPCON               (*((volatile unsigned int  *) 0x4480002c)) // Port C Sleep mode Configuration Register
#define GPDCON                  (*((volatile unsigned int  *) 0x44800030)) // Port D Configuration Register
#define GPDDAT                  (*((volatile unsigned int  *) 0x44800034)) // Port D Data Register
#define GPDPU                   (*((volatile unsigned int  *) 0x44800038)) // Port D Pull-up Register
#define GPECON                  (*((volatile unsigned int  *) 0x44800040)) // Port E Configuration Register
#define GPEDAT                  (*((volatile unsigned int  *) 0x44800044)) // Port E Data Register
#define GPEPU                   (*((volatile unsigned int  *) 0x44800048)) // Port E Pull-up Register
#define GPESLPCON               (*((volatile unsigned int  *) 0x4480004c)) // Port E Sleep mode Configuration Register
#define GPFCON                  (*((volatile unsigned int  *) 0x44800050)) // Port F Configuration Register
#define GPFDAT                  (*((volatile unsigned int  *) 0x44800054)) // Port F Data Register
#define GPFPU                   (*((volatile unsigned int  *) 0x44800058)) // Port F Pull-up Register
#define GPFSLPCON               (*((volatile unsigned int  *) 0x4480005c)) // Port F Sleep mode Configuration Register
#define GPGCON                  (*((volatile unsigned int  *) 0x44800060)) // Port G Configuration Register
#define GPGDAT                  (*((volatile unsigned int  *) 0x44800064)) // Port G Data Register
#define GPGPU                   (*((volatile unsigned int  *) 0x44800068)) // Port G Pull-up Register
#define GPGSLPCON               (*((volatile unsigned int  *) 0x4480006c)) // Port G Sleep mode Configuration Register
#define GPHCON                  (*((volatile unsigned int  *) 0x44800070)) // Port H Configuration Register
#define GPHDAT                  (*((volatile unsigned int  *) 0x44800074)) // Port H Data Register
#define GPHPU                   (*((volatile unsigned int  *) 0x44800078)) // Port H Pull-up Register
#define GPHSLPCON               (*((volatile unsigned int  *) 0x4480007c)) // Port H Sleep mode Configuration Register
#define GPICON                  (*((volatile unsigned int  *) 0x44800080)) // Port I Configuration Register
#define GPIDAT                  (*((volatile unsigned int  *) 0x44800084)) // Port I Data Register
#define GPIPU                   (*((volatile unsigned int  *) 0x44800088)) // Port I Pull-up Register
#define GPISLPCON               (*((volatile unsigned int  *) 0x4480008c)) // Port I Sleep mode Configuration Register
#define GPJCON                  (*((volatile unsigned int  *) 0x44800090)) // Port J Configuration Register
#define GPJDAT                  (*((volatile unsigned int  *) 0x44800094)) // Port J Data Register
#define GPJPU                   (*((volatile unsigned int  *) 0x44800098)) // Port J Pull-up Register
#define SPCON                   (*((volatile unsigned int  *) 0x4480009c)) // Special Port Control Register
#define GPKCON                  (*((volatile unsigned int  *) 0x448000a0)) // Port K Configuration Register
#define GPKDAT                  (*((volatile unsigned int  *) 0x448000a4)) // Port K Data Register
#define GPKPU                   (*((volatile unsigned int  *) 0x448000a8)) // Port K Pull-up Register
#define GPKSLPCON               (*((volatile unsigned int  *) 0x448000ac)) // Port K Sleep mode Configuration Register
#define EINTCON0                (*((volatile unsigned int  *) 0x448000b0)) // External Interrupt Control Register 0
#define EINTCON1                (*((volatile unsigned int  *) 0x448000b4)) // External Interrupt Control Register 1
#define EINTFLT0                (*((volatile unsigned int  *) 0x448000b8)) // External Interrupt Filter Control Register 0
#define EINTFLT1                (*((volatile unsigned int  *) 0x448000bc)) // External Interrupt Filter Control Register 1
#define EINTMASK                (*((volatile unsigned int  *) 0x448000c0)) // External Interrupt Mask Register
#define EINTPEND                (*((volatile unsigned int  *) 0x448000c4)) // External Interrupt Pending Register
#define DSPGPSLP                (*((volatile unsigned int  *) 0x448000c8)) // DSP GPIO Sleep Mode Control Register
#define MEM0CONSTOP             (*((volatile unsigned int  *) 0x448000d0)) // Memory Port 0 Stop Mode Control Register 0
#define MEM1CONSTOP             (*((volatile unsigned int  *) 0x448000d4)) // Memory Port 1 Stop Mode Control Register 1
#define MEM2CONSTOP             (*((volatile unsigned int  *) 0x448000d8)) // Memory Port 2 Stop Mode Control Register 2
#define MEM0CONSLP              (*((volatile unsigned int  *) 0x448000e0)) // Memory Port 0 Sleep Mode Control Register
#define MEM1CONSLP              (*((volatile unsigned int  *) 0x448000e4)) // Memory Port 1 Sleep Mode Control Register
#define MEM2CONSLP              (*((volatile unsigned int  *) 0x448000e8)) // Memory Port 2 Sleep Mode Control Register
#define SPCONSLP                (*((volatile unsigned int  *) 0x448000ec)) // Special Pin Sleep Mode Control Register
#define SLPEN                   (*((volatile unsigned int  *) 0x448000f0)) // Sleep mode Pad state enable Register
#define MEM0DRVCON              (*((volatile unsigned int  *) 0x448000f4)) // Memory Port 0 Drive strength Control Register
#define MEM1DRVCON              (*((volatile unsigned int  *) 0x448000f8)) // Memory Port 1 Drive strength Control Register
#define MEM2DRVCON              (*((volatile unsigned int  *) 0x448000fc)) // Memory Port 2 Drive strength Control Register


/*
** Key Pad Interface
*/

#define KEYIFCON                (*((volatile unsigned int  *) 0x44900000)) // Control register
#define KEYIFSTSCLR             (*((volatile unsigned int  *) 0x44900004)) // Status and clear register
#define KEYIFCOL                (*((volatile unsigned int  *) 0x44900008)) // Column data output register
#define KEYIFROW                (*((volatile unsigned int  *) 0x4490000c)) // Row data input register Reflects input ports
#define KEYIFFCD                (*((volatile unsigned int  *) 0x44900010)) // Debouncing filter clock division register


/*
** USB Device
*/

#define FUNC_ADDR_REG           (*((volatile unsigned char *) 0x44a00140)) // Function address
#define PWR_REG                 (*((volatile unsigned char *) 0x44a00144)) // Power management
#define EP_INT_REG              (*((volatile unsigned char *) 0x44a00148)) // EP interrupt pending and clear
#define USB_INT_REG             (*((volatile unsigned char *) 0x44a00158)) // USB interrupt pending and clear
#define EP_INT_EN_REG           (*((volatile unsigned char *) 0x44a0015c)) // Interrupt enable
#define USB_INT_EN_REG          (*((volatile unsigned char *) 0x44a0016c)) // Interrupt enbale
#define FRAME_NUM1_REG          (*((volatile unsigned char *) 0x44a00170)) // Frame number lower byte
#define FRAME_NUM2_REG          (*((volatile unsigned char *) 0x44a00174)) // Frame number lower byte
#define INDEX_REG               (*((volatile unsigned char *) 0x44a00178)) // Register index
#define EP0_CSR                 (*((volatile unsigned char *) 0x44a00184)) // Endpoint 0 status
#define IN_CSR1_REG             (*((volatile unsigned char *) 0x44a00184)) // In endpoint control status
#define IN_CSR2_REG             (*((volatile unsigned char *) 0x44a00188)) // In endpoint control status
#define MAXP_REG                (*((volatile unsigned char *) 0x44a00180)) // Endpoint max packet
#define OUT_CSR1_REG            (*((volatile unsigned char *) 0x44a00190)) // Out endpoint control status
#define OUT_CSR2_REG            (*((volatile unsigned char *) 0x44a00194)) // Out endpoint control status
#define OUT_FIFO_CNT1_REG       (*((volatile unsigned char *) 0x44a00198)) // Endpoint out write count
#define OUT_FIFO_CNT2_REG       (*((volatile unsigned char *) 0x44a0019c)) // Endpoint out write count
#define EP0_FIFO                (*((volatile unsigned char *) 0x44a001c0)) // Endpoint 0 FIFO
#define EP1_FIFO                (*((volatile unsigned char *) 0x44a001c4)) // Endpoint 1 FIFO
#define EP2_FIFO                (*((volatile unsigned char *) 0x44a001c8)) // Endpoint 2 FIFO
#define EP3_FIFO                (*((volatile unsigned char *) 0x44a001cc)) // Endpoint 3 FIFO
#define EP4_FIFO                (*((volatile unsigned char *) 0x44a001d0)) // Endpoint 4 FIFO
#define EP1_DMA_CON             (*((volatile unsigned char *) 0x44a00200)) // EP1 DMA interface control
#define EP1_DMA_UNIT            (*((volatile unsigned char *) 0x44a00204)) // EP1 DMA Tx unit counter
#define EP1_DMA_FIFO            (*((volatile unsigned char *) 0x44a00208)) // EP1 DMA Tx FIFO counter
#define EP1_DMA_TTC_L           (*((volatile unsigned char *) 0x44a0020c)) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00210)) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_H           (*((volatile unsigned char *) 0x44a00214)) // EP1 DMA total Tx counter
#define EP2_DMA_CON             (*((volatile unsigned char *) 0x44a00218)) // EP2 DMA interface control
#define EP2_DMA_UNIT            (*((volatile unsigned char *) 0x44a0021c)) // EP2 DMA Tx Unit counter
#define EP2_DMA_FIFO            (*((volatile unsigned char *) 0x44a00220)) // EP2 DMA Tx FIFO counter
#define EP2_DMA_TTC_L           (*((volatile unsigned char *) 0x44a00224)) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00228)) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_H           (*((volatile unsigned char *) 0x44a0022c)) // EP2 DMA total Tx counter
#define EP3_DMA_CON             (*((volatile unsigned char *) 0x44a00240)) // EP3 DMA interface control
#define EP3_DMA_UNIT            (*((volatile unsigned char *) 0x44a00244)) // EP3 DMA Tx unit counter
#define EP3_DMA_FIFO            (*((volatile unsigned char *) 0x44a00248)) // EP3 DMA Tx FIFO counter
#define EP3_DMA_TTC_L           (*((volatile unsigned char *) 0x44a0024c)) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00250)) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_H           (*((volatile unsigned char *) 0x44a00254)) // EP3 DMA total Tx counter
#define EP4_DMA_CON             (*((volatile unsigned char *) 0x44a00258)) // EP4 DMA interface control
#define EP4_DMA_UNIT            (*((volatile unsigned char *) 0x44a0025c)) // EP4 DMA Tx Unit counter
#define EP4_DMA_FIFO            (*((volatile unsigned char *) 0x44a00260)) // EP4 DMA Tx FIFO counter
#define EP4_DMA_TTC_L           (*((volatile unsigned char *) 0x44a00264)) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_M           (*((volatile unsigned char *) 0x44a00268)) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_H           (*((volatile unsigned char *) 0x44a0026c)) // EP4 DMA total Tx counter


/*
** IrDA Controller
*/

#define IRDA_CNT                (*((volatile unsigned int  *) 0x44c00000)) // Control Register
#define IRDA_MDR                (*((volatile unsigned int  *) 0x44c00004)) // Mode Definition Register
#define IRDA_CNF                (*((volatile unsigned int  *) 0x44c00008)) // Interrupt / DMA Configuration Register
#define IRDA_IER                (*((volatile unsigned int  *) 0x44c0000c)) // Interrupt Enable Register
#define IRDA_IIR                (*((volatile unsigned int  *) 0x44c00010)) // Interrupt Identification Register
#define IRDA_LSR                (*((volatile unsigned int  *) 0x44c00014)) // Line Status Register
#define IRDA_FCR                (*((volatile unsigned int  *) 0x44c00018)) // FIFO Control Register
#define IRDA_PLR                (*((volatile unsigned int  *) 0x44c0001c)) // Preamble Length Register
#define IRDA_RBR                (*((volatile unsigned int  *) 0x44c00020)) // Receiver & Transmitter Buffer Register
#define IRDA_TXNO               (*((volatile unsigned int  *) 0x44c00024)) // The total number of data bytes remained in Tx FIFO
#define IRDA_RXNO               (*((volatile unsigned int  *) 0x44c00028)) // The total number of data bytes remained in Rx FIFO
#define IRDA_TXFLL              (*((volatile unsigned int  *) 0x44c0002c)) // Transmit Frame-Length Register Low
#define IRDA_TXFLH              (*((volatile unsigned int  *) 0x44c00030)) // Transmit Frame-Length Register High
#define IRDA_RXFLL              (*((volatile unsigned int  *) 0x44c00034)) // Receive Frame-Length Register Low
#define IRDA_RXFLH              (*((volatile unsigned int  *) 0x44c00038)) // Receive Frame-Length Register High


/*
** AC97 Controller
*/

#define AC_GLBCTRL              (*((volatile unsigned int  *) 0x45000000)) // Global Control Register
#define AC_GLBSTAT              (*((volatile unsigned int  *) 0x45000004)) // Global Status Register
#define AC_CODEC_CMD            (*((volatile unsigned int  *) 0x45000008)) // Codec Command Register
#define AC_CODEC_STAT           (*((volatile unsigned int  *) 0x4500000c)) // Codec Status Register
#define AC_PCMADDR              (*((volatile unsigned int  *) 0x45000010)) // PCM Out/In Channel FIFO Address Register
#define AC_MICADDR              (*((volatile unsigned int  *) 0x45000014)) // Mic In Channel FIFO Address Register
#define AC_PCMDATA              (*((volatile unsigned int  *) 0x45000018)) // PCM Out/In Channel FIFO Data Register
#define AC_MICDATA              (*((volatile unsigned int  *) 0x4500001c)) // MIC In Channel FIFO Data Register


/*
** Analog-to-Digital Converter & Touch Screen
*/

#define ADCCON                  (*((volatile unsigned int  *) 0x45800000)) // Control Register
#define ADCTSC                  (*((volatile unsigned int  *) 0x45800004)) // Touch Screen Control Register
#define ADCDLY                  (*((volatile unsigned int  *) 0x45800008)) // Start or Interval Delay Register
#define ADCDAT0                 (*((volatile unsigned int  *) 0x4580000c)) // Conversion Data Register -
#define ADCDAT1                 (*((volatile unsigned int  *) 0x45800010)) // Conversion Data Register -
#define ADCUPDN                 (*((volatile unsigned int  *) 0x45800014)) // Stylus Up or Down Interrupt Register


/*
** SD Interface
*/

#define SDICON                  (*((volatile unsigned int  *) 0x46000000)) // SDI control
#define SDIPRE                  (*((volatile unsigned int  *) 0x46000004)) // SDI baud rate prescaler
#define SDICARG                 (*((volatile unsigned int  *) 0x46000008)) // SDI command argument
#define SDICCON                 (*((volatile unsigned int  *) 0x4600000c)) // SDI command control
#define SDICSTA                 (*((volatile unsigned int  *) 0x46000010)) // SDI command status
#define SDIRSP0                 (*((volatile unsigned int  *) 0x46000014)) // SDI response 0
#define SDIRSP1                 (*((volatile unsigned int  *) 0x46000018)) // SDI response 1
#define SDIRSP2                 (*((volatile unsigned int  *) 0x4600001c)) // SDI response 2
#define SDIRSP3                 (*((volatile unsigned int  *) 0x46000020)) // SDI response 3
#define SDIDTIMER               (*((volatile unsigned int  *) 0x46000024)) // SDI data/busy timer
#define SDIBSIZE                (*((volatile unsigned int  *) 0x46000028)) // SDI block size
#define SDIDCON                 (*((volatile unsigned int  *) 0x4600002c)) // SDI data control
#define SDIDCNT                 (*((volatile unsigned int  *) 0x46000030)) // SDI data remain counter
#define SDIDSTA                 (*((volatile unsigned int  *) 0x46000034)) // SDI data status
#define SDIFSTA                 (*((volatile unsigned int  *) 0x46000038)) // SDI FIFO status
#define SDIIMSK                 (*((volatile unsigned int  *) 0x4600003c)) // SDI interrupt mask
#define SDIDAT                  (*((volatile unsigned int  *) 0x46000040)) // SDI data


/*
** Memory Stick
*/

#define MSPRE                   (*((volatile unsigned int  *) 0x46100000)) // Pescaler control register
#define MSFINTCON               (*((volatile unsigned int  *) 0x46100004)) // FIFO interrupt control
#define TP_CMD                  (*((volatile unsigned int  *) 0x46108000)) // Transfer protocol command register
#define CTRL_STA                (*((volatile unsigned int  *) 0x46108004)) // Control [15:8] and staus [7:0] register
#define DAT_FIFO                (*((volatile unsigned int  *) 0x46108008)) // Tx/ Rx FIFO (buffer) register
#define INTCTRL_STA             (*((volatile unsigned int  *) 0x4610800c)) // Interrupt control [15:8] and staus [7:0] register
#define INS_CON                 (*((volatile unsigned int  *) 0x46108010)) // INS port control register
#define ACMD_CON                (*((volatile unsigned int  *) 0x46108014)) // Auto command and polaity control register
#define ATP_CMD                 (*((volatile unsigned int  *) 0x46108018)) // Auto transfer protocol command register


/*
** PCM Audio Interface
*/

#define PCM_CTL                 (*((volatile unsigned int  *) 0x46200000)) // PCM Main Control
#define PCM_CLKCTL              (*((volatile unsigned int  *) 0x46200004)) // PCM Clock and Shift control
#define PCM_TXFIFO              (*((volatile unsigned int  *) 0x46200008)) // PCM TxFIFO write port
#define PCM_RXFIFO              (*((volatile unsigned int  *) 0x4620000c)) // PCM RxFIFO read port
#define PCM_IRQ_CTL             (*((volatile unsigned int  *) 0x46200010)) // PCM Interrupt Control
#define PCM_IRQ_STAT            (*((volatile unsigned int  *) 0x46200014)) // PCM Interrupt Status
#define PCM_FIFO_STAT           (*((volatile unsigned int  *) 0x46200018)) // PCM Tx Defualt Value


/*
** Camera Interface
*/

#define CISRCFMT                (*((volatile unsigned int  *) 0x48000000)) // Input Source Format Register
#define CIWDOFST                (*((volatile unsigned int  *) 0x48000004)) // Window Offset Register
#define CIGCTRL                 (*((volatile unsigned int  *) 0x48000008)) // Global Control Register
#define CICOYSA1                (*((volatile unsigned int  *) 0x48000018)) // Y 1st frame start address for codec DMA
#define CICOYSA2                (*((volatile unsigned int  *) 0x4800001c)) // Y 2nd frame start address for codec DMA
#define CICOYSA3                (*((volatile unsigned int  *) 0x48000020)) // Y 3rd frame start address for codec DMA
#define CICOYSA4                (*((volatile unsigned int  *) 0x48000024)) // Y 4th frame start address for codec DMA
#define CICOCBSA1               (*((volatile unsigned int  *) 0x48000028)) // Cb 1st frame start address for codec DMA
#define CICOCBSA2               (*((volatile unsigned int  *) 0x4800002c)) // Cb 2nd frame start address for codec DMA
#define CICOCBSA3               (*((volatile unsigned int  *) 0x48000030)) // Cb 3rd frame start address for codec DMA
#define CICOCBSA4               (*((volatile unsigned int  *) 0x48000034)) // Cb 4th frame start address for codec DMA
#define CICOCRSA1               (*((volatile unsigned int  *) 0x48000038)) // Cr 1st frame start address for codec DMA
#define CICOCRSA2               (*((volatile unsigned int  *) 0x4800003c)) // Cr 2nd frame start address for codec DMA
#define CICOCRSA3               (*((volatile unsigned int  *) 0x48000040)) // Cr 3rd frame start address for codec DMA
#define CICOCRSA4               (*((volatile unsigned int  *) 0x48000044)) // Cr 4th frame start address for codec DMA
#define CICOTRGFMT              (*((volatile unsigned int  *) 0x48000048)) // Target image format of codec DMA
#define CICOCTRL                (*((volatile unsigned int  *) 0x4800004c)) // Codec DMA control related
#define CICOSCPRERATIO          (*((volatile unsigned int  *) 0x48000050)) // Codec pre-scaler ratio control
#define CICOSCPREDST            (*((volatile unsigned int  *) 0x48000054)) // Codec pre-scaler destination format
#define CICOSCCTRL              (*((volatile unsigned int  *) 0x48000058)) // Codec main-scaler control
#define CICOTAREA               (*((volatile unsigned int  *) 0x4800005c)) // Codec scaler target area
#define CICOSTATUS              (*((volatile unsigned int  *) 0x48000064)) // Codec path status
#define CIPRCLRSA1              (*((volatile unsigned int  *) 0x4800006c)) // RGB 1st frame start address for preview DMA
#define CIPRCLRSA2              (*((volatile unsigned int  *) 0x48000070)) // RGB 2nd frame start address for preview DMA
#define CIPRCLRSA3              (*((volatile unsigned int  *) 0x48000074)) // RGB 3rd frame start address for preview DMA
#define CIPRCLRSA4              (*((volatile unsigned int  *) 0x48000078)) // RGB 4th frame start address for preview DMA
#define CIPRTRGFMT              (*((volatile unsigned int  *) 0x4800007c)) // Target image format of preview DMA
#define CIPRCTRL                (*((volatile unsigned int  *) 0x48000080)) // Preview DMA control related
#define CIPRSCPRERATIO          (*((volatile unsigned int  *) 0x48000084)) // Preview pre-scaler ratio control
#define CIPRSCPREDST            (*((volatile unsigned int  *) 0x48000088)) // Preview pre-scaler destination format
#define CIPRSCCTRL              (*((volatile unsigned int  *) 0x4800008c)) // Preview main-scaler control
#define CIPRTAREA               (*((volatile unsigned int  *) 0x48000090)) // Preview scaler target area
#define CIPRSTATUS              (*((volatile unsigned int  *) 0x48000098)) // Preview path status
#define CIIMGCPT                (*((volatile unsigned int  *) 0x480000a0)) // Image capture enable command


/*
** MPEG-4 Video Codec
*/

/* Motion Estimation */
#define ME_CFSA                 (*((volatile unsigned int  *) 0x48800000)) // Current frame start address register
#define ME_PFSA                 (*((volatile unsigned int  *) 0x48800004)) // Previous frame start address register
#define ME_MVSA                 (*((volatile unsigned int  *) 0x48800008)) // Motion vector start address register
#define ME_CMND                 (*((volatile unsigned int  *) 0x4880000c)) // Command register
#define ME_STAT_SWR             (*((volatile unsigned int  *) 0x48800010)) // Status & S/W reset register
#define ME_CNFG                 (*((volatile unsigned int  *) 0x48800014)) // Configuration register
#define ME_IMGFMT               (*((volatile unsigned int  *) 0x48800018)) // Image format register

/* Motion Compensation */
#define MC_PFYSA_ENC            (*((volatile unsigned int  *) 0x48c00000)) // Previous frame Y start address register (ENC)
#define MC_MFYSA_ENC            (*((volatile unsigned int  *) 0x48c00004)) // MCed frame Y start address register (ENC)
#define MC_PFYSA_DEC            (*((volatile unsigned int  *) 0x48c00008)) // Previous frame Y start address register (DEC)
#define MC_MFYSA_DEC            (*((volatile unsigned int  *) 0x48c0000c)) // MCed frame Y start address register (DEC)
#define MC_PFCbSA_ENC           (*((volatile unsigned int  *) 0x48c00010)) // Previous frame Cb start address register (ENC)
#define MC_PFCrSA_ENC           (*((volatile unsigned int  *) 0x48c00014)) // Previous frame Cr start address register (ENC)
#define MC_MFCbSA_ENC           (*((volatile unsigned int  *) 0x48c00018)) // MCed frame Cb start address register (ENC)
#define MC_MFCrSA_ENC           (*((volatile unsigned int  *) 0x48c0001c)) // MCed frame Cr start address register (ENC)
#define MC_PFCbSA_DEC           (*((volatile unsigned int  *) 0x48c00020)) // Previous frame Cb start address register (DEC)
#define MC_PFCrSA_DEC           (*((volatile unsigned int  *) 0x48c00024)) // Previous frame Cr start address register (DEC)
#define MC_MFCbSA_DEC           (*((volatile unsigned int  *) 0x48c00028)) // MCed frame Cb start address register (DEC)
#define MC_MFCrSA_DEC           (*((volatile unsigned int  *) 0x48c0002c)) // MCed frame Cr start address register (DEC)
#define MC_MVSA_ENC             (*((volatile unsigned int  *) 0x48c00030)) // Motion vector start address register (ENC)
#define MC_MVSA_DEC             (*((volatile unsigned int  *) 0x48c00034)) // Motion vector start address register (DEC)
#define MC_CMND                 (*((volatile unsigned int  *) 0x48c00038)) // Command register
#define MC_STAT_SWR             (*((volatile unsigned int  *) 0x48c0003c)) // Status & S/W reset register
#define MC_CNFG                 (*((volatile unsigned int  *) 0x48c00040)) // Configuration register
#define MC_IMGFMT               (*((volatile unsigned int  *) 0x48c00044)) // Image format register

/* DCTQ */
#define SAYCF                   (*((volatile unsigned int  *) 0x49000000)) // Current frame luminance start address
#define SACBCF                  (*((volatile unsigned int  *) 0x49000004)) // Current frame Cb start address
#define SACRCF                  (*((volatile unsigned int  *) 0x49000008)) // Current frame Cr start address
#define SAYRF                   (*((volatile unsigned int  *) 0x4900000c)) // Reference frame luminance start address
#define SACBRF                  (*((volatile unsigned int  *) 0x49000010)) // Reference frame Cb start address
#define SACRRF                  (*((volatile unsigned int  *) 0x49000014)) // Reference frame Cr start address
#define SAYDQF                  (*((volatile unsigned int  *) 0x49000018)) // DCTQed frame luminance start address
#define SACBDQF                 (*((volatile unsigned int  *) 0x4900001c)) // DCTQed frame Cb start address
#define SACRDQF                 (*((volatile unsigned int  *) 0x49000020)) // DCTQed frame Cr start address
#define SAQP                    (*((volatile unsigned int  *) 0x49000024)) // Qp start address
#define IMGSIZE                 (*((volatile unsigned int  *) 0x49000028)) // Image horizontal and vertical pixel number
#define SHQ                     (*((volatile unsigned int  *) 0x4900002c)) // Short header quantization mode
#define DCTQCTRL                (*((volatile unsigned int  *) 0x49000034)) // Control register

/* VLX */
#define COMMON1                 (*((volatile unsigned int  *) 0x4a200000)) // VLX common control register 1
#define FRAME_START_Y           (*((volatile unsigned int  *) 0x4a200004)) // Y coeff. frame start address
#define FRAME_START_CB          (*((volatile unsigned int  *) 0x4a200008)) // CB coeff. frame start address
#define FRAME_START_CR          (*((volatile unsigned int  *) 0x4a20000c)) // CR coeff. frame start address
#define VLC_CON1                (*((volatile unsigned int  *) 0x4a200010)) // Control register in VLC mode
#define VLC_CON2                (*((volatile unsigned int  *) 0x4a200014)) // Reserved -
#define VLC_CON3                (*((volatile unsigned int  *) 0x4a200018)) // VLC bit stream start addr
#define VLC_CON4                (*((volatile unsigned int  *) 0x4a20001c)) // Reserved
#define VLD_CON1                (*((volatile unsigned int  *) 0x4a200020)) // VLD control value setting register
#define VLD_CON2                (*((volatile unsigned int  *) 0x4a200024)) // VLD BIT_SADDR
#define VLD_CON3                (*((volatile unsigned int  *) 0x4a200028)) // Reserved -
#define VLX_OUT1                (*((volatile unsigned int  *) 0x4a20002c)) // VLX output information register. 1
#define VLX_OUT2                (*((volatile unsigned int  *) 0x4a200030)) // VLX output information register. 2


/*
** LCD Controller
*/

#define LCDCON1                 (*((volatile unsigned int  *) 0x4a000000)) // LCD Control 1
#define LCDCON2                 (*((volatile unsigned int  *) 0x4a000004)) // LCD Control 2
#define LCDTCON1                (*((volatile unsigned int  *) 0x4a000008)) // LCD Time Control 1
#define LCDTCON2                (*((volatile unsigned int  *) 0x4a00000c)) // LCD Time Control 2
#define LCDTCON3                (*((volatile unsigned int  *) 0x4a000010)) // LCD Time Control 3
#define LCDOSD1                 (*((volatile unsigned int  *) 0x4a000014)) // LCD OSD Control Register
#define LCDOSD2                 (*((volatile unsigned int  *) 0x4a000018)) // Foreground image (OSD Image) Left top position set
#define LCDOSD3                 (*((volatile unsigned int  *) 0x4a00001c)) // Foreground image (OSD Image) Right Bottom position set
#define LCDB1SADDR1             (*((volatile unsigned int  *) 0x4a000020)) // Frame Buffer Start Address 1 (Background buffer 1)
#define LCDB2SADDR1             (*((volatile unsigned int  *) 0x4a000024)) // Frame Buffer Start Address 2 (Background buffer 2)
#define LCDF1SADDR1             (*((volatile unsigned int  *) 0x4a000028)) // Frame Buffer Start Address 1 (Foreground buffer 1)
#define LCDF2SADDR1             (*((volatile unsigned int  *) 0x4a00002c)) // Frame Buffer Start Address 2 (Foreground buffer 2)
#define LCDB1SADDR2             (*((volatile unsigned int  *) 0x4a000030)) // Frame Buffer End Address 1 (Background buffer 1)
#define LCDB2SADDR2             (*((volatile unsigned int  *) 0x4a000034)) // Frame Buffer End Address 2 (Background buffer 2)
#define LCDF1SADDR2             (*((volatile unsigned int  *) 0x4a000038)) // Frame Buffer End Address 1 (Foreground buffer 1)
#define LCDF2SADDR2             (*((volatile unsigned int  *) 0x4a00003c)) // Frame Buffer End Address 2 (Foreground buffer 2)
#define LCDB1SADDR3             (*((volatile unsigned int  *) 0x4a000040)) // Virtual Screen Offset size and Page width (Background buffer 1)
#define LCDB2SADDR3             (*((volatile unsigned int  *) 0x4a000044)) // Virtual Screen Offset size and Page width (Background buffer 2)
#define LCDF1SADDR3             (*((volatile unsigned int  *) 0x4a000048)) // Virtual Screen Offset size and Page width (Foreground buffer 1)
#define LCDF2SADDR3             (*((volatile unsigned int  *) 0x4a00004c)) // Virtual Screen Offset size and Page width (Foreground buffer 2)
#define LCDINTCON               (*((volatile unsigned int  *) 0x4a000050)) // LCD Interrupt Control
#define LCDKEYCON               (*((volatile unsigned int  *) 0x4a000054)) // COLOR KEY Control 1
#define LCDKEYVAL               (*((volatile unsigned int  *) 0x4a000058)) // COLOR KEY Control 2
#define LCDBGCON                (*((volatile unsigned int  *) 0x4a00005c)) // Back-ground color Control
#define LCDFGCON                (*((volatile unsigned int  *) 0x4a000060)) // Fore-ground color Control
#define LCDDITHCON              (*((volatile unsigned int  *) 0x4a000064)) // LCD Dithering Control for Active Matrix


/*
** Post Processor
*/

#define MODE                    (*((volatile unsigned int  *) 0x4a100000)) // Mode Register [9:0]
#define PRESCALE_RATIO          (*((volatile unsigned int  *) 0x4a100004)) // Pre-Scale ratio for vertical andhorizontal
#define PRESCALEIMGSIZE         (*((volatile unsigned int  *) 0x4a100008)) // Pre-Scaled image size
#define SRCIMGSIZE              (*((volatile unsigned int  *) 0x4a10000c)) // Source image size
#define DX                      (*((volatile unsigned int  *) 0x4a100010)) // Main scale ratio along to horizontal direction
#define DY                      (*((volatile unsigned int  *) 0x4a100014)) // Main scale ratio along to vertical direction
#define DSTIMGSIZE              (*((volatile unsigned int  *) 0x4a100018)) // Destination image size
#define PRESCALE_SHFACTOR       (*((volatile unsigned int  *) 0x4a10001c)) // Pre-scale shift factor
#define ADDRSTART_Y             (*((volatile unsigned int  *) 0x4a100020)) // DMA Start address for Y or RGB component
#define ADDRSTART_CB            (*((volatile unsigned int  *) 0x4a100024)) // DMA Start address for Cb component
#define ADDRSTART_CR            (*((volatile unsigned int  *) 0x4a100028)) // DMA Start address for Cr component
#define ADDRSTART_RGB           (*((volatile unsigned int  *) 0x4a10002c)) // DMA Start address for RGB component
#define ADDREND_Y               (*((volatile unsigned int  *) 0x4a100030)) // DMA End address for Y or RGB component
#define ADDREND_CB              (*((volatile unsigned int  *) 0x4a100034)) // DMA End address for Cb component
#define ADDREND_CR              (*((volatile unsigned int  *) 0x4a100038)) // DMA End address for Cr component
#define ADDREND_RGB             (*((volatile unsigned int  *) 0x4a10003c)) // DMA End address for RGB component
#define OFFSET_Y                (*((volatile unsigned int  *) 0x4a100040)) // Offset of Y component for fetching source image
#define OFFSET_CB               (*((volatile unsigned int  *) 0x4a100044)) // Offset of Cb component for fetching source image
#define OFFSET_CR               (*((volatile unsigned int  *) 0x4a100048)) // Offset of Cr component for fetching source image
#define OFFSET_RGB              (*((volatile unsigned int  *) 0x4a10004c)) // Offset of RGB component for restoring destination image
#define EXTFB                   (*((volatile unsigned int  *) 0x4a100050)) // External Frame Buffer Control Register


/*
** De-block Filter
*/

#define DBF_MODE                (*((volatile unsigned int  *) 0x4a300000)) // Mode Register
#define DBF_MBLOCKSIZE          (*((volatile unsigned int  *) 0x4a300004)) // Block Size for Y Component
#define DBF_DEBLKCON            (*((volatile unsigned int  *) 0x4a300008)) // DeBlock Filter Characteristics Control Register
#define DBF_ADDRSTART_Y         (*((volatile unsigned int  *) 0x4a30000c)) // DMA Start address for Y component
#define DBF_ADDRSTART_CB        (*((volatile unsigned int  *) 0x4a300010)) // DMA Start address for Cb component
#define DBF_ADDRSTART_CR        (*((volatile unsigned int  *) 0x4a300014)) // DMA Start address for Cr component
#define DBF_ADDREND_Y           (*((volatile unsigned int  *) 0x4a300018)) // DMA End address for Y component
#define DBF_ADDREND_CB          (*((volatile unsigned int  *) 0x4a30001c)) // DMA End address for Cb component
#define DBF_ADDREND_CR          (*((volatile unsigned int  *) 0x4a300020)) // DMA End address for Cr component
#define DBF_ADDRSTART_QP        (*((volatile unsigned int  *) 0x4a300024)) // DMA Start address for Qp
#define DBF_NUMOFWORD_QP        (*((volatile unsigned int  *) 0x4a300028)) // Number of Words for DMA operation of Qp
#define DBF_OFFSET_Y            (*((volatile unsigned int  *) 0x4a30002c)) // Offset of Y component
#define DBF_OFFSET_C            (*((volatile unsigned int  *) 0x4a300030)) // Offset of Cb and Cr component


#endif   /* _S3C2460_H */
