/**************************************************************************
**                                                                        *
**  FILE        :  s3c2412.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for Samsung S3C2412        *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _S3C2412_H
#define _S3C2412_H


#ifdef __BIG_ENDIAN__
#define BIG_END_CHAR_OFF        3
#define BIG_END_HW_OFF          2
#else
#define BIG_END_CHAR_OFF        0
#define BIG_END_HW_OFF          0
#endif


/*
** Memory Controller
*/

#define BANKCFG                 (*((volatile unsigned int  *) 0x48000000)) // DRAM/SDRAM configuration
#define BANKCON1                (*((volatile unsigned int  *) 0x48000004)) // BANK1 Control
#define BANKCON2                (*((volatile unsigned int  *) 0x48000008)) // BANK2 Control
#define BANKCON3                (*((volatile unsigned int  *) 0x4800000c)) // BANK3 Control
#define REFRESH                 (*((volatile unsigned int  *) 0x48000010)) // DRAM/SDRAM Refresh Control
#define TIMEOUT                 (*((volatile unsigned int  *) 0x48000014)) // Write buffer time out control


/*
** EBI
*/

#define EBIPR                   (*((volatile unsigned int  *) 0x48800000)) // Bus priority decision
#define BANK_CFG                (*((volatile unsigned int  *) 0x48800004)) // Bank configuration


/*
** USB Host Controller
*/

#define HcRevision              (*((volatile unsigned int  *) 0x49000000)) // Control and Status Group
#define HcControl               (*((volatile unsigned int  *) 0x49000004))
#define HcCommonStatus          (*((volatile unsigned int  *) 0x49000008))
#define HcInterruptStatus       (*((volatile unsigned int  *) 0x4900000c))
#define HcInterruptEnable       (*((volatile unsigned int  *) 0x49000010))
#define HcInterruptDisable      (*((volatile unsigned int  *) 0x49000014))

#define HcHCCA                  (*((volatile unsigned int  *) 0x49000018)) // Memory Pointer Group
#define HcPeriodCuttentED       (*((volatile unsigned int  *) 0x4900001c))
#define HcControlHeadED         (*((volatile unsigned int  *) 0x49000020))
#define HcControlCurrentED      (*((volatile unsigned int  *) 0x49000024))
#define HcBulkHeadED            (*((volatile unsigned int  *) 0x49000028))
#define HcBulkCurrentED         (*((volatile unsigned int  *) 0x4900002c))
#define HcDoneHead              (*((volatile unsigned int  *) 0x49000030))

#define HcRmInterval            (*((volatile unsigned int  *) 0x49000034)) // Frame Counter Group
#define HcFmRemaining           (*((volatile unsigned int  *) 0x49000038))
#define HcFmNumber              (*((volatile unsigned int  *) 0x4900003c))
#define HcPeriodicStart         (*((volatile unsigned int  *) 0x49000040))
#define HcLSThreshold           (*((volatile unsigned int  *) 0x49000044))

#define HcRhDescriptorA         (*((volatile unsigned int  *) 0x49000048)) // Root Hub Group
#define HcRhDescriptorB         (*((volatile unsigned int  *) 0x4900004c))
#define HcRhStatus              (*((volatile unsigned int  *) 0x49000050))
#define HcRhPortStatus1         (*((volatile unsigned int  *) 0x49000054))
#define HcRhPortStatus2         (*((volatile unsigned int  *) 0x49000058))


/*
** Interrupt Controller
*/

#define SRCPND                  (*((volatile unsigned int  *) 0x4a000000)) // Interrupt request status
#define INTMOD                  (*((volatile unsigned int  *) 0x4a000004)) // Interrupt mode control
#define INTMSK                  (*((volatile unsigned int  *) 0x4a000008)) // Interrupt mask control
#define PRIORITY                (*((volatile unsigned int  *) 0x4a00000c)) // IRQ priority control
#define INTPND                  (*((volatile unsigned int  *) 0x4a000010)) // Interrupt request status
#define INTOFFSET               (*((volatile unsigned int  *) 0x4a000014)) // Interruot request source offset
#define SUBSRCPND               (*((volatile unsigned int  *) 0x4a000018)) // Sub source pending
#define INTSUBMSK               (*((volatile unsigned int  *) 0x4a00001c)) // Interrupt sub mask


/*
** DMA
*/

#define DISRC0                  (*((volatile unsigned int  *) 0x4b000000)) // DMA 0 Initial source
#define DISRCC0                 (*((volatile unsigned int  *) 0x4b000004)) // DMA 0 Initial source control
#define DIDST0                  (*((volatile unsigned int  *) 0x4b000008)) // DMA 0 Initial Destination
#define DIDSTC0                 (*((volatile unsigned int  *) 0x4b00000c)) // DMA 0 Initial Destination control
#define DCON0                   (*((volatile unsigned int  *) 0x4b000010)) // DMA 0 Control
#define DSTAT0                  (*((volatile unsigned int  *) 0x4b000014)) // DMA 0 Status
#define DCSRC0                  (*((volatile unsigned int  *) 0x4b000018)) // DMA 0 Current source
#define DCDST0                  (*((volatile unsigned int  *) 0x4b00001c)) // DMA 0 Current destination
#define DMASKTRIG0              (*((volatile unsigned int  *) 0x4b000020)) // DMA 0 Mask trigger
#define DMAREQSEL0              (*((volatile unsigned int  *) 0x4b000024)) // DMA 0 Request Selection Register

#define DISRC1                  (*((volatile unsigned int  *) 0x4b000040)) // DMA 1 Initial source
#define DISRCC1                 (*((volatile unsigned int  *) 0x4b000044)) // DMA 1 Initial source control
#define DIDST1                  (*((volatile unsigned int  *) 0x4b000048)) // DMA 1 Initial Destination
#define DIDSTC1                 (*((volatile unsigned int  *) 0x4b00004c)) // DMA 1 Initial Destination control
#define DCON1                   (*((volatile unsigned int  *) 0x4b000050)) // DMA 1 Control
#define DSTAT1                  (*((volatile unsigned int  *) 0x4b000054)) // DMA 1 Status
#define DCSRC1                  (*((volatile unsigned int  *) 0x4b000058)) // DMA 1 Current source
#define DCDST1                  (*((volatile unsigned int  *) 0x4b00005c)) // DMA 1 Current destination
#define DMASKTRIG1              (*((volatile unsigned int  *) 0x4b000060)) // DMA 1 Mask trigger
#define DMAREQSEL1              (*((volatile unsigned int  *) 0x4b000064)) // DMA 1 Request Selection Register

#define DISRC2                  (*((volatile unsigned int  *) 0x4b000080)) // DMA 2 Initial source
#define DISRCC2                 (*((volatile unsigned int  *) 0x4b000084)) // DMA 2 Initial source control
#define DIDST2                  (*((volatile unsigned int  *) 0x4b000088)) // DMA 2 Initial Destination
#define DIDSTC2                 (*((volatile unsigned int  *) 0x4b00008c)) // DMA 2 Initial Destination control
#define DCON2                   (*((volatile unsigned int  *) 0x4b000090)) // DMA 2 Control
#define DSTAT2                  (*((volatile unsigned int  *) 0x4b000094)) // DMA 2 Status
#define DCSRC2                  (*((volatile unsigned int  *) 0x4b000098)) // DMA 2 Current source
#define DCDST2                  (*((volatile unsigned int  *) 0x4b00009c)) // DMA 2 Current destination
#define DMASKTRIG2              (*((volatile unsigned int  *) 0x4b0000a0)) // DMA 2 Mask trigger
#define DMAREQSEL2              (*((volatile unsigned int  *) 0x4b0000a4)) // DMA 2 Request Selection Register

#define DISRC3                  (*((volatile unsigned int  *) 0x4b0000c0)) // DMA 3 Initial source
#define DISRCC3                 (*((volatile unsigned int  *) 0x4b0000c4)) // DMA 3 Initial source control
#define DIDST3                  (*((volatile unsigned int  *) 0x4b0000c8)) // DMA 3 Initial Destination
#define DIDSTC3                 (*((volatile unsigned int  *) 0x4b0000cc)) // DMA 3 Initial Destination control
#define DCON3                   (*((volatile unsigned int  *) 0x4b0000d0)) // DMA 3 Control
#define DSTAT3                  (*((volatile unsigned int  *) 0x4b0000d4)) // DMA 3 Status
#define DCSRC3                  (*((volatile unsigned int  *) 0x4b0000d8)) // DMA 3 Current source
#define DCDST3                  (*((volatile unsigned int  *) 0x4b0000dc)) // DMA 3 Current destination
#define DMASKTRIG3              (*((volatile unsigned int  *) 0x4b0000e0)) // DMA 3 Mask trigger
#define DMAREQSEL3              (*((volatile unsigned int  *) 0x4b0000e4)) // DMA 3 Request Selection Register


/*
** ATA Controller
*/

#define ATA_CONTROL             (*((volatile unsigned int  *) 0x4b800000)) // ATA control
#define ATA_STATUS              (*((volatile unsigned int  *) 0x4b800004)) // ATA status
#define ATA_COMMAND             (*((volatile unsigned int  *) 0x4b800008)) // ATA command
#define ATA_SWRST               (*((volatile unsigned int  *) 0x4b80000c)) // ATA S/W reset
#define ATA_IRQ                 (*((volatile unsigned int  *) 0x4b800010)) // ATA IRQ
#define ATA_IRQ_MASK            (*((volatile unsigned int  *) 0x4b800014)) // ATA IRQ MASK
#define ATA_CFG                 (*((volatile unsigned int  *) 0x4b800018)) // ATA configuration
#define ATA_PIO_TIME            (*((volatile unsigned int  *) 0x4b80002c)) // ATA PIO time
#define ATA_XFR_NUM             (*((volatile unsigned int  *) 0x4b800034)) // ATA data transfer number
#define ATA_XFR_CNT             (*((volatile unsigned int  *) 0x4b800038)) // ATA data transfer count
#define ATA_TBUF_START          (*((volatile unsigned int  *) 0x4b80003c)) // ATA tract buffer start adress
#define ATA_TBUF_SIZE           (*((volatile unsigned int  *) 0x4b800040)) // ATA tract buffer size
#define ATA_SBUF_START          (*((volatile unsigned int  *) 0x4b800044)) // ATA source buffer start adress
#define ATA_SBUF_SIZE           (*((volatile unsigned int  *) 0x4b800048)) // ATA source buffer size
#define ATA_CADDR_TBUR          (*((volatile unsigned int  *) 0x4b80004c)) // ATA tract buffer current address
#define ATA_CADDR_SBUR          (*((volatile unsigned int  *) 0x4b800050)) // ATA source buffer current address
#define ATA_PIO_DTR             (*((volatile unsigned int  *) 0x4b800054)) // ATA PIO 16 bit data
#define ATA_PIO_FED             (*((volatile unsigned int  *) 0x4b800058)) // ATA PIO feature/error
#define ATA_PIO_SCR             (*((volatile unsigned int  *) 0x4b80005c)) // ATA PIO sector count
#define ATA_PIO_LLR             (*((volatile unsigned int  *) 0x4b800060)) // ATA PIO LBA low
#define ATA_PIO_LMR             (*((volatile unsigned int  *) 0x4b800064)) // ATA PIO LBA middle
#define ATA_PIO_LHR             (*((volatile unsigned int  *) 0x4b800068)) // ATA PIO LBA high
#define ATA_PIO_DVR             (*((volatile unsigned int  *) 0x4b80006c)) // ATA PIO device
#define ATA_PIO_CSD             (*((volatile unsigned int  *) 0x4b800070)) // ATA PIO command/status
#define ATA_PIO_DAD             (*((volatile unsigned int  *) 0x4b800074)) // ATA PIO control/alternate status
#define ATA_PIO_READY           (*((volatile unsigned int  *) 0x4b800078)) // ATA PIO READY
#define ATA_PIO_RDATA           (*((volatile unsigned int  *) 0x4b80007c)) // ATA read data
#define BUS_FIFO_STATUS         (*((volatile unsigned int  *) 0x4b800090)) // Bus FIFO status
#define ATA_FIFO_STATUS         (*((volatile unsigned int  *) 0x4b800094)) // ATA FIFO status


/*
** Clock & Power Management
*/

#define LOCKTIME                (*((volatile unsigned int  *) 0x4c000000)) // PLL Lock Time Counter
#define MPLLCON                 (*((volatile unsigned int  *) 0x4c000004)) // MPLL Control
#define UPLLCON                 (*((volatile unsigned int  *) 0x4c000008)) // UPLL Control
#define CLKCON                  (*((volatile unsigned int  *) 0x4c00000c)) // Clock Generator Control
#define CLKDIVN                 (*((volatile unsigned int  *) 0x4c000014)) // Clock divider Control
#define OSCSET                  (*((volatile unsigned int  *) 0x4c000018)) // Oscillator stabilization time counter
#define CLKSRC                  (*((volatile unsigned int  *) 0x4c00001c)) // Clock source Control
#define PWRMODECON              (*((volatile unsigned int  *) 0x4c000020)) // Power management mode setting
#define PWRCFG                  (*((volatile unsigned int  *) 0x4c000024)) // Power management Configuration
#define ENDIAN                  (*((volatile unsigned int  *) 0x4c00002c)) // System endian control
#define SWRSTCON                (*((volatile unsigned int  *) 0x4c000030)) // S/W reset control register
#define RSTCON                  (*((volatile unsigned int  *) 0x4c000034)) // Reset control
#define INFORM0                 (*((volatile unsigned int  *) 0x4c000070)) // User Defined information 0
#define INFORM1                 (*((volatile unsigned int  *) 0x4c000074)) // User Defined information 1
#define INFORM2                 (*((volatile unsigned int  *) 0x4c000078)) // User Defined information 2
#define INFORM3                 (*((volatile unsigned int  *) 0x4c00007c)) // User Defined information 3


/*
** LCD Controller
*/

#define LCDCON1                 (*((volatile unsigned int  *) 0x4d000000)) // LCD Control 1
#define LCDCON2                 (*((volatile unsigned int  *) 0x4d000004)) // LCD Control 2
#define LCDCON3                 (*((volatile unsigned int  *) 0x4d000008)) // LCD Control 3
#define LCDCON4                 (*((volatile unsigned int  *) 0x4d00000c)) // LCD Control 4
#define LCDCON5                 (*((volatile unsigned int  *) 0x4d000010)) // LCD Control 5
#define LCDSADDR1               (*((volatile unsigned int  *) 0x4d000014)) // STN/TFT: Frame Buffer Start Address1
#define LCDSADDR2               (*((volatile unsigned int  *) 0x4d000018)) // STN/TFT: Frame Buffer Start Address2
#define LCDSADDR3               (*((volatile unsigned int  *) 0x4d00001c)) // STN/TFT: Virtual Screen Address Set
#define TPAL                    (*((volatile unsigned int  *) 0x4d000020)) // TFT: Temporary palette
#define LCDINTPND               (*((volatile unsigned int  *) 0x4d000024)) // LCD Interrupt Pending
#define LCDSRCPND               (*((volatile unsigned int  *) 0x4d000028)) // LCD Interrupt Source
#define LCDINTMSK               (*((volatile unsigned int  *) 0x4d00002c)) // LCD Interrupt Mask
#define TCONSEL                 (*((volatile unsigned int  *) 0x4d000030)) // TCON(LPC3600/LCC3600) Control
#define LCDCON6                 (*((volatile unsigned int  *) 0x4d000034)) // LCD Control 6
#define LCDCON7                 (*((volatile unsigned int  *) 0x4d000038)) // LCD Control 7
#define LCDCON8                 (*((volatile unsigned int  *) 0x4d00003c)) // LCD Control 8
#define LCDCON9                 (*((volatile unsigned int  *) 0x4d000040)) // LCD Control 9
#define REDLUT0                 (*((volatile unsigned int  *) 0x4d000044)) // Red Lookup table[31:0]
#define REDLUT1                 (*((volatile unsigned int  *) 0x4d000048)) // Red Lookup table[63:32]
#define REDLUT2                 (*((volatile unsigned int  *) 0x4d00004c)) // Red Lookup table[95:64]
#define REDLUT3                 (*((volatile unsigned int  *) 0x4d000050)) // Red Lookup table[127:96]
#define REDLUT4                 (*((volatile unsigned int  *) 0x4d000054)) // Red Lookup table[159:128]
#define REDLUT5                 (*((volatile unsigned int  *) 0x4d000058)) // Red Lookup table[191:160]
#define REDLUT6                 (*((volatile unsigned int  *) 0x4d00005c)) // Red Lookup table[223:192]
#define GREENLUT0               (*((volatile unsigned int  *) 0x4d000060)) // GREEN Lookup table[31:0]
#define GREENLUT1               (*((volatile unsigned int  *) 0x4d000064)) // GREEN Lookup table[63:32]
#define GREENLUT2               (*((volatile unsigned int  *) 0x4d000068)) // GREEN Lookup table[95:64]
#define GREENLUT3               (*((volatile unsigned int  *) 0x4d00006c)) // GREEN Lookup table[127:96]
#define GREENLUT4               (*((volatile unsigned int  *) 0x4d000070)) // GREEN Lookup table[159:128]
#define GREENLUT5               (*((volatile unsigned int  *) 0x4d000074)) // GREEN Lookup table[191:160]
#define GREENLUT6               (*((volatile unsigned int  *) 0x4d000078)) // GREEN Lookup table[223:192]
#define GREENLUT7               (*((volatile unsigned int  *) 0x4d00007c)) // GREEN Lookup table[255:224]
#define GREENLUT8               (*((volatile unsigned int  *) 0x4d000080)) // GREEN Lookup table[287:256]
#define GREENLUT9               (*((volatile unsigned int  *) 0x4d000084)) // GREEN Lookup table[319:288]
#define GREENLUT10              (*((volatile unsigned int  *) 0x4d000088)) // GREEN Lookup table[351:320]
#define GREENLUT11              (*((volatile unsigned int  *) 0x4d00008c)) // GREEN Lookup table[383:352]
#define GREENLUT12              (*((volatile unsigned int  *) 0x4d000090)) // GREEN Lookup table[415:384]
#define GREENLUT13              (*((volatile unsigned int  *) 0x4d000094)) // GREEN Lookup table[447:416]
#define BLUELUT0                (*((volatile unsigned int  *) 0x4d000098)) // BLUE Lookup table[31:0]
#define BLUELUT1                (*((volatile unsigned int  *) 0x4d00009c)) // BLUE Lookup table[63:32]
#define BLUELUT2                (*((volatile unsigned int  *) 0x4d0000a0)) // BLUE Lookup table[95:64]
#define BLUELUT3                (*((volatile unsigned int  *) 0x4d0000a4)) // BLUE Lookup table[127:96]
#define BLUELUT4                (*((volatile unsigned int  *) 0x4d0000a8)) // BLUE Lookup table[159:128]
#define BLUELUT5                (*((volatile unsigned int  *) 0x4d0000ac)) // BLUE Lookup table[191:160]
#define BLUELUT6                (*((volatile unsigned int  *) 0x4d0000b0)) // BLUE Lookup table[223:192]
#define FRCPAT0                 (*((volatile unsigned int  *) 0x4d0000b4)) // FRC Pattern Register
#define FRCPAT1                 (*((volatile unsigned int  *) 0x4d0000b8)) // FRC Pattern Register
#define FRCPAT2                 (*((volatile unsigned int  *) 0x4d0000bc)) // FRC Pattern Register
#define FRCPAT3                 (*((volatile unsigned int  *) 0x4d0000c0)) // FRC Pattern Register
#define FRCPAT4                 (*((volatile unsigned int  *) 0x4d0000c4)) // FRC Pattern Register
#define FRCPAT5                 (*((volatile unsigned int  *) 0x4d0000c8)) // FRC Pattern Register
#define FRCPAT6                 (*((volatile unsigned int  *) 0x4d0000cc)) // FRC Pattern Register
#define FRCPAT7                 (*((volatile unsigned int  *) 0x4d0000d0)) // FRC Pattern Register
#define FRCPAT8                 (*((volatile unsigned int  *) 0x4d0000d4)) // FRC Pattern Register
#define FRCPAT9                 (*((volatile unsigned int  *) 0x4d0000d8)) // FRC Pattern Register
#define FRCPAT10                (*((volatile unsigned int  *) 0x4d0000dc)) // FRC Pattern Register
#define FRCPAT11                (*((volatile unsigned int  *) 0x4d0000e0)) // FRC Pattern Register
#define FRCPAT12                (*((volatile unsigned int  *) 0x4d0000e4)) // FRC Pattern Register
#define FRCPAT13                (*((volatile unsigned int  *) 0x4d0000e8)) // FRC Pattern Register
#define FRCPAT14                (*((volatile unsigned int  *) 0x4d0000ec)) // FRC Pattern Register
#define FRCPAT15                (*((volatile unsigned int  *) 0x4d0000f0)) // FRC Pattern Register
#define FRCPAT16                (*((volatile unsigned int  *) 0x4d0000f4)) // FRC Pattern Register
#define FRCPAT17                (*((volatile unsigned int  *) 0x4d0000f8)) // FRC Pattern Register
#define FRCPAT18                (*((volatile unsigned int  *) 0x4d0000fc)) // FRC Pattern Register
#define FRCPAT19                (*((volatile unsigned int  *) 0x4d000100)) // FRC Pattern Register
#define FRCPAT20                (*((volatile unsigned int  *) 0x4d000104)) // FRC Pattern Register
#define FRCPAT21                (*((volatile unsigned int  *) 0x4d000108)) // FRC Pattern Register
#define FRCPAT22                (*((volatile unsigned int  *) 0x4d00010c)) // FRC Pattern Register
#define FRCPAT23                (*((volatile unsigned int  *) 0x4d000110)) // FRC Pattern Register
#define FRCPAT24                (*((volatile unsigned int  *) 0x4d000114)) // FRC Pattern Register
#define FRCPAT25                (*((volatile unsigned int  *) 0x4d000118)) // FRC Pattern Register
#define FRCPAT26                (*((volatile unsigned int  *) 0x4d00011c)) // FRC Pattern Register
#define FRCPAT27                (*((volatile unsigned int  *) 0x4d000120)) // FRC Pattern Register
#define FRCPAT28                (*((volatile unsigned int  *) 0x4d000124)) // FRC Pattern Register
#define FRCPAT29                (*((volatile unsigned int  *) 0x4d000128)) // FRC Pattern Register
#define FRCPAT30                (*((volatile unsigned int  *) 0x4d00012c)) // FRC Pattern Register
#define FRCPAT31                (*((volatile unsigned int  *) 0x4d000130)) // FRC Pattern Register
#define FRCPAT32                (*((volatile unsigned int  *) 0x4d000134)) // FRC Pattern Register
#define FRCPAT33                (*((volatile unsigned int  *) 0x4d000138)) // FRC Pattern Register
#define FRCPAT34                (*((volatile unsigned int  *) 0x4d00013c)) // FRC Pattern Register
#define FRCPAT35                (*((volatile unsigned int  *) 0x4d000140)) // FRC Pattern Register
#define FRCPAT36                (*((volatile unsigned int  *) 0x4d000144)) // FRC Pattern Register
#define FRCPAT37                (*((volatile unsigned int  *) 0x4d000148)) // FRC Pattern Register
#define FRCPAT38                (*((volatile unsigned int  *) 0x4d00014c)) // FRC Pattern Register
#define FRCPAT39                (*((volatile unsigned int  *) 0x4d000150)) // FRC Pattern Register
#define FRCPAT40                (*((volatile unsigned int  *) 0x4d000154)) // FRC Pattern Register
#define FRCPAT41                (*((volatile unsigned int  *) 0x4d000158)) // FRC Pattern Register
#define FRCPAT42                (*((volatile unsigned int  *) 0x4d00015c)) // FRC Pattern Register
#define FRCPAT43                (*((volatile unsigned int  *) 0x4d000160)) // FRC Pattern Register
#define FRCPAT44                (*((volatile unsigned int  *) 0x4d000164)) // FRC Pattern Register
#define FRCPAT45                (*((volatile unsigned int  *) 0x4d000168)) // FRC Pattern Register
#define FRCPAT46                (*((volatile unsigned int  *) 0x4d00016c)) // FRC Pattern Register
#define FRCPAT47                (*((volatile unsigned int  *) 0x4d000170)) // FRC Pattern Register
#define FRCPAT48                (*((volatile unsigned int  *) 0x4d000174)) // FRC Pattern Register
#define FRCPAT49                (*((volatile unsigned int  *) 0x4d000178)) // FRC Pattern Register
#define FRCPAT50                (*((volatile unsigned int  *) 0x4d00017c)) // FRC Pattern Register
#define FRCPAT51                (*((volatile unsigned int  *) 0x4d000180)) // FRC Pattern Register
#define FRCPAT52                (*((volatile unsigned int  *) 0x4d000184)) // FRC Pattern Register
#define FRCPAT53                (*((volatile unsigned int  *) 0x4d000188)) // FRC Pattern Register
#define FRCPAT54                (*((volatile unsigned int  *) 0x4d00018c)) // FRC Pattern Register
#define FRCPAT55                (*((volatile unsigned int  *) 0x4d000190)) // FRC Pattern Register
#define FRCPAT56                (*((volatile unsigned int  *) 0x4d000194)) // FRC Pattern Register
#define FRCPAT57                (*((volatile unsigned int  *) 0x4d000198)) // FRC Pattern Register
#define FRCPAT58                (*((volatile unsigned int  *) 0x4d00019c)) // FRC Pattern Register
#define FRCPAT59                (*((volatile unsigned int  *) 0x4d0001a0)) // FRC Pattern Register
#define FRCPAT60                (*((volatile unsigned int  *) 0x4d0001a4)) // FRC Pattern Register
#define FRCPAT61                (*((volatile unsigned int  *) 0x4d0001a8)) // FRC Pattern Register
#define FRCPAT62                (*((volatile unsigned int  *) 0x4d0001ac)) // FRC Pattern Register
#define FRCPAT63                (*((volatile unsigned int  *) 0x4d0001b0)) // FRC Pattern Register


/*
** NAND Flash
*/

#define NFCONF                  (*((volatile unsigned int  *) 0x4e000000)) // NAND Flash Configuration
#define NFCONT                  (*((volatile unsigned int  *) 0x4e000004)) // NAND Flash Control
#define NFCMMD                  (*((volatile unsigned int  *) 0x4e000008)) // NAND Flash Command
#define NFADDR                  (*((volatile unsigned int  *) 0x4e00000c)) // NAND Flash Address
#define NFDATA                  (*((volatile unsigned int  *) 0x4e000010)) // NAND Flash Data
#define NFMECCD0                (*((volatile unsigned int  *) 0x4e000014)) // NAND Flash Main area ECC0/1
#define NFMECCD1                (*((volatile unsigned int  *) 0x4e000018)) // NAND Flash Main area ECC2/3
#define NFSECCD                 (*((volatile unsigned int  *) 0x4e00001c)) // NAND Flash Spare area ECC
#define NFSBLK                  (*((volatile unsigned int  *) 0x4e000020)) // NAND Flash start block address
#define NFEBLK                  (*((volatile unsigned int  *) 0x4e000024)) // NAND Flash end block address
#define NFSTAT                  (*((volatile unsigned int  *) 0x4e000028)) // NAND Flash Operation Status
#define NFECCERR0               (*((volatile unsigned int  *) 0x4e00002c)) // NAND Flash ECC error Status 0
#define NFECCERR1               (*((volatile unsigned int  *) 0x4e000030)) // NAND Flash ECC error Status 1
#define NFMECC0                 (*((volatile unsigned int  *) 0x4e000034)) // NAND Flash Main area ECC0 status
#define NFMECC1                 (*((volatile unsigned int  *) 0x4e000038)) // NAND Flash Main Area ECC1 status
#define NFSECC                  (*((volatile unsigned int  *) 0x4e00003c)) // NAND Flash Spare Area ECC status
#define NFMLCBITPT              (*((volatile unsigned int  *) 0x4e000040)) // 4-bit ECC error bit pattern


/*
** SSMC
*/

#define SMBIDCYR0               (*((volatile unsigned int  *) 0x4f000000)) // BANK0 idle cycle control
#define SMBWSTRDR0              (*((volatile unsigned int  *) 0x4f000004)) // BANK0 read wait state control
#define SMBWSTWRR0              (*((volatile unsigned int  *) 0x4f000008)) // BANK0 write wait state control
#define SMBWSTOENR0             (*((volatile unsigned int  *) 0x4f00000c)) // BANK0 output enable assertion delay control
#define SMBWSTWENR0             (*((volatile unsigned int  *) 0x4f000010)) // BANK0 write enable assertion delay control
#define SMBCR0                  (*((volatile unsigned int  *) 0x4f000014)) // BANK0 control
#define SMBSR0                  (*((volatile unsigned int  *) 0x4f000018)) // BANK0 status
#define SMBWSTBRDR0             (*((volatile unsigned int  *) 0x4f00001c)) // BANK0 burst read wait delay control
#define SMBIDCYR1               (*((volatile unsigned int  *) 0x4f000020)) // BANK1 idle cycle control
#define SMBWSTRDR1              (*((volatile unsigned int  *) 0x4f000024)) // BANK1 read wait state control
#define SMBWSTWRR1              (*((volatile unsigned int  *) 0x4f000028)) // BANK1 write wait state control
#define SMBWSTOENR1             (*((volatile unsigned int  *) 0x4f00002c)) // BANK1 output enable assertion delay control
#define SMBWSTWENR1             (*((volatile unsigned int  *) 0x4f000030)) // BANK1 write enable assertion delay control
#define SMBCR1                  (*((volatile unsigned int  *) 0x4f000034)) // BANK1 control
#define SMBSR1                  (*((volatile unsigned int  *) 0x4f000038)) // BANK1 status
#define SMBWSTBRDR1             (*((volatile unsigned int  *) 0x4f00003c)) // BANK1 burst read wait delay control
#define SMBIDCYR2               (*((volatile unsigned int  *) 0x4f000040)) // BANK2 idle cycle control
#define SMBWSTRDR2              (*((volatile unsigned int  *) 0x4f000044)) // BANK2 read wait state control
#define SMBWSTWRR2              (*((volatile unsigned int  *) 0x4f000048)) // BANK2 write wait state control
#define SMBWSTOENR2             (*((volatile unsigned int  *) 0x4f00004c)) // BANK2 output enable assertion delay control
#define SMBWSTWENR2             (*((volatile unsigned int  *) 0x4f000050)) // BANK2 write enable assertion delay control
#define SMBCR2                  (*((volatile unsigned int  *) 0x4f000054)) // BANK2 control
#define SMBSR2                  (*((volatile unsigned int  *) 0x4f000058)) // BANK2 status
#define SMBWSTBRDR2             (*((volatile unsigned int  *) 0x4f00005c)) // BANK2 burst read wait delay control
#define SMBIDCYR3               (*((volatile unsigned int  *) 0x4f000060)) // BANK3 idle cycle control
#define SMBWSTRDR3              (*((volatile unsigned int  *) 0x4f000064)) // BANK3 read wait state control
#define SMBWSTWRR3              (*((volatile unsigned int  *) 0x4f000068)) // BANK3 write wait state control
#define SMBWSTOENR3             (*((volatile unsigned int  *) 0x4f00006c)) // BANK3 output enable assertion delay control
#define SMBWSTWENR3             (*((volatile unsigned int  *) 0x4f000070)) // BANK3 write enable assertion delay control
#define SMBCR3                  (*((volatile unsigned int  *) 0x4f000074)) // BANK3 control
#define SMBSR3                  (*((volatile unsigned int  *) 0x4f000078)) // BANK3 status
#define SMBWSTBRDR3             (*((volatile unsigned int  *) 0x4f00007c)) // BANK3 burst read wait delay control
#define SMBIDCYR4               (*((volatile unsigned int  *) 0x4f000080)) // BANK4 idle cycle control
#define SMBWSTRDR4              (*((volatile unsigned int  *) 0x4f000084)) // BANK4 read wait state control
#define SMBWSTWRR4              (*((volatile unsigned int  *) 0x4f000088)) // BANK4 write wait state control
#define SMBWSTOENR4             (*((volatile unsigned int  *) 0x4f00008c)) // BANK4 output enable assertion delay control
#define SMBWSTWENR4             (*((volatile unsigned int  *) 0x4f000090)) // BANK4 write enable assertion delay control
#define SMBCR4                  (*((volatile unsigned int  *) 0x4f000094)) // BANK4 control
#define SMBSR4                  (*((volatile unsigned int  *) 0x4f000098)) // BANK4 status
#define SMBWSTBRDR4             (*((volatile unsigned int  *) 0x4f00009c)) // BANK4 burst read wait delay control
#define SMBIDCYR5               (*((volatile unsigned int  *) 0x4f0000a0)) // BANK5 idle cycle control
#define SMBWSTRDR5              (*((volatile unsigned int  *) 0x4f0000a4)) // BANK5 read wait state control
#define SMBWSTWRR5              (*((volatile unsigned int  *) 0x4f0000a8)) // BANK5 write wait state control
#define SMBWSTOENR5             (*((volatile unsigned int  *) 0x4f0000ac)) // BANK5 output enable assertion delay control
#define SMBWSTWENR5             (*((volatile unsigned int  *) 0x4f0000b0)) // BANK5 write enable assertion delay control
#define SMBCR5                  (*((volatile unsigned int  *) 0x4f0000b4)) // BANK5 control
#define SMBSR5                  (*((volatile unsigned int  *) 0x4f0000b8)) // BANK5 status
#define SMBWSTBRDR5             (*((volatile unsigned int  *) 0x4f0000bc)) // BANK5 burst read wait delay control
#define SMBIDCYR6               (*((volatile unsigned int  *) 0x4f0000c0)) // BANK6 idle cycle control
#define SMBWSTRDR6              (*((volatile unsigned int  *) 0x4f0000c4)) // BANK6 read wait state control
#define SMBWSTWRR6              (*((volatile unsigned int  *) 0x4f0000c8)) // BANK6 write wait state control
#define SMBWSTOENR6             (*((volatile unsigned int  *) 0x4f0000cc)) // BANK6 output enable assertion delay control
#define SMBWSTWENR6             (*((volatile unsigned int  *) 0x4f0000d0)) // BANK6 write enable assertion delay control
#define SMBCR6                  (*((volatile unsigned int  *) 0x4f0000d4)) // BANK6 control
#define SMBSR6                  (*((volatile unsigned int  *) 0x4f0000d8)) // BANK6 status
#define SMBWSTBRDR6             (*((volatile unsigned int  *) 0x4f0000dc)) // BANK6 burst read wait delay control
#define SMBIDCYR7               (*((volatile unsigned int  *) 0x4f0000e0)) // BANK7 idle cycle control
#define SMBWSTRDR7              (*((volatile unsigned int  *) 0x4f0000e4)) // BANK7 read wait state control
#define SMBWSTWRR7              (*((volatile unsigned int  *) 0x4f0000e8)) // BANK7 write wait state control
#define SMBWSTOENR7             (*((volatile unsigned int  *) 0x4f0000ec)) // BANK7 output enable assertion delay control
#define SMBWSTWENR7             (*((volatile unsigned int  *) 0x4f0000f0)) // BANK7 write enable assertion delay control
#define SMBCR7                  (*((volatile unsigned int  *) 0x4f0000f4)) // BANK7 control
#define SMBSR7                  (*((volatile unsigned int  *) 0x4f0000f8)) // BANK7 status
#define SMBWSTBRDR7             (*((volatile unsigned int  *) 0x4f0000fc)) // BANK7 burst read wait delay control
#define SSMCSR                  (*((volatile unsigned int  *) 0x4f000200)) // SROMC status
#define SSMCCR                  (*((volatile unsigned int  *) 0x4f000204)) // SROMC control


/*
** UART
*/

#define ULCON0                  (*((volatile unsigned int  *) 0x50000000)) // UART 0 Line control
#define UCON0                   (*((volatile unsigned int  *) 0x50000004)) // UART 0 Control
#define UFCON0                  (*((volatile unsigned int  *) 0x50000008)) // UART 0 FIFO control
#define UMCON0                  (*((volatile unsigned int  *) 0x5000000c)) // UART 0 Modem control
#define UTRSTAT0                (*((volatile unsigned int  *) 0x50000010)) // UART 0 Tx/Rx status
#define UERSTAT0                (*((volatile unsigned int  *) 0x50000014)) // UART 0 Rx error status
#define UFSTAT0                 (*((volatile unsigned int  *) 0x50000018)) // UART 0 FIFO status
#define UMSTAT0                 (*((volatile unsigned int  *) 0x5000001c)) // UART 0 Modem status
#define UTXH0                   (*((volatile unsigned char *)(0x50000020 + BIG_END_CHAR_OFF))) // UART 0 Transmission Hold
#define URXH0                   (*((volatile unsigned char *)(0x50000024 + BIG_END_CHAR_OFF))) // UART 0 Receive buffer
#define UBRDIV0                 (*((volatile unsigned int  *) 0x50000028)) // UART 0 Baud rate divisor
#define UDIVSLOT0               (*((volatile unsigned int  *) 0x5000002c)) // UART 0 Baud rate division

#define ULCON1                  (*((volatile unsigned int  *) 0x50004000)) // UART 1 Line control
#define UCON1                   (*((volatile unsigned int  *) 0x50004004)) // UART 1 Control
#define UFCON1                  (*((volatile unsigned int  *) 0x50004008)) // UART 1 FIFO control
#define UMCON1                  (*((volatile unsigned int  *) 0x5000400c)) // UART 1 Modem control
#define UTRSTAT1                (*((volatile unsigned int  *) 0x50004010)) // UART 1 Tx/Rx status
#define UERSTAT1                (*((volatile unsigned int  *) 0x50004014)) // UART 1 Rx error status
#define UFSTAT1                 (*((volatile unsigned int  *) 0x50004018)) // UART 1 FIFO status
#define UMSTAT1                 (*((volatile unsigned int  *) 0x5000401c)) // UART 1 Modem status
#define UTXH1                   (*((volatile unsigned char *)(0x50004020 + BIG_END_CHAR_OFF))) // UART 1 Transmission Hold
#define URXH1                   (*((volatile unsigned char *)(0x50004024 + BIG_END_CHAR_OFF))) // UART 1 Receive buffer
#define UBRDIV1                 (*((volatile unsigned int  *) 0x50004028)) // UART 1 Baud rate divisor
#define UDIVSLOT1               (*((volatile unsigned int  *) 0x5000402c)) // UART 1 Baud rate division

#define ULCON2                  (*((volatile unsigned int  *) 0x50008000)) // UART 2 Line control
#define UCON2                   (*((volatile unsigned int  *) 0x50008004)) // UART 2 Control
#define UFCON2                  (*((volatile unsigned int  *) 0x50008008)) // UART 2 FIFO control
#define UMCON2                  (*((volatile unsigned int  *) 0x5000800c)) // UART 2 Modem control
#define UTRSTAT2                (*((volatile unsigned int  *) 0x50008010)) // UART 2 Tx/Rx status
#define UERSTAT2                (*((volatile unsigned int  *) 0x50008014)) // UART 2 Rx error status
#define UFSTAT2                 (*((volatile unsigned int  *) 0x50008018)) // UART 2 FIFO status
#define UMSTAT2                 (*((volatile unsigned int  *) 0x5000801c)) // UART 2 Modem status
#define UTXH2                   (*((volatile unsigned char *)(0x50008020 + BIG_END_CHAR_OFF))) // UART 2 Transmission Hold
#define URXH2                   (*((volatile unsigned char *)(0x50008024 + BIG_END_CHAR_OFF))) // UART 2 Receive buffer
#define UBRDIV2                 (*((volatile unsigned int  *) 0x50008028)) // UART 2 Baud rate divisor
#define UDIVSLOT2               (*((volatile unsigned int  *) 0x5000802c)) // UART 2 Baud rate division


/*
** PWM Timer
*/

#define TCFG0                   (*((volatile unsigned int  *) 0x51000000)) // Timer 0 configuration
#define TCFG1                   (*((volatile unsigned int  *) 0x51000004)) // Timer 1 configuration
#define TCON                    (*((volatile unsigned int  *) 0x51000008)) // Timer control
#define TCNTB0                  (*((volatile unsigned int  *) 0x5100000c)) // Timer count buffer 0
#define TCMPB0                  (*((volatile unsigned int  *) 0x51000010)) // Timer compare buffer 0
#define TCNTO0                  (*((volatile unsigned int  *) 0x51000014)) // Timer count observation 0
#define TCNTB1                  (*((volatile unsigned int  *) 0x51000018)) // Timer count buffer 1
#define TCMPB1                  (*((volatile unsigned int  *) 0x5100001c)) // Timer compare buffer 1
#define TCNTO1                  (*((volatile unsigned int  *) 0x51000020)) // Timer count observation 1
#define TCNTB2                  (*((volatile unsigned int  *) 0x51000024)) // Timer count buffer 2
#define TCMPB2                  (*((volatile unsigned int  *) 0x51000028)) // Timer compare buffer 2
#define TCNTO2                  (*((volatile unsigned int  *) 0x5100002c)) // Timer count observation 2
#define TCNTB3                  (*((volatile unsigned int  *) 0x51000030)) // Timer count buffer 3
#define TCMPB3                  (*((volatile unsigned int  *) 0x51000034)) // Timer compare buffer 3
#define TCNTO3                  (*((volatile unsigned int  *) 0x51000038)) // Timer count observation 3
#define TCNTB4                  (*((volatile unsigned int  *) 0x5100003c)) // Timer count buffer 4
#define TCNTO4                  (*((volatile unsigned int  *) 0x51000040)) // Timer count observation 4


/*
** USB Device
*/

#define FUNC_ADDR_REG           (*((volatile unsigned char *) (0x52000140 + BIG_END_CHAR_OFF))) // Function address
#define PWR_REG                 (*((volatile unsigned char *) (0x52000144 + BIG_END_CHAR_OFF))) // Power management
#define EP_INT_REG              (*((volatile unsigned char *) (0x52000148 + BIG_END_CHAR_OFF))) // EP Interrupt pending and clear
#define USB_INT_REG             (*((volatile unsigned char *) (0x52000158 + BIG_END_CHAR_OFF))) // USB Interrupt pending and clear
#define EP_INT_EN_REG           (*((volatile unsigned char *) (0x5200015c + BIG_END_CHAR_OFF))) // Interrupt enable
#define USB_INT_EN_REG          (*((volatile unsigned char *) (0x5200016c + BIG_END_CHAR_OFF))) // Interrupt enable
#define FRAME_NUM1_REG          (*((volatile unsigned char *) (0x52000170 + BIG_END_CHAR_OFF))) // Frame number lower byte
#define FRAME_NUM2_REG          (*((volatile unsigned char *) (0x52000174 + BIG_END_CHAR_OFF))) // Frame number higher byte
#define INDEX_REG               (*((volatile unsigned char *) (0x52000178 + BIG_END_CHAR_OFF))) // Register index
#define MAXP_REG                (*((volatile unsigned char *) (0x52000180 + BIG_END_CHAR_OFF))) // Endpoint max packet
#define EP0_CSR                 (*((volatile unsigned char *) (0x52000184 + BIG_END_CHAR_OFF))) // Endpoint 0 status
#define IN_CSR1_REG             (*((volatile unsigned char *) (0x52000184 + BIG_END_CHAR_OFF))) // In endpoint control status
#define IN_CSR2_REG             (*((volatile unsigned char *) (0x52000188 + BIG_END_CHAR_OFF))) // In endpoint control status
#define OUT_CSR1_REG            (*((volatile unsigned char *) (0x52000190 + BIG_END_CHAR_OFF))) // Out endpoint control status
#define OUT_CSR2_REG            (*((volatile unsigned char *) (0x52000194 + BIG_END_CHAR_OFF))) // Out endpoint control status
#define OUT_FIFO_CNT1_REG       (*((volatile unsigned char *) (0x52000198 + BIG_END_CHAR_OFF))) // Endpoint out write count
#define OUT_FIFO_CNT2_REG       (*((volatile unsigned char *) (0x5200019c + BIG_END_CHAR_OFF))) // Endpoint out write count
#define EP0_FIFO                (*((volatile unsigned char *) (0x520001c0 + BIG_END_CHAR_OFF))) // Endpoint 0 FIFO
#define EP1_FIFO                (*((volatile unsigned char *) (0x520001c4 + BIG_END_CHAR_OFF))) // Endpoint 1 FIFO
#define EP2_FIFO                (*((volatile unsigned char *) (0x520001c8 + BIG_END_CHAR_OFF))) // Endpoint 2 FIFO
#define EP3_FIFO                (*((volatile unsigned char *) (0x520001cc + BIG_END_CHAR_OFF))) // Endpoint 3 FIFO
#define EP4_FIFO                (*((volatile unsigned char *) (0x520001d0 + BIG_END_CHAR_OFF))) // Endpoint 4 FIFO
#define EP1_DMA_CON             (*((volatile unsigned char *) (0x52000200 + BIG_END_CHAR_OFF))) // EP1 DMA interface control
#define EP1_DMA_UNIT            (*((volatile unsigned char *) (0x52000204 + BIG_END_CHAR_OFF))) // EP1 DMA Tx unit counter
#define EP1_DMA_FIFO            (*((volatile unsigned char *) (0x52000208 + BIG_END_CHAR_OFF))) // EP1 DMA Tx FIFO counter
#define EP1_DMA_TTC_L           (*((volatile unsigned char *) (0x5200020c + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_M           (*((volatile unsigned char *) (0x52000210 + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP1_DMA_TTC_H           (*((volatile unsigned char *) (0x52000214 + BIG_END_CHAR_OFF))) // EP1 DMA total Tx counter
#define EP2_DMA_CON             (*((volatile unsigned char *) (0x52000218 + BIG_END_CHAR_OFF))) // EP2 DMA interface control
#define EP2_DMA_UNIT            (*((volatile unsigned char *) (0x5200021c + BIG_END_CHAR_OFF))) // EP2 DMA Tx unit counter
#define EP2_DMA_FIFO            (*((volatile unsigned char *) (0x52000220 + BIG_END_CHAR_OFF))) // EP2 DMA Tx FIFO counter
#define EP2_DMA_TTC_L           (*((volatile unsigned char *) (0x52000224 + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_M           (*((volatile unsigned char *) (0x52000228 + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP2_DMA_TTC_H           (*((volatile unsigned char *) (0x5200022c + BIG_END_CHAR_OFF))) // EP2 DMA total Tx counter
#define EP3_DMA_CON             (*((volatile unsigned char *) (0x52000240 + BIG_END_CHAR_OFF))) // EP3 DMA interface control
#define EP3_DMA_UNIT            (*((volatile unsigned char *) (0x52000244 + BIG_END_CHAR_OFF))) // EP3 DMA Tx unit counter
#define EP3_DMA_FIFO            (*((volatile unsigned char *) (0x52000248 + BIG_END_CHAR_OFF))) // EP3 DMA Tx FIFO counter
#define EP3_DMA_TTC_L           (*((volatile unsigned char *) (0x5200024c + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_M           (*((volatile unsigned char *) (0x52000250 + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP3_DMA_TTC_H           (*((volatile unsigned char *) (0x52000254 + BIG_END_CHAR_OFF))) // EP3 DMA total Tx counter
#define EP4_DMA_CON             (*((volatile unsigned char *) (0x52000258 + BIG_END_CHAR_OFF))) // EP4 DMA interface control
#define EP4_DMA_UNIT            (*((volatile unsigned char *) (0x5200025c + BIG_END_CHAR_OFF))) // EP4 DMA Tx unit counter
#define EP4_DMA_FIFO            (*((volatile unsigned char *) (0x52000260 + BIG_END_CHAR_OFF))) // EP4 DMA Tx FIFO counter
#define EP4_DMA_TTC_L           (*((volatile unsigned char *) (0x52000264 + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_M           (*((volatile unsigned char *) (0x52000268 + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter
#define EP4_DMA_TTC_H           (*((volatile unsigned char *) (0x5200026c + BIG_END_CHAR_OFF))) // EP4 DMA total Tx counter


/*
** Watchdog Timer
*/

#define WTCON                   (*((volatile unsigned int  *) 0x53000000)) // Watch-dog timer mode
#define WTDAT                   (*((volatile unsigned int  *) 0x53000004)) // Watch-dog timer data
#define WTCNT                   (*((volatile unsigned int  *) 0x53000008)) // Eatch-dog timer count


/*
** IIC
*/

#define IICCON                  (*((volatile unsigned int  *) 0x54000000)) // IIC Control
#define IICSTAT                 (*((volatile unsigned int  *) 0x54000004)) // IIC Status
#define IICADD                  (*((volatile unsigned int  *) 0x54000008)) // IIC Address
#define IICDS                   (*((volatile unsigned int  *) 0x5400000c)) // IIC Data Shift
#define IICLC                   (*((volatile unsigned int  *) 0x54000010)) // IIC multi-master line control


/*
** IIS
*/

#define IISCON                  (*((volatile unsigned int  *) 0x55000000)) //IIS Control
#define IISMOD                  (*((volatile unsigned int  *) 0x55000004)) //IIS Mode
#define IISFIC                  (*((volatile unsigned int  *) 0x55000008)) //IIS FIFO control
#define IISPSR                  (*((volatile unsigned int  *) 0x5500000c)) //IIS Prescaler
#define IISTXD                  (*((volatile unsigned int  *) 0x55000010)) //IIS Transmit data
#define IISRXD                  (*((volatile unsigned int  *) 0x55000014)) //IIS Receive data


/*
** I/O Port
*/

#define GPACON                  (*((volatile unsigned int  *) 0x56000000)) // Port A control
#define GPADAT                  (*((volatile unsigned int  *) 0x56000004)) // Port A data
                        
#define GPBCON                  (*((volatile unsigned int  *) 0x56000010)) // Port B control
#define GPBDAT                  (*((volatile unsigned int  *) 0x56000014)) // Port B data
#define GPBDN                   (*((volatile unsigned int  *) 0x56000018)) // Pull-down control B
#define GPBSLPCON               (*((volatile unsigned int  *) 0x5600001c)) // Port B sleep mode configuration
                        
#define GPCCON                  (*((volatile unsigned int  *) 0x56000020)) // Port C control
#define GPCDAT                  (*((volatile unsigned int  *) 0x56000024)) // Port C data
#define GPCDN                   (*((volatile unsigned int  *) 0x56000028)) // Pull-down control C
#define GPCSLPCON               (*((volatile unsigned int  *) 0x5600002c)) // Port C sleep mode configuration
                        
#define GPDCON                  (*((volatile unsigned int  *) 0x56000030)) // Port D control
#define GPDDAT                  (*((volatile unsigned int  *) 0x56000034)) // Port D data
#define GPDDN                   (*((volatile unsigned int  *) 0x56000038)) // Pull-down control D
#define GPDSLPCON               (*((volatile unsigned int  *) 0x5600003c)) // Port D sleep mode configuration
                        
#define GPECON                  (*((volatile unsigned int  *) 0x56000040)) // Port E control
#define GPEDAT                  (*((volatile unsigned int  *) 0x56000044)) // Port E data
#define GPEDN                   (*((volatile unsigned int  *) 0x56000048)) // Pull-down control E
#define GPESLPCON               (*((volatile unsigned int  *) 0x5600004c)) // Port E sleep mode configuration
                        
#define GPFCON                  (*((volatile unsigned int  *) 0x56000050)) // Port F control
#define GPFDAT                  (*((volatile unsigned int  *) 0x56000054)) // Port F data
#define GPFDN                   (*((volatile unsigned int  *) 0x56000058)) // Pull-down control F
                        
#define GPGCON                  (*((volatile unsigned int  *) 0x56000060)) // Port G control
#define GPGDAT                  (*((volatile unsigned int  *) 0x56000064)) // Port G data
#define GPGDN                   (*((volatile unsigned int  *) 0x56000068)) // Pull-down control G
#define GPGSLPCON               (*((volatile unsigned int  *) 0x5600006c)) // Port G sleep mode configuration
                        
#define GPHCON                  (*((volatile unsigned int  *) 0x56000070)) // Port H control
#define GPHDAT                  (*((volatile unsigned int  *) 0x56000074)) // Port H data
#define GPHDN                   (*((volatile unsigned int  *) 0x56000078)) // Pull-down control H
#define GPHSLPCON               (*((volatile unsigned int  *) 0x5600007c)) // Port H sleep mode configuration
                        
#define MISCCR                  (*((volatile unsigned int  *) 0x56000080)) // Miscellaneous control
#define DCLKCON                 (*((volatile unsigned int  *) 0x56000084)) // DCLK0/1 control
#define EXTINT0                 (*((volatile unsigned int  *) 0x56000088)) // External interrupt control register 0
#define EXTINT1                 (*((volatile unsigned int  *) 0x5600008c)) // External interrupt control register 1
#define EXTINT2                 (*((volatile unsigned int  *) 0x56000090)) // External interrupt control register 2
#define EINTFLT0                (*((volatile unsigned int  *) 0x56000094)) // Reserved
#define EINTFLT1                (*((volatile unsigned int  *) 0x56000098)) // Reserved
#define EINTFLT2                (*((volatile unsigned int  *) 0x5600009c)) // External interrupt filter control register 2
#define EINTFLT3                (*((volatile unsigned int  *) 0x560000a0)) // External interrupt filter control register 3
#define EINTMASK                (*((volatile unsigned int  *) 0x560000a4)) // External interrupt mask
#define EINTPEND                (*((volatile unsigned int  *) 0x560000a8)) // External interrupt pending
#define GSTATUS0                (*((volatile unsigned int  *) 0x560000ac)) // External pin status
#define GSTATUS1                (*((volatile unsigned int  *) 0x560000b0)) // Chip ID
#define GSTATUS2                (*((volatile unsigned int  *) 0x560000b4)) // Reset type
#define GSTATUS3                (*((volatile unsigned int  *) 0x560000b8)) // Saved data0(32-bit) before entering POWER_OFF mode 
#define GSTATUS4                (*((volatile unsigned int  *) 0x560000bc)) // Saved data0(32-bit) before entering POWER_OFF mode

#define MSTCON                  (*((volatile unsigned int  *) 0x560000d4)) // Memory port Stop control
#define MSLCON                  (*((volatile unsigned int  *) 0x560000d8)) // Memory port Sleep control
#define DSC0                    (*((volatile unsigned int  *) 0x560000dc)) // Strength control 0
#define DSC1                    (*((volatile unsigned int  *) 0x560000e0)) // Strength control 0


/*
** RTC
*/

#define RTCCON                  (*((volatile unsigned char *) (0x57000040 + BIG_END_CHAR_OFF))) // RTC control
#define TICNT                   (*((volatile unsigned char *) (0x57000044 + BIG_END_CHAR_OFF))) // Tick time count
#define RTCALM                  (*((volatile unsigned char *) (0x57000050 + BIG_END_CHAR_OFF))) // RTC alarm control
#define ALMSEC                  (*((volatile unsigned char *) (0x57000054 + BIG_END_CHAR_OFF))) // Alarm second
#define ALMMIN                  (*((volatile unsigned char *) (0x57000058 + BIG_END_CHAR_OFF))) // Alarm minute
#define ALMHOUR                 (*((volatile unsigned char *) (0x5700005c + BIG_END_CHAR_OFF))) // Alarm Hour
#define ALMDATE                 (*((volatile unsigned char *) (0x57000060 + BIG_END_CHAR_OFF))) // Alarm day
#define ALMMON                  (*((volatile unsigned char *) (0x57000064 + BIG_END_CHAR_OFF))) // Alarm month
#define ALMYEAR                 (*((volatile unsigned char *) (0x57000068 + BIG_END_CHAR_OFF))) // Alarm year
#define RTCRST                  (*((volatile unsigned char *) (0x5700006c + BIG_END_CHAR_OFF))) // RTC round reset
#define BCDSEC                  (*((volatile unsigned char *) (0x57000070 + BIG_END_CHAR_OFF))) // BCD second
#define BCDMIN                  (*((volatile unsigned char *) (0x57000074 + BIG_END_CHAR_OFF))) // BCD minute
#define BCDHOUR                 (*((volatile unsigned char *) (0x57000078 + BIG_END_CHAR_OFF))) // BCD hour
#define BCDDATE                 (*((volatile unsigned char *) (0x5700007c + BIG_END_CHAR_OFF))) // BCD day
#define BCDDAY                  (*((volatile unsigned char *) (0x57000080 + BIG_END_CHAR_OFF))) // BCD date
#define BCDMON                  (*((volatile unsigned char *) (0x57000084 + BIG_END_CHAR_OFF))) // BCD month
#define BCDYEAR                 (*((volatile unsigned char *) (0x57000088 + BIG_END_CHAR_OFF))) // BCD year


/*
** A/D Converter
*/

#define ADCCON                  (*((volatile unsigned int  *) 0x58000000)) // ADC control
#define ADCTSC                  (*((volatile unsigned int  *) 0x58000004)) // ADC touch screen control
#define ADCDLY                  (*((volatile unsigned int  *) 0x58000008)) // ADC start or Interval Delay
#define ADCDAT0                 (*((volatile unsigned int  *) 0x5800000c)) // ADC conversion data 0
#define ADCDAT1                 (*((volatile unsigned int  *) 0x58000010)) // ADC conversion data 1                   
                        

/*
** SPI
*/

#define SPCON0                  (*((volatile unsigned int  *) 0x59000000)) // SPI Control
#define SPSTA0                  (*((volatile unsigned int  *) 0x59000004)) // SPI Status
#define SPPIN0                  (*((volatile unsigned int  *) 0x59000008)) // SPI Pin Control
#define SPPRE0                  (*((volatile unsigned int  *) 0x5900000c)) // SPI Baud Rate Prescaler
#define SPTDAT0                 (*((volatile unsigned int  *) 0x59000010)) // SPI Tx Data
#define SPRDAT0                 (*((volatile unsigned int  *) 0x59000014)) // SPI Rx Data
#define SPTXFIFO0               (*((volatile unsigned int  *) 0x59000018)) // SPI Tx FIFO
#define SPRXFIFO0               (*((volatile unsigned int  *) 0x5900001c)) // SPI Rx FIFO
#define SPRDATB0                (*((volatile unsigned int  *) 0x59000020)) // SPI Rx Data
#define SPFIC0                  (*((volatile unsigned int  *) 0x59000024)) // SPI FIFO interrupt and DMA control

#define SPCON1                  (*((volatile unsigned int  *) 0x59000100)) // SPI Control
#define SPSTA1                  (*((volatile unsigned int  *) 0x59000104)) // SPI Status
#define SPPIN1                  (*((volatile unsigned int  *) 0x59000108)) // SPI Pin Control
#define SPPRE1                  (*((volatile unsigned int  *) 0x5900010c)) // SPI Baud Rate Prescaler
#define SPTDAT1                 (*((volatile unsigned int  *) 0x59000110)) // SPI Tx Data
#define SPRDAT1                 (*((volatile unsigned int  *) 0x59000114)) // SPI Rx Data
#define SPTXFIFO1               (*((volatile unsigned int  *) 0x59000118)) // SPI Tx FIFO
#define SPRXFIFO1               (*((volatile unsigned int  *) 0x5900011c)) // SPI Rx FIFO
#define SPRDATB1                (*((volatile unsigned int  *) 0x5900012 )) // PI Rx Data
#define SPFIC1                  (*((volatile unsigned int  *) 0x59000124)) // SPI FIFO interrupt and DMA control


/*
** SD Interface
*/

#define SDICON                  (*((volatile unsigned int  *) 0x5a000000)) // SDI control
#define SDIPRE                  (*((volatile unsigned int  *) 0x5a000004)) // SDI baud rate prescaler
#define SDICARG                 (*((volatile unsigned int  *) 0x5a000008)) // SDI command argument
#define SDICCON                 (*((volatile unsigned int  *) 0x5a00000c)) // SDI command control
#define SDICSTA                 (*((volatile unsigned int  *) 0x5a000010)) // SDI command status
#define SDIRSP0                 (*((volatile unsigned int  *) 0x5a000014)) // SDI response 0
#define SDIRSP1                 (*((volatile unsigned int  *) 0x5a000018)) // SDI response 1
#define SDIRSP2                 (*((volatile unsigned int  *) 0x5a00001c)) // SDI response 2
#define SDIRSP3                 (*((volatile unsigned int  *) 0x5a000020)) // SDI response 3
#define SDIDTIMER               (*((volatile unsigned int  *) 0x5a000024)) // SDI data/busy timer
#define SDIBSIZE                (*((volatile unsigned int  *) 0x5a000028)) // SDI block size
#define SDIDCON                 (*((volatile unsigned int  *) 0x5a00002c)) // SDI data control
#define SDIDCNT                 (*((volatile unsigned int  *) 0x5a000030)) // SDI data remain counter
#define SDIDSTA                 (*((volatile unsigned int  *) 0x5a000034)) // SDI data status
#define SDIFSTA                 (*((volatile unsigned int  *) 0x5a000038)) // SDI FIFO status
#define SDIIMSK                 (*((volatile unsigned int  *) 0x5a00003c)) // SDI interrupt mask
#define SDIDAT                  (*((volatile unsigned char *)(0x5a000040 + BIG_END_CHAR_OFF))) // SDI data


#endif   /* _S3C2412_H */
