/**************************************************************************
**                                                                        *
**  FILE        :  sja2020.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**                 SJA2020			                          *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _SJA2020_H
#define _SJA2020_H

/**************************************************************************
**                                                                        *
** Memory region 0 to 6							  *
**                                                                        *
**************************************************************************/

/*
** FMC embedded flash controller configuration registers
*/

#define EIC_BASE 0x20200000

#define EIC_FCTR            	(*((volatile unsigned int  *) (EIC_BASE + 0x000)))	/* R/W control register */
#define EIC_FPTR            	(*((volatile unsigned int  *) (EIC_BASE + 0x008)))	/* R/W program time register */
#define EIC_FBWST           	(*((volatile unsigned int  *) (EIC_BASE + 0x010)))	/* R/W bridge wait state register */
#define EIC_FCRA            	(*((volatile unsigned int  *) (EIC_BASE + 0x01C)))	/* R/W clock divider register */
#define EIC_FMSSTART        	(*((volatile unsigned int  *) (EIC_BASE + 0x020)))	/* R/W BIST start address register */
#define EIC_FMSSTOP         	(*((volatile unsigned int  *) (EIC_BASE + 0x024)))	/* R/W BIST stop address register */
#define EIC_FMSW0           	(*((volatile unsigned int  *) (EIC_BASE + 0x02C)))	/* R   128-bit signature word 0 register */
#define EIC_FMSW1           	(*((volatile unsigned int  *) (EIC_BASE + 0x030)))	/* R   128-bit signature word 1 register */
#define EIC_FMSW2           	(*((volatile unsigned int  *) (EIC_BASE + 0x034)))	/* R   128-bit signature word 2 register */
#define EIC_FMSW3           	(*((volatile unsigned int  *) (EIC_BASE + 0x038)))	/* R   128-bit signature word 3 register */
#define EIC_INT_CLR_ENABLE	(*((volatile unsigned int  *) (EIC_BASE + 0xFD8)))	/* W   clear interrupt enable register */
#define EIC_INT_SET_ENABLE	(*((volatile unsigned int  *) (EIC_BASE + 0xFDC)))	/* W   set interrupt enable register */
#define EIC_INT_STATUS		(*((volatile unsigned int  *) (EIC_BASE + 0xFE0)))	/* R   interrupt status register */
#define EIC_INT_ENABLE		(*((volatile unsigned int  *) (EIC_BASE + 0xFE4)))	/* R   interrupt enable register */
#define EIC_INT_CLR_STATUS	(*((volatile unsigned int  *) (EIC_BASE + 0xFE8)))	/* W   clear interrupt status register */
#define EIC_INT_SET_STATUS	(*((volatile unsigned int  *) (EIC_BASE + 0xFEC)))	/* W   set interrupt status register */


/*
** SMC Static Memory Controller configuration registers
*/

#define SMC_BASE 0xBFFFF000

#define SMC_SMBIDCYR0       	(*((volatile unsigned int  *) (SMC_BASE + 0x000)))	/* R/W idle cycle control register for memory bank 0 */
#define SMC_SMBWST1R0       	(*((volatile unsigned int  *) (SMC_BASE + 0x004)))	/* R/W wait state 1 control register for memory bank 0 */
#define SMC_SMBWST2R0       	(*((volatile unsigned int  *) (SMC_BASE + 0x008)))	/* R/W wait state 2 control register for memory bank 0 */
#define SMC_SMBWSTOENR0     	(*((volatile unsigned int  *) (SMC_BASE + 0x00C)))	/* R/W output enable assertion delay control register for memory bank 0 */
#define SMC_SMBWSTWENR0     	(*((volatile unsigned int  *) (SMC_BASE + 0x010)))	/* R/W write enable assertion delay control register for memory bank 0 */
#define SMC_SMBCR0          	(*((volatile unsigned int  *) (SMC_BASE + 0x014)))	/* R/W configuration register for memory bank 0 */
#define SMC_SMBSR0          	(*((volatile unsigned int  *) (SMC_BASE + 0x018)))	/* R/W status register for memory bank 0 */

#define SMC_SMBIDCYR1       	(*((volatile unsigned int  *) (SMC_BASE + 0x01C)))	/* R/W idle cycle control register for memory bank 1 */
#define SMC_SMBWST1R1       	(*((volatile unsigned int  *) (SMC_BASE + 0x020)))	/* R/W wait state 1 control register for memory bank 1 */
#define SMC_SMBWST2R1       	(*((volatile unsigned int  *) (SMC_BASE + 0x024)))	/* R/W wait state 2 control register for memory bank 1 */
#define SMC_SMBWSTOENR1     	(*((volatile unsigned int  *) (SMC_BASE + 0x028)))	/* R/W output enable assertion delay control register for memory bank 1 */
#define SMC_SMBWSTWENR1     	(*((volatile unsigned int  *) (SMC_BASE + 0x02C)))	/* R/W write enable assertion delay control register for memory bank 1 */
#define SMC_SMBCR1          	(*((volatile unsigned int  *) (SMC_BASE + 0x030)))	/* R/W configuration register for memory bank 1 */
#define SMC_SMBSR1          	(*((volatile unsigned int  *) (SMC_BASE + 0x034)))	/* R/W status register for memory bank 1 */

#define SMC_SMBIDCYR2       	(*((volatile unsigned int  *) (SMC_BASE + 0x038)))	/* R/W idle cycle control register for memory bank 2 */
#define SMC_SMBWST1R2       	(*((volatile unsigned int  *) (SMC_BASE + 0x03C)))	/* R/W wait state 1 control register for memory bank 2 */
#define SMC_SMBWST2R2       	(*((volatile unsigned int  *) (SMC_BASE + 0x040)))	/* R/W wait state 2 control register for memory bank 2 */
#define SMC_SMBWSTOENR2     	(*((volatile unsigned int  *) (SMC_BASE + 0x044)))	/* R/W output enable assertion delay control register for memory bank 2 */
#define SMC_SMBWSTWENR2     	(*((volatile unsigned int  *) (SMC_BASE + 0x048)))	/* R/W write enable assertion delay control register for memory bank 2 */
#define SMC_SMBCR2          	(*((volatile unsigned int  *) (SMC_BASE + 0x04C)))	/* R/W configuration register for memory bank 2 */
#define SMC_SMBSR2          	(*((volatile unsigned int  *) (SMC_BASE + 0x050)))	/* R/W status register for memory bank 2 */

#define SMC_SMBIDCYR3       	(*((volatile unsigned int  *) (SMC_BASE + 0x054)))	/* R/W idle cycle control register for memory bank 3 */
#define SMC_SMBWST1R3       	(*((volatile unsigned int  *) (SMC_BASE + 0x058)))	/* R/W wait state 1 control register for memory bank 3 */
#define SMC_SMBWST2R3       	(*((volatile unsigned int  *) (SMC_BASE + 0x05C)))	/* R/W wait state 2 control register for memory bank 3 */
#define SMC_SMBWSTOENR3     	(*((volatile unsigned int  *) (SMC_BASE + 0x060)))	/* R/W output enable assertion delay control register for memory bank 3 */
#define SMC_SMBWSTWENR3     	(*((volatile unsigned int  *) (SMC_BASE + 0x064)))	/* R/W write enable assertion delay control register for memory bank 3 */
#define SMC_SMBCR3          	(*((volatile unsigned int  *) (SMC_BASE + 0x068)))	/* R/W configuration register for memory bank 3 */
#define SMC_SMBSR3          	(*((volatile unsigned int  *) (SMC_BASE + 0x06C)))	/* R/W status register for memory bank 3 */


/**************************************************************************
**                                                                        *
** VPB cluster 0: general subsystem					  *
**                                                                        *
**************************************************************************/

/*
** CGU Clock Generation Unit
*/

#define CGU_BASE 0xE0000000

#define CGU_CSC             	(*((volatile unsigned int  *) (CGU_BASE + 0x000)))	/* R/W clock switch configuration register */
#define CGU_CFS1            	(*((volatile unsigned int  *) (CGU_BASE + 0x004)))	/* R/W clock frequency select 1 register */
#define CGU_CFS2            	(*((volatile unsigned int  *) (CGU_BASE + 0x008)))	/* R/W clock frequency select 2 register */
#define CGU_CSS             	(*((volatile unsigned int  *) (CGU_BASE + 0x00C)))	/* R   clock switch status register */
#define CGU_CPC0            	(*((volatile unsigned int  *) (CGU_BASE + 0x010)))	/* R/W AHB clock power control register */
#define CGU_CPC1            	(*((volatile unsigned int  *) (CGU_BASE + 0x014)))	/* R/W flash clock power control register */
#define CGU_CPC2            	(*((volatile unsigned int  *) (CGU_BASE + 0x018)))	/* R/W general and peripheral subsystem clock power control register */
#define CGU_CPC3            	(*((volatile unsigned int  *) (CGU_BASE + 0x01C)))	/* R/W in-vehicle networking subsystem clock power control register */
#define CGU_CPC4            	(*((volatile unsigned int  *) (CGU_BASE + 0x020)))	/* R/W ADC clock power control register */
#define CGU_AHB             	(*((volatile unsigned int  *) (CGU_BASE + 0x028)))	/* R   clock power status register */
#define CGU_CPS0            	(*((volatile unsigned int  *) (CGU_BASE + 0x02C)))	/* R   CPS1 flash clock power status register */
#define CGU_CPS2            	(*((volatile unsigned int  *) (CGU_BASE + 0x030)))	/* R   general and peripheral subsystem clock power status register */
#define CGU_CPS3            	(*((volatile unsigned int  *) (CGU_BASE + 0x034)))	/* R   in-vehicle networking subsystem clock power status register */
#define CGU_CPS4            	(*((volatile unsigned int  *) (CGU_BASE + 0x038)))	/* R   ADC clock power status register */
#define CGU_CFCE4           	(*((volatile unsigned int  *) (CGU_BASE + 0x050)))	/* R/W ADC fractional clock enable register */
#define CGU_CFD             	(*((volatile unsigned int  *) (CGU_BASE + 0x058)))	/* R/W fractional clock divider register */
#define CGU_CPM             	(*((volatile unsigned int  *) (CGU_BASE + 0xC00)))	/* R/W power mode register */
#define CGU_CWDB            	(*((volatile unsigned int  *) (CGU_BASE + 0xC04)))	/* R   watchdog bark register */
#define CGU_CRTCOPM         	(*((volatile unsigned int  *) (CGU_BASE + 0xC08)))	/* R/W real time clock oscillator power mode register */
#define CGU_COPM            	(*((volatile unsigned int  *) (CGU_BASE + 0xC10)))	/* R/W oscillator power mode register */
#define CGU_COLS            	(*((volatile unsigned int  *) (CGU_BASE + 0xC18)))	/* R   oscillator lock status register */
#define CGU_CPCSS           	(*((volatile unsigned int  *) (CGU_BASE + 0xC40)))	/* R/W PLL clock source select register */
#define CGU_CPPDM           	(*((volatile unsigned int  *) (CGU_BASE + 0xC44)))	/* R/W PLL Power-down mode register */
#define CGU_CPLS            	(*((volatile unsigned int  *) (CGU_BASE + 0xC4C)))	/* R   PLL lock status register */
#define CGU_CPMR            	(*((volatile unsigned int  *) (CGU_BASE + 0xC54)))	/* R/W PLL multiplication ratio register */
#define CGU_CPPD            	(*((volatile unsigned int  *) (CGU_BASE + 0xC58)))	/* R/W PLL post divider register */
#define CGU_CRPM            	(*((volatile unsigned int  *) (CGU_BASE + 0xC5C)))	/* R/W ring oscillator power mode register */
#define CGU_CRPD            	(*((volatile unsigned int  *) (CGU_BASE + 0xC60)))	/* R/W ring oscillator post divider register */
#define CGU_CRFS            	(*((volatile unsigned int  *) (CGU_BASE + 0xC64)))	/* R/W ring oscillator frequency select register */


/*
** SCU System Control Unit
*/

#define SCU_BASE 0xE0001000

#define SCU_SSMM            	(*((volatile unsigned int  *) (SCU_BASE + 0x00)))	/* R/W shadow memory mapping register */
#define SCU_SFSAP0          	(*((volatile unsigned int  *) (SCU_BASE + 0x04)))	/* R/W function select A port 0 register */
#define SCU_SFSBP0          	(*((volatile unsigned int  *) (SCU_BASE + 0x08)))	/* R/W function select B port 0 register */
#define SCU_SFSAP1          	(*((volatile unsigned int  *) (SCU_BASE + 0x0C)))	/* R/W function select A port 1 register */
#define SCU_SFSBP1          	(*((volatile unsigned int  *) (SCU_BASE + 0x10)))	/* R/W function select B port 1 register */
#define SCU_SFSAP2          	(*((volatile unsigned int  *) (SCU_BASE + 0x14)))	/* R/W function select A port 2 register */
#define SCU_SFSBP2          	(*((volatile unsigned int  *) (SCU_BASE + 0x18)))	/* R/W function select B port 2 register */
#define SCU_SPUCP0          	(*((volatile unsigned int  *) (SCU_BASE + 0x1C)))	/* R/W pull-up control port 0 register */
#define SCU_SPUCP1          	(*((volatile unsigned int  *) (SCU_BASE + 0x20)))	/* R/W pull-up control port 1 register */
#define SCU_SPUCP2          	(*((volatile unsigned int  *) (SCU_BASE + 0x24)))	/* R/W pull-up control port 2 register */


/*
** SSP0 Synchronous Serial Port controller 0
*/

#define SSP0_BASE 0xE0002000

#define SSP0_CR0         	(*((volatile unsigned int  *) (SSP0_BASE + 0x00)))	/* R/W control register 0 */
#define SSP0_CR1         	(*((volatile unsigned int  *) (SSP0_BASE + 0x04)))	/* R/W control register 1 */
#define SSP0_DR          	(*((volatile unsigned int  *) (SSP0_BASE + 0x08)))	/* R/W FIFO data register */
#define SSP0_SR          	(*((volatile unsigned int  *) (SSP0_BASE + 0x0C)))	/* R   status register */
#define SSP0_CPSR        	(*((volatile unsigned int  *) (SSP0_BASE + 0x10)))	/* R/W clock prescale register */
#define SSP0_IMSC        	(*((volatile unsigned int  *) (SSP0_BASE + 0x14)))	/* R/W interrupt enable register */
#define SSP0_RIS         	(*((volatile unsigned int  *) (SSP0_BASE + 0x18)))	/* R   raw interrupt status register */
#define SSP0_MIS         	(*((volatile unsigned int  *) (SSP0_BASE + 0x1C)))	/* R   masked interrupt status register */
#define SSP0_ICR         	(*((volatile unsigned int  *) (SSP0_BASE + 0x20)))	/* W   interrupt clear register */


/*
** SSP1 Synchronous Serial Port controller 1
*/

#define SSP1_BASE 0xE0003000

#define SSP1_CR0         	(*((volatile unsigned int  *) (SSP1_BASE + 0x00)))	/* R/W control register O */
#define SSP1_CR1         	(*((volatile unsigned int  *) (SSP1_BASE + 0x04)))	/* R/W control register 1 */
#define SSP1_DR          	(*((volatile unsigned int  *) (SSP1_BASE + 0x08)))	/* R/W FIFO data register */
#define SSP1_SR          	(*((volatile unsigned int  *) (SSP1_BASE + 0x0C)))	/* R   status register */
#define SSP1_CPSR        	(*((volatile unsigned int  *) (SSP1_BASE + 0x10)))	/* R/W clock prescale register */
#define SSP1_IMSC        	(*((volatile unsigned int  *) (SSP1_BASE + 0x14)))	/* R/W interrupt enable register */
#define SSP1_RIS         	(*((volatile unsigned int  *) (SSP1_BASE + 0x18)))	/* R   raw interrupt status register */
#define SSP1_MIS         	(*((volatile unsigned int  *) (SSP1_BASE + 0x1C)))	/* R   masked interrupt status register */
#define SSP1_ICR         	(*((volatile unsigned int  *) (SSP1_BASE + 0x20)))	/* W   interrupt clear register */


/*
** SSP2 Synchronous Serial Port controller 2
*/

#define SSP2_BASE 0xE0004000

#define SSP2_CR0         	(*((volatile unsigned int  *) (SSP2_BASE + 0x00)))	/* R/W control register 0 */
#define SSP2_CR1         	(*((volatile unsigned int  *) (SSP2_BASE + 0x04)))	/* R/W control register 1 */
#define SSP2_DR          	(*((volatile unsigned int  *) (SSP2_BASE + 0x08)))	/* R/W FIFO data register */
#define SSP2_SR          	(*((volatile unsigned int  *) (SSP2_BASE + 0x0C)))	/* R   status register */
#define SSP2_CPSR        	(*((volatile unsigned int  *) (SSP2_BASE + 0x10)))	/* R/W clock prescale register */
#define SSP2_IMSC        	(*((volatile unsigned int  *) (SSP2_BASE + 0x14)))	/* R/W interrupt enable register */
#define SSP2_RIS         	(*((volatile unsigned int  *) (SSP2_BASE + 0x18)))	/* R   raw interrupt status register */
#define SSP2_MIS         	(*((volatile unsigned int  *) (SSP2_BASE + 0x1C)))	/* R   masked interrupt status register */
#define SSP2_ICR         	(*((volatile unsigned int  *) (SSP2_BASE + 0x20)))	/* W   interrupt clear register */


/*
** ADC Analog/Digital Converter
*/

#define ADC_BASE 0xE0005000

#define ADC_ACD0            	(*((volatile unsigned int  *) (ADC_BASE + 0x00)))	/* R   channel 0 conversion data register */
#define ADC_ACD1            	(*((volatile unsigned int  *) (ADC_BASE + 0x04)))	/* R   channel 1 conversion data register */
#define ADC_ACD2            	(*((volatile unsigned int  *) (ADC_BASE + 0x08)))	/* R   channel 2 conversion data register */
#define ADC_ACD3            	(*((volatile unsigned int  *) (ADC_BASE + 0x0C)))	/* R   channel 3 conversion data register */
#define ADC_ACD4            	(*((volatile unsigned int  *) (ADC_BASE + 0x10)))	/* R   channel 4 conversion data register */
#define ADC_ACD5            	(*((volatile unsigned int  *) (ADC_BASE + 0x14)))	/* R   channel 5 conversion data register */
#define ADC_ACD6            	(*((volatile unsigned int  *) (ADC_BASE + 0x18)))	/* R   channel 6 conversion data register */
#define ADC_ACD7            	(*((volatile unsigned int  *) (ADC_BASE + 0x1C)))	/* R   channel 7 conversion data register */
#define ADC_ACON            	(*((volatile unsigned int  *) (ADC_BASE + 0x20)))	/* R/W control register */
#define ADC_ACC             	(*((volatile unsigned int  *) (ADC_BASE + 0x24)))	/* R/W channel configuration register */
#define ADC_AIE             	(*((volatile unsigned int  *) (ADC_BASE + 0x28)))	/* R/W interrupt enable register */
#define ADC_AIS             	(*((volatile unsigned int  *) (ADC_BASE + 0x2C)))	/* R   interrupt status register */
#define ADC_AIC             	(*((volatile unsigned int  *) (ADC_BASE + 0x30)))	/* W   interrupt clear register */


/*
** WD Watchdog
*/

#define WD_BASE 0xE0006000

#define WD_WDMOD            	(*((volatile unsigned int  *) (WD_BASE + 0x00)))	/* R/W mode register */
#define WD_WDRV             	(*((volatile unsigned int  *) (WD_BASE + 0x04)))	/* R/W timer reload value */
#define WD_WDCV             	(*((volatile unsigned int  *) (WD_BASE + 0x08)))	/* R/W timer counter value */
#define WD_WDTRIG           	(*((volatile unsigned int  *) (WD_BASE + 0x0C)))	/* W   trigger */
#define WD_WDISS            	(*((volatile unsigned int  *) (WD_BASE + 0x10)))	/* W   interrupt set status */
#define WD_WDICS            	(*((volatile unsigned int  *) (WD_BASE + 0x14)))	/* W   interrupt clear status */
#define WD_WDIE             	(*((volatile unsigned int  *) (WD_BASE + 0x18)))	/* R   interrupt enable */
#define WD_WDIS             	(*((volatile unsigned int  *) (WD_BASE + 0x1C)))	/* R   interrupt status */
#define WD_WDISE            	(*((volatile unsigned int  *) (WD_BASE + 0x20)))	/* W   interrupt set enable */
#define WD_WDICE            	(*((volatile unsigned int  *) (WD_BASE + 0x24)))	/* W   interrupt clear enable */


/*
** ER Event Router
*/

#define ER_BASE 0xE0008000

#define ER_PEND             	(*((volatile unsigned int  *) (ER_BASE + 0xC00)))	/* R   event status register */
#define ER_INT_CLR          	(*((volatile unsigned int  *) (ER_BASE + 0xC20)))	/* W   event status clear register */
#define ER_INT_SET          	(*((volatile unsigned int  *) (ER_BASE + 0xC40)))	/* W   event status set register */
#define ER_MASK             	(*((volatile unsigned int  *) (ER_BASE + 0xC60)))	/* R   event enable register */
#define ER_MASK_CLR         	(*((volatile unsigned int  *) (ER_BASE + 0xC80)))	/* W   event enable clear register */
#define ER_MASK_SET         	(*((volatile unsigned int  *) (ER_BASE + 0xCA0)))	/* W   event enable set register */
#define ER_APR              	(*((volatile unsigned int  *) (ER_BASE + 0xCC0)))	/* R/W activation polarity register */
#define ER_ATR              	(*((volatile unsigned int  *) (ER_BASE + 0xCE0)))	/* R/W activation type register */
#define ER_RSR              	(*((volatile unsigned int  *) (ER_BASE + 0xD20)))	/* R/W raw status register */


/*
** RTC Real Time Clock
*/

#define RTC_BASE 0xE000A000

#define RTC_TIME_SECONDS    	(*((volatile unsigned int  *) (RTC_BASE + 0x000)))	/* R   elapsed time seconds register */
#define RTC_TIME_FRACTION	(*((volatile unsigned int  *) (RTC_BASE + 0x010)))	/* R   seconds fraction register */
#define RTC_PORTIME         	(*((volatile unsigned int  *) (RTC_BASE + 0x020)))	/* R/W real-time offset register */
#define RTC_CONTROL         	(*((volatile unsigned int  *) (RTC_BASE + 0xFC0)))	/* R/W real-time control register */


/**************************************************************************
**                                                                        *
** VPB cluster 1: not used						  *
**                                                                        *
**************************************************************************/


/**************************************************************************
**                                                                        *
** VPB cluster 2: peripheral subsystem					  *
**                                                                        *
**************************************************************************/

/*
** TIMERn Timer
*/

#define TIMER0_BASE 0xE0040000

#define TIMER0_IR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x00)))	/* R/W timer interrupt register */
#define TIMER0_TCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x04)))	/* R/W timer control register */
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x08)))	/* R/W timer counter value */
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x0C)))	/* R/W prescale register */
#define TIMER0_PC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x10)))	/* R/W prescale counter value */
#define TIMER0_MCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x14)))	/* R/W match control register */
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x18)))	/* R/W match register 0 */
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x1C)))	/* R/W match register 1 */
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x20)))	/* R/W match register 2 */
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x24)))	/* R/W match register 3 */
#define TIMER0_CCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x28)))	/* R/W capture control register */
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x2C)))	/* R   capture register 0 */
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x30)))	/* R   capture register 1 */
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x34)))	/* R   capture register 2 */
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x38)))	/* R   capture register 3 */
#define TIMER0_EMR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x3C)))	/* R/W external match register */

#define TIMER1_BASE 0xE0041000

#define TIMER1_IR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x00)))	/* R/W timer interrupt register */
#define TIMER1_TCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x04)))	/* R/W timer control register */
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x08)))	/* R/W timer counter value */
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x0C)))	/* R/W prescale register */
#define TIMER1_PC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x10)))	/* R/W prescale counter value */
#define TIMER1_MCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x14)))	/* R/W match control register */
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x18)))	/* R/W match register 0 */
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x1C)))	/* R/W match register 1 */
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x20)))	/* R/W match register 2 */
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x24)))	/* R/W match register 3 */
#define TIMER1_CCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x28)))	/* R/W capture control register */
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x2C)))	/* R   capture register 0 */
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x30)))	/* R   capture register 1 */
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x34)))	/* R   capture register 2 */
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x38)))	/* R   capture register 3 */
#define TIMER1_EMR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x3C)))	/* R/W external match register */

#define TIMER2_BASE 0xE0042000

#define TIMER2_IR           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x00)))	/* R/W timer interrupt register */
#define TIMER2_TCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x04)))	/* R/W timer control register */
#define TIMER2_TC           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x08)))	/* R/W timer counter value */
#define TIMER2_PR           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x0C)))	/* R/W prescale register */
#define TIMER2_PC           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x10)))	/* R/W prescale counter value */
#define TIMER2_MCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x14)))	/* R/W match control register */
#define TIMER2_MR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x18)))	/* R/W match register 0 */
#define TIMER2_MR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x1C)))	/* R/W match register 1 */
#define TIMER2_MR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x20)))	/* R/W match register 2 */
#define TIMER2_MR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x24)))	/* R/W match register 3 */
#define TIMER2_CCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x28)))	/* R/W capture control register */
#define TIMER2_CR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x2C)))	/* R   capture register 0 */
#define TIMER2_CR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x30)))	/* R   capture register 1 */
#define TIMER2_CR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x34)))	/* R   capture register 2 */
#define TIMER2_CR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x38)))	/* R   capture register 3 */
#define TIMER2_EMR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x3C)))	/* R/W external match register */

#define TIMER3_BASE 0xE0043000

#define TIMER3_IR           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x00)))	/* R/W timer interrupt register */
#define TIMER3_TCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x04)))	/* R/W timer control register */
#define TIMER3_TC           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x08)))	/* R/W timer counter value */
#define TIMER3_PR           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x0C)))	/* R/W prescale register */
#define TIMER3_PC           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x10)))	/* R/W prescale counter value */
#define TIMER3_MCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x14)))	/* R/W match control register */
#define TIMER3_MR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x18)))	/* R/W match register 0 */
#define TIMER3_MR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x1C)))	/* R/W match register 1 */
#define TIMER3_MR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x20)))	/* R/W match register 2 */
#define TIMER3_MR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x24)))	/* R/W match register 3 */
#define TIMER3_CCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x28)))	/* R/W capture control register */
#define TIMER3_CR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x2C)))	/* R   capture register 0 */
#define TIMER3_CR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x30)))	/* R   capture register 1 */
#define TIMER3_CR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x34)))	/* R   capture register 2 */
#define TIMER3_CR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x38)))	/* R   capture register 3 */
#define TIMER3_EMR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x3C)))	/* R/W external match register */


/*
** UART Universal Asynchronous Receiver Transmitter (16C550)
*/

#define UART_BASE 0xE0044000

#define UART_RBR            	(*((volatile unsigned int  *) (UART_BASE + 0x00)))	/* R   DLAB = 0 receiver buffer register */
#define UART_THR            	(*((volatile unsigned int  *) (UART_BASE + 0x00)))	/* W   DLAB = 0 transmit holding register */
#define UART_DLL            	(*((volatile unsigned int  *) (UART_BASE + 0x00)))	/* R/W DLAB = 1 divisor latch LSB register */
#define UART_IER            	(*((volatile unsigned int  *) (UART_BASE + 0x04)))	/* R/W DLAB = 0 interrupt enable register */
#define UART_DLM            	(*((volatile unsigned int  *) (UART_BASE + 0x04)))	/* R/W DLAB = 1 divisor latch MSB register */
#define UART_IIR            	(*((volatile unsigned int  *) (UART_BASE + 0x08)))	/* R   interrupt ID register */
#define UART_FCR            	(*((volatile unsigned int  *) (UART_BASE + 0x08)))	/* W   FIFO control register */
#define UART_LCR            	(*((volatile unsigned int  *) (UART_BASE + 0x0C)))	/* R/W line control register */
#define UART_LSR            	(*((volatile unsigned int  *) (UART_BASE + 0x14)))	/* R   line status register */
#define UART_SCR            	(*((volatile unsigned int  *) (UART_BASE + 0x1C)))	/* R/W scratch register */


/*
** GPIOn General Purpose I/O
*/

#define GPIO0_BASE 0xE0045000

#define GPIO0_PINS          	(*((volatile unsigned int  *) (GPIO0_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO0_OR            	(*((volatile unsigned int  *) (GPIO0_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO0_DR            	(*((volatile unsigned int  *) (GPIO0_BASE + 0x8)))	/* R/W DR port direction register */

#define GPIO1_BASE 0xE0046000

#define GPIO1_PINS          	(*((volatile unsigned int  *) (GPIO1_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO1_OR            	(*((volatile unsigned int  *) (GPIO1_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO1_DR            	(*((volatile unsigned int  *) (GPIO1_BASE + 0x8)))	/* R/W DR port direction register */

#define GPIO2_BASE 0xE0047000

#define GPIO2_PINS          	(*((volatile unsigned int  *) (GPIO2_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO2_OR            	(*((volatile unsigned int  *) (GPIO2_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO2_DR            	(*((volatile unsigned int  *) (GPIO2_BASE + 0x8)))	/* R/W DR port direction register */


/**************************************************************************
**                                                                        *
** VPB cluster 3: not used						  *
**                                                                        *
**************************************************************************/


/**************************************************************************
**                                                                        *
** VPB cluster 4: in-vehicle networking subsystem			  *
**                                                                        *
**************************************************************************/

/*
** CANCn CAN controller
*/

#define CANC0_BASE 0xE0080000

#define CANC0_MODE        	(*((volatile unsigned int  *) (CANC0_BASE + 0x00)))	/* R/W mode register */
#define CANC0_CMD         	(*((volatile unsigned int  *) (CANC0_BASE + 0x04)))	/* W   command register */
#define CANC0_GS          	(*((volatile unsigned int  *) (CANC0_BASE + 0x08)))	/* R/W global status register */
#define CANC0_IC          	(*((volatile unsigned int  *) (CANC0_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC0_IE          	(*((volatile unsigned int  *) (CANC0_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC0_BT          	(*((volatile unsigned int  *) (CANC0_BASE + 0x14)))	/* R/W bus timing register */
#define CANC0_EWL         	(*((volatile unsigned int  *) (CANC0_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC0_STAT        	(*((volatile unsigned int  *) (CANC0_BASE + 0x1C)))	/* R   status register */
#define CANC0_RXBMI       	(*((volatile unsigned int  *) (CANC0_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC0_RXBID       	(*((volatile unsigned int  *) (CANC0_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC0_RXBDA       	(*((volatile unsigned int  *) (CANC0_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC0_RXBDB       	(*((volatile unsigned int  *) (CANC0_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC0_TXB1MI      	(*((volatile unsigned int  *) (CANC0_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC0_TXB1ID      	(*((volatile unsigned int  *) (CANC0_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC0_TXB1DA      	(*((volatile unsigned int  *) (CANC0_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC0_TXB1DB      	(*((volatile unsigned int  *) (CANC0_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC0_TXB2MI      	(*((volatile unsigned int  *) (CANC0_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC0_TXB2ID      	(*((volatile unsigned int  *) (CANC0_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC0_TXB2DA      	(*((volatile unsigned int  *) (CANC0_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC0_TXB2DB      	(*((volatile unsigned int  *) (CANC0_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC0_TXB3MI      	(*((volatile unsigned int  *) (CANC0_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC0_TXB3ID      	(*((volatile unsigned int  *) (CANC0_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC0_TXB3DA      	(*((volatile unsigned int  *) (CANC0_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC0_TXB3DB      	(*((volatile unsigned int  *) (CANC0_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CANC1_BASE 0xE0081000

#define CANC1_MODE        	(*((volatile unsigned int  *) (CANC1_BASE + 0x00)))	/* R/W mode register */
#define CANC1_CMD         	(*((volatile unsigned int  *) (CANC1_BASE + 0x04)))	/* W   command register */
#define CANC1_GS          	(*((volatile unsigned int  *) (CANC1_BASE + 0x08)))	/* R/W global status register */
#define CANC1_IC          	(*((volatile unsigned int  *) (CANC1_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC1_IE          	(*((volatile unsigned int  *) (CANC1_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC1_BT          	(*((volatile unsigned int  *) (CANC1_BASE + 0x14)))	/* R/W bus timing register */
#define CANC1_EWL         	(*((volatile unsigned int  *) (CANC1_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC1_STAT        	(*((volatile unsigned int  *) (CANC1_BASE + 0x1C)))	/* R   status register */
#define CANC1_RXBMI       	(*((volatile unsigned int  *) (CANC1_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC1_RXBID       	(*((volatile unsigned int  *) (CANC1_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC1_RXBDA       	(*((volatile unsigned int  *) (CANC1_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC1_RXBDB       	(*((volatile unsigned int  *) (CANC1_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC1_TXB1MI      	(*((volatile unsigned int  *) (CANC1_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC1_TXB1ID      	(*((volatile unsigned int  *) (CANC1_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC1_TXB1DA      	(*((volatile unsigned int  *) (CANC1_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC1_TXB1DB      	(*((volatile unsigned int  *) (CANC1_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC1_TXB2MI      	(*((volatile unsigned int  *) (CANC1_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC1_TXB2ID      	(*((volatile unsigned int  *) (CANC1_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC1_TXB2DA      	(*((volatile unsigned int  *) (CANC1_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC1_TXB2DB      	(*((volatile unsigned int  *) (CANC1_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC1_TXB3MI      	(*((volatile unsigned int  *) (CANC1_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC1_TXB3ID      	(*((volatile unsigned int  *) (CANC1_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC1_TXB3DA      	(*((volatile unsigned int  *) (CANC1_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC1_TXB3DB      	(*((volatile unsigned int  *) (CANC1_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CANC2_BASE 0xE0082000

#define CANC2_MODE        	(*((volatile unsigned int  *) (CANC2_BASE + 0x00)))	/* R/W mode register */
#define CANC2_CMD         	(*((volatile unsigned int  *) (CANC2_BASE + 0x04)))	/* W   command register */
#define CANC2_GS          	(*((volatile unsigned int  *) (CANC2_BASE + 0x08)))	/* R/W global status register */
#define CANC2_IC          	(*((volatile unsigned int  *) (CANC2_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC2_IE          	(*((volatile unsigned int  *) (CANC2_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC2_BT          	(*((volatile unsigned int  *) (CANC2_BASE + 0x14)))	/* R/W bus timing register */
#define CANC2_EWL         	(*((volatile unsigned int  *) (CANC2_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC2_STAT        	(*((volatile unsigned int  *) (CANC2_BASE + 0x1C)))	/* R   status register */
#define CANC2_RXBMI       	(*((volatile unsigned int  *) (CANC2_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC2_RXBID       	(*((volatile unsigned int  *) (CANC2_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC2_RXBDA       	(*((volatile unsigned int  *) (CANC2_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC2_RXBDB       	(*((volatile unsigned int  *) (CANC2_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC2_TXB1MI      	(*((volatile unsigned int  *) (CANC2_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC2_TXB1ID      	(*((volatile unsigned int  *) (CANC2_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC2_TXB1DA      	(*((volatile unsigned int  *) (CANC2_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC2_TXB1DB      	(*((volatile unsigned int  *) (CANC2_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC2_TXB2MI      	(*((volatile unsigned int  *) (CANC2_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC2_TXB2ID      	(*((volatile unsigned int  *) (CANC2_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC2_TXB2DA      	(*((volatile unsigned int  *) (CANC2_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC2_TXB2DB      	(*((volatile unsigned int  *) (CANC2_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC2_TXB3MI      	(*((volatile unsigned int  *) (CANC2_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC2_TXB3ID      	(*((volatile unsigned int  *) (CANC2_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC2_TXB3DA      	(*((volatile unsigned int  *) (CANC2_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC2_TXB3DB      	(*((volatile unsigned int  *) (CANC2_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CANC3_BASE 0xE0083000

#define CANC3_MODE        	(*((volatile unsigned int  *) (CANC3_BASE + 0x00)))	/* R/W mode register */
#define CANC3_CMD         	(*((volatile unsigned int  *) (CANC3_BASE + 0x04)))	/* W   command register */
#define CANC3_GS          	(*((volatile unsigned int  *) (CANC3_BASE + 0x08)))	/* R/W global status register */
#define CANC3_IC          	(*((volatile unsigned int  *) (CANC3_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC3_IE          	(*((volatile unsigned int  *) (CANC3_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC3_BT          	(*((volatile unsigned int  *) (CANC3_BASE + 0x14)))	/* R/W bus timing register */
#define CANC3_EWL         	(*((volatile unsigned int  *) (CANC3_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC3_STAT        	(*((volatile unsigned int  *) (CANC3_BASE + 0x1C)))	/* R   status register */
#define CANC3_RXBMI       	(*((volatile unsigned int  *) (CANC3_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC3_RXBID       	(*((volatile unsigned int  *) (CANC3_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC3_RXBDA       	(*((volatile unsigned int  *) (CANC3_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC3_RXBDB       	(*((volatile unsigned int  *) (CANC3_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC3_TXB1MI      	(*((volatile unsigned int  *) (CANC3_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC3_TXB1ID      	(*((volatile unsigned int  *) (CANC3_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC3_TXB1DA      	(*((volatile unsigned int  *) (CANC3_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC3_TXB1DB      	(*((volatile unsigned int  *) (CANC3_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC3_TXB2MI      	(*((volatile unsigned int  *) (CANC3_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC3_TXB2ID      	(*((volatile unsigned int  *) (CANC3_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC3_TXB2DA      	(*((volatile unsigned int  *) (CANC3_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC3_TXB2DB      	(*((volatile unsigned int  *) (CANC3_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC3_TXB3MI      	(*((volatile unsigned int  *) (CANC3_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC3_TXB3ID      	(*((volatile unsigned int  *) (CANC3_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC3_TXB3DA      	(*((volatile unsigned int  *) (CANC3_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC3_TXB3DB      	(*((volatile unsigned int  *) (CANC3_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CANC4_BASE 0xE0084000

#define CANC4_MODE        	(*((volatile unsigned int  *) (CANC4_BASE + 0x00)))	/* R/W mode register */
#define CANC4_CMD         	(*((volatile unsigned int  *) (CANC4_BASE + 0x04)))	/* W   command register */
#define CANC4_GS          	(*((volatile unsigned int  *) (CANC4_BASE + 0x08)))	/* R/W global status register */
#define CANC4_IC          	(*((volatile unsigned int  *) (CANC4_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC4_IE          	(*((volatile unsigned int  *) (CANC4_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC4_BT          	(*((volatile unsigned int  *) (CANC4_BASE + 0x14)))	/* R/W bus timing register */
#define CANC4_EWL         	(*((volatile unsigned int  *) (CANC4_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC4_STAT        	(*((volatile unsigned int  *) (CANC4_BASE + 0x1C)))	/* R   status register */
#define CANC4_RXBMI       	(*((volatile unsigned int  *) (CANC4_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC4_RXBID       	(*((volatile unsigned int  *) (CANC4_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC4_RXBDA       	(*((volatile unsigned int  *) (CANC4_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC4_RXBDB       	(*((volatile unsigned int  *) (CANC4_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC4_TXB1MI      	(*((volatile unsigned int  *) (CANC4_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC4_TXB1ID      	(*((volatile unsigned int  *) (CANC4_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC4_TXB1DA      	(*((volatile unsigned int  *) (CANC4_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC4_TXB1DB      	(*((volatile unsigned int  *) (CANC4_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC4_TXB2MI      	(*((volatile unsigned int  *) (CANC4_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC4_TXB2ID      	(*((volatile unsigned int  *) (CANC4_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC4_TXB2DA      	(*((volatile unsigned int  *) (CANC4_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC4_TXB2DB      	(*((volatile unsigned int  *) (CANC4_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC4_TXB3MI      	(*((volatile unsigned int  *) (CANC4_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC4_TXB3ID      	(*((volatile unsigned int  *) (CANC4_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC4_TXB3DA      	(*((volatile unsigned int  *) (CANC4_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC4_TXB3DB      	(*((volatile unsigned int  *) (CANC4_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CANC5_BASE 0xE0085000

#define CANC5_MODE        	(*((volatile unsigned int  *) (CANC5_BASE + 0x00)))	/* R/W mode register */
#define CANC5_CMD         	(*((volatile unsigned int  *) (CANC5_BASE + 0x04)))	/* W   command register */
#define CANC5_GS          	(*((volatile unsigned int  *) (CANC5_BASE + 0x08)))	/* R/W global status register */
#define CANC5_IC          	(*((volatile unsigned int  *) (CANC5_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CANC5_IE          	(*((volatile unsigned int  *) (CANC5_BASE + 0x10)))	/* R/W interrupt enable register */
#define CANC5_BT          	(*((volatile unsigned int  *) (CANC5_BASE + 0x14)))	/* R/W bus timing register */
#define CANC5_EWL         	(*((volatile unsigned int  *) (CANC5_BASE + 0x18)))	/* R/W error warning limit register */
#define CANC5_STAT        	(*((volatile unsigned int  *) (CANC5_BASE + 0x1C)))	/* R   status register */
#define CANC5_RXBMI       	(*((volatile unsigned int  *) (CANC5_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CANC5_RXBID       	(*((volatile unsigned int  *) (CANC5_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CANC5_RXBDA       	(*((volatile unsigned int  *) (CANC5_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CANC5_RXBDB       	(*((volatile unsigned int  *) (CANC5_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CANC5_TXB1MI      	(*((volatile unsigned int  *) (CANC5_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CANC5_TXB1ID      	(*((volatile unsigned int  *) (CANC5_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CANC5_TXB1DA      	(*((volatile unsigned int  *) (CANC5_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CANC5_TXB1DB      	(*((volatile unsigned int  *) (CANC5_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CANC5_TXB2MI      	(*((volatile unsigned int  *) (CANC5_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CANC5_TXB2ID      	(*((volatile unsigned int  *) (CANC5_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CANC5_TXB2DA      	(*((volatile unsigned int  *) (CANC5_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CANC5_TXB2DB      	(*((volatile unsigned int  *) (CANC5_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CANC5_TXB3MI      	(*((volatile unsigned int  *) (CANC5_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CANC5_TXB3ID      	(*((volatile unsigned int  *) (CANC5_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CANC5_TXB3DA      	(*((volatile unsigned int  *) (CANC5_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CANC5_TXB3DB      	(*((volatile unsigned int  *) (CANC5_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */


/*
** CANAFM CAN Acceptance Filter Memory (ID-look-up table)
*/

#define CANAFM_BASE 0xE0086000
 

/*
** CANAFR CAN Acceptance Filter registers
*/

#define CANAFR_BASE 0xE0087000

#define CANAFR_MODE       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x00)))	/* R/W mode register */
#define CANAFR_SFESA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x04)))	/* R/W standard frame explicit start address register */
#define CANAFR_SFGSA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x08)))	/* R/W standard frame group start address register */
#define CANAFR_EFESA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x0C)))	/* R/W extended frame explicit start address register */
#define CANAFR_EFGSA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x10)))	/* R/W extended frame group start address register */
#define CANAFR_EOTA       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x14)))	/* R/W end of table address register */
#define CANAFR_LUTEA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x18)))	/* R   look-up table error address register */
#define CANAFR_LUTE       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x1C)))	/* R   look-up table error register */


/*
** CANCS CAN Central Status registers
*/

#define CANCS_BASE 0xE0088000

#define CANCS_TS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x0)))	/* R   transmit status register */
#define CANCS_RS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x4)))	/* R   receive status register */
#define CANCS_MS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x8)))	/* R   miscellaneous status register */


/*
** LINn LIN master controller
*/

#define LIN0_BASE 0xE0089000

#define LIN0_LMODE          	(*((volatile unsigned int  *) (LIN0_BASE + 0x00)))	/* R/W mode register */
#define LIN0_LCFG           	(*((volatile unsigned int  *) (LIN0_BASE + 0x04)))	/* R/W configuration register */
#define LIN0_LCMD           	(*((volatile unsigned int  *) (LIN0_BASE + 0x08)))	/* R/W command register */
#define LIN0_LFBRG          	(*((volatile unsigned int  *) (LIN0_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN0_LSTAT          	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN0_LIC            	(*((volatile unsigned int  *) (LIN0_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN0_LIE            	(*((volatile unsigned int  *) (LIN0_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN0_LCS            	(*((volatile unsigned int  *) (LIN0_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN0_LTO            	(*((volatile unsigned int  *) (LIN0_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN0_LID            	(*((volatile unsigned int  *) (LIN0_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN0_LDATA          	(*((volatile unsigned int  *) (LIN0_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN0_LDATB          	(*((volatile unsigned int  *) (LIN0_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN0_LDATC          	(*((volatile unsigned int  *) (LIN0_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN0_LDATD          	(*((volatile unsigned int  *) (LIN0_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN0_RBR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN0_THR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN0_IER            	(*((volatile unsigned int  *) (LIN0_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN0_IIR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN0_LCR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN0_LSR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN0_SCR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x2C)))	/* R/W LM = 1 scratch register */

#define LIN1_BASE 0xE008A000

#define LIN1_LMODE          	(*((volatile unsigned int  *) (LIN1_BASE + 0x00)))	/* R/W mode register */
#define LIN1_LCFG           	(*((volatile unsigned int  *) (LIN1_BASE + 0x04)))	/* R/W configuration register */
#define LIN1_LCMD           	(*((volatile unsigned int  *) (LIN1_BASE + 0x08)))	/* R/W command register */
#define LIN1_LFBRG          	(*((volatile unsigned int  *) (LIN1_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN1_LSTAT          	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN1_LIC            	(*((volatile unsigned int  *) (LIN1_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN1_LIE            	(*((volatile unsigned int  *) (LIN1_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN1_LCS            	(*((volatile unsigned int  *) (LIN1_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN1_LTO            	(*((volatile unsigned int  *) (LIN1_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN1_LID            	(*((volatile unsigned int  *) (LIN1_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN1_LDATA          	(*((volatile unsigned int  *) (LIN1_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN1_LDATB          	(*((volatile unsigned int  *) (LIN1_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN1_LDATC          	(*((volatile unsigned int  *) (LIN1_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN1_LDATD          	(*((volatile unsigned int  *) (LIN1_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN1_RBR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN1_THR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN1_IER            	(*((volatile unsigned int  *) (LIN1_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN1_IIR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN1_LCR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN1_LSR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN1_SCR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x2C)))	/* R/W LM = 1 scratch register */

#define LIN2_BASE 0xE008B000

#define LIN2_LMODE          	(*((volatile unsigned int  *) (LIN2_BASE + 0x00)))	/* R/W mode register */
#define LIN2_LCFG           	(*((volatile unsigned int  *) (LIN2_BASE + 0x04)))	/* R/W configuration register */
#define LIN2_LCMD           	(*((volatile unsigned int  *) (LIN2_BASE + 0x08)))	/* R/W command register */
#define LIN2_LFBRG          	(*((volatile unsigned int  *) (LIN2_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN2_LSTAT          	(*((volatile unsigned int  *) (LIN2_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN2_LIC            	(*((volatile unsigned int  *) (LIN2_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN2_LIE            	(*((volatile unsigned int  *) (LIN2_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN2_LCS            	(*((volatile unsigned int  *) (LIN2_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN2_LTO            	(*((volatile unsigned int  *) (LIN2_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN2_LID            	(*((volatile unsigned int  *) (LIN2_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN2_LDATA          	(*((volatile unsigned int  *) (LIN2_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN2_LDATB          	(*((volatile unsigned int  *) (LIN2_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN2_LDATC          	(*((volatile unsigned int  *) (LIN2_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN2_LDATD          	(*((volatile unsigned int  *) (LIN2_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN2_RBR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN2_THR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN2_IER            	(*((volatile unsigned int  *) (LIN2_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN2_IIR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN2_LCR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN2_LSR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN2_SCR            	(*((volatile unsigned int  *) (LIN2_BASE + 0x2C)))	/* R/W LM = 1 scratch register */

#define LIN3_BASE 0xE008C000

#define LIN3_LMODE          	(*((volatile unsigned int  *) (LIN3_BASE + 0x00)))	/* R/W mode register */
#define LIN3_LCFG           	(*((volatile unsigned int  *) (LIN3_BASE + 0x04)))	/* R/W configuration register */
#define LIN3_LCMD           	(*((volatile unsigned int  *) (LIN3_BASE + 0x08)))	/* R/W command register */
#define LIN3_LFBRG          	(*((volatile unsigned int  *) (LIN3_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN3_LSTAT          	(*((volatile unsigned int  *) (LIN3_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN3_LIC            	(*((volatile unsigned int  *) (LIN3_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN3_LIE            	(*((volatile unsigned int  *) (LIN3_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN3_LCS            	(*((volatile unsigned int  *) (LIN3_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN3_LTO            	(*((volatile unsigned int  *) (LIN3_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN3_LID            	(*((volatile unsigned int  *) (LIN3_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN3_LDATA          	(*((volatile unsigned int  *) (LIN3_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN3_LDATB          	(*((volatile unsigned int  *) (LIN3_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN3_LDATC          	(*((volatile unsigned int  *) (LIN3_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN3_LDATD          	(*((volatile unsigned int  *) (LIN3_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN3_RBR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN3_THR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN3_IER            	(*((volatile unsigned int  *) (LIN3_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN3_IIR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN3_LCR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN3_LSR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN3_SCR            	(*((volatile unsigned int  *) (LIN3_BASE + 0x2C)))	/* R/W LM = 1 scratch register */


/**************************************************************************
**                                                                        *
** Vector interrupt controller						  *
**                                                                        *
**************************************************************************/

/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VIC_INT_PRIORITY_MASK_0	(*((volatile unsigned int  *) (VIC_BASE + 0x000)))      /* R/W target 0 priority mask register */
#define VIC_INT_PRIORITY_MASK_1	(*((volatile unsigned int  *) (VIC_BASE + 0x004)))      /* R/W target 1 priority mask register */
#define VIC_INT_VECTOR_0	(*((volatile unsigned int  *) (VIC_BASE + 0x100)))      /* R/W target 0 vector register */
#define VIC_INT_VECTOR_1	(*((volatile unsigned int  *) (VIC_BASE + 0x104)))      /* R/W target 1 vector register */
#define VIC_INT_PENDING_1_31	(*((volatile unsigned int  *) (VIC_BASE + 0x200)))      /* R   interrupt pending status register */
#define VIC_INT_FEATURES	(*((volatile unsigned int  *) (VIC_BASE + 0x300)))      /* R   interrupt controller features register */
#define VIC_INT_REQUEST_1	(*((volatile unsigned int  *) (VIC_BASE + 0x404)))      /* R/W interrupt request 1 control register */
#define VIC_INT_REQUEST_2	(*((volatile unsigned int  *) (VIC_BASE + 0x408)))      /* R/W interrupt request 2 control register */
#define VIC_INT_REQUEST_3	(*((volatile unsigned int  *) (VIC_BASE + 0x40C)))      /* R/W interrupt request 3 control register */
#define VIC_INT_REQUEST_4	(*((volatile unsigned int  *) (VIC_BASE + 0x410)))      /* R/W interrupt request 4 control register */
#define VIC_INT_REQUEST_5	(*((volatile unsigned int  *) (VIC_BASE + 0x414)))      /* R/W interrupt request 5 control register */
#define VIC_INT_REQUEST_6	(*((volatile unsigned int  *) (VIC_BASE + 0x418)))      /* R/W interrupt request 6 control register */
#define VIC_INT_REQUEST_7	(*((volatile unsigned int  *) (VIC_BASE + 0x41C)))      /* R/W interrupt request 7 control register */
#define VIC_INT_REQUEST_8	(*((volatile unsigned int  *) (VIC_BASE + 0x420)))      /* R/W interrupt request 8 control register */
#define VIC_INT_REQUEST_9	(*((volatile unsigned int  *) (VIC_BASE + 0x424)))      /* R/W interrupt request 9 control register */
#define VIC_INT_REQUEST_10	(*((volatile unsigned int  *) (VIC_BASE + 0x428)))      /* R/W interrupt request 10 control register */
#define VIC_INT_REQUEST_11	(*((volatile unsigned int  *) (VIC_BASE + 0x42C)))      /* R/W interrupt request 11 control register */
#define VIC_INT_REQUEST_12	(*((volatile unsigned int  *) (VIC_BASE + 0x430)))      /* R/W interrupt request 12 control register */
#define VIC_INT_REQUEST_13	(*((volatile unsigned int  *) (VIC_BASE + 0x434)))      /* R/W interrupt request 13 control register */
#define VIC_INT_REQUEST_14	(*((volatile unsigned int  *) (VIC_BASE + 0x438)))      /* R/W interrupt request 14 control register */
#define VIC_INT_REQUEST_15	(*((volatile unsigned int  *) (VIC_BASE + 0x43C)))      /* R/W interrupt request 15 control register */
#define VIC_INT_REQUEST_16	(*((volatile unsigned int  *) (VIC_BASE + 0x440)))      /* R/W interrupt request 16 control register */
#define VIC_INT_REQUEST_17	(*((volatile unsigned int  *) (VIC_BASE + 0x444)))      /* R/W interrupt request 17 control register */
#define VIC_INT_REQUEST_18	(*((volatile unsigned int  *) (VIC_BASE + 0x448)))      /* R/W interrupt request 18 control register */
#define VIC_INT_REQUEST_19	(*((volatile unsigned int  *) (VIC_BASE + 0x44C)))      /* R/W interrupt request 19 control register */
#define VIC_INT_REQUEST_20	(*((volatile unsigned int  *) (VIC_BASE + 0x450)))      /* R/W interrupt request 20 control register */
#define VIC_INT_REQUEST_21	(*((volatile unsigned int  *) (VIC_BASE + 0x454)))      /* R/W interrupt request 21 control register */
#define VIC_INT_REQUEST_22	(*((volatile unsigned int  *) (VIC_BASE + 0x458)))      /* R/W interrupt request 22 control register */
#define VIC_INT_REQUEST_23	(*((volatile unsigned int  *) (VIC_BASE + 0x45C)))      /* R/W interrupt request 23 control register */
#define VIC_INT_REQUEST_24	(*((volatile unsigned int  *) (VIC_BASE + 0x460)))      /* R/W interrupt request 24 control register */
#define VIC_INT_REQUEST_25	(*((volatile unsigned int  *) (VIC_BASE + 0x464)))      /* R/W interrupt request 25 control register */
#define VIC_INT_REQUEST_26	(*((volatile unsigned int  *) (VIC_BASE + 0x468)))      /* R/W interrupt request 26 control register */
#define VIC_INT_REQUEST_27	(*((volatile unsigned int  *) (VIC_BASE + 0x46C)))      /* R/W interrupt request 27 control register */
#define VIC_INT_REQUEST_28	(*((volatile unsigned int  *) (VIC_BASE + 0x470)))      /* R/W interrupt request 28 control register */
#define VIC_INT_REQUEST_29	(*((volatile unsigned int  *) (VIC_BASE + 0x474)))      /* R/W interrupt request 29 control register */
#define VIC_INT_REQUEST_30	(*((volatile unsigned int  *) (VIC_BASE + 0x478)))      /* R/W interrupt request 30 control register */
#define VIC_INT_REQUEST_31	(*((volatile unsigned int  *) (VIC_BASE + 0x47C)))      /* R/W interrupt request 31 control register */

#endif   /* _SJA2020_H */
