/**************************************************************************
**                                                                        *
**  FILE        :  lpc3180.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**		   LPC3180						  *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC3180_H
#define _LPC3180_H


/*
** SLC Single Level NAND Flash Controller
*/

#define SLC_BASE 0x20020000

#define SLC_DATA		(*((volatile unsigned int *) (SLC_BASE + 0x00)))
#define SLC_ADDR		(*((volatile unsigned int *) (SLC_BASE + 0x04)))
#define SLC_CMD			(*((volatile unsigned int *) (SLC_BASE + 0x08)))
#define SLC_STOP		(*((volatile unsigned int *) (SLC_BASE + 0x0C)))
#define SLC_CTRL		(*((volatile unsigned int *) (SLC_BASE + 0x10)))
#define SLC_CFG			(*((volatile unsigned int *) (SLC_BASE + 0x14)))
#define SLC_STAT		(*((volatile unsigned int *) (SLC_BASE + 0x18)))
#define SLC_INT_STAT		(*((volatile unsigned int *) (SLC_BASE + 0x1C)))
#define SLC_IEN			(*((volatile unsigned int *) (SLC_BASE + 0x20)))
#define SLC_ISR			(*((volatile unsigned int *) (SLC_BASE + 0x24)))
#define SLC_ICR			(*((volatile unsigned int *) (SLC_BASE + 0x28)))
#define SLC_TAC			(*((volatile unsigned int *) (SLC_BASE + 0x2C)))
#define SLC_TC			(*((volatile unsigned int *) (SLC_BASE + 0x30)))
#define SLC_ECC			(*((volatile unsigned int *) (SLC_BASE + 0x34)))
#define SLC_DMA_DATA		(*((volatile unsigned int *) (SLC_BASE + 0x38)))


/*
** SPI1 Serial Peripheral Interfaces 1
*/

#define SPI1_BASE 0x20088000

#define SPI1_GLOBAL		(*((volatile unsigned int *) (SPI1_BASE + 0x000)))
#define SPI1_CON		(*((volatile unsigned int *) (SPI1_BASE + 0x004)))
#define SPI1_FRM		(*((volatile unsigned int *) (SPI1_BASE + 0x008)))
#define SPI1_IER		(*((volatile unsigned int *) (SPI1_BASE + 0x00C)))
#define SPI1_STAT		(*((volatile unsigned int *) (SPI1_BASE + 0x010)))
#define SPI1_DAT		(*((volatile unsigned int *) (SPI1_BASE + 0x014)))
#define SPI1_TIM_CTRL		(*((volatile unsigned int *) (SPI1_BASE + 0x400)))
#define SPI1_TIM_COUNT		(*((volatile unsigned int *) (SPI1_BASE + 0x404)))
#define SPI1_TIM_STAT		(*((volatile unsigned int *) (SPI1_BASE + 0x408)))


/*
** SPI2 Serial Peripheral Interfaces 2
*/

#define SPI2__BASE 0x20090000

#define SPI2_GLOBAL		(*((volatile unsigned int *) (SPI2_BASE + 0x000)))
#define SPI2_CON		(*((volatile unsigned int *) (SPI2_BASE + 0x004)))
#define SPI2_FRM		(*((volatile unsigned int *) (SPI2_BASE + 0x008)))
#define SPI2_IER		(*((volatile unsigned int *) (SPI2_BASE + 0x00C)))
#define SPI2_STAT		(*((volatile unsigned int *) (SPI2_BASE + 0x010)))
#define SPI2_DAT		(*((volatile unsigned int *) (SPI2_BASE + 0x014)))
#define SPI2_TIM_CTRL		(*((volatile unsigned int *) (SPI2_BASE + 0x400)))
#define SPI2_TIM_COUNT		(*((volatile unsigned int *) (SPI2_BASE + 0x404)))
#define SPI2_TIM_STAT		(*((volatile unsigned int *) (SPI2_BASE + 0x408)))


/*
** SD Secure Digital card interface
*/

#define SD_BASE 0x20098000

#define SD_Power      		(*((volatile unsigned int *) (SD_BASE + 0x00)))
#define SD_Clock      		(*((volatile unsigned int *) (SD_BASE + 0x04)))
#define SD_Argument   		(*((volatile unsigned int *) (SD_BASE + 0x08)))
#define SD_Command    		(*((volatile unsigned int *) (SD_BASE + 0x0C)))
#define SD_RespCmd   		(*((volatile unsigned int *) (SD_BASE + 0x10)))
#define SD_Response0      	(*((volatile unsigned int *) (SD_BASE + 0x14)))
#define SD_Response1      	(*((volatile unsigned int *) (SD_BASE + 0x18)))
#define SD_Response2      	(*((volatile unsigned int *) (SD_BASE + 0x1C)))
#define SD_response3  		(*((volatile unsigned int *) (SD_BASE + 0x20)))
#define SD_DataTimer  		(*((volatile unsigned int *) (SD_BASE + 0x24)))
#define SD_DataLength 		(*((volatile unsigned int *) (SD_BASE + 0x28)))
#define SD_DataCtrl  		(*((volatile unsigned int *) (SD_BASE + 0x2C)))
#define SD_DataCnt   		(*((volatile unsigned int *) (SD_BASE + 0x30)))
#define SD_Status     		(*((volatile unsigned int *) (SD_BASE + 0x34)))
#define SD_Clear      		(*((volatile unsigned int *) (SD_BASE + 0x38)))
#define SD_Mask0      		(*((volatile unsigned int *) (SD_BASE + 0x3C)))
#define SD_Mask1      		(*((volatile unsigned int *) (SD_BASE + 0x40)))
#define SD_FIFOCnt   		(*((volatile unsigned int *) (SD_BASE + 0x48)))
#define SD_FIFO       		(*((volatile unsigned int *) (SD_BASE + 0x80)))


/*
** MLC Muliple Level NAND Flash Controller
*/

#define MLC_BASE 0x200B0000

#define MLC_CMD			(*((volatile unsigned int *) (MLC_BASE + 0x00)))
#define MLC			(*((volatile unsigned int *) (MLC_BASE + 0x04)))
#define MLC_ECC_ENC_REG		(*((volatile unsigned int *) (MLC_BASE + 0x08)))
#define MLC_ECC_DEC_REG		(*((volatile unsigned int *) (MLC_BASE + 0x0C)))
#define MLC_ECC_AUTO_ENC_REG	(*((volatile unsigned int *) (MLC_BASE + 0x10)))
#define MLC_ECC_AUTO_DEC_REG	(*((volatile unsigned int *) (MLC_BASE + 0x14)))
#define MLC_RPR			(*((volatile unsigned int *) (MLC_BASE + 0x18)))
#define MLC_WPR			(*((volatile unsigned int *) (MLC_BASE + 0x1C)))
#define MLC_RUBP		(*((volatile unsigned int *) (MLC_BASE + 0x20)))
#define MLC_ROBP		(*((volatile unsigned int *) (MLC_BASE + 0x24)))
#define MLC_SW_WP_ADD_LOW	(*((volatile unsigned int *) (MLC_BASE + 0x28)))
#define MLC_SW_WP_ADD_HIG	(*((volatile unsigned int *) (MLC_BASE + 0x2C)))
#define MLC_ICR			(*((volatile unsigned int *) (MLC_BASE + 0x30)))
#define MLC_TIME_REG		(*((volatile unsigned int *) (MLC_BASE + 0x34)))
#define MLC_IRQ_MR		(*((volatile unsigned int *) (MLC_BASE + 0x38)))
#define MLC_IRQ_SR		(*((volatile unsigned int *) (MLC_BASE + 0x3C)))
#define MLC_LOCK_PR		(*((volatile unsigned int *) (MLC_BASE + 0x44)))
#define MLC_ISR			(*((volatile unsigned int *) (MLC_BASE + 0x48)))
#define MLC_CEH			(*((volatile unsigned int *) (MLC_BASE + 0x4C)))


/*
** DMAC General Purpose DMA Controller
*/

#define DMAC_BASE 0x31000000

/* General Registers */
#define DMACIntStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x000)))
#define DMACIntTCStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x004)))
#define DMACIntTCClear		(*((volatile unsigned int *) (DMAC_BASE + 0x008)))
#define DMACIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x00C)))
#define DMACIntIntErrClr	(*((volatile unsigned int *) (DMAC_BASE + 0x010)))
#define DMACRawIntTCStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x014)))
#define DMACRawIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x018)))
#define DMACEnbldChns		(*((volatile unsigned int *) (DMAC_BASE + 0x01C)))
#define DMACSoftBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x020)))
#define DMACSoftSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x024)))
#define DMACSoftLBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x028)))
#define DMACSoftLSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x02C)))
#define DMACConfiguration	(*((volatile unsigned int *) (DMAC_BASE + 0x030)))
#define DMACSync		(*((volatile unsigned int *) (DMAC_BASE + 0x034)))

/* Channel 0 Registers */
#define DMACC0SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x100)))
#define DMACC0DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x104)))
#define DMACC0LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x108)))
#define DMACC0Control		(*((volatile unsigned int *) (DMAC_BASE + 0x10C)))
#define DMACC0Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x110)))

/* Channel 1 Registers */
#define DMACC1SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x120)))
#define DMACC1DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x124)))
#define DMACC1LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x128)))
#define DMACC1Control		(*((volatile unsigned int *) (DMAC_BASE + 0x12C)))
#define DMACC1Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x130)))

/* Channel 2 Registers */
#define DMACC2SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x140)))
#define DMACC2DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x144)))
#define DMACC2LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x148)))
#define DMACC2Control		(*((volatile unsigned int *) (DMAC_BASE + 0x14C)))
#define DMACC2Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x150)))

/* Channel 3 Registers */
#define DMACC3SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x160)))
#define DMACC3DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x164)))
#define DMACC3LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x168)))
#define DMACC3Control		(*((volatile unsigned int *) (DMAC_BASE + 0x16C)))
#define DMACC3Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x170)))

/* Channel 4 Registers */
#define DMACC4SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x180)))
#define DMACC4DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x184)))
#define DMACC4LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x188)))
#define DMACC4Control		(*((volatile unsigned int *) (DMAC_BASE + 0x18C)))
#define DMACC4Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x190)))

/* Channel 5 Registers */
#define DMACC5SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1A0)))
#define DMACC5DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1A4)))
#define DMACC5LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1A8)))
#define DMACC5Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1AC)))
#define DMACC5Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1B0)))

/* Channel 6 Registers */
#define DMACC6SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1C0)))
#define DMACC6DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1C4)))
#define DMACC6LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1C8)))
#define DMACC6Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1CC)))
#define DMACC6Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1D0)))

/* Channel 7 Registers */
#define DMACC7SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1E0)))
#define DMACC7DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1E4)))
#define DMACC7LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1E8)))
#define DMACC7Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1EC)))
#define DMACC7Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1F0)))


/*
** USB device register address definitions
*/

#define USB_BASE 0x31020000

/* USB Host register address definitions */
#define HcRevision		(*((volatile unsigned int *) (USB_BASE + 0x000)))
#define HcControl		(*((volatile unsigned int *) (USB_BASE + 0x004)))
#define HcCommandStatus		(*((volatile unsigned int *) (USB_BASE + 0x008)))
#define HcInterruptStatus	(*((volatile unsigned int *) (USB_BASE + 0x00C)))
#define HcInterruptEnable	(*((volatile unsigned int *) (USB_BASE + 0x010)))
#define HcInterruptDisable	(*((volatile unsigned int *) (USB_BASE + 0x014)))
#define HcHCCA			(*((volatile unsigned int *) (USB_BASE + 0x018)))
#define HcPeriodCurrentED	(*((volatile unsigned int *) (USB_BASE + 0x01C)))
#define HcControlHeadED		(*((volatile unsigned int *) (USB_BASE + 0x020)))
#define HcControlCurrentED	(*((volatile unsigned int *) (USB_BASE + 0x024)))
#define HcBulkHeadED		(*((volatile unsigned int *) (USB_BASE + 0x028)))
#define HcBulkCurrentED		(*((volatile unsigned int *) (USB_BASE + 0x02C)))
#define HcDoneHead		(*((volatile unsigned int *) (USB_BASE + 0x030)))
#define HcFmInterval		(*((volatile unsigned int *) (USB_BASE + 0x034)))
#define HcFmRemaining		(*((volatile unsigned int *) (USB_BASE + 0x038)))
#define HcFmNumber		(*((volatile unsigned int *) (USB_BASE + 0x03C)))
#define HcPeriodicStart		(*((volatile unsigned int *) (USB_BASE + 0x040)))
#define HcLSThreshold		(*((volatile unsigned int *) (USB_BASE + 0x044)))
#define HcRhDescriptorA		(*((volatile unsigned int *) (USB_BASE + 0x048)))
#define HcRhDescriptorB		(*((volatile unsigned int *) (USB_BASE + 0x04C)))
#define HcRhStatus		(*((volatile unsigned int *) (USB_BASE + 0x050)))
#define HcRhPortStatus1		(*((volatile unsigned int *) (USB_BASE + 0x054)))
#define HcRhPortStatus2		(*((volatile unsigned int *) (USB_BASE + 0x058)))
#define HcModuleID		(*((volatile unsigned int *) (USB_BASE + 0x0FC)))

/* OTG registers */
#define OTG_int_status		(*((volatile unsigned int *) (USB_BASE + 0x100)))
#define OTG_int_enable		(*((volatile unsigned int *) (USB_BASE + 0x104)))
#define OTG_int_set		(*((volatile unsigned int *) (USB_BASE + 0x108)))
#define OTG_int_clear		(*((volatile unsigned int *) (USB_BASE + 0x10C)))
#define OTG_status		(*((volatile unsigned int *) (USB_BASE + 0x110)))
#define OTG_timer		(*((volatile unsigned int *) (USB_BASE + 0x114)))

/* Device interrupt registers */
#define USBDevIntSt		(*((volatile unsigned int *) (USB_BASE + 0x200)))
#define USBDevIntEn		(*((volatile unsigned int *) (USB_BASE + 0x204)))
#define USBDevIntClr		(*((volatile unsigned int *) (USB_BASE + 0x208)))
#define USBDevIntSet		(*((volatile unsigned int *) (USB_BASE + 0x20C)))
#define USBDevIntPri		(*((volatile unsigned int *) (USB_BASE + 0x22C)))

/* Endpoint interrupt registers */
#define USBEpIntSt		(*((volatile unsigned int *) (USB_BASE + 0x230)))
#define USBEpIntEn		(*((volatile unsigned int *) (USB_BASE + 0x234)))
#define USBEpIntClr		(*((volatile unsigned int *) (USB_BASE + 0x238)))
#define USBEpIntSet		(*((volatile unsigned int *) (USB_BASE + 0x23C)))
#define USBEpIntPri		(*((volatile unsigned int *) (USB_BASE + 0x240)))

/* Endpoint realization registers */
#define USBReEp			(*((volatile unsigned int *) (USB_BASE + 0x244)))
#define USBEpInd		(*((volatile unsigned int *) (USB_BASE + 0x248)))
#define USBEpMaxPSize		(*((volatile unsigned int *) (USB_BASE + 0x24C)))

/* Command registers */
#define USBCmdCode		(*((volatile unsigned int *) (USB_BASE + 0x210)))
#define USBCmdData		(*((volatile unsigned int *) (USB_BASE + 0x214)))

/* Data transfer registers */
#define USBRxData		(*((volatile unsigned int *) (USB_BASE + 0x218)))
#define USBRxPLen		(*((volatile unsigned int *) (USB_BASE + 0x220)))
#define USBTxData		(*((volatile unsigned int *) (USB_BASE + 0x21C)))
#define USBTxPLen		(*((volatile unsigned int *) (USB_BASE + 0x224)))
#define USBCtrl			(*((volatile unsigned int *) (USB_BASE + 0x228)))

/* DMA registers */
#define USBDMARSt		(*((volatile unsigned int *) (USB_BASE + 0x250)))
#define USBDMARClr		(*((volatile unsigned int *) (USB_BASE + 0x254)))
#define USBDMARSet		(*((volatile unsigned int *) (USB_BASE + 0x258)))
#define USBUDCAH		(*((volatile unsigned int *) (USB_BASE + 0x280)))
#define USBEpDMASt		(*((volatile unsigned int *) (USB_BASE + 0x284)))
#define USBEpDMAEn		(*((volatile unsigned int *) (USB_BASE + 0x288)))
#define USBEpDMADis		(*((volatile unsigned int *) (USB_BASE + 0x28C)))
#define USBDMAIntSt		(*((volatile unsigned int *) (USB_BASE + 0x290)))
#define USBDMAIntEn		(*((volatile unsigned int *) (USB_BASE + 0x294)))
#define USBEoTIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2A0)))
#define USBEoTIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2A4)))
#define USBEoTIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2A8)))
#define USBNDDRIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2AC)))
#define USBNDDRIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2B0)))
#define USBNDDRIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2B4)))
#define USBSysErrIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2B8)))
#define USBSysErrIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2BC)))
#define USBSysErrIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2C0)))
#define USBModId		(*((volatile unsigned int *) (USB_BASE + 0x2FC)))

/* I2C registers */
#define I2C_RX			(*((volatile unsigned int *) (USB_BASE + 0x300)))
#define I2C_TX			(*((volatile unsigned int *) (USB_BASE + 0x300)))
#define I2C_STS			(*((volatile unsigned int *) (USB_BASE + 0x304)))
#define I2C_CTL			(*((volatile unsigned int *) (USB_BASE + 0x308)))
#define I2C_CLKHI		(*((volatile unsigned int *) (USB_BASE + 0x30C)))
#define I2C_CLKLO		(*((volatile unsigned int *) (USB_BASE + 0x310)))

/* Clock control and module ID registers */
#define OTG_clock_control	(*((volatile unsigned int *) (USB_BASE + 0xFF4)))
#define OTG_clock_status	(*((volatile unsigned int *) (USB_BASE + 0xFF8)))
#define OTG_module_id		(*((volatile unsigned int *) (USB_BASE + 0xFFC)))


/*
** SDRAM memory controller
*/

#define SDRAM_BASE 0x31080000

#define MPMCControl		(*((volatile unsigned int *) (SDRAM_BASE + 0x000)))
#define MPMCStatus		(*((volatile unsigned int *) (SDRAM_BASE + 0x004)))
#define MPMCConfig		(*((volatile unsigned int *) (SDRAM_BASE + 0x008)))
#define MPMCDynamicControl	(*((volatile unsigned int *) (SDRAM_BASE + 0x020)))
#define MPMCDynamicRefresh	(*((volatile unsigned int *) (SDRAM_BASE + 0x024)))
#define MPMCDynamicReadConfig	(*((volatile unsigned int *) (SDRAM_BASE + 0x028)))
#define MPMCDynamicRP		(*((volatile unsigned int *) (SDRAM_BASE + 0x030)))
#define MPMCDynamicRAS		(*((volatile unsigned int *) (SDRAM_BASE + 0x034)))
#define MPMCDynamicSREX		(*((volatile unsigned int *) (SDRAM_BASE + 0x038)))
#define MPMCDynamicWR		(*((volatile unsigned int *) (SDRAM_BASE + 0x044)))
#define MPMCDynamicRC		(*((volatile unsigned int *) (SDRAM_BASE + 0x048)))
#define MPMCDynamicRFC		(*((volatile unsigned int *) (SDRAM_BASE + 0x04C)))
#define MPMCDynamicXSR		(*((volatile unsigned int *) (SDRAM_BASE + 0x050)))
#define MPMCDynamicRRD		(*((volatile unsigned int *) (SDRAM_BASE + 0x054)))
#define MPMCDynamicMRD		(*((volatile unsigned int *) (SDRAM_BASE + 0x058)))
#define MPMCDynamicCDLR		(*((volatile unsigned int *) (SDRAM_BASE + 0x05C)))
#define MPMCDynamicConfig0	(*((volatile unsigned int *) (SDRAM_BASE + 0x100)))
#define MPMCDynamicRasCas0	(*((volatile unsigned int *) (SDRAM_BASE + 0x104)))
#define MPMCAHBControl0		(*((volatile unsigned int *) (SDRAM_BASE + 0x400)))
#define MPMCAHBStatus0		(*((volatile unsigned int *) (SDRAM_BASE + 0x404)))
#define MPMCAHBTimeout0		(*((volatile unsigned int *) (SDRAM_BASE + 0x408)))
#define MPMCAHBControl2		(*((volatile unsigned int *) (SDRAM_BASE + 0x440)))
#define MPMCAHBStatus2		(*((volatile unsigned int *) (SDRAM_BASE + 0x444)))
#define MPMCAHBTimeout2		(*((volatile unsigned int *) (SDRAM_BASE + 0x448)))
#define MPMCAHBControl3		(*((volatile unsigned int *) (SDRAM_BASE + 0x460)))
#define MPMCAHBStatus3		(*((volatile unsigned int *) (SDRAM_BASE + 0x464)))
#define MPMCAHBTimeout3		(*((volatile unsigned int *) (SDRAM_BASE + 0x468)))
#define MPMCAHBControl4		(*((volatile unsigned int *) (SDRAM_BASE + 0x480)))
#define MPMCAHBStatus4		(*((volatile unsigned int *) (SDRAM_BASE + 0x484)))
#define MPMCAHBTimeout4		(*((volatile unsigned int *) (SDRAM_BASE + 0x488)))


/*
** SCR System configuration registers
*/

#define SRC_BASE 0x40004000

/* Bootmap control register */
#define SCR_BOOTMAP		(*((volatile unsigned int *) (SCR_BASE + 0x14)))

/* Power control register */
#define START_ER_INT		(*((volatile unsigned int *) (SRC_BASE + 0x20)))
#define START_RSR_INT		(*((volatile unsigned int *) (SRC_BASE + 0x24)))
#define START_SR_INT		(*((volatile unsigned int *) (SRC_BASE + 0x28)))
#define START_APR_INT		(*((volatile unsigned int *) (SRC_BASE + 0x2C)))
#define START_ER_PIN		(*((volatile unsigned int *) (SRC_BASE + 0x30)))
#define START_RSR_PIN		(*((volatile unsigned int *) (SRC_BASE + 0x34)))
#define START_SR_PIN		(*((volatile unsigned int *) (SRC_BASE + 0x38)))
#define START_APR_PIN		(*((volatile unsigned int *) (SRC_BASE + 0x3C)))

/* Clocking register */
#define HCLKDIV_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x40)))
#define PWR_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x44)))
#define PLL397_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x48)))
#define OSC_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x4C)))
#define SYSCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x50)))
#define HCLKPLL_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x58)))
#define USBCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x64)))

/* SDRAM controller registers */
#define SDRAMCLK_CTRL		(*((volatile unsigned int *) (SCR_BASE + 0x68)))
#define DDR_LAP_NOM		(*((volatile unsigned int *) (SCR_BASE + 0x6C)))
#define DDR_LAP_COUNT		(*((volatile unsigned int *) (SCR_BASE + 0x70)))
#define DDR_CAL_DELAY		(*((volatile unsigned int *) (SCR_BASE + 0x74)))

/* Others */
#define MS_CTRL			(*((volatile unsigned int *) (SRC_BASE + 0x80)))
#define RINGOSC_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0x88)))
#define SW_INT			(*((volatile unsigned int *) (SRC_BASE + 0xA8)))
#define TEST_CLK		(*((volatile unsigned int *) (SRC_BASE + 0xA4)))
#define I2CCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xAC)))
#define KEYCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xB0)))
#define ADCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xB4)))
#define PWMCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xB8)))
#define TIMCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xBC)))
#define SPI_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xC4)))
#define FLASHCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xC8)))

/* UART control registers */
#define U3CLK          		(*((volatile unsigned int *) (SRC_BASE + 0xD0)))
#define U4CLK          		(*((volatile unsigned int *) (SRC_BASE + 0xD4)))
#define U5CLK          		(*((volatile unsigned int *) (SRC_BASE + 0xD8)))
#define U6CLK          		(*((volatile unsigned int *) (SRC_BASE + 0xDC)))
#define IRDACLK        		(*((volatile unsigned int *) (SRC_BASE + 0xE0)))
#define UARTCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xE4)))
#define DMACLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xE8)))
#define AUTOCLK_CTRL		(*((volatile unsigned int *) (SRC_BASE + 0xEC)))


/*
** Main Interrupt Controller
*/

#define MIC_BASE 0x40008000

#define MIC_ER			(*((volatile unsigned int *) (MIC_BASE + 0x00)))
#define MIC_RSR			(*((volatile unsigned int *) (MIC_BASE + 0x04)))
#define MIC_SR			(*((volatile unsigned int *) (MIC_BASE + 0x08)))
#define MIC_APR			(*((volatile unsigned int *) (MIC_BASE + 0x0C)))
#define MIC_ATR			(*((volatile unsigned int *) (MIC_BASE + 0x10)))
#define MIC_ITR			(*((volatile unsigned int *) (MIC_BASE + 0x14)))


/*
** Slave Interrupt Controller 1
*/

#define SIC1_BASE 0x4000C000

#define SIC1_ER			(*(volatile unsigned int *) (SIC1_BASE + 0x00)))
#define SIC1_RSR		(*(volatile unsigned int *) (SIC1_BASE + 0x04)))
#define SIC1_SR			(*(volatile unsigned int *) (SIC1_BASE + 0x08)))
#define SIC1_APR		(*(volatile unsigned int *) (SIC1_BASE + 0x0C)))
#define SIC1_ATR		(*(volatile unsigned int *) (SIC1_BASE + 0x10)))
#define SIC1_ITR		(*(volatile unsigned int *) (SIC1_BASE + 0x14)))


/*
** Slave Interrupt Controller 2
*/

#define SIC2_BASE 0x40010000

#define SIC2_ER			(*((volatile unsigned int *) (SIC2_BASE + 0x00)))
#define SIC2_RSR		(*((volatile unsigned int *) (SIC2_BASE + 0x04)))
#define SIC2_SR			(*((volatile unsigned int *) (SIC2_BASE + 0x08)))
#define SIC2_APR		(*((volatile unsigned int *) (SIC2_BASE + 0x0C)))
#define SIC2_ATR		(*((volatile unsigned int *) (SIC2_BASE + 0x10)))
#define SIC2_ITR		(*((volatile unsigned int *) (SIC2_BASE + 0x14)))


/*
** UART1 Universal Asynchronous Receiver Transmitter 1 (High speed)
*/

#define UART1_BASE 0x40014000

#define UART1_RX        	(*((volatile unsigned int *) (UART1_BASE + 0x00)))
#define UART1_TX        	(*((volatile unsigned int *) (UART1_BASE + 0x00)))
#define UART1_LEVEL     	(*((volatile unsigned int *) (UART1_BASE + 0x04)))
#define UART1_IIR       	(*((volatile unsigned int *) (UART1_BASE + 0x08)))
#define UART1_CTRL      	(*((volatile unsigned int *) (UART1_BASE + 0x0C)))
#define UART1_RATE      	(*((volatile unsigned int *) (UART1_BASE + 0x10)))


/*
** UART2 Universal Asynchronous Receiver Transmitter 2 (High speed)
*/

#define UART2_BASE 0x40018000

#define UART2_RX        	(*((volatile unsigned int *) (UART2_BASE + 0x00)))
#define UART2_TX        	(*((volatile unsigned int *) (UART2_BASE + 0x00)))
#define UART2_LEVEL     	(*((volatile unsigned int *) (UART2_BASE + 0x04)))
#define UART2_IIR       	(*((volatile unsigned int *) (UART2_BASE + 0x08)))
#define UART2_CTRL      	(*((volatile unsigned int *) (UART2_BASE + 0x0C)))
#define UART2_RATE      	(*((volatile unsigned int *) (UART2_BASE + 0x10)))


/*
** UART7 Universal Asynchronous Receiver Transmitter 7 (High speed)
*/

#define UART7_BASE 0x4001C000

#define UART7_RX        	(*((volatile unsigned int *) (UART7_BASE + 0x00)))
#define UART7_TX        	(*((volatile unsigned int *) (UART7_BASE + 0x00)))
#define UART7_LEVEL     	(*((volatile unsigned int *) (UART7_BASE + 0x04)))
#define UART7_IIR       	(*((volatile unsigned int *) (UART7_BASE + 0x08)))
#define UART7_CTRL      	(*((volatile unsigned int *) (UART7_BASE + 0x0C)))
#define UART7_RATE      	(*((volatile unsigned int *) (UART7_BASE + 0x10)))


/*
** RTC Real Time Clock and battery RAM
*/

#define RTC_BASE 0x40024000

#define RTC_UCOUNT		(*((volatile unsigned int *) (RTC_BASE + 0x00)))
#define RTC_DCOUNT		(*((volatile unsigned int *) (RTC_BASE + 0x04)))
#define RTC_MATCH0		(*((volatile unsigned int *) (RTC_BASE + 0x08)))
#define RTC_MATCH1		(*((volatile unsigned int *) (RTC_BASE + 0x0C)))
#define RTC_CTRL		(*((volatile unsigned int *) (RTC_BASE + 0x10)))
#define RTC_INTSTAT		(*((volatile unsigned int *) (RTC_BASE + 0x14)))
#define RTC_KEY			(*((volatile unsigned int *) (RTC_BASE + 0x18)))
#define RTC_SRAM		(*((volatile unsigned int *) (RTC_BASE + 0x80)))


/*
** GPIO General Purpose I/O
*/

#define GPIO_BASE 0x40028000

#define GPIO_INP_STATE		(*((volatile unsigned int *) (GPIO_BASE + 0x00)))
#define GPIO_OUTP_SET		(*((volatile unsigned int *) (GPIO_BASE + 0x04)))
#define GPIO_OUTP_CLR		(*((volatile unsigned int *) (GPIO_BASE + 0x08)))
#define GPIO_OUTP_STATE		(*((volatile unsigned int *) (GPIO_BASE + 0x0C)))
#define GPIO_DIR_SET		(*((volatile unsigned int *) (GPIO_BASE + 0x10)))
#define GPIO_DIR_CLR		(*((volatile unsigned int *) (GPIO_BASE + 0x14)))
#define GPIO_DIR_STATE		(*((volatile unsigned int *) (GPIO_BASE + 0x18)))
#define GPIO_SDINP_STATE	(*((volatile unsigned int *) (GPIO_BASE + 0x1C)))
#define GPIO_SDOUTP_SET		(*((volatile unsigned int *) (GPIO_BASE + 0x20)))
#define GPIO_SDOUTP_CLR		(*((volatile unsigned int *) (GPIO_BASE + 0x24)))
#define GPIO_MUX_SET		(*((volatile unsigned int *) (GPIO_BASE + 0x28)))
#define GPIO_MUX_CLR		(*((volatile unsigned int *) (GPIO_BASE + 0x2C)))
#define GPIO_MUX_STATE		(*((volatile unsigned int *) (GPIO_BASE + 0x30)))


/*
** Millisecond Timer
*/

#define MSTIM_BASE 0x40034000

#define MSTIM_INT		(*((volatile unsigned int *) (MSTIM_BASE + 0x00)))
#define MSTIM_CTRL		(*((volatile unsigned int *) (MSTIM_BASE + 0x04)))
#define MSTIM_COUNTER		(*((volatile unsigned int *) (MSTIM_BASE + 0x08)))
#define MSTIM_MCTRL		(*((volatile unsigned int *) (MSTIM_BASE + 0x14)))
#define MSTIM_MATCH0		(*((volatile unsigned int *) (MSTIM_BASE + 0x18)))
#define MSTIM_MATCH1		(*((volatile unsigned int *) (MSTIM_BASE + 0x1C)))


/*
** High Speed Timer
*/

#define HSTIM_BASE 0x40038000

#define HSTIM_INT		(*((volatile unsigned int *) (HSTIM_BASE + 0x00)))
#define HSTIM_CTRL		(*((volatile unsigned int *) (HSTIM_BASE + 0x04)))
#define HSTIM_COUNTER		(*((volatile unsigned int *) (HSTIM_BASE + 0x08)))
#define HSTIM_PMATCH		(*((volatile unsigned int *) (HSTIM_BASE + 0x0C)))
#define HSTIM_PCOUNT		(*((volatile unsigned int *) (HSTIM_BASE + 0x10)))
#define HSTIM_MCTRL		(*((volatile unsigned int *) (HSTIM_BASE + 0x14)))
#define HSTIM_MATCH0		(*((volatile unsigned int *) (HSTIM_BASE + 0x18)))
#define HSTIM_MATCH1		(*((volatile unsigned int *) (HSTIM_BASE + 0x1C)))
#define HSTIM_MATCH2		(*((volatile unsigned int *) (HSTIM_BASE + 0x20)))
#define HSTIM_CCR		(*((volatile unsigned int *) (HSTIM_BASE + 0x28)))
#define HSTIM_CR0		(*((volatile unsigned int *) (HSTIM_BASE + 0x2C)))
#define HSTIM_CR1		(*((volatile unsigned int *) (HSTIM_BASE + 0x30)))


/*
** Watchdog timer
*/

#define WDTIM_BASE 0x4003C000

#define WDTIM_INT		(*((volatile unsigned int *) (WDTIM_BASE + 0x00)))
#define WDTIM_CTRL		(*((volatile unsigned int *) (WDTIM_BASE + 0x04)))
#define WDTIM_COUNTER		(*((volatile unsigned int *) (WDTIM_BASE + 0x08)))
#define WDTIM_MCTRL		(*((volatile unsigned int *) (WDTIM_BASE + 0x0C)))
#define WDTIM_MATCH0		(*((volatile unsigned int *) (WDTIM_BASE + 0x10)))
#define WDTIM_EMR		(*((volatile unsigned int *) (WDTIM_BASE + 0x14)))
#define WDTIM_PULSE		(*((volatile unsigned int *) (WDTIM_BASE + 0x18)))
#define WDTIM_RES		(*((volatile unsigned int *) (WDTIM_BASE + 0x1C)))


/*
** A/D Converter
*/

#define ADC_BASE 0x40048000

#define ADSTAT			(*((volatile unsigned int *) (ADC_BASE + 0x00)))
#define ADSEL			(*((volatile unsigned int *) (ADC_BASE + 0x04)))
#define ADCON			(*((volatile unsigned int *) (ADC_BASE + 0x08)))
#define ADDAT			(*((volatile unsigned int *) (ADC_BASE + 0x48)))


/*
** Keyboard Scan
*/

#define KS_BASE 0x40050000

#define KS_DEB			(*((volatile unsigned int *) (KS_BASE + 0x00)))
#define KS_STATE_COND		(*((volatile unsigned int *) (KS_BASE + 0x04)))
#define KS_IRQ			(*((volatile unsigned int *) (KS_BASE + 0x08)))
#define KS_SCAN_CTL		(*((volatile unsigned int *) (KS_BASE + 0x0C)))
#define KS_FAST_TST		(*((volatile unsigned int *) (KS_BASE + 0x10)))
#define KS_MATRIX_DIM		(*((volatile unsigned int *) (KS_BASE + 0x14)))
#define KS_DATA0		(*((volatile unsigned int *) (KS_BASE + 0x40)))
#define KS_DATA1		(*((volatile unsigned int *) (KS_BASE + 0x44)))
#define KS_DATA2		(*((volatile unsigned int *) (KS_BASE + 0x48)))
#define KS_DATA3		(*((volatile unsigned int *) (KS_BASE + 0x4C)))
#define KS_DATA4		(*((volatile unsigned int *) (KS_BASE + 0x50)))
#define KS_DATA5		(*((volatile unsigned int *) (KS_BASE + 0x54)))
#define KS_DATA6		(*((volatile unsigned int *) (KS_BASE + 0x58)))
#define KS_DATA7		(*((volatile unsigned int *) (KS_BASE + 0x5C)))


/*
** UART Control register (general UART control)
*/

#define UARTC_BASE 0x40054000

#define UART_CTRL      		(*((volatile unsigned int *) (UARTC_BASE + 0x00)))
#define UART_CLKMODE   		(*((volatile unsigned int *) (UARTC_BASE + 0x04)))
#define UART_LOOP      		(*((volatile unsigned int *) (UARTC_BASE + 0x08)))


/*
** PWM Pulse Width Modulators
*/

#define PWM_BASE 0x4005C000

#define PWM1_CTRL		(*((volatile unsigned int *) (PWM_BASE + 0x00)))
#define PWM2_CTRL		(*((volatile unsigned int *) (PWM_BASE + 0x04)))


/*
** UART3 Universal Asynchronous Receiver Transmitter 3 (Standard)
*/

#define UART3_BASE 0x40080000

#define UART3_RBR		(*((volatile unsigned int *) (UART3_BASE + 0x00)))
#define UART3_THR		(*((volatile unsigned int *) (UART3_BASE + 0x00)))
#define UART3_DLL		(*((volatile unsigned int *) (UART3_BASE + 0x00)))
#define UART3_IER		(*((volatile unsigned int *) (UART3_BASE + 0x04)))
#define UART3_DLM		(*((volatile unsigned int *) (UART3_BASE + 0x04)))
#define UART3_IIR		(*((volatile unsigned int *) (UART3_BASE + 0x08)))
#define UART3_FCR		(*((volatile unsigned int *) (UART3_BASE + 0x08)))
#define UART3_LCR		(*((volatile unsigned int *) (UART3_BASE + 0x0C)))
#define UART3_LSR		(*((volatile unsigned int *) (UART3_BASE + 0x14)))
#define UART3_RXLEV		(*((volatile unsigned int *) (UART3_BASE + 0x1C)))


/*
** UART4 Universal Asynchronous Receiver Transmitter 4 (Standard)
*/

#define UART4_BASE 0x40088000

#define UART4_RBR		(*((volatile unsigned int *) (UART4_BASE + 0x00)))
#define UART4_THR		(*((volatile unsigned int *) (UART4_BASE + 0x00)))
#define UART4_DLL		(*((volatile unsigned int *) (UART4_BASE + 0x00)))
#define UART4_IER		(*((volatile unsigned int *) (UART4_BASE + 0x04)))
#define UART4_DLM		(*((volatile unsigned int *) (UART4_BASE + 0x04)))
#define UART4_IIR		(*((volatile unsigned int *) (UART4_BASE + 0x08)))
#define UART4_FCR		(*((volatile unsigned int *) (UART4_BASE + 0x08)))
#define UART4_LCR		(*((volatile unsigned int *) (UART4_BASE + 0x0C)))
#define UART4_LSR		(*((volatile unsigned int *) (UART4_BASE + 0x14)))
#define UART4_RXLEV		(*((volatile unsigned int *) (UART4_BASE + 0x1C)))


/*
** UART5 Universal Asynchronous Receiver Transmitter 5 (Standard)
*/

#define UART5_BASE 0x40090000

#define UART5_RBR		(*((volatile unsigned int *) (UART5_BASE + 0x00)))
#define UART5_THR		(*((volatile unsigned int *) (UART5_BASE + 0x00)))
#define UART5_DLL		(*((volatile unsigned int *) (UART5_BASE + 0x00)))
#define UART5_IER		(*((volatile unsigned int *) (UART5_BASE + 0x04)))
#define UART5_DLM		(*((volatile unsigned int *) (UART5_BASE + 0x04)))
#define UART5_IIR		(*((volatile unsigned int *) (UART5_BASE + 0x08)))
#define UART5_FCR		(*((volatile unsigned int *) (UART5_BASE + 0x08)))
#define UART5_LCR		(*((volatile unsigned int *) (UART5_BASE + 0x0C)))
#define UART5_LSR		(*((volatile unsigned int *) (UART5_BASE + 0x14)))
#define UART5_RXLEV		(*((volatile unsigned int *) (UART5_BASE + 0x1C)))


/*
** UART6 Universal Asynchronous Receiver Transmitter 6 (Standard)
*/

#define UART6_BASE 0x40098000

#define UART6_RBR		(*((volatile unsigned int *) (UART6_BASE + 0x00)))
#define UART6_THR		(*((volatile unsigned int *) (UART6_BASE + 0x00)))
#define UART6_DLL		(*((volatile unsigned int *) (UART6_BASE + 0x00)))
#define UART6_IER		(*((volatile unsigned int *) (UART6_BASE + 0x04)))
#define UART6_DLM		(*((volatile unsigned int *) (UART6_BASE + 0x04)))
#define UART6_IIR		(*((volatile unsigned int *) (UART6_BASE + 0x08)))
#define UART6_FCR		(*((volatile unsigned int *) (UART6_BASE + 0x08)))
#define UART6_LCR		(*((volatile unsigned int *) (UART6_BASE + 0x0C)))
#define UART6_LSR		(*((volatile unsigned int *) (UART6_BASE + 0x14)))
#define UART6_RXLEV		(*((volatile unsigned int *) (UART6_BASE + 0x1C)))


/*
** I2C1 Inter-Integrated Circuit interface 1
*/

#define I2C1_BASE 0x400A0000

#define I2C1_RX            	(*((volatile unsigned int *) (I2C1_BASE + 0x00)))
#define I2C1_TX            	(*((volatile unsigned int *) (I2C1_BASE + 0x00)))
#define I2C1_STS           	(*((volatile unsigned int *) (I2C1_BASE + 0x04)))
#define I2C1_CTRL           	(*((volatile unsigned int *) (I2C1_BASE + 0x08)))
#define I2C1_CLK_HI         	(*((volatile unsigned int *) (I2C1_BASE + 0x0C)))
#define I2C1_CLK_LO         	(*((volatile unsigned int *) (I2C1_BASE + 0x10)))


/*
** I2C2 Inter-Integrated Circuit interface 2
*/

#define I2C2_BASE 0x400A8000

#define I2C2_RX            	(*((volatile unsigned int *) (I2C2_BASE + 0x00)))
#define I2C2_TX            	(*((volatile unsigned int *) (I2C2_BASE + 0x00)))
#define I2C2_STS           	(*((volatile unsigned int *) (I2C2_BASE + 0x04)))
#define I2C2_CTRL           	(*((volatile unsigned int *) (I2C2_BASE + 0x08)))
#define I2C2_CLK_HI         	(*((volatile unsigned int *) (I2C2_BASE + 0x0C)))
#define I2C2_CLK_LO         	(*((volatile unsigned int *) (I2C2_BASE + 0x10)))


#endif  // _LPC3180_H
