/**************************************************************************
**                                                                        *
**  FILE        :  lpc29xx.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**		   LPC2917, LPC2919, LPC2921, LPC2923, LPC2925, LPC2927   *
**                 LPC2929, LPC2930 & LPC2939                             *
**                                                                        *
**  Copyright 2008-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC29xx_H
#define _LPC29xx_H


/*
** FMC embedded flash controller configuration registers
*/

#define FMC_BASE 0x20200000

#define FMC_FCTR            	(*((volatile unsigned int  *) (EIC_BASE + 0x000)))	/* R/W control register */
#define FMC_FPTR            	(*((volatile unsigned int  *) (EIC_BASE + 0x008)))	/* R/W program time register */
#define FMC_FBWST           	(*((volatile unsigned int  *) (EIC_BASE + 0x010)))	/* R/W bridge wait state register */
#define FMC_FCRA            	(*((volatile unsigned int  *) (EIC_BASE + 0x01C)))	/* R/W clock divider register */
#define FMC_FMSSTART        	(*((volatile unsigned int  *) (EIC_BASE + 0x020)))	/* R/W BIST start address register */
#define FMC_FMSSTOP         	(*((volatile unsigned int  *) (EIC_BASE + 0x024)))	/* R/W BIST stop address register */
#define FMC_FMSW0           	(*((volatile unsigned int  *) (EIC_BASE + 0x02C)))	/* R   128-bit signature word 0 register */
#define FMC_FMSW1           	(*((volatile unsigned int  *) (EIC_BASE + 0x030)))	/* R   128-bit signature word 1 register */
#define FMC_FMSW2           	(*((volatile unsigned int  *) (EIC_BASE + 0x034)))	/* R   128-bit signature word 2 register */
#define FMC_FMSW3           	(*((volatile unsigned int  *) (EIC_BASE + 0x038)))	/* R   128-bit signature word 3 register */
#define FMC_INT_CLR_ENABLE	(*((volatile unsigned int  *) (EIC_BASE + 0xFD8)))	/* W   clear interrupt enable register */
#define FMC_INT_SET_ENABLE	(*((volatile unsigned int  *) (EIC_BASE + 0xFDC)))	/* W   set interrupt enable register */
#define FMC_INT_STATUS		(*((volatile unsigned int  *) (EIC_BASE + 0xFE0)))	/* R   interrupt status register */
#define FMC_INT_ENABLE		(*((volatile unsigned int  *) (EIC_BASE + 0xFE4)))	/* R   interrupt enable register */
#define FMC_INT_CLR_STATUS	(*((volatile unsigned int  *) (EIC_BASE + 0xFE8)))	/* W   clear interrupt status register */
#define FMC_INT_SET_STATUS	(*((volatile unsigned int  *) (EIC_BASE + 0xFEC)))	/* W   set interrupt status register */


/*
** SMC Static Memory Controller configuration registers
*/

#define SMC_BASE 0x60000000

#define SMC_SMBIDCYR0       	(*((volatile unsigned int  *) (SMC_BASE + 0x000)))	/* R/W idle cycle control register for memory bank 0 */
#define SMC_SMBWST1R0       	(*((volatile unsigned int  *) (SMC_BASE + 0x004)))	/* R/W wait state 1 control register for memory bank 0 */
#define SMC_SMBWST2R0       	(*((volatile unsigned int  *) (SMC_BASE + 0x008)))	/* R/W wait state 2 control register for memory bank 0 */
#define SMC_SMBWSTOENR0     	(*((volatile unsigned int  *) (SMC_BASE + 0x00C)))	/* R/W output enable assertion delay control register for memory bank 0 */
#define SMC_SMBWSTWENR0     	(*((volatile unsigned int  *) (SMC_BASE + 0x010)))	/* R/W write enable assertion delay control register for memory bank 0 */
#define SMC_SMBCR0          	(*((volatile unsigned int  *) (SMC_BASE + 0x014)))	/* R/W configuration register for memory bank 0 */
#define SMC_SMBSR0          	(*((volatile unsigned int  *) (SMC_BASE + 0x018)))	/* R/W status register for memory bank 0 */

#define SMC_SMBIDCYR1       	(*((volatile unsigned int  *) (SMC_BASE + 0x01C)))	/* R/W idle cycle control register for memory bank 1 */
#define SMC_SMBWST1R1       	(*((volatile unsigned int  *) (SMC_BASE + 0x020)))	/* R/W wait state 1 control register for memory bank 1 */
#define SMC_SMBWST2R1       	(*((volatile unsigned int  *) (SMC_BASE + 0x024)))	/* R/W wait state 2 control register for memory bank 1 */
#define SMC_SMBWSTOENR1     	(*((volatile unsigned int  *) (SMC_BASE + 0x028)))	/* R/W output enable assertion delay control register for memory bank 1 */
#define SMC_SMBWSTWENR1     	(*((volatile unsigned int  *) (SMC_BASE + 0x02C)))	/* R/W write enable assertion delay control register for memory bank 1 */
#define SMC_SMBCR1          	(*((volatile unsigned int  *) (SMC_BASE + 0x030)))	/* R/W configuration register for memory bank 1 */
#define SMC_SMBSR1          	(*((volatile unsigned int  *) (SMC_BASE + 0x034)))	/* R/W status register for memory bank 1 */

#define SMC_SMBIDCYR2       	(*((volatile unsigned int  *) (SMC_BASE + 0x038)))	/* R/W idle cycle control register for memory bank 2 */
#define SMC_SMBWST1R2       	(*((volatile unsigned int  *) (SMC_BASE + 0x03C)))	/* R/W wait state 1 control register for memory bank 2 */
#define SMC_SMBWST2R2       	(*((volatile unsigned int  *) (SMC_BASE + 0x040)))	/* R/W wait state 2 control register for memory bank 2 */
#define SMC_SMBWSTOENR2     	(*((volatile unsigned int  *) (SMC_BASE + 0x044)))	/* R/W output enable assertion delay control register for memory bank 2 */
#define SMC_SMBWSTWENR2     	(*((volatile unsigned int  *) (SMC_BASE + 0x048)))	/* R/W write enable assertion delay control register for memory bank 2 */
#define SMC_SMBCR2          	(*((volatile unsigned int  *) (SMC_BASE + 0x04C)))	/* R/W configuration register for memory bank 2 */
#define SMC_SMBSR2          	(*((volatile unsigned int  *) (SMC_BASE + 0x050)))	/* R/W status register for memory bank 2 */

#define SMC_SMBIDCYR3       	(*((volatile unsigned int  *) (SMC_BASE + 0x054)))	/* R/W idle cycle control register for memory bank 3 */
#define SMC_SMBWST1R3       	(*((volatile unsigned int  *) (SMC_BASE + 0x058)))	/* R/W wait state 1 control register for memory bank 3 */
#define SMC_SMBWST2R3       	(*((volatile unsigned int  *) (SMC_BASE + 0x05C)))	/* R/W wait state 2 control register for memory bank 3 */
#define SMC_SMBWSTOENR3     	(*((volatile unsigned int  *) (SMC_BASE + 0x060)))	/* R/W output enable assertion delay control register for memory bank 3 */
#define SMC_SMBWSTWENR3     	(*((volatile unsigned int  *) (SMC_BASE + 0x064)))	/* R/W write enable assertion delay control register for memory bank 3 */
#define SMC_SMBCR3          	(*((volatile unsigned int  *) (SMC_BASE + 0x068)))	/* R/W configuration register for memory bank 3 */
#define SMC_SMBSR3          	(*((volatile unsigned int  *) (SMC_BASE + 0x06C)))	/* R/W status register for memory bank 3 */

#define SMC_SMBIDCYR4       	(*((volatile unsigned int  *) (SMC_BASE + 0x070)))	/* R/W idle cycle control register for memory bank 4 */
#define SMC_SMBWST1R4       	(*((volatile unsigned int  *) (SMC_BASE + 0x074)))	/* R/W wait state 1 control register for memory bank 4 */
#define SMC_SMBWST2R4       	(*((volatile unsigned int  *) (SMC_BASE + 0x078)))	/* R/W wait state 2 control register for memory bank 4 */
#define SMC_SMBWSTOENR4     	(*((volatile unsigned int  *) (SMC_BASE + 0x07C)))	/* R/W output enable assertion delay control register for memory bank 4 */
#define SMC_SMBWSTWENR4     	(*((volatile unsigned int  *) (SMC_BASE + 0x080)))	/* R/W write enable assertion delay control register for memory bank 4 */
#define SMC_SMBCR4          	(*((volatile unsigned int  *) (SMC_BASE + 0x084)))	/* R/W configuration register for memory bank 4 */
#define SMC_SMBSR4          	(*((volatile unsigned int  *) (SMC_BASE + 0x088)))	/* R/W status register for memory bank 4 */

#define SMC_SMBIDCYR5       	(*((volatile unsigned int  *) (SMC_BASE + 0x08C)))	/* R/W idle cycle control register for memory bank 5 */
#define SMC_SMBWST1R5       	(*((volatile unsigned int  *) (SMC_BASE + 0x090)))	/* R/W wait state 1 control register for memory bank 5 */
#define SMC_SMBWST2R5       	(*((volatile unsigned int  *) (SMC_BASE + 0x094)))	/* R/W wait state 2 control register for memory bank 5 */
#define SMC_SMBWSTOENR5     	(*((volatile unsigned int  *) (SMC_BASE + 0x098)))	/* R/W output enable assertion delay control register for memory bank 5 */
#define SMC_SMBWSTWENR5     	(*((volatile unsigned int  *) (SMC_BASE + 0x09C)))	/* R/W write enable assertion delay control register for memory bank 5 */
#define SMC_SMBCR5          	(*((volatile unsigned int  *) (SMC_BASE + 0x0A0)))	/* R/W configuration register for memory bank 5 */
#define SMC_SMBSR5          	(*((volatile unsigned int  *) (SMC_BASE + 0x0A4)))	/* R/W status register for memory bank 5 */

#define SMC_SMBIDCYR6       	(*((volatile unsigned int  *) (SMC_BASE + 0x0A8)))	/* R/W idle cycle control register for memory bank 6 */
#define SMC_SMBWST1R6       	(*((volatile unsigned int  *) (SMC_BASE + 0x0AC)))	/* R/W wait state 1 control register for memory bank 6 */
#define SMC_SMBWST2R6     	(*((volatile unsigned int  *) (SMC_BASE + 0x0B0)))	/* R/W wait state 2 control register for memory bank 6 */
#define SMC_SMBWSTOENR6     	(*((volatile unsigned int  *) (SMC_BASE + 0x0B4)))	/* R/W output enable assertion delay control register for memory bank 6 */
#define SMC_SMBWSTWENR6     	(*((volatile unsigned int  *) (SMC_BASE + 0x0B8)))	/* R/W write enable assertion delay control register for memory bank 6 */
#define SMC_SMBCR6          	(*((volatile unsigned int  *) (SMC_BASE + 0x0BC)))	/* R/W configuration register for memory bank 6 */
#define SMC_SMBSR6          	(*((volatile unsigned int  *) (SMC_BASE + 0x0C0)))	/* R/W status register for memory bank 6 */

#define SMC_SMBIDCYR7       	(*((volatile unsigned int  *) (SMC_BASE + 0x0C4)))	/* R/W idle cycle control register for memory bank 7 */
#define SMC_SMBWST1R7       	(*((volatile unsigned int  *) (SMC_BASE + 0x0C8)))	/* R/W wait state 1 control register for memory bank 7 */
#define SMC_SMBWST2R7       	(*((volatile unsigned int  *) (SMC_BASE + 0x0CC)))	/* R/W wait state 2 control register for memory bank 7 */
#define SMC_SMBWSTOENR7     	(*((volatile unsigned int  *) (SMC_BASE + 0x0D0)))	/* R/W output enable assertion delay control register for memory bank 7 */
#define SMC_SMBWSTWENR7     	(*((volatile unsigned int  *) (SMC_BASE + 0x0D4)))	/* R/W write enable assertion delay control register for memory bank 7 */
#define SMC_SMBCR7          	(*((volatile unsigned int  *) (SMC_BASE + 0x0D8)))	/* R/W configuration register for memory bank 7 */
#define SMC_SMBSR7          	(*((volatile unsigned int  *) (SMC_BASE + 0x0DC)))	/* R/W status register for memory bank 7 */


/*
** SCU System Control Unit
*/

#define SCU_BASE 0xE0001000

#define SCU_SFSP0_BASE		(SCU_BASE + 0x000)
#define SCU_SFSP1_BASE		(SCU_BASE + 0x100)
#define SCU_SFSP2_BASE		(SCU_BASE + 0x200)
#define SCU_SFSP3_BASE		(SCU_BASE + 0x300)

#define SCU_SFSP0_0		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x00)))
#define SCU_SFSP0_1		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x04)))
#define SCU_SFSP0_2		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x08)))
#define SCU_SFSP0_3		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x0C)))
#define SCU_SFSP0_4		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x10)))
#define SCU_SFSP0_5		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x14)))
#define SCU_SFSP0_6		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x18)))
#define SCU_SFSP0_7		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x1C)))
#define SCU_SFSP0_8		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x20)))
#define SCU_SFSP0_9		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x24)))
#define SCU_SFSP0_10		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x28)))
#define SCU_SFSP0_11		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x2C)))
#define SCU_SFSP0_12		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x30)))
#define SCU_SFSP0_13		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x34)))
#define SCU_SFSP0_14		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x38)))
#define SCU_SFSP0_15		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x3C)))
#define SCU_SFSP0_16		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x40)))
#define SCU_SFSP0_17		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x44)))
#define SCU_SFSP0_18		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x48)))
#define SCU_SFSP0_19		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x4C)))
#define SCU_SFSP0_20		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x50)))
#define SCU_SFSP0_21		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x54)))
#define SCU_SFSP0_22		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x58)))
#define SCU_SFSP0_23		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x5C)))
#define SCU_SFSP0_24		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x60)))
#define SCU_SFSP0_25		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x64)))
#define SCU_SFSP0_26		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x68)))
#define SCU_SFSP0_27		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x6C)))
#define SCU_SFSP0_28		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x70)))
#define SCU_SFSP0_29		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x74)))
#define SCU_SFSP0_30		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x78)))
#define SCU_SFSP0_31		(*((volatile unsigned int  *) (SCU_SFSP0_BASE + 0x7C)))

#define SCU_SFSP1_0		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x00)))
#define SCU_SFSP1_1		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x04)))
#define SCU_SFSP1_2		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x08)))
#define SCU_SFSP1_3		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x0C)))
#define SCU_SFSP1_4		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x10)))
#define SCU_SFSP1_5		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x14)))
#define SCU_SFSP1_6		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x18)))
#define SCU_SFSP1_7		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x1C)))
#define SCU_SFSP1_8		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x20)))
#define SCU_SFSP1_9		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x24)))
#define SCU_SFSP1_10		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x28)))
#define SCU_SFSP1_11		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x2C)))
#define SCU_SFSP1_12		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x30)))
#define SCU_SFSP1_13		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x34)))
#define SCU_SFSP1_14		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x38)))
#define SCU_SFSP1_15		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x3C)))
#define SCU_SFSP1_16		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x40)))
#define SCU_SFSP1_17		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x44)))
#define SCU_SFSP1_18		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x48)))
#define SCU_SFSP1_19		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x4C)))
#define SCU_SFSP1_20		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x50)))
#define SCU_SFSP1_21		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x54)))
#define SCU_SFSP1_22		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x58)))
#define SCU_SFSP1_23		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x5C)))
#define SCU_SFSP1_24		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x60)))
#define SCU_SFSP1_25		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x64)))
#define SCU_SFSP1_26		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x68)))
#define SCU_SFSP1_27		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x6C)))
#define SCU_SFSP1_28		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x70)))
#define SCU_SFSP1_29		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x74)))
#define SCU_SFSP1_30		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x78)))
#define SCU_SFSP1_31		(*((volatile unsigned int  *) (SCU_SFSP1_BASE + 0x7C)))

#define SCU_SFSP2_0		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x00)))
#define SCU_SFSP2_1		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x04)))
#define SCU_SFSP2_2		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x08)))
#define SCU_SFSP2_3		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x0C)))
#define SCU_SFSP2_4		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x10)))
#define SCU_SFSP2_5		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x14)))
#define SCU_SFSP2_6		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x18)))
#define SCU_SFSP2_7		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x1C)))
#define SCU_SFSP2_8		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x20)))
#define SCU_SFSP2_9		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x24)))
#define SCU_SFSP2_10		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x28)))
#define SCU_SFSP2_11		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x2C)))
#define SCU_SFSP2_12		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x30)))
#define SCU_SFSP2_13		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x34)))
#define SCU_SFSP2_14		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x38)))
#define SCU_SFSP2_15		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x3C)))
#define SCU_SFSP2_16		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x40)))
#define SCU_SFSP2_17		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x44)))
#define SCU_SFSP2_18		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x48)))
#define SCU_SFSP2_19		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x4C)))
#define SCU_SFSP2_20		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x50)))
#define SCU_SFSP2_21		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x54)))
#define SCU_SFSP2_22		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x58)))
#define SCU_SFSP2_23		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x5C)))
#define SCU_SFSP2_24		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x60)))
#define SCU_SFSP2_25		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x64)))
#define SCU_SFSP2_26		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x68)))
#define SCU_SFSP2_27		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x6C)))
#define SCU_SFSP2_28		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x70)))
#define SCU_SFSP2_29		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x74)))
#define SCU_SFSP2_30		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x78)))
#define SCU_SFSP2_31		(*((volatile unsigned int  *) (SCU_SFSP2_BASE + 0x7C)))

#define SCU_SFSP3_0		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x00)))
#define SCU_SFSP3_1		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x04)))
#define SCU_SFSP3_2		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x08)))
#define SCU_SFSP3_3		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x0C)))
#define SCU_SFSP3_4		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x10)))
#define SCU_SFSP3_5		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x14)))
#define SCU_SFSP3_6		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x18)))
#define SCU_SFSP3_7		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x1C)))
#define SCU_SFSP3_8		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x20)))
#define SCU_SFSP3_9		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x24)))
#define SCU_SFSP3_10		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x28)))
#define SCU_SFSP3_11		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x2C)))
#define SCU_SFSP3_12		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x30)))
#define SCU_SFSP3_13		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x34)))
#define SCU_SFSP3_14		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x38)))
#define SCU_SFSP3_15		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x3C)))
#define SCU_SFSP3_16		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x40)))
#define SCU_SFSP3_17		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x44)))
#define SCU_SFSP3_18		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x48)))
#define SCU_SFSP3_19		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x4C)))
#define SCU_SFSP3_20		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x50)))
#define SCU_SFSP3_21		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x54)))
#define SCU_SFSP3_22		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x58)))
#define SCU_SFSP3_23		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x5C)))
#define SCU_SFSP3_24		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x60)))
#define SCU_SFSP3_25		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x64)))
#define SCU_SFSP3_26		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x68)))
#define SCU_SFSP3_27		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x6C)))
#define SCU_SFSP3_28		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x70)))
#define SCU_SFSP3_29		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x74)))
#define SCU_SFSP3_30		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x78)))
#define SCU_SFSP3_31		(*((volatile unsigned int  *) (SCU_SFSP3_BASE + 0x7C)))


/*
** ER Event Router
*/

#define ER_BASE 0xE0002000

#define ER_PEND             	(*((volatile unsigned int  *) (ER_BASE + 0xC00)))	/* R   event status register */
#define ER_INT_CLR          	(*((volatile unsigned int  *) (ER_BASE + 0xC20)))	/* W   event status clear register */
#define ER_INT_SET          	(*((volatile unsigned int  *) (ER_BASE + 0xC40)))	/* W   event status set register */
#define ER_MASK             	(*((volatile unsigned int  *) (ER_BASE + 0xC60)))	/* R   event enable register */
#define ER_MASK_CLR         	(*((volatile unsigned int  *) (ER_BASE + 0xC80)))	/* W   event enable clear register */
#define ER_MASK_SET         	(*((volatile unsigned int  *) (ER_BASE + 0xCA0)))	/* W   event enable set register */
#define ER_APR              	(*((volatile unsigned int  *) (ER_BASE + 0xCC0)))	/* R/W activation polarity register */
#define ER_ATR              	(*((volatile unsigned int  *) (ER_BASE + 0xCE0)))	/* R/W activation type register */
#define ER_RSR              	(*((volatile unsigned int  *) (ER_BASE + 0xD20)))	/* R/W raw status register */


/*
** WDT WatchDog Timer
*/

#define WDT_BASE 0xE0040000

#define WDT_WTCR             	(*((volatile unsigned int  *) (WDT_BASE + 0x00)))	/* R/W timer control register */
#define WDT_TC             	(*((volatile unsigned int  *) (WDT_BASE + 0x04)))	/* R/W timer counter value */
#define WDT_PR             	(*((volatile unsigned int  *) (WDT_BASE + 0x08)))	/* R/W prescale register */
#define WDT_KEY             	(*((volatile unsigned int  *) (WDT_BASE + 0x38)))	/* R/W watchdog key register */
#define WDT_TIMEOUT            	(*((volatile unsigned int  *) (WDT_BASE + 0x3C)))	/* R/W watchdog time-out register */
#define WDT_DEBUG             	(*((volatile unsigned int  *) (WDT_BASE + 0x40)))	/* R/W watchdog debug register */


/*
** TIMERn Timer
*/

#define TIMER0_BASE 0xE0041000

#define TIMER0_TCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x000)))	/* R/W timer control register */
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x004)))	/* R/W timer counter value */
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x008)))	/* R/W prescale register */
#define TIMER0_MCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x00C)))	/* R/W match control register */
#define TIMER0_EMR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x010)))	/* R/W external match register */
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x014)))	/* R/W match register 0 */
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x018)))	/* R/W match register 1 */
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x01C)))	/* R/W match register 2 */
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x020)))	/* R/W match register 3 */
#define TIMER0_CCR          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x024)))	/* R/W capture control register */
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x028)))	/* R   capture register 0 */
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x02C)))	/* R   capture register 1 */
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x030)))	/* R   capture register 2 */
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x034)))	/* R   capture register 3 */
#define TIMER0_INT_CLR_ENABLE	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFD8)))	/* W   interrupt clear-enable register */
#define TIMER0_INT_SET_ENABLE	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define TIMER0_INT_STATUS	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFE0)))	/* R   interrupt status register */
#define TIMER0_INT_ENABLE	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFE4)))	/* R   interrupt enable register */
#define TIMER0_INT_CLR_STATUS	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define TIMER0_INT_SET_STATUS	(*((volatile unsigned int  *) (TIMER0_BASE + 0xFEC)))	/* W   interrupt set-status register  */

#define TIMER1_BASE 0xE0042000

#define TIMER1_TCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x000)))	/* R/W timer control register */
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x004)))	/* R/W timer counter value */
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x008)))	/* R/W prescale register */
#define TIMER1_MCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x00C)))	/* R/W match control register */
#define TIMER1_EMR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x010)))	/* R/W external match register */
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x014)))	/* R/W match register 0 */
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x018)))	/* R/W match register 1 */
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x01C)))	/* R/W match register 2 */
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x020)))	/* R/W match register 3 */
#define TIMER1_CCR          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x024)))	/* R/W capture control register */
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x028)))	/* R   capture register 0 */
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x02C)))	/* R   capture register 1 */
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x030)))	/* R   capture register 2 */
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x034)))	/* R   capture register 3 */
#define TIMER1_INT_CLR_ENABLE	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFD8)))	/* W   interrupt clear-enable register */
#define TIMER1_INT_SET_ENABLE	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define TIMER1_INT_STATUS	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFE0)))	/* R   interrupt status register */
#define TIMER1_INT_ENABLE	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFE4)))	/* R   interrupt enable register */
#define TIMER1_INT_CLR_STATUS	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define TIMER1_INT_SET_STATUS	(*((volatile unsigned int  *) (TIMER1_BASE + 0xFEC)))	/* W   interrupt set-status register  */

#define TIMER2_BASE 0xE0043000

#define TIMER2_TCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x000)))	/* R/W timer control register */
#define TIMER2_TC           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x004)))	/* R/W timer counter value */
#define TIMER2_PR           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x008)))	/* R/W prescale register */
#define TIMER2_MCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x00C)))	/* R/W match control register */
#define TIMER2_EMR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x010)))	/* R/W external match register */
#define TIMER2_MR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x014)))	/* R/W match register 0 */
#define TIMER2_MR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x018)))	/* R/W match register 1 */
#define TIMER2_MR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x01C)))	/* R/W match register 2 */
#define TIMER2_MR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x020)))	/* R/W match register 3 */
#define TIMER2_CCR          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x024)))	/* R/W capture control register */
#define TIMER2_CR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x028)))	/* R   capture register 0 */
#define TIMER2_CR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x02C)))	/* R   capture register 1 */
#define TIMER2_CR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x030)))	/* R   capture register 2 */
#define TIMER2_CR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x034)))	/* R   capture register 3 */
#define TIMER2_INT_CLR_ENABLE	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFD8)))	/* W   interrupt clear-enable register */
#define TIMER2_INT_SET_ENABLE	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define TIMER2_INT_STATUS	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFE0)))	/* R   interrupt status register */
#define TIMER2_INT_ENABLE	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFE4)))	/* R   interrupt enable register */
#define TIMER2_INT_CLR_STATUS	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define TIMER2_INT_SET_STATUS	(*((volatile unsigned int  *) (TIMER2_BASE + 0xFEC)))	/* W   interrupt set-status register  */

#define TIMER3_BASE 0xE0044000

#define TIMER3_TCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x000)))	/* R/W timer control register */
#define TIMER3_TC           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x004)))	/* R/W timer counter value */
#define TIMER3_PR           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x008)))	/* R/W prescale register */
#define TIMER3_MCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x00C)))	/* R/W match control register */
#define TIMER3_EMR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x010)))	/* R/W external match register */
#define TIMER3_MR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x014)))	/* R/W match register 0 */
#define TIMER3_MR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x018)))	/* R/W match register 1 */
#define TIMER3_MR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x01C)))	/* R/W match register 2 */
#define TIMER3_MR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x020)))	/* R/W match register 3 */
#define TIMER3_CCR          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x024)))	/* R/W capture control register */
#define TIMER3_CR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x028)))	/* R   capture register 0 */
#define TIMER3_CR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x02C)))	/* R   capture register 1 */
#define TIMER3_CR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x030)))	/* R   capture register 2 */
#define TIMER3_CR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x034)))	/* R   capture register 3 */
#define TIMER3_INT_CLR_ENABLE	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFD8)))	/* W   interrupt clear-enable register */
#define TIMER3_INT_SET_ENABLE	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define TIMER3_INT_STATUS	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFE0)))	/* R   interrupt status register */
#define TIMER3_INT_ENABLE	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFE4)))	/* R   interrupt enable register */
#define TIMER3_INT_CLR_STATUS	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define TIMER3_INT_SET_STATUS	(*((volatile unsigned int  *) (TIMER3_BASE + 0xFEC)))	/* W   interrupt set-status register  */

				 
/*
** UART0 Universal Asynchronous Receiver/Transmitter 0
*/

#define UART0_BASE 0xE0045000

#define UART0_RBR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_THR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_DLL		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_IER		(*((volatile unsigned int  *) (UART0_BASE + 0x04)))
#define UART0_DLM		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_IIR		(*((volatile unsigned int  *) (UART0_BASE + 0x08)))
#define UART0_FCR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_LCR		(*((volatile unsigned char *) (UART0_BASE + 0x0C)))
#define UART0_LSR		(*((volatile unsigned char *) (UART0_BASE + 0x14)))
#define UART0_SCR		(*((volatile unsigned char *) (UART0_BASE + 0x1C)))
#define UART0_ACR               (*((volatile unsigned int  *) (UART0_BASE + 0x20)))
#define UART0_FDR               (*((volatile unsigned int  *) (UART0_BASE + 0x28)))
#define UART0_TER               (*((volatile unsigned char *) (UART0_BASE + 0x30)))
#define UART0_RS485CTRL		(*((volatile unsigned int  *) (UART0_BASE + 0x4C)))
#define UART0_ADRMATCH		(*((volatile unsigned char *) (UART0_BASE + 0x50)))


/*
** UART1 Universal Asynchronous Receiver/Transmitter 1
*/

#define UART1_BASE 0xE0046000

#define UART1_RBR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_THR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_DLL		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_IER		(*((volatile unsigned int  *) (UART1_BASE + 0x04)))
#define UART1_DLM		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_IIR		(*((volatile unsigned int  *) (UART1_BASE + 0x08)))
#define UART1_FCR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_LCR		(*((volatile unsigned char *) (UART1_BASE + 0x0C)))
#define UART1_LSR		(*((volatile unsigned char *) (UART1_BASE + 0x14)))
#define UART1_SCR		(*((volatile unsigned char *) (UART1_BASE + 0x1C)))
#define UART1_ACR               (*((volatile unsigned int  *) (UART1_BASE + 0x20)))
#define UART1_FDR               (*((volatile unsigned int  *) (UART1_BASE + 0x28)))
#define UART1_TER               (*((volatile unsigned char *) (UART1_BASE + 0x30)))
#define UART1_RS485CTRL		(*((volatile unsigned int  *) (UART1_BASE + 0x4C)))
#define UART1_ADRMATCH		(*((volatile unsigned char *) (UART1_BASE + 0x50)))


/*
** SPI0 Serial Peripheral Interface 0
*/

#define SPI0_BASE 0xE0047000

#define SPI0_CONFIG		(*((volatile unsigned int  *) (SPI0_BASE + 0x000)))
#define SPI0_SLV_ENABLE		(*((volatile unsigned int  *) (SPI0_BASE + 0x004)))
#define SPI0_TX_FIFO_FLUSH	(*((volatile unsigned int  *) (SPI0_BASE + 0x008)))
#define SPI0_FIFO_DATA		(*((volatile unsigned int  *) (SPI0_BASE + 0x00C)))
#define SPI0_RX_FIFO_POP	(*((volatile unsigned int  *) (SPI0_BASE + 0x010)))
#define SPI0_RX_FIFO_READMODE	(*((volatile unsigned int  *) (SPI0_BASE + 0x014)))
#define SPI0_DMA_SETTINGS	(*((volatile unsigned int  *) (SPI0_BASE + 0x018)))
#define SPI0_STATUS		(*((volatile unsigned int  *) (SPI0_BASE + 0x01C)))
#define SPI0_SLV0_SETTINGS1	(*((volatile unsigned int  *) (SPI0_BASE + 0x024)))
#define SPI0_SLV0_SETTINGS2	(*((volatile unsigned int  *) (SPI0_BASE + 0x028)))
#define SPI0_SLV1_SETTINGS1	(*((volatile unsigned int  *) (SPI0_BASE + 0x02C)))
#define SPI0_SLV1_SETTINGS2	(*((volatile unsigned int  *) (SPI0_BASE + 0x030)))
#define SPI0_SLV2_SETTINGS1	(*((volatile unsigned int  *) (SPI0_BASE + 0x034)))
#define SPI0_SLV2_SETTINGS2	(*((volatile unsigned int  *) (SPI0_BASE + 0x038)))
#define SPI0_SLV3_SETTINGS1	(*((volatile unsigned int  *) (SPI0_BASE + 0x03C)))
#define SPI0_SLV3_SETTINGS2	(*((volatile unsigned int  *) (SPI0_BASE + 0x040)))
#define SPI0_INT_THRESHOLD	(*((volatile unsigned int  *) (SPI0_BASE + 0xFD4)))
#define SPI0_INT_CLR_ENABLE	(*((volatile unsigned int  *) (SPI0_BASE + 0xFD8)))
#define SPI0_INT_SET_ENABLE	(*((volatile unsigned int  *) (SPI0_BASE + 0xFDC)))
#define SPI0_INT_STATUS		(*((volatile unsigned int  *) (SPI0_BASE + 0xFE0)))
#define SPI0_INT_ENABLE		(*((volatile unsigned int  *) (SPI0_BASE + 0xFE4)))
#define SPI0_INT_CLR_STATUS	(*((volatile unsigned int  *) (SPI0_BASE + 0xFE8)))
#define SPI0_INT_SET_STATUS	(*((volatile unsigned int  *) (SPI0_BASE + 0xFEC)))


/*
** SPI1 Serial Peripheral Interface 1
*/

#define SPI1_BASE 0xE0048000

#define SPI1_CONFIG		(*((volatile unsigned int  *) (SPI1_BASE + 0x000)))
#define SPI1_SLV_ENABLE		(*((volatile unsigned int  *) (SPI1_BASE + 0x004)))
#define SPI1_TX_FIFO_FLUSH	(*((volatile unsigned int  *) (SPI1_BASE + 0x008)))
#define SPI1_FIFO_DATA		(*((volatile unsigned int  *) (SPI1_BASE + 0x00C)))
#define SPI1_RX_FIFO_POP	(*((volatile unsigned int  *) (SPI1_BASE + 0x010)))
#define SPI1_RX_FIFO_READMODE	(*((volatile unsigned int  *) (SPI1_BASE + 0x014)))
#define SPI1_DMA_SETTINGS	(*((volatile unsigned int  *) (SPI1_BASE + 0x018)))
#define SPI1_STATUS		(*((volatile unsigned int  *) (SPI1_BASE + 0x01C)))
#define SPI1_SLV0_SETTINGS1	(*((volatile unsigned int  *) (SPI1_BASE + 0x024)))
#define SPI1_SLV0_SETTINGS2	(*((volatile unsigned int  *) (SPI1_BASE + 0x028)))
#define SPI1_SLV1_SETTINGS1	(*((volatile unsigned int  *) (SPI1_BASE + 0x02C)))
#define SPI1_SLV1_SETTINGS2	(*((volatile unsigned int  *) (SPI1_BASE + 0x030)))
#define SPI1_SLV2_SETTINGS1	(*((volatile unsigned int  *) (SPI1_BASE + 0x034)))
#define SPI1_SLV2_SETTINGS2	(*((volatile unsigned int  *) (SPI1_BASE + 0x038)))
#define SPI1_SLV3_SETTINGS1	(*((volatile unsigned int  *) (SPI1_BASE + 0x03C)))
#define SPI1_SLV3_SETTINGS2	(*((volatile unsigned int  *) (SPI1_BASE + 0x040)))
#define SPI1_INT_THRESHOLD	(*((volatile unsigned int  *) (SPI1_BASE + 0xFD4)))
#define SPI1_INT_CLR_ENABLE	(*((volatile unsigned int  *) (SPI1_BASE + 0xFD8)))
#define SPI1_INT_SET_ENABLE	(*((volatile unsigned int  *) (SPI1_BASE + 0xFDC)))
#define SPI1_INT_STATUS		(*((volatile unsigned int  *) (SPI1_BASE + 0xFE0)))
#define SPI1_INT_ENABLE		(*((volatile unsigned int  *) (SPI1_BASE + 0xFE4)))
#define SPI1_INT_CLR_STATUS	(*((volatile unsigned int  *) (SPI1_BASE + 0xFE8)))
#define SPI1_INT_SET_STATUS	(*((volatile unsigned int  *) (SPI1_BASE + 0xFEC)))


/*
** SPI2 Serial Peripheral Interface 2
*/

#define SPI2_BASE 0xE0049000

#define SPI2_CONFIG		(*((volatile unsigned int  *) (SPI2_BASE + 0x000)))
#define SPI2_SLV_ENABLE		(*((volatile unsigned int  *) (SPI2_BASE + 0x004)))
#define SPI2_TX_FIFO_FLUSH	(*((volatile unsigned int  *) (SPI2_BASE + 0x008)))
#define SPI2_FIFO_DATA		(*((volatile unsigned int  *) (SPI2_BASE + 0x00C)))
#define SPI2_RX_FIFO_POP	(*((volatile unsigned int  *) (SPI2_BASE + 0x010)))
#define SPI2_RX_FIFO_READMODE	(*((volatile unsigned int  *) (SPI2_BASE + 0x014)))
#define SPI2_DMA_SETTINGS	(*((volatile unsigned int  *) (SPI2_BASE + 0x018)))
#define SPI2_STATUS		(*((volatile unsigned int  *) (SPI2_BASE + 0x01C)))
#define SPI2_SLV0_SETTINGS1	(*((volatile unsigned int  *) (SPI2_BASE + 0x024)))
#define SPI2_SLV0_SETTINGS2	(*((volatile unsigned int  *) (SPI2_BASE + 0x028)))
#define SPI2_SLV1_SETTINGS1	(*((volatile unsigned int  *) (SPI2_BASE + 0x02C)))
#define SPI2_SLV1_SETTINGS2	(*((volatile unsigned int  *) (SPI2_BASE + 0x030)))
#define SPI2_SLV2_SETTINGS1	(*((volatile unsigned int  *) (SPI2_BASE + 0x034)))
#define SPI2_SLV2_SETTINGS2	(*((volatile unsigned int  *) (SPI2_BASE + 0x038)))
#define SPI2_SLV3_SETTINGS1	(*((volatile unsigned int  *) (SPI2_BASE + 0x03C)))
#define SPI2_SLV3_SETTINGS2	(*((volatile unsigned int  *) (SPI2_BASE + 0x040)))
#define SPI2_INT_THRESHOLD	(*((volatile unsigned int  *) (SPI2_BASE + 0xFD4)))
#define SPI2_INT_CLR_ENABLE	(*((volatile unsigned int  *) (SPI2_BASE + 0xFD8)))
#define SPI2_INT_SET_ENABLE	(*((volatile unsigned int  *) (SPI2_BASE + 0xFDC)))
#define SPI2_INT_STATUS		(*((volatile unsigned int  *) (SPI2_BASE + 0xFE0)))
#define SPI2_INT_ENABLE		(*((volatile unsigned int  *) (SPI2_BASE + 0xFE4)))
#define SPI2_INT_CLR_STATUS	(*((volatile unsigned int  *) (SPI2_BASE + 0xFE8)))
#define SPI2_INT_SET_STATUS	(*((volatile unsigned int  *) (SPI2_BASE + 0xFEC)))


/*
** GPIOn General Purpose I/O
*/

#define GPIO0_BASE 0xE004A000

#define GPIO0_PINS          	(*((volatile unsigned int  *) (GPIO0_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO0_OR            	(*((volatile unsigned int  *) (GPIO0_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO0_DR            	(*((volatile unsigned int  *) (GPIO0_BASE + 0x8)))	/* R/W DR port direction register */

#define GPIO1_BASE 0xE004B000

#define GPIO1_PINS          	(*((volatile unsigned int  *) (GPIO1_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO1_OR            	(*((volatile unsigned int  *) (GPIO1_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO1_DR            	(*((volatile unsigned int  *) (GPIO1_BASE + 0x8)))	/* R/W DR port direction register */

#define GPIO2_BASE 0xE004C000

#define GPIO2_PINS          	(*((volatile unsigned int  *) (GPIO2_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO2_OR            	(*((volatile unsigned int  *) (GPIO2_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO2_DR            	(*((volatile unsigned int  *) (GPIO2_BASE + 0x8)))	/* R/W DR port direction register */

#define GPIO3_BASE 0xE004D000

#define GPIO3_PINS          	(*((volatile unsigned int  *) (GPIO3_BASE + 0x0)))	/* R   PINS port input register */
#define GPIO3_OR            	(*((volatile unsigned int  *) (GPIO3_BASE + 0x4)))	/* R/W OR port output register */
#define GPIO3_DR            	(*((volatile unsigned int  *) (GPIO3_BASE + 0x8)))	/* R/W DR port direction register */


/*
** CANCn CAN controller
*/

#define CAN0_BASE 0xE0080000

#define CAN0_MODE        	(*((volatile unsigned int  *) (CAN0_BASE + 0x00)))	/* R/W mode register */
#define CAN0_CMD         	(*((volatile unsigned int  *) (CAN0_BASE + 0x04)))	/* W   command register */
#define CAN0_GS          	(*((volatile unsigned int  *) (CAN0_BASE + 0x08)))	/* R/W global status register */
#define CAN0_IC          	(*((volatile unsigned int  *) (CAN0_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CAN0_IE          	(*((volatile unsigned int  *) (CAN0_BASE + 0x10)))	/* R/W interrupt enable register */
#define CAN0_BT          	(*((volatile unsigned int  *) (CAN0_BASE + 0x14)))	/* R/W bus timing register */
#define CAN0_EWL         	(*((volatile unsigned int  *) (CAN0_BASE + 0x18)))	/* R/W error warning limit register */
#define CAN0_STAT        	(*((volatile unsigned int  *) (CAN0_BASE + 0x1C)))	/* R   status register */
#define CAN0_RXBMI       	(*((volatile unsigned int  *) (CAN0_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CAN0_RXBID       	(*((volatile unsigned int  *) (CAN0_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CAN0_RXBDA       	(*((volatile unsigned int  *) (CAN0_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CAN0_RXBDB       	(*((volatile unsigned int  *) (CAN0_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CAN0_TXB1MI      	(*((volatile unsigned int  *) (CAN0_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CAN0_TXB1ID      	(*((volatile unsigned int  *) (CAN0_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CAN0_TXB1DA      	(*((volatile unsigned int  *) (CAN0_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CAN0_TXB1DB      	(*((volatile unsigned int  *) (CAN0_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CAN0_TXB2MI      	(*((volatile unsigned int  *) (CAN0_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CAN0_TXB2ID      	(*((volatile unsigned int  *) (CAN0_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CAN0_TXB2DA      	(*((volatile unsigned int  *) (CAN0_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CAN0_TXB2DB      	(*((volatile unsigned int  *) (CAN0_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CAN0_TXB3MI      	(*((volatile unsigned int  *) (CAN0_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CAN0_TXB3ID      	(*((volatile unsigned int  *) (CAN0_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CAN0_TXB3DA      	(*((volatile unsigned int  *) (CAN0_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CAN0_TXB3DB      	(*((volatile unsigned int  *) (CAN0_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */

#define CAN1_BASE 0xE0081000

#define CAN1_MODE        	(*((volatile unsigned int  *) (CAN1_BASE + 0x00)))	/* R/W mode register */
#define CAN1_CMD         	(*((volatile unsigned int  *) (CAN1_BASE + 0x04)))	/* W   command register */
#define CAN1_GS          	(*((volatile unsigned int  *) (CAN1_BASE + 0x08)))	/* R/W global status register */
#define CAN1_IC          	(*((volatile unsigned int  *) (CAN1_BASE + 0x0C)))	/* R   interrupt and capture register */
#define CAN1_IE          	(*((volatile unsigned int  *) (CAN1_BASE + 0x10)))	/* R/W interrupt enable register */
#define CAN1_BT          	(*((volatile unsigned int  *) (CAN1_BASE + 0x14)))	/* R/W bus timing register */
#define CAN1_EWL         	(*((volatile unsigned int  *) (CAN1_BASE + 0x18)))	/* R/W error warning limit register */
#define CAN1_STAT        	(*((volatile unsigned int  *) (CAN1_BASE + 0x1C)))	/* R   status register */
#define CAN1_RXBMI       	(*((volatile unsigned int  *) (CAN1_BASE + 0x20)))	/* R/W receive buffer message info register */
#define CAN1_RXBID       	(*((volatile unsigned int  *) (CAN1_BASE + 0x24)))	/* R/W receive buffer identifier register */
#define CAN1_RXBDA       	(*((volatile unsigned int  *) (CAN1_BASE + 0x28)))	/* R/W receive buffer data A register */
#define CAN1_RXBDB       	(*((volatile unsigned int  *) (CAN1_BASE + 0x2C)))	/* R/W receive buffer data B register */
#define CAN1_TXB1MI      	(*((volatile unsigned int  *) (CAN1_BASE + 0x30)))	/* R/W transmit buffer 1 message info register */
#define CAN1_TXB1ID      	(*((volatile unsigned int  *) (CAN1_BASE + 0x34)))	/* R/W transmit buffer 1 identifier register */
#define CAN1_TXB1DA      	(*((volatile unsigned int  *) (CAN1_BASE + 0x38)))	/* R/W transmit buffer 1 data A register */
#define CAN1_TXB1DB      	(*((volatile unsigned int  *) (CAN1_BASE + 0x3C)))	/* R/W transmit buffer 1 data B register */
#define CAN1_TXB2MI      	(*((volatile unsigned int  *) (CAN1_BASE + 0x40)))	/* R/W transmit buffer 2 message info register */
#define CAN1_TXB2ID      	(*((volatile unsigned int  *) (CAN1_BASE + 0x44)))	/* R/W transmit buffer 2 identifier register */
#define CAN1_TXB2DA      	(*((volatile unsigned int  *) (CAN1_BASE + 0x48)))	/* R/W transmit buffer 2 data A register */
#define CAN1_TXB2DB      	(*((volatile unsigned int  *) (CAN1_BASE + 0x4C)))	/* R/W transmit buffer 2 data B register */
#define CAN1_TXB3MI      	(*((volatile unsigned int  *) (CAN1_BASE + 0x50)))	/* R/W transmit buffer 3 message info register */
#define CAN1_TXB3ID      	(*((volatile unsigned int  *) (CAN1_BASE + 0x54)))	/* R/W transmit buffer 3 identifier register */
#define CAN1_TXB3DA      	(*((volatile unsigned int  *) (CAN1_BASE + 0x58)))	/* R/W transmit buffer 3 data A register */
#define CAN1_TXB3DB      	(*((volatile unsigned int  *) (CAN1_BASE + 0x5C)))	/* R/W transmit buffer 3 data B register */


/*
** CANAFM CAN Acceptance Filter Memory (ID-look-up table)
*/

#define CANAFM_BASE 0xE0085000
 

/*
** CANAFR CAN Acceptance Filter registers
*/

#define CANAFR_BASE 0xE0086000

#define CANAFR_MODE       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x00)))	/* R/W mode register */
#define CANAFR_SFESA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x04)))	/* R/W standard frame explicit start address register */
#define CANAFR_SFGSA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x08)))	/* R/W standard frame group start address register */
#define CANAFR_EFESA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x0C)))	/* R/W extended frame explicit start address register */
#define CANAFR_EFGSA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x10)))	/* R/W extended frame group start address register */
#define CANAFR_EOTA       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x14)))	/* R/W end of table address register */
#define CANAFR_LUTEA      	(*((volatile unsigned int  *) (CANAFR_BASE + 0x18)))	/* R   look-up table error address register */
#define CANAFR_LUTE       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x1C)))	/* R   look-up table error register */


/*
** CANCS CAN Central Status registers
*/

#define CANCS_BASE 0xE0087000

#define CANCS_TS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x0)))	/* R   transmit status register */
#define CANCS_RS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x4)))	/* R   receive status register */
#define CANCS_MS         	(*((volatile unsigned int  *) (CANCS_BASE + 0x8)))	/* R   miscellaneous status register */


/*
** I2C0 Inter-Integrated Circuit interface 0
*/

#define I2C0_BASE 0xE0082000

#define I2C0_CONSET     	(*((volatile unsigned char *) (I2C0_BASE + 0x00)))
#define I2C0_STAT       	(*((volatile unsigned char *) (I2C0_BASE + 0x04)))
#define I2C0_DAT        	(*((volatile unsigned char *) (I2C0_BASE + 0x08)))
#define I2C0_ADR        	(*((volatile unsigned char *) (I2C0_BASE + 0x0C)))
#define I2C0_SCLH       	(*((volatile unsigned short*) (I2C0_BASE + 0x10)))
#define I2C0_SCLL       	(*((volatile unsigned short*) (I2C0_BASE + 0x14)))
#define I2C0_CONCLR     	(*((volatile unsigned char *) (I2C0_BASE + 0x18)))
#define I2C0_MMCTRL	     	(*((volatile unsigned char *) (I2C0_BASE + 0x1C)))
#define I2C0_ADR0        	(*((volatile unsigned char *) (I2C0_BASE + 0x0C)))
#define I2C0_ADR1	     	(*((volatile unsigned char *) (I2C0_BASE + 0x20)))
#define I2C0_ADR2	     	(*((volatile unsigned char *) (I2C0_BASE + 0x24)))
#define I2C0_ADR3	     	(*((volatile unsigned char *) (I2C0_BASE + 0x28)))
#define I2C0_DATA_BUFFER     	(*((volatile unsigned char *) (I2C0_BASE + 0x2C)))
#define I2C0_MASK0	     	(*((volatile unsigned int  *) (I2C0_BASE + 0x30)))
#define I2C0_MASK1	     	(*((volatile unsigned int  *) (I2C0_BASE + 0x34)))
#define I2C0_MASK2	     	(*((volatile unsigned int  *) (I2C0_BASE + 0x38)))
#define I2C0_MASK3	     	(*((volatile unsigned int  *) (I2C0_BASE + 0x3C)))


/*
** I2C1 Inter-Integrated Circuit interface 1
*/

#define I2C1_BASE 0xE0082000

#define I2C1_CONSET     	(*((volatile unsigned char *) (I2C1_BASE + 0x00)))
#define I2C1_STAT       	(*((volatile unsigned char *) (I2C1_BASE + 0x04)))
#define I2C1_DAT        	(*((volatile unsigned char *) (I2C1_BASE + 0x08)))
#define I2C1_ADR        	(*((volatile unsigned char *) (I2C1_BASE + 0x0C)))
#define I2C1_SCLH       	(*((volatile unsigned short*) (I2C1_BASE + 0x10)))
#define I2C1_SCLL       	(*((volatile unsigned short*) (I2C1_BASE + 0x14)))
#define I2C1_CONCLR     	(*((volatile unsigned char *) (I2C1_BASE + 0x18)))
#define I2C1_MMCTRL	     	(*((volatile unsigned char *) (I2C1_BASE + 0x1C)))
#define I2C1_ADR0        	(*((volatile unsigned char *) (I2C1_BASE + 0x0C)))
#define I2C1_ADR1	     	(*((volatile unsigned char *) (I2C1_BASE + 0x20)))
#define I2C1_ADR2	     	(*((volatile unsigned char *) (I2C1_BASE + 0x24)))
#define I2C1_ADR3	     	(*((volatile unsigned char *) (I2C1_BASE + 0x28)))
#define I2C1_DATA_BUFFER     	(*((volatile unsigned char *) (I2C1_BASE + 0x2C)))
#define I2C1_MASK0	     	(*((volatile unsigned int  *) (I2C1_BASE + 0x30)))
#define I2C1_MASK1	     	(*((volatile unsigned int  *) (I2C1_BASE + 0x34)))
#define I2C1_MASK2	     	(*((volatile unsigned int  *) (I2C1_BASE + 0x38)))
#define I2C1_MASK3	     	(*((volatile unsigned int  *) (I2C1_BASE + 0x3C)))

				 
/*
** LINn LIN master controller
*/

#define LIN0_BASE 0xE0089000

#define LIN0_LMODE          	(*((volatile unsigned int  *) (LIN0_BASE + 0x00)))	/* R/W mode register */
#define LIN0_LCFG           	(*((volatile unsigned int  *) (LIN0_BASE + 0x04)))	/* R/W configuration register */
#define LIN0_LCMD           	(*((volatile unsigned int  *) (LIN0_BASE + 0x08)))	/* R/W command register */
#define LIN0_LFBRG          	(*((volatile unsigned int  *) (LIN0_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN0_LSTAT          	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN0_LIC            	(*((volatile unsigned int  *) (LIN0_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN0_LIE            	(*((volatile unsigned int  *) (LIN0_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN0_LCS            	(*((volatile unsigned int  *) (LIN0_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN0_LTO            	(*((volatile unsigned int  *) (LIN0_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN0_LID            	(*((volatile unsigned int  *) (LIN0_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN0_LDATA          	(*((volatile unsigned int  *) (LIN0_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN0_LDATB          	(*((volatile unsigned int  *) (LIN0_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN0_LDATC          	(*((volatile unsigned int  *) (LIN0_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN0_LDATD          	(*((volatile unsigned int  *) (LIN0_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN0_RBR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN0_THR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN0_IER            	(*((volatile unsigned int  *) (LIN0_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN0_IIR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN0_LCR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN0_LSR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN0_SCR            	(*((volatile unsigned int  *) (LIN0_BASE + 0x2C)))	/* R/W LM = 1 scratch register */

#define LIN1_BASE 0xE008A000

#define LIN1_LMODE          	(*((volatile unsigned int  *) (LIN1_BASE + 0x00)))	/* R/W mode register */
#define LIN1_LCFG           	(*((volatile unsigned int  *) (LIN1_BASE + 0x04)))	/* R/W configuration register */
#define LIN1_LCMD           	(*((volatile unsigned int  *) (LIN1_BASE + 0x08)))	/* R/W command register */
#define LIN1_LFBRG          	(*((volatile unsigned int  *) (LIN1_BASE + 0x0C)))	/* R/W fractional baud rate generator register */
#define LIN1_LSTAT          	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* R   LM = 0 status register */
#define LIN1_LIC            	(*((volatile unsigned int  *) (LIN1_BASE + 0x14)))	/* R   LM = 0 interrupt and capture register */
#define LIN1_LIE            	(*((volatile unsigned int  *) (LIN1_BASE + 0x18)))	/* R/W LM = 0 interrupt enable register */
#define LIN1_LCS            	(*((volatile unsigned int  *) (LIN1_BASE + 0x20)))	/* R/W LM = 0 check sum register */
#define LIN1_LTO            	(*((volatile unsigned int  *) (LIN1_BASE + 0x24)))	/* R/W LM = 0 time-out register */
#define LIN1_LID            	(*((volatile unsigned int  *) (LIN1_BASE + 0x28)))	/* R/W LM = 0 message buffer identifier register */
#define LIN1_LDATA          	(*((volatile unsigned int  *) (LIN1_BASE + 0x2C)))	/* R/W LM = 0 message buffer data A register */
#define LIN1_LDATB          	(*((volatile unsigned int  *) (LIN1_BASE + 0x30)))	/* R/W LM = 0 message buffer data B register */
#define LIN1_LDATC          	(*((volatile unsigned int  *) (LIN1_BASE + 0x34)))	/* R/W LM = 0 message buffer data C register */
#define LIN1_LDATD          	(*((volatile unsigned int  *) (LIN1_BASE + 0x38)))	/* R/W LM = 0 message buffer data D register */
#define LIN1_RBR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* R   LM = 1 receiver buffer register */
#define LIN1_THR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x10)))	/* W   LM = 1 transmit holding register */
#define LIN1_IER            	(*((volatile unsigned int  *) (LIN1_BASE + 0x14)))	/* R/W LM = 1 interrupt enable register */
#define LIN1_IIR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x18)))	/* R   LM = 1 interrupt ID register */
#define LIN1_LCR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x1C)))	/* R/W LM = 1 line control register */
#define LIN1_LSR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x24)))	/* R   LM = 1 line status register */
#define LIN1_SCR            	(*((volatile unsigned int  *) (LIN1_BASE + 0x2C)))	/* R/W LM = 1 scratch register */


/*
** MSCSSn Timer
*/

#define MSCSS0_BASE 0xE00C0000

#define MSCSS0_TCR          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x000)))	/* R/W timer control register */
#define MSCSS0_TC           	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x004)))	/* R/W timer counter value */
#define MSCSS0_PR           	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x008)))	/* R/W prescale register */
#define MSCSS0_MCR          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x00C)))	/* R/W match control register */
#define MSCSS0_EMR          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x010)))	/* R/W external match register */
#define MSCSS0_MR0          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x014)))	/* R/W match register 0 */
#define MSCSS0_MR1          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x018)))	/* R/W match register 1 */
#define MSCSS0_MR2          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x01C)))	/* R/W match register 2 */
#define MSCSS0_MR3          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x020)))	/* R/W match register 3 */
#define MSCSS0_CCR          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x024)))	/* R/W capture control register */
#define MSCSS0_CR0          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x028)))	/* R   capture register 0 */
#define MSCSS0_CR1          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x02C)))	/* R   capture register 1 */
#define MSCSS0_CR2          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x030)))	/* R   capture register 2 */
#define MSCSS0_CR3          	(*((volatile unsigned int  *) (MSCSS0_BASE + 0x034)))	/* R   capture register 3 */
#define MSCSS0_INT_CLR_ENABLE	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFD8)))	/* W   interrupt clear-enable register */#define MSCSS0_INT_SET_ENABLE	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define MSCSS0_INT_STATUS	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFE0)))	/* R   interrupt status register */
#define MSCSS0_INT_ENABLE	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFE4)))	/* R   interrupt enable register */
#define MSCSS0_INT_CLR_STATUS	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define MSCSS0_INT_SET_STATUS	(*((volatile unsigned int  *) (MSCSS0_BASE + 0xFEC)))	/* W   interrupt set-status register  */

#define MSCSS1_BASE 0xE00C1000

#define MSCSS1_TCR          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x000)))	/* R/W timer control register */
#define MSCSS1_TC           	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x004)))	/* R/W timer counter value */
#define MSCSS1_PR           	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x008)))	/* R/W prescale register */
#define MSCSS1_MCR          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x00C)))	/* R/W match control register */
#define MSCSS1_EMR          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x010)))	/* R/W external match register */
#define MSCSS1_MR0          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x014)))	/* R/W match register 0 */
#define MSCSS1_MR1          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x018)))	/* R/W match register 1 */
#define MSCSS1_MR2          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x01C)))	/* R/W match register 2 */
#define MSCSS1_MR3          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x020)))	/* R/W match register 3 */
#define MSCSS1_CCR          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x024)))	/* R/W capture control register */
#define MSCSS1_CR0          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x028)))	/* R   capture register 0 */
#define MSCSS1_CR1          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x02C)))	/* R   capture register 1 */
#define MSCSS1_CR2          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x030)))	/* R   capture register 2 */
#define MSCSS1_CR3          	(*((volatile unsigned int  *) (MSCSS1_BASE + 0x034)))	/* R   capture register 3 */
#define MSCSS1_INT_CLR_ENABLE	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFD8)))	/* W   interrupt clear-enable register */
#define MSCSS1_INT_SET_ENABLE	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFDC)))	/* W   interrupt set-enable register */
#define MSCSS1_INT_STATUS	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFE0)))	/* R   interrupt status register */
#define MSCSS1_INT_ENABLE	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFE4)))	/* R   interrupt enable register */
#define MSCSS1_INT_CLR_STATUS	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFE8)))	/* W   interrupt clear-status register  */
#define MSCSS1_INT_SET_STATUS	(*((volatile unsigned int  *) (MSCSS1_BASE + 0xFEC)))	/* W   interrupt set-status register  */


/*
** ADC Analog/Digital Converter 0
*/

#define ADC0_BASE 0xE00C2000

#define ADC0_ACC0		(*((volatile unsigned int  *) (ADC0_BASE + 0x000)))
#define ADC0_ACC1		(*((volatile unsigned int  *) (ADC0_BASE + 0x004)))
#define ADC0_ACC2		(*((volatile unsigned int  *) (ADC0_BASE + 0x008)))
#define ADC0_ACC3		(*((volatile unsigned int  *) (ADC0_BASE + 0x00C)))
#define ADC0_ACC4		(*((volatile unsigned int  *) (ADC0_BASE + 0x010)))
#define ADC0_ACC5		(*((volatile unsigned int  *) (ADC0_BASE + 0x014)))
#define ADC0_ACC6		(*((volatile unsigned int  *) (ADC0_BASE + 0x018)))
#define ADC0_ACC7		(*((volatile unsigned int  *) (ADC0_BASE + 0x01C)))
#define ADC0_ACC8		(*((volatile unsigned int  *) (ADC0_BASE + 0x020)))
#define ADC0_ACC9		(*((volatile unsigned int  *) (ADC0_BASE + 0x024)))
#define ADC0_ACC10		(*((volatile unsigned int  *) (ADC0_BASE + 0x028)))
#define ADC0_ACC11		(*((volatile unsigned int  *) (ADC0_BASE + 0x02C)))
#define ADC0_ACC12		(*((volatile unsigned int  *) (ADC0_BASE + 0x030)))
#define ADC0_ACC13		(*((volatile unsigned int  *) (ADC0_BASE + 0x034)))
#define ADC0_ACC14		(*((volatile unsigned int  *) (ADC0_BASE + 0x038)))
#define ADC0_ACC15		(*((volatile unsigned int  *) (ADC0_BASE + 0x03C)))
#define ADC0_COMP0		(*((volatile unsigned int  *) (ADC0_BASE + 0x100)))
#define ADC0_COMP1		(*((volatile unsigned int  *) (ADC0_BASE + 0x104)))
#define ADC0_COMP2		(*((volatile unsigned int  *) (ADC0_BASE + 0x108)))
#define ADC0_COMP3		(*((volatile unsigned int  *) (ADC0_BASE + 0x10C)))
#define ADC0_COMP4		(*((volatile unsigned int  *) (ADC0_BASE + 0x110)))
#define ADC0_COMP5		(*((volatile unsigned int  *) (ADC0_BASE + 0x114)))
#define ADC0_COMP6		(*((volatile unsigned int  *) (ADC0_BASE + 0x118)))
#define ADC0_COMP7		(*((volatile unsigned int  *) (ADC0_BASE + 0x11C)))
#define ADC0_COMP8		(*((volatile unsigned int  *) (ADC0_BASE + 0x120)))
#define ADC0_COMP9		(*((volatile unsigned int  *) (ADC0_BASE + 0x124)))
#define ADC0_COMP10		(*((volatile unsigned int  *) (ADC0_BASE + 0x128)))
#define ADC0_COMP11		(*((volatile unsigned int  *) (ADC0_BASE + 0x12C)))
#define ADC0_COMP12		(*((volatile unsigned int  *) (ADC0_BASE + 0x130)))
#define ADC0_COMP13		(*((volatile unsigned int  *) (ADC0_BASE + 0x134)))
#define ADC0_COMP14		(*((volatile unsigned int  *) (ADC0_BASE + 0x138)))
#define ADC0_COMP15		(*((volatile unsigned int  *) (ADC0_BASE + 0x13C)))
#define ADC0_ADCD0		(*((volatile unsigned int  *) (ADC0_BASE + 0x200)))
#define ADC0_ADCD1		(*((volatile unsigned int  *) (ADC0_BASE + 0x204)))
#define ADC0_ADCD2		(*((volatile unsigned int  *) (ADC0_BASE + 0x208)))
#define ADC0_ADCD3		(*((volatile unsigned int  *) (ADC0_BASE + 0x20C)))
#define ADC0_ADCD4		(*((volatile unsigned int  *) (ADC0_BASE + 0x210)))
#define ADC0_ADCD5		(*((volatile unsigned int  *) (ADC0_BASE + 0x214)))
#define ADC0_ADCD6		(*((volatile unsigned int  *) (ADC0_BASE + 0x218)))
#define ADC0_ADCD7		(*((volatile unsigned int  *) (ADC0_BASE + 0x21C)))
#define ADC0_ADCD8		(*((volatile unsigned int  *) (ADC0_BASE + 0x220)))
#define ADC0_ADCD9		(*((volatile unsigned int  *) (ADC0_BASE + 0x224)))
#define ADC0_ADCD10		(*((volatile unsigned int  *) (ADC0_BASE + 0x228)))
#define ADC0_ADCD11		(*((volatile unsigned int  *) (ADC0_BASE + 0x22C)))
#define ADC0_ADCD12		(*((volatile unsigned int  *) (ADC0_BASE + 0x230)))
#define ADC0_ADCD13		(*((volatile unsigned int  *) (ADC0_BASE + 0x234)))
#define ADC0_ADCD14		(*((volatile unsigned int  *) (ADC0_BASE + 0x238)))
#define ADC0_ADCD15		(*((volatile unsigned int  *) (ADC0_BASE + 0x23C)))
#define ADC0_COMP_STATUS	(*((volatile unsigned int  *) (ADC0_BASE + 0x300)))
#define ADC0_COMP_STATUS_CLR	(*((volatile unsigned int  *) (ADC0_BASE + 0x304)))
#define ADC0_ADC_CONFIG		(*((volatile unsigned int  *) (ADC0_BASE + 0x400)))
#define ADC0_ADC_CONTROL	(*((volatile unsigned int  *) (ADC0_BASE + 0x404)))
#define ADC0_ADC_STATUS		(*((volatile unsigned int  *) (ADC0_BASE + 0x408)))
#define ADC0_INT_CLR_ENABLE	(*((volatile unsigned int  *) (ADC0_BASE + 0xFD8)))
#define ADC0_INT_SET_ENABLE	(*((volatile unsigned int  *) (ADC0_BASE + 0xFDC)))
#define ADC0_INT_STATUS		(*((volatile unsigned int  *) (ADC0_BASE + 0xFE0)))
#define ADC0_INT_ENABLE		(*((volatile unsigned int  *) (ADC0_BASE + 0xFE4)))
#define ADC0_INT_CLR_STATUS	(*((volatile unsigned int  *) (ADC0_BASE + 0xFE8)))
#define ADC0_INT_SET_STATUS	(*((volatile unsigned int  *) (ADC0_BASE + 0xFEC)))


/*
** ADC Analog/Digital Converter 1
*/

#define ADC1_BASE 0xE00C3000

#define ADC1_ACC0		(*((volatile unsigned int  *) (ADC1_BASE + 0x000)))
#define ADC1_ACC1		(*((volatile unsigned int  *) (ADC1_BASE + 0x004)))
#define ADC1_ACC2		(*((volatile unsigned int  *) (ADC1_BASE + 0x008)))
#define ADC1_ACC3		(*((volatile unsigned int  *) (ADC1_BASE + 0x00C)))
#define ADC1_ACC4		(*((volatile unsigned int  *) (ADC1_BASE + 0x010)))
#define ADC1_ACC5		(*((volatile unsigned int  *) (ADC1_BASE + 0x014)))
#define ADC1_ACC6		(*((volatile unsigned int  *) (ADC1_BASE + 0x018)))
#define ADC1_ACC7		(*((volatile unsigned int  *) (ADC1_BASE + 0x01C)))
#define ADC1_ACC8		(*((volatile unsigned int  *) (ADC1_BASE + 0x020)))
#define ADC1_ACC9		(*((volatile unsigned int  *) (ADC1_BASE + 0x024)))
#define ADC1_ACC10		(*((volatile unsigned int  *) (ADC1_BASE + 0x028)))
#define ADC1_ACC11		(*((volatile unsigned int  *) (ADC1_BASE + 0x02C)))
#define ADC1_ACC12		(*((volatile unsigned int  *) (ADC1_BASE + 0x030)))
#define ADC1_ACC13		(*((volatile unsigned int  *) (ADC1_BASE + 0x034)))
#define ADC1_ACC14		(*((volatile unsigned int  *) (ADC1_BASE + 0x038)))
#define ADC1_ACC15		(*((volatile unsigned int  *) (ADC1_BASE + 0x03C)))
#define ADC1_COMP0		(*((volatile unsigned int  *) (ADC1_BASE + 0x100)))
#define ADC1_COMP1		(*((volatile unsigned int  *) (ADC1_BASE + 0x104)))
#define ADC1_COMP2		(*((volatile unsigned int  *) (ADC1_BASE + 0x108)))
#define ADC1_COMP3		(*((volatile unsigned int  *) (ADC1_BASE + 0x10C)))
#define ADC1_COMP4		(*((volatile unsigned int  *) (ADC1_BASE + 0x110)))
#define ADC1_COMP5		(*((volatile unsigned int  *) (ADC1_BASE + 0x114)))
#define ADC1_COMP6		(*((volatile unsigned int  *) (ADC1_BASE + 0x118)))
#define ADC1_COMP7		(*((volatile unsigned int  *) (ADC1_BASE + 0x11C)))
#define ADC1_COMP8		(*((volatile unsigned int  *) (ADC1_BASE + 0x120)))
#define ADC1_COMP9		(*((volatile unsigned int  *) (ADC1_BASE + 0x124)))
#define ADC1_COMP10		(*((volatile unsigned int  *) (ADC1_BASE + 0x128)))
#define ADC1_COMP11		(*((volatile unsigned int  *) (ADC1_BASE + 0x12C)))
#define ADC1_COMP12		(*((volatile unsigned int  *) (ADC1_BASE + 0x130)))
#define ADC1_COMP13		(*((volatile unsigned int  *) (ADC1_BASE + 0x134)))
#define ADC1_COMP14		(*((volatile unsigned int  *) (ADC1_BASE + 0x138)))
#define ADC1_COMP15		(*((volatile unsigned int  *) (ADC1_BASE + 0x13C)))
#define ADC1_ADCD0		(*((volatile unsigned int  *) (ADC1_BASE + 0x200)))
#define ADC1_ADCD1		(*((volatile unsigned int  *) (ADC1_BASE + 0x204)))
#define ADC1_ADCD2		(*((volatile unsigned int  *) (ADC1_BASE + 0x208)))
#define ADC1_ADCD3		(*((volatile unsigned int  *) (ADC1_BASE + 0x20C)))
#define ADC1_ADCD4		(*((volatile unsigned int  *) (ADC1_BASE + 0x210)))
#define ADC1_ADCD5		(*((volatile unsigned int  *) (ADC1_BASE + 0x214)))
#define ADC1_ADCD6		(*((volatile unsigned int  *) (ADC1_BASE + 0x218)))
#define ADC1_ADCD7		(*((volatile unsigned int  *) (ADC1_BASE + 0x21C)))
#define ADC1_ADCD8		(*((volatile unsigned int  *) (ADC1_BASE + 0x220)))
#define ADC1_ADCD9		(*((volatile unsigned int  *) (ADC1_BASE + 0x224)))
#define ADC1_ADCD10		(*((volatile unsigned int  *) (ADC1_BASE + 0x228)))
#define ADC1_ADCD11		(*((volatile unsigned int  *) (ADC1_BASE + 0x22C)))
#define ADC1_ADCD12		(*((volatile unsigned int  *) (ADC1_BASE + 0x230)))
#define ADC1_ADCD13		(*((volatile unsigned int  *) (ADC1_BASE + 0x234)))
#define ADC1_ADCD14		(*((volatile unsigned int  *) (ADC1_BASE + 0x238)))
#define ADC1_ADCD15		(*((volatile unsigned int  *) (ADC1_BASE + 0x23C)))
#define ADC1_COMP_STATUS	(*((volatile unsigned int  *) (ADC1_BASE + 0x300)))
#define ADC1_COMP_STATUS_CLR	(*((volatile unsigned int  *) (ADC1_BASE + 0x304)))
#define ADC1_ADC_CONFIG		(*((volatile unsigned int  *) (ADC1_BASE + 0x400)))
#define ADC1_ADC_CONTROL	(*((volatile unsigned int  *) (ADC1_BASE + 0x404)))
#define ADC1_ADC_STATUS		(*((volatile unsigned int  *) (ADC1_BASE + 0x408)))
#define ADC1_INT_CLR_ENABLE	(*((volatile unsigned int  *) (ADC1_BASE + 0xFD8)))
#define ADC1_INT_SET_ENABLE	(*((volatile unsigned int  *) (ADC1_BASE + 0xFDC)))
#define ADC1_INT_STATUS		(*((volatile unsigned int  *) (ADC1_BASE + 0xFE0)))
#define ADC1_INT_ENABLE		(*((volatile unsigned int  *) (ADC1_BASE + 0xFE4)))
#define ADC1_INT_CLR_STATUS	(*((volatile unsigned int  *) (ADC1_BASE + 0xFE8)))
#define ADC1_INT_SET_STATUS	(*((volatile unsigned int  *) (ADC1_BASE + 0xFEC)))


/*
** ADC Analog/Digital Converter 1
*/

#define ADC2_BASE 0xE00C4000

#define ADC2_ACC0		(*((volatile unsigned int  *) (ADC2_BASE + 0x000)))
#define ADC2_ACC1		(*((volatile unsigned int  *) (ADC2_BASE + 0x004)))
#define ADC2_ACC2		(*((volatile unsigned int  *) (ADC2_BASE + 0x008)))
#define ADC2_ACC3		(*((volatile unsigned int  *) (ADC2_BASE + 0x00C)))
#define ADC2_ACC4		(*((volatile unsigned int  *) (ADC2_BASE + 0x010)))
#define ADC2_ACC5		(*((volatile unsigned int  *) (ADC2_BASE + 0x014)))
#define ADC2_ACC6		(*((volatile unsigned int  *) (ADC2_BASE + 0x018)))
#define ADC2_ACC7		(*((volatile unsigned int  *) (ADC2_BASE + 0x01C)))
#define ADC2_ACC8		(*((volatile unsigned int  *) (ADC2_BASE + 0x020)))
#define ADC2_ACC9		(*((volatile unsigned int  *) (ADC2_BASE + 0x024)))
#define ADC2_ACC10		(*((volatile unsigned int  *) (ADC2_BASE + 0x028)))
#define ADC2_ACC11		(*((volatile unsigned int  *) (ADC2_BASE + 0x02C)))
#define ADC2_ACC12		(*((volatile unsigned int  *) (ADC2_BASE + 0x030)))
#define ADC2_ACC13		(*((volatile unsigned int  *) (ADC2_BASE + 0x034)))
#define ADC2_ACC14		(*((volatile unsigned int  *) (ADC2_BASE + 0x038)))
#define ADC2_ACC15		(*((volatile unsigned int  *) (ADC2_BASE + 0x03C)))
#define ADC2_COMP0		(*((volatile unsigned int  *) (ADC2_BASE + 0x100)))
#define ADC2_COMP1		(*((volatile unsigned int  *) (ADC2_BASE + 0x104)))
#define ADC2_COMP2		(*((volatile unsigned int  *) (ADC2_BASE + 0x108)))
#define ADC2_COMP3		(*((volatile unsigned int  *) (ADC2_BASE + 0x10C)))
#define ADC2_COMP4		(*((volatile unsigned int  *) (ADC2_BASE + 0x110)))
#define ADC2_COMP5		(*((volatile unsigned int  *) (ADC2_BASE + 0x114)))
#define ADC2_COMP6		(*((volatile unsigned int  *) (ADC2_BASE + 0x118)))
#define ADC2_COMP7		(*((volatile unsigned int  *) (ADC2_BASE + 0x11C)))
#define ADC2_COMP8		(*((volatile unsigned int  *) (ADC2_BASE + 0x120)))
#define ADC2_COMP9		(*((volatile unsigned int  *) (ADC2_BASE + 0x124)))
#define ADC2_COMP10		(*((volatile unsigned int  *) (ADC2_BASE + 0x128)))
#define ADC2_COMP11		(*((volatile unsigned int  *) (ADC2_BASE + 0x12C)))
#define ADC2_COMP12		(*((volatile unsigned int  *) (ADC2_BASE + 0x130)))
#define ADC2_COMP13		(*((volatile unsigned int  *) (ADC2_BASE + 0x134)))
#define ADC2_COMP14		(*((volatile unsigned int  *) (ADC2_BASE + 0x138)))
#define ADC2_COMP15		(*((volatile unsigned int  *) (ADC2_BASE + 0x13C)))
#define ADC2_ADCD0		(*((volatile unsigned int  *) (ADC2_BASE + 0x200)))
#define ADC2_ADCD1		(*((volatile unsigned int  *) (ADC2_BASE + 0x204)))
#define ADC2_ADCD2		(*((volatile unsigned int  *) (ADC2_BASE + 0x208)))
#define ADC2_ADCD3		(*((volatile unsigned int  *) (ADC2_BASE + 0x20C)))
#define ADC2_ADCD4		(*((volatile unsigned int  *) (ADC2_BASE + 0x210)))
#define ADC2_ADCD5		(*((volatile unsigned int  *) (ADC2_BASE + 0x214)))
#define ADC2_ADCD6		(*((volatile unsigned int  *) (ADC2_BASE + 0x218)))
#define ADC2_ADCD7		(*((volatile unsigned int  *) (ADC2_BASE + 0x21C)))
#define ADC2_ADCD8		(*((volatile unsigned int  *) (ADC2_BASE + 0x220)))
#define ADC2_ADCD9		(*((volatile unsigned int  *) (ADC2_BASE + 0x224)))
#define ADC2_ADCD10		(*((volatile unsigned int  *) (ADC2_BASE + 0x228)))
#define ADC2_ADCD11		(*((volatile unsigned int  *) (ADC2_BASE + 0x22C)))
#define ADC2_ADCD12		(*((volatile unsigned int  *) (ADC2_BASE + 0x230)))
#define ADC2_ADCD13		(*((volatile unsigned int  *) (ADC2_BASE + 0x234)))
#define ADC2_ADCD14		(*((volatile unsigned int  *) (ADC2_BASE + 0x238)))
#define ADC2_ADCD15		(*((volatile unsigned int  *) (ADC2_BASE + 0x23C)))
#define ADC2_COMP_STATUS	(*((volatile unsigned int  *) (ADC2_BASE + 0x300)))
#define ADC2_COMP_STATUS_CLR	(*((volatile unsigned int  *) (ADC2_BASE + 0x304)))
#define ADC2_ADC_CONFIG		(*((volatile unsigned int  *) (ADC2_BASE + 0x400)))
#define ADC2_ADC_CONTROL	(*((volatile unsigned int  *) (ADC2_BASE + 0x404)))
#define ADC2_ADC_STATUS		(*((volatile unsigned int  *) (ADC2_BASE + 0x408)))
#define ADC2_INT_CLR_ENABLE	(*((volatile unsigned int  *) (ADC2_BASE + 0xFD8)))
#define ADC2_INT_SET_ENABLE	(*((volatile unsigned int  *) (ADC2_BASE + 0xFDC)))
#define ADC2_INT_STATUS		(*((volatile unsigned int  *) (ADC2_BASE + 0xFE0)))
#define ADC2_INT_ENABLE		(*((volatile unsigned int  *) (ADC2_BASE + 0xFE4)))
#define ADC2_INT_CLR_STATUS	(*((volatile unsigned int  *) (ADC2_BASE + 0xFE8)))
#define ADC2_INT_SET_STATUS	(*((volatile unsigned int  *) (ADC2_BASE + 0xFEC)))


/*
** PWM0 Pulse Width Modulator 0
*/

#define PWM0_BASE 0xE00C5000

#define PWM0_MODECTL             (*((volatile unsigned int  *) (PWM0_BASE + 0x000)))     /* R/W Main control register */
#define PWM0_TRPCTL              (*((volatile unsigned int  *) (PWM0_BASE + 0x004)))	/* R/W Controls the behavior of PWM outputs when there is an event on the PWMx TRAP input pin */
#define PWM0_CAPTCTL             (*((volatile unsigned int  *) (PWM0_BASE + 0x008)))	/* R/W Controls the behavior of the Capture_Registers and associated pins */
#define PWM0_CAPTSRC             (*((volatile unsigned int  *) (PWM0_BASE + 0x00C)))	/* R/W Controls the source of the capture events */
#define PWM0_CTRL                (*((volatile unsigned int  *) (PWM0_BASE + 0x010)))	/* R/W Controls the PWM output behavior. */
#define PWM0_PRD                 (*((volatile unsigned int  *) (PWM0_BASE + 0x014)))	/* R/W The cycle period (minus 1) of all PWM output */
#define PWM0_PRSC                (*((volatile unsigned int  *) (PWM0_BASE + 0x018)))	/* R/W The prescale register defines the number of system clock cycles to be counted (PR+1) before the PWM counter increments */
#define PWM0_SYNDEL              (*((volatile unsigned int  *) (PWM0_BASE + 0x01C)))	/* R/W Holds the delay between input and output trigger signals of the synchronization port */
#define PWM0_CNT                 (*((volatile unsigned int  *) (PWM0_BASE + 0x020)))	/* R   The PWM counter increments every Prescale+1 system clock cycles */
#define PWM0_MTCHACT0            (*((volatile unsigned int  *) (PWM0_BASE + 0x100)))	/* R/W Holds the first (activation) match value related to PWM 0 output */
#define PWM0_MTCHACT1            (*((volatile unsigned int  *) (PWM0_BASE + 0x104)))	/* R/W Holds the first (activation) match value related to PWM 1 output */
#define PWM0_MTCHACT2            (*((volatile unsigned int  *) (PWM0_BASE + 0x108)))	/* R/W Holds the first (activation) match value related to PWM 2 output */
#define PWM0_MTCHACT3            (*((volatile unsigned int  *) (PWM0_BASE + 0x10C)))	/* R/W Holds the first (activation) match value related to PWM 3 output */
#define PWM0_MTCHACT4            (*((volatile unsigned int  *) (PWM0_BASE + 0x110)))	/* R/W Holds the first (activation) match value related to PWM 4 output */
#define PWM0_MTCHACT5            (*((volatile unsigned int  *) (PWM0_BASE + 0x114)))	/* R/W Holds the first (activation) match value related to PWM 5 output */
#define PWM0_MTCHDEACT0          (*((volatile unsigned int  *) (PWM0_BASE + 0x200)))	/* R/W Holds the second (de-activation) match value related to PWM 0 output */
#define PWM0_MTCHDEACT1          (*((volatile unsigned int  *) (PWM0_BASE + 0x204)))	/* R/W Holds the second (de-activation) match value related to PWM 1 output */
#define PWM0_MTCHDEACT2          (*((volatile unsigned int  *) (PWM0_BASE + 0x208)))	/* R/W Holds the second (de-activation) match value related to PWM 2 output */
#define PWM0_MTCHDEACT3          (*((volatile unsigned int  *) (PWM0_BASE + 0x20C)))	/* R/W Holds the second (de-activation) match value related to PWM 3 output */
#define PWM0_MTCHDEACT4          (*((volatile unsigned int  *) (PWM0_BASE + 0x210)))	/* R/W Holds the second (de-activation) match value related to PWM 4 output */
#define PWM0_MTCHDEACT5          (*((volatile unsigned int  *) (PWM0_BASE + 0x214)))	/* R/W Holds the second (de-activation) match value related to PWM 5 output */
#define PWM0_CAPT0               (*((volatile unsigned int  *) (PWM0_BASE + 0x300)))	/* R   Holds the captured value on the selected event of capture channel 0 */
#define PWM0_CAPT1               (*((volatile unsigned int  *) (PWM0_BASE + 0x304)))	/* R   Holds the captured value on the selected event of capture channel 1 */
#define PWM0_CAPT2               (*((volatile unsigned int  *) (PWM0_BASE + 0x308)))	/* R   Holds the captured value on the selected event of capture channel 2 */
#define PWM0_CAPT3               (*((volatile unsigned int  *) (PWM0_BASE + 0x30C)))	/* R   Holds the captured value on the selected event of capture channel 3 */
#define PWM0_MODECTLS            (*((volatile unsigned int  *) (PWM0_BASE + 0x800)))	/* R   Mirror the synchronized MODECTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM0_TRPCTLS             (*((volatile unsigned int  *) (PWM0_BASE + 0x804)))	/* R   Mirror the synchronized TRPCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM0_CAPTCTLS            (*((volatile unsigned int  *) (PWM0_BASE + 0x808)))	/* R   Mirror the synchronized CAPTCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM0_CAPTSRCS            (*((volatile unsigned int  *) (PWM0_BASE + 0x80C)))	/* R   Mirror the synchronized CAPTSRC register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM0_CTRLS               (*((volatile unsigned int  *) (PWM0_BASE + 0x810)))	/* R   Mirror the shadowed CTRL register from PWM domain. Stable only if TRANS_ENA is low */
#define PWM0_PRDS                (*((volatile unsigned int  *) (PWM0_BASE + 0x814)))	/* R   Mirror the shadowed PRD register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM0_PRSCS               (*((volatile unsigned int  *) (PWM0_BASE + 0x818)))	/* R   Mirror the shadowed PRSC register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM0_SYNDELS             (*((volatile unsigned int  *) (PWM0_BASE + 0x81C)))	/* R   Mirror the shadowed SYNDEL register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM0_MTCHACTS0           (*((volatile unsigned int  *) (PWM0_BASE + 0x900)))	/* R   Mirror the activation match shadowed value related to PWM 0 output */
#define PWM0_MTCHACTS1           (*((volatile unsigned int  *) (PWM0_BASE + 0x904)))	/* R   Mirror the activation match shadowed value related to PWM 1 output */
#define PWM0_MTCHACTS2           (*((volatile unsigned int  *) (PWM0_BASE + 0x908)))	/* R   Mirror the activation match shadowed value related to PWM 2 output */
#define PWM0_MTCHACTS3           (*((volatile unsigned int  *) (PWM0_BASE + 0x90C)))	/* R   Mirror the activation match shadowed value related to PWM 3 output */
#define PWM0_MTCHACTS4           (*((volatile unsigned int  *) (PWM0_BASE + 0x910)))	/* R   Mirror the activation match shadowed value related to PWM 4 output */
#define PWM0_MTCHACTS5           (*((volatile unsigned int  *) (PWM0_BASE + 0x914)))	/* R   Mirror the activation match shadowed value related to PWM 5 output */
#define PWM0_MTCHDEACTS0         (*((volatile unsigned int  *) (PWM0_BASE + 0xA00)))	/* R   Mirror the de-activation match shadowed value related to PWM 0 output */
#define PWM0_MTCHDEACTS1         (*((volatile unsigned int  *) (PWM0_BASE + 0xA04)))	/* R   Mirror the de-activation match shadowed value related to PWM 1 output */
#define PWM0_MTCHDEACTS2         (*((volatile unsigned int  *) (PWM0_BASE + 0xA08)))	/* R   Mirror the de-activation match shadowed value related to PWM 2 output */
#define PWM0_MTCHDEACTS3         (*((volatile unsigned int  *) (PWM0_BASE + 0xA0C)))	/* R   Mirror the de-activation match shadowed value related to PWM 3 output */
#define PWM0_MTCHDEACTS4         (*((volatile unsigned int  *) (PWM0_BASE + 0xA10)))	/* R   Mirror the de-activation match shadowed value related to PWM 4 output */
#define PWM0_MTCHDEACTS5         (*((volatile unsigned int  *) (PWM0_BASE + 0xA14)))	/* R   Mirror the de-activation match shadowed value related to PWM 5 output */
#define PWM0_INT_CLR_ENABLE      (*((volatile unsigned int  *) (PWM0_BASE + 0xF90)))	/* W   PWM interrupt clear-enable register */
#define PWM0_INT_SET_ENABLE      (*((volatile unsigned int  *) (PWM0_BASE + 0xF94)))	/* W   PWM interrupt set-enable register */
#define PWM0_INT_STATUS          (*((volatile unsigned int  *) (PWM0_BASE + 0xF98)))	/* R   PWM interrupt status register */
#define PWM0_INT_ENABLE          (*((volatile unsigned int  *) (PWM0_BASE + 0xF9C)))	/* R   PWM interrupt enable register */
#define PWM0_INT_CLR_STATUS      (*((volatile unsigned int  *) (PWM0_BASE + 0xFA0)))	/* W   PWM interrupt clear-status register */
#define PWM0_INT_SET_STATUS      (*((volatile unsigned int  *) (PWM0_BASE + 0xFA4)))	/* W   PWM interrupt set-status register */
#define PWM0_INT_MTCH_CLR_ENABLE (*((volatile unsigned int  *) (PWM0_BASE + 0xFA8)))	/* W   Match interrupt clear-enable register */
#define PWM0_INT_MTCH_SET_ENABLE (*((volatile unsigned int  *) (PWM0_BASE + 0xFAC)))	/* W   Match interrupt set enable register */
#define PWM0_INT_MTCH_STATUS     (*((volatile unsigned int  *) (PWM0_BASE + 0xFB0)))	/* R   Match interrupt status register */
#define PWM0_INT_MTCH_ENABLE     (*((volatile unsigned int  *) (PWM0_BASE + 0xFB4)))	/* R   Match interrupt enable register */
#define PWM0_INT_MTCH_CLR_STATUS (*((volatile unsigned int  *) (PWM0_BASE + 0xFB8)))	/* W   Match interrupt clear-status register */
#define PWM0_INT_MTCH_SET_STATUS (*((volatile unsigned int  *) (PWM0_BASE + 0xFBC)))	/* W   Match interrupt set-status register */
#define PWM0_INT_CAPT_CLR_ENABLE (*((volatile unsigned int  *) (PWM0_BASE + 0xFC0)))	/* W   Capture interrupt clear-enable register */
#define PWM0_INT_CAPT_SET_ENABLE (*((volatile unsigned int  *) (PWM0_BASE + 0xFC4)))	/* W   Capture interrupt set-enable register */
#define PWM0_INT_CAPT_STATUS     (*((volatile unsigned int  *) (PWM0_BASE + 0xFC8)))	/* R   Capture interrupt status register */
#define PWM0_INT_CAPT_ENABLE     (*((volatile unsigned int  *) (PWM0_BASE + 0xFCC)))	/* R   Capture interrupt enable register */
#define PWM0_INT_CAPT_CLR_STATUS (*((volatile unsigned int  *) (PWM0_BASE + 0xFD0)))	/* W   Capture interrupt clear-status register */
#define PWM0_INT_CAPT_SET_STATUS (*((volatile unsigned int  *) (PWM0_BASE + 0xFD4)))	/* W   Capture interrupt set-status register */


/*
** PWM1 Pulse Width Modulator 1
*/

#define PWM1_BASE 0xE00C6000

#define PWM1_MODECTL             (*((volatile unsigned int  *) (PWM1_BASE + 0x000)))	/* R/W Main control register */
#define PWM1_TRPCTL              (*((volatile unsigned int  *) (PWM1_BASE + 0x004)))	/* R/W Controls the behavior of PWM outputs when there is an event on the PWMx TRAP input pin */
#define PWM1_CAPTCTL             (*((volatile unsigned int  *) (PWM1_BASE + 0x008)))	/* R/W Controls the behavior of the Capture_Registers and associated pins */
#define PWM1_CAPTSRC             (*((volatile unsigned int  *) (PWM1_BASE + 0x00C)))	/* R/W Controls the source of the capture events */
#define PWM1_CTRL                (*((volatile unsigned int  *) (PWM1_BASE + 0x010)))	/* R/W Controls the PWM output behavior. */
#define PWM1_PRD                 (*((volatile unsigned int  *) (PWM1_BASE + 0x014)))	/* R/W The cycle period (minus 1) of all PWM output */
#define PWM1_PRSC                (*((volatile unsigned int  *) (PWM1_BASE + 0x018)))	/* R/W The prescale register defines the number of system clock cycles to be counted (PR+1) before the PWM counter increments */
#define PWM1_SYNDEL              (*((volatile unsigned int  *) (PWM1_BASE + 0x01C)))	/* R/W Holds the delay between input and output trigger signals of the synchronization port */
#define PWM1_CNT                 (*((volatile unsigned int  *) (PWM1_BASE + 0x020)))	/* R   The PWM counter increments every Prescale+1 system clock cycles */
#define PWM1_MTCHACT0            (*((volatile unsigned int  *) (PWM1_BASE + 0x100)))	/* R/W Holds the first (activation) match value related to PWM 0 output */
#define PWM1_MTCHACT1            (*((volatile unsigned int  *) (PWM1_BASE + 0x104)))	/* R/W Holds the first (activation) match value related to PWM 1 output */
#define PWM1_MTCHACT2            (*((volatile unsigned int  *) (PWM1_BASE + 0x108)))	/* R/W Holds the first (activation) match value related to PWM 2 output */
#define PWM1_MTCHACT3            (*((volatile unsigned int  *) (PWM1_BASE + 0x10C)))	/* R/W Holds the first (activation) match value related to PWM 3 output */
#define PWM1_MTCHACT4            (*((volatile unsigned int  *) (PWM1_BASE + 0x110)))	/* R/W Holds the first (activation) match value related to PWM 4 output */
#define PWM1_MTCHACT5            (*((volatile unsigned int  *) (PWM1_BASE + 0x114)))	/* R/W Holds the first (activation) match value related to PWM 5 output */
#define PWM1_MTCHDEACT0          (*((volatile unsigned int  *) (PWM1_BASE + 0x200)))	/* R/W Holds the second (de-activation) match value related to PWM 0 output */
#define PWM1_MTCHDEACT1          (*((volatile unsigned int  *) (PWM1_BASE + 0x204)))	/* R/W Holds the second (de-activation) match value related to PWM 1 output */
#define PWM1_MTCHDEACT2          (*((volatile unsigned int  *) (PWM1_BASE + 0x208)))	/* R/W Holds the second (de-activation) match value related to PWM 2 output */
#define PWM1_MTCHDEACT3          (*((volatile unsigned int  *) (PWM1_BASE + 0x20C)))	/* R/W Holds the second (de-activation) match value related to PWM 3 output */
#define PWM1_MTCHDEACT4          (*((volatile unsigned int  *) (PWM1_BASE + 0x210)))	/* R/W Holds the second (de-activation) match value related to PWM 4 output */
#define PWM1_MTCHDEACT5          (*((volatile unsigned int  *) (PWM1_BASE + 0x214)))	/* R/W Holds the second (de-activation) match value related to PWM 5 output */
#define PWM1_CAPT0               (*((volatile unsigned int  *) (PWM1_BASE + 0x300)))	/* R   Holds the captured value on the selected event of capture channel 0 */
#define PWM1_CAPT1               (*((volatile unsigned int  *) (PWM1_BASE + 0x304)))	/* R   Holds the captured value on the selected event of capture channel 1 */
#define PWM1_CAPT2               (*((volatile unsigned int  *) (PWM1_BASE + 0x308)))	/* R   Holds the captured value on the selected event of capture channel 2 */
#define PWM1_CAPT3               (*((volatile unsigned int  *) (PWM1_BASE + 0x30C)))	/* R   Holds the captured value on the selected event of capture channel 3 */
#define PWM1_MODECTLS            (*((volatile unsigned int  *) (PWM1_BASE + 0x800)))	/* R   Mirror the synchronized MODECTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM1_TRPCTLS             (*((volatile unsigned int  *) (PWM1_BASE + 0x804)))	/* R   Mirror the synchronized TRPCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM1_CAPTCTLS            (*((volatile unsigned int  *) (PWM1_BASE + 0x808)))	/* R   Mirror the synchronized CAPTCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM1_CAPTSRCS            (*((volatile unsigned int  *) (PWM1_BASE + 0x80C)))	/* R   Mirror the synchronized CAPTSRC register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM1_CTRLS               (*((volatile unsigned int  *) (PWM1_BASE + 0x810)))	/* R   Mirror the shadowed CTRL register from PWM domain. Stable only if TRANS_ENA is low */
#define PWM1_PRDS                (*((volatile unsigned int  *) (PWM1_BASE + 0x814)))	/* R   Mirror the shadowed PRD register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM1_PRSCS               (*((volatile unsigned int  *) (PWM1_BASE + 0x818)))	/* R   Mirror the shadowed PRSC register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM1_SYNDELS             (*((volatile unsigned int  *) (PWM1_BASE + 0x81C)))	/* R   Mirror the shadowed SYNDEL register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM1_MTCHACTS0           (*((volatile unsigned int  *) (PWM1_BASE + 0x900)))	/* R   Mirror the activation match shadowed value related to PWM 0 output */
#define PWM1_MTCHACTS1           (*((volatile unsigned int  *) (PWM1_BASE + 0x904)))	/* R   Mirror the activation match shadowed value related to PWM 1 output */
#define PWM1_MTCHACTS2           (*((volatile unsigned int  *) (PWM1_BASE + 0x908)))	/* R   Mirror the activation match shadowed value related to PWM 2 output */
#define PWM1_MTCHACTS3           (*((volatile unsigned int  *) (PWM1_BASE + 0x90C)))	/* R   Mirror the activation match shadowed value related to PWM 3 output */
#define PWM1_MTCHACTS4           (*((volatile unsigned int  *) (PWM1_BASE + 0x910)))	/* R   Mirror the activation match shadowed value related to PWM 4 output */
#define PWM1_MTCHACTS5           (*((volatile unsigned int  *) (PWM1_BASE + 0x914)))	/* R   Mirror the activation match shadowed value related to PWM 5 output */
#define PWM1_MTCHDEACTS0         (*((volatile unsigned int  *) (PWM1_BASE + 0xA00)))	/* R   Mirror the de-activation match shadowed value related to PWM 0 output */
#define PWM1_MTCHDEACTS1         (*((volatile unsigned int  *) (PWM1_BASE + 0xA04)))	/* R   Mirror the de-activation match shadowed value related to PWM 1 output */
#define PWM1_MTCHDEACTS2         (*((volatile unsigned int  *) (PWM1_BASE + 0xA08)))	/* R   Mirror the de-activation match shadowed value related to PWM 2 output */
#define PWM1_MTCHDEACTS3         (*((volatile unsigned int  *) (PWM1_BASE + 0xA0C)))	/* R   Mirror the de-activation match shadowed value related to PWM 3 output */
#define PWM1_MTCHDEACTS4         (*((volatile unsigned int  *) (PWM1_BASE + 0xA10)))	/* R   Mirror the de-activation match shadowed value related to PWM 4 output */
#define PWM1_MTCHDEACTS5         (*((volatile unsigned int  *) (PWM1_BASE + 0xA14)))	/* R   Mirror the de-activation match shadowed value related to PWM 5 output */
#define PWM1_INT_CLR_ENABLE      (*((volatile unsigned int  *) (PWM1_BASE + 0xF90)))	/* W   PWM interrupt clear-enable register */
#define PWM1_INT_SET_ENABLE      (*((volatile unsigned int  *) (PWM1_BASE + 0xF94)))	/* W   PWM interrupt set-enable register */
#define PWM1_INT_STATUS          (*((volatile unsigned int  *) (PWM1_BASE + 0xF98)))	/* R   PWM interrupt status register */
#define PWM1_INT_ENABLE          (*((volatile unsigned int  *) (PWM1_BASE + 0xF9C)))	/* R   PWM interrupt enable register */
#define PWM1_INT_CLR_STATUS      (*((volatile unsigned int  *) (PWM1_BASE + 0xFA0)))	/* W   PWM interrupt clear-status register */
#define PWM1_INT_SET_STATUS      (*((volatile unsigned int  *) (PWM1_BASE + 0xFA4)))	/* W   PWM interrupt set-status register */
#define PWM1_INT_MTCH_CLR_ENABLE (*((volatile unsigned int  *) (PWM1_BASE + 0xFA8)))	/* W   Match interrupt clear-enable register */
#define PWM1_INT_MTCH_SET_ENABLE (*((volatile unsigned int  *) (PWM1_BASE + 0xFAC)))	/* W   Match interrupt set enable register */
#define PWM1_INT_MTCH_STATUS     (*((volatile unsigned int  *) (PWM1_BASE + 0xFB0)))	/* R   Match interrupt status register */
#define PWM1_INT_MTCH_ENABLE     (*((volatile unsigned int  *) (PWM1_BASE + 0xFB4)))	/* R   Match interrupt enable register */
#define PWM1_INT_MTCH_CLR_STATUS (*((volatile unsigned int  *) (PWM1_BASE + 0xFB8)))	/* W   Match interrupt clear-status register */
#define PWM1_INT_MTCH_SET_STATUS (*((volatile unsigned int  *) (PWM1_BASE + 0xFBC)))	/* W   Match interrupt set-status register */
#define PWM1_INT_CAPT_CLR_ENABLE (*((volatile unsigned int  *) (PWM1_BASE + 0xFC0)))	/* W   Capture interrupt clear-enable register */
#define PWM1_INT_CAPT_SET_ENABLE (*((volatile unsigned int  *) (PWM1_BASE + 0xFC4)))	/* W   Capture interrupt set-enable register */
#define PWM1_INT_CAPT_STATUS     (*((volatile unsigned int  *) (PWM1_BASE + 0xFC8)))	/* R   Capture interrupt status register */
#define PWM1_INT_CAPT_ENABLE     (*((volatile unsigned int  *) (PWM1_BASE + 0xFCC)))	/* R   Capture interrupt enable register */
#define PWM1_INT_CAPT_CLR_STATUS (*((volatile unsigned int  *) (PWM1_BASE + 0xFD0)))	/* W   Capture interrupt clear-status register */
#define PWM1_INT_CAPT_SET_STATUS (*((volatile unsigned int  *) (PWM1_BASE + 0xFD4)))	/* W   Capture interrupt set-status register */


/*
** PWM2 Pulse Width Modulator 2
*/

#define PWM2_BASE 0xE00C7000

#define PWM2_MODECTL             (*((volatile unsigned int  *) (PWM2_BASE + 0x000)))	/* R/W Main control register */
#define PWM2_TRPCTL              (*((volatile unsigned int  *) (PWM2_BASE + 0x004)))	/* R/W Controls the behavior of PWM outputs when there is an event on the PWMx TRAP input pin */
#define PWM2_CAPTCTL             (*((volatile unsigned int  *) (PWM2_BASE + 0x008)))	/* R/W Controls the behavior of the Capture_Registers and associated pins */
#define PWM2_CAPTSRC             (*((volatile unsigned int  *) (PWM2_BASE + 0x00C)))	/* R/W Controls the source of the capture events */
#define PWM2_CTRL                (*((volatile unsigned int  *) (PWM2_BASE + 0x010)))	/* R/W Controls the PWM output behavior. */
#define PWM2_PRD                 (*((volatile unsigned int  *) (PWM2_BASE + 0x014)))	/* R/W The cycle period (minus 1) of all PWM output */
#define PWM2_PRSC                (*((volatile unsigned int  *) (PWM2_BASE + 0x018)))	/* R/W The prescale register defines the number of system clock cycles to be counted (PR+1) before the PWM counter increments */
#define PWM2_SYNDEL              (*((volatile unsigned int  *) (PWM2_BASE + 0x01C)))	/* R/W Holds the delay between input and output trigger signals of the synchronization port */
#define PWM2_CNT                 (*((volatile unsigned int  *) (PWM2_BASE + 0x020)))	/* R   The PWM counter increments every Prescale+1 system clock cycles */
#define PWM2_MTCHACT0            (*((volatile unsigned int  *) (PWM2_BASE + 0x100)))	/* R/W Holds the first (activation) match value related to PWM 0 output */
#define PWM2_MTCHACT1            (*((volatile unsigned int  *) (PWM2_BASE + 0x104)))	/* R/W Holds the first (activation) match value related to PWM 1 output */
#define PWM2_MTCHACT2            (*((volatile unsigned int  *) (PWM2_BASE + 0x108)))	/* R/W Holds the first (activation) match value related to PWM 2 output */
#define PWM2_MTCHACT3            (*((volatile unsigned int  *) (PWM2_BASE + 0x10C)))	/* R/W Holds the first (activation) match value related to PWM 3 output */
#define PWM2_MTCHACT4            (*((volatile unsigned int  *) (PWM2_BASE + 0x110)))	/* R/W Holds the first (activation) match value related to PWM 4 output */
#define PWM2_MTCHACT5            (*((volatile unsigned int  *) (PWM2_BASE + 0x114)))	/* R/W Holds the first (activation) match value related to PWM 5 output */
#define PWM2_MTCHDEACT0          (*((volatile unsigned int  *) (PWM2_BASE + 0x200)))	/* R/W Holds the second (de-activation) match value related to PWM 0 output */
#define PWM2_MTCHDEACT1          (*((volatile unsigned int  *) (PWM2_BASE + 0x204)))	/* R/W Holds the second (de-activation) match value related to PWM 1 output */
#define PWM2_MTCHDEACT2          (*((volatile unsigned int  *) (PWM2_BASE + 0x208)))	/* R/W Holds the second (de-activation) match value related to PWM 2 output */
#define PWM2_MTCHDEACT3          (*((volatile unsigned int  *) (PWM2_BASE + 0x20C)))	/* R/W Holds the second (de-activation) match value related to PWM 3 output */
#define PWM2_MTCHDEACT4          (*((volatile unsigned int  *) (PWM2_BASE + 0x210)))	/* R/W Holds the second (de-activation) match value related to PWM 4 output */
#define PWM2_MTCHDEACT5          (*((volatile unsigned int  *) (PWM2_BASE + 0x214)))	/* R/W Holds the second (de-activation) match value related to PWM 5 output */
#define PWM2_CAPT0               (*((volatile unsigned int  *) (PWM2_BASE + 0x300)))	/* R   Holds the captured value on the selected event of capture channel 0 */
#define PWM2_CAPT1               (*((volatile unsigned int  *) (PWM2_BASE + 0x304)))	/* R   Holds the captured value on the selected event of capture channel 1 */
#define PWM2_CAPT2               (*((volatile unsigned int  *) (PWM2_BASE + 0x308)))	/* R   Holds the captured value on the selected event of capture channel 2 */
#define PWM2_CAPT3               (*((volatile unsigned int  *) (PWM2_BASE + 0x30C)))	/* R   Holds the captured value on the selected event of capture channel 3 */
#define PWM2_MODECTLS            (*((volatile unsigned int  *) (PWM2_BASE + 0x800)))	/* R   Mirror the synchronized MODECTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM2_TRPCTLS             (*((volatile unsigned int  *) (PWM2_BASE + 0x804)))	/* R   Mirror the synchronized TRPCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM2_CAPTCTLS            (*((volatile unsigned int  *) (PWM2_BASE + 0x808)))	/* R   Mirror the synchronized CAPTCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM2_CAPTSRCS            (*((volatile unsigned int  *) (PWM2_BASE + 0x80C)))	/* R   Mirror the synchronized CAPTSRC register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM2_CTRLS               (*((volatile unsigned int  *) (PWM2_BASE + 0x810)))	/* R   Mirror the shadowed CTRL register from PWM domain. Stable only if TRANS_ENA is low */
#define PWM2_PRDS                (*((volatile unsigned int  *) (PWM2_BASE + 0x814)))	/* R   Mirror the shadowed PRD register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM2_PRSCS               (*((volatile unsigned int  *) (PWM2_BASE + 0x818)))	/* R   Mirror the shadowed PRSC register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM2_SYNDELS             (*((volatile unsigned int  *) (PWM2_BASE + 0x81C)))	/* R   Mirror the shadowed SYNDEL register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM2_MTCHACTS0           (*((volatile unsigned int  *) (PWM2_BASE + 0x900)))	/* R   Mirror the activation match shadowed value related to PWM 0 output */
#define PWM2_MTCHACTS1           (*((volatile unsigned int  *) (PWM2_BASE + 0x904)))	/* R   Mirror the activation match shadowed value related to PWM 1 output */
#define PWM2_MTCHACTS2           (*((volatile unsigned int  *) (PWM2_BASE + 0x908)))	/* R   Mirror the activation match shadowed value related to PWM 2 output */
#define PWM2_MTCHACTS3           (*((volatile unsigned int  *) (PWM2_BASE + 0x90C)))	/* R   Mirror the activation match shadowed value related to PWM 3 output */
#define PWM2_MTCHACTS4           (*((volatile unsigned int  *) (PWM2_BASE + 0x910)))	/* R   Mirror the activation match shadowed value related to PWM 4 output */
#define PWM2_MTCHACTS5           (*((volatile unsigned int  *) (PWM2_BASE + 0x914)))	/* R   Mirror the activation match shadowed value related to PWM 5 output */
#define PWM2_MTCHDEACTS0         (*((volatile unsigned int  *) (PWM2_BASE + 0xA00)))	/* R   Mirror the de-activation match shadowed value related to PWM 0 output */
#define PWM2_MTCHDEACTS1         (*((volatile unsigned int  *) (PWM2_BASE + 0xA04)))	/* R   Mirror the de-activation match shadowed value related to PWM 1 output */
#define PWM2_MTCHDEACTS2         (*((volatile unsigned int  *) (PWM2_BASE + 0xA08)))	/* R   Mirror the de-activation match shadowed value related to PWM 2 output */
#define PWM2_MTCHDEACTS3         (*((volatile unsigned int  *) (PWM2_BASE + 0xA0C)))	/* R   Mirror the de-activation match shadowed value related to PWM 3 output */
#define PWM2_MTCHDEACTS4         (*((volatile unsigned int  *) (PWM2_BASE + 0xA10)))	/* R   Mirror the de-activation match shadowed value related to PWM 4 output */
#define PWM2_MTCHDEACTS5         (*((volatile unsigned int  *) (PWM2_BASE + 0xA14)))	/* R   Mirror the de-activation match shadowed value related to PWM 5 output */
#define PWM2_INT_CLR_ENABLE      (*((volatile unsigned int  *) (PWM2_BASE + 0xF90)))	/* W   PWM interrupt clear-enable register */
#define PWM2_INT_SET_ENABLE      (*((volatile unsigned int  *) (PWM2_BASE + 0xF94)))	/* W   PWM interrupt set-enable register */
#define PWM2_INT_STATUS          (*((volatile unsigned int  *) (PWM2_BASE + 0xF98)))	/* R   PWM interrupt status register */
#define PWM2_INT_ENABLE          (*((volatile unsigned int  *) (PWM2_BASE + 0xF9C)))	/* R   PWM interrupt enable register */
#define PWM2_INT_CLR_STATUS      (*((volatile unsigned int  *) (PWM2_BASE + 0xFA0)))	/* W   PWM interrupt clear-status register */
#define PWM2_INT_SET_STATUS      (*((volatile unsigned int  *) (PWM2_BASE + 0xFA4)))	/* W   PWM interrupt set-status register */
#define PWM2_INT_MTCH_CLR_ENABLE (*((volatile unsigned int  *) (PWM2_BASE + 0xFA8)))	/* W   Match interrupt clear-enable register */
#define PWM2_INT_MTCH_SET_ENABLE (*((volatile unsigned int  *) (PWM2_BASE + 0xFAC)))	/* W   Match interrupt set enable register */
#define PWM2_INT_MTCH_STATUS     (*((volatile unsigned int  *) (PWM2_BASE + 0xFB0)))	/* R   Match interrupt status register */
#define PWM2_INT_MTCH_ENABLE     (*((volatile unsigned int  *) (PWM2_BASE + 0xFB4)))	/* R   Match interrupt enable register */
#define PWM2_INT_MTCH_CLR_STATUS (*((volatile unsigned int  *) (PWM2_BASE + 0xFB8)))	/* W   Match interrupt clear-status register */
#define PWM2_INT_MTCH_SET_STATUS (*((volatile unsigned int  *) (PWM2_BASE + 0xFBC)))	/* W   Match interrupt set-status register */
#define PWM2_INT_CAPT_CLR_ENABLE (*((volatile unsigned int  *) (PWM2_BASE + 0xFC0)))	/* W   Capture interrupt clear-enable register */
#define PWM2_INT_CAPT_SET_ENABLE (*((volatile unsigned int  *) (PWM2_BASE + 0xFC4)))	/* W   Capture interrupt set-enable register */
#define PWM2_INT_CAPT_STATUS     (*((volatile unsigned int  *) (PWM2_BASE + 0xFC8)))	/* R   Capture interrupt status register */
#define PWM2_INT_CAPT_ENABLE     (*((volatile unsigned int  *) (PWM2_BASE + 0xFCC)))	/* R   Capture interrupt enable register */
#define PWM2_INT_CAPT_CLR_STATUS (*((volatile unsigned int  *) (PWM2_BASE + 0xFD0)))	/* W   Capture interrupt clear-status register */
#define PWM2_INT_CAPT_SET_STATUS (*((volatile unsigned int  *) (PWM2_BASE + 0xFD4)))	/* W   Capture interrupt set-status register */


/*
** PWM3 Pulse Width Modulator 3
*/

#define PWM3_BASE 0xE00C8000

#define PWM3_MODECTL             (*((volatile unsigned int  *) (PWM3_BASE + 0x000)))	/* R/W Main control register */
#define PWM3_TRPCTL              (*((volatile unsigned int  *) (PWM3_BASE + 0x004)))	/* R/W Controls the behavior of PWM outputs when there is an event on the PWMx TRAP input pin */
#define PWM3_CAPTCTL             (*((volatile unsigned int  *) (PWM3_BASE + 0x008)))	/* R/W Controls the behavior of the Capture_Registers and associated pins */
#define PWM3_CAPTSRC             (*((volatile unsigned int  *) (PWM3_BASE + 0x00C)))	/* R/W Controls the source of the capture events */
#define PWM3_CTRL                (*((volatile unsigned int  *) (PWM3_BASE + 0x010)))	/* R/W Controls the PWM output behavior. */
#define PWM3_PRD                 (*((volatile unsigned int  *) (PWM3_BASE + 0x014)))	/* R/W The cycle period (minus 1) of all PWM output */
#define PWM3_PRSC                (*((volatile unsigned int  *) (PWM3_BASE + 0x018)))	/* R/W The prescale register defines the number of system clock cycles to be counted (PR+1) before the PWM counter increments */
#define PWM3_SYNDEL              (*((volatile unsigned int  *) (PWM3_BASE + 0x01C)))	/* R/W Holds the delay between input and output trigger signals of the synchronization port */
#define PWM3_CNT                 (*((volatile unsigned int  *) (PWM3_BASE + 0x020)))	/* R   The PWM counter increments every Prescale+1 system clock cycles  */
#define PWM3_MTCHACT0            (*((volatile unsigned int  *) (PWM3_BASE + 0x100)))	/* R/W Holds the first (activation) match value related to PWM 0 output */
#define PWM3_MTCHACT1            (*((volatile unsigned int  *) (PWM3_BASE + 0x104)))	/* R/W Holds the first (activation) match value related to PWM 1 output */
#define PWM3_MTCHACT2            (*((volatile unsigned int  *) (PWM3_BASE + 0x108)))	/* R/W Holds the first (activation) match value related to PWM 2 output */
#define PWM3_MTCHACT3            (*((volatile unsigned int  *) (PWM3_BASE + 0x10C)))	/* R/W Holds the first (activation) match value related to PWM 3 output */
#define PWM3_MTCHACT4            (*((volatile unsigned int  *) (PWM3_BASE + 0x110)))	/* R/W Holds the first (activation) match value related to PWM 4 output */
#define PWM3_MTCHACT5            (*((volatile unsigned int  *) (PWM3_BASE + 0x114)))	/* R/W Holds the first (activation) match value related to PWM 5 output */
#define PWM3_MTCHDEACT0          (*((volatile unsigned int  *) (PWM3_BASE + 0x200)))	/* R/W Holds the second (de-activation) match value related to PWM 0 output */
#define PWM3_MTCHDEACT1          (*((volatile unsigned int  *) (PWM3_BASE + 0x204)))	/* R/W Holds the second (de-activation) match value related to PWM 1 output */
#define PWM3_MTCHDEACT2          (*((volatile unsigned int  *) (PWM3_BASE + 0x208)))	/* R/W Holds the second (de-activation) match value related to PWM 2 output */
#define PWM3_MTCHDEACT3          (*((volatile unsigned int  *) (PWM3_BASE + 0x20C)))	/* R/W Holds the second (de-activation) match value related to PWM 3 output */
#define PWM3_MTCHDEACT4          (*((volatile unsigned int  *) (PWM3_BASE + 0x210)))	/* R/W Holds the second (de-activation) match value related to PWM 4 output */
#define PWM3_MTCHDEACT5          (*((volatile unsigned int  *) (PWM3_BASE + 0x214)))	/* R/W Holds the second (de-activation) match value related to PWM 5 output */
#define PWM3_CAPT0               (*((volatile unsigned int  *) (PWM3_BASE + 0x300)))	/* R   Holds the captured value on the selected event of capture channel 0 */
#define PWM3_CAPT1               (*((volatile unsigned int  *) (PWM3_BASE + 0x304)))	/* R   Holds the captured value on the selected event of capture channel 1 */
#define PWM3_CAPT2               (*((volatile unsigned int  *) (PWM3_BASE + 0x308)))	/* R   Holds the captured value on the selected event of capture channel 2 */
#define PWM3_CAPT3               (*((volatile unsigned int  *) (PWM3_BASE + 0x30C)))	/* R   Holds the captured value on the selected event of capture channel 3 */
#define PWM3_MODECTLS            (*((volatile unsigned int  *) (PWM3_BASE + 0x800)))	/* R   Mirror the synchronized MODECTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM3_TRPCTLS             (*((volatile unsigned int  *) (PWM3_BASE + 0x804)))	/* R   Mirror the synchronized TRPCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM3_CAPTCTLS            (*((volatile unsigned int  *) (PWM3_BASE + 0x808)))	/* R   Mirror the synchronized CAPTCTL register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM3_CAPTSRCS            (*((volatile unsigned int  *) (PWM3_BASE + 0x80C)))	/* R   Mirror the synchronized CAPTSRC register from PWM domain. Stable only if UPD_ENA is 0 */
#define PWM3_CTRLS               (*((volatile unsigned int  *) (PWM3_BASE + 0x810)))	/* R   Mirror the shadowed CTRL register from PWM domain. Stable only if TRANS_ENA is low */
#define PWM3_PRDS                (*((volatile unsigned int  *) (PWM3_BASE + 0x814)))	/* R   Mirror the shadowed PRD register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM3_PRSCS               (*((volatile unsigned int  *) (PWM3_BASE + 0x818)))	/* R   Mirror the shadowed PRSC register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM3_SYNDELS             (*((volatile unsigned int  *) (PWM3_BASE + 0x81C)))	/* R   Mirror the shadowed SYNDEL register from PWM domain. Stable only if TRANS_ENA is 0 */
#define PWM3_MTCHACTS0           (*((volatile unsigned int  *) (PWM3_BASE + 0x900)))	/* R   Mirror the activation match shadowed value related to PWM 0 output */
#define PWM3_MTCHACTS1           (*((volatile unsigned int  *) (PWM3_BASE + 0x904)))	/* R   Mirror the activation match shadowed value related to PWM 1 output */
#define PWM3_MTCHACTS2           (*((volatile unsigned int  *) (PWM3_BASE + 0x908)))	/* R   Mirror the activation match shadowed value related to PWM 2 output */
#define PWM3_MTCHACTS3           (*((volatile unsigned int  *) (PWM3_BASE + 0x90C)))	/* R   Mirror the activation match shadowed value related to PWM 3 output */
#define PWM3_MTCHACTS4           (*((volatile unsigned int  *) (PWM3_BASE + 0x910)))	/* R   Mirror the activation match shadowed value related to PWM 4 output */
#define PWM3_MTCHACTS5           (*((volatile unsigned int  *) (PWM3_BASE + 0x914)))	/* R   Mirror the activation match shadowed value related to PWM 5 output */
#define PWM3_MTCHDEACTS0         (*((volatile unsigned int  *) (PWM3_BASE + 0xA00)))	/* R   Mirror the de-activation match shadowed value related to PWM 0 output */
#define PWM3_MTCHDEACTS1         (*((volatile unsigned int  *) (PWM3_BASE + 0xA04)))	/* R   Mirror the de-activation match shadowed value related to PWM 1 output */
#define PWM3_MTCHDEACTS2         (*((volatile unsigned int  *) (PWM3_BASE + 0xA08)))	/* R   Mirror the de-activation match shadowed value related to PWM 2 output */
#define PWM3_MTCHDEACTS3         (*((volatile unsigned int  *) (PWM3_BASE + 0xA0C)))	/* R   Mirror the de-activation match shadowed value related to PWM 3 output */
#define PWM3_MTCHDEACTS4         (*((volatile unsigned int  *) (PWM3_BASE + 0xA10)))	/* R   Mirror the de-activation match shadowed value related to PWM 4 output */
#define PWM3_MTCHDEACTS5         (*((volatile unsigned int  *) (PWM3_BASE + 0xA14)))	/* R   Mirror the de-activation match shadowed value related to PWM 5 output */
#define PWM3_INT_CLR_ENABLE      (*((volatile unsigned int  *) (PWM3_BASE + 0xF90)))	/* W   PWM interrupt clear-enable register */
#define PWM3_INT_SET_ENABLE      (*((volatile unsigned int  *) (PWM3_BASE + 0xF94)))	/* W   PWM interrupt set-enable register */
#define PWM3_INT_STATUS          (*((volatile unsigned int  *) (PWM3_BASE + 0xF98)))	/* R   PWM interrupt status register */
#define PWM3_INT_ENABLE          (*((volatile unsigned int  *) (PWM3_BASE + 0xF9C)))	/* R   PWM interrupt enable register */
#define PWM3_INT_CLR_STATUS      (*((volatile unsigned int  *) (PWM3_BASE + 0xFA0)))	/* W   PWM interrupt clear-status register */
#define PWM3_INT_SET_STATUS      (*((volatile unsigned int  *) (PWM3_BASE + 0xFA4)))	/* W   PWM interrupt set-status register */
#define PWM3_INT_MTCH_CLR_ENABLE (*((volatile unsigned int  *) (PWM3_BASE + 0xFA8)))	/* W   Match interrupt clear-enable register */
#define PWM3_INT_MTCH_SET_ENABLE (*((volatile unsigned int  *) (PWM3_BASE + 0xFAC)))	/* W   Match interrupt set enable register */
#define PWM3_INT_MTCH_STATUS     (*((volatile unsigned int  *) (PWM3_BASE + 0xFB0)))	/* R   Match interrupt status register */
#define PWM3_INT_MTCH_ENABLE     (*((volatile unsigned int  *) (PWM3_BASE + 0xFB4)))	/* R   Match interrupt enable register */
#define PWM3_INT_MTCH_CLR_STATUS (*((volatile unsigned int  *) (PWM3_BASE + 0xFB8)))	/* W   Match interrupt clear-status register */
#define PWM3_INT_MTCH_SET_STATUS (*((volatile unsigned int  *) (PWM3_BASE + 0xFBC)))	/* W   Match interrupt set-status register */
#define PWM3_INT_CAPT_CLR_ENABLE (*((volatile unsigned int  *) (PWM3_BASE + 0xFC0)))	/* W   Capture interrupt clear-enable register */
#define PWM3_INT_CAPT_SET_ENABLE (*((volatile unsigned int  *) (PWM3_BASE + 0xFC4)))	/* W   Capture interrupt set-enable register */
#define PWM3_INT_CAPT_STATUS     (*((volatile unsigned int  *) (PWM3_BASE + 0xFC8)))	/* R   Capture interrupt status register */
#define PWM3_INT_CAPT_ENABLE     (*((volatile unsigned int  *) (PWM3_BASE + 0xFCC)))	/* R   Capture interrupt enable register */
#define PWM3_INT_CAPT_CLR_STATUS (*((volatile unsigned int  *) (PWM3_BASE + 0xFD0)))	/* W   Capture interrupt clear-status register */
#define PWM3_INT_CAPT_SET_STATUS (*((volatile unsigned int  *) (PWM3_BASE + 0xFD4)))	/* W   Capture interrupt set-status register */


/*
** QEI Quadrature Encoder Interface
*/

#define QEI_BASE 0xE00C9000

#define QEI_QEICON              (*((volatile unsigned int  *) (QEI_BASE + 0x000)))	/* W   Control register */
#define QEI_QEISTAT             (*((volatile unsigned int  *) (QEI_BASE + 0x004)))	/* R   Encoder status register */
#define QEI_QEICONF             (*((volatile unsigned int  *) (QEI_BASE + 0x008)))	/* R/W Configuration register */
#define QEI_QEIPOS              (*((volatile unsigned int  *) (QEI_BASE + 0x00C)))	/* R   Position register */
#define QEI_QEIMAXPSOS          (*((volatile unsigned int  *) (QEI_BASE + 0x010)))	/* R/W Maximum position register */
#define QEI_CMPOS0              (*((volatile unsigned int  *) (QEI_BASE + 0x014)))	/* R/W Position compare register 0 */
#define QEI_CMPOS1              (*((volatile unsigned int  *) (QEI_BASE + 0x018)))	/* R/W Position compare register 1 */
#define QEI_CMPOS2              (*((volatile unsigned int  *) (QEI_BASE + 0x01C)))	/* R/W Position compare register 2 */
#define QEI_INXCNT              (*((volatile unsigned int  *) (QEI_BASE + 0x020)))	/* R   Index count register */
#define QEI_INXCMP              (*((volatile unsigned int  *) (QEI_BASE + 0x024)))	/* R/W Index compare register */
#define QEI_QEILOAD             (*((volatile unsigned int  *) (QEI_BASE + 0x028)))	/* R/W Velocity timer reload register */
#define QEI_QEITIME             (*((volatile unsigned int  *) (QEI_BASE + 0x02C)))	/* R   Velocity timer register */
#define QEI_QEIVEL              (*((volatile unsigned int  *) (QEI_BASE + 0x030)))	/* R   Velocity counter register */
#define QEI_QEICAP              (*((volatile unsigned int  *) (QEI_BASE + 0x034)))	/* R   Velocity capture register */
#define QEI_VELCOMP             (*((volatile unsigned int  *) (QEI_BASE + 0x038)))	/* R/W Velocity compare register */
#define QEI_FILTER              (*((volatile unsigned int  *) (QEI_BASE + 0x03C)))	/* R/W Digital filter register */
#define QEI_QEIIES              (*((volatile unsigned int  *) (QEI_BASE + 0xFDC)))	/* W   Interrupt enable set register */
#define QEI_QEIIEC              (*((volatile unsigned int  *) (QEI_BASE + 0xFD8)))	/* W   Interrupt enable clear register */
#define QEI_QEIINTSTAT          (*((volatile unsigned int  *) (QEI_BASE + 0xFE0)))	/* R   Interrupt status register */
#define QEI_QEIIE               (*((volatile unsigned int  *) (QEI_BASE + 0xFE4)))	/* R   Interrupt enable register */
#define QEI_QEICLR              (*((volatile unsigned int  *) (QEI_BASE + 0xFE8)))	/* W   Interrupt status clear register */
#define QEI_QEISET              (*((volatile unsigned int  *) (QEI_BASE + 0xFEC)))	/* W   Interrupt status set register */


/*
** USB device register address definitions
*/

/* Interrupt status register */
#define USBIntSt        	(*((volatile unsigned int  *) 0xE01FC1C0))

#define USB_BASE 0xE0100000

/* USB Host register address definitions */
#define HcRevision		(*((volatile unsigned int *) (USB_BASE + 0x000)))
#define HcControl		(*((volatile unsigned int *) (USB_BASE + 0x004)))
#define HcCommandStatus		(*((volatile unsigned int *) (USB_BASE + 0x008)))
#define HcInterruptStatus	(*((volatile unsigned int *) (USB_BASE + 0x00C)))
#define HcInterruptEnable	(*((volatile unsigned int *) (USB_BASE + 0x010)))
#define HcInterruptDisable	(*((volatile unsigned int *) (USB_BASE + 0x014)))
#define HcHCCA			(*((volatile unsigned int *) (USB_BASE + 0x018)))
#define HcPeriodCurrentED	(*((volatile unsigned int *) (USB_BASE + 0x01C)))
#define HcControlHeadED		(*((volatile unsigned int *) (USB_BASE + 0x020)))
#define HcControlCurrentED	(*((volatile unsigned int *) (USB_BASE + 0x024)))
#define HcBulkHeadED		(*((volatile unsigned int *) (USB_BASE + 0x028)))
#define HcBulkCurrentED		(*((volatile unsigned int *) (USB_BASE + 0x02C)))
#define HcDoneHead		(*((volatile unsigned int *) (USB_BASE + 0x030)))
#define HcFmInterval		(*((volatile unsigned int *) (USB_BASE + 0x034)))
#define HcFmRemaining		(*((volatile unsigned int *) (USB_BASE + 0x038)))
#define HcFmNumber		(*((volatile unsigned int *) (USB_BASE + 0x03C)))
#define HcPeriodicStart		(*((volatile unsigned int *) (USB_BASE + 0x040)))
#define HcLSThreshold		(*((volatile unsigned int *) (USB_BASE + 0x044)))
#define HcRhDescriptorA		(*((volatile unsigned int *) (USB_BASE + 0x048)))
#define HcRhDescriptorB		(*((volatile unsigned int *) (USB_BASE + 0x04C)))
#define HcRhStatus		(*((volatile unsigned int *) (USB_BASE + 0x050)))
#define HcRhPortStatus1		(*((volatile unsigned int *) (USB_BASE + 0x054)))
#define HcRhPortStatus2		(*((volatile unsigned int *) (USB_BASE + 0x058)))
#define HcModuleID		(*((volatile unsigned int *) (USB_BASE + 0x0FC)))

/* OTG registers */
#define OTG_int_status		(*((volatile unsigned int *) (USB_BASE + 0x100)))
#define OTG_int_enable		(*((volatile unsigned int *) (USB_BASE + 0x104)))
#define OTG_int_set		(*((volatile unsigned int *) (USB_BASE + 0x108)))
#define OTG_int_clear		(*((volatile unsigned int *) (USB_BASE + 0x10C)))
#define OTG_status		(*((volatile unsigned int *) (USB_BASE + 0x110)))
#define OTG_timer		(*((volatile unsigned int *) (USB_BASE + 0x114)))

/* Device interrupt registers */
#define USBDevIntSt		(*((volatile unsigned int *) (USB_BASE + 0x200)))
#define USBDevIntEn		(*((volatile unsigned int *) (USB_BASE + 0x204)))
#define USBDevIntClr		(*((volatile unsigned int *) (USB_BASE + 0x208)))
#define USBDevIntSet		(*((volatile unsigned int *) (USB_BASE + 0x20C)))
#define USBDevIntPri		(*((volatile unsigned int *) (USB_BASE + 0x22C)))

/* Endpoint interrupt registers */
#define USBEpIntSt		(*((volatile unsigned int *) (USB_BASE + 0x230)))
#define USBEpIntEn		(*((volatile unsigned int *) (USB_BASE + 0x234)))
#define USBEpIntClr		(*((volatile unsigned int *) (USB_BASE + 0x238)))
#define USBEpIntSet		(*((volatile unsigned int *) (USB_BASE + 0x23C)))
#define USBEpIntPri		(*((volatile unsigned int *) (USB_BASE + 0x240)))

/* Endpoint realization registers */
#define USBReEp			(*((volatile unsigned int *) (USB_BASE + 0x244)))
#define USBEpInd		(*((volatile unsigned int *) (USB_BASE + 0x248)))
#define USBEpMaxPSize		(*((volatile unsigned int *) (USB_BASE + 0x24C)))

/* Command registers */
#define USBCmdCode		(*((volatile unsigned int *) (USB_BASE + 0x210)))
#define USBCmdData		(*((volatile unsigned int *) (USB_BASE + 0x214)))

/* Data transfer registers */
#define USBRxData		(*((volatile unsigned int *) (USB_BASE + 0x218)))
#define USBRxPLen		(*((volatile unsigned int *) (USB_BASE + 0x220)))
#define USBTxData		(*((volatile unsigned int *) (USB_BASE + 0x21C)))
#define USBTxPLen		(*((volatile unsigned int *) (USB_BASE + 0x224)))
#define USBCtrl			(*((volatile unsigned int *) (USB_BASE + 0x228)))

/* DMA registers */
#define USBDMARSt		(*((volatile unsigned int *) (USB_BASE + 0x250)))
#define USBDMARClr		(*((volatile unsigned int *) (USB_BASE + 0x254)))
#define USBDMARSet		(*((volatile unsigned int *) (USB_BASE + 0x258)))
#define USBUDCAH		(*((volatile unsigned int *) (USB_BASE + 0x280)))
#define USBEpDMASt		(*((volatile unsigned int *) (USB_BASE + 0x284)))
#define USBEpDMAEn		(*((volatile unsigned int *) (USB_BASE + 0x288)))
#define USBEpDMADis		(*((volatile unsigned int *) (USB_BASE + 0x28C)))
#define USBDMAIntSt		(*((volatile unsigned int *) (USB_BASE + 0x290)))
#define USBDMAIntEn		(*((volatile unsigned int *) (USB_BASE + 0x294)))
#define USBEoTIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2A0)))
#define USBEoTIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2A4)))
#define USBEoTIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2A8)))
#define USBNDDRIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2AC)))
#define USBNDDRIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2B0)))
#define USBNDDRIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2B4)))
#define USBSysErrIntSt		(*((volatile unsigned int *) (USB_BASE + 0x2B8)))
#define USBSysErrIntClr		(*((volatile unsigned int *) (USB_BASE + 0x2BC)))
#define USBSysErrIntSet		(*((volatile unsigned int *) (USB_BASE + 0x2C0)))
#define USBModId		(*((volatile unsigned int *) (USB_BASE + 0x2FC)))

/* I2C registers */
#define I2C_RX			(*((volatile unsigned int *) (USB_BASE + 0x300)))
#define I2C_TX			(*((volatile unsigned int *) (USB_BASE + 0x300)))
#define I2C_STS			(*((volatile unsigned int *) (USB_BASE + 0x304)))
#define I2C_CTL			(*((volatile unsigned int *) (USB_BASE + 0x308)))
#define I2C_CLKHI		(*((volatile unsigned int *) (USB_BASE + 0x30C)))
#define I2C_CLKLO		(*((volatile unsigned int *) (USB_BASE + 0x310)))

/* Clock control and module ID registers */
#define OTG_clock_control	(*((volatile unsigned int *) (USB_BASE + 0xFF4)))
#define OTG_clock_status	(*((volatile unsigned int *) (USB_BASE + 0xFF8)))
#define OTG_module_id		(*((volatile unsigned int *) (USB_BASE + 0xFFC)))


/*
** DMAC General Purpose DMA Controller
*/

#define DMAC_BASE 0xE0140000

/* General Registers */
#define DMACIntStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x000)))
#define DMACIntTCStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x004)))
#define DMACIntTCClear		(*((volatile unsigned int *) (DMAC_BASE + 0x008)))
#define DMACIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x00C)))
#define DMACIntIntErrClr	(*((volatile unsigned int *) (DMAC_BASE + 0x010)))
#define DMACRawIntTCStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x014)))
#define DMACRawIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x018)))
#define DMACEnbldChns		(*((volatile unsigned int *) (DMAC_BASE + 0x01C)))
#define DMACSoftBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x020)))
#define DMACSoftSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x024)))
#define DMACSoftLBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x028)))
#define DMACSoftLSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x02C)))
#define DMACConfiguration	(*((volatile unsigned int *) (DMAC_BASE + 0x030)))
#define DMACSync		(*((volatile unsigned int *) (DMAC_BASE + 0x034)))

/* Channel 0 Registers */
#define DMACC0SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x100)))
#define DMACC0DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x104)))
#define DMACC0LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x108)))
#define DMACC0Control		(*((volatile unsigned int *) (DMAC_BASE + 0x10C)))
#define DMACC0Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x110)))

/* Channel 1 Registers */
#define DMACC1SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x120)))
#define DMACC1DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x124)))
#define DMACC1LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x128)))
#define DMACC1Control		(*((volatile unsigned int *) (DMAC_BASE + 0x12C)))
#define DMACC1Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x130)))

/* Channel 2 Registers */
#define DMACC2SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x140)))
#define DMACC2DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x144)))
#define DMACC2LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x148)))
#define DMACC2Control		(*((volatile unsigned int *) (DMAC_BASE + 0x14C)))
#define DMACC2Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x150)))

/* Channel 3 Registers */
#define DMACC3SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x160)))
#define DMACC3DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x164)))
#define DMACC3LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x168)))
#define DMACC3Control		(*((volatile unsigned int *) (DMAC_BASE + 0x16C)))
#define DMACC3Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x170)))

/* Channel 4 Registers */
#define DMACC4SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x180)))
#define DMACC4DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x184)))
#define DMACC4LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x188)))
#define DMACC4Control		(*((volatile unsigned int *) (DMAC_BASE + 0x18C)))
#define DMACC4Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x190)))

/* Channel 5 Registers */
#define DMACC5SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1A0)))
#define DMACC5DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1A4)))
#define DMACC5LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1A8)))
#define DMACC5Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1AC)))
#define DMACC5Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1B0)))

/* Channel 6 Registers */
#define DMACC6SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1C0)))
#define DMACC6DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1C4)))
#define DMACC6LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1C8)))
#define DMACC6Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1CC)))
#define DMACC6Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1D0)))

/* Channel 7 Registers */
#define DMACC7SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1E0)))
#define DMACC7DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x1E4)))
#define DMACC7LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x1E8)))
#define DMACC7Control		(*((volatile unsigned int *) (DMAC_BASE + 0x1EC)))
#define DMACC7Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x1F0)))


/*
** CGU Clock Generation Unit
*/

#define CGU_BASE_ADDR 0xFFFF8000


/*
** CGU Reset Generation Unit
*/

#define RGU_BASE_ADDR 0xFFFFF000


/*
** PMU Power Management Unit
*/


/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VIC_INT_PRIORITY_MASK_0	(*((volatile unsigned int  *) (VIC_BASE + 0x000)))      /* R/W target 0 priority mask register */
#define VIC_INT_PRIORITY_MASK_1	(*((volatile unsigned int  *) (VIC_BASE + 0x004)))      /* R/W target 1 priority mask register */
#define VIC_INT_VECTOR_0	(*((volatile unsigned int  *) (VIC_BASE + 0x100)))      /* R/W target 0 vector register */
#define VIC_INT_VECTOR_1	(*((volatile unsigned int  *) (VIC_BASE + 0x104)))      /* R/W target 1 vector register */
#define VIC_INT_PENDING_1_31	(*((volatile unsigned int  *) (VIC_BASE + 0x200)))      /* R   interrupt pending status register */
#define VIC_INT_FEATURES	(*((volatile unsigned int  *) (VIC_BASE + 0x300)))      /* R   interrupt controller features register */
#define VIC_INT_REQUEST_1	(*((volatile unsigned int  *) (VIC_BASE + 0x404)))      /* R/W interrupt request 1 control register */
#define VIC_INT_REQUEST_2	(*((volatile unsigned int  *) (VIC_BASE + 0x408)))      /* R/W interrupt request 2 control register */
#define VIC_INT_REQUEST_3	(*((volatile unsigned int  *) (VIC_BASE + 0x40C)))      /* R/W interrupt request 3 control register */
#define VIC_INT_REQUEST_4	(*((volatile unsigned int  *) (VIC_BASE + 0x410)))      /* R/W interrupt request 4 control register */
#define VIC_INT_REQUEST_5	(*((volatile unsigned int  *) (VIC_BASE + 0x414)))      /* R/W interrupt request 5 control register */
#define VIC_INT_REQUEST_6	(*((volatile unsigned int  *) (VIC_BASE + 0x418)))      /* R/W interrupt request 6 control register */
#define VIC_INT_REQUEST_7	(*((volatile unsigned int  *) (VIC_BASE + 0x41C)))      /* R/W interrupt request 7 control register */
#define VIC_INT_REQUEST_8	(*((volatile unsigned int  *) (VIC_BASE + 0x420)))      /* R/W interrupt request 8 control register */
#define VIC_INT_REQUEST_9	(*((volatile unsigned int  *) (VIC_BASE + 0x424)))      /* R/W interrupt request 9 control register */
#define VIC_INT_REQUEST_10	(*((volatile unsigned int  *) (VIC_BASE + 0x428)))      /* R/W interrupt request 10 control register */
#define VIC_INT_REQUEST_11	(*((volatile unsigned int  *) (VIC_BASE + 0x42C)))      /* R/W interrupt request 11 control register */
#define VIC_INT_REQUEST_12	(*((volatile unsigned int  *) (VIC_BASE + 0x430)))      /* R/W interrupt request 12 control register */
#define VIC_INT_REQUEST_13	(*((volatile unsigned int  *) (VIC_BASE + 0x434)))      /* R/W interrupt request 13 control register */
#define VIC_INT_REQUEST_14	(*((volatile unsigned int  *) (VIC_BASE + 0x438)))      /* R/W interrupt request 14 control register */
#define VIC_INT_REQUEST_15	(*((volatile unsigned int  *) (VIC_BASE + 0x43C)))      /* R/W interrupt request 15 control register */
#define VIC_INT_REQUEST_16	(*((volatile unsigned int  *) (VIC_BASE + 0x440)))      /* R/W interrupt request 16 control register */
#define VIC_INT_REQUEST_17	(*((volatile unsigned int  *) (VIC_BASE + 0x444)))      /* R/W interrupt request 17 control register */
#define VIC_INT_REQUEST_18	(*((volatile unsigned int  *) (VIC_BASE + 0x448)))      /* R/W interrupt request 18 control register */
#define VIC_INT_REQUEST_19	(*((volatile unsigned int  *) (VIC_BASE + 0x44C)))      /* R/W interrupt request 19 control register */
#define VIC_INT_REQUEST_20	(*((volatile unsigned int  *) (VIC_BASE + 0x450)))      /* R/W interrupt request 20 control register */
#define VIC_INT_REQUEST_21	(*((volatile unsigned int  *) (VIC_BASE + 0x454)))      /* R/W interrupt request 21 control register */
#define VIC_INT_REQUEST_22	(*((volatile unsigned int  *) (VIC_BASE + 0x458)))      /* R/W interrupt request 22 control register */
#define VIC_INT_REQUEST_23	(*((volatile unsigned int  *) (VIC_BASE + 0x45C)))      /* R/W interrupt request 23 control register */
#define VIC_INT_REQUEST_24	(*((volatile unsigned int  *) (VIC_BASE + 0x460)))      /* R/W interrupt request 24 control register */
#define VIC_INT_REQUEST_25	(*((volatile unsigned int  *) (VIC_BASE + 0x464)))      /* R/W interrupt request 25 control register */
#define VIC_INT_REQUEST_26	(*((volatile unsigned int  *) (VIC_BASE + 0x468)))      /* R/W interrupt request 26 control register */
#define VIC_INT_REQUEST_27	(*((volatile unsigned int  *) (VIC_BASE + 0x46C)))      /* R/W interrupt request 27 control register */
#define VIC_INT_REQUEST_28	(*((volatile unsigned int  *) (VIC_BASE + 0x470)))      /* R/W interrupt request 28 control register */
#define VIC_INT_REQUEST_29	(*((volatile unsigned int  *) (VIC_BASE + 0x474)))      /* R/W interrupt request 29 control register */
#define VIC_INT_REQUEST_30	(*((volatile unsigned int  *) (VIC_BASE + 0x478)))      /* R/W interrupt request 30 control register */
#define VIC_INT_REQUEST_31	(*((volatile unsigned int  *) (VIC_BASE + 0x47C)))      /* R/W interrupt request 31 control register */
#define VIC_INT_REQUEST_32	(*((volatile unsigned int  *) (VIC_BASE + 0x480)))      /* R/W interrupt request 8 control register */
#define VIC_INT_REQUEST_33	(*((volatile unsigned int  *) (VIC_BASE + 0x484)))      /* R/W interrupt request 9 control register */
#define VIC_INT_REQUEST_34	(*((volatile unsigned int  *) (VIC_BASE + 0x488)))      /* R/W interrupt request 10 control register */
#define VIC_INT_REQUEST_35	(*((volatile unsigned int  *) (VIC_BASE + 0x48C)))      /* R/W interrupt request 11 control register */
#define VIC_INT_REQUEST_36	(*((volatile unsigned int  *) (VIC_BASE + 0x490)))      /* R/W interrupt request 12 control register */
#define VIC_INT_REQUEST_37	(*((volatile unsigned int  *) (VIC_BASE + 0x494)))      /* R/W interrupt request 13 control register */
#define VIC_INT_REQUEST_38	(*((volatile unsigned int  *) (VIC_BASE + 0x498)))      /* R/W interrupt request 14 control register */
#define VIC_INT_REQUEST_39	(*((volatile unsigned int  *) (VIC_BASE + 0x49C)))      /* R/W interrupt request 15 control register */
#define VIC_INT_REQUEST_40	(*((volatile unsigned int  *) (VIC_BASE + 0x4A0)))      /* R/W interrupt request 16 control register */
#define VIC_INT_REQUEST_41	(*((volatile unsigned int  *) (VIC_BASE + 0x4A4)))      /* R/W interrupt request 17 control register */
#define VIC_INT_REQUEST_42	(*((volatile unsigned int  *) (VIC_BASE + 0x4A8)))      /* R/W interrupt request 18 control register */
#define VIC_INT_REQUEST_43	(*((volatile unsigned int  *) (VIC_BASE + 0x4AC)))      /* R/W interrupt request 19 control register */
#define VIC_INT_REQUEST_44	(*((volatile unsigned int  *) (VIC_BASE + 0x4B0)))      /* R/W interrupt request 20 control register */
#define VIC_INT_REQUEST_45	(*((volatile unsigned int  *) (VIC_BASE + 0x4B4)))      /* R/W interrupt request 21 control register */
#define VIC_INT_REQUEST_46	(*((volatile unsigned int  *) (VIC_BASE + 0x4B8)))      /* R/W interrupt request 22 control register */
#define VIC_INT_REQUEST_47	(*((volatile unsigned int  *) (VIC_BASE + 0x4BC)))      /* R/W interrupt request 23 control register */
#define VIC_INT_REQUEST_48	(*((volatile unsigned int  *) (VIC_BASE + 0x4C0)))      /* R/W interrupt request 24 control register */
#define VIC_INT_REQUEST_49	(*((volatile unsigned int  *) (VIC_BASE + 0x4C4)))      /* R/W interrupt request 25 control register */
#define VIC_INT_REQUEST_50	(*((volatile unsigned int  *) (VIC_BASE + 0x4C8)))      /* R/W interrupt request 26 control register */
#define VIC_INT_REQUEST_51	(*((volatile unsigned int  *) (VIC_BASE + 0x4CC)))      /* R/W interrupt request 27 control register */
#define VIC_INT_REQUEST_52	(*((volatile unsigned int  *) (VIC_BASE + 0x4D0)))      /* R/W interrupt request 28 control register */
#define VIC_INT_REQUEST_53	(*((volatile unsigned int  *) (VIC_BASE + 0x4D4)))      /* R/W interrupt request 29 control register */
#define VIC_INT_REQUEST_54	(*((volatile unsigned int  *) (VIC_BASE + 0x4D8)))      /* R/W interrupt request 30 control register */
#define VIC_INT_REQUEST_55	(*((volatile unsigned int  *) (VIC_BASE + 0x4DC)))      /* R/W interrupt request 31 control register */


#endif  // _LPC29xx_H
