/**************************************************************************
**                                                                        *
**  FILE        :  lpc288x.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**		   LPC2880, LPC2888					  *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC288x_H
#define _LPC288x_H


/*
** EV Event Router
*/

#define EV_BASE 0x80000000


#define EV_IOMK20               (*((volatile unsigned int ) (EV_BASE + 0x1440)))
#define EV_IOMK21               (*((volatile unsigned int ) (EV_BASE + 0x1444)))
#define EV_IOMK22               (*((volatile unsigned int ) (EV_BASE + 0x1448)))
#define EV_IOMK23               (*((volatile unsigned int ) (EV_BASE + 0x144C)))
#define EV_IOMK30               (*((volatile unsigned int ) (EV_BASE + 0x1460)))
#define EV_IOMK31               (*((volatile unsigned int ) (EV_BASE + 0x1464)))
#define EV_IOMK32               (*((volatile unsigned int ) (EV_BASE + 0x1468)))
#define EV_IOMK33               (*((volatile unsigned int ) (EV_BASE + 0x146C)))
#define EV_IOMK40               (*((volatile unsigned int ) (EV_BASE + 0x1480)))
#define EV_IOMK41               (*((volatile unsigned int ) (EV_BASE + 0x1484)))
#define EV_IOMK42               (*((volatile unsigned int ) (EV_BASE + 0x1488)))
#define EV_IOMK43               (*((volatile unsigned int ) (EV_BASE + 0x148C)))

#define EV_IOMC00               (*((volatile unsigned int ) (EV_BASE + 0x1800)))
#define EV_IOMC01               (*((volatile unsigned int ) (EV_BASE + 0x1804)))
#define EV_IOMC02               (*((volatile unsigned int ) (EV_BASE + 0x1808)))
#define EV_IOMC03               (*((volatile unsigned int ) (EV_BASE + 0x180C)))
#define EV_IOMC10               (*((volatile unsigned int ) (EV_BASE + 0x1820)))
#define EV_IOMC11               (*((volatile unsigned int ) (EV_BASE + 0x1824)))
#define EV_IOMC12               (*((volatile unsigned int ) (EV_BASE + 0x1828)))
#define EV_IOMC13               (*((volatile unsigned int ) (EV_BASE + 0x182C)))
#define EV_IOMC20               (*((volatile unsigned int ) (EV_BASE + 0x1840)))
#define EV_IOMC21               (*((volatile unsigned int ) (EV_BASE + 0x1844)))
#define EV_IOMC22               (*((volatile unsigned int ) (EV_BASE + 0x1848)))
#define EV_IOMC23               (*((volatile unsigned int ) (EV_BASE + 0x184C)))
#define EV_IOMC30               (*((volatile unsigned int ) (EV_BASE + 0x1860)))
#define EV_IOMC31               (*((volatile unsigned int ) (EV_BASE + 0x1864)))
#define EV_IOMC32               (*((volatile unsigned int ) (EV_BASE + 0x1868)))
#define EV_IOMC33               (*((volatile unsigned int ) (EV_BASE + 0x186C)))
#define EV_IOMC40               (*((volatile unsigned int ) (EV_BASE + 0x1880)))
#define EV_IOMC41               (*((volatile unsigned int ) (EV_BASE + 0x1884)))
#define EV_IOMC42               (*((volatile unsigned int ) (EV_BASE + 0x1888)))
#define EV_IOMC43               (*((volatile unsigned int ) (EV_BASE + 0x188C)))

#define EV_IOMS00               (*((volatile unsigned int ) (EV_BASE + 0x1C00)))
#define EV_IOMS01               (*((volatile unsigned int ) (EV_BASE + 0x1C04)))
#define EV_IOMS02               (*((volatile unsigned int ) (EV_BASE + 0x1C08)))
#define EV_IOMS03               (*((volatile unsigned int ) (EV_BASE + 0x1C0C)))
#define EV_IOMS10               (*((volatile unsigned int ) (EV_BASE + 0x1C20)))
#define EV_IOMS11               (*((volatile unsigned int ) (EV_BASE + 0x1C24)))
#define EV_IOMS12               (*((volatile unsigned int ) (EV_BASE + 0x1C28)))
#define EV_IOMS13               (*((volatile unsigned int ) (EV_BASE + 0x1C2C)))
#define EV_IOMS20               (*((volatile unsigned int ) (EV_BASE + 0x1C40)))
#define EV_IOMS21               (*((volatile unsigned int ) (EV_BASE + 0x1C44)))
#define EV_IOMS22               (*((volatile unsigned int ) (EV_BASE + 0x1C48)))
#define EV_IOMS23               (*((volatile unsigned int ) (EV_BASE + 0x1C4C)))
#define EV_IOMS30               (*((volatile unsigned int ) (EV_BASE + 0x1C60)))
#define EV_IOMS31               (*((volatile unsigned int ) (EV_BASE + 0x1C64)))
#define EV_IOMS32               (*((volatile unsigned int ) (EV_BASE + 0x1C68)))
#define EV_IOMS33               (*((volatile unsigned int ) (EV_BASE + 0x1C6C)))
#define EV_IOMS40               (*((volatile unsigned int ) (EV_BASE + 0x1C80)))
#define EV_IOMS41               (*((volatile unsigned int ) (EV_BASE + 0x1C84)))
#define EV_IOMS42               (*((volatile unsigned int ) (EV_BASE + 0x1C88)))
#define EV_IOMS43               (*((volatile unsigned int ) (EV_BASE + 0x1C8C)))


/*
** RTC Real Time Clock
*/

#define RTC_BASE 0x80002000

#define RTC_ILR            	(*((volatile unsigned int *) (RTC_BASE + 0x00)))
#define RTC_CTC            	(*((volatile unsigned int *) (RTC_BASE + 0x04)))
#define RTC_CCR            	(*((volatile unsigned int *) (RTC_BASE + 0x08)))
#define RTC_CIIR           	(*((volatile unsigned int *) (RTC_BASE + 0x0C)))
#define RTC_AMR            	(*((volatile unsigned int *) (RTC_BASE + 0x10)))
#define RTC_CTIME0         	(*((volatile unsigned int *) (RTC_BASE + 0x14)))
#define RTC_CTIME1         	(*((volatile unsigned int *) (RTC_BASE + 0x18)))
#define RTC_CTIME2         	(*((volatile unsigned int *) (RTC_BASE + 0x1C)))
#define RTC_SEC            	(*((volatile unsigned int *) (RTC_BASE + 0x20)))
#define RTC_MIN            	(*((volatile unsigned int *) (RTC_BASE + 0x24)))
#define RTC_HOUR           	(*((volatile unsigned int *) (RTC_BASE + 0x28)))
#define RTC_DOM            	(*((volatile unsigned int *) (RTC_BASE + 0x2C)))
#define RTC_DOW            	(*((volatile unsigned int *) (RTC_BASE + 0x30)))
#define RTC_DOY            	(*((volatile unsigned int *) (RTC_BASE + 0x34)))
#define RTC_MONTH          	(*((volatile unsigned int *) (RTC_BASE + 0x38)))
#define RTC_YEAR           	(*((volatile unsigned int *) (RTC_BASE + 0x3C)))
#define RTC_CISS           	(*((volatile unsigned int *) (RTC_BASE + 0x40)))
#define RTC_ALSEC          	(*((volatile unsigned int *) (RTC_BASE + 0x60)))
#define RTC_ALMIN          	(*((volatile unsigned int *) (RTC_BASE + 0x64)))
#define RTC_ALHOUR         	(*((volatile unsigned int *) (RTC_BASE + 0x68)))
#define RTC_ALDOM          	(*((volatile unsigned int *) (RTC_BASE + 0x6C)))
#define RTC_ALDOW          	(*((volatile unsigned int *) (RTC_BASE + 0x70)))
#define RTC_ALDOY          	(*((volatile unsigned int *) (RTC_BASE + 0x74)))
#define RTC_ALMON          	(*((volatile unsigned int *) (RTC_BASE + 0x78)))
#define RTC_ALYEAR         	(*((volatile unsigned int *) (RTC_BASE + 0x7C)))

#define RTC_CFG			(SCR_RTC_CFG)


/*
** ADC Analog to Digital Converter
*/

#define ADC_BASE 0x80002400

#define ADCR0           	(*((volatile unsigned int *) (ADC_BASE + 0x00)))
#define ADCR1           	(*((volatile unsigned int *) (ADC_BASE + 0x04)))
#define ADCR2           	(*((volatile unsigned int *) (ADC_BASE + 0x08)))
#define ADCR3           	(*((volatile unsigned int *) (ADC_BASE + 0x0C)))
#define ADCR4           	(*((volatile unsigned int *) (ADC_BASE + 0x10)))
#define ADCR5           	(*((volatile unsigned int *) (ADC_BASE + 0x14)))
#define ADCCON          	(*((volatile unsigned int *) (ADC_BASE + 0x20)))
#define ADCSEL          	(*((volatile unsigned int *) (ADC_BASE + 0x24)))
#define ADCINTE         	(*((volatile unsigned int *) (ADC_BASE + 0x28)))
#define ADCINTS         	(*((volatile unsigned int *) (ADC_BASE + 0x2C)))
#define ADCINTC         	(*((volatile unsigned int *) (ADC_BASE + 0x30)))

#define ADCPD           	(SCR_ADCPD)


/*
** WDT Watchdog Timer
*/

#define WDT_BASE 0x80002800

#define WDT_SR            	(*((volatile unsigned int *) (WDT_BASE + 0x00)))
#define WDT_TCR            	(*((volatile unsigned int *) (WDT_BASE + 0x04)))
#define WDT_TC            	(*((volatile unsigned int *) (WDT_BASE + 0x08)))
#define WDT_PR            	(*((volatile unsigned int *) (WDT_BASE + 0x0C)))
#define WDT_MCR            	(*((volatile unsigned int *) (WDT_BASE + 0x14)))
#define WDT_MR0            	(*((volatile unsigned int *) (WDT_BASE + 0x18)))
#define WDT_MR1            	(*((volatile unsigned int *) (WDT_BASE + 0x1C)))
#define WDT_EMR            	(*((volatile unsigned int *) (WDT_BASE + 0x3C)))


/*
** IOCONF I/O Configuration
*/

#define IOCONF_BASE 0x80003000

/* Port 0 (EMC) registers */
#define IOCONF_PINS0            (*((volatile unsigned int *) (IOCONF_BASE + 0x000)))
#define IOCONF_MODE00           (*((volatile unsigned int *) (IOCONF_BASE + 0x010)))
#define IOCONF_MODE0S0          (*((volatile unsigned int *) (IOCONF_BASE + 0x014)))
#define IOCONF_MODE0C0          (*((volatile unsigned int *) (IOCONF_BASE + 0x018)))
#define IOCONF_MODE10           (*((volatile unsigned int *) (IOCONF_BASE + 0x020)))
#define IOCONF_MODE1S0          (*((volatile unsigned int *) (IOCONF_BASE + 0x024)))
#define IOCONF_MODE1C0          (*((volatile unsigned int *) (IOCONF_BASE + 0x028)))

/* Port 1 (EMC) Registers */
#define IOCONF_PINS1            (*((volatile unsigned int *) (IOCONF_BASE + 0x040)))
#define IOCONF_MODE01           (*((volatile unsigned int *) (IOCONF_BASE + 0x050)))
#define IOCONF_MODE0S1          (*((volatile unsigned int *) (IOCONF_BASE + 0x054)))
#define IOCONF_MODE0C1          (*((volatile unsigned int *) (IOCONF_BASE + 0x058)))
#define IOCONF_MODE11           (*((volatile unsigned int *) (IOCONF_BASE + 0x060)))
#define IOCONF_MODE1S1          (*((volatile unsigned int *) (IOCONF_BASE + 0x064)))
#define IOCONF_MODE1C1          (*((volatile unsigned int *) (IOCONF_BASE + 0x068)))

/* Port 2 (GPIO) registers */
#define IOCONF_PINS2            (*((volatile unsigned int *) (IOCONF_BASE + 0x080)))
#define IOCONF_MODE02           (*((volatile unsigned int *) (IOCONF_BASE + 0x090)))
#define IOCONF_MODE0S2          (*((volatile unsigned int *) (IOCONF_BASE + 0x094)))
#define IOCONF_MODE0C2          (*((volatile unsigned int *) (IOCONF_BASE + 0x098)))
#define IOCONF_MODE12           (*((volatile unsigned int *) (IOCONF_BASE + 0x0A0)))
#define IOCONF_MODE1S2          (*((volatile unsigned int *) (IOCONF_BASE + 0x0A4)))
#define IOCONF_MODE1C2          (*((volatile unsigned int *) (IOCONF_BASE + 0x0A8)))

/* Port 3 (DAI/DAO) Registers */
#define IOCONF_PINS3            (*((volatile unsigned int *) (IOCONF_BASE + 0x0C0)))
#define IOCONF_MODE03           (*((volatile unsigned int *) (IOCONF_BASE + 0x0D0)))
#define IOCONF_MODE0S3          (*((volatile unsigned int *) (IOCONF_BASE + 0x0D4)))
#define IOCONF_MODE0C3          (*((volatile unsigned int *) (IOCONF_BASE + 0x0D8)))
#define IOCONF_MODE13           (*((volatile unsigned int *) (IOCONF_BASE + 0x0E0)))
#define IOCONF_MODE1S3          (*((volatile unsigned int *) (IOCONF_BASE + 0x0E4)))
#define IOCONF_MODE1C3          (*((volatile unsigned int *) (IOCONF_BASE + 0x0E8)))

/* Port 4 (LCD) Registers */
#define IOCONF_PINS4            (*((volatile unsigned int *) (IOCONF_BASE + 0x100)))
#define IOCONF_MODE04           (*((volatile unsigned int *) (IOCONF_BASE + 0x110)))
#define IOCONF_MODE0S4          (*((volatile unsigned int *) (IOCONF_BASE + 0x114)))
#define IOCONF_MODE0C4          (*((volatile unsigned int *) (IOCONF_BASE + 0x118)))
#define IOCONF_MODE14           (*((volatile unsigned int *) (IOCONF_BASE + 0x120)))
#define IOCONF_MODE1S4          (*((volatile unsigned int *) (IOCONF_BASE + 0x124)))
#define IOCONF_MODE1C4          (*((volatile unsigned int *) (IOCONF_BASE + 0x128)))

/* Port 5 (MCI/SD) Registers */
#define IOCONF_PINS5            (*((volatile unsigned int *) (IOCONF_BASE + 0x140)))
#define IOCONF_MODE05           (*((volatile unsigned int *) (IOCONF_BASE + 0x150)))
#define IOCONF_MODE0S5          (*((volatile unsigned int *) (IOCONF_BASE + 0x154)))
#define IOCONF_MODE0C5          (*((volatile unsigned int *) (IOCONF_BASE + 0x158)))
#define IOCONF_MODE15           (*((volatile unsigned int *) (IOCONF_BASE + 0x160)))
#define IOCONF_MODE1S5          (*((volatile unsigned int *) (IOCONF_BASE + 0x164)))
#define IOCONF_MODE1C5          (*((volatile unsigned int *) (IOCONF_BASE + 0x168)))

/* Port 6 (UART) Registers */
#define IOCONF_PINS6            (*((volatile unsigned int *) (IOCONF_BASE + 0x180)))
#define IOCONF_MODE06           (*((volatile unsigned int *) (IOCONF_BASE + 0x190)))
#define IOCONF_MODE0S6          (*((volatile unsigned int *) (IOCONF_BASE + 0x194)))
#define IOCONF_MODE0C6          (*((volatile unsigned int *) (IOCONF_BASE + 0x198)))
#define IOCONF_MODE16           (*((volatile unsigned int *) (IOCONF_BASE + 0x1A0)))
#define IOCONF_MODE1S6          (*((volatile unsigned int *) (IOCONF_BASE + 0x1A4)))
#define IOCONF_MODE1C6          (*((volatile unsigned int *) (IOCONF_BASE + 0x1A8)))

/* Port 7 (USB) Registers */
#define IOCONF_PINS7            (*((volatile unsigned int *) (IOCONF_BASE + 0x1C0)))
#define IOCONF_MODE07           (*((volatile unsigned int *) (IOCONF_BASE + 0x1D0)))
#define IOCONF_MODE0S7          (*((volatile unsigned int *) (IOCONF_BASE + 0x1D4)))
#define IOCONF_MODE0C7          (*((volatile unsigned int *) (IOCONF_BASE + 0x1D8)))
#define IOCONF_MODE17           (*((volatile unsigned int *) (IOCONF_BASE + 0x1E0)))
#define IOCONF_MODE1S7          (*((volatile unsigned int *) (IOCONF_BASE + 0x1E4)))
#define IOCONF_MODE1C7          (*((volatile unsigned int *) (IOCONF_BASE + 0x1E8)))


/*
** CGUS Clock Generation Unit Switchbox
*/

#define CGUS_BASE 0x80004000

/* Switch configuration registers */
#define CGUS_SYSSCR             (*((volatile unsigned int *) (CGUS_BASE + 0x000)))
#define CGUS_APB0SCR            (*((volatile unsigned int *) (CGUS_BASE + 0x004)))
#define CGUS_APB1SCR            (*((volatile unsigned int *) (CGUS_BASE + 0x008)))
#define CGUS_APB3SCR            (*((volatile unsigned int *) (CGUS_BASE + 0x00C)))
#define CGUS_DCDCSCR            (*((volatile unsigned int *) (CGUS_BASE + 0x010)))
#define CGUS_RTCSCR             (*((volatile unsigned int *) (CGUS_BASE + 0x014)))
#define CGUS_MCISCR             (*((volatile unsigned int *) (CGUS_BASE + 0x018)))
#define CGUS_UARTSCR            (*((volatile unsigned int *) (CGUS_BASE + 0x01C)))
#define CGUS_DAIOSCR            (*((volatile unsigned int *) (CGUS_BASE + 0x020)))
#define CGUS_DAISCR             (*((volatile unsigned int *) (CGUS_BASE + 0x024)))

/* Frequency select 1 registers */
#define CGUS_SYSFSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x02C)))
#define CGUS_APB0FSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x030)))
#define CGUS_APB1FSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x034)))
#define CGUS_APB3FSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x038)))
#define CGUS_DCDCFSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x03C)))
#define CGUS_RTCFSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x040)))
#define CGUS_MCIFSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x044)))
#define CGUS_UARTFSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x048)))
#define CGUS_DAIOFSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x04C)))
#define CGUS_DAIFSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x050)))

/* Frequency select 2 registers */
#define CGUS_SYSFSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x058)))
#define CGUS_APB0FSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x05C)))
#define CGUS_APB1FSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x060)))
#define CGUS_APB3FSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x064)))
#define CGUS_DCDCFSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x068)))
#define CGUS_RTCFSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x06C)))
#define CGUS_MCIFSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x070)))
#define CGUS_UARTFSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x074)))
#define CGUS_DAIOFSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x078)))
#define CGUS_DAIFSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x07C)))

/* Switch status registers */
#define CGUS_SYSSSR             (*((volatile unsigned int *) (CGUS_BASE + 0x084)))
#define CGUS_APB0SSR            (*((volatile unsigned int *) (CGUS_BASE + 0x088)))
#define CGUS_APB1SSR            (*((volatile unsigned int *) (CGUS_BASE + 0x08C)))
#define CGUS_APB3SSR            (*((volatile unsigned int *) (CGUS_BASE + 0x090)))
#define CGUS_DCDCSSR            (*((volatile unsigned int *) (CGUS_BASE + 0x094)))
#define CGUS_RTCSSR             (*((volatile unsigned int *) (CGUS_BASE + 0x098)))
#define CGUS_MCISSR             (*((volatile unsigned int *) (CGUS_BASE + 0x09C)))
#define CGUS_UARTSSR            (*((volatile unsigned int *) (CGUS_BASE + 0x0A0)))
#define CGUS_DAIOSSR            (*((volatile unsigned int *) (CGUS_BASE + 0x0A4)))
#define CGUS_DAISSR             (*((volatile unsigned int *) (CGUS_BASE + 0x0A8)))

/* Power control registers */
#define CGUS_APB0PCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0B0)))
#define CGUS_APB1PCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0B4)))
#define CGUS_APB2PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x0B8)))
#define CGUS_APB3PCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0BC)))
#define CGUS_MMIOPCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0C0)))
#define CGUS_AHB0PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x0C4)))
#define CGUS_MCIPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x0C8)))
#define CGUS_MCIPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x0CC)))
#define CGUS_UARTPCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0D0)))
#define CGUS_UNUSEDCR0          (*((volatile unsigned int *) (CGUS_BASE + 0x0D4)))
#define CGUS_UNUSEDCR1          (*((volatile unsigned int *) (CGUS_BASE + 0x0D8)))
#define CGUS_FLSHPCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x0DC)))
#define CGUS_FLSHPCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x0E0)))
#define CGUS_FLSHPCR2           (*((volatile unsigned int *) (CGUS_BASE + 0x0E4)))
#define CGUS_LCDPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x0E8)))
#define CGUS_LCDPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x0EC)))
#define CGUS_DMAPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x0F0)))
#define CGUS_DMAPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x0F4)))
#define CGUS_USBPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x0F8)))
#define CGUS_CPUPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x0FC)))
#define CGUS_CPUPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x100)))
#define CGUS_CPUPCR2            (*((volatile unsigned int *) (CGUS_BASE + 0x104)))
#define CGUS_RAMPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x108)))
#define CGUS_ROMPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x10C)))
#define CGUS_EMCPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x110)))
#define CGUS_EMCPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x114)))
#define CGUS_MMIOPCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x118)))
#define CGUS_APB0PCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x11C)))
#define CGUS_EVRTPCR            (*((volatile unsigned int *) (CGUS_BASE + 0x120)))
#define CGUS_RTCPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x124)))
#define CGUS_ADCPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x128)))
#define CGUS_ADCPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x12C)))
#define CGUS_WDTPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x130)))
#define CGUS_IOCPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x134)))
#define CGUS_CGUPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x138)))
#define CGUS_SYSCPCR            (*((volatile unsigned int *) (CGUS_BASE + 0x13C)))
#define CGUS_APB1PCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x140)))
#define CGUS_T0PCR              (*((volatile unsigned int *) (CGUS_BASE + 0x144)))
#define CGUS_T1PCR              (*((volatile unsigned int *) (CGUS_BASE + 0x148)))
#define CGUS_I2CPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x14C)))
#define CGUS_APB3PCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x150)))
#define CGUS_SCONPCR            (*((volatile unsigned int *) (CGUS_BASE + 0x154)))
#define CGUS_DAIPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x158)))
#define CGUS_UNUSEDCR2          (*((volatile unsigned int *) (CGUS_BASE + 0x15C)))
#define CGUS_DAOPCR0            (*((volatile unsigned int *) (CGUS_BASE + 0x160)))
#define CGUS_SIOPCR             (*((volatile unsigned int *) (CGUS_BASE + 0x164)))
#define CGUS_SAI1PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x168)))
#define CGUS_UNUSEDCR3          (*((volatile unsigned int *) (CGUS_BASE + 0x16C)))
#define CGUS_UNUSEDCR4          (*((volatile unsigned int *) (CGUS_BASE + 0x170)))
#define CGUS_SAI4PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x174)))
#define CGUS_SAO1PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x178)))
#define CGUS_SAO2PCR            (*((volatile unsigned int *) (CGUS_BASE + 0x17C)))
#define CGUS_UNUSEDCR5          (*((volatile unsigned int *) (CGUS_BASE + 0x180)))
#define CGUS_DDACPCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x184)))
#define CGUS_EDGEPCR            (*((volatile unsigned int *) (CGUS_BASE + 0x188)))
#define CGUS_DADCPCR0           (*((volatile unsigned int *) (CGUS_BASE + 0x18C)))
#define CGUS_DCDCPCR            (*((volatile unsigned int *) (CGUS_BASE + 0x190)))
#define CGUS_RTCPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x194)))
#define CGUS_MCIPCR2            (*((volatile unsigned int *) (CGUS_BASE + 0x198)))
#define CGUS_UARTPCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x19C)))
#define CGUS_DDACPCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x1A0)))
#define CGUS_DDACPCR2           (*((volatile unsigned int *) (CGUS_BASE + 0x1A4)))
#define CGUS_DADCPCR1           (*((volatile unsigned int *) (CGUS_BASE + 0x1A8)))
#define CGUS_DADCPCR2           (*((volatile unsigned int *) (CGUS_BASE + 0x1AC)))
#define CGUS_DAIPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x1B0)))
#define CGUS_DAIPCR2            (*((volatile unsigned int *) (CGUS_BASE + 0x1B4)))
#define CGUS_DAOPCR1            (*((volatile unsigned int *) (CGUS_BASE + 0x1B8)))
#define CGUS_DAOPCR2            (*((volatile unsigned int *) (CGUS_BASE + 0x1BC)))
#define CGUS_DAOPCR3            (*((volatile unsigned int *) (CGUS_BASE + 0x1C0)))
#define CGUS_DAIPCR3            (*((volatile unsigned int *) (CGUS_BASE + 0x1C4)))
#define CGUS_UNUSEDCR6          (*((volatile unsigned int *) (CGUS_BASE + 0x1C8)))

/* Power status registers */
#define CGUS_APB0PSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1CC)))
#define CGUS_APB1PSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1D0)))
#define CGUS_APB2PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x1D4)))
#define CGUS_APB3PSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1D8)))
#define CGUS_MMIOPSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1DC)))
#define CGUS_AHB0PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x1E0)))
#define CGUS_MCIPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x1E4)))
#define CGUS_MCIPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x1E8)))
#define CGUS_UARTPSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1EC)))
#define CGUS_FLSHPSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x1F8)))
#define CGUS_FLSHPSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x1FC)))
#define CGUS_FLSHPSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x200)))
#define CGUS_LCDPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x204)))
#define CGUS_LCDPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x208)))
#define CGUS_DMAPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x20C)))
#define CGUS_DMAPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x210)))
#define CGUS_USBPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x214)))
#define CGUS_CPUPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x218)))
#define CGUS_CPUPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x21C)))
#define CGUS_CPUPSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x220)))
#define CGUS_RAMPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x224)))
#define CGUS_ROMPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x228)))
#define CGUS_EMCPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x22C)))
#define CGUS_EMCPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x230)))
#define CGUS_MMIOPSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x234)))
#define CGUS_APB0PSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x238)))
#define CGUS_EVRTPSR            (*((volatile unsigned int *) (CGUS_BASE + 0x23C)))
#define CGUS_RTCPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x240)))
#define CGUS_ADCPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x244)))
#define CGUS_ADCPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x248)))
#define CGUS_WDTPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x24C)))
#define CGUS_IOCPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x250)))
#define CGUS_CGUPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x254)))
#define CGUS_SYSCPSR            (*((volatile unsigned int *) (CGUS_BASE + 0x258)))
#define CGUS_APB1PSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x25C)))
#define CGUS_T0PSR              (*((volatile unsigned int *) (CGUS_BASE + 0x260)))
#define CGUS_T1PSR              (*((volatile unsigned int *) (CGUS_BASE + 0x264)))
#define CGUS_I2CPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x268)))
#define CGUS_APB3PSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x26C)))
#define CGUS_SCONPSR            (*((volatile unsigned int *) (CGUS_BASE + 0x270)))
#define CGUS_DAIPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x274)))
#define CGUS_DAOPSR0            (*((volatile unsigned int *) (CGUS_BASE + 0x27C)))
#define CGUS_SIOPSR             (*((volatile unsigned int *) (CGUS_BASE + 0x280)))
#define CGUS_SAI1PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x284)))
#define CGUS_SAI4PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x290)))
#define CGUS_SAO1PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x294)))
#define CGUS_SAO2PSR            (*((volatile unsigned int *) (CGUS_BASE + 0x298)))
#define CGUS_DDACPSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2A0)))
#define CGUS_EDGEPSR            (*((volatile unsigned int *) (CGUS_BASE + 0x2A4)))
#define CGUS_DADCPSR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2A8)))
#define CGUS_DCDCPSR            (*((volatile unsigned int *) (CGUS_BASE + 0x2AC)))
#define CGUS_RTCPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x2B0)))
#define CGUS_MCIPSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x2B4)))
#define CGUS_UARTPSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x2B8)))
#define CGUS_DDACPSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x2BC)))
#define CGUS_DDACPSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x2C0)))
#define CGUS_DADCPSR1           (*((volatile unsigned int *) (CGUS_BASE + 0x2C4)))
#define CGUS_DADCPSR2           (*((volatile unsigned int *) (CGUS_BASE + 0x2C8)))
#define CGUS_DAIPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x2CC)))
#define CGUS_DAIPSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x2D0)))
#define CGUS_DAOPSR1            (*((volatile unsigned int *) (CGUS_BASE + 0x2D4)))
#define CGUS_DAOPSR2            (*((volatile unsigned int *) (CGUS_BASE + 0x2D8)))
#define CGUS_DAOPSR3            (*((volatile unsigned int *) (CGUS_BASE + 0x2DC)))
#define CGUS_DAIPSR3            (*((volatile unsigned int *) (CGUS_BASE + 0x2E0)))

/* Enable select registers */
#define CGUS_APB0ESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2E8)))
#define CGUS_APB1ESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2EC)))
#define CGUS_APB2ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x2F0)))
#define CGUS_APB3ESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2F4)))
#define CGUS_MMIOESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x2F8)))
#define CGUS_AHB0ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x2FC)))
#define CGUS_MCIESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x300)))
#define CGUS_MCIESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x304)))
#define CGUS_UARTESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x308)))
#define CGUS_FLSHESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x314)))
#define CGUS_FLSHESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x318)))
#define CGUS_FLSHESR2           (*((volatile unsigned int *) (CGUS_BASE + 0x31C)))
#define CGUS_LCDESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x320)))
#define CGUS_LCDESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x324)))
#define CGUS_DMAESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x328)))
#define CGUS_DMAESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x32C)))
#define CGUS_USBESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x330)))
#define CGUS_CPUESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x334)))
#define CGUS_CPUESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x338)))
#define CGUS_CPUESR2            (*((volatile unsigned int *) (CGUS_BASE + 0x33C)))
#define CGUS_RAMESR             (*((volatile unsigned int *) (CGUS_BASE + 0x340)))
#define CGUS_ROMESR             (*((volatile unsigned int *) (CGUS_BASE + 0x344)))
#define CGUS_EMCESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x348)))
#define CGUS_EMCESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x34C)))
#define CGUS_MMIOESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x350)))
#define CGUS_APB0ESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x354)))
#define CGUS_EVRTESR            (*((volatile unsigned int *) (CGUS_BASE + 0x358)))
#define CGUS_RTCESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x35C)))
#define CGUS_ADCESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x360)))
#define CGUS_ADCESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x364)))
#define CGUS_WDTESR             (*((volatile unsigned int *) (CGUS_BASE + 0x368)))
#define CGUS_IOCESR             (*((volatile unsigned int *) (CGUS_BASE + 0x36C)))
#define CGUS_CGUESR             (*((volatile unsigned int *) (CGUS_BASE + 0x370)))
#define CGUS_SYSCESR            (*((volatile unsigned int *) (CGUS_BASE + 0x374)))
#define CGUS_APB1ESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x378)))
#define CGUS_T0ESR              (*((volatile unsigned int *) (CGUS_BASE + 0x37C)))
#define CGUS_T1ESR              (*((volatile unsigned int *) (CGUS_BASE + 0x380)))
#define CGUS_I2CESR             (*((volatile unsigned int *) (CGUS_BASE + 0x384)))
#define CGUS_APB3ESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x388)))
#define CGUS_SCONESR            (*((volatile unsigned int *) (CGUS_BASE + 0x38C)))
#define CGUS_DAIESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x390)))
#define CGUS_DAOESR0            (*((volatile unsigned int *) (CGUS_BASE + 0x398)))
#define CGUS_SIOESR             (*((volatile unsigned int *) (CGUS_BASE + 0x39C)))
#define CGUS_SAI1ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x3A0)))
#define CGUS_SAI4ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x3AC)))
#define CGUS_SAO1ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x3B0)))
#define CGUS_SAO2ESR            (*((volatile unsigned int *) (CGUS_BASE + 0x3B4)))
#define CGUS_DDACESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x3BC)))
#define CGUS_EDGEESR            (*((volatile unsigned int *) (CGUS_BASE + 0x3C0)))
#define CGUS_DADCESR0           (*((volatile unsigned int *) (CGUS_BASE + 0x3C4)))
#define CGUS_UARTESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x3C8)))
#define CGUS_DDACESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x3CC)))
#define CGUS_DDACESR2           (*((volatile unsigned int *) (CGUS_BASE + 0x3D0)))
#define CGUS_DADCESR1           (*((volatile unsigned int *) (CGUS_BASE + 0x3D4)))
#define CGUS_DADCESR2           (*((volatile unsigned int *) (CGUS_BASE + 0x3D8)))
#define CGUS_DAIESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x3DC)))
#define CGUS_DAIESR2            (*((volatile unsigned int *) (CGUS_BASE + 0x3E0)))
#define CGUS_DAOESR1            (*((volatile unsigned int *) (CGUS_BASE + 0x3E4)))
#define CGUS_DAOESR2            (*((volatile unsigned int *) (CGUS_BASE + 0x3E8)))
#define CGUS_DAOESR3            (*((volatile unsigned int *) (CGUS_BASE + 0x3EC)))

/* Base control registers */
#define CGUS_SYSBCR             (*((volatile unsigned int *) (CGUS_BASE + 0x3F0)))
#define CGUS_APB0BCR            (*((volatile unsigned int *) (CGUS_BASE + 0x3F4)))
#define CGUS_DAIOBCR            (*((volatile unsigned int *) (CGUS_BASE + 0x3F8)))

/* Fractional divider configuration registers */
#define CGUS_SYSFDCR0           (*((volatile unsigned int *) (CGUS_BASE + 0X3FC)))
#define CGUS_SYSFDCR1           (*((volatile unsigned int *) (CGUS_BASE + 0X400)))
#define CGUS_SYSFDCR2           (*((volatile unsigned int *) (CGUS_BASE + 0X404)))
#define CGUS_SYSFDCR3           (*((volatile unsigned int *) (CGUS_BASE + 0X408)))
#define CGUS_SYSFDCR4           (*((volatile unsigned int *) (CGUS_BASE + 0X40C)))
#define CGUS_SYSFDCR5           (*((volatile unsigned int *) (CGUS_BASE + 0X410)))
#define CGUS_APB0FDCR0          (*((volatile unsigned int *) (CGUS_BASE + 0X414)))
#define CGUS_APB0FDCR1          (*((volatile unsigned int *) (CGUS_BASE + 0X418)))
#define CGUS_APB1FDCR           (*((volatile unsigned int *) (CGUS_BASE + 0X41C)))
#define CGUS_APB3FDCR           (*((volatile unsigned int *) (CGUS_BASE + 0X420)))
#define CGUS_UARTFDCR           (*((volatile unsigned int *) (CGUS_BASE + 0X424)))
#define CGUS_DAIOFDCR0          (*((volatile unsigned int *) (CGUS_BASE + 0X428)))
#define CGUS_DAIOFDCR1          (*((volatile unsigned int *) (CGUS_BASE + 0X42C)))
#define CGUS_DAIOFDCR2          (*((volatile unsigned int *) (CGUS_BASE + 0X430)))
#define CGUS_DAIOFDCR3          (*((volatile unsigned int *) (CGUS_BASE + 0X434)))
#define CGUS_DAIOFDCR4          (*((volatile unsigned int *) (CGUS_BASE + 0X438)))
#define CGUS_DAIOFDCR5          (*((volatile unsigned int *) (CGUS_BASE + 0X43C)))


/*
** CGU Clock Generation Unit
*/

#define CGU_BASE 0x80004C00

/* CGU configuration registers */
#define CGU_PMODE		(*((volatile unsigned int *) (CGU_BASE + 0x00)))
#define CGU_WDBARK		(*((volatile unsigned int *) (CGU_BASE + 0x04)))
#define CGU_OSC32EN		(*((volatile unsigned int *) (CGU_BASE + 0x08)))
#define CGU_OSCEN		(*((volatile unsigned int *) (CGU_BASE + 0x10)))

/* Software reset registers */
#define CGU_APB0RES		(*((volatile unsigned int *) (CGU_BASE + 0x18)))
#define CGU_APB0RES2		(*((volatile unsigned int *) (CGU_BASE + 0x1C)))
#define CGU_APB1RES		(*((volatile unsigned int *) (CGU_BASE + 0x20)))
#define CGU_APB1RES2		(*((volatile unsigned int *) (CGU_BASE + 0x24)))
#define CGU_APB2RES		(*((volatile unsigned int *) (CGU_BASE + 0x28)))
#define CGU_APB3RES		(*((volatile unsigned int *) (CGU_BASE + 0x2C)))
#define CGU_APB3RES2		(*((volatile unsigned int *) (CGU_BASE + 0x30)))
#define CGU_MMIORES		(*((volatile unsigned int *) (CGU_BASE + 0x34)))
#define CGU_AHB0RES		(*((volatile unsigned int *) (CGU_BASE + 0x38)))
#define CGU_T0RES		(*((volatile unsigned int *) (CGU_BASE + 0x3C)))
#define CGU_T1RES		(*((volatile unsigned int *) (CGU_BASE + 0x40)))
#define CGU_MCIRES		(*((volatile unsigned int *) (CGU_BASE + 0x44)))
#define CGU_MCIRES2		(*((volatile unsigned int *) (CGU_BASE + 0x48)))
#define CGU_UARTRES		(*((volatile unsigned int *) (CGU_BASE + 0x4C)))
#define CGU_I2CRES		(*((volatile unsigned int *) (CGU_BASE + 0x50)))
#define CGU_SCONRES		(*((volatile unsigned int *) (CGU_BASE + 0x58)))
#define CGU_DAIRES		(*((volatile unsigned int *) (CGU_BASE + 0x60)))
#define CGU_DAORES		(*((volatile unsigned int *) (CGU_BASE + 0x68)))
#define CGU_DADCRES		(*((volatile unsigned int *) (CGU_BASE + 0x6C)))
#define CGU_EDGERES		(*((volatile unsigned int *) (CGU_BASE + 0x70)))
#define CGU_DDACRES		(*((volatile unsigned int *) (CGU_BASE + 0x74)))
#define CGU_SAI1RES		(*((volatile unsigned int *) (CGU_BASE + 0x78)))
#define CGU_SAI4RES		(*((volatile unsigned int *) (CGU_BASE + 0x84)))
#define CGU_SAO1RES		(*((volatile unsigned int *) (CGU_BASE + 0x88)))
#define CGU_SAO2RES		(*((volatile unsigned int *) (CGU_BASE + 0x8C)))
#define CGU_FLSHRES		(*((volatile unsigned int *) (CGU_BASE + 0x94)))
#define CGU_LCDRES		(*((volatile unsigned int *) (CGU_BASE + 0x98)))
#define CGU_DMARES		(*((volatile unsigned int *) (CGU_BASE + 0x9C)))
#define CGU_USBRES		(*((volatile unsigned int *) (CGU_BASE + 0xA0)))
#define CGU_EMCRES		(*((volatile unsigned int *) (CGU_BASE + 0xA4)))
#define CGU_MMIORES2		(*((volatile unsigned int *) (CGU_BASE + 0xA8)))

/* High speed PLL registers */
#define CGU_HPFIN		(*((volatile unsigned int *) (CGU_BASE + 0xAC)))
#define CGU_HPMDEC		(*((volatile unsigned int *) (CGU_BASE + 0xB0)))
#define CGU_HPNDEC		(*((volatile unsigned int *) (CGU_BASE + 0xB4)))
#define CGU_HPPDEC		(*((volatile unsigned int *) (CGU_BASE + 0xB8)))
#define CGU_HPMODE		(*((volatile unsigned int *) (CGU_BASE + 0xBC)))
#define CGU_HPSTAT		(*((volatile unsigned int *) (CGU_BASE + 0xC0)))
#define CGU_HPACK		(*((volatile unsigned int *) (CGU_BASE + 0xC4)))
#define CGU_HPREQ		(*((volatile unsigned int *) (CGU_BASE + 0xC8)))
#define CGU_HPSELR		(*((volatile unsigned int *) (CGU_BASE + 0xD8)))
#define CGU_HPSELI		(*((volatile unsigned int *) (CGU_BASE + 0xDC)))
#define CGU_HPSELP		(*((volatile unsigned int *) (CGU_BASE + 0xE0)))

/* Main PLL registers */
#define CGU_LPFIN		(*((volatile unsigned int *) (CGU_BASE + 0xE4)))
#define CGU_LPPDN		(*((volatile unsigned int *) (CGU_BASE + 0xE8)))
#define CGU_LPMBYP		(*((volatile unsigned int *) (CGU_BASE + 0xEC)))
#define CGU_LPLOCK		(*((volatile unsigned int *) (CGU_BASE + 0xF0)))
#define CGU_LPDBYP		(*((volatile unsigned int *) (CGU_BASE + 0xF4)))
#define CGU_LPMSEL		(*((volatile unsigned int *) (CGU_BASE + 0xF8)))
#define CGU_LPPSEL		(*((volatile unsigned int *) (CGU_BASE + 0xFC)))


/*
** SCR System configuration registers
*/

#define SCR_BASE 0x80005000

/* DC-DC converter */
#define SCR_DCDCADJUST1		(*((volatile unsigned int *) (SCR_BASE + 0x04)))
#define SCR_DCDCADJUST2		(*((volatile unsigned int *) (SCR_BASE + 0x08)))
#define SCR_DCDCCLKSEL		(*((volatile unsigned int *) (SCR_BASE + 0x0C)))

/* RTC */
#define SCR_RTC_CFG		(*((volatile unsigned int *) (SCR_BASE + 0x24)))

/* ADC */
#define SCR_ADCPD		(*((volatile unsigned int *) (SCR_BASE + 0x28)))

/* MCI */
#define SCR_MCICLKEN		(*((volatile unsigned int *) (SCR_BASE + 0x2C)))

/* Flash */
#define SCR_FLASH_PD		(*((volatile unsigned int *) (SCR_BASE + 0x30)))
#define SCR_FLASH_INIT		(*((volatile unsigned int *) (SCR_BASE + 0x34)))

/* General Purpose DMA Controller */
#define SCR_DMA3EXTEN           (*((volatile unsigned int *) (SCR_BASE + 0x48)))
#define SCR_DMA5EXTEN           (*((volatile unsigned int *) (SCR_BASE + 0x4C)))

/* USB */
#define SCR_USBClkEn		(*((volatile unsigned int *) (SRC_BASE + 0x50)))

/* EMC */
#define SRC_EMCMisc		(*((volatile unsigned int *) (SRC_BASE + 0x5C)))

/* System control registers */
#define SCR_SYS_BOOTMAP		(*((volatile unsigned int *) (SCR_BASE + 0x70)))
#define SCR_SYS_BOOTADDR	(*((volatile unsigned int *) (SCR_BASE + 0x74)))
#define SCR_SYS_PARTID		(*((volatile unsigned int *) (SCR_BASE + 0x7C)))


/*
** EMC External Memory Controller
*/

#define EMC_BASE 0x80008000

#define EMCControl		(*((volatile unsigned int *) (EMC_BASE + 0x000)))
#define EMCStatus		(*((volatile unsigned int *) (EMC_BASE + 0x004)))
#define EMCConfig		(*((volatile unsigned int *) (EMC_BASE + 0x008)))

#define EMCDynamicControl	(*((volatile unsigned int *) (EMC_BASE + 0x020)))
#define EMCDynamicRefresh	(*((volatile unsigned int *) (EMC_BASE + 0x024)))
#define EMCDynamicReadConfig	(*((volatile unsigned int *) (EMC_BASE + 0x028)))
#define EMCDynamicRP		(*((volatile unsigned int *) (EMC_BASE + 0x030)))
#define EMCDynamicRAS		(*((volatile unsigned int *) (EMC_BASE + 0x034)))
#define EMCDynamicSREX		(*((volatile unsigned int *) (EMC_BASE + 0x038)))
#define EMCDynamicAPR		(*((volatile unsigned int *) (EMC_BASE + 0x03C)))
#define EMCDynamicDAL		(*((volatile unsigned int *) (EMC_BASE + 0x040)))
#define EMCDynamicWR		(*((volatile unsigned int *) (EMC_BASE + 0x044)))
#define EMCDynamicRC		(*((volatile unsigned int *) (EMC_BASE + 0x048)))
#define EMCDynamicRFC		(*((volatile unsigned int *) (EMC_BASE + 0x04C)))
#define EMCDynamicXSR		(*((volatile unsigned int *) (EMC_BASE + 0x050)))
#define EMCDynamicRRD		(*((volatile unsigned int *) (EMC_BASE + 0x054)))
#define EMCDynamicMRD		(*((volatile unsigned int *) (EMC_BASE + 0x058)))

#define EMCStaticExtendedWait	(*((volatile unsigned int *) (EMC_BASE + 0x080)))
#define EMCDynamicConfig	(*((volatile unsigned int *) (EMC_BASE + 0x100)))
#define EMCDynamicRasCas	(*((volatile unsigned int *) (EMC_BASE + 0x104)))

#define EMCStaticConfig0	(*((volatile unsigned int *) (EMC_BASE + 0x200)))
#define EMCStaticWaitWen0	(*((volatile unsigned int *) (EMC_BASE + 0x204)))
#define EMCStaticWaitOen0	(*((volatile unsigned int *) (EMC_BASE + 0x208)))
#define EMCStaticWaitRd0	(*((volatile unsigned int *) (EMC_BASE + 0x20C)))
#define EMCStaticWaitPage0	(*((volatile unsigned int *) (EMC_BASE + 0x210)))
#define EMCStaticWaitWr0	(*((volatile unsigned int *) (EMC_BASE + 0x214)))
#define EMCStaticWaitTurn0	(*((volatile unsigned int *) (EMC_BASE + 0x218)))

#define EMCStaticConfig1	(*((volatile unsigned int *) (EMC_BASE + 0x220)))
#define EMCStaticWaitWen1	(*((volatile unsigned int *) (EMC_BASE + 0x224)))
#define EMCStaticWaitOen1	(*((volatile unsigned int *) (EMC_BASE + 0x228)))
#define EMCStaticWaitRd1	(*((volatile unsigned int *) (EMC_BASE + 0x22C)))
#define EMCStaticWaitPage1	(*((volatile unsigned int *) (EMC_BASE + 0x230)))
#define EMCStaticWaitWr1	(*((volatile unsigned int *) (EMC_BASE + 0x234)))
#define EMCStaticWaitTurn1	(*((volatile unsigned int *) (EMC_BASE + 0x238)))

#define EMCStaticConfig2	(*((volatile unsigned int *) (EMC_BASE + 0x240)))
#define EMCStaticWaitWen2	(*((volatile unsigned int *) (EMC_BASE + 0x244)))
#define EMCStaticWaitOen2	(*((volatile unsigned int *) (EMC_BASE + 0x248)))
#define EMCStaticWaitRd2	(*((volatile unsigned int *) (EMC_BASE + 0x24C)))
#define EMCStaticWaitPage2	(*((volatile unsigned int *) (EMC_BASE + 0x250)))
#define EMCStaticWaitWr2	(*((volatile unsigned int *) (EMC_BASE + 0x254)))
#define EMCStaticWaitTurn2	(*((volatile unsigned int *) (EMC_BASE + 0x258)))

#define EMCMisc			(SRC_EMCMisc)


/*
** TIMER0 Timer 0
*/

#define TIMER0_BASE 0x80020000

#define TIMER0_LOAD		(*((volatile unsigned int *) (TIMER0_BASE + 0x00)))
#define TIMER0_VALUE		(*((volatile unsigned int *) (TIMER0_BASE + 0x04)))
#define TIMER0_CTRL		(*((volatile unsigned int *) (TIMER0_BASE + 0x08)))
#define TIMER0_CLR		(*((volatile unsigned int *) (TIMER0_BASE + 0x0C)))


/*
** TIMER1 Timer 1
*/

#define TIMER1_BASE 0x80020400

#define TIMER1_LOAD		(*((volatile unsigned int *) (TIMER1_BASE + 0x00)))
#define TIMER1_VALUE		(*((volatile unsigned int *) (TIMER1_BASE + 0x04)))
#define TIMER1_CTRL		(*((volatile unsigned int *) (TIMER1_BASE + 0x08)))
#define TIMER1_CLR		(*((volatile unsigned int *) (TIMER1_BASE + 0x0C)))


/*
** I2 Inter-Integrated Circuit interface (I2C)
*/

#define I2_BASE 0x80020800

#define I2RX            	(*((volatile unsigned int *) (I2_BASE + 0x00)))
#define I2TX            	(*((volatile unsigned int *) (I2_BASE + 0x00)))
#define I2STS           	(*((volatile unsigned int *) (I2_BASE + 0x04)))
#define I2CTL           	(*((volatile unsigned int *) (I2_BASE + 0x08)))
#define I2CLKHI         	(*((volatile unsigned int *) (I2_BASE + 0x0C)))
#define I2CLKLO         	(*((volatile unsigned int *) (I2_BASE + 0x10)))
#define I2ADR           	(*((volatile unsigned int *) (I2_BASE + 0x14)))
#define I2RFL           	(*((volatile unsigned int *) (I2_BASE + 0x18)))
#define I2TFL           	(*((volatile unsigned int *) (I2_BASE + 0x1C)))
#define I2RXB           	(*((volatile unsigned int *) (I2_BASE + 0x20)))
#define I2TXB           	(*((volatile unsigned int *) (I2_BASE + 0x24)))
#define I2TXS           	(*((volatile unsigned int *) (I2_BASE + 0x28)))
#define I2STFL          	(*((volatile unsigned int *) (I2_BASE + 0x2C)))


/*
** USB Controller
*/

#define UDMA_BASE 0x80040000
#define USB_BASE 0x80041000

/* Engine Register Map */
#define UDMA0Stat               (*((volatile unsigned int *) (UDMA_BASE + 0x000)))
#define UDMA0Ctrl               (*((volatile unsigned int *) (UDMA_BASE + 0x004)))
#define UDMA0Src                (*((volatile unsigned int *) (UDMA_BASE + 0x008)))
#define UDMA0Dest               (*((volatile unsigned int *) (UDMA_BASE + 0x00C)))
#define UDMA0Throtl             (*((volatile unsigned int *) (UDMA_BASE + 0x010)))
#define UDMA0Cnt                (*((volatile unsigned int *) (UDMA_BASE + 0x014)))
#define UDMA1Stat               (*((volatile unsigned int *) (UDMA_BASE + 0x040)))
#define UDMA1Ctrl               (*((volatile unsigned int *) (UDMA_BASE + 0x044)))
#define UDMA1Src                (*((volatile unsigned int *) (UDMA_BASE + 0x048)))
#define UDMA1Dest               (*((volatile unsigned int *) (UDMA_BASE + 0x04C)))
#define UDMA1Throtl             (*((volatile unsigned int *) (UDMA_BASE + 0x050)))
#define UDMA1Cnt                (*((volatile unsigned int *) (UDMA_BASE + 0x054)))
#define UDMACtrl                (*((volatile unsigned int *) (UDMA_BASE + 0x400)))
#define UDMASoftRes             (*((volatile unsigned int *) (UDMA_BASE + 0x404)))
#define UDMAStat                (*((volatile unsigned int *) (UDMA_BASE + 0x408)))
#define UDMAIntStat             (*((volatile unsigned int *) (UDMA_BASE + 0x410)))
#define UDMAIntEn               (*((volatile unsigned int *) (UDMA_BASE + 0x418)))
#define UDMAIntDis              (*((volatile unsigned int *) (UDMA_BASE + 0x420)))
#define UDMAIntSet              (*((volatile unsigned int *) (UDMA_BASE + 0x428)))
#define UDMAIntClr              (*((volatile unsigned int *) (UDMA_BASE + 0x430)))
#define UDMAFCP0                (*((volatile unsigned int *) (UDMA_BASE + 0x500)))
#define UDMAFCP1                (*((volatile unsigned int *) (UDMA_BASE + 0x504)))
#define UDMAFCP2                (*((volatile unsigned int *) (UDMA_BASE + 0x508)))
#define UDMAFCP3                (*((volatile unsigned int *) (UDMA_BASE + 0x50C)))

/* USB controller registers */
#define USBDevAdr               (*((volatile unsigned int *) (DMA_BASE + 0x000)))
#define USBEMaxSize             (*((volatile unsigned int *) (DMA_BASE + 0x004)))
#define USBEType                (*((volatile unsigned int *) (DMA_BASE + 0x008)))
#define USBMode         	(*((volatile unsigned int *) (DMA_BASE + 0x00C)))
#define USBIntCfg               (*((volatile unsigned int *) (DMA_BASE + 0x010)))
#define USBDCnt         	(*((volatile unsigned int *) (DMA_BASE + 0x01C)))
#define USBData         	(*((volatile unsigned int *) (DMA_BASE + 0x020)))
#define USBShort                (*((volatile unsigned int *) (DMA_BASE + 0x024)))
#define USBECtrl                (*((volatile unsigned int *) (DMA_BASE + 0x028)))
#define USBEIX          	(*((volatile unsigned int *) (DMA_BASE + 0x02C)))
#define USBFN           	(*((volatile unsigned int *) (DMA_BASE + 0x074)))
#define USBScratch              (*((volatile unsigned int *) (DMA_BASE + 0x078)))
#define USBLock         	(*((volatile unsigned int *) (DMA_BASE + 0x07C)))
#define USBTest         	(*((volatile unsigned int *) (DMA_BASE + 0x084)))
#define USBIntE         	(*((volatile unsigned int *) (DMA_BASE + 0x08C)))
#define USBEIntE                (*((volatile unsigned int *) (DMA_BASE + 0x090)))
#define USBIntStat              (*((volatile unsigned int *) (DMA_BASE + 0x094)))
#define USBEIntStat             (*((volatile unsigned int *) (DMA_BASE + 0x098)))
#define USBEIntClr              (*((volatile unsigned int *) (DMA_BASE + 0x0A0)))
#define USBEIntSet              (*((volatile unsigned int *) (DMA_BASE + 0x0A4)))
#define USBEIntP                (*((volatile unsigned int *) (DMA_BASE + 0x0A8)))
#define USBIntClr               (*((volatile unsigned int *) (DMA_BASE + 0x0AC)))
#define USBIntSet               (*((volatile unsigned int *) (DMA_BASE + 0x0B0)))
#define USBIntP         	(*((volatile unsigned int *) (DMA_BASE + 0x0B4)))

#define USBClkEn		(SCR_USBClkEn)


/*
** MCI Secure Digital and Multimedia Card Interface
*/

#define MCI_BASE 0x80100000

#define MCIPower      		(*((volatile unsigned int *) (MCI_BASE + 0x00)))
#define MCIClock      		(*((volatile unsigned int *) (MCI_BASE + 0x04)))
#define MCIArgument   		(*((volatile unsigned int *) (MCI_BASE + 0x08)))
#define MCICommand    		(*((volatile unsigned int *) (MCI_BASE + 0x0C)))
#define MCIRespCmd   		(*((volatile unsigned int *) (MCI_BASE + 0x10)))
#define MCIResponse0      	(*((volatile unsigned int *) (MCI_BASE + 0x14)))
#define MCIResponse1      	(*((volatile unsigned int *) (MCI_BASE + 0x18)))
#define MCIResponse2      	(*((volatile unsigned int *) (MCI_BASE + 0x1C)))
#define MCIresponse3  		(*((volatile unsigned int *) (MCI_BASE + 0x20)))
#define MCIDataTimer  		(*((volatile unsigned int *) (MCI_BASE + 0x24)))
#define MCIDataLength 		(*((volatile unsigned int *) (MCI_BASE + 0x28)))
#define MCIDataCtrl  		(*((volatile unsigned int *) (MCI_BASE + 0x2C)))
#define MCIDataCnt   		(*((volatile unsigned int *) (MCI_BASE + 0x30)))
#define MCIStatus     		(*((volatile unsigned int *) (MCI_BASE + 0x34)))
#define MCIClear      		(*((volatile unsigned int *) (MCI_BASE + 0x38)))
#define MCIMask0      		(*((volatile unsigned int *) (MCI_BASE + 0x3C)))
#define MCIMask1      		(*((volatile unsigned int *) (MCI_BASE + 0x40)))
#define MCIFifoCnt   		(*((volatile unsigned int *) (MCI_BASE + 0x48)))
#define MCIFIFO       		(*((volatile unsigned int *) (MCI_BASE + 0x80)))

#define MCICLKEN		(SCR_MCICLKEN)


/*
** UART Universal Asynchronous Receiver Transmitter
*/

#define UART_BASE 0x80101000

#define UART_RBR		(*((volatile unsigned int *) (UART_BASE + 0x000)))
#define UART_THR		(*((volatile unsigned int *) (UART_BASE + 0x000)))
#define UART_DLL		(*((volatile unsigned int *) (UART_BASE + 0x000)))
#define UART_IER		(*((volatile unsigned int *) (UART_BASE + 0x004)))
#define UART_DLM		(*((volatile unsigned int *) (UART_BASE + 0x004)))
#define UART_IIR		(*((volatile unsigned int *) (UART_BASE + 0x008)))
#define UART_FCR		(*((volatile unsigned int *) (UART_BASE + 0x008)))
#define UART_LCR		(*((volatile unsigned int *) (UART_BASE + 0x00C)))
#define UART_MCR		(*((volatile unsigned int *) (UART_BASE + 0x010)))
#define UART_LSR		(*((volatile unsigned int *) (UART_BASE + 0x014)))
#define UART_MSR		(*((volatile unsigned int *) (UART_BASE + 0x018)))
#define UART_SCR		(*((volatile unsigned int *) (UART_BASE + 0x01C)))
#define UART_ACR		(*((volatile unsigned int *) (UART_BASE + 0x020)))
#define UART_ICR		(*((volatile unsigned int *) (UART_BASE + 0x024)))
#define UART_FDR		(*((volatile unsigned int *) (UART_BASE + 0x028)))
#define UART_POP		(*((volatile unsigned int *) (UART_BASE + 0x030)))
#define UART_MODE		(*((volatile unsigned int *) (UART_BASE + 0x034)))
#define UART_INTCE		(*((volatile unsigned int *) (UART_BASE + 0xFD8)))
#define UART_INTSE		(*((volatile unsigned int *) (UART_BASE + 0xFDC)))
#define UART_INTS		(*((volatile unsigned int *) (UART_BASE + 0xFE0)))
#define UART_INTE		(*((volatile unsigned int *) (UART_BASE + 0xFE4)))
#define UART_INTCS		(*((volatile unsigned int *) (UART_BASE + 0xFE8)))
#define UART_INTSS		(*((volatile unsigned int *) (UART_BASE + 0xFEC)))


/*
** Flash Programming Interface
*/

#define FLASH_BASE 0x80102000

#define FLASH_CTRL		(*((volatile unsigned int *) (FLASH_BASE + 0x000)))
#define FLASH_STAT		(*((volatile unsigned int *) (FLASH_BASE + 0x004)))
#define FLASH_PROG_TIME		(*((volatile unsigned int *) (FLASH_BASE + 0x008)))
#define FLASH_WAIT		(*((volatile unsigned int *) (FLASH_BASE + 0x010)))
#define FLASH_CLK_TIME		(*((volatile unsigned int *) (FLASH_BASE + 0x01C)))

#define FLASH_INTEN_CLR		(*((volatile unsigned int *) (FLASH_BASE + 0xFD8)))
#define FLASH_INTEN_SET		(*((volatile unsigned int *) (FLASH_BASE + 0xFDC)))
#define FLASH_INT_STAT		(*((volatile unsigned int *) (FLASH_BASE + 0xFE0)))
#define FLASH_INTEN		(*((volatile unsigned int *) (FLASH_BASE + 0xFE4)))
#define FLASH_INT_CLR		(*((volatile unsigned int *) (FLASH_BASE + 0xFE8)))
#define FLASH_INT_SET		(*((volatile unsigned int *) (FLASH_BASE + 0xFEC)))

#define FLASH_PD		(SCR_FLASH_PD)
#define FLASH_INIT		(SCR_FLASH_INIT)


/*
** LCD Interface
*/

#define LCD_BASE 0x80103000

#define LCDSTAT       		(*((volatile unsigned int *) (LCD_BASE + 0x00)))
#define LCDCTRL         	(*((volatile unsigned int *) (LCD_BASE + 0x04)))
#define LCDISTAT                (*((volatile unsigned int *) (LCD_BASE + 0x08)))
#define LCDICLR         	(*((volatile unsigned int *) (LCD_BASE + 0x0C)))
#define LCDIMASK                (*((volatile unsigned int *) (LCD_BASE + 0x10)))
#define LCDREAD         	(*((volatile unsigned int *) (LCD_BASE + 0x14)))
#define LCDIBYTE                (*((volatile unsigned int *) (LCD_BASE + 0x20)))
#define LCDDBYTE                (*((volatile unsigned int *) (LCD_BASE + 0x30)))
#define LCDIWORD                (*((volatile unsigned int *) (LCD_BASE + 0x40)))
#define LCDDWORD                (*((volatile unsigned int *) (LCD_BASE + 0x80)))


/*
** GPDMA General Purpose DMA Controller
*/

#define DMA_BASE 0x80103800

/* Channel registers */
#define DMA0Source              (*((volatile unsigned int *) (DMA_BASE + 0x00)))
#define DMA0Dest                (*((volatile unsigned int *) (DMA_BASE + 0x04)))
#define DMA0Length              (*((volatile unsigned int *) (DMA_BASE + 0x08)))
#define DMA0Config              (*((volatile unsigned int *) (DMA_BASE + 0x0C)))
#define DMA0Enab                (*((volatile unsigned int *) (DMA_BASE + 0x10)))
#define DMA0Count               (*((volatile unsigned int *) (DMA_BASE + 0x1C)))

#define DMA1Source              (*((volatile unsigned int *) (DMA_BASE + 0x20)))
#define DMA1Dest                (*((volatile unsigned int *) (DMA_BASE + 0x24)))
#define DMA1Length              (*((volatile unsigned int *) (DMA_BASE + 0x28)))
#define DMA1Config              (*((volatile unsigned int *) (DMA_BASE + 0x2C)))
#define DMA1Enab                (*((volatile unsigned int *) (DMA_BASE + 0x30)))
#define DMA1Count               (*((volatile unsigned int *) (DMA_BASE + 0x3C)))

#define DMA2Source              (*((volatile unsigned int *) (DMA_BASE + 0x40)))
#define DMA2Dest                (*((volatile unsigned int *) (DMA_BASE + 0x44)))
#define DMA2Length              (*((volatile unsigned int *) (DMA_BASE + 0x48)))
#define DMA2Config              (*((volatile unsigned int *) (DMA_BASE + 0x4C)))
#define DMA2Enab                (*((volatile unsigned int *) (DMA_BASE + 0x50)))
#define DMA2Count               (*((volatile unsigned int *) (DMA_BASE + 0x5C)))

#define DMA3Source              (*((volatile unsigned int *) (DMA_BASE + 0x60)))
#define DMA3Dest                (*((volatile unsigned int *) (DMA_BASE + 0x64)))
#define DMA3Length              (*((volatile unsigned int *) (DMA_BASE + 0x68)))
#define DMA3Config              (*((volatile unsigned int *) (DMA_BASE + 0x6C)))
#define DMA3Enab                (*((volatile unsigned int *) (DMA_BASE + 0x70)))
#define DMA3Count               (*((volatile unsigned int *) (DMA_BASE + 0x7C)))

#define DMA4Source              (*((volatile unsigned int *) (DMA_BASE + 0x80)))
#define DMA4Dest                (*((volatile unsigned int *) (DMA_BASE + 0x84)))
#define DMA4Length              (*((volatile unsigned int *) (DMA_BASE + 0x88)))
#define DMA4Config              (*((volatile unsigned int *) (DMA_BASE + 0x8C)))
#define DMA4Enab                (*((volatile unsigned int *) (DMA_BASE + 0x90)))
#define DMA4Count               (*((volatile unsigned int *) (DMA_BASE + 0x9C)))

#define DMA5Source              (*((volatile unsigned int *) (DMA_BASE + 0xA0)))
#define DMA5Dest                (*((volatile unsigned int *) (DMA_BASE + 0xA4)))
#define DMA5Length              (*((volatile unsigned int *) (DMA_BASE + 0xA8)))
#define DMA5Config              (*((volatile unsigned int *) (DMA_BASE + 0xAC)))
#define DMA5Enab                (*((volatile unsigned int *) (DMA_BASE + 0xB0)))
#define DMA5Count               (*((volatile unsigned int *) (DMA_BASE + 0xBC)))

#define DMA6Source              (*((volatile unsigned int *) (DMA_BASE + 0xC0)))
#define DMA6Dest                (*((volatile unsigned int *) (DMA_BASE + 0xC4)))
#define DMA6Length              (*((volatile unsigned int *) (DMA_BASE + 0xC8)))
#define DMA6Config              (*((volatile unsigned int *) (DMA_BASE + 0xCC)))
#define DMA6Enab                (*((volatile unsigned int *) (DMA_BASE + 0xD0)))
#define DMA6Count               (*((volatile unsigned int *) (DMA_BASE + 0xDC)))

#define DMA7Source              (*((volatile unsigned int *) (DMA_BASE + 0xE0)))
#define DMA7Dest                (*((volatile unsigned int *) (DMA_BASE + 0xE4)))
#define DMA7Length              (*((volatile unsigned int *) (DMA_BASE + 0xE8)))
#define DMA7Config              (*((volatile unsigned int *) (DMA_BASE + 0xEC)))
#define DMA7Enab                (*((volatile unsigned int *) (DMA_BASE + 0xF0)))
#define DMA7Count               (*((volatile unsigned int *) (DMA_BASE + 0xFC)))

#define DMA0AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA0AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA0AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA0AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA1AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA1AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA1AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA1AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA2AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA2AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA2AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA2AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA3AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA3AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA3AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA3AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA4AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA4AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA4AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA4AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA5AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA5AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA5AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA5AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA6AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA6AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA6AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA6AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

#define DMA7AltSource           (*((volatile unsigned int *) (DMA_BASE + 0x0)))
#define DMA7AltDest             (*((volatile unsigned int *) (DMA_BASE + 0x4)))
#define DMA7AltLength           (*((volatile unsigned int *) (DMA_BASE + 0x8)))
#define DMA7AltConfig           (*((volatile unsigned int *) (DMA_BASE + 0xC)))

/* Global registers */
#define DMA_Enable              (*((volatile unsigned int *) (DMA_BASE + 0x00)))
#define DMA_Stat                (*((volatile unsigned int *) (DMA_BASE + 0x04)))
#define DMA_IRQMask             (*((volatile unsigned int *) (DMA_BASE + 0x08)))
#define DMA_SoftInt             (*((volatile unsigned int *) (DMA_BASE + 0x10)))

/* Registers in the System Control address range */
#define DMA3EXTEN               (SCR_DMA3EXTEN)
#define DMA5EXTEN               (SCR_DMA5EXTEN)


/*
** CMM Cache and Memory Mapping
*/

#define CMM_BASE 0x80104000

#define CMM_CACHE_RST_STAT	(*((volatile unsigned int *) (CMM_BASE + 0x00)))
#define CMM_CACHE_SETTINGS	(*((volatile unsigned int *) (CMM_BASE + 0x04)))
#define CMM_CACHE_PAGE_CTRL	(*((volatile unsigned int *) (CMM_BASE + 0x08)))
#define CMM_C_RD_MISSES		(*((volatile unsigned int *) (CMM_BASE + 0x0C)))
#define CMM_C_FLUSHES		(*((volatile unsigned int *) (CMM_BASE + 0x10)))
#define CMM_C_WR_MISSES		(*((volatile unsigned int *) (CMM_BASE + 0x14)))
#define CMM_PAGE_ADDRESS_0	(*((volatile unsigned int *) (CMM_BASE + 0x18)))
#define CMM_PAGE_ADDRESS_1	(*((volatile unsigned int *) (CMM_BASE + 0x1C)))
#define CMM_PAGE_ADDRESS_2	(*((volatile unsigned int *) (CMM_BASE + 0x20)))
#define CMM_PAGE_ADDRESS_3	(*((volatile unsigned int *) (CMM_BASE + 0x24)))
#define CMM_PAGE_ADDRESS_4	(*((volatile unsigned int *) (CMM_BASE + 0x28)))
#define CMM_PAGE_ADDRESS_5	(*((volatile unsigned int *) (CMM_BASE + 0x2C)))
#define CMM_PAGE_ADDRESS_6	(*((volatile unsigned int *) (CMM_BASE + 0x30)))
#define CMM_PAGE_ADDRESS_7	(*((volatile unsigned int *) (CMM_BASE + 0x34)))
#define CMM_PAGE_ADDRESS_8	(*((volatile unsigned int *) (CMM_BASE + 0x38)))
#define CMM_PAGE_ADDRESS_9	(*((volatile unsigned int *) (CMM_BASE + 0x3C)))
#define CMM_PAGE_ADDRESS_10	(*((volatile unsigned int *) (CMM_BASE + 0x40)))
#define CMM_PAGE_ADDRESS_11	(*((volatile unsigned int *) (CMM_BASE + 0x44)))
#define CMM_PAGE_ADDRESS_12	(*((volatile unsigned int *) (CMM_BASE + 0x48)))
#define CMM_PAGE_ADDRESS_13	(*((volatile unsigned int *) (CMM_BASE + 0x4C)))
#define CMM_PAGE_ADDRESS_14	(*((volatile unsigned int *) (CMM_BASE + 0x50)))
#define CMM_PAGE_ADDRESS_15	(*((volatile unsigned int *) (CMM_BASE + 0x54)))
#define CMM_CPU_CLK_GATE	(*((volatile unsigned int *) (CMM_BASE + 0x58)))


/*
** SAI1 Streaming Analog Input 1
*/

#define SAI1_BASE 0x80200000

#define SAI1_L16IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x00)))
#define SAI1_R16IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x04)))
#define SAI1_L24IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x08)))
#define SAI1_R24IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x0C)))
#define SAI1_SAISTAT1            (*((volatile unsigned int *) (SAI1_BASE + 0x10)))
#define SAI1_SAIMASK1            (*((volatile unsigned int *) (SAI1_BASE + 0x14)))
#define SAI1_L32IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x20)))
#define SAI1_R32IN1              (*((volatile unsigned int *) (SAI1_BASE + 0x40)))
#define SAI1_LR32IN1             (*((volatile unsigned int *) (SAI1_BASE + 0x60)))


/*
** SAI4 Streaming Analog Input 4
*/

#define SAI4_BASE 0x80200180

#define SAI4_L16IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x00)))
#define SAI4_R16IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x04)))
#define SAI4_L24IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x08)))
#define SAI4_R24IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x0C)))
#define SAI4_SAISTAT4            (*((volatile unsigned int *) (SAI4_BASE + 0x10)))
#define SAI4_SAIMASK4            (*((volatile unsigned int *) (SAI4_BASE + 0x14)))
#define SAI4_L32IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x20)))
#define SAI4_R32IN4              (*((volatile unsigned int *) (SAI4_BASE + 0x40)))
#define SAI4_LR32IN4             (*((volatile unsigned int *) (SAI4_BASE + 0x60)))


/*
** SAO1 Streaming Analog Output 1
*/

#define SAO1_BASE 0x80200200

#define SAO1_L16OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x00)))
#define SAO1_R16OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x04)))
#define SAO1_L24OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x08)))
#define SAO1_R24OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x0C)))
#define SAO1_SAOSTAT1           (*((volatile unsigned int *) (SAO1_BASE + 0x10)))
#define SAO1_SAOMASK1           (*((volatile unsigned int *) (SAO1_BASE + 0c14)))
#define SAO1_L32OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x20)))
#define SAO1_R32OUT1            (*((volatile unsigned int *) (SAO1_BASE + 0x40)))
#define SAO1_LR32OUT1           (*((volatile unsigned int *) (SAO1_BASE + 0x60)))


/*
** SAO2 Streaming Analog Output 2
*/

#define SAO2_BASE 0x80200280

#define SAO2_L16OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x00)))
#define SAO2_R16OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x04)))
#define SAO2_L24OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x08)))
#define SAO2_R24OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x0C)))
#define SAO2_SAOSTAT2           (*((volatile unsigned int *) (SAO2_BASE + 0x10)))
#define SAO2_SAOMASK2           (*((volatile unsigned int *) (SAO2_BASE + 0c14)))
#define SAO2_L32OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x20)))
#define SAO2_R32OUT2            (*((volatile unsigned int *) (SAO2_BASE + 0x40)))
#define SAO2_LR32OUT2           (*((volatile unsigned int *) (SAO2_BASE + 0x60)))


/*
** SIO Stream I/O (Inter-IC Sound and Streaming Analog Converters)
*/

#define SIO_BASE 0x80200380

#define SIO_CR      		(*((volatile unsigned int *) (SIO_BASE + 0x04)))

/* I2S input module (DAI) / I2S output module (DAO) */
#define SIO_FMT        		(*((volatile unsigned int *) (SIO_BASE + 0x00)))

/* Dual DAC */
#define SIO_DDACCTRL            (*((volatile unsigned int *) (SIO_BASE + 0x18)))
#define SIO_DDACSTAT            (*((volatile unsigned int *) (SIO_BASE + 0x1C)))
#define SIO_DDACSET             (*((volatile unsigned int *) (SIO_BASE + 0x20)))

/* Dual ADC */
#define SIO_DAINCTRL            (*((volatile unsigned int *) (SIO_BASE + 0x24)))
#define SIO_DADCCTRL            (*((volatile unsigned int *) (SIO_BASE + 0x28)))
#define SIO_DECCTRL             (*((volatile unsigned int *) (SIO_BASE + 0x2C)))
#define SIO_DECSTAT             (*((volatile unsigned int *) (SIO_BASE + 0x30)))


/*
** INT Interrupt Controller
*/

#define INT_BASE 0x80300000

#define INT_PRIOMASK0           (*((volatile unsigned int *) (INT_BASE + 0x000)))
#define INT_PRIOMASK1           (*((volatile unsigned int *) (INT_BASE + 0x004)))
#define INT_VECTOR0             (*((volatile unsigned int *) (INT_BASE + 0x100)))
#define INT_VECTOR1             (*((volatile unsigned int *) (INT_BASE + 0x104)))
#define INT_PENDING             (*((volatile unsigned int *) (INT_BASE + 0x200)))
#define INT_FEATURES            (*((volatile unsigned int *) (INT_BASE + 0x300)))
#define INT_REQ1                (*((volatile unsigned int *) (INT_BASE + 0x404)))
#define INT_REQ2                (*((volatile unsigned int *) (INT_BASE + 0x408)))
#define INT_REQ3                (*((volatile unsigned int *) (INT_BASE + 0x40C)))
#define INT_REQ4                (*((volatile unsigned int *) (INT_BASE + 0x410)))
#define INT_REQ5                (*((volatile unsigned int *) (INT_BASE + 0x414)))
#define INT_REQ6                (*((volatile unsigned int *) (INT_BASE + 0x418)))
#define INT_REQ7                (*((volatile unsigned int *) (INT_BASE + 0x41C)))
#define INT_REQ8                (*((volatile unsigned int *) (INT_BASE + 0x420)))
#define INT_REQ9                (*((volatile unsigned int *) (INT_BASE + 0x424)))
#define INT_REQ10               (*((volatile unsigned int *) (INT_BASE + 0x428)))
#define INT_REQ11               (*((volatile unsigned int *) (INT_BASE + 0x42C)))
#define INT_REQ12               (*((volatile unsigned int *) (INT_BASE + 0x430)))
#define INT_REQ13               (*((volatile unsigned int *) (INT_BASE + 0x434)))
#define INT_REQ14               (*((volatile unsigned int *) (INT_BASE + 0x438)))
#define INT_REQ15               (*((volatile unsigned int *) (INT_BASE + 0x43C)))
#define INT_REQ16               (*((volatile unsigned int *) (INT_BASE + 0x440)))
#define INT_REQ17               (*((volatile unsigned int *) (INT_BASE + 0x444)))
#define INT_REQ18               (*((volatile unsigned int *) (INT_BASE + 0x448)))
#define INT_REQ19               (*((volatile unsigned int *) (INT_BASE + 0x44C)))
#define INT_REQ20               (*((volatile unsigned int *) (INT_BASE + 0x450)))
#define INT_REQ21               (*((volatile unsigned int *) (INT_BASE + 0x454)))
#define INT_REQ22               (*((volatile unsigned int *) (INT_BASE + 0x458)))
#define INT_REQ23               (*((volatile unsigned int *) (INT_BASE + 0x45C)))
#define INT_REQ24               (*((volatile unsigned int *) (INT_BASE + 0x460)))
#define INT_REQ25               (*((volatile unsigned int *) (INT_BASE + 0x464)))
#define INT_REQ26               (*((volatile unsigned int *) (INT_BASE + 0x468)))
#define INT_REQ27               (*((volatile unsigned int *) (INT_BASE + 0x46C)))
#define INT_REQ28               (*((volatile unsigned int *) (INT_BASE + 0x470)))
#define INT_REQ29               (*((volatile unsigned int *) (INT_BASE + 0x474)))


#endif  // _LPC288x_H
