/**************************************************************************
**                                                                        *
**  FILE        :  lpc23xx.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**		   LPC2364, LPC2366, LPC2368, LPC2378, LPC2387 & LPC2388  *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC23xx_H
#define _LPC23xx_H


/*
** WD Watchdog
*/

#define WD_BASE 0xE0000000

#define WD_MOD            	(*((volatile unsigned char *) (WD_BASE + 0x00)))
#define WD_TC             	(*((volatile unsigned int  *) (WD_BASE + 0x04)))
#define WD_FEED             	(*((volatile unsigned char *) (WD_BASE + 0x08)))
#define WD_TV           	(*((volatile unsigned int  *) (WD_BASE + 0x0C)))
#define WD_CLKSEL           	(*((volatile unsigned int  *) (WD_BASE + 0x10)))


/*
** TIMER0 Timer 0
*/

#define TIMER0_BASE 0xE0004000

#define TIMER0_IR           	(*((volatile unsigned char *) (TIMER0_BASE + 0x00)))
#define TIMER0_TCR          	(*((volatile unsigned char *) (TIMER0_BASE + 0x04)))
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x08)))
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x0C)))
#define TIMER0_PC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x10)))
#define TIMER0_MCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x14)))
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x18)))
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x1C)))
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x20)))
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x24)))
#define TIMER0_CCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x28)))
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x2C)))
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x30)))
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x34)))
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x38)))
#define TIMER0_EMR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x3C)))
#define TIMER0_CTCR             (*((volatile unsigned char *) (TIMER0_BASE + 0x70)))


/*
** TIMER1 Timer 1
*/

#define TIMER1_BASE 0xE0008000

#define TIMER1_IR           	(*((volatile unsigned char *) (TIMER1_BASE + 0x00)))
#define TIMER1_TCR          	(*((volatile unsigned char *) (TIMER1_BASE + 0x04)))
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x08)))
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x0C)))
#define TIMER1_PC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x10)))
#define TIMER1_MCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x14)))
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x18)))
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x1C)))
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x20)))
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x24)))
#define TIMER1_CCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x28)))
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x2C)))
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x30)))
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x34)))
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x38)))
#define TIMER1_EMR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x3C)))
#define TIMER1_CTCR             (*((volatile unsigned char *) (TIMER1_BASE + 0x70)))


/*
** UART0 Universal Asynchronous Receiver Transmitter 0
*/

#define UART0_BASE 0xE000C000

#define UART0_RBR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_THR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_DLL		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_IER		(*((volatile unsigned int  *) (UART0_BASE + 0x04)))
#define UART0_DLM		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_IIR		(*((volatile unsigned int  *) (UART0_BASE + 0x08)))
#define UART0_FCR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_LCR		(*((volatile unsigned char *) (UART0_BASE + 0x0C)))
#define UART0_LSR		(*((volatile unsigned char *) (UART0_BASE + 0x14)))
#define UART0_SCR		(*((volatile unsigned char *) (UART0_BASE + 0x1C)))
#define UART0_ACR               (*((volatile unsigned int  *) (UART0_BASE + 0x20)))
#define UART0_FDR               (*((volatile unsigned int  *) (UART0_BASE + 0x28)))
#define UART0_TER               (*((volatile unsigned char *) (UART0_BASE + 0x30)))


/*
** UART1 Universal Asynchronous Receiver Transmitter 1
*/

#define UART1_BASE 0xE0010000

#define UART1_RBR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_THR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_DLL		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_IER		(*((volatile unsigned int  *) (UART1_BASE + 0x04)))
#define UART1_DLM		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_IIR		(*((volatile unsigned int  *) (UART1_BASE + 0x08)))
#define UART1_FCR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_LCR		(*((volatile unsigned char *) (UART1_BASE + 0x0C)))
#define UART1_MCR		(*((volatile unsigned char *) (UART1_BASE + 0x10)))
#define UART1_LSR		(*((volatile unsigned char *) (UART1_BASE + 0x14)))
#define UART1_MSR		(*((volatile unsigned char *) (UART1_BASE + 0x18)))
#define UART1_SCR		(*((volatile unsigned char *) (UART1_BASE + 0x1C)))
#define UART1_ACR               (*((volatile unsigned int  *) (UART1_BASE + 0x20)))
#define UART1_FDR               (*((volatile unsigned int  *) (UART1_BASE + 0x28)))
#define UART1_TER               (*((volatile unsigned char *) (UART1_BASE + 0x30)))


/*
** PWM0 Pulse Width Modulator 0
*/

#define PWM0_BASE 0xE0014000

#define PWM0_IR          	(*((volatile unsigned int  *) (PWM0_BASE + 0x00)))
#define PWM0_TCR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x04)))
#define PWM0_TC          	(*((volatile unsigned int  *) (PWM0_BASE + 0x08)))
#define PWM0_PR          	(*((volatile unsigned int  *) (PWM0_BASE + 0x0C)))
#define PWM0_PC          	(*((volatile unsigned int  *) (PWM0_BASE + 0x10)))
#define PWM0_MCR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x14)))
#define PWM0_MR0         	(*((volatile unsigned int  *) (PWM0_BASE + 0x18)))
#define PWM0_MR1         	(*((volatile unsigned int  *) (PWM0_BASE + 0x1C)))
#define PWM0_MR2         	(*((volatile unsigned int  *) (PWM0_BASE + 0x20)))
#define PWM0_MR3         	(*((volatile unsigned int  *) (PWM0_BASE + 0x24)))
#define PWM0_CCR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x28)))
#define PWM0_CR0         	(*((volatile unsigned int  *) (PWM0_BASE + 0x2C)))
#define PWM0_CR1         	(*((volatile unsigned int  *) (PWM0_BASE + 0x30)))
#define PWM0_CR2         	(*((volatile unsigned int  *) (PWM0_BASE + 0x34)))
#define PWM0_CR3         	(*((volatile unsigned int  *) (PWM0_BASE + 0x38)))
#define PWM0_EMR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x3C)))
#define PWM0_MR4         	(*((volatile unsigned int  *) (PWM0_BASE + 0x40)))
#define PWM0_MR5         	(*((volatile unsigned int  *) (PWM0_BASE + 0x44)))
#define PWM0_MR6         	(*((volatile unsigned int  *) (PWM0_BASE + 0x48)))
#define PWM0_PCR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x4C)))
#define PWM0_LER         	(*((volatile unsigned int  *) (PWM0_BASE + 0x50)))
#define PWM0_CTCR         	(*((volatile unsigned int  *) (PWM0_BASE + 0x70)))


/*
** PWM1 Pulse Width Modulator 1
*/

#define PWM1_BASE 0xE0018000

#define PWM1_IR          	(*((volatile unsigned int  *) (PWM1_BASE + 0x00)))
#define PWM1_TCR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x04)))
#define PWM1_TC          	(*((volatile unsigned int  *) (PWM1_BASE + 0x08)))
#define PWM1_PR          	(*((volatile unsigned int  *) (PWM1_BASE + 0x0C)))
#define PWM1_PC          	(*((volatile unsigned int  *) (PWM1_BASE + 0x10)))
#define PWM1_MCR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x14)))
#define PWM1_MR0         	(*((volatile unsigned int  *) (PWM1_BASE + 0x18)))
#define PWM1_MR1         	(*((volatile unsigned int  *) (PWM1_BASE + 0x1C)))
#define PWM1_MR2         	(*((volatile unsigned int  *) (PWM1_BASE + 0x20)))
#define PWM1_MR3         	(*((volatile unsigned int  *) (PWM1_BASE + 0x24)))
#define PWM1_CCR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x28)))
#define PWM1_CR0         	(*((volatile unsigned int  *) (PWM1_BASE + 0x2C)))
#define PWM1_CR1         	(*((volatile unsigned int  *) (PWM1_BASE + 0x30)))
#define PWM1_CR2         	(*((volatile unsigned int  *) (PWM1_BASE + 0x34)))
#define PWM1_CR3         	(*((volatile unsigned int  *) (PWM1_BASE + 0x38)))
#define PWM1_EMR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x3C)))
#define PWM1_MR4         	(*((volatile unsigned int  *) (PWM1_BASE + 0x40)))
#define PWM1_MR5         	(*((volatile unsigned int  *) (PWM1_BASE + 0x44)))
#define PWM1_MR6         	(*((volatile unsigned int  *) (PWM1_BASE + 0x48)))
#define PWM1_PCR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x4C)))
#define PWM1_LER         	(*((volatile unsigned int  *) (PWM1_BASE + 0x50)))
#define PWM1_CTCR         	(*((volatile unsigned int  *) (PWM1_BASE + 0x70)))


/*
** I2C0 Inter-Integrated Circuit interface 0
*/

#define I2C0_BASE 0xE001C000

#define I2C0_CONSET     	(*((volatile unsigned char *) (I2C0_BASE + 0x00)))
#define I2C0_STAT       	(*((volatile unsigned char *) (I2C0_BASE + 0x04)))
#define I2C0_DAT        	(*((volatile unsigned char *) (I2C0_BASE + 0x08)))
#define I2C0_ADR        	(*((volatile unsigned char *) (I2C0_BASE + 0x0C)))
#define I2C0_SCLH       	(*((volatile unsigned short*) (I2C0_BASE + 0x10)))
#define I2C0_SCLL       	(*((volatile unsigned short*) (I2C0_BASE + 0x14)))
#define I2C0_CONCLR     	(*((volatile unsigned char *) (I2C0_BASE + 0x18)))


/*
** SPI Serial Peripheral Interface
*/

#define SPI_BASE 0xE0020000

#define SPI_CR	         	(*((volatile unsigned short*) (SPI_BASE + 0x00)))
#define SPI_SR	         	(*((volatile unsigned char *) (SPI_BASE + 0x04)))
#define SPI_DR	         	(*((volatile unsigned short*) (SPI_BASE + 0x08)))
#define SPI_CCR	        	(*((volatile unsigned char *) (SPI_BASE + 0x0C)))
#define SPI_INT	        	(*((volatile unsigned char *) (SPI_BASE + 0x1C)))

                               
/*
** RTC Real Time Clock
*/

#define RTC_BASE 0xE0024000

#define RTC_ILR            	(*((volatile unsigned char *) (RTC_BASE + 0x00)))
#define RTC_CTC            	(*((volatile unsigned short*) (RTC_BASE + 0x04)))
#define RTC_CCR            	(*((volatile unsigned char *) (RTC_BASE + 0x08)))
#define RTC_CIIR           	(*((volatile unsigned char *) (RTC_BASE + 0x0C)))
#define RTC_AMR            	(*((volatile unsigned char *) (RTC_BASE + 0x10)))
#define RTC_CTIME0         	(*((volatile unsigned int  *) (RTC_BASE + 0x14)))
#define RTC_CTIME1         	(*((volatile unsigned int  *) (RTC_BASE + 0x18)))
#define RTC_CTIME2         	(*((volatile unsigned int  *) (RTC_BASE + 0x1C)))
#define RTC_SEC            	(*((volatile unsigned char *) (RTC_BASE + 0x20)))
#define RTC_MIN            	(*((volatile unsigned char *) (RTC_BASE + 0x24)))
#define RTC_HOUR           	(*((volatile unsigned char *) (RTC_BASE + 0x28)))
#define RTC_DOM            	(*((volatile unsigned char *) (RTC_BASE + 0x2C)))
#define RTC_DOW            	(*((volatile unsigned char *) (RTC_BASE + 0x30)))
#define RTC_DOY            	(*((volatile unsigned short*) (RTC_BASE + 0x34)))
#define RTC_MONTH          	(*((volatile unsigned char *) (RTC_BASE + 0x38)))
#define RTC_YEAR           	(*((volatile unsigned short*) (RTC_BASE + 0x3C)))
#define RTC_CISS           	(*((volatile unsigned char *) (RTC_BASE + 0x40)))
#define RTC_ALSEC          	(*((volatile unsigned char *) (RTC_BASE + 0x60)))
#define RTC_ALMIN          	(*((volatile unsigned char *) (RTC_BASE + 0x64)))
#define RTC_ALHOUR         	(*((volatile unsigned char *) (RTC_BASE + 0x68)))
#define RTC_ALDOM          	(*((volatile unsigned char *) (RTC_BASE + 0x6C)))
#define RTC_ALDOW          	(*((volatile unsigned char *) (RTC_BASE + 0x70)))
#define RTC_ALDOY          	(*((volatile unsigned short*) (RTC_BASE + 0x74)))
#define RTC_ALMON          	(*((volatile unsigned char *) (RTC_BASE + 0x78)))
#define RTC_ALYEAR         	(*((volatile unsigned short*) (RTC_BASE + 0x7C)))
#define RTC_PREINT         	(*((volatile unsigned short*) (RTC_BASE + 0x80)))
#define RTC_PREFRAC        	(*((volatile unsigned short*) (RTC_BASE + 0x84)))


/*
** GPIO General Purpose Input/Output
*/

#define GPIO_BASE 0xE0028000
#define FGPIO_BASE 0x3FFFC000

/* Input/Output registers PORT 0 */
#define GPIO0_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x00)))
#define GPIO0_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x04)))
#define GPIO0_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x08)))
#define GPIO0_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x0C)))

/* Input/Output registers PORT 1 */
#define GPIO1_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x10)))
#define GPIO1_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x14)))
#define GPIO1_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x18)))
#define GPIO1_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x1C)))

/* Interrupt registers general */
#define GPIO_IntStatus		(*((volatile unsigned int  *) (GPIO_BASE + 0x00)))
#define GPIO0_IntStatus		(GPIO_IntStatus)
#define GPIO2_IntStatus		(GPIO_IntStatus)

/* Interrupt registers PORT 0 */
#define GPIO0_IntStatR		(*((volatile unsigned int  *) (GPIO_BASE + 0x84)))
#define GPIO0_IntStatF		(*((volatile unsigned int  *) (GPIO_BASE + 0x88)))
#define GPIO0_IntClr		(*((volatile unsigned int  *) (GPIO_BASE + 0x8C)))
#define GPIO0_IntEnR		(*((volatile unsigned int  *) (GPIO_BASE + 0x90)))
#define GPIO0_IntEnF		(*((volatile unsigned int  *) (GPIO_BASE + 0x94)))

/* Interrupt registers PORT 2 */
#define GPIO2_IntStatR		(*((volatile unsigned int  *) (GPIO_BASE + 0xA4)))
#define GPIO2_IntStatF		(*((volatile unsigned int  *) (GPIO_BASE + 0xA8)))
#define GPIO2_IntClr		(*((volatile unsigned int  *) (GPIO_BASE + 0xAC)))
#define GPIO2_IntEnR		(*((volatile unsigned int  *) (GPIO_BASE + 0xB0)))
#define GPIO2_IntEnF		(*((volatile unsigned int  *) (GPIO_BASE + 0xB4)))

/* Fast Input/Output PORT 0 */
#define FGPIO0_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x00)))
#define FGPIO0_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x10)))
#define FGPIO0_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x14)))
#define FGPIO0_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x18)))
#define FGPIO0_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x1C)))

/* Fast Input/Output PORT 1 */
#define FGPIO1_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x20)))
#define FGPIO1_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x30)))
#define FGPIO1_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x34)))
#define FGPIO1_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x38)))
#define FGPIO1_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x3C)))

/* Fast Input/Output PORT 2 */
#define FGPIO2_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x40)))
#define FGPIO2_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x50)))
#define FGPIO2_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x54)))
#define FGPIO2_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x58)))
#define FGPIO2_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x5C)))

/* Fast Input/Output PORT 3 */
#define FGPIO3_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x60)))
#define FGPIO3_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x70)))
#define FGPIO3_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x74)))
#define FGPIO3_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x78)))
#define FGPIO3_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x7C)))

/* Fast Input/Output PORT 4 */
#define FGPIO4_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x80)))
#define FGPIO4_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x90)))
#define FGPIO4_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x94)))
#define FGPIO4_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x98)))
#define FGPIO4_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x9C)))


/*
** PCB Pin Connect Block
*/

#define PCB_BASE 0xE002C000

#define PCB_PINSEL0        	(*((volatile unsigned int  *) (PCB_BASE + 0x00)))
#define PCB_PINSEL1        	(*((volatile unsigned int  *) (PCB_BASE + 0x04)))
#define PCB_PINSEL2        	(*((volatile unsigned int  *) (PCB_BASE + 0x08)))
#define PCB_PINSEL3        	(*((volatile unsigned int  *) (PCB_BASE + 0x0C)))
#define PCB_PINSEL4        	(*((volatile unsigned int  *) (PCB_BASE + 0x10)))
#define PCB_PINSEL5        	(*((volatile unsigned int  *) (PCB_BASE + 0x14)))
#define PCB_PINSEL6        	(*((volatile unsigned int  *) (PCB_BASE + 0x18)))
#define PCB_PINSEL7        	(*((volatile unsigned int  *) (PCB_BASE + 0x1C)))
#define PCB_PINSEL8        	(*((volatile unsigned int  *) (PCB_BASE + 0x20)))
#define PCB_PINSEL9        	(*((volatile unsigned int  *) (PCB_BASE + 0x24)))
#define PCB_PINSEL10        	(*((volatile unsigned int  *) (PCB_BASE + 0x28)))
#define PCB_PINMODE0        	(*((volatile unsigned int  *) (PCB_BASE + 0x40)))
#define PCB_PINMODE1        	(*((volatile unsigned int  *) (PCB_BASE + 0x44)))
#define PCB_PINMODE2        	(*((volatile unsigned int  *) (PCB_BASE + 0x48)))
#define PCB_PINMODE3        	(*((volatile unsigned int  *) (PCB_BASE + 0x4C)))
#define PCB_PINMODE4        	(*((volatile unsigned int  *) (PCB_BASE + 0x50)))
#define PCB_PINMODE5        	(*((volatile unsigned int  *) (PCB_BASE + 0x54)))
#define PCB_PINMODE6        	(*((volatile unsigned int  *) (PCB_BASE + 0x58)))
#define PCB_PINMODE7        	(*((volatile unsigned int  *) (PCB_BASE + 0x5C)))
#define PCB_PINMODE8        	(*((volatile unsigned int  *) (PCB_BASE + 0x60)))
#define PCB_PINMODE9        	(*((volatile unsigned int  *) (PCB_BASE + 0x64)))


/*
** SSP1 Synchronous Serial Port controller 1
*/

#define SSP1_BASE 0xE0030000

#define SSP1_CR0         	(*((volatile unsigned short*) (SSP1_BASE + 0x00)))
#define SSP1_CR1         	(*((volatile unsigned char *) (SSP1_BASE + 0x04)))
#define SSP1_DR          	(*((volatile unsigned short*) (SSP1_BASE + 0x08)))
#define SSP1_SR          	(*((volatile unsigned char *) (SSP1_BASE + 0x0C)))
#define SSP1_CPSR        	(*((volatile unsigned char *) (SSP1_BASE + 0x10)))
#define SSP1_IMSC        	(*((volatile unsigned char *) (SSP1_BASE + 0x14)))
#define SSP1_RIS         	(*((volatile unsigned char *) (SSP1_BASE + 0x18)))
#define SSP1_MIS         	(*((volatile unsigned char *) (SSP1_BASE + 0x1C)))
#define SSP1_ICR         	(*((volatile unsigned char *) (SSP1_BASE + 0x20)))
#define SSP1_DMACR         	(*((volatile unsigned short*) (SSP1_BASE + 0x24)))


/*
** ADC Analog/Digital Converter
*/

#define ADC_BASE 0xE0034000

#define ADC_CR           	(*((volatile unsigned int  *) (ADC_BASE + 0x00)))
#define ADC_GDR          	(*((volatile unsigned int  *) (ADC_BASE + 0x04)))
#define ADC_INTEN        	(*((volatile unsigned int  *) (ADC_BASE + 0x0C)))
#define ADC_DR0          	(*((volatile unsigned int  *) (ADC_BASE + 0x10)))
#define ADC_DR1          	(*((volatile unsigned int  *) (ADC_BASE + 0x14)))
#define ADC_DR2          	(*((volatile unsigned int  *) (ADC_BASE + 0x18)))
#define ADC_DR3          	(*((volatile unsigned int  *) (ADC_BASE + 0x1C)))
#define ADC_DR4          	(*((volatile unsigned int  *) (ADC_BASE + 0x20)))
#define ADC_DR5          	(*((volatile unsigned int  *) (ADC_BASE + 0x24)))
#define ADC_DR6          	(*((volatile unsigned int  *) (ADC_BASE + 0x28)))
#define ADC_DR7          	(*((volatile unsigned int  *) (ADC_BASE + 0x2C)))
#define ADC_STAT         	(*((volatile unsigned int  *) (ADC_BASE + 0x30)))


/*
** CANAFM CAN Acceptance Filter Memory (ID-look-up table)
*/

#define CANAFM_BASE 0xE0038000
 

/*
** CANAFR CAN Acceptance Filter registers
*/

#define CANAFR_BASE 0xE003C000

#define CANAFR_AFMR       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x00);
#define CANAFR_SFF_SA     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x04);
#define CANAFR_SFF_GRP_SA 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x08);
#define CANAFR_EFF_SA     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x0C);
#define CANAFR_EFF_GRP_SA 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x10);
#define CANAFR_ENDOFTABLE 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x14);
#define CANAFR_LUTERRAD   	(*((volatile unsigned int  *) (CANAFR_BASE + 0x18);
#define CANAFR_LUTERR     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x1C);


/*
** CANCS CAN Central Status registers
*/

#define CANCS_BASE 0xE0040000

#define CANCS_TXSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x0)))
#define CANCS_RXSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x4)))
#define CANCS_MSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x8)))


/*
** CAN1 CAN 1
*/

#define CAN1_BASE 0xE0044000

#define CAN1_MOD          	(*((volatile unsigned int  *) (CAN1_BASE + 0x00)))
#define CAN1_CMR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x04)))
#define CAN1_GSR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x08)))
#define CAN1_ICR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x0C)))
#define CAN1_IER          	(*((volatile unsigned int  *) (CAN1_BASE + 0x10)))
#define CAN1_BTR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x14)))
#define CAN1_EWL          	(*((volatile unsigned int  *) (CAN1_BASE + 0x18)))
#define CAN1_SR           	(*((volatile unsigned int  *) (CAN1_BASE + 0x1C)))
#define CAN1_RFS          	(*((volatile unsigned int  *) (CAN1_BASE + 0x20)))
#define CAN1_RID          	(*((volatile unsigned int  *) (CAN1_BASE + 0x24)))
#define CAN1_RDA          	(*((volatile unsigned int  *) (CAN1_BASE + 0x28)))
#define CAN1_RDB          	(*((volatile unsigned int  *) (CAN1_BASE + 0x2C)))
#define CAN1_TFI1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x30)))
#define CAN1_TID1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x34)))
#define CAN1_TDA1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x38)))
#define CAN1_TDB1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x3C)))
#define CAN1_TFI2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x40)))
#define CAN1_TID2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x44)))
#define CAN1_TDA2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x48)))
#define CAN1_TDB2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x4C)))
#define CAN1_TFI3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x50)))
#define CAN1_TID3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x54)))
#define CAN1_TDA3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x58)))
#define CAN1_TDB3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x5C)))


/*
** CAN2 CAN 2
*/

#define CAN2_BASE 0xE0048000

#define CAN2_MOD          	(*((volatile unsigned int  *) (CAN2_BASE + 0x00)))
#define CAN2_CMR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x04)))
#define CAN2_GSR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x08)))
#define CAN2_ICR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x0C)))
#define CAN2_IER          	(*((volatile unsigned int  *) (CAN2_BASE + 0x10)))
#define CAN2_BTR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x14)))
#define CAN2_EWL          	(*((volatile unsigned int  *) (CAN2_BASE + 0x18)))
#define CAN2_SR           	(*((volatile unsigned int  *) (CAN2_BASE + 0x1C)))
#define CAN2_RFS          	(*((volatile unsigned int  *) (CAN2_BASE + 0x20)))
#define CAN2_RID          	(*((volatile unsigned int  *) (CAN2_BASE + 0x24)))
#define CAN2_RDA          	(*((volatile unsigned int  *) (CAN2_BASE + 0x28)))
#define CAN2_RDB          	(*((volatile unsigned int  *) (CAN2_BASE + 0x2C)))
#define CAN2_TFI1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x30)))
#define CAN2_TID1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x34)))
#define CAN2_TDA1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x38)))
#define CAN2_TDB1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x3C)))
#define CAN2_TFI2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x40)))
#define CAN2_TID2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x44)))
#define CAN2_TDA2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x48)))
#define CAN2_TDB2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x4C)))
#define CAN2_TFI3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x50)))
#define CAN2_TID3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x54)))
#define CAN2_TDA3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x58)))
#define CAN2_TDB3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x5C)))


/*
** I2C1 Inter-Integrated Circuit interface 1
*/

#define I2C1_BASE 0xE005C000

#define I2C1_CONSET     	(*((volatile unsigned char *) (I2C1_BASE + 0x00)))
#define I2C1_STAT       	(*((volatile unsigned char *) (I2C1_BASE + 0x04)))
#define I2C1_DAT        	(*((volatile unsigned char *) (I2C1_BASE + 0x08)))
#define I2C1_ADR        	(*((volatile unsigned char *) (I2C1_BASE + 0x0C)))
#define I2C1_SCLH       	(*((volatile unsigned short*) (I2C1_BASE + 0x10)))
#define I2C1_SCLL       	(*((volatile unsigned short*) (I2C1_BASE + 0x14)))
#define I2C1_CONCLR     	(*((volatile unsigned char *) (I2C1_BASE + 0x18)))

                                
/*
** SSP0 Synchronous Serial Port controller 0
*/

#define SSP0_BASE 0xE0068000

#define SSP0_CR0         	(*((volatile unsigned short*) (SSP0_BASE + 0x00)))
#define SSP0_CR1         	(*((volatile unsigned char *) (SSP0_BASE + 0x04)))
#define SSP0_DR          	(*((volatile unsigned short*) (SSP0_BASE + 0x08)))
#define SSP0_SR          	(*((volatile unsigned char *) (SSP0_BASE + 0x0C)))
#define SSP0_CPSR        	(*((volatile unsigned char *) (SSP0_BASE + 0x10)))
#define SSP0_IMSC        	(*((volatile unsigned char *) (SSP0_BASE + 0x14)))
#define SSP0_RIS         	(*((volatile unsigned char *) (SSP0_BASE + 0x18)))
#define SSP0_MIS         	(*((volatile unsigned char *) (SSP0_BASE + 0x1C)))
#define SSP0_ICR         	(*((volatile unsigned char *) (SSP0_BASE + 0x20)))
#define SSP0_DMACR         	(*((volatile unsigned short*) (SSP0_BASE + 0x24)))


/*
** Digital/Analog Converter
*/

#define DAC_BASE 0xE006C000

#define DAC_R                   (*((volatile unsigned int  *)(DAC_BASE)))


/*
** TIMER2 Timer 2
*/

#define TIMER2_BASE 0xE0070000

#define TIMER2_IR           	(*((volatile unsigned char *) (TIMER2_BASE + 0x00)))
#define TIMER2_TCR          	(*((volatile unsigned char *) (TIMER2_BASE + 0x04)))
#define TIMER2_TC           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x08)))
#define TIMER2_PR           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x0C)))
#define TIMER2_PC           	(*((volatile unsigned int  *) (TIMER2_BASE + 0x10)))
#define TIMER2_MCR          	(*((volatile unsigned short*) (TIMER2_BASE + 0x14)))
#define TIMER2_MR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x18)))
#define TIMER2_MR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x1C)))
#define TIMER2_MR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x20)))
#define TIMER2_MR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x24)))
#define TIMER2_CCR          	(*((volatile unsigned short*) (TIMER2_BASE + 0x28)))
#define TIMER2_CR0          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x2C)))
#define TIMER2_CR1          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x30)))
#define TIMER2_CR2          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x34)))
#define TIMER2_CR3          	(*((volatile unsigned int  *) (TIMER2_BASE + 0x38)))
#define TIMER2_EMR          	(*((volatile unsigned short*) (TIMER2_BASE + 0x3C)))
#define TIMER2_CTCR             (*((volatile unsigned char *) (TIMER2_BASE + 0x70)))

/*
** TIMER3 Timer 3
*/

#define TIMER3_BASE 0xE0074000

#define TIMER3_IR           	(*((volatile unsigned char *) (TIMER3_BASE + 0x00)))
#define TIMER3_TCR          	(*((volatile unsigned char *) (TIMER3_BASE + 0x04)))
#define TIMER3_TC           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x08)))
#define TIMER3_PR           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x0C)))
#define TIMER3_PC           	(*((volatile unsigned int  *) (TIMER3_BASE + 0x10)))
#define TIMER3_MCR          	(*((volatile unsigned short*) (TIMER3_BASE + 0x14)))
#define TIMER3_MR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x18)))
#define TIMER3_MR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x1C)))
#define TIMER3_MR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x20)))
#define TIMER3_MR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x24)))
#define TIMER3_CCR          	(*((volatile unsigned short*) (TIMER3_BASE + 0x28)))
#define TIMER3_CR0          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x2C)))
#define TIMER3_CR1          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x30)))
#define TIMER3_CR2          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x34)))
#define TIMER3_CR3          	(*((volatile unsigned int  *) (TIMER3_BASE + 0x38)))
#define TIMER3_EMR          	(*((volatile unsigned short*) (TIMER3_BASE + 0x3C)))
#define TIMER3_CTCR             (*((volatile unsigned char *) (TIMER3_BASE + 0x70)))


/*
** UART2 Universal Asynchronous Receiver Transmitter 2
*/

#define UART2_BASE 0xE0078000

#define UART2_RBR		(*((volatile unsigned char *) (UART2_BASE + 0x00)))
#define UART2_THR		(*((volatile unsigned char *) (UART2_BASE + 0x00)))
#define UART2_DLL		(*((volatile unsigned char *) (UART2_BASE + 0x00)))
#define UART2_IER		(*((volatile unsigned int  *) (UART2_BASE + 0x04)))
#define UART2_DLM		(*((volatile unsigned char *) (UART2_BASE + 0x04)))
#define UART2_IIR		(*((volatile unsigned int  *) (UART2_BASE + 0x08)))
#define UART2_FCR		(*((volatile unsigned char *) (UART2_BASE + 0x08)))
#define UART2_LCR		(*((volatile unsigned char *) (UART2_BASE + 0x0C)))
#define UART2_LSR		(*((volatile unsigned char *) (UART2_BASE + 0x14)))
#define UART2_SCR		(*((volatile unsigned char *) (UART2_BASE + 0x1C)))
#define UART2_ACR               (*((volatile unsigned int  *) (UART2_BASE + 0x20)))
#define UART2_FDR               (*((volatile unsigned int  *) (UART2_BASE + 0x28)))
#define UART2_TER               (*((volatile unsigned char *) (UART2_BASE + 0x30)))


/*
** UART3 Universal Asynchronous Receiver Transmitter 3
*/

#define UART3_BASE 0xE007C000

#define UART3_RBR		(*((volatile unsigned char *) (UART3_BASE + 0x00)))
#define UART3_THR		(*((volatile unsigned char *) (UART3_BASE + 0x00)))
#define UART3_DLL		(*((volatile unsigned char *) (UART3_BASE + 0x00)))
#define UART3_IER		(*((volatile unsigned int  *) (UART3_BASE + 0x04)))
#define UART3_DLM		(*((volatile unsigned char *) (UART3_BASE + 0x04)))
#define UART3_IIR		(*((volatile unsigned int  *) (UART3_BASE + 0x08)))
#define UART3_FCR		(*((volatile unsigned char *) (UART3_BASE + 0x08)))
#define UART3_LCR		(*((volatile unsigned char *) (UART3_BASE + 0x0C)))
#define UART3_LSR		(*((volatile unsigned char *) (UART3_BASE + 0x14)))
#define UART3_SCR		(*((volatile unsigned char *) (UART3_BASE + 0x1C)))
#define UART3_ACR               (*((volatile unsigned int  *) (UART3_BASE + 0x20)))
#define UART3_ICR               (*((volatile unsigned int  *) (UART3_BASE + 0x24)))
#define UART3_FDR               (*((volatile unsigned int  *) (UART3_BASE + 0x28)))
#define UART3_TER               (*((volatile unsigned char *) (UART3_BASE + 0x30)))


/*
** I2C2 Inter-Integrated Circuit interface 1
*/

#define I2C2_BASE 0xE0080000

#define I2C2_CONSET     	(*((volatile unsigned char *) (I2C2_BASE + 0x00)))
#define I2C2_STAT       	(*((volatile unsigned char *) (I2C2_BASE + 0x04)))
#define I2C2_DAT        	(*((volatile unsigned char *) (I2C2_BASE + 0x08)))
#define I2C2_ADR        	(*((volatile unsigned char *) (I2C2_BASE + 0x0C)))
#define I2C2_SCLH       	(*((volatile unsigned short*) (I2C2_BASE + 0x10)))
#define I2C2_SCLL       	(*((volatile unsigned short*) (I2C2_BASE + 0x14)))
#define I2C2_CONCLR     	(*((volatile unsigned char *) (I2C2_BASE + 0x18)))


/*
** BATT_RAM Battery RAM
*/

#define BATT_RAM_BASE 0xE0084000


/*
** I2S 
*/

#define I2S_BASE 0xE0088000

#define I2S_DAO        		(*((volatile unsigned short*) (I2S_BASE + 0x00)))
#define I2S_DAI        		(*((volatile unsigned short*) (I2S_BASE + 0x04)))
#define I2S_TXFIFO     		(*((volatile unsigned int  *) (I2S_BASE + 0x08)))
#define I2S_RXFIFO     		(*((volatile unsigned int  *) (I2S_BASE + 0x0C)))
#define I2S_STATE      		(*((volatile unsigned int  *) (I2S_BASE + 0x10)))
#define I2S_DMA1       		(*((volatile unsigned int  *) (I2S_BASE + 0x14)))
#define I2S_DMA2       		(*((volatile unsigned int  *) (I2S_BASE + 0x18)))
#define I2S_IRQ        		(*((volatile unsigned int  *) (I2S_BASE + 0x1C)))
#define I2S_TXRATE     		(*((volatile unsigned short*) (I2S_BASE + 0x20)))
#define I2S_RXRATE     		(*((volatile unsigned short*) (I2S_BASE + 0x24)))


/*
** MCI Secure Digital and Multimedia Card Interface
*/

#define MCI_BASE 0xE008C000

#define MCIPower      		(*((volatile unsigned char *) (MCI_BASE + 0x00)))
#define MCIClock      		(*((volatile unsigned short*) (MCI_BASE + 0x04)))
#define MCIArgument   		(*((volatile unsigned int  *) (MCI_BASE + 0x08)))
#define MCICommand    		(*((volatile unsigned short*) (MCI_BASE + 0x0C)))
#define MCIRespCmd   		(*((volatile unsigned char *) (MCI_BASE + 0x10)))
#define MCIResponse0      	(*((volatile unsigned int  *) (MCI_BASE + 0x14)))
#define MCIResponse1      	(*((volatile unsigned int  *) (MCI_BASE + 0x18)))
#define MCIResponse2      	(*((volatile unsigned int  *) (MCI_BASE + 0x1C)))
#define MCIresponse3  		(*((volatile unsigned int  *) (MCI_BASE + 0x20)))
#define MCIDataTimer  		(*((volatile unsigned int  *) (MCI_BASE + 0x24)))
#define MCIDataLength 		(*((volatile unsigned short*) (MCI_BASE + 0x28)))
#define MCIDataCtrl  		(*((volatile unsigned char *) (MCI_BASE + 0x2C)))
#define MCIDataCnt   		(*((volatile unsigned short*) (MCI_BASE + 0x30)))
#define MCIStatus     		(*((volatile unsigned int  *) (MCI_BASE + 0x34)))
#define MCIClear      		(*((volatile unsigned short*) (MCI_BASE + 0x38)))
#define MCIMask0      		(*((volatile unsigned int  *) (MCI_BASE + 0x3C)))
#define MCIMask1      		(*((volatile unsigned int  *) (MCI_BASE + 0x40)))
#define MCIFifoCnt   		(*((volatile unsigned short*) (MCI_BASE + 0x48)))
#define MCIFIFO       		(*((volatile unsigned int  *) (MCI_BASE + 0x80)))


/*
** SCB System Control Block
*/

#define SCB_BASE 0xE01FC000

/* MAM Memory Accelerator Module */
#define SCB_MAMCR		(*((volatile unsigned char *) (SCB_BASE + 0x000)))
#define SCB_MAMTIM		(*((volatile unsigned char *) (SCB_BASE + 0x004)))

/* Memory Mapping control */
#define SCB_MEMMAP		(*((volatile unsigned char *) (SCB_BASE + 0x040)))

/* PLL Phase Locked Loop */
#define SCB_PLLCON		(*((volatile unsigned char *) (SCB_BASE + 0x080)))
#define SCB_PLLCFG		(*((volatile unsigned int  *) (SCB_BASE + 0x084)))
#define SCB_PLLSTAT		(*((volatile unsigned int  *) (SCB_BASE + 0x088)))
#define SCB_PLLFEED		(*((volatile unsigned char *) (SCB_BASE + 0x08C)))

/* PC Power Control */
#define SCB_PCON		(*((volatile unsigned char *) (SCB_BASE + 0x0C0)))
#define SCB_PCONP		(*((volatile unsigned int  *) (SCB_BASE + 0x0C4)))

/* Clock Divider */
#define SCB_CCLKCFG        	(*((volatile unsigned char *) (SCB_BASE + 0x104)))
#define SCB_USBCLKCFG      	(*((volatile unsigned char *) (SCB_BASE + 0x108)))
#define SCB_CLKSRCSEL      	(*((volatile unsigned char *) (SCB_BASE + 0x10C)))
#define SCB_IRCTRIML      	(*((volatile unsigned short*) (SCB_BASE + 0x1A4)))
#define SCB_PCLKSEL0       	(*((volatile unsigned int  *) (SCB_BASE + 0x1A8)))
#define SCB_PCLKSEL1       	(*((volatile unsigned int  *) (SCB_BASE + 0x1AC)))

/* External Interrupts */
#define SCB_EXTINT         	(*((volatile unsigned char *) (SCB_BASE + 0x140)))
#define SCB_INTWAKE		(*((volatile unsigned short*) (SCB_BASE + 0x144)))
#define SCB_EXTMODE		(*((volatile unsigned char *) (SCB_BASE + 0x148)))
#define SCB_EXTPOLAR		(*((volatile unsigned char *) (SCB_BASE + 0x14C)))

/* Reset Source Identification Register */
#define SCB_RSIR       		(*((volatile unsigned char *) (SCB_BASE + 0x180)))

/* Code Security Protection Register */
#define SCB_CSPR       		(*((volatile unsigned int  *) (SCB_BASE + 0x184)))

/* AHB configuration */
#define SCB_AHBCFG1        	(*((volatile unsigned int  *)(SCB_BASE + 0x188)))
#define SCB_AHBCFG2        	(*((volatile unsigned int  *)(SCB_BASE + 0x18C)))

/* System Control and Status flags register */
#define SCB_SCS       		(*((volatile unsigned int  *) (SCB_BASE + 0x1A0)))
                                

/*
** MAC Ethernet controller
*/

#define MAC_BASE 0xFFE00000

/* MAC registers */
#define MAC_MAC1            	(*((volatile unsigned int  *) (MAC_BASE + 0x000)))
#define MAC_MAC2            	(*((volatile unsigned int  *) (MAC_BASE + 0x004)))
#define MAC_IPGT            	(*((volatile unsigned int  *) (MAC_BASE + 0x008)))
#define MAC_IPGR            	(*((volatile unsigned int  *) (MAC_BASE + 0x00C)))
#define MAC_CLRT            	(*((volatile unsigned int  *) (MAC_BASE + 0x010)))
#define MAC_MAXF            	(*((volatile unsigned int  *) (MAC_BASE + 0x014)))
#define MAC_SUPP            	(*((volatile unsigned int  *) (MAC_BASE + 0x018)))
#define MAC_TEST            	(*((volatile unsigned int  *) (MAC_BASE + 0x01C)))
#define MAC_MCFG            	(*((volatile unsigned int  *) (MAC_BASE + 0x020)))
#define MAC_MCMD            	(*((volatile unsigned int  *) (MAC_BASE + 0x024)))
#define MAC_MADR            	(*((volatile unsigned int  *) (MAC_BASE + 0x028)))
#define MAC_MWTD            	(*((volatile unsigned int  *) (MAC_BASE + 0x02C)))
#define MAC_MRDD            	(*((volatile unsigned int  *) (MAC_BASE + 0x030)))
#define MAC_MIND            	(*((volatile unsigned int  *) (MAC_BASE + 0x034)))
#define MAC_SA0             	(*((volatile unsigned int  *) (MAC_BASE + 0x040)))
#define MAC_SA1             	(*((volatile unsigned int  *) (MAC_BASE + 0x044)))
#define MAC_SA2             	(*((volatile unsigned int  *) (MAC_BASE + 0x048)))

/* Control registers */
#define MAC_Command		(*((volatile unsigned int  *) (MAC_BASE + 0x100)))
#define MAC_Status		(*((volatile unsigned int  *) (MAC_BASE + 0x104)))
#define MAC_RxDescriptor	(*((volatile unsigned int  *) (MAC_BASE + 0x108)))
#define MAC_RxStatus		(*((volatile unsigned int  *) (MAC_BASE + 0x10C)))
#define MAC_RxDescriptorNumber 	(*((volatile unsigned int  *) (MAC_BASE + 0x110)))
#define MAC_RxProduceIndex	(*((volatile unsigned int  *) (MAC_BASE + 0x114)))
#define MAC_RxConsumeIndex	(*((volatile unsigned int  *) (MAC_BASE + 0x118)))
#define MAC_TxDescriptor	(*((volatile unsigned int  *) (MAC_BASE + 0x11C)))
#define MAC_TxStatus		(*((volatile unsigned int  *) (MAC_BASE + 0x120)))
#define MAC_TxDescriptorNumber	(*((volatile unsigned int  *) (MAC_BASE + 0x124)))
#define MAC_TxProduceIndex	(*((volatile unsigned int  *) (MAC_BASE + 0x128)))
#define MAC_TxConsumeIndex  	(*((volatile unsigned int  *) (MAC_BASE + 0x12C)))
#define MAC_TSV0		(*((volatile unsigned int  *) (MAC_BASE + 0x158)))
#define MAC_TSV1		(*((volatile unsigned int  *) (MAC_BASE + 0x15C)))
#define MAC_RSV			(*((volatile unsigned int  *) (MAC_BASE + 0x160)))
#define MAC_FlowControlCounter	(*((volatile unsigned int  *) (MAC_BASE + 0x170)))
#define MAC_FlowControlStatus	(*((volatile unsigned int  *) (MAC_BASE + 0x174)))

/* Rx filter registers */
#define MAC_RxFilterCtrl	(*((volatile unsigned int  *) (MAC_BASE + 0x200)))
#define MAC_RxFilterWoLStatus	(*((volatile unsigned int  *) (MAC_BASE + 0x204)))
#define MAC_RxFilterWOLClear	(*((volatile unsigned int  *) (MAC_BASE + 0x208)))
#define MAC_HashFilterL		(*((volatile unsigned int  *) (MAC_BASE + 0x210)))
#define MAC_HashFilterH		(*((volatile unsigned int  *) (MAC_BASE + 0x214)))

/* Module control registers */
#define MAC_IntStatus		(*((volatile unsigned int  *) (MAC_BASE + 0xFE0)))
#define MAC_IntEnable		(*((volatile unsigned int  *) (MAC_BASE + 0xFE4)))
#define MAC_IntClear		(*((volatile unsigned int  *) (MAC_BASE + 0xFE8)))
#define MAC_IntSet		(*((volatile unsigned int  *) (MAC_BASE + 0xFEC)))
#define MAC_PowerDown       	(*((volatile unsigned int  *) (MAC_BASE + 0xFF4)))


/*
** DMAC General Purpose DMA Controller
*/

#define DMAC_BASE 0xFFE04000

/* General Registers */
#define DMACIntStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x000)))
#define DMACIntTCStatus		(*((volatile unsigned int *) (DMAC_BASE + 0x004)))
#define DMACIntTCClear		(*((volatile unsigned int *) (DMAC_BASE + 0x008)))
#define DMACIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x00C)))
#define DMACIntIntErrClr	(*((volatile unsigned int *) (DMAC_BASE + 0x010)))
#define DMACRawIntTCStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x014)))
#define DMACRawIntErrorStatus	(*((volatile unsigned int *) (DMAC_BASE + 0x018)))
#define DMACEnbldChns		(*((volatile unsigned int *) (DMAC_BASE + 0x01C)))
#define DMACSoftBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x020)))
#define DMACSoftSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x024)))
#define DMACSoftLBReq		(*((volatile unsigned int *) (DMAC_BASE + 0x028)))
#define DMACSoftLSReq		(*((volatile unsigned int *) (DMAC_BASE + 0x02C)))
#define DMACConfiguration	(*((volatile unsigned int *) (DMAC_BASE + 0x030)))
#define DMACSync		(*((volatile unsigned int *) (DMAC_BASE + 0x034)))

/* Channel 0 Registers */
#define DMACC0SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x100)))
#define DMACC0DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x104)))
#define DMACC0LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x108)))
#define DMACC0Control		(*((volatile unsigned int *) (DMAC_BASE + 0x10C)))
#define DMACC0Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x110)))

/* Channel 1 Registers */
#define DMACC1SrcAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x120)))
#define DMACC1DestAddr		(*((volatile unsigned int *) (DMAC_BASE + 0x124)))
#define DMACC1LLI		(*((volatile unsigned int *) (DMAC_BASE + 0x128)))
#define DMACC1Control		(*((volatile unsigned int *) (DMAC_BASE + 0x12C)))
#define DMACC1Configuration	(*((volatile unsigned int *) (DMAC_BASE + 0x130)))


/*
** EMC External Memory Controller
*/

#define EMC_BASE 0xFFE08000

#define EMCControl		(*((volatile unsigned int *) (EMC_BASE + 0x000)))
#define EMCStatus		(*((volatile unsigned int *) (EMC_BASE + 0x004)))
#define EMCConfig		(*((volatile unsigned int *) (EMC_BASE + 0x008)))

#define EMCStaticConfig0	(*((volatile unsigned int *) (EMC_BASE + 0x200)))
#define EMCStaticWaitWen0	(*((volatile unsigned int *) (EMC_BASE + 0x204)))
#define EMCStaticWaitOen0	(*((volatile unsigned int *) (EMC_BASE + 0x208)))
#define EMCStaticWaitRd0	(*((volatile unsigned int *) (EMC_BASE + 0x20C)))
#define EMCStaticWaitPage0	(*((volatile unsigned int *) (EMC_BASE + 0x210)))
#define EMCStaticWaitWr0	(*((volatile unsigned int *) (EMC_BASE + 0x214)))
#define EMCStaticWaitTurn0	(*((volatile unsigned int *) (EMC_BASE + 0x218)))

#define EMCStaticConfig1	(*((volatile unsigned int *) (EMC_BASE + 0x220)))
#define EMCStaticWaitWen1	(*((volatile unsigned int *) (EMC_BASE + 0x224)))
#define EMCStaticWaitOen1	(*((volatile unsigned int *) (EMC_BASE + 0x228)))
#define EMCStaticWaitRd1	(*((volatile unsigned int *) (EMC_BASE + 0x22C)))
#define EMCStaticWaitPage1	(*((volatile unsigned int *) (EMC_BASE + 0x230)))
#define EMCStaticWaitWr1	(*((volatile unsigned int *) (EMC_BASE + 0x234)))
#define EMCStaticWaitTurn1	(*((volatile unsigned int *) (EMC_BASE + 0x238)))

#define EMCStaticExtendedWait	(*((volatile unsigned int *) (EMC_BASE + 0x880)))


/*
** USB Controller
*/

/* Interrupt status register */
#define USBIntSt        	(*((volatile unsigned int  *) 0xE01FC1C0))

#define USB_BASE 0xFFE0C000

/* Port select register */
#if !defined(_LPC2364_H) && !defined(_LPC2366_H) && !defined(_LPC2368_H)
#define USBPortSel	     	(*((volatile unsigned int  *) (USB_BASE + 0x110)))
#endif /* !defined(_LPC2364_H) && !defined(_LPC2366_H) && !defined(_LPC2368_H) */

/* Device interrupt registers */
#define USBDevIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0x200)))
#define USBDevIntEn     	(*((volatile unsigned int  *) (USB_BASE + 0x204)))
#define USBDevIntClr    	(*((volatile unsigned int  *) (USB_BASE + 0x208)))
#define USBDevIntSet    	(*((volatile unsigned int  *) (USB_BASE + 0x20C)))
#define USBDevIntPri    	(*((volatile unsigned char *) (USB_BASE + 0x22C)))

/* Endpoint interrupt registers */
#define USBEpIntSt      	(*((volatile unsigned int  *) (USB_BASE + 0x230)))
#define USBEpIntEn      	(*((volatile unsigned int  *) (USB_BASE + 0x234)))
#define USBEpIntClr     	(*((volatile unsigned int  *) (USB_BASE + 0x238)))
#define USBEpIntSet     	(*((volatile unsigned int  *) (USB_BASE + 0x23C)))
#define USBEpIntPri     	(*((volatile unsigned int  *) (USB_BASE + 0x240)))

/* Endpoint realization registers */
#define USBReEp         	(*((volatile unsigned int  *) (USB_BASE + 0x244)))
#define USBEpInd        	(*((volatile unsigned int  *) (USB_BASE + 0x248)))
#define USBMaxPSize     	(*((volatile unsigned int  *) (USB_BASE + 0x24C)))

/* USB transfer registers */
#define USBRxData       	(*((volatile unsigned int  *) (USB_BASE + 0x218)))
#define USBRxPLen       	(*((volatile unsigned int  *) (USB_BASE + 0x220)))
#define USBTxData       	(*((volatile unsigned int  *) (USB_BASE + 0x21C)))
#define USBTxPLen       	(*((volatile unsigned int  *) (USB_BASE + 0x224)))
#define USBCtrl         	(*((volatile unsigned int  *) (USB_BASE + 0x228)))

/* Command registers */
#define USBCmdCode      	(*((volatile unsigned int  *) (USB_BASE + 0x210)))
#define USBCmdData      	(*((volatile unsigned int  *) (USB_BASE + 0x214)))

/* DMA Registers */
#define USBDMARSt       	(*((volatile unsigned int  *) (USB_BASE + 0x250)))
#define USBDMARClr      	(*((volatile unsigned int  *) (USB_BASE + 0x254)))
#define USBDMARSet      	(*((volatile unsigned int  *) (USB_BASE + 0x258)))
#define USBUDCAH        	(*((volatile unsigned int  *) (USB_BASE + 0x280)))
#define USBEpDMASt      	(*((volatile unsigned int  *) (USB_BASE + 0x284)))
#define USBEpDMAEn      	(*((volatile unsigned int  *) (USB_BASE + 0x288)))
#define USBEpDMADis     	(*((volatile unsigned int  *) (USB_BASE + 0x28C)))
#define USBDMAIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0x290)))
#define USBDMAIntEn     	(*((volatile unsigned int  *) (USB_BASE + 0x294)))
#define USBEoTIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0x2A0)))
#define USBEoTIntClr    	(*((volatile unsigned int  *) (USB_BASE + 0x2A4)))
#define USBEoTIntSet    	(*((volatile unsigned int  *) (USB_BASE + 0x2A8)))
#define USBNDDRIntSt    	(*((volatile unsigned int  *) (USB_BASE + 0x2AC)))
#define USBNDDRIntClr   	(*((volatile unsigned int  *) (USB_BASE + 0x2B0)))
#define USBNDDRIntSet   	(*((volatile unsigned int  *) (USB_BASE + 0x2B4)))
#define USBSysErrIntSt  	(*((volatile unsigned int  *) (USB_BASE + 0x2B8)))
#define USBSysErrIntClr 	(*((volatile unsigned int  *) (USB_BASE + 0x2BC)))
#define USBSysErrIntSet 	(*((volatile unsigned int  *) (USB_BASE + 0x2C0)))

/* Clock control registers */
#define USBClkCtrl      	(*((volatile unsigned int  *) (USB_BASE + 0xFF4)))
#define USBClkSt	      	(*((volatile unsigned int  *) (USB_BASE + 0xFF8)))


/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VICIRQStatus		(*((volatile unsigned int  *) (VIC_BASE + 0x000)))
#define VICFIQStatus		(*((volatile unsigned int  *) (VIC_BASE + 0x004)))
#define VICRawIntr		(*((volatile unsigned int  *) (VIC_BASE + 0x008)))
#define VICIntSelect		(*((volatile unsigned int  *) (VIC_BASE + 0x00C)))
#define VICIntEnable		(*((volatile unsigned int  *) (VIC_BASE + 0x010)))
#define VICIntEnClr		(*((volatile unsigned int  *) (VIC_BASE + 0x014)))
#define VICSoftInt		(*((volatile unsigned int  *) (VIC_BASE + 0x018)))
#define VICSoftIntClear		(*((volatile unsigned int  *) (VIC_BASE + 0x01C)))
#define VICProtection		(*((volatile unsigned int  *) (VIC_BASE + 0x020)))
#define VICSWPriorityMask	(*((volatile unsigned int  *) (VIC_BASE + 0x024)))

#define VICVectAddr0   		(*((volatile unsigned int  *) (VIC_BASE + 0x100)))
#define VICVectAddr1   		(*((volatile unsigned int  *) (VIC_BASE + 0x104)))
#define VICVectAddr2   		(*((volatile unsigned int  *) (VIC_BASE + 0x108)))
#define VICVectAddr3   		(*((volatile unsigned int  *) (VIC_BASE + 0x10C)))
#define VICVectAddr4   		(*((volatile unsigned int  *) (VIC_BASE + 0x110)))
#define VICVectAddr5   		(*((volatile unsigned int  *) (VIC_BASE + 0x114)))
#define VICVectAddr6   		(*((volatile unsigned int  *) (VIC_BASE + 0x118)))
#define VICVectAddr7   		(*((volatile unsigned int  *) (VIC_BASE + 0x11C)))
#define VICVectAddr8   		(*((volatile unsigned int  *) (VIC_BASE + 0x120)))
#define VICVectAddr9   		(*((volatile unsigned int  *) (VIC_BASE + 0x124)))
#define VICVectAddr10  		(*((volatile unsigned int  *) (VIC_BASE + 0x128)))
#define VICVectAddr11  		(*((volatile unsigned int  *) (VIC_BASE + 0x12C)))
#define VICVectAddr12  		(*((volatile unsigned int  *) (VIC_BASE + 0x130)))
#define VICVectAddr13  		(*((volatile unsigned int  *) (VIC_BASE + 0x134)))
#define VICVectAddr14  		(*((volatile unsigned int  *) (VIC_BASE + 0x138)))
#define VICVectAddr15  		(*((volatile unsigned int  *) (VIC_BASE + 0x13C)))
#define VICVectAddr16  		(*((volatile unsigned int  *) (VIC_BASE + 0x140)))
#define VICVectAddr17  		(*((volatile unsigned int  *) (VIC_BASE + 0x144)))
#define VICVectAddr18  		(*((volatile unsigned int  *) (VIC_BASE + 0x148)))
#define VICVectAddr19  		(*((volatile unsigned int  *) (VIC_BASE + 0x14C)))
#define VICVectAddr20  		(*((volatile unsigned int  *) (VIC_BASE + 0x150)))
#define VICVectAddr21  		(*((volatile unsigned int  *) (VIC_BASE + 0x154)))
#define VICVectAddr22  		(*((volatile unsigned int  *) (VIC_BASE + 0x158)))
#define VICVectAddr23  		(*((volatile unsigned int  *) (VIC_BASE + 0x15C)))
#define VICVectAddr24  		(*((volatile unsigned int  *) (VIC_BASE + 0x160)))
#define VICVectAddr25  		(*((volatile unsigned int  *) (VIC_BASE + 0x164)))
#define VICVectAddr26  		(*((volatile unsigned int  *) (VIC_BASE + 0x168)))
#define VICVectAddr27  		(*((volatile unsigned int  *) (VIC_BASE + 0x16C)))
#define VICVectAddr28  		(*((volatile unsigned int  *) (VIC_BASE + 0x170)))
#define VICVectAddr29  		(*((volatile unsigned int  *) (VIC_BASE + 0x174)))
#define VICVectAddr30  		(*((volatile unsigned int  *) (VIC_BASE + 0x178)))
#define VICVectAddr31  		(*((volatile unsigned int  *) (VIC_BASE + 0x17C)))

#define VICVectPriority0	(*((volatile unsigned int  *) (VIC_BASE + 0x200)))
#define VICVectPriority1	(*((volatile unsigned int  *) (VIC_BASE + 0x204)))
#define VICVectPriority2	(*((volatile unsigned int  *) (VIC_BASE + 0x208)))
#define VICVectPriority3	(*((volatile unsigned int  *) (VIC_BASE + 0x20C)))
#define VICVectPriority4	(*((volatile unsigned int  *) (VIC_BASE + 0x210)))
#define VICVectPriority5	(*((volatile unsigned int  *) (VIC_BASE + 0x214)))
#define VICVectPriority6	(*((volatile unsigned int  *) (VIC_BASE + 0x218)))
#define VICVectPriority7	(*((volatile unsigned int  *) (VIC_BASE + 0x21C)))
#define VICVectPriority8	(*((volatile unsigned int  *) (VIC_BASE + 0x220)))
#define VICVectPriority9	(*((volatile unsigned int  *) (VIC_BASE + 0x224)))
#define VICVectPriority10	(*((volatile unsigned int  *) (VIC_BASE + 0x228)))
#define VICVectPriority11	(*((volatile unsigned int  *) (VIC_BASE + 0x22C)))
#define VICVectPriority12	(*((volatile unsigned int  *) (VIC_BASE + 0x230)))
#define VICVectPriority13	(*((volatile unsigned int  *) (VIC_BASE + 0x234)))
#define VICVectPriority14	(*((volatile unsigned int  *) (VIC_BASE + 0x238)))
#define VICVectPriority15	(*((volatile unsigned int  *) (VIC_BASE + 0x23C)))
#define VICVectPriority16	(*((volatile unsigned int  *) (VIC_BASE + 0x240)))
#define VICVectPriority17	(*((volatile unsigned int  *) (VIC_BASE + 0x244)))
#define VICVectPriority18	(*((volatile unsigned int  *) (VIC_BASE + 0x248)))
#define VICVectPriority19	(*((volatile unsigned int  *) (VIC_BASE + 0x24C)))
#define VICVectPriority20	(*((volatile unsigned int  *) (VIC_BASE + 0x250)))
#define VICVectPriority21	(*((volatile unsigned int  *) (VIC_BASE + 0x254)))
#define VICVectPriority22	(*((volatile unsigned int  *) (VIC_BASE + 0x258)))
#define VICVectPriority23	(*((volatile unsigned int  *) (VIC_BASE + 0x25C)))
#define VICVectPriority24	(*((volatile unsigned int  *) (VIC_BASE + 0x260)))
#define VICVectPriority25	(*((volatile unsigned int  *) (VIC_BASE + 0x264)))
#define VICVectPriority26	(*((volatile unsigned int  *) (VIC_BASE + 0x268)))
#define VICVectPriority27	(*((volatile unsigned int  *) (VIC_BASE + 0x26C)))
#define VICVectPriority28	(*((volatile unsigned int  *) (VIC_BASE + 0x270)))
#define VICVectPriority29	(*((volatile unsigned int  *) (VIC_BASE + 0x274)))
#define VICVectPriority30	(*((volatile unsigned int  *) (VIC_BASE + 0x278)))
#define VICVectPriority31	(*((volatile unsigned int  *) (VIC_BASE + 0x27C)))

#define VICAddress		(*((volatile unsigned int  *) (VIC_BASE + 0xF00)))


#endif  // _LPC23xx_H
