/**************************************************************************
**                                                                        *
**  FILE        :  lpc21xx.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**                 LPC2109, LPC2114, LPC2119, LPC2124, LPC2129, LPC2194,  *
**		   LPC2212, LPC2214, LPC2290, LPC2292 & LPC2294           *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC21XX_H
#define _LPC21XX_H


/*
** WD Watchdog
*/

#define WD_BASE 0xE0000000

#define WD_MOD            	(*((volatile unsigned char *) (WD_BASE + 0x00)))
#define WD_TC             	(*((volatile unsigned int  *) (WD_BASE + 0x04)))
#define WD_FEED             	(*((volatile unsigned char *) (WD_BASE + 0x08)))
#define WD_TV           	(*((volatile unsigned int  *) (WD_BASE + 0x0C)))


/*
** TIMER0 Timer 0
*/

#define TIMER0_BASE 0xE0004000

#define TIMER0_IR           	(*((volatile unsigned char *) (TIMER0_BASE + 0x00)))
#define TIMER0_TCR          	(*((volatile unsigned char *) (TIMER0_BASE + 0x04)))
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x08)))
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x0C)))
#define TIMER0_PC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x10)))
#define TIMER0_MCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x14)))
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x18)))
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x1C)))
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x20)))
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x24)))
#define TIMER0_CCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x28)))
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x2C)))
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x30)))
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x34)))
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x38)))
#define TIMER0_EMR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x3C)))


/*
** TIMER1 Timer 1
*/

#define TIMER1_BASE 0xE0008000

#define TIMER1_IR           	(*((volatile unsigned char *) (TIMER1_BASE + 0x00)))
#define TIMER1_TCR          	(*((volatile unsigned char *) (TIMER1_BASE + 0x04)))
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x08)))
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x0C)))
#define TIMER1_PC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x10)))
#define TIMER1_MCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x14)))
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x18)))
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x1C)))
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x20)))
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x24)))
#define TIMER1_CCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x28)))
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x2C)))
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x30)))
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x34)))
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x38)))
#define TIMER1_EMR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x3C)))


/*
** UART0 Universal Asynchronous Receiver Transmitter 0
*/

#define UART0_BASE 0xE000C000

#define UART0_RBR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_THR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_DLL		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_IER		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_DLM		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_IIR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_FCR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_LCR		(*((volatile unsigned char *) (UART0_BASE + 0x0C)))
#define UART0_LSR		(*((volatile unsigned char *) (UART0_BASE + 0x14)))
#define UART0_SCR		(*((volatile unsigned char *) (UART0_BASE + 0x1C)))


/*
** UART1 Universal Asynchronous Receiver Transmitter 1
*/

#define UART1_BASE 0xE0010000

#define UART1_RBR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_THR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_DLL		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_IER		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_DLM		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_IIR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_FCR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_LCR		(*((volatile unsigned char *) (UART1_BASE + 0x0C)))
#define UART1_MCR		(*((volatile unsigned char *) (UART1_BASE + 0x10)))
#define UART1_LSR		(*((volatile unsigned char *) (UART1_BASE + 0x14)))
#define UART1_MSR		(*((volatile unsigned char *) (UART1_BASE + 0x18)))
#define UART1_SCR		(*((volatile unsigned char *) (UART1_BASE + 0x1C)))


/*
** PWM Pulse Width Modulator
*/

#define PWM_BASE 0xE0014000

#define PWM_IR          	(*((volatile unsigned int  *) (PWM_BASE + 0x00)))
#define PWM_TCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x04)))
#define PWM_TC          	(*((volatile unsigned int  *) (PWM_BASE + 0x08)))
#define PWM_PR          	(*((volatile unsigned int  *) (PWM_BASE + 0x0C)))
#define PWM_PC          	(*((volatile unsigned int  *) (PWM_BASE + 0x10)))
#define PWM_MCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x14)))
#define PWM_MR0         	(*((volatile unsigned int  *) (PWM_BASE + 0x18)))
#define PWM_MR1         	(*((volatile unsigned int  *) (PWM_BASE + 0x1C)))
#define PWM_MR2         	(*((volatile unsigned int  *) (PWM_BASE + 0x20)))
#define PWM_MR3         	(*((volatile unsigned int  *) (PWM_BASE + 0x24)))
#define PWM_MR4         	(*((volatile unsigned int  *) (PWM_BASE + 0x40)))
#define PWM_MR5         	(*((volatile unsigned int  *) (PWM_BASE + 0x44)))
#define PWM_MR6         	(*((volatile unsigned int  *) (PWM_BASE + 0x48)))
#define PWM_PCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x4C)))
#define PWM_LER         	(*((volatile unsigned int  *) (PWM_BASE + 0x50)))


/*
** I2C Inter-Integrated Circuit interface
*/

#define I2C_BASE 0xE001C000

#define I2C_CONSET     		(*((volatile unsigned char *) (I2C_BASE + 0x00)))
#define I2C_STAT       		(*((volatile unsigned char *) (I2C_BASE + 0x04)))
#define I2C_DAT        		(*((volatile unsigned char *) (I2C_BASE + 0x08)))
#define I2C_ADR        		(*((volatile unsigned char *) (I2C_BASE + 0x0C)))
#define I2C_SCLH       		(*((volatile unsigned short*) (I2C_BASE + 0x10)))
#define I2C_SCLL       		(*((volatile unsigned short*) (I2C_BASE + 0x14)))
#define I2C_CONCLR     		(*((volatile unsigned char *) (I2C_BASE + 0x18)))


/*
** SPI0 Serial Peripheral Interface 0
*/

#define SPI0_BASE 0xE0020000

#define SPI0_CR         	(*((volatile unsigned char *) (SPI0_BASE + 0x00)))
#define SPI0_SR         	(*((volatile unsigned char *) (SPI0_BASE + 0x04)))
#define SPI0_DR         	(*((volatile unsigned char *) (SPI0_BASE + 0x08)))
#define SPI0_CCR        	(*((volatile unsigned char *) (SPI0_BASE + 0x0C)))
#define SPI0_INT        	(*((volatile unsigned char *) (SPI0_BASE + 0x1C)))


/*
** SPI1 Serial Peripheral Interface 1
*/

#define SPI1_BASE 0xE0030000

#define SPI1_CR         	(*((volatile unsigned char *) (SPI1_BASE + 0x00)))
#define SPI1_SR         	(*((volatile unsigned char *) (SPI1_BASE + 0x04)))
#define SPI1_DR         	(*((volatile unsigned char *) (SPI1_BASE + 0x08)))
#define SPI1_CCR        	(*((volatile unsigned char *) (SPI1_BASE + 0x0C)))
#define SPI1_INT        	(*((volatile unsigned char *) (SPI1_BASE + 0x1C)))


/*
** RTC Real Time Clock
*/

#define RTC_BASE 0xE0024000

#define RTC_ILR            	(*((volatile unsigned char *) (RTC_BASE + 0x00)))
#define RTC_CTC            	(*((volatile unsigned short*) (RTC_BASE + 0x04)))
#define RTC_CCR            	(*((volatile unsigned char *) (RTC_BASE + 0x08)))
#define RTC_CIIR           	(*((volatile unsigned char *) (RTC_BASE + 0x0C)))
#define RTC_AMR            	(*((volatile unsigned char *) (RTC_BASE + 0x10)))
#define RTC_CTIME0         	(*((volatile unsigned int  *) (RTC_BASE + 0x14)))
#define RTC_CTIME1         	(*((volatile unsigned int  *) (RTC_BASE + 0x18)))
#define RTC_CTIME2         	(*((volatile unsigned int  *) (RTC_BASE + 0x1C)))
#define RTC_SEC            	(*((volatile unsigned char *) (RTC_BASE + 0x20)))
#define RTC_MIN            	(*((volatile unsigned char *) (RTC_BASE + 0x24)))
#define RTC_HOUR           	(*((volatile unsigned char *) (RTC_BASE + 0x28)))
#define RTC_DOM            	(*((volatile unsigned char *) (RTC_BASE + 0x2C)))
#define RTC_DOW            	(*((volatile unsigned char *) (RTC_BASE + 0x30)))
#define RTC_DOY            	(*((volatile unsigned short*) (RTC_BASE + 0x34)))
#define RTC_MONTH          	(*((volatile unsigned char *) (RTC_BASE + 0x38)))
#define RTC_YEAR           	(*((volatile unsigned short*) (RTC_BASE + 0x3C)))
#define RTC_ALSEC          	(*((volatile unsigned char *) (RTC_BASE + 0x60)))
#define RTC_ALMIN          	(*((volatile unsigned char *) (RTC_BASE + 0x64)))
#define RTC_ALHOUR         	(*((volatile unsigned char *) (RTC_BASE + 0x68)))
#define RTC_ALDOM          	(*((volatile unsigned char *) (RTC_BASE + 0x6C)))
#define RTC_ALDOW          	(*((volatile unsigned char *) (RTC_BASE + 0x70)))
#define RTC_ALDOY          	(*((volatile unsigned short*) (RTC_BASE + 0x74)))
#define RTC_ALMON          	(*((volatile unsigned char *) (RTC_BASE + 0x78)))
#define RTC_ALYEAR         	(*((volatile unsigned short*) (RTC_BASE + 0x7C)))
#define RTC_PREINT         	(*((volatile unsigned short*) (RTC_BASE + 0x80)))
#define RTC_PREFRAC        	(*((volatile unsigned short*) (RTC_BASE + 0x84)))


/*
** GPIO General Purpose Input/Output
*/

#define GPIO_BASE 0xE0028000

/* Input/Output registers PORT 0 */
#define GPIO0_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x00)))
#define GPIO0_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x04)))
#define GPIO0_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x08)))
#define GPIO0_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x0C)))

/* Input/Output registers PORT 1 */
#define GPIO1_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x10)))
#define GPIO1_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x14)))
#define GPIO1_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x18)))
#define GPIO1_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x1C)))

#if !defined(_LPC2109_H) && !defined(_LPC2114_H) && !defined(_LPC2119_H) && !defined(_LPC2124_H) && !defined(_LPC2129_H) && !defined(_LPC2194_H)

/* Input/Output registers PORT 2 */
#define GPIO2_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x20)))
#define GPIO2_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x24)))
#define GPIO2_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x28)))
#define GPIO2_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x2C)))

/* Input/Output registers PORT 3 */
#define GPIO3_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x30)))
#define GPIO3_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x34)))
#define GPIO3_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x38)))
#define GPIO3_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x3C)))

#endif /* !defined(_LPC2109_H) && !defined(_LPC2114_H) && !defined(_LPC2119_H) && !defined(_LPC2124_H) && !defined(_LPC2129_H) && !defined(_LPC2194_H) */


/*
** PCB Pin Connect Block
*/

#define PCB_BASE 0xE002C000

#define PCB_PINSEL0        	(*((volatile unsigned int  *) (PCB_BASE + 0x00)))
#define PCB_PINSEL1        	(*((volatile unsigned int  *) (PCB_BASE + 0x04)))
#define PCB_PINSEL2        	(*((volatile unsigned int  *) (PCB_BASE + 0x14)))


/*
** ADC Analog/Digital Converter
*/

#define ADC_BASE 0xE0034000

#define ADC_CR           	(*((volatile unsigned int  *) (ADC_BASE + 0x00)))
#define ADC_DR          	(*((volatile unsigned int  *) (ADC_BASE + 0x04)))


/*
** CAN
*/

#if !defined(_LPC2114_H) && !defined(_LPC2124_H) && !defined(_LPC2212_H) && !defined(_LPC2214_H)


/*
** CANAFM CAN Acceptance Filter Memory (ID-look-up table)
*/

#define CANAFM_BASE 0xE0038000
 

/*
** CANAFR CAN Acceptance Filter registers
*/

#define CANAFR_BASE 0xE003C000

#define CANAFR_AFMR       	(*((volatile unsigned int  *) (CANAFR_BASE + 0x00);
#define CANAFR_SFF_SA     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x04);
#define CANAFR_SFF_GRP_SA 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x08);
#define CANAFR_EFF_SA     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x0C);
#define CANAFR_EFF_GRP_SA 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x10);
#define CANAFR_ENDOFTABLE 	(*((volatile unsigned int  *) (CANAFR_BASE + 0x14);
#define CANAFR_LUTERRAD   	(*((volatile unsigned int  *) (CANAFR_BASE + 0x18);
#define CANAFR_LUTERR     	(*((volatile unsigned int  *) (CANAFR_BASE + 0x1C);


/*
** CANCS CAN Central Status registers
*/

#define CANCS_BASE 0xE0040000

#define CANCS_TXSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x0)))
#define CANCS_RXSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x4)))
#define CANCS_MSR         	(*((volatile unsigned int  *) (CANCS_BASE + 0x8)))


/*
** CAN1 CAN 1
*/

#define CAN1_BASE 0xE0044000

#define CAN1_MOD          	(*((volatile unsigned int  *) (CAN1_BASE + 0x00)))
#define CAN1_CMR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x04)))
#define CAN1_GSR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x08)))
#define CAN1_ICR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x0C)))
#define CAN1_IER          	(*((volatile unsigned int  *) (CAN1_BASE + 0x10)))
#define CAN1_BTR          	(*((volatile unsigned int  *) (CAN1_BASE + 0x14)))
#define CAN1_EWL          	(*((volatile unsigned int  *) (CAN1_BASE + 0x18)))
#define CAN1_SR           	(*((volatile unsigned int  *) (CAN1_BASE + 0x1C)))
#define CAN1_RFS          	(*((volatile unsigned int  *) (CAN1_BASE + 0x20)))
#define CAN1_RID          	(*((volatile unsigned int  *) (CAN1_BASE + 0x24)))
#define CAN1_RDA          	(*((volatile unsigned int  *) (CAN1_BASE + 0x28)))
#define CAN1_RDB          	(*((volatile unsigned int  *) (CAN1_BASE + 0x2C)))
#define CAN1_TFI1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x30)))
#define CAN1_TID1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x34)))
#define CAN1_TDA1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x38)))
#define CAN1_TDB1         	(*((volatile unsigned int  *) (CAN1_BASE + 0x3C)))
#define CAN1_TFI2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x40)))
#define CAN1_TID2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x44)))
#define CAN1_TDA2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x48)))
#define CAN1_TDB2         	(*((volatile unsigned int  *) (CAN1_BASE + 0x4C)))
#define CAN1_TFI3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x50)))
#define CAN1_TID3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x54)))
#define CAN1_TDA3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x58)))
#define CAN1_TDB3         	(*((volatile unsigned int  *) (CAN1_BASE + 0x5C)))


/*
** CAN2 CAN 2
*/

#define CAN2_BASE 0xE0048000

#define CAN2_MOD          	(*((volatile unsigned int  *) (CAN2_BASE + 0x00)))
#define CAN2_CMR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x04)))
#define CAN2_GSR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x08)))
#define CAN2_ICR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x0C)))
#define CAN2_IER          	(*((volatile unsigned int  *) (CAN2_BASE + 0x10)))
#define CAN2_BTR          	(*((volatile unsigned int  *) (CAN2_BASE + 0x14)))
#define CAN2_EWL          	(*((volatile unsigned int  *) (CAN2_BASE + 0x18)))
#define CAN2_SR           	(*((volatile unsigned int  *) (CAN2_BASE + 0x1C)))
#define CAN2_RFS          	(*((volatile unsigned int  *) (CAN2_BASE + 0x20)))
#define CAN2_RID          	(*((volatile unsigned int  *) (CAN2_BASE + 0x24)))
#define CAN2_RDA          	(*((volatile unsigned int  *) (CAN2_BASE + 0x28)))
#define CAN2_RDB          	(*((volatile unsigned int  *) (CAN2_BASE + 0x2C)))
#define CAN2_TFI1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x30)))
#define CAN2_TID1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x34)))
#define CAN2_TDA1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x38)))
#define CAN2_TDB1         	(*((volatile unsigned int  *) (CAN2_BASE + 0x3C)))
#define CAN2_TFI2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x40)))
#define CAN2_TID2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x44)))
#define CAN2_TDA2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x48)))
#define CAN2_TDB2         	(*((volatile unsigned int  *) (CAN2_BASE + 0x4C)))
#define CAN2_TFI3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x50)))
#define CAN2_TID3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x54)))
#define CAN2_TDA3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x58)))
#define CAN2_TDB3         	(*((volatile unsigned int  *) (CAN2_BASE + 0x5C)))


/*
** CAN3 CAN 3
*/

#if !defined(_LPC2109_H) && !defined(_LPC2119_H) && !defined(_LPC2129_H) && !defined(_LPC2290_H) && !defined(_LPC2292_H)

#define CAN3_BASE 0xE004c000

#define CAN3_MOD          	(*((volatile unsigned int  *) (CAN3_BASE + 0x00)))
#define CAN3_CMR          	(*((volatile unsigned int  *) (CAN3_BASE + 0x04)))
#define CAN3_GSR          	(*((volatile unsigned int  *) (CAN3_BASE + 0x08)))
#define CAN3_ICR          	(*((volatile unsigned int  *) (CAN3_BASE + 0x0C)))
#define CAN3_IER          	(*((volatile unsigned int  *) (CAN3_BASE + 0x10)))
#define CAN3_BTR          	(*((volatile unsigned int  *) (CAN3_BASE + 0x14)))
#define CAN3_EWL          	(*((volatile unsigned int  *) (CAN3_BASE + 0x18)))
#define CAN3_SR           	(*((volatile unsigned int  *) (CAN3_BASE + 0x1C)))
#define CAN3_RFS          	(*((volatile unsigned int  *) (CAN3_BASE + 0x20)))
#define CAN3_RID          	(*((volatile unsigned int  *) (CAN3_BASE + 0x24)))
#define CAN3_RDA          	(*((volatile unsigned int  *) (CAN3_BASE + 0x28)))
#define CAN3_RDB          	(*((volatile unsigned int  *) (CAN3_BASE + 0x2C)))
#define CAN3_TFI1         	(*((volatile unsigned int  *) (CAN3_BASE + 0x30)))
#define CAN3_TID1         	(*((volatile unsigned int  *) (CAN3_BASE + 0x34)))
#define CAN3_TDA1         	(*((volatile unsigned int  *) (CAN3_BASE + 0x38)))
#define CAN3_TDB1         	(*((volatile unsigned int  *) (CAN3_BASE + 0x3C)))
#define CAN3_TFI2         	(*((volatile unsigned int  *) (CAN3_BASE + 0x40)))
#define CAN3_TID2         	(*((volatile unsigned int  *) (CAN3_BASE + 0x44)))
#define CAN3_TDA2         	(*((volatile unsigned int  *) (CAN3_BASE + 0x48)))
#define CAN3_TDB2         	(*((volatile unsigned int  *) (CAN3_BASE + 0x4C)))
#define CAN3_TFI3         	(*((volatile unsigned int  *) (CAN3_BASE + 0x50)))
#define CAN3_TID3         	(*((volatile unsigned int  *) (CAN3_BASE + 0x54)))
#define CAN3_TDA3         	(*((volatile unsigned int  *) (CAN3_BASE + 0x58)))
#define CAN3_TDB3         	(*((volatile unsigned int  *) (CAN3_BASE + 0x5C)))


/*
** CAN4 CAN 4
*/

#define CAN4_BASE 0xE0050000

#define CAN4_MOD          	(*((volatile unsigned int  *) (CAN4_BASE + 0x00)))
#define CAN4_CMR          	(*((volatile unsigned int  *) (CAN4_BASE + 0x04)))
#define CAN4_GSR          	(*((volatile unsigned int  *) (CAN4_BASE + 0x08)))
#define CAN4_ICR          	(*((volatile unsigned int  *) (CAN4_BASE + 0x0C)))
#define CAN4_IER          	(*((volatile unsigned int  *) (CAN4_BASE + 0x10)))
#define CAN4_BTR          	(*((volatile unsigned int  *) (CAN4_BASE + 0x14)))
#define CAN4_EWL          	(*((volatile unsigned int  *) (CAN4_BASE + 0x18)))
#define CAN4_SR           	(*((volatile unsigned int  *) (CAN4_BASE + 0x1C)))
#define CAN4_RFS          	(*((volatile unsigned int  *) (CAN4_BASE + 0x20)))
#define CAN4_RID          	(*((volatile unsigned int  *) (CAN4_BASE + 0x24)))
#define CAN4_RDA          	(*((volatile unsigned int  *) (CAN4_BASE + 0x28)))
#define CAN4_RDB          	(*((volatile unsigned int  *) (CAN4_BASE + 0x2C)))
#define CAN4_TFI1         	(*((volatile unsigned int  *) (CAN4_BASE + 0x30)))
#define CAN4_TID1         	(*((volatile unsigned int  *) (CAN4_BASE + 0x34)))
#define CAN4_TDA1         	(*((volatile unsigned int  *) (CAN4_BASE + 0x38)))
#define CAN4_TDB1         	(*((volatile unsigned int  *) (CAN4_BASE + 0x3C)))
#define CAN4_TFI2         	(*((volatile unsigned int  *) (CAN4_BASE + 0x40)))
#define CAN4_TID2         	(*((volatile unsigned int  *) (CAN4_BASE + 0x44)))
#define CAN4_TDA2         	(*((volatile unsigned int  *) (CAN4_BASE + 0x48)))
#define CAN4_TDB2         	(*((volatile unsigned int  *) (CAN4_BASE + 0x4C)))
#define CAN4_TFI3         	(*((volatile unsigned int  *) (CAN4_BASE + 0x50)))
#define CAN4_TID3         	(*((volatile unsigned int  *) (CAN4_BASE + 0x54)))
#define CAN4_TDA3         	(*((volatile unsigned int  *) (CAN4_BASE + 0x58)))
#define CAN4_TDB3         	(*((volatile unsigned int  *) (CAN4_BASE + 0x5C)))

#endif /* !defined(_LPC2109_H) && !defined(_LPC2119_H) && !defined(_LPC2129_H) && !defined(_LPC2290_H) && !defined(_LPC2292_H) */
#endif /* !defined(_LPC2114_H) && !defined(_LPC2124_H) && !defined(_LPC2212_H) && !defined(_LPC2214_H) */


/*
** SCB System Control Block
*/

#define SCB_BASE 0xE01FC000

/* MAM Memory Accelerator Module */
#define SCB_MAMCR		(*((volatile unsigned char *) (SCB_BASE + 0x000)))
#define SCB_MAMTIM		(*((volatile unsigned char *) (SCB_BASE + 0x004)))

/* Memory Mapping control */
#define SCB_MEMMAP		(*((volatile unsigned char *) (SCB_BASE + 0x040)))

/* PLL Phase Locked Loop */
#define SCB_PLLCON		(*((volatile unsigned char *) (SCB_BASE + 0x080)))
#define SCB_PLLCFG		(*((volatile unsigned char *) (SCB_BASE + 0x084)))
#define SCB_PLLSTAT		(*((volatile unsigned short*) (SCB_BASE + 0x088)))
#define SCB_PLLFEED		(*((volatile unsigned char *) (SCB_BASE + 0x08C)))

/* PC Power Control */
#define SCB_PCON		(*((volatile unsigned char *) (SCB_BASE + 0x0C0)))
#define SCB_PCONP		(*((volatile unsigned int  *) (SCB_BASE + 0x0C4)))

/* VPB Divider */
#define SCB_VPBDIV		(*((volatile unsigned char *) (SCB_BASE + 0x100)))

/* External Interrupts */
#define SCB_EXTINT         	(*((volatile unsigned char *) (SCB_BASE + 0x140)))
#define SCB_EXTWAKE		(*((volatile unsigned char *) (SCB_BASE + 0x144)))
#define SCB_EXTMODE		(*((volatile unsigned char *) (SCB_BASE + 0x148)))
#define SCB_EXTPOLAR		(*((volatile unsigned char *) (SCB_BASE + 0x14C)))


#if !defined(_LPC2109_H) && !defined(_LPC2114_H) && !defined(_LPC2119_H) && !defined(_LPC2124_H) && !defined(_LPC2129_H) && !defined(_LPC2194_H)

/*
** EMC - External Memory Controller
*/

#define EMC_BASE 0xFFE00000

#define EMC_BCFG0	       (*((volatile unsigned int  *) (EMC_BASE + 0x00)))
#define EMC_BCFG1	       (*((volatile unsigned int  *) (EMC_BASE + 0x04)))
#define EMC_BCFG2	       (*((volatile unsigned int  *) (EMC_BASE + 0x08)))
#define EMC_BCFG3	       (*((volatile unsigned int  *) (EMC_BASE + 0x0C)))

#endif /* !defined(_LPC2109_H) && !defined(_LPC2114_H) && !defined(_LPC2119_H) && !defined(_LPC2124_H) && !defined(_LPC2129_H) && !defined(_LPC2194_H) */


/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VICIRQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x000)))
#define VICFIQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x004)))
#define VICRawIntr     		(*((volatile unsigned int  *) (VIC_BASE + 0x008)))
#define VICIntSelect   		(*((volatile unsigned int  *) (VIC_BASE + 0x00C)))
#define VICIntEnable   		(*((volatile unsigned int  *) (VIC_BASE + 0x010)))
#define VICIntEnClr    		(*((volatile unsigned int  *) (VIC_BASE + 0x014)))
#define VICSoftInt     		(*((volatile unsigned int  *) (VIC_BASE + 0x018)))
#define VICSoftIntClear		(*((volatile unsigned int  *) (VIC_BASE + 0x01C)))
#define VICProtection  		(*((volatile unsigned int  *) (VIC_BASE + 0x020)))
#define VICVectAddr    		(*((volatile unsigned int  *) (VIC_BASE + 0x030)))
#define VICDefVectAddr 		(*((volatile unsigned int  *) (VIC_BASE + 0x034)))

#define VICVectAddr0   		(*((volatile unsigned int  *) (VIC_BASE + 0x100)))
#define VICVectAddr1   		(*((volatile unsigned int  *) (VIC_BASE + 0x104)))
#define VICVectAddr2   		(*((volatile unsigned int  *) (VIC_BASE + 0x108)))
#define VICVectAddr3   		(*((volatile unsigned int  *) (VIC_BASE + 0x10C)))
#define VICVectAddr4   		(*((volatile unsigned int  *) (VIC_BASE + 0x110)))
#define VICVectAddr5   		(*((volatile unsigned int  *) (VIC_BASE + 0x114)))
#define VICVectAddr6   		(*((volatile unsigned int  *) (VIC_BASE + 0x118)))
#define VICVectAddr7   		(*((volatile unsigned int  *) (VIC_BASE + 0x11C)))
#define VICVectAddr8   		(*((volatile unsigned int  *) (VIC_BASE + 0x120)))
#define VICVectAddr9   		(*((volatile unsigned int  *) (VIC_BASE + 0x124)))
#define VICVectAddr10  		(*((volatile unsigned int  *) (VIC_BASE + 0x128)))
#define VICVectAddr11  		(*((volatile unsigned int  *) (VIC_BASE + 0x12C)))
#define VICVectAddr12  		(*((volatile unsigned int  *) (VIC_BASE + 0x130)))
#define VICVectAddr13  		(*((volatile unsigned int  *) (VIC_BASE + 0x134)))
#define VICVectAddr14  		(*((volatile unsigned int  *) (VIC_BASE + 0x138)))
#define VICVectAddr15  		(*((volatile unsigned int  *) (VIC_BASE + 0x13C)))

#define VICVectCntl0   		(*((volatile unsigned int  *) (VIC_BASE + 0x200)))
#define VICVectCntl1   		(*((volatile unsigned int  *) (VIC_BASE + 0x204)))
#define VICVectCntl2   		(*((volatile unsigned int  *) (VIC_BASE + 0x208)))
#define VICVectCntl3   		(*((volatile unsigned int  *) (VIC_BASE + 0x20C)))
#define VICVectCntl4   		(*((volatile unsigned int  *) (VIC_BASE + 0x210)))
#define VICVectCntl5   		(*((volatile unsigned int  *) (VIC_BASE + 0x214)))
#define VICVectCntl6   		(*((volatile unsigned int  *) (VIC_BASE + 0x218)))
#define VICVectCntl7   		(*((volatile unsigned int  *) (VIC_BASE + 0x21C)))
#define VICVectCntl8   		(*((volatile unsigned int  *) (VIC_BASE + 0x220)))
#define VICVectCntl9   		(*((volatile unsigned int  *) (VIC_BASE + 0x224)))
#define VICVectCntl10  		(*((volatile unsigned int  *) (VIC_BASE + 0x228)))
#define VICVectCntl11  		(*((volatile unsigned int  *) (VIC_BASE + 0x22C)))
#define VICVectCntl12  		(*((volatile unsigned int  *) (VIC_BASE + 0x230)))
#define VICVectCntl13  		(*((volatile unsigned int  *) (VIC_BASE + 0x234)))
#define VICVectCntl14  		(*((volatile unsigned int  *) (VIC_BASE + 0x238)))
#define VICVectCntl15  		(*((volatile unsigned int  *) (VIC_BASE + 0x23C)))


#endif   /* _LPC21XX_H */
