/**************************************************************************
**                                                                        *
**  FILE        :  lpc214x.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**		   LPC2141, LPC2142, LPC2144, LPC2146 & LPC2148		  *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC214x_H
#define _LPC214x_H


/*
** WD Watchdog
*/

#define WD_BASE 0xE0000000

#define WD_MOD            	(*((volatile unsigned char *) (WD_BASE + 0x00)))
#define WD_TC             	(*((volatile unsigned int  *) (WD_BASE + 0x04)))
#define WD_FEED             	(*((volatile unsigned char *) (WD_BASE + 0x08)))
#define WD_TV           	(*((volatile unsigned int  *) (WD_BASE + 0x0C)))


/*
** TIMER0 Timer 0
*/

#define TIMER0_BASE 0xE0004000

#define TIMER0_IR           	(*((volatile unsigned char *) (TIMER0_BASE + 0x00)))
#define TIMER0_TCR          	(*((volatile unsigned char *) (TIMER0_BASE + 0x04)))
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x08)))
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x0C)))
#define TIMER0_PC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x10)))
#define TIMER0_MCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x14)))
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x18)))
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x1C)))
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x20)))
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x24)))
#define TIMER0_CCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x28)))
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x2C)))
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x30)))
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x34)))
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x38)))
#define TIMER0_EMR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x3C)))
#define TIMER0_CTCR             (*((volatile unsigned char *) (TIMER0_BASE + 0x70)))


/*
** TIMER1 Timer 1
*/

#define TIMER1_BASE 0xE0008000

#define TIMER1_IR           	(*((volatile unsigned char *) (TIMER1_BASE + 0x00)))
#define TIMER1_TCR          	(*((volatile unsigned char *) (TIMER1_BASE + 0x04)))
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x08)))
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x0C)))
#define TIMER1_PC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x10)))
#define TIMER1_MCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x14)))
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x18)))
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x1C)))
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x20)))
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x24)))
#define TIMER1_CCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x28)))
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x2C)))
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x30)))
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x34)))
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x38)))
#define TIMER1_EMR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x3C)))
#define TIMER1_CTCR             (*((volatile unsigned char *) (TIMER1_BASE + 0x70)))


/*
** UART0 Universal Asynchronous Receiver Transmitter 0
*/

#define UART0_BASE 0xE000C000

#define UART0_RBR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_THR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_DLL		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_IER		(*((volatile unsigned int  *) (UART0_BASE + 0x04)))
#define UART0_DLM		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_IIR		(*((volatile unsigned int  *) (UART0_BASE + 0x08)))
#define UART0_FCR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_LCR		(*((volatile unsigned char *) (UART0_BASE + 0x0C)))
#define UART0_LSR		(*((volatile unsigned char *) (UART0_BASE + 0x14)))
#define UART0_SCR		(*((volatile unsigned char *) (UART0_BASE + 0x1C)))
#define UART0_ACR               (*((volatile unsigned int  *) (UART0_BASE + 0x20)))
#define UART0_FDR               (*((volatile unsigned int  *) (UART0_BASE + 0x28)))
#define UART0_TER               (*((volatile unsigned char *) (UART0_BASE + 0x30)))


/*
** UART1 Universal Asynchronous Receiver Transmitter 1
*/

#define UART1_BASE 0xE0010000

#define UART1_RBR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_THR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_DLL		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_IER		(*((volatile unsigned int  *) (UART1_BASE + 0x04)))
#define UART1_DLM		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_IIR		(*((volatile unsigned int  *) (UART1_BASE + 0x08)))
#define UART1_FCR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_LCR		(*((volatile unsigned char *) (UART1_BASE + 0x0C)))
#define UART1_LSR		(*((volatile unsigned char *) (UART1_BASE + 0x14)))
#define UART1_SCR		(*((volatile unsigned char *) (UART1_BASE + 0x1C)))
#define UART1_ACR               (*((volatile unsigned int  *) (UART1_BASE + 0x20)))
#define UART1_FDR               (*((volatile unsigned int  *) (UART1_BASE + 0x28)))
#define UART1_TER               (*((volatile unsigned char *) (UART1_BASE + 0x30)))

#if !defined(_LPC2141_H) && !defined(_LPC2142_H)

#define UART1_MCR		(*((volatile unsigned char *) (UART1_BASE + 0x10)))
#define UART1_MSR		(*((volatile unsigned char *) (UART1_BASE + 0x18)))

#endif /* !defined(_LPC2141_H) && !defined(_LPC2142_H) */


/*
** PWM Pulse Width Modulator
*/

#define PWM_BASE 0xE0014000

#define PWM_IR          	(*((volatile unsigned int  *) (PWM_BASE + 0x00)))
#define PWM_TCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x04)))
#define PWM_TC          	(*((volatile unsigned int  *) (PWM_BASE + 0x08)))
#define PWM_PR          	(*((volatile unsigned int  *) (PWM_BASE + 0x0C)))
#define PWM_PC          	(*((volatile unsigned int  *) (PWM_BASE + 0x10)))
#define PWM_MCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x14)))
#define PWM_MR0         	(*((volatile unsigned int  *) (PWM_BASE + 0x18)))
#define PWM_MR1         	(*((volatile unsigned int  *) (PWM_BASE + 0x1C)))
#define PWM_MR2         	(*((volatile unsigned int  *) (PWM_BASE + 0x20)))
#define PWM_MR3         	(*((volatile unsigned int  *) (PWM_BASE + 0x24)))
#define PWM_MR4         	(*((volatile unsigned int  *) (PWM_BASE + 0x40)))
#define PWM_MR5         	(*((volatile unsigned int  *) (PWM_BASE + 0x44)))
#define PWM_MR6         	(*((volatile unsigned int  *) (PWM_BASE + 0x48)))
#define PWM_PCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x4C)))
#define PWM_LER         	(*((volatile unsigned int  *) (PWM_BASE + 0x50)))


/*
** I2C0 Inter-Integrated Circuit interface 0
*/

#define I2C0_BASE 0xE001C000

#define I2C0_CONSET     	(*((volatile unsigned char *) (I2C0_BASE + 0x00)))
#define I2C0_STAT       	(*((volatile unsigned char *) (I2C0_BASE + 0x04)))
#define I2C0_DAT        	(*((volatile unsigned char *) (I2C0_BASE + 0x08)))
#define I2C0_ADR        	(*((volatile unsigned char *) (I2C0_BASE + 0x0C)))
#define I2C0_SCLH       	(*((volatile unsigned short*) (I2C0_BASE + 0x10)))
#define I2C0_SCLL       	(*((volatile unsigned short*) (I2C0_BASE + 0x14)))
#define I2C0_CONCLR     	(*((volatile unsigned char *) (I2C0_BASE + 0x18)))


/*
** SPI Serial Peripheral Interface
*/

#define SPI_BASE 0xE0020000

#define SPI_CR	         	(*((volatile unsigned short*) (SPI_BASE + 0x00)))
#define SPI_SR	         	(*((volatile unsigned char *) (SPI_BASE + 0x04)))
#define SPI_DR	         	(*((volatile unsigned short*) (SPI_BASE + 0x08)))
#define SPI_CCR	        	(*((volatile unsigned char *) (SPI_BASE + 0x0C)))
#define SPI_INT	        	(*((volatile unsigned char *) (SPI_BASE + 0x1C)))

                               
/*
** RTC Real Time Clock
*/

#define RTC_BASE 0xE0024000

#define RTC_ILR            	(*((volatile unsigned char *) (RTC_BASE + 0x00)))
#define RTC_CTC            	(*((volatile unsigned short*) (RTC_BASE + 0x04)))
#define RTC_CCR            	(*((volatile unsigned char *) (RTC_BASE + 0x08)))
#define RTC_CIIR           	(*((volatile unsigned char *) (RTC_BASE + 0x0C)))
#define RTC_AMR            	(*((volatile unsigned char *) (RTC_BASE + 0x10)))
#define RTC_CTIME0         	(*((volatile unsigned int  *) (RTC_BASE + 0x14)))
#define RTC_CTIME1         	(*((volatile unsigned int  *) (RTC_BASE + 0x18)))
#define RTC_CTIME2         	(*((volatile unsigned int  *) (RTC_BASE + 0x1C)))
#define RTC_SEC            	(*((volatile unsigned char *) (RTC_BASE + 0x20)))
#define RTC_MIN            	(*((volatile unsigned char *) (RTC_BASE + 0x24)))
#define RTC_HOUR           	(*((volatile unsigned char *) (RTC_BASE + 0x28)))
#define RTC_DOM            	(*((volatile unsigned char *) (RTC_BASE + 0x2C)))
#define RTC_DOW            	(*((volatile unsigned char *) (RTC_BASE + 0x30)))
#define RTC_DOY            	(*((volatile unsigned short*) (RTC_BASE + 0x34)))
#define RTC_MONTH          	(*((volatile unsigned char *) (RTC_BASE + 0x38)))
#define RTC_YEAR           	(*((volatile unsigned short*) (RTC_BASE + 0x3C)))
#define RTC_ALSEC          	(*((volatile unsigned char *) (RTC_BASE + 0x60)))
#define RTC_ALMIN          	(*((volatile unsigned char *) (RTC_BASE + 0x64)))
#define RTC_ALHOUR         	(*((volatile unsigned char *) (RTC_BASE + 0x68)))
#define RTC_ALDOM          	(*((volatile unsigned char *) (RTC_BASE + 0x6C)))
#define RTC_ALDOW          	(*((volatile unsigned char *) (RTC_BASE + 0x70)))
#define RTC_ALDOY          	(*((volatile unsigned short*) (RTC_BASE + 0x74)))
#define RTC_ALMON          	(*((volatile unsigned char *) (RTC_BASE + 0x78)))
#define RTC_ALYEAR         	(*((volatile unsigned short*) (RTC_BASE + 0x7C)))
#define RTC_PREINT         	(*((volatile unsigned short*) (RTC_BASE + 0x80)))
#define RTC_PREFRAC        	(*((volatile unsigned short*) (RTC_BASE + 0x84)))


/*
** GPIO General Purpose Input/Output
*/

#define GPIO_BASE 0xE0028000
#define FGPIO_BASE 0x3FFFC000

/* Input/Output registers PORT 0 */
#define GPIO0_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x00)))
#define GPIO0_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x04)))
#define GPIO0_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x08)))
#define GPIO0_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x0C)))

/* Input/Output registers PORT 1 */
#define GPIO1_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x10)))
#define GPIO1_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x14)))
#define GPIO1_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x18)))
#define GPIO1_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x1C)))

/* Fast Input/Output PORT 0 */
#define FGPIO0_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x00)))
#define FGPIO0_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x10)))
#define FGPIO0_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x14)))
#define FGPIO0_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x18)))
#define FGPIO0_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x1C)))

/* Fast Input/Output PORT 1 */
#define FGPIO1_DIR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x20)))
#define FGPIO1_MASK        	(*((volatile unsigned int  *) (FGPIO_BASE + 0x30)))
#define FGPIO1_PIN         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x34)))
#define FGPIO1_SET         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x38)))
#define FGPIO1_CLR         	(*((volatile unsigned int  *) (FGPIO_BASE + 0x3C)))


/*
** PCB Pin Connect Block
*/

#define PCB_BASE 0xE002C000

#define PCB_PINSEL0        	(*((volatile unsigned int  *) (PCB_BASE + 0x00)))
#define PCB_PINSEL1        	(*((volatile unsigned int  *) (PCB_BASE + 0x04)))
#define PCB_PINSEL2        	(*((volatile unsigned int  *) (PCB_BASE + 0x14)))


/*
** ADC Analog/Digital Converter
*/

#define ADC_BASE 0xE0034000

#define ADC_CR           	(*((volatile unsigned int  *) (ADC_BASE + 0x00)))
#define ADC_GDR          	(*((volatile unsigned int  *) (ADC_BASE + 0x04)))
#define ADC_INTEN        	(*((volatile unsigned int  *) (ADC_BASE + 0x0C)))
#define ADC_DR0          	(*((volatile unsigned int  *) (ADC_BASE + 0x10)))
#define ADC_DR1          	(*((volatile unsigned int  *) (ADC_BASE + 0x14)))
#define ADC_DR2          	(*((volatile unsigned int  *) (ADC_BASE + 0x18)))
#define ADC_DR3          	(*((volatile unsigned int  *) (ADC_BASE + 0x1C)))
#define ADC_DR4          	(*((volatile unsigned int  *) (ADC_BASE + 0x20)))
#define ADC_DR5          	(*((volatile unsigned int  *) (ADC_BASE + 0x24)))
#define ADC_DR6          	(*((volatile unsigned int  *) (ADC_BASE + 0x28)))
#define ADC_DR7          	(*((volatile unsigned int  *) (ADC_BASE + 0x2C)))
#define ADC_STAT         	(*((volatile unsigned int  *) (ADC_BASE + 0x30)))


/*
** ADC0 Analog/Digital Converter 0
*/

#if !defined(_LPC2141_H) && !defined(_LPC2142_H)

#define ADC0_BASE (ADC_BASE)

#define ADC0_CR           	(ADC_CR)
#define ADC0_GDR          	(ADC_GDR)
#define ADC0_INTEN        	(ADC_INTEN)
#define ADC0_DR0          	(ADC_DR0)
#define ADC0_DR1          	(ADC_DR1)
#define ADC0_DR2          	(ADC_DR2)
#define ADC0_DR3          	(ADC_DR3)
#define ADC0_DR4          	(ADC_DR4)
#define ADC0_DR5          	(ADC_DR5)
#define ADC0_DR6          	(ADC_DR6)
#define ADC0_DR7          	(ADC_DR7)
#define ADC0_STAT         	(ADC_STAT)


/*
** ADC0/ADC1 Analog/Digital Converters
*/

#define ADC_GSR          	(*((volatile unsigned int  *) (ADC0_BASE + 0x08)))
#define ADC0_GSR           	(ADC_GSR)
#define ADC1_GSR           	(ADC_GSR)
                                
#endif /* !defined(_LPC2141_H) && !defined(_LPC2142_H) */


/*
** I2C1 Inter-Integrated Circuit interface 1
*/

#define I2C1_BASE 0xE005C000

#define I2C1_CONSET     	(*((volatile unsigned char *) (I2C1_BASE + 0x00)))
#define I2C1_STAT       	(*((volatile unsigned char *) (I2C1_BASE + 0x04)))
#define I2C1_DAT        	(*((volatile unsigned char *) (I2C1_BASE + 0x08)))
#define I2C1_ADR        	(*((volatile unsigned char *) (I2C1_BASE + 0x0C)))
#define I2C1_SCLH       	(*((volatile unsigned short*) (I2C1_BASE + 0x10)))
#define I2C1_SCLL       	(*((volatile unsigned short*) (I2C1_BASE + 0x14)))
#define I2C1_CONCLR     	(*((volatile unsigned char *) (I2C1_BASE + 0x18)))


/*
** ADC1 Analog/Digital Converter 1
*/

#if !defined(_LPC2141_H) && !defined(_LPC2142_H)

#define ADC1_BASE 0xE0060000

#define ADC1_CR           	(*((volatile unsigned int  *) (ADC1_BASE + 0x00)))
#define ADC1_GDR          	(*((volatile unsigned int  *) (ADC1_BASE + 0x04)))
#define ADC1_INTEN        	(*((volatile unsigned int  *) (ADC1_BASE + 0x0C)))
#define ADC1_DR0          	(*((volatile unsigned int  *) (ADC1_BASE + 0x10)))
#define ADC1_DR1          	(*((volatile unsigned int  *) (ADC1_BASE + 0x14)))
#define ADC1_DR2          	(*((volatile unsigned int  *) (ADC1_BASE + 0x18)))
#define ADC1_DR3          	(*((volatile unsigned int  *) (ADC1_BASE + 0x1C)))
#define ADC1_DR4          	(*((volatile unsigned int  *) (ADC1_BASE + 0x20)))
#define ADC1_DR5          	(*((volatile unsigned int  *) (ADC1_BASE + 0x24)))
#define ADC1_DR6          	(*((volatile unsigned int  *) (ADC1_BASE + 0x28)))
#define ADC1_DR7          	(*((volatile unsigned int  *) (ADC1_BASE + 0x2C)))
#define ADC1_STAT         	(*((volatile unsigned int  *) (ADC1_BASE + 0x30)))

#endif /* !defined(_LPC2141_H) && !defined(_LPC2142_H) */

                                
/*
** SSP Synchronous Serial Port controller
*/

#define SSP_BASE 0xE0068000

#define SSP_CR0         	(*((volatile unsigned short*) (SSP_BASE + 0x00)))
#define SSP_CR1         	(*((volatile unsigned char *) (SSP_BASE + 0x04)))
#define SSP_DR          	(*((volatile unsigned short*) (SSP_BASE + 0x08)))
#define SSP_SR          	(*((volatile unsigned char *) (SSP_BASE + 0x0C)))
#define SSP_CPSR        	(*((volatile unsigned char *) (SSP_BASE + 0x10)))
#define SSP_IMSC        	(*((volatile unsigned char *) (SSP_BASE + 0x14)))
#define SSP_RIS         	(*((volatile unsigned char *) (SSP_BASE + 0x18)))
#define SSP_MIS         	(*((volatile unsigned char *) (SSP_BASE + 0x1C)))
#define SSP_ICR         	(*((volatile unsigned char *) (SSP_BASE + 0x20)))


/*
** Digital/Analog Converter
*/

#if !defined(_LPC2141_H)

#define DAC_BASE 0xE006C000

#define DAC_R                   (*((volatile unsigned int  *)(DAC_BASE)))

#endif /* !defined(_LPC2141_H) */


/*
** USB Controller
*/

/* Interrupt status register */
#define USBIntSt        	(*((volatile unsigned int  *) 0xE01FC1C0))

#define USB_BASE 0xE0090000

/* Device interrupt registers */
#define USBDevIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0x00)))
#define USBDevIntEn     	(*((volatile unsigned int  *) (USB_BASE + 0x04)))
#define USBDevIntClr    	(*((volatile unsigned int  *) (USB_BASE + 0x08)))
#define USBDevIntSet    	(*((volatile unsigned int  *) (USB_BASE + 0x0C)))
#define USBDevIntPri    	(*((volatile unsigned char *) (USB_BASE + 0x2C)))

/* Endpoint interrupt registers */
#define USBEpIntSt      	(*((volatile unsigned int  *) (USB_BASE + 0x30)))
#define USBEpIntEn      	(*((volatile unsigned int  *) (USB_BASE + 0x34)))
#define USBEpIntClr     	(*((volatile unsigned int  *) (USB_BASE + 0x38)))
#define USBEpIntSet     	(*((volatile unsigned int  *) (USB_BASE + 0x3C)))
#define USBEpIntPri     	(*((volatile unsigned int  *) (USB_BASE + 0x40)))

/* Endpoint realization registers */
#define USBReEp         	(*((volatile unsigned int  *) (USB_BASE + 0x44)))
#define USBEpInd        	(*((volatile unsigned int  *) (USB_BASE + 0x48)))
#define USBMaxPSize     	(*((volatile unsigned int  *) (USB_BASE + 0x4C)))

/* USB transfer registers */
#define USBRxData       	(*((volatile unsigned int  *) (USB_BASE + 0x18)))
#define USBRxPLen       	(*((volatile unsigned int  *) (USB_BASE + 0x20)))
#define USBTxData       	(*((volatile unsigned int  *) (USB_BASE + 0x1C)))
#define USBTxPLen       	(*((volatile unsigned int  *) (USB_BASE + 0x24)))
#define USBCtrl         	(*((volatile unsigned int  *) (USB_BASE + 0x28)))

/* Command registers */
#define USBCmdCode      	(*((volatile unsigned int  *) (USB_BASE + 0x10)))
#define USBCmdData      	(*((volatile unsigned int  *) (USB_BASE + 0x14)))

#if !defined(_LPC2141_H) && !defined(_LPC2142_H) && !defined(_LPC2144_H)

/* DMA Registers */
#define USBDMARSt       	(*((volatile unsigned int  *) (USB_BASE + 0x50)))
#define USBDMARClr      	(*((volatile unsigned int  *) (USB_BASE + 0x54)))
#define USBDMARSet      	(*((volatile unsigned int  *) (USB_BASE + 0x58)))
#define USBUDCAH        	(*((volatile unsigned int  *) (USB_BASE + 0x80)))
#define USBEpDMASt      	(*((volatile unsigned int  *) (USB_BASE + 0x84)))
#define USBEpDMAEn      	(*((volatile unsigned int  *) (USB_BASE + 0x88)))
#define USBEpDMADis     	(*((volatile unsigned int  *) (USB_BASE + 0x8C)))
#define USBDMAIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0x90)))
#define USBDMAIntEn     	(*((volatile unsigned int  *) (USB_BASE + 0x94)))
#define USBEoTIntSt     	(*((volatile unsigned int  *) (USB_BASE + 0xA0)))
#define USBEoTIntClr    	(*((volatile unsigned int  *) (USB_BASE + 0xA4)))
#define USBEoTIntSet    	(*((volatile unsigned int  *) (USB_BASE + 0xA8)))
#define USBNDDRIntSt    	(*((volatile unsigned int  *) (USB_BASE + 0xAC)))
#define USBNDDRIntClr   	(*((volatile unsigned int  *) (USB_BASE + 0xB0)))
#define USBNDDRIntSet   	(*((volatile unsigned int  *) (USB_BASE + 0xB4)))
#define USBSysErrIntSt  	(*((volatile unsigned int  *) (USB_BASE + 0xB8)))
#define USBSysErrIntClr 	(*((volatile unsigned int  *) (USB_BASE + 0xBC)))
#define USBSysErrIntSet 	(*((volatile unsigned int  *) (USB_BASE + 0xC0)))

#endif /* !defined(_LPC2141_H) && !defined(_LPC2142_H) && !defined(_LPC2144_H) */

/*
** SCB System Control Block
*/

#define SCB_BASE 0xE01FC000

/* MAM Memory Accelerator Module */
#define SCB_MAMCR		(*((volatile unsigned char *) (SCB_BASE + 0x000)))
#define SCB_MAMTIM		(*((volatile unsigned char *) (SCB_BASE + 0x004)))

/* Memory Mapping control */
#define SCB_MEMMAP		(*((volatile unsigned char *) (SCB_BASE + 0x040)))

/* PLL Phase Locked Loop */
#define SCB_PLLCON		(*((volatile unsigned char *) (SCB_BASE + 0x080)))
#define SCB_PLLCFG		(*((volatile unsigned char *) (SCB_BASE + 0x084)))
#define SCB_PLLSTAT		(*((volatile unsigned short*) (SCB_BASE + 0x088)))
#define SCB_PLLFEED		(*((volatile unsigned char *) (SCB_BASE + 0x08C)))

/* PLL0 Phase Locked Loop */
#define SCB_PLL0CON		(SCB_PLLCON)
#define SCB_PLL0CFG		(SCB_PLLCFG)
#define SCB_PLL0STAT		(SCB_PLLSTAT)
#define SCB_PLL0FEED		(SCB_PLLFEED)

/* PLL1 Phase Locked Loop */
#define SCB_PLL1CON		(*((volatile unsigned char *) (SCB_BASE + 0x0A0)))
#define SCB_PLL1CFG		(*((volatile unsigned char *) (SCB_BASE + 0x0A4)))
#define SCB_PLL1STAT		(*((volatile unsigned short*) (SCB_BASE + 0x0A8)))
#define SCB_PLL1FEED		(*((volatile unsigned char *) (SCB_BASE + 0x0AC)))

/* PC Power Control */
#define SCB_PCON		(*((volatile unsigned char *) (SCB_BASE + 0x0C0)))
#define SCB_PCONP		(*((volatile unsigned int  *) (SCB_BASE + 0x0C4)))

/* VPB Divider */
#define SCB_VPBDIV		(*((volatile unsigned char *) (SCB_BASE + 0x100)))

/* External Interrupts */
#define SCB_EXTINT         	(*((volatile unsigned char *) (SCB_BASE + 0x140)))
#define SCB_INTWAKE		(*((volatile unsigned short*) (SCB_BASE + 0x144)))
#define SCB_EXTMODE		(*((volatile unsigned char *) (SCB_BASE + 0x148)))
#define SCB_EXTPOLAR		(*((volatile unsigned char *) (SCB_BASE + 0x14C)))

/* Reset Source Identification Register */
#define SCB_RSIR       		(*((volatile unsigned char *) (SCB_BASE + 0x180)))

/* Code Security Protection Register */
#define SCB_CSPR       		(*((volatile unsigned int  *) (SCB_BASE + 0x184)))

/* System Control and Status flags register */
#define SCB_SCS       		(*((volatile unsigned int  *) (SCB_BASE + 0x1A0)))
                                

/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VICIRQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x000)))
#define VICFIQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x004)))
#define VICRawIntr     		(*((volatile unsigned int  *) (VIC_BASE + 0x008)))
#define VICIntSelect   		(*((volatile unsigned int  *) (VIC_BASE + 0x00C)))
#define VICIntEnable   		(*((volatile unsigned int  *) (VIC_BASE + 0x010)))
#define VICIntEnClr    		(*((volatile unsigned int  *) (VIC_BASE + 0x014)))
#define VICSoftInt     		(*((volatile unsigned int  *) (VIC_BASE + 0x018)))
#define VICSoftIntClear  	(*((volatile unsigned int  *) (VIC_BASE + 0x01C)))
#define VICProtection  		(*((volatile unsigned int  *) (VIC_BASE + 0x020)))
#define VICVectAddr    		(*((volatile unsigned int  *) (VIC_BASE + 0x030)))
#define VICDefVectAddr 		(*((volatile unsigned int  *) (VIC_BASE + 0x034)))

#define VICVectAddr0   		(*((volatile unsigned int  *) (VIC_BASE + 0x100)))
#define VICVectAddr1   		(*((volatile unsigned int  *) (VIC_BASE + 0x104)))
#define VICVectAddr2   		(*((volatile unsigned int  *) (VIC_BASE + 0x108)))
#define VICVectAddr3   		(*((volatile unsigned int  *) (VIC_BASE + 0x10C)))
#define VICVectAddr4   		(*((volatile unsigned int  *) (VIC_BASE + 0x110)))
#define VICVectAddr5   		(*((volatile unsigned int  *) (VIC_BASE + 0x114)))
#define VICVectAddr6   		(*((volatile unsigned int  *) (VIC_BASE + 0x118)))
#define VICVectAddr7   		(*((volatile unsigned int  *) (VIC_BASE + 0x11C)))
#define VICVectAddr8   		(*((volatile unsigned int  *) (VIC_BASE + 0x120)))
#define VICVectAddr9   		(*((volatile unsigned int  *) (VIC_BASE + 0x124)))
#define VICVectAddr10  		(*((volatile unsigned int  *) (VIC_BASE + 0x128)))
#define VICVectAddr11  		(*((volatile unsigned int  *) (VIC_BASE + 0x12C)))
#define VICVectAddr12  		(*((volatile unsigned int  *) (VIC_BASE + 0x130)))
#define VICVectAddr13  		(*((volatile unsigned int  *) (VIC_BASE + 0x134)))
#define VICVectAddr14  		(*((volatile unsigned int  *) (VIC_BASE + 0x138)))
#define VICVectAddr15  		(*((volatile unsigned int  *) (VIC_BASE + 0x13C)))

#define VICVectCntl0   		(*((volatile unsigned int  *) (VIC_BASE + 0x200)))
#define VICVectCntl1   		(*((volatile unsigned int  *) (VIC_BASE + 0x204)))
#define VICVectCntl2   		(*((volatile unsigned int  *) (VIC_BASE + 0x208)))
#define VICVectCntl3   		(*((volatile unsigned int  *) (VIC_BASE + 0x20C)))
#define VICVectCntl4   		(*((volatile unsigned int  *) (VIC_BASE + 0x210)))
#define VICVectCntl5   		(*((volatile unsigned int  *) (VIC_BASE + 0x214)))
#define VICVectCntl6   		(*((volatile unsigned int  *) (VIC_BASE + 0x218)))
#define VICVectCntl7   		(*((volatile unsigned int  *) (VIC_BASE + 0x21C)))
#define VICVectCntl8   		(*((volatile unsigned int  *) (VIC_BASE + 0x220)))
#define VICVectCntl9   		(*((volatile unsigned int  *) (VIC_BASE + 0x224)))
#define VICVectCntl10  		(*((volatile unsigned int  *) (VIC_BASE + 0x228)))
#define VICVectCntl11  		(*((volatile unsigned int  *) (VIC_BASE + 0x22C)))
#define VICVectCntl12  		(*((volatile unsigned int  *) (VIC_BASE + 0x230)))
#define VICVectCntl13  		(*((volatile unsigned int  *) (VIC_BASE + 0x234)))
#define VICVectCntl14  		(*((volatile unsigned int  *) (VIC_BASE + 0x238)))
#define VICVectCntl15  		(*((volatile unsigned int  *) (VIC_BASE + 0x23C)))


#endif  // _LPC214x_H
