/**************************************************************************
**                                                                        *
**  FILE        :  lpc210x.h                                              *
**                                                                        *
**  DESCRIPTION :  Processor register mappings for NXP (Philips)          *
**                 LPC2104, LPC2105 & LPC2106                             *
**                                                                        *
**  Copyright 2006-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#ifndef _LPC210X_H
#define _LPC210X_H


/*
** WD Watchdog
*/

#define WD_BASE 0xE0000000

#define WD_MOD            	(*((volatile unsigned char *) (WD_BASE + 0x00)))
#define WD_TC             	(*((volatile unsigned int  *) (WD_BASE + 0x04)))
#define WD_FEED             	(*((volatile unsigned char *) (WD_BASE + 0x08)))
#define WD_TV           	(*((volatile unsigned int  *) (WD_BASE + 0x0C)))


/*
** TIMER0 Timer 0
*/

#define TIMER0_BASE 0xE0004000

#define TIMER0_IR           	(*((volatile unsigned char *) (TIMER0_BASE + 0x00)))
#define TIMER0_TCR          	(*((volatile unsigned char *) (TIMER0_BASE + 0x04)))
#define TIMER0_TC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x08)))
#define TIMER0_PR           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x0C)))
#define TIMER0_PC           	(*((volatile unsigned int  *) (TIMER0_BASE + 0x10)))
#define TIMER0_MCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x14)))
#define TIMER0_MR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x18)))
#define TIMER0_MR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x1C)))
#define TIMER0_MR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x20)))
#define TIMER0_MR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x24)))
#define TIMER0_CCR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x28)))
#define TIMER0_CR0          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x2C)))
#define TIMER0_CR1          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x30)))
#define TIMER0_CR2          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x34)))
#define TIMER0_CR3          	(*((volatile unsigned int  *) (TIMER0_BASE + 0x38)))
#define TIMER0_EMR          	(*((volatile unsigned short*) (TIMER0_BASE + 0x3C)))


/*
** TIMER1 Timer 1
*/

#define TIMER1_BASE 0xE0008000

#define TIMER1_IR           	(*((volatile unsigned char *) (TIMER1_BASE + 0x00)))
#define TIMER1_TCR          	(*((volatile unsigned char *) (TIMER1_BASE + 0x04)))
#define TIMER1_TC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x08)))
#define TIMER1_PR           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x0C)))
#define TIMER1_PC           	(*((volatile unsigned int  *) (TIMER1_BASE + 0x10)))
#define TIMER1_MCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x14)))
#define TIMER1_MR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x18)))
#define TIMER1_MR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x1C)))
#define TIMER1_MR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x20)))
#define TIMER1_MR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x24)))
#define TIMER1_CCR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x28)))
#define TIMER1_CR0          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x2C)))
#define TIMER1_CR1          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x30)))
#define TIMER1_CR2          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x34)))
#define TIMER1_CR3          	(*((volatile unsigned int  *) (TIMER1_BASE + 0x38)))
#define TIMER1_EMR          	(*((volatile unsigned short*) (TIMER1_BASE + 0x3C)))


/*
** UART0 Universal Asynchronous Receiver Transmitter 0
*/

#define UART0_BASE 0xE000C000

#define UART0_RBR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_THR		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_DLL		(*((volatile unsigned char *) (UART0_BASE + 0x00)))
#define UART0_IER		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_DLM		(*((volatile unsigned char *) (UART0_BASE + 0x04)))
#define UART0_IIR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_FCR		(*((volatile unsigned char *) (UART0_BASE + 0x08)))
#define UART0_LCR		(*((volatile unsigned char *) (UART0_BASE + 0x0C)))
#define UART0_LSR		(*((volatile unsigned char *) (UART0_BASE + 0x14)))
#define UART0_SCR		(*((volatile unsigned char *) (UART0_BASE + 0x1C)))


/*
** UART1 Universal Asynchronous Receiver Transmitter 1
*/

#define UART1_BASE 0xE0010000

#define UART1_RBR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_THR		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_DLL		(*((volatile unsigned char *) (UART1_BASE + 0x00)))
#define UART1_IER		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_DLM		(*((volatile unsigned char *) (UART1_BASE + 0x04)))
#define UART1_IIR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_FCR		(*((volatile unsigned char *) (UART1_BASE + 0x08)))
#define UART1_LCR		(*((volatile unsigned char *) (UART1_BASE + 0x0C)))
#define UART1_MCR		(*((volatile unsigned char *) (UART1_BASE + 0x10)))
#define UART1_LSR		(*((volatile unsigned char *) (UART1_BASE + 0x14)))
#define UART1_MSR		(*((volatile unsigned char *) (UART1_BASE + 0x18)))
#define UART1_SCR		(*((volatile unsigned char *) (UART1_BASE + 0x1C)))


/*
** PWM Pulse Width Modulator
*/

#define PWM_BASE 0xE0014000

#define PWM_IR          	(*((volatile unsigned int  *) (PWM_BASE + 0x00)))
#define PWM_TCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x04)))
#define PWM_TC          	(*((volatile unsigned int  *) (PWM_BASE + 0x08)))
#define PWM_PR          	(*((volatile unsigned int  *) (PWM_BASE + 0x0C)))
#define PWM_PC          	(*((volatile unsigned int  *) (PWM_BASE + 0x10)))
#define PWM_MCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x14)))
#define PWM_MR0         	(*((volatile unsigned int  *) (PWM_BASE + 0x18)))
#define PWM_MR1         	(*((volatile unsigned int  *) (PWM_BASE + 0x1C)))
#define PWM_MR2         	(*((volatile unsigned int  *) (PWM_BASE + 0x20)))
#define PWM_MR3         	(*((volatile unsigned int  *) (PWM_BASE + 0x24)))
#define PWM_MR4         	(*((volatile unsigned int  *) (PWM_BASE + 0x40)))
#define PWM_MR5         	(*((volatile unsigned int  *) (PWM_BASE + 0x44)))
#define PWM_MR6         	(*((volatile unsigned int  *) (PWM_BASE + 0x48)))
#define PWM_PCR         	(*((volatile unsigned int  *) (PWM_BASE + 0x4C)))
#define PWM_LER         	(*((volatile unsigned int  *) (PWM_BASE + 0x50)))


/*
** I2C Inter-Integrated Circuit interface
*/

#define I2C_BASE 0xE001C000

#define I2C_CONSET     		(*((volatile unsigned char *) (I2C_BASE + 0x00)))
#define I2C_STAT       		(*((volatile unsigned char *) (I2C_BASE + 0x04)))
#define I2C_DAT        		(*((volatile unsigned char *) (I2C_BASE + 0x08)))
#define I2C_ADR        		(*((volatile unsigned char *) (I2C_BASE + 0x0C)))
#define I2C_SCLH       		(*((volatile unsigned short*) (I2C_BASE + 0x10)))
#define I2C_SCLL       		(*((volatile unsigned short*) (I2C_BASE + 0x14)))
#define I2C_CONCLR     		(*((volatile unsigned char *) (I2C_BASE + 0x18)))


/*
** SPI Serial Peripheral Interface
*/

#define SPI_BASE 0xE0020000

#define SPI_CR	         	(*((volatile unsigned char *) (SPI_BASE + 0x00)))
#define SPI_SR 	        	(*((volatile unsigned char *) (SPI_BASE + 0x04)))
#define SPI_DR	         	(*((volatile unsigned char *) (SPI_BASE + 0x08)))
#define SPI_CCR	        	(*((volatile unsigned char *) (SPI_BASE + 0x0C)))
#define SPI_INT	        	(*((volatile unsigned char *) (SPI_BASE + 0x1C)))


/*
** RTC Real Time Clock
*/

#define RTC_BASE 0xE0024000

#define RTC_ILR            	(*((volatile unsigned char *) (RTC_BASE + 0x00)))
#define RTC_CTC            	(*((volatile unsigned short*) (RTC_BASE + 0x04)))
#define RTC_CCR            	(*((volatile unsigned char *) (RTC_BASE + 0x08)))
#define RTC_CIIR           	(*((volatile unsigned char *) (RTC_BASE + 0x0C)))
#define RTC_AMR            	(*((volatile unsigned char *) (RTC_BASE + 0x10)))
#define RTC_CTIME0         	(*((volatile unsigned int  *) (RTC_BASE + 0x14)))
#define RTC_CTIME1         	(*((volatile unsigned int  *) (RTC_BASE + 0x18)))
#define RTC_CTIME2         	(*((volatile unsigned int  *) (RTC_BASE + 0x1C)))
#define RTC_SEC            	(*((volatile unsigned char *) (RTC_BASE + 0x20)))
#define RTC_MIN            	(*((volatile unsigned char *) (RTC_BASE + 0x24)))
#define RTC_HOUR           	(*((volatile unsigned char *) (RTC_BASE + 0x28)))
#define RTC_DOM            	(*((volatile unsigned char *) (RTC_BASE + 0x2C)))
#define RTC_DOW            	(*((volatile unsigned char *) (RTC_BASE + 0x30)))
#define RTC_DOY            	(*((volatile unsigned short*) (RTC_BASE + 0x34)))
#define RTC_MONTH          	(*((volatile unsigned char *) (RTC_BASE + 0x38)))
#define RTC_YEAR           	(*((volatile unsigned short*) (RTC_BASE + 0x3C)))
#define RTC_ALSEC          	(*((volatile unsigned char *) (RTC_BASE + 0x60)))
#define RTC_ALMIN          	(*((volatile unsigned char *) (RTC_BASE + 0x64)))
#define RTC_ALHOUR         	(*((volatile unsigned char *) (RTC_BASE + 0x68)))
#define RTC_ALDOM          	(*((volatile unsigned char *) (RTC_BASE + 0x6C)))
#define RTC_ALDOW          	(*((volatile unsigned char *) (RTC_BASE + 0x70)))
#define RTC_ALDOY          	(*((volatile unsigned short*) (RTC_BASE + 0x74)))
#define RTC_ALMON          	(*((volatile unsigned char *) (RTC_BASE + 0x78)))
#define RTC_ALYEAR         	(*((volatile unsigned short*) (RTC_BASE + 0x7C)))
#define RTC_PREINT         	(*((volatile unsigned short*) (RTC_BASE + 0x80)))
#define RTC_PREFRAC        	(*((volatile unsigned short*) (RTC_BASE + 0x84)))


/*
** GPIO General Purpose Input/Output
*/

#define GPIO_BASE 0xE0028000

#define GPIO_PIN          	(*((volatile unsigned int  *) (GPIO_BASE + 0x00)))
#define GPIO_SET          	(*((volatile unsigned int  *) (GPIO_BASE + 0x04)))
#define GPIO_DIR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x08)))
#define GPIO_CLR          	(*((volatile unsigned int  *) (GPIO_BASE + 0x0C)))


/*
** PCB Pin Connect Block
*/

#define PCB_BASE 0xE002C000

#define PCB_PINSEL0        	(*((volatile unsigned int  *) (PCB_BASE + 0x00)))
#define PCB_PINSEL1        	(*((volatile unsigned int  *) (PCB_BASE + 0x04)))


/*
** SCB System Control Block
*/

#define SCB_BASE 0xE01FC000

/* MAM Memory Accelerator Module */
#define SCB_MAMCR		(*((volatile unsigned char *) (SCB_BASE + 0x000)))
#define SCB_MAMTIM		(*((volatile unsigned char *) (SCB_BASE + 0x004)))

/* Memory Mapping control */
#define SCB_MEMMAP		(*((volatile unsigned char *) (SCB_BASE + 0x040)))

/* PLL Phase Locked Loop */
#define SCB_PLLCON		(*((volatile unsigned char *) (SCB_BASE + 0x080)))
#define SCB_PLLCFG		(*((volatile unsigned char *) (SCB_BASE + 0x084)))
#define SCB_PLLSTAT		(*((volatile unsigned short*) (SCB_BASE + 0x088)))
#define SCB_PLLFEED		(*((volatile unsigned char *) (SCB_BASE + 0x08C)))

/* PC Power Control */
#define SCB_PCON		(*((volatile unsigned char *) (SCB_BASE + 0x0C0)))
#define SCB_PCONP		(*((volatile unsigned int  *) (SCB_BASE + 0x0C4)))

/* VPB Divider */
#define SCB_VPBDIV		(*((volatile unsigned char *) (SCB_BASE + 0x100)))

/* External Interrupts */
#define SCB_EXTINT         	(*((volatile unsigned char *) (SCB_BASE + 0x140)))
#define SCB_EXTWAKE		(*((volatile unsigned char *) (SCB_BASE + 0x144)))


/*
** VIC Vectored Interrupt Controller
*/

#define VIC_BASE 0xFFFFF000

#define VICIRQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x000)))
#define VICFIQStatus   		(*((volatile unsigned int  *) (VIC_BASE + 0x004)))
#define VICRawIntr     		(*((volatile unsigned int  *) (VIC_BASE + 0x008)))
#define VICIntSelect   		(*((volatile unsigned int  *) (VIC_BASE + 0x00C)))
#define VICIntEnable   		(*((volatile unsigned int  *) (VIC_BASE + 0x010)))
#define VICIntEnClr    		(*((volatile unsigned int  *) (VIC_BASE + 0x014)))
#define VICSoftInt     		(*((volatile unsigned int  *) (VIC_BASE + 0x018)))
#define VICSoftIntClear  	(*((volatile unsigned int  *) (VIC_BASE + 0x01C)))
#define VICProtection  		(*((volatile unsigned int  *) (VIC_BASE + 0x020)))
#define VICVectAddr    		(*((volatile unsigned int  *) (VIC_BASE + 0x030)))
#define VICDefVectAddr 		(*((volatile unsigned int  *) (VIC_BASE + 0x034)))

#define VICVectAddr0   		(*((volatile unsigned int  *) (VIC_BASE + 0x100)))
#define VICVectAddr1   		(*((volatile unsigned int  *) (VIC_BASE + 0x104)))
#define VICVectAddr2   		(*((volatile unsigned int  *) (VIC_BASE + 0x108)))
#define VICVectAddr3   		(*((volatile unsigned int  *) (VIC_BASE + 0x10C)))
#define VICVectAddr4   		(*((volatile unsigned int  *) (VIC_BASE + 0x110)))
#define VICVectAddr5   		(*((volatile unsigned int  *) (VIC_BASE + 0x114)))
#define VICVectAddr6   		(*((volatile unsigned int  *) (VIC_BASE + 0x118)))
#define VICVectAddr7   		(*((volatile unsigned int  *) (VIC_BASE + 0x11C)))
#define VICVectAddr8   		(*((volatile unsigned int  *) (VIC_BASE + 0x120)))
#define VICVectAddr9   		(*((volatile unsigned int  *) (VIC_BASE + 0x124)))
#define VICVectAddr10  		(*((volatile unsigned int  *) (VIC_BASE + 0x128)))
#define VICVectAddr11  		(*((volatile unsigned int  *) (VIC_BASE + 0x12C)))
#define VICVectAddr12  		(*((volatile unsigned int  *) (VIC_BASE + 0x130)))
#define VICVectAddr13  		(*((volatile unsigned int  *) (VIC_BASE + 0x134)))
#define VICVectAddr14  		(*((volatile unsigned int  *) (VIC_BASE + 0x138)))
#define VICVectAddr15  		(*((volatile unsigned int  *) (VIC_BASE + 0x13C)))

#define VICVectCntl0   		(*((volatile unsigned int  *) (VIC_BASE + 0x200)))
#define VICVectCntl1   		(*((volatile unsigned int  *) (VIC_BASE + 0x204)))
#define VICVectCntl2   		(*((volatile unsigned int  *) (VIC_BASE + 0x208)))
#define VICVectCntl3   		(*((volatile unsigned int  *) (VIC_BASE + 0x20C)))
#define VICVectCntl4   		(*((volatile unsigned int  *) (VIC_BASE + 0x210)))
#define VICVectCntl5   		(*((volatile unsigned int  *) (VIC_BASE + 0x214)))
#define VICVectCntl6   		(*((volatile unsigned int  *) (VIC_BASE + 0x218)))
#define VICVectCntl7   		(*((volatile unsigned int  *) (VIC_BASE + 0x21C)))
#define VICVectCntl8   		(*((volatile unsigned int  *) (VIC_BASE + 0x220)))
#define VICVectCntl9   		(*((volatile unsigned int  *) (VIC_BASE + 0x224)))
#define VICVectCntl10  		(*((volatile unsigned int  *) (VIC_BASE + 0x228)))
#define VICVectCntl11  		(*((volatile unsigned int  *) (VIC_BASE + 0x22C)))
#define VICVectCntl12  		(*((volatile unsigned int  *) (VIC_BASE + 0x230)))
#define VICVectCntl13  		(*((volatile unsigned int  *) (VIC_BASE + 0x234)))
#define VICVectCntl14  		(*((volatile unsigned int  *) (VIC_BASE + 0x238)))
#define VICVectCntl15  		(*((volatile unsigned int  *) (VIC_BASE + 0x23C)))


#endif   /* _LPC210X_H */
